/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintStream;

class ErrorHighPoint
extends ErrorHighlight {
    private final EPoint point;

    ErrorHighPoint(Cell c2, EPoint p) {
        super(c2, null);
        this.point = p;
    }

    ErrorHighPoint(CellId cellId, EPoint p) {
        super(cellId);
        this.point = p;
    }

    @Override
    public void addToHighlighter(Highlighter h2, EDatabase database) {
        double consize = 5.0;
        Cell cell = this.getCell(database);
        h2.addLine(new Point2D.Double(this.point.getX() - consize, this.point.getY() - consize), new Point2D.Double(this.point.getX() + consize, this.point.getY() + consize), cell);
        h2.addLine(new Point2D.Double(this.point.getX() - consize, this.point.getY() + consize), new Point2D.Double(this.point.getX() + consize, this.point.getY() - consize), cell);
    }

    public static void writeXmlHeader(String indent, PrintStream ps) {
        ps.println(indent + "<!ELEMENT ERRORTYPEPOINT ANY>");
        ps.println(indent + "<!ATTLIST ERRORTYPEPOINT");
        ps.println(indent + "   pt CDATA #REQUIRED");
        ps.println(indent + "   cellName CDATA #REQUIRED");
        ps.println(indent + ">");
    }

    @Override
    void writeXmlDescription(String tabs, PrintStream msg, EDatabase database) {
        msg.append(tabs + "<ERRORTYPEPOINT  ");
        msg.append("pt=\"(" + this.point.getX() + "," + this.point.getY() + ")\" ");
        msg.append("cellName=\"" + this.getCellName(database) + "\"");
        msg.append(" />\n");
    }

    @Override
    void write(IdWriter writer) throws IOException {
        this.writeTag(writer, (byte)4);
        writer.writePoint(this.point);
    }
}

