/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.IOException;
import java.io.PrintStream;

class ErrorHighArc
extends ErrorHighlight {
    private final int arcId;

    public ErrorHighArc(VarContext con, ArcInst ai) {
        super(ai.getParent(), con);
        this.arcId = ai.getArcId();
    }

    ErrorHighArc(CellId cellId, int arcId) {
        super(cellId);
        this.arcId = arcId;
    }

    @Override
    boolean containsObject(Cell c2, Object obj) {
        EDatabase database = c2.getDatabase();
        return this.getCell(database) == c2 && this.getObject(database) == obj;
    }

    @Override
    Object getObject(EDatabase database) {
        Cell cell = this.getCell(database);
        if (cell == null) {
            return null;
        }
        return cell.getArcById(this.arcId);
    }

    @Override
    void writeXmlDescription(String tabs, PrintStream msg, EDatabase database) {
        ArcInst ai = (ArcInst)this.getObject(database);
        msg.append(tabs + "<ERRORTYPEGEOM ");
        msg.append("geomName=\"" + String.valueOf(ai.getD().name) + "\" ");
        msg.append("cellName=\"" + ai.getParent().describe(false) + "\"");
        msg.append(" />\n");
    }

    @Override
    boolean isValid(EDatabase database) {
        return this.getObject(database) != null;
    }

    @Override
    public void addToHighlighter(Highlighter h2, EDatabase database) {
        ArcInst ai = (ArcInst)this.getObject(database);
        if (ai != null) {
            h2.addElectricObject((ElectricObject)ai, true, ai.getParent());
        }
    }

    @Override
    void write(IdWriter writer) throws IOException {
        this.writeTag(writer, (byte)6);
        writer.writeArcId(this.arcId);
    }
}

