/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BypassJtagTester;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.LogicSettable;
import com.sun.electric.tool.simulation.test.SimulationModel;
import com.sun.electric.tool.simulation.test.VerilogJtagSubchainTester;
import com.sun.electric.tool.simulation.test.VerilogJtagTester;
import com.sun.electric.tool.simulation.test.VerilogLogicSettable;
import com.sun.electric.tool.simulation.test.VerilogParser;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VerilogModel
extends SimulationModel {
    public static final int NORECORD = 0;
    public static final int DUMPVARS = 1;
    public static final int RECORDVARS = 2;
    private final List jtagTesters = new ArrayList();
    private final List logicSettables = new ArrayList();
    private final AllAliasedNames aliased = new AllAliasedNames();
    private int ticks = 0;
    public static final String jtagControllerFile = "jtagController.v";

    public VerilogModel() {
        super("Verilog", "$finish;", "Error!", "C%% > ");
    }

    @Override
    public JtagTester createJtagTester(String tckName, String tmsName, String trstbName, String tdiName, String tdobName) {
        if (this.isProcessRunning()) {
            System.out.println("Error: JtagTester test device must be created before Verilog process is started.");
            return null;
        }
        VerilogJtagTester tester = new VerilogJtagTester(this, tckName, tmsName, trstbName, tdiName, tdobName);
        this.jtagTesters.add(tester);
        return tester;
    }

    @Override
    public JtagTester createJtagSubchainTester(String jtagInBus, String jtagOutBus) {
        if (this.isProcessRunning()) {
            System.out.println("Error: JtagTester test device must be created before Verilog process is started.");
            return null;
        }
        VerilogJtagSubchainTester tester = new VerilogJtagSubchainTester(this, jtagInBus, jtagOutBus);
        this.jtagTesters.add(tester);
        return tester;
    }

    @Override
    public JtagTester createJtagSubchainTester(String phi2, String phi1, String write, String read, String sin, String sout) {
        if (this.isProcessRunning()) {
            System.out.println("Error: JtagTester test device must be created before Verilog process is started.");
            return null;
        }
        VerilogJtagSubchainTester tester = new VerilogJtagSubchainTester(this, phi2, phi1, write, read, sin, sout);
        this.jtagTesters.add(tester);
        return tester;
    }

    @Override
    public LogicSettable createLogicSettable(String portName) {
        if (this.isProcessRunning()) {
            System.out.println("Error: LogicSettable test device must be created before Verilog process is started.");
            return null;
        }
        VerilogLogicSettable ls = new VerilogLogicSettable(this, portName);
        this.logicSettables.add(ls);
        this.aliased.add(ls.getAliasedNames());
        return ls;
    }

    @Override
    public LogicSettable createLogicSettable(List portNames) {
        if (this.isProcessRunning()) {
            System.out.println("Error: LogicSettable test device must be created before Verilog process is started.");
            return null;
        }
        VerilogLogicSettable ls = new VerilogLogicSettable(this, portNames);
        this.logicSettables.add(ls);
        this.aliased.add(ls.getAliasedNames());
        return ls;
    }

    @Override
    public void disableNode(String node) {
        Exception e2 = new Exception("Unsupported feature");
        e2.printStackTrace(System.out);
    }

    @Override
    public void enableNode(String node) {
        Exception e2 = new Exception("Unsupported feature");
        e2.printStackTrace(System.out);
    }

    @Override
    public double getVdd() {
        return 1.0;
    }

    @Override
    public double getSimulationTime() {
        return this.ticks;
    }

    @Override
    public boolean start_(String verilogCommand, String verilogSource, int recordSim) {
        VerilogParser vp = new VerilogParser();
        if (!vp.parse(verilogSource)) {
            System.out.println("Failed parsing verilog source file " + verilogSource);
            return false;
        }
        List modules = vp.getModules();
        VerilogParser.Module top = (VerilogParser.Module)modules.get(modules.size() - 1);
        if (!this.startProcess(verilogCommand + " -s " + verilogSource, null, null, verilogSource + ".log")) {
            return false;
        }
        switch (recordSim) {
            case 2: {
                this.issueCommand("$recordfile(\"" + top.name + "\");");
                this.issueCommand("$recordvars;");
                break;
            }
            case 1: {
                this.issueCommand("$dumpfile(\"" + top.name + ".dump\");");
                this.issueCommand("$dumpvars;");
                break;
            }
        }
        for (BypassJtagTester tester : this.jtagTesters) {
            tester.reset();
        }
        return true;
    }

    @Override
    public void wait(float seconds) {
        long ticks = (long)((double)seconds * 1000000.0);
        this.waitTicks(ticks);
    }

    @Override
    public void waitNS(double ns) {
        long ticks = (long)(ns * 1000.0);
        this.waitTicks(ticks);
    }

    @Override
    public void waitPS(double ps) {
        this.waitTicks((long)ps);
    }

    public void waitTicks(long ticks) {
        this.issueCommand("$db_steptime(" + ticks + ");");
        this.ticks = (int)((long)this.ticks + ticks);
    }

    @Override
    public double getTimeNS() {
        return (double)this.ticks / 1000.0;
    }

    @Override
    public void setNodeState(String node, int state) {
        if (state != 0 && state != 1) {
            System.out.println("Illegal state passed to setNodeState: " + state + ". Expected 0 or 1.");
            return;
        }
        node = node.replaceAll("@", "_");
        this.issueCommand("force " + node + " = " + state + ";");
        StringBuffer ret = this.getLastCommandOutput();
        if (ret.toString().matches("(Error!).*?(not declared)")) {
            System.out.println("Error! setNodeState: node " + node + " not found");
        }
    }

    @Override
    public int getNodeState(String node) {
        node = node.replaceAll("@", "_");
        this.issueCommand("$showvars(" + node + ");");
        StringBuffer result = this.getLastCommandOutput();
        String[] results = result.toString().trim().split("\n");
        for (int i2 = 0; i2 < results.length; ++i2) {
            String s = results[i2];
            String[] parts = s.split("\\s+");
            if (!node.endsWith(parts[0])) continue;
            String val = parts[parts.length - 1].toLowerCase();
            if (val.equals("0") || val.equals("st0") || val.equals("su0") || val.equals("we0")) {
                return 0;
            }
            if (val.equals("1") || val.equals("st1") || val.equals("su1") || val.equals("we1")) {
                return 1;
            }
            if (val.equals("scheduled")) {
                System.out.println("Warning, attempting to read node '" + node + "' that has a scheduled event at time " + this.ticks + ", you should advance time before reading the node");
                return -2;
            }
            return -2;
        }
        System.out.println("Error! getNodeState: node " + node + " not found");
        return -1;
    }

    public void releaseNode(String s) {
        s = s.replaceAll("@", "_");
        this.issueCommand("release " + s + ";");
    }

    @Override
    public void releaseNodes(List nodes) {
        for (Object o2 : nodes) {
            String s = (String)o2;
            this.releaseNode(s);
        }
    }

    static String getExampleVerilogChipFile() {
        URL jtagController = VerilogModel.class.getResource(jtagControllerFile);
        if (jtagController == null) {
            System.out.println("Can't find resource jtagController.v.  Test Failed.");
            Infrastructure.exit(1);
        }
        return jtagController.getFile();
    }

    static String formatDataNetName(String dataNetName) {
        dataNetName = dataNetName.replaceAll("\\[([a-zA-Z_][^\\]]*)\\]", "_$1_");
        dataNetName = dataNetName.replaceAll("\\[(.*?)\\](?=.)", "_$1_");
        dataNetName = dataNetName.replace('@', '_');
        String[] parts = dataNetName.split("\\.");
        StringBuffer newName = new StringBuffer();
        for (int i2 = 0; i2 < parts.length - 1; ++i2) {
            if (parts[i2].startsWith("x") || parts[i2].startsWith("X")) {
                parts[i2] = parts[i2].substring(1);
            }
            newName.append(parts[i2]);
            newName.append(".");
        }
        if (parts.length > 0) {
            newName.append(parts[parts.length - 1]);
        }
        return newName.toString();
    }

    public static void main(String[] args) {
        VerilogModel vm = new VerilogModel();
        vm.start("verilog", VerilogModel.getExampleVerilogChipFile(), 0);
        vm.issueCommand("$showvars;");
        vm.finish();
    }

    static class AllAliasedNames {
        private List aliases = new ArrayList();

        private AllAliasedNames() {
        }

        private void add(AliasedNames names) {
            if (names == null) {
                return;
            }
            this.aliases.add(names);
        }

        String getAliasFor(String replacedName) {
            for (AliasedNames aliased : this.aliases) {
                String alias2 = aliased.getAliasFor(replacedName);
                if (alias2 == null) continue;
                return alias2;
            }
            return replacedName;
        }
    }

    static class AliasedNames {
        private final String alias;
        private final List replacedNames;

        AliasedNames(String name, List replacedNames) {
            this.alias = name;
            this.replacedNames = new ArrayList(replacedNames);
        }

        private String getAliasFor(String n2) {
            if (this.replacedNames.contains(n2)) {
                return this.alias;
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Alias '" + this.alias + "' for: ");
            Iterator it = this.replacedNames.iterator();
            while (it.hasNext()) {
                String nn = (String)it.next();
                buf.append(nn);
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            return buf.toString();
        }
    }
}

