/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BERT;
import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.NanosimBERT;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class NanosimDataGen
extends NanosimBERT.NanosimTerminal
implements BERT.DataGenerator {
    private BitVector startPattern = new BitVector(0, "start pattern");
    private BitVector repeatPattern = new BitVector(0, "repeat pattern");
    private double delay = 0.0;
    private BERT.SignalMode signalMode = BERT.NONRETURNTOZERO;
    private List pinNames = new ArrayList();
    private List pinNamesComplement = new ArrayList();
    private double voltageLow = 0.0;
    private double voltageHigh = -1.0;
    private boolean enableComplement = false;

    NanosimDataGen(NanosimBERT.NanosimDataModule parentModule) {
        super(parentModule);
    }

    @Override
    public void setPattern(BitVector start, BitVector repeat) {
        this.setPattern(start.getState(), repeat.getState());
    }

    @Override
    public void setPattern(String start, String repeat) {
        this.startPattern = new BitVector(start, "start pattern");
        this.repeatPattern = new BitVector(repeat, "repeat pattern");
    }

    @Override
    public void setDelay(double nanoseconds) {
        this.delay = nanoseconds;
    }

    @Override
    public void setSignalMode(BERT.SignalMode mode) {
        this.signalMode = mode;
    }

    @Override
    public void setClock() {
        this.setPattern("", "1");
        this.setSignalMode(BERT.RETURNTOZERO);
    }

    @Override
    public void setDDRClock() {
        this.setPattern("", "10");
        this.setSignalMode(BERT.NONRETURNTOZERO);
    }

    @Override
    public void addPinName(String pinName) {
        this.pinNames.add(pinName);
    }

    @Override
    public void addPinNameComplement(String pinName) {
        this.pinNamesComplement.add(pinName);
    }

    @Override
    public Iterator getPinNames() {
        return this.pinNames.iterator();
    }

    @Override
    public Iterator getPinNamesComplement() {
        return this.pinNamesComplement.iterator();
    }

    @Override
    public void clearPins() {
        this.pinNames.clear();
        this.pinNamesComplement.clear();
    }

    @Override
    public void setVoltage(double voltageLow, double voltageHigh) {
        this.voltageLow = voltageLow;
        this.voltageHigh = voltageHigh;
    }

    @Override
    public void enableComplement(boolean enable) {
        this.enableComplement = enable;
    }

    protected BitVector getStartPattern() {
        return this.startPattern;
    }

    protected BitVector getRepeatPattern() {
        return this.repeatPattern;
    }

    public String getStartState() {
        return this.startPattern.getState();
    }

    public String getRepeatState() {
        return this.repeatPattern.getState();
    }

    @Override
    public Set generateEvents(double startTimeNS, double stopTimeNS) {
        TreeSet<NanosimBERT.Event> set = new TreeSet<NanosimBERT.Event>();
        int bitIndex = 0;
        boolean lastVal = false;
        for (double curTime = startTimeNS + this.delay; curTime < stopTimeNS; curTime += this.getParentModule().getPeriod()) {
            boolean val = this.getBit(bitIndex);
            if (bitIndex == 0 || val != lastVal) {
                NanosimBERT.Event e2;
                String node;
                Iterator it = this.getPinNames();
                while (it.hasNext()) {
                    node = (String)it.next();
                    e2 = NanosimBERT.Event.createSetNodeEvent(curTime, node, val ? this.voltageHigh : this.voltageLow);
                    set.add(e2);
                }
                if (this.enableComplement) {
                    it = this.getPinNamesComplement();
                    while (it.hasNext()) {
                        node = (String)it.next();
                        e2 = NanosimBERT.Event.createSetNodeEvent(curTime, node, val ? this.voltageLow : this.voltageHigh);
                        set.add(e2);
                    }
                }
            }
            lastVal = val;
            if (this.signalMode == BERT.RETURNTOZERO && val) {
                NanosimBERT.Event e3;
                String node;
                double rtzTime = curTime + this.getParentModule().getPeriod() / 2.0;
                Iterator it = this.getPinNames();
                while (it.hasNext()) {
                    node = (String)it.next();
                    e3 = NanosimBERT.Event.createSetNodeEvent(rtzTime, node, this.voltageLow);
                    set.add(e3);
                }
                if (this.enableComplement) {
                    it = this.getPinNamesComplement();
                    while (it.hasNext()) {
                        node = (String)it.next();
                        e3 = NanosimBERT.Event.createSetNodeEvent(curTime, node, this.voltageHigh);
                        set.add(e3);
                    }
                }
                lastVal = false;
            }
            ++bitIndex;
        }
        return set;
    }

    public boolean getBit(int bitIndex) {
        if (bitIndex < this.startPattern.getNumBits()) {
            return this.startPattern.get(bitIndex);
        }
        int len = this.repeatPattern.getNumBits();
        bitIndex -= this.startPattern.getNumBits();
        if (len > 0) {
            int loc = bitIndex % len;
            return this.repeatPattern.get(loc);
        }
        if (this.startPattern.getNumBits() > 0) {
            return this.startPattern.get(this.startPattern.getNumBits() - 1);
        }
        return false;
    }

    public static void main(String[] args) {
        NanosimBERT.NanosimDataModule module = new NanosimBERT.NanosimDataModule();
        module.setFrequency(1000000.0);
        NanosimDataGen gen = (NanosimDataGen)module.createDataGenerator();
        gen.addPinName("testpin");
        System.out.println("Empty events:");
        NanosimBERT.printEvents(gen.generateEvents(0.0, 20.0));
        System.out.println("-----------------------------------");
        gen.setPattern(new BitVector("10010101011", "blah"), new BitVector("", ""));
        System.out.println("Start pattern only events: ");
        NanosimBERT.printEvents(gen.generateEvents(0.0, 20.0));
        System.out.println("-----------------------------------");
        gen.setPattern(new BitVector("", "blah"), new BitVector("0101010001011", ""));
        System.out.println("Repeat pattern only events: ");
        NanosimBERT.printEvents(gen.generateEvents(0.0, 20.0));
        System.out.println("-----------------------------------");
        gen.setPattern(new BitVector("10111100011010", "blah"), new BitVector("0100001011", ""));
        System.out.println("Start and Repeat pattern events: ");
        NanosimBERT.printEvents(gen.generateEvents(0.0, 50.0));
        System.out.println("-----------------------------------");
        System.out.println("Start and Repeat pattern events (ReturnToZero): ");
        gen.setSignalMode(BERT.RETURNTOZERO);
        NanosimBERT.printEvents(gen.generateEvents(0.0, 20.0));
        System.out.println("-----------------------------------");
        System.out.println("Clock mode: ");
        gen.setClock();
        NanosimBERT.printEvents(gen.generateEvents(0.0, 20.0));
    }
}

