/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.sctiming;

import java.util.HashMap;
import java.util.Map;

public class Table2D {
    private double[] rowVals;
    private double[] colVals;
    private String rowName;
    private String colName;
    private Map<String, double[][]> valuesMap;

    public Table2D(double[] rowVals, String rowName, double[] colVals, String colName) {
        this.rowVals = rowVals;
        this.colVals = colVals;
        this.rowName = rowName.toLowerCase();
        this.colName = colName.toLowerCase();
        this.valuesMap = new HashMap<String, double[][]>();
    }

    public String getRowName() {
        return this.rowName;
    }

    public String getColName() {
        return this.colName;
    }

    public int getNumRows() {
        return this.rowVals.length;
    }

    public int getNumCols() {
        return this.colVals.length;
    }

    public double[] getColIndexVals() {
        return this.colVals;
    }

    public double[] getRowIndexVals() {
        return this.rowVals;
    }

    public void setValue(double rowVal, double colVal, String dataKey, double value) {
        int i2;
        int i1;
        double[][] values = this.valuesMap.get(dataKey = dataKey.toLowerCase());
        if (values == null) {
            values = new double[this.rowVals.length][this.colVals.length];
            this.valuesMap.put(dataKey, values);
        }
        for (i1 = 0; i1 < this.rowVals.length && this.rowVals[i1] != rowVal; ++i1) {
        }
        if (i1 == this.rowVals.length) {
            System.out.println("Cannot find value " + rowVal + " in row values");
            return;
        }
        for (i2 = 0; i2 < this.colVals.length && this.colVals[i2] != colVal; ++i2) {
        }
        if (i2 == this.colVals.length) {
            System.out.println("Cannot find value " + colVal + " in column values");
            return;
        }
        values[i1][i2] = value;
    }

    public double getValue(double rowVal, double colVal, String dataKey) {
        int i2;
        int i1;
        double[][] values = this.valuesMap.get(dataKey = dataKey.toLowerCase());
        if (values == null) {
            System.out.println("Data key " + dataKey + " not found");
            return Double.MIN_VALUE;
        }
        for (i1 = 0; i1 < this.rowVals.length && this.rowVals[i1] != rowVal; ++i1) {
        }
        if (i1 == this.rowVals.length) {
            System.out.println("Cannot find value " + rowVal + " in row values");
            return Double.MIN_VALUE;
        }
        for (i2 = 0; i2 < this.colVals.length && this.colVals[i2] != colVal; ++i2) {
        }
        if (i2 == this.colVals.length) {
            System.out.println("Cannot find value " + colVal + " in column values");
            return Double.MIN_VALUE;
        }
        return values[i1][i2];
    }

    public void setData(String dataKey, double[][] data) {
        dataKey = dataKey.toLowerCase();
        if (data.length != this.rowVals.length) {
            return;
        }
        for (int i2 = 0; i2 < data.length; ++i2) {
            if (data[i2].length == this.colVals.length) continue;
            return;
        }
        this.valuesMap.put(dataKey, data);
    }

    public double[] getColumnValues(String key, int colIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return null;
        }
        double[] col = new double[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            col[i2] = values[i2][colIndex];
        }
        return col;
    }

    public double[] getRowValues(String key, int rowIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return null;
        }
        return values[rowIndex];
    }

    public static double getAverage(double[] vals) {
        double total = 0.0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            total += vals[i2];
        }
        return total / (double)vals.length;
    }

    public static double getStandardDeviation(double[] vals) {
        double avg = Table2D.getAverage(vals);
        double total = 0.0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            double diff = avg - vals[i2];
            total += diff * diff;
        }
        return Math.sqrt(total / (double)vals.length);
    }

    public static double getAverage(double[][] vals) {
        double total = 0.0;
        int count = 0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            double[] row = vals[i2];
            for (int j2 = 0; j2 < row.length; ++j2) {
                total += row[j2];
                ++count;
            }
        }
        return total / (double)count;
    }

    public static double getStandardDeviation(double[][] vals) {
        double avg = Table2D.getAverage(vals);
        double total = 0.0;
        int count = 0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            double[] row = vals[i2];
            for (int j2 = 0; j2 < row.length; ++j2) {
                double diff = avg - row[j2];
                total += diff * diff;
                ++count;
            }
        }
        return Math.sqrt(total / (double)count);
    }

    public double getAvgColumnValue(String key, int colIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return 0.0;
        }
        double total = 0.0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            double[] row = values[i2];
            total += row[colIndex];
        }
        return total / (double)values.length;
    }

    public double[] getAvgColumnValues(String key) {
        key = key.toLowerCase();
        double[] avgvals = new double[this.colVals.length];
        for (int i2 = 0; i2 < this.colVals.length; ++i2) {
            avgvals[i2] = this.getAvgColumnValue(key, i2);
        }
        return avgvals;
    }

    public double getAvgRowValue(String key, int rowIndex) {
        double[][] values = this.valuesMap.get(key = key.toLowerCase());
        if (values == null) {
            return 0.0;
        }
        double[] row = values[rowIndex];
        return Table2D.getAverage(row);
    }

    public double[] getAvgRowValues(String key) {
        key = key.toLowerCase();
        double[] avgvals = new double[this.rowVals.length];
        for (int i2 = 0; i2 < this.rowVals.length; ++i2) {
            avgvals[i2] = this.getAvgRowValue(key, i2);
        }
        return avgvals;
    }

    public double[][] getValues(String key) {
        key = key.toLowerCase();
        return this.valuesMap.get(key);
    }

    public void print() {
        for (String s : this.valuesMap.keySet()) {
            this.print(s);
        }
    }

    public void print(String key) {
        int i2;
        key = key.toLowerCase();
        System.out.println("---------------------------------------------------");
        System.out.println(key + ":");
        System.out.println("---------------------------------------------------");
        double[][] values = this.valuesMap.get(key);
        if (values == null) {
            return;
        }
        System.out.println("\t" + this.colName);
        System.out.println(this.rowName);
        System.out.print("\t");
        for (i2 = 0; i2 < this.colVals.length; ++i2) {
            System.out.print(this.colVals[i2] + "\t");
        }
        System.out.println();
        for (i2 = 0; i2 < this.rowVals.length; ++i2) {
            System.out.print(this.rowVals[i2] + "\t");
            double[] vals = values[i2];
            for (int i22 = 0; i22 < this.colVals.length; ++i22) {
                System.out.print(vals[i22] + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }
}

