/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.irsim;

import com.sun.electric.api.irsim.IAnalyzer;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.extract.ExtractedPBucket;
import com.sun.electric.tool.extract.RCPBucket;
import com.sun.electric.tool.extract.TransistorPBucket;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.simulation.BusSample;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.SwingUtilities;

public class IRSIM
implements Engine,
IAnalyzer.GUI {
    private static final double DEFIRSIMTIMERANGE = (double)1.0E-8f;
    private static boolean IRSIMChecked = false;
    private static IAnalyzer instance;
    private IAnalyzer.EngineIRSIM a;
    private WaveformWindow ww;
    private SignalCollection sigCollection;
    private Collection<GuiSignalImpl> guiSigCollection = new ArrayList<GuiSignalImpl>();
    private final Stimuli sd = new Stimuli();

    public static boolean hasIRSIM() {
        return IRSIM.getInstance() != null;
    }

    private static IAnalyzer getInstance() {
        if (instance == null && !IRSIMChecked) {
            try {
                Class<?> clz = Class.forName("com.sun.electric.plugins.irsim.IAnalyzerImpl");
                if (clz != null) {
                    instance = (IAnalyzer)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (instance == null) {
                TextUtils.recordMissingComponent("IRSIM");
            }
            IRSIMChecked = true;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runIRSIM(Cell cell, VarContext context, String fileName, IRSIM.IRSIMPreferences ip, boolean doNow) {
        try {
            IAnalyzer.EngineIRSIM analyzer;
            File pf;
            URL parameterURL = null;
            String parameterFile = ip.parameterFile.trim();
            if (parameterFile.length() > 0 && (parameterURL = (pf = new File(parameterFile)) != null && pf.exists() ? TextUtils.makeURLToFile(parameterFile) : LibFile.getLibFile(parameterFile)) == null) {
                System.out.println("Cannot find parameter file: " + parameterFile);
            }
            IAnalyzer ianalyzer = IRSIM.getInstance();
            final IRSIM irsim = new IRSIM();
            irsim.a = analyzer = ianalyzer.createEngine(irsim, ip.steppingModel, parameterURL, ip.irDebug, SimulationTool.isIRSIMShowsCommands(), SimulationTool.isIRSIMDelayedX());
            IAnalyzer.EngineIRSIM engineIRSIM = analyzer;
            synchronized (engineIRSIM) {
                if (cell != null) {
                    System.out.println("Loading netlist for " + cell.noLibDescribe() + "...");
                } else {
                    System.out.println("Loading netlist for file " + fileName + "...");
                }
                if (fileName == null) {
                    List<Object> components = com.sun.electric.tool.io.output.IRSIM.getIRSIMComponents(cell, context, ip);
                    Technology layoutTech = Schematics.getDefaultSchematicTechnology();
                    double lengthOff = Schematics.getDefaultSchematicTechnology().getGateLengthSubtraction() / layoutTech.getScale();
                    for (Object obj : components) {
                        ExtractedPBucket pb = (ExtractedPBucket)obj;
                        if (pb instanceof TransistorPBucket) {
                            TransistorPBucket tb = (TransistorPBucket)pb;
                            analyzer.putTransistor(tb.gateName, tb.sourceName, tb.drainName, tb.getTransistorLength(lengthOff), tb.getTransistorWidth(), tb.getActiveArea(), tb.getActivePerim(), tb.ni.getAnchorCenterX(), tb.ni.getAnchorCenterY(), tb.getType() == 'n');
                            continue;
                        }
                        if (!(pb instanceof RCPBucket)) continue;
                        RCPBucket rcb = (RCPBucket)pb;
                        switch (rcb.getType()) {
                            case 'r': {
                                analyzer.putResistor(rcb.net1, rcb.net2, rcb.rcValue);
                                break;
                            }
                            case 'C': {
                                analyzer.putCapacitor(rcb.net1, rcb.net2, rcb.rcValue);
                            }
                        }
                    }
                } else {
                    URL fileURL = TextUtils.makeURLToFile(fileName);
                    if (irsim.inputSim(fileURL)) {
                        return;
                    }
                }
                analyzer.finishNetwork();
                irsim.sd.setEngine(irsim);
                irsim.sigCollection = Stimuli.newSignalCollection(irsim.sd, "SIGNALS");
                irsim.sd.setSeparatorChar('/');
                analyzer.convertStimuli();
                irsim.sd.setCell(cell);
                if (doNow) {
                    WaveformWindow.showSimulationDataInNewWindow(irsim.sd);
                    irsim.ww = irsim.sd.getWaveformWindow();
                    analyzer.init();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WaveformWindow.showSimulationDataInNewWindow(irsim.sd);
                            irsim.ww = irsim.sd.getWaveformWindow();
                            analyzer.init();
                        }
                    });
                }
            }
        }
        catch (Exception e2) {
            System.out.println("Unable to run the IRSIM simulator");
            e2.printStackTrace(System.out);
        }
    }

    @Override
    public FileType getVectorsFileType() {
        return FileType.IRSIMVECTOR;
    }

    @Override
    public Stimuli getStimuli() {
        return this.sd;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void update() {
        this.a.playVectors();
    }

    @Override
    public void setSignalHigh() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.isEmpty()) {
            Job.getUserInterface().showErrorMessage("Must select a signal before setting it High", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            String signalName = sig.getFullName().replace('.', '/');
            this.a.newContolPoint(signalName, this.ww.getMainXPositionCursor(), IAnalyzer.LogicState.LOGIC_1);
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.a.playVectors();
        }
    }

    @Override
    public void setSignalLow() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.isEmpty()) {
            Job.getUserInterface().showErrorMessage("Must select a signal before setting it Low", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            String signalName = sig.getFullName().replace('.', '/');
            this.a.newContolPoint(signalName, this.ww.getMainXPositionCursor(), IAnalyzer.LogicState.LOGIC_0);
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.a.playVectors();
        }
    }

    @Override
    public void setSignalX() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.isEmpty()) {
            Job.getUserInterface().showErrorMessage("Must select a signal before setting it Undefined", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            String signalName = sig.getFullName().replace('.', '/');
            this.a.newContolPoint(signalName, this.ww.getMainXPositionCursor(), IAnalyzer.LogicState.LOGIC_X);
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.a.playVectors();
        }
    }

    @Override
    public void setClock(double period) {
        System.out.println("IRSIM CANNOT HANDLE CLOCKS YET");
    }

    @Override
    public void showSignalInfo() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.isEmpty()) {
            Job.getUserInterface().showErrorMessage("Must select a signal before displaying it", "No Signals Selected");
            return;
        }
        for (Signal<?> sig : signals) {
            this.a.showSignalInfo(this.findGuiSignal(sig));
        }
    }

    @Override
    public void removeStimuliFromSignal() {
        List<Signal<?>> signals = this.ww.getHighlightedNetworkNames();
        if (signals.size() != 1) {
            Job.getUserInterface().showErrorMessage("Must select a single signal on which to clear stimuli", "No Signals Selected");
            return;
        }
        Signal<?> sig = signals.get(0);
        sig.clearControlPoints();
        this.a.clearControlPoints(this.findGuiSignal(sig));
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.a.playVectors();
        }
    }

    @Override
    public boolean removeSelectedStimuli() {
        boolean found = false;
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            for (WaveSignal ws : wp.getSignals()) {
                double[] selectedCPs;
                if (!ws.isHighlighted() || (selectedCPs = ws.getSelectedControlPoints()) == null) continue;
                for (int i2 = 0; i2 < selectedCPs.length; ++i2) {
                    if (!this.a.clearControlPoint(this.findGuiSignal(ws.getSignal()), selectedCPs[i2])) continue;
                    found = true;
                }
            }
        }
        if (!found) {
            System.out.println("There are no selected control points to remove");
            return false;
        }
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.a.playVectors();
        }
        return true;
    }

    @Override
    public void removeAllStimuli() {
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            for (WaveSignal ws : wp.getSignals()) {
                ws.getSignal().clearControlPoints();
            }
        }
        this.a.clearAllVectors();
        if (SimulationTool.isBuiltInResimulateEach()) {
            this.a.playVectors();
        }
    }

    @Override
    public void saveStimuli(File stimuliFile) throws IOException {
        this.a.saveStimuli(stimuliFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreStimuli(URL stimuliURL) throws IOException {
        if (stimuliURL == null) {
            throw new NullPointerException();
        }
        try (InputStreamReader reader = new InputStreamReader(stimuliURL.openStream());){
            this.a.clearAllVectors();
            Iterator<Panel> it = this.ww.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                for (WaveSignal ws : wp.getSignals()) {
                    ws.getSignal().clearControlPoints();
                }
            }
            this.a.restoreStimuli(reader);
        }
    }

    @Override
    public double getMinTimeRange() {
        return 1.0E-8f;
    }

    @Override
    public IAnalyzer.GuiSignal makeSignal(String name) {
        int slashPos = name.lastIndexOf(47);
        MutableSignal<DigitalSample> sig = slashPos >= 0 ? DigitalSample.createSignal(this.sigCollection, this.sd, name.substring(slashPos + 1), name.substring(0, slashPos)) : DigitalSample.createSignal(this.sigCollection, this.sd, name, null);
        GuiSignalImpl sigImpl = new GuiSignalImpl(sig, null);
        this.guiSigCollection.add(sigImpl);
        return sigImpl;
    }

    @Override
    public void createBus(String busName, IAnalyzer.GuiSignal ... subsigs) {
        Signal[] sigArray = new Signal[subsigs.length];
        for (int i2 = 0; i2 < subsigs.length; ++i2) {
            Signal<?> sigImpl;
            IAnalyzer.GuiSignal guiSig = subsigs[i2];
            sigArray[i2] = sigImpl = ((GuiSignalImpl)guiSig).impl;
        }
        Signal busSignal = BusSample.createSignal(this.sigCollection, this.sd, busName, null, true, sigArray);
        GuiSignalImpl sigImpl = new GuiSignalImpl(busSignal, subsigs);
        this.guiSigCollection.add(sigImpl);
    }

    @Override
    public void makeBusSignals(List<IAnalyzer.GuiSignal> sigList) {
        ArrayList sigListImpl = new ArrayList();
        HashMap sigToGui = new HashMap();
        for (IAnalyzer.GuiSignal guiSignal : sigList) {
            Signal<?> sigImpl = ((GuiSignalImpl)guiSignal).impl;
            sigListImpl.add(sigImpl);
            GuiSignalImpl old = sigToGui.put(sigImpl, (GuiSignalImpl)guiSignal);
            if (old == null) continue;
            throw new IllegalArgumentException("Duplicate " + String.valueOf(old));
        }
        this.sd.makeBusSignals(sigListImpl, this.sigCollection);
        for (Signal signal : this.sigCollection.getSignals()) {
            Signal<?>[] busMembers = signal.getBusMembers();
            if (busMembers == null) continue;
            IAnalyzer.GuiSignal[] memberArray = new IAnalyzer.GuiSignal[busMembers.length];
            for (int i2 = 0; i2 < busMembers.length; ++i2) {
                GuiSignalImpl ss = (GuiSignalImpl)sigToGui.get(busMembers[i2]);
                if (ss == null) {
                    throw new IllegalArgumentException();
                }
                memberArray[i2] = ss;
            }
            this.guiSigCollection.add(new GuiSignalImpl(signal, memberArray));
        }
    }

    @Override
    public Collection<IAnalyzer.GuiSignal> getSignals() {
        return Collections.unmodifiableCollection(this.guiSigCollection);
    }

    @Override
    public void setMainXPositionCursor(double curTime) {
        if (SimulationTool.isBuiltInAutoAdvance()) {
            this.ww.setMainXPositionCursor(curTime + 1.0E-8);
        }
    }

    @Override
    public void openPanel(Collection<IAnalyzer.GuiSignal> sigs) {
        for (IAnalyzer.GuiSignal guiSig : sigs) {
            Signal<?> sig = ((GuiSignalImpl)guiSig).impl;
            int height = User.getWaveformDigitalPanelHeight();
            Panel wp = new Panel(this.ww, height);
            wp.makeSelectedPanel(-1, -1);
            new WaveSignal(wp, sig);
        }
    }

    @Override
    public void closePanels() {
        this.ww.clearHighlighting();
        ArrayList<Panel> allPanels = new ArrayList<Panel>();
        Iterator<Panel> it = this.ww.getPanels();
        while (it.hasNext()) {
            allPanels.add(it.next());
        }
        for (Panel wp : allPanels) {
            wp.closePanel();
        }
    }

    @Override
    public double getMaxPanelTime() {
        double maxPanelTime = Double.NEGATIVE_INFINITY;
        Iterator<Panel> it = this.ww.getPanels();
        if (it.hasNext()) {
            Panel wp = it.next();
            maxPanelTime = Math.max(maxPanelTime, wp.getMaxXAxis());
        }
        return maxPanelTime;
    }

    @Override
    public void repaint() {
        this.ww.repaint();
    }

    @Override
    public char canonicChar(char ch) {
        return TextUtils.canonicChar(ch);
    }

    @Override
    public String canonicString(String s) {
        return TextUtils.canonicString(s);
    }

    @Override
    public double atof(String text) {
        return TextUtils.atof(text);
    }

    @Override
    public int atoi(String s) {
        return TextUtils.atoi(s);
    }

    @Override
    public String formatDouble(double v) {
        return TextUtils.formatDouble(v);
    }

    private boolean inputSim(URL simFileURL) {
        String fileName = simFileURL.getFile();
        try {
            URLConnection urlCon = simFileURL.openConnection();
            InputStream inputStream = urlCon.getInputStream();
            InputStreamReader is = new InputStreamReader(new ProgressMonitorInputStream(null, "import " + fileName, inputStream));
            int numErrors = this.a.inputSim(is, fileName);
            inputStream.close();
            System.out.println("Loaded circuit, lambda=" + this.a.getLambda() + "u");
            return numErrors > 0;
        }
        catch (IOException e2) {
            System.out.println("Error reading file");
            return false;
        }
    }

    private IAnalyzer.GuiSignal findGuiSignal(Signal<?> sig) {
        for (GuiSignalImpl guiSignal : this.guiSigCollection) {
            if (guiSignal.impl != sig) continue;
            return guiSignal;
        }
        return null;
    }

    static class GuiSignalImpl
    implements IAnalyzer.GuiSignal {
        final Signal<?> impl;
        private IAnalyzer.GuiSignal[] busMembers;

        private GuiSignalImpl(Signal<?> impl, IAnalyzer.GuiSignal[] busMembers) {
            this.impl = impl;
            this.busMembers = busMembers;
        }

        public void updateHistory(double[] time, IAnalyzer.LogicState[] value) {
        }

        @Override
        public String getFullName() {
            return this.impl.getFullName();
        }

        @Override
        public String getSignalName() {
            return this.impl.getSignalName();
        }

        @Override
        public IAnalyzer.GuiSignal[] getBusMembers() {
            return this.busMembers;
        }

        @Override
        public void addControlPoint(double time) {
            this.impl.addControlPoint(time);
        }

        @Override
        public void removeControlPoint(double time) {
            this.impl.removeControlPoint(time);
        }

        @Override
        public void addSample(double t, IAnalyzer.LogicState v) {
            DigitalSample.Value value = switch (v) {
                case IAnalyzer.LogicState.LOGIC_1 -> DigitalSample.Value.HIGH;
                case IAnalyzer.LogicState.LOGIC_0 -> DigitalSample.Value.LOW;
                case IAnalyzer.LogicState.LOGIC_X -> DigitalSample.Value.X;
                default -> throw new AssertionError();
            };
            MutableSignal mutable = (MutableSignal)this.impl;
            if (mutable.getSample(t) == null) {
                mutable.addSample(t, DigitalSample.getSample(value, DigitalSample.Strength.LARGE_CAPACITANCE));
            }
        }
    }
}

