/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.interval;

import com.sun.electric.util.math.MutableInterval;
import java.math.BigDecimal;

public class UnivariateTaylorModel {
    private static double[] NULL_DOUBLE_ARRAY = new double[0];
    private static MutableInterval ENTIRE = new MutableInterval().assignEntire();
    private final double[] coeff;
    private final MutableInterval remainder;
    private final MutableInterval evalRemainder;

    private UnivariateTaylorModel(double[] coeff, double inf, double sup) {
        this.coeff = coeff;
        this.remainder = new MutableInterval(inf, sup);
        double evalRound = 0.0;
        this.evalRemainder = new MutableInterval(-evalRound, evalRound);
        this.evalRemainder.add(this.remainder);
    }

    private UnivariateTaylorModel(double[] coeff) {
        this.coeff = coeff;
        this.remainder = this.evalRemainder = ENTIRE;
    }

    public static UnivariateTaylorModel newInst(double x) {
        double[] coeff = NULL_DOUBLE_ARRAY;
        double inf = 0.0;
        double sup = 0.0;
        if (Double.NEGATIVE_INFINITY < x && x < Double.POSITIVE_INFINITY) {
            coeff = new double[]{x};
        } else if (x == Double.POSITIVE_INFINITY) {
            coeff = new double[]{Double.MAX_VALUE};
            sup = x;
        } else if (x == Double.NEGATIVE_INFINITY) {
            inf = x;
            coeff = new double[]{-1.7976931348623157E308};
        } else {
            inf = -1.7976931348623157E308;
            sup = Double.MAX_VALUE;
        }
        return new UnivariateTaylorModel(coeff, inf, sup);
    }

    public static UnivariateTaylorModel newInst(MutableInterval x) {
        return null;
    }

    public int size() {
        return this.coeff.length;
    }

    public double coeff(int k2) {
        return k2 < this.coeff.length ? this.coeff[k2] : 0.0;
    }

    public MutableInterval getRemainder() {
        return new MutableInterval(this.remainder);
    }

    public void eval(MutableInterval result, double t) {
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            result.assignEntire();
            return;
        }
        double value = 0.0;
        for (int k2 = this.coeff.length - 1; k2 >= 0; --k2) {
            value = value * t + this.coeff[k2];
        }
        result.add(this.evalRemainder);
    }

    public void eval2(MutableInterval result, double t) {
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            result.assignEntire();
            return;
        }
        result.assign(0);
        MutableInterval ti = new MutableInterval(t);
        for (int k2 = this.coeff.length - 1; k2 >= 0; --k2) {
            result.mul(ti).add(new MutableInterval(this.coeff[k2]));
        }
        result.add(this.remainder);
    }

    public void eval3(MutableInterval result, double t) {
        double sup;
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            result.assignEntire();
            return;
        }
        BigDecimal tb = BigDecimal.valueOf(t);
        BigDecimal ib = BigDecimal.valueOf(0L);
        BigDecimal sb = BigDecimal.valueOf(0L);
        for (int k2 = this.coeff.length - 1; k2 >= 0; --k2) {
            ib.multiply(tb);
            sb.multiply(tb);
            if (t < 0.0) {
                BigDecimal b2 = ib;
                ib = sb;
                sb = b2;
            }
            BigDecimal cb = BigDecimal.valueOf(this.coeff[k2]);
            ib.add(cb);
            sb.add(cb);
        }
        ib.add(new BigDecimal(this.remainder.inf()));
        sb.add(new BigDecimal(this.remainder.sup()));
        double inf = ib.doubleValue();
        if (!ib.equals(BigDecimal.valueOf(inf))) {
            inf = MutableInterval.prev(inf);
        }
        if (!sb.equals(BigDecimal.valueOf(sup = sb.doubleValue()))) {
            sup = MutableInterval.next(sup);
        }
        result.assign(inf, sup);
    }

    public void eval3(MutableInterval[] results, double t) {
        if (!(-1.0 <= t) || !(t <= 1.0)) {
            for (MutableInterval result : results) {
                result.assignEntire();
            }
            return;
        }
        BigDecimal[] lb = new BigDecimal[results.length];
        BigDecimal[] hb = new BigDecimal[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            lb[i2] = hb[i2] = BigDecimal.valueOf(0L);
        }
    }

    public void evalAtZero(MutableInterval result) {
        if (this.coeff.length >= 1) {
            result.assign(this.coeff[0]);
            result.add(this.remainder);
        } else {
            result.assignEmpty();
        }
    }

    public void evalAtPlusOne(MutableInterval result) {
        result.assign(0);
        for (int k2 = this.coeff.length - 1; k2 >= 0; --k2) {
            result.add(this.coeff[k2]);
        }
        result.add(this.remainder);
    }

    public void evalAtMinusOne(MutableInterval result) {
        result.assign(0);
        for (int k2 = this.coeff.length - 1; k2 >= 0; --k2) {
            result.add((k2 & 1) == 0 ? this.coeff[k2] : -this.coeff[k2]);
        }
        result.add(this.remainder);
    }

    public UnivariateTaylorModel negate() {
        double[] newCoeff = new double[this.coeff.length];
        for (int k2 = 0; k2 < this.coeff.length; ++k2) {
            newCoeff[k2] = -this.coeff[k2];
        }
        return new UnivariateTaylorModel(newCoeff, -this.remainder.sup(), -this.remainder.inf());
    }

    public UnivariateTaylorModel multiplyNaive(double x) {
        double[] newCoeff = new double[this.size()];
        for (int k2 = 0; k2 < newCoeff.length; ++k2) {
            newCoeff[k2] = this.coeff[k2] * x;
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    public UnivariateTaylorModel addNaive(UnivariateTaylorModel x, int maxSize) {
        maxSize = Math.min(maxSize, Math.max(this.size(), x.size()));
        double[] newCoeff = new double[maxSize];
        for (int k2 = 0; k2 < newCoeff.length; ++k2) {
            newCoeff[k2] = this.coeff(k2) + x.coeff(k2);
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    public UnivariateTaylorModel subtractNaive(UnivariateTaylorModel x, int maxSize) {
        maxSize = Math.min(maxSize, Math.max(this.size(), x.size()));
        double[] newCoeff = new double[maxSize];
        for (int k2 = 0; k2 < newCoeff.length; ++k2) {
            newCoeff[k2] = this.coeff(k2) + x.coeff(k2);
        }
        return new UnivariateTaylorModel(newCoeff);
    }

    public UnivariateTaylorModel multiplyNaive(UnivariateTaylorModel x, int maxSize) {
        maxSize = Math.min(maxSize, this.size() + x.size() - 1);
        if (x.size() < maxSize) {
            return x.multiplyNaive(this, maxSize);
        }
        double[] newCoeff = new double[maxSize];
        for (int k2 = 0; k2 < newCoeff.length; ++k2) {
            double s = 0.0;
            for (int l2 = 0; l2 < this.size(); ++l2) {
                s += this.coeff(l2) * x.coeff(k2 - l2);
            }
            newCoeff[k2] = s;
        }
        return new UnivariateTaylorModel(newCoeff);
    }
}

