/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.interval;

import com.sun.electric.tool.simulation.interval.ExprEval;
import com.sun.electric.tool.simulation.interval.RawFile;

public class Diode {
    static final double CHARGE = 1.6021918E-19;
    static final double CONSTboltz = 1.3806226E-23;
    static final double REFTEMP = 300.15;
    ExprEval ev = new ExprEval();
    ExprEval.DoubleConstExpr is = this.ev.newConst(1.0E-14);
    ExprEval.DoubleConstExpr gmin = this.ev.newConst(0.0);
    ExprEval.DoubleConstExpr vt = this.ev.newConst(0.02586418638455146);
    ExprEval.DoubleConstExpr vd = this.ev.newConst();
    ExprEval.DoubleExpr cd;
    ExprEval.DoubleExpr gd;

    Diode() {
        this.is.setName("is");
        this.gmin.setName("gmin");
        this.vt.setName("vt");
        this.vd.setName("vd");
        ExprEval.DoubleExpr evd = this.vd.divide(this.vt).exp();
        evd.setName("evd");
        ExprEval.DoubleExpr cdp = this.is.multiply(evd.subtract(this.ev.newConst(1.0)));
        cdp.setName("cdp");
        ExprEval.DoubleExpr gdp = this.is.divide(this.vt).multiply(evd);
        gdp.setName("gdp");
        ExprEval.DoubleExpr arg = this.vt.multiply(this.ev.newConst(1.103638323514327)).divide(this.vd);
        arg.setName("arg");
        ExprEval.DoubleExpr arg3 = arg.multiply(arg).multiply(arg);
        arg3.setName("arg3");
        ExprEval.DoubleExpr cdm = this.is.negate().multiply(this.ev.newConst(1.0).add(arg3));
        cdm.setName("cdm");
        ExprEval.DoubleExpr gdm = this.is.multiply(this.ev.newConst(3.0)).multiply(arg3).divide(this.vd);
        gdm.setName("gdm");
        ExprEval.BooleanExpr direct = this.vd.ge(this.ev.newConst(-3.0).multiply(this.vt));
        direct.setName("direct");
        ExprEval.DoubleExpr cd0 = direct.ite(cdp, cdm);
        cd0.setName("cd0");
        ExprEval.DoubleExpr gd0 = direct.ite(gdp, gdm);
        gd0.setName("gd0");
        this.cd = cd0.add(this.gmin.multiply(this.vd));
        this.cd.setName("cd");
        this.gd = gd0.add(this.gmin);
        this.gd.setName("gd");
    }

    public static void plotDiode(String filePath) {
        System.out.println("Plotting Diode graph to file " + filePath);
        Diode d2 = new Diode();
        double delta = 0.001;
        int numPoints = 10000;
        int numVars = 11;
        RawFile raw = new RawFile(numPoints + 1, numVars);
        raw.setVar(0, "vd", "voltage");
        raw.setVar(1, "j", "current");
        raw.setVar(2, "g", "conductance");
        raw.setVar(3, "jm", "current");
        raw.setVar(4, "gm", "conductance");
        raw.setVar(5, "jp", "current");
        raw.setVar(6, "gp", "conductance");
        raw.setVar(7, "jl", "current");
        raw.setVar(8, "gl", "conductance");
        raw.setVar(9, "jh", "current");
        raw.setVar(10, "gh", "conductance");
        for (int k2 = 0; k2 <= numPoints; ++k2) {
            double vd = -0.2 + 0.3 / (double)numPoints * (double)k2;
            raw.set(k2, 0, vd);
            d2.vd.setV(vd);
            d2.ev.calcAll();
            raw.set(k2, 1, d2.cd.v());
            raw.set(k2, 2, d2.gd.v());
            d2.vd.setV(vd - delta);
            d2.ev.calcAll();
            raw.set(k2, 3, d2.cd.v());
            raw.set(k2, 4, d2.gd.v());
            d2.vd.setV(vd + delta);
            d2.ev.calcAll();
            raw.set(k2, 5, d2.cd.v());
            raw.set(k2, 6, d2.gd.v());
            d2.vd.setInterval(vd - delta, vd + delta);
            d2.ev.calcIntervalAll();
            raw.set(k2, 7, d2.cd.inf());
            raw.set(k2, 8, d2.gd.inf());
            raw.set(k2, 9, d2.cd.sup());
            raw.set(k2, 10, d2.gd.sup());
        }
        raw.write(filePath);
    }

    public static void main(String[] argv) {
        Diode.plotDiode("diode.raw");
    }
}

