/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import java.math.BigInteger;
import java.util.Map;

public class Vec4Concat<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public Svex<N> width;
    public Svex<N> low;
    public Svex<N> high;

    private Vec4Concat(Svex<N> width, Svex<N> low, Svex<N> high) {
        super(FUNCTION, width, low, high);
        this.width = width;
        this.low = low;
        this.high = high;
    }

    @Override
    public boolean isLhsUnbounded() {
        return this.width instanceof SvexQuote && ((SvexQuote)this.width).val.isIndex() && this.low.isLhsUnbounded() && this.high.isLhsUnbounded();
    }

    @Override
    public boolean isLhs() {
        return this.width instanceof SvexQuote && ((SvexQuote)this.width).val.isIndex() && this.low.isLhsUnbounded() && this.high.isLhs();
    }

    @Override
    public Lhs<N> lhsBound(int w) {
        Vec2 widVal = (Vec2)((SvexQuote)this.width).val;
        int wv = widVal.getVal().intValueExact();
        return w <= wv ? this.low.lhsBound(w) : this.low.lhsBound(wv).concat(wv, this.high.lhsBound(w - wv));
    }

    @Override
    public Lhs<N> toLhs() {
        Vec2 widVal = (Vec2)((SvexQuote)this.width).val;
        int wv = widVal.getVal().intValueExact();
        return this.low.lhsBound(wv).concat(wv, this.high.toLhs());
    }

    @Override
    public Svex.MatchConcat<N> matchConcat() {
        Vec4 wval;
        if (this.width instanceof SvexQuote && (wval = ((SvexQuote)this.width).val).isVec2() && ((Vec2)wval).getVal().signum() >= 0) {
            return new Svex.MatchConcat<N>(((Vec2)wval).getVal().intValueExact(), this.low, this.high);
        }
        return super.matchConcat();
    }

    @Override
    public Svex<N> lhsrewriteAux(SvexManager<N> sm, int shift, int w) {
        int wv;
        Vec4 wval;
        if (this.width instanceof SvexQuote && (wval = ((SvexQuote)this.width).val).isVec2() && (wv = ((Vec2)wval).getVal().intValueExact()) >= 0) {
            if (wv <= shift) {
                Svex<N> Z2 = SvexQuote.Z();
                return Z2.concat(sm, w, this.high.lhsrewriteAux(sm, shift - wv, w));
            }
            if (shift + w <= wv) {
                return this.low.lhsrewriteAux(sm, shift, w);
            }
            Svex<N> newLow = this.low.lhsrewriteAux(sm, shift, wv - shift);
            Svex<N> newHigh = this.high.lhsrewriteAux(sm, 0, shift + w - wv);
            return newLow.concat(sm, wv, newHigh);
        }
        return super.lhsrewriteAux(sm, shift, w);
    }

    @Override
    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        Svex<N> newWidth = this.width.lhsPreproc(sm);
        Svex<N> newLow = this.low.lhsPreproc(sm);
        Svex<N> newHigh = this.high.lhsPreproc(sm);
        return sm.newCall(FUNCTION, newWidth, newLow, newHigh);
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_CONCAT, 3, "4vec-concat");
        }

        public <N extends SvarName> Vec4Concat<N> build(Svex<N>[] args) {
            return new Vec4Concat<N>(args[0], args[1], args[2]);
        }

        @Override
        public <N extends SvarName> Svex<N> callStar(SvexManager<N> sm, Svex<N>[] args) {
            BigInteger wV;
            Vec4 wVal;
            assert (args.length == 3);
            Svex<N> width = args[0];
            if (width instanceof SvexQuote && (wVal = ((SvexQuote)width).val).isVec2() && (wV = ((Vec2)wVal).getVal()).signum() >= 0) {
                return args[1].concat(sm, wV.intValueExact(), args[2]);
            }
            return super.callStar(sm, args);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            int wval;
            Vec4 width = args[0];
            Vec4 l2 = args[1];
            Vec4 h2 = args[2];
            if (width.isVec2() && (wval = ((Vec2)width).getVal().intValueExact()) >= 0) {
                if (l2.isVec2() && h2.isVec2()) {
                    BigInteger lv = ((Vec2)l2).getVal();
                    BigInteger hv = ((Vec2)h2).getVal();
                    if (wval >= 0x1000000 && hv.intValueExact() != (lv.signum() < 0 ? -1 : 0)) {
                        throw new IllegalArgumentException("very large integer");
                    }
                    return Vec2.valueOf(BigIntegerUtil.loghead(wval, lv).or(hv.shiftLeft(wval)));
                }
                if (wval >= 0x1000000) {
                    if (h2.getUpper().intValueExact() != (l2.getUpper().signum() < 0 ? -1 : 0)) {
                        throw new IllegalArgumentException("very large integer");
                    }
                    if (h2.getLower().intValueExact() != (l2.getLower().signum() < 0 ? -1 : 0)) {
                        throw new IllegalArgumentException("very large integer");
                    }
                }
                BigInteger mask = BigIntegerUtil.logheadMask(wval);
                return Vec4.valueOf(l2.getUpper().and(mask).or(h2.getUpper().shiftLeft(wval)), l2.getLower().and(mask).or(h2.getLower().shiftLeft(wval)));
            }
            return Vec4.X;
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            if (mask.signum() == 0) {
                return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO};
            }
            Svex<N> width = args[0];
            Vec4 widthVal = width.xeval(xevalMemoize);
            if (!widthVal.isVec2()) {
                BigInteger argMask = this.maskForGenericSignx(mask);
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, argMask, argMask};
            }
            int widthV = ((Vec2)widthVal).getVal().intValueExact();
            if (widthV < 0) {
                return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigInteger.ZERO, BigInteger.ZERO};
            }
            return new BigInteger[]{BigIntegerUtil.MINUS_ONE, BigIntegerUtil.loghead(widthV, mask), mask.shiftRight(widthV)};
        }
    }
}

