/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarImpl;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import java.util.HashMap;
import java.util.Map;

public class SvexManager<N extends SvarName> {
    Map<SvexCall<N>, SvexCall<N>> svexCalls = new HashMap<SvexCall<N>, SvexCall<N>>();
    Map<N, SvexVar<N>> nondelayedVars = new HashMap<N, SvexVar<N>>();
    Map<Svar<N>, SvexVar<N>> delayedVars = new HashMap<Svar<N>, SvexVar<N>>();

    @SafeVarargs
    public final SvexCall<N> newCall(SvexFunction fun, Svex<N> ... args) {
        SvexCall<N> svex = fun.build(args);
        SvexCall<N> canonic = this.svexCalls.get(svex);
        if (canonic == null) {
            canonic = svex;
            canonic.setOwner(this);
            this.svexCalls.put(svex, canonic);
        }
        return canonic;
    }

    public SvexVar<N> getSvex(N name) {
        SvexVar<N> canonic = this.nondelayedVars.get(name);
        if (canonic == null) {
            SvarImpl<N> svar = new SvarImpl<N>(name, 0);
            canonic = new SvexVar<N>(svar);
            this.nondelayedVars.put(name, canonic);
        }
        return canonic;
    }

    public Svar<N> getVar(N name) {
        return this.getSvex(name).svar;
    }

    N getName(N name) {
        return this.getVar(name).getName();
    }

    public SvexVar<N> getSvex(N name, int delay, boolean isNonblocking) {
        int delayImpl;
        SvexVar<N> canonic = this.getSvex(name);
        int n2 = delayImpl = isNonblocking ? ~delay : delay;
        if (delayImpl == 0) {
            return canonic;
        }
        SvarImpl svar = new SvarImpl(canonic.svar.getName(), delayImpl);
        canonic = this.delayedVars.get(svar);
        if (canonic == null) {
            canonic = new SvexVar(svar);
            this.delayedVars.put(svar, canonic);
        }
        return canonic;
    }

    public SvexVar<N> getSvex(Svar<N> svar) {
        return this.getSvex(svar.getName(), svar.getDelay(), svar.isNonblocking());
    }

    public Svar<N> getVar(N name, int delay, boolean isNonblocking) {
        return this.getSvex(name, (int)delay, (boolean)isNonblocking).svar;
    }
}

