/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex;

import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4SignExt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ZeroExt;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class Svex<N extends SvarName>
implements ACL2Backed {
    public static <N extends SvarName> Svex<N> fromACL2(SvarName.Builder<N> snb, SvexManager<N> sm, ACL2Object impl, Map<ACL2Object, Svex<N>> cache) {
        Svex<N> svex;
        Svex<N> svex2 = svex = cache != null ? cache.get(impl) : null;
        if (svex != null) {
            return svex;
        }
        if (ACL2.consp(impl).bool()) {
            ACL2Object fn = ACL2.car(impl);
            ACL2Object args = ACL2.cdr(impl);
            if (Svar.KEYWORD_VAR.equals(fn)) {
                Util.check(ACL2.car(impl).equals(Util.KEYWORD_VAR));
                ACL2Object nameImpl = ACL2.car(ACL2.cdr(impl));
                int delayImpl = ACL2.cdr(ACL2.cdr(impl)).intValueExact();
                N name = snb.fromACL2(nameImpl);
                boolean isNonblocking = delayImpl < 0;
                int delay = isNonblocking ? ~delayImpl : delayImpl;
                svex = sm.getSvex(name, delay, isNonblocking);
            } else if (fn.equals(ACL2.QUOTE)) {
                if (ACL2.NIL.equals(ACL2.cdr(args)) && ACL2.consp(ACL2.car(args)).bool()) {
                    svex = SvexQuote.valueOf(Vec4.fromACL2(ACL2.car(args)));
                }
            } else {
                int n2 = 0;
                ACL2Object as = args;
                while (ACL2.consp(as).bool()) {
                    ++n2;
                    as = ACL2.cdr(as);
                }
                Svex<N>[] argsArray = Svex.newSvexArray(n2);
                for (n2 = 0; n2 < argsArray.length; ++n2) {
                    if (!ACL2.consp(args).bool()) {
                        throw new IllegalArgumentException();
                    }
                    argsArray[n2] = Svex.fromACL2(snb, sm, ACL2.car(args), cache);
                    args = ACL2.cdr(args);
                }
                Util.checkNil(args);
                SvexFunction fun = SvexFunction.valueOf(fn, argsArray.length);
                svex = sm.newCall(fun, argsArray);
            }
        } else if (ACL2.stringp(impl).bool() || ACL2.symbolp(impl).bool()) {
            N name = snb.fromACL2(impl);
            svex = sm.getSvex(name);
        } else if (ACL2.integerp(impl).bool()) {
            svex = SvexQuote.valueOf(impl.bigIntegerValueExact());
        }
        if (svex != null) {
            if (cache != null) {
                cache.put(impl, svex);
            }
            return svex;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("svex(");
        Map<Svar<N>, BigInteger> varsWithMasks = this.collectVarsWithMasks(BigIntegerUtil.MINUS_ONE, false);
        boolean first = true;
        for (Map.Entry<Svar<N>, BigInteger> e2 : varsWithMasks.entrySet()) {
            Svar<N> svar = e2.getKey();
            BigInteger mask = e2.getValue();
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(svar.toString(mask));
        }
        sb.append(")");
        return sb.toString();
    }

    public static <N extends SvarName> Svex<N>[] newSvexArray(int length) {
        return new Svex[length];
    }

    public abstract <N1 extends SvarName> Svex<N1> convertVars(Function<N, N1> var1, SvexManager<N1> var2, Map<Svex<N>, Svex<N1>> var3);

    public abstract Svex<N> addDelay(int var1, SvexManager<N> var2, Map<Svex<N>, Svex<N>> var3);

    public List<Svar<N>> collectVars() {
        Set<Svar<N>> varsRev = this.collectVarsRev();
        Svar<N>[] varsArr = Svar.newSvarArray(varsRev.size());
        int i2 = varsArr.length;
        for (Svar<N> svar : varsRev) {
            varsArr[--i2] = svar;
        }
        assert (i2 == 0);
        return Arrays.asList(varsArr);
    }

    public Set<Svar<N>> collectVarsRev() {
        LinkedHashSet<Svar<N>> result = new LinkedHashSet<Svar<N>>();
        HashSet<SvexCall<N>> visited = new HashSet<SvexCall<N>>();
        this.collectVarsRev(result, visited);
        return result;
    }

    public static <N extends SvarName> Set<Svar<N>> collectVarsRev(Collection<Svex<N>> exprs) {
        LinkedHashSet<Svar<N>> result = new LinkedHashSet<Svar<N>>();
        HashSet<SvexCall<N>> visited = new HashSet<SvexCall<N>>();
        for (Svex<N> svex : exprs) {
            svex.collectVarsRev(result, visited);
        }
        return result;
    }

    protected abstract void collectVarsRev(Set<Svar<N>> var1, Set<SvexCall<N>> var2);

    public abstract <R, D> R accept(Visitor<N, R, D> var1, D var2);

    public <R> R traverse(TraverseVisitor<N, R> visitor) {
        return this.traverse(visitor, new HashMap());
    }

    abstract <R> R traverse(TraverseVisitor<N, R> var1, Map<Svex<N>, R> var2);

    public Vec4 eval(final Map<Svar<N>, Vec4> env) {
        TraverseVisitor visitor = new TraverseVisitor<N, Vec4>(){
            final /* synthetic */ Svex this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Vec4 visitQuote(Vec4 val) {
                return val;
            }

            @Override
            public Vec4 visitVar(Svar<N> svar) {
                Vec4 val = (Vec4)env.get(svar);
                return val != null ? val : Vec4.X;
            }

            public Vec4 visitCall(SvexFunction fun, Svex<N>[] args, Vec4[] argVals) {
                return fun.apply(argVals);
            }

            public Vec4[] newVals(int arity) {
                return new Vec4[arity];
            }
        };
        return (Vec4)this.traverse(visitor);
    }

    public abstract Vec4 xeval(Map<Svex<N>, Vec4> var1);

    public static <N extends SvarName> Vec4[] listXeval(Svex<N>[] list, Map<Svex<N>, Vec4> memoize) {
        Vec4[] result = new Vec4[list.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = list[i2].xeval(memoize);
        }
        return result;
    }

    void toposort(Set<Svex<N>> downTop) {
        downTop.add(this);
    }

    public Svex<N>[] toposort() {
        LinkedHashSet<Svex<N>> downTop = new LinkedHashSet<Svex<N>>();
        this.toposort(downTop);
        Svex<N>[] topDown = Svex.newSvexArray(downTop.size());
        int i2 = topDown.length;
        for (Svex svex : downTop) {
            topDown[--i2] = svex;
        }
        assert (i2 == 0);
        return topDown;
    }

    public static <N extends SvarName> Svex<N>[] listToposort(Collection<Svex<N>> list) {
        LinkedHashSet<Svex<N>> downTop = new LinkedHashSet<Svex<N>>();
        for (Svex<N> svex : list) {
            if (svex == null) {
                throw new NullPointerException();
            }
            svex.toposort(downTop);
        }
        Svex<N>[] topDown = Svex.newSvexArray(downTop.size());
        int i2 = topDown.length;
        for (Svex svex : downTop) {
            topDown[--i2] = svex;
        }
        assert (i2 == 0);
        return topDown;
    }

    private static <N extends SvarName> void svexArgsApplyMasks(Svex<N>[] args, BigInteger[] masks, Map<Svex<N>, BigInteger> maskMap) {
        if (args.length != masks.length) {
            throw new IllegalArgumentException();
        }
        for (int i2 = args.length - 1; i2 >= 0; --i2) {
            if (masks[i2].signum() == 0) continue;
            BigInteger look = maskMap.get(args[i2]);
            maskMap.put(args[i2], look == null ? masks[i2] : look.or(masks[i2]));
        }
    }

    private static <N extends SvarName> void listComputeMasks(Svex<N>[] x, Map<Svex<N>, BigInteger> maskMap) {
        for (Svex<N> svex : x) {
            SvexCall sc;
            BigInteger mask;
            if (!(svex instanceof SvexCall) || (mask = maskMap.get(sc = (SvexCall)svex)) == null || mask.signum() == 0) continue;
            BigInteger[] argmasks = sc.fun.argmasks(mask, sc.args);
            Svex.svexArgsApplyMasks(sc.args, argmasks, maskMap);
        }
    }

    public Map<Svex<N>, BigInteger> maskAlist(BigInteger mask) {
        Svex<N>[] toposort = this.toposort();
        HashMap<Svex<N>, BigInteger> maskMap = new HashMap<Svex<N>, BigInteger>();
        maskMap.put(this, mask);
        Svex.listComputeMasks(toposort, maskMap);
        return maskMap;
    }

    public Map<Svar<N>, BigInteger> collectVarsWithMasks(BigInteger mask, boolean omitNulls) {
        List<Svar<N>> vars = this.collectVars();
        Map<Svex<N>, BigInteger> maskAl = this.maskAlist(mask);
        LinkedHashMap<Svar<N>, BigInteger> result = new LinkedHashMap<Svar<N>, BigInteger>();
        for (Svar<N> var : vars) {
            SvexVar<N> svv = new SvexVar<N>(var);
            BigInteger varMask = maskAl.get(svv);
            if (omitNulls && varMask == null) continue;
            result.put(var, varMask);
        }
        return result;
    }

    public static <N extends SvarName> Map<Svex<N>, BigInteger> listMaskAlist(Collection<Svex<N>> list) {
        Svex<N>[] toposort = Svex.listToposort(list);
        HashMap<Svex<N>, BigInteger> maskMap = new HashMap<Svex<N>, BigInteger>();
        for (Svex<N> svex : list) {
            maskMap.put(svex, BigIntegerUtil.MINUS_ONE);
        }
        Svex.listComputeMasks(toposort, maskMap);
        return maskMap;
    }

    public abstract Svex<N> patch(Map<Svar<N>, Vec4> var1, SvexManager<N> var2, Map<SvexCall<N>, SvexCall<N>> var3);

    public abstract boolean isLhsUnbounded();

    public abstract boolean isLhs();

    public abstract Lhs<N> lhsBound(int var1);

    public abstract Lhs<N> toLhs();

    public MatchConcat<N> matchConcat() {
        return null;
    }

    public MatchExt<N> matchExt() {
        return null;
    }

    public MatchRsh<N> matchRsh() {
        return null;
    }

    public Svex<N> rsh(SvexManager<N> sm, int sh) {
        if (sh <= 0) {
            if (sh == 0) {
                return this;
            }
            throw new IllegalArgumentException();
        }
        if (this instanceof SvexQuote) {
            return SvexQuote.valueOf(Vec4Rsh.FUNCTION.apply(Vec2.valueOf(sh), ((SvexQuote)this).val));
        }
        MatchRsh<N> matchRsh = this.matchRsh();
        if (matchRsh != null) {
            Svex shift = SvexQuote.valueOf(matchRsh.width + sh);
            Svex<N>[] newArgs = Svex.newSvexArray(2);
            newArgs[0] = shift;
            newArgs[1] = matchRsh.subexp;
            return sm.newCall(Vec4Rsh.FUNCTION, newArgs);
        }
        MatchConcat<N> matchConcat = this.matchConcat();
        if (matchConcat != null && sh >= matchConcat.width) {
            return matchConcat.msbs.rsh(sm, sh - matchConcat.width);
        }
        MatchExt<N> matchExt = this.matchExt();
        if (matchExt != null && sh >= matchExt.width && !matchExt.signExtend) {
            return SvexQuote.valueOf(0);
        }
        Svex shift = SvexQuote.valueOf(sh);
        Svex<N>[] newArgs = Svex.newSvexArray(2);
        newArgs[0] = shift;
        newArgs[1] = this;
        return sm.newCall(Vec4Rsh.FUNCTION, newArgs);
    }

    public Svex<N> concat(SvexManager<N> sm, int w, Svex<N> y) {
        if (w <= 0) {
            if (w == 0) {
                return y;
            }
            throw new IllegalArgumentException();
        }
        if (this instanceof SvexQuote && y instanceof SvexQuote) {
            Vec4 val = Vec4Concat.FUNCTION.apply(Vec2.valueOf(w), ((SvexQuote)this).val, ((SvexQuote)y).val);
            return SvexQuote.valueOf(val);
        }
        MatchConcat<N> matchConcat = this.matchConcat();
        if (matchConcat != null && w <= matchConcat.width) {
            return matchConcat.lsbs.concat(sm, w, y);
        }
        MatchExt<N> matchExt = this.matchExt();
        if (matchExt != null && w <= matchExt.width) {
            return matchExt.lsbs.concat(sm, w, y);
        }
        if (!(this instanceof SvexQuote)) {
            Svex width = SvexQuote.valueOf(w);
            Svex<N>[] newArgs = Svex.newSvexArray(3);
            newArgs[0] = width;
            newArgs[1] = this;
            newArgs[2] = y;
            return sm.newCall(Vec4Concat.FUNCTION, newArgs);
        }
        MatchConcat<N> matchConcatY = y.matchConcat();
        if (matchConcatY != null && matchConcatY.lsbs instanceof SvexQuote) {
            Vec4 lsbVal = Vec4Concat.FUNCTION.apply(Vec2.valueOf(w), ((SvexQuote)this).val, ((SvexQuote)matchConcatY.lsbs).val);
            Svex<N> newLsb = SvexQuote.valueOf(lsbVal);
            return newLsb.concat(sm, w + matchConcatY.width, matchConcatY.msbs);
        }
        Svex width = SvexQuote.valueOf(w);
        Svex<N>[] newArgs = Svex.newSvexArray(3);
        newArgs[0] = width;
        newArgs[1] = this;
        newArgs[2] = y;
        return sm.newCall(Vec4Concat.FUNCTION, newArgs);
    }

    public Svex<N> zerox(SvexManager<N> sm, int w) {
        if (w <= 0) {
            if (w == 0) {
                return SvexQuote.valueOf(0);
            }
            throw new IllegalArgumentException();
        }
        if (this instanceof SvexQuote) {
            Vec4 val = Vec4ZeroExt.FUNCTION.apply(Vec2.valueOf(w), ((SvexQuote)this).val);
            return SvexQuote.valueOf(val);
        }
        MatchConcat<N> matchConcat = this.matchConcat();
        if (matchConcat != null && w <= matchConcat.width) {
            return matchConcat.lsbs.zerox(sm, w);
        }
        MatchExt<N> matchExt = this.matchExt();
        if (matchExt != null && w <= matchExt.width) {
            return matchExt.lsbs.zerox(sm, w);
        }
        Svex width = SvexQuote.valueOf(w);
        Svex<N>[] newArgs = Svex.newSvexArray(2);
        newArgs[0] = width;
        newArgs[1] = this;
        return sm.newCall(Vec4ZeroExt.FUNCTION, newArgs);
    }

    public Svex<N> signx(SvexManager<N> sm, int w) {
        if (w <= 0) {
            if (w == 0) {
                return SvexQuote.X();
            }
            throw new IllegalArgumentException();
        }
        if (this instanceof SvexQuote) {
            Vec4 val = Vec4SignExt.FUNCTION.apply(Vec2.valueOf(w), ((SvexQuote)this).val);
            return SvexQuote.valueOf(val);
        }
        MatchConcat<N> matchConcat = this.matchConcat();
        if (matchConcat != null && w <= matchConcat.width) {
            return matchConcat.lsbs.signx(sm, w);
        }
        MatchExt<N> matchExt = this.matchExt();
        if (matchExt != null) {
            if (w <= matchExt.width) {
                return matchExt.lsbs.signx(sm, w);
            }
            if (matchExt.signExtend) {
                return matchExt.lsbs.signx(sm, matchExt.width);
            }
            return matchExt.lsbs.zerox(sm, matchExt.width);
        }
        Svex width = SvexQuote.valueOf(w);
        Svex<N>[] newArgs = Svex.newSvexArray(2);
        newArgs[0] = width;
        newArgs[1] = this;
        return sm.newCall(Vec4SignExt.FUNCTION, newArgs);
    }

    public Svex<N> lhsrewriteAux(SvexManager<N> sm, int shift, int w) {
        return this;
    }

    public Svex<N> lhsPreproc(SvexManager<N> sm) {
        return this;
    }

    public Svex<N> lhsRewrite(SvexManager<N> sm, int width) {
        return this.lhsPreproc(sm).lhsrewriteAux(sm, 0, width);
    }

    void multirefs(Set<SvexCall<N>> seen, Set<SvexCall<N>> multirefs) {
    }

    public Set<SvexCall<N>> multirefs() {
        return Svex.multirefs(Collections.singleton(this));
    }

    public static <N extends SvarName> Set<SvexCall<N>> multirefs(Collection<Svex<N>> list) {
        HashSet<SvexCall<N>> seen = new HashSet<SvexCall<N>>();
        LinkedHashSet<SvexCall<N>> multirefs = new LinkedHashSet<SvexCall<N>>();
        for (Svex<N> svex : list) {
            svex.multirefs(seen, multirefs);
        }
        ArrayList multirefsList = new ArrayList(multirefs);
        multirefs.clear();
        for (int i2 = multirefsList.size() - 1; i2 >= 0; --i2) {
            multirefs.add((SvexCall)multirefsList.get(i2));
        }
        return multirefs;
    }

    public static interface TraverseVisitor<N extends SvarName, R> {
        public R visitQuote(Vec4 var1);

        public R visitVar(Svar<N> var1);

        public R visitCall(SvexFunction var1, Svex<N>[] var2, R[] var3);

        public R[] newVals(int var1);
    }

    public static class MatchRsh<N extends SvarName> {
        final int width;
        final Svex<N> subexp;

        public MatchRsh(int width, Svex<N> subexp) {
            this.width = width;
            this.subexp = subexp;
        }
    }

    public static class MatchConcat<N extends SvarName> {
        final int width;
        final Svex<N> lsbs;
        final Svex<N> msbs;

        public MatchConcat(int width, Svex<N> lsbs, Svex<N> msbs) {
            this.width = width;
            this.lsbs = lsbs;
            this.msbs = msbs;
        }
    }

    public static class MatchExt<N extends SvarName> {
        final int width;
        final Svex<N> lsbs;
        final boolean signExtend;

        public MatchExt(int width, Svex<N> lsbs, boolean signExtend) {
            this.width = width;
            this.lsbs = lsbs;
            this.signExtend = signExtend;
        }
    }

    public static interface Visitor<N extends SvarName, R, P> {
        public R visitConst(Vec4 var1, P var2);

        public R visitVar(Svar<N> var1, P var2);

        public R visitCall(SvexFunction var1, Svex<N>[] var2, P var3);
    }
}

