/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExplore;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.ParameterizedModule;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TutorialHints
implements DesignHints {
    @Override
    public List<ParameterizedModule> getParameterizedModules() {
        List<ParameterizedModule> result = ParameterizedModule.getStandardModules();
        result.addAll(Arrays.asList(new Flop(), new BoothFlop()));
        return result;
    }

    @Override
    public String getGlobalClock() {
        return "clk";
    }

    @Override
    public String[] getExportNames(ModName modName) {
        switch (modName.toString()) {
            case "alu16": {
                return new String[]{"out", "opcode", "abus", "bbus", "clk"};
            }
            case "boothpipe": {
                return new String[]{"o", "a", "b", "en", "clk"};
            }
        }
        return null;
    }

    @Override
    public String[] getPortInstancesToSplit(ModName modName) {
        return null;
    }

    @Override
    public int[] getDriversToSplit(ModName modName) {
        return null;
    }

    @Override
    public void testSvtv(ModName modName, Map<Svar<Address>, Svex<Address>> updates, Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, SvexManager<Address> sm) {
        switch (modName.toString()) {
            case "counter": {
                this.testCounter(svtvOutExprs, svtvNextStates, sm);
                break;
            }
            case "alu16": {
                this.testAlu16(svtvOutExprs, svtvNextStates, sm);
                break;
            }
            case "boothenc": {
                this.testBoothenc(svtvOutExprs, svtvNextStates, sm);
                break;
            }
            case "boothpipe": {
                this.testBoothpipe(svtvOutExprs, svtvNextStates, sm);
                break;
            }
            default: {
                System.out.println("Can't test " + String.valueOf(modName));
            }
        }
    }

    private static void check(boolean p) {
        if (!p) {
            throw new AssertionError();
        }
    }

    public static int counter$count(CounterState st) {
        TutorialHints.check(st.countValid);
        return st.count;
    }

    public static void counter$nextState(CounterState prev, CounterState next, int reset, boolean resetValid, int incr, boolean incrValid) {
        next.invalidate();
        if (resetValid) {
            assert (reset >>> 1 == 0);
            if (reset != 0) {
                next.setStage1(0);
            } else if (prev.countValid && incrValid) {
                assert (prev.count >>> 4 == 0);
                assert (incr >>> 1 == 0);
                int tmpcount = prev.count + incr & 0xF;
                next.setStage1(tmpcount == 10 ? 0 : tmpcount);
            }
        }
    }

    public void testCounter(Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, SvexManager<Address> sm) {
        CounterState state = new CounterState();
        for (int count = 0; count < 16; ++count) {
            state.setStage1(count);
            this.testCounter(sm, svtvOutExprs, svtvNextStates, state, 0, 0);
            this.testCounter(sm, svtvOutExprs, svtvNextStates, state, 0, 1);
            this.testCounter(sm, svtvOutExprs, svtvNextStates, state, 1, 0);
            this.testCounter(sm, svtvOutExprs, svtvNextStates, state, 1, 1);
        }
    }

    private void testCounter(SvexManager<Address> sm, Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, CounterState state, int reset, int incr) {
        HashMap<Svar<Address>, Vec4> env = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedOut = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedState = new HashMap<Svar<Address>, Vec4>();
        if (state.countValid) {
            DesignHints.putState(sm, env, "count", state.count, 4);
        }
        DesignHints.putEnv(sm, env, "reset", reset);
        DesignHints.putEnv(sm, env, "incr", incr);
        DesignHints.putEnv(sm, expectedOut, "count", TutorialHints.counter$count(state));
        CounterState nextState = new CounterState();
        TutorialHints.counter$nextState(state, nextState, reset, true, incr, true);
        if (nextState.countValid) {
            DesignHints.putState(sm, expectedState, "count", nextState.count, 4);
        }
        DesignHints.test(sm, "clk", null, svtvOutExprs, svtvNextStates, env, expectedOut, expectedState);
    }

    public static int alu16$out(Alu16State st) {
        TutorialHints.check(st.validStage2);
        return st.out & 0xFFFF;
    }

    public static void alu16$nextState(Alu16State prev, Alu16State next, int opcode, boolean opcodeValid, int abus, boolean abusValid, int bbus, boolean bbusValid) {
        next.invalidate();
        if (abusValid && bbusValid) {
            assert (abus >>> 16 == 0);
            assert (bbus >>> 16 == 0);
            next.setStage1(abus, bbus);
        }
        if (prev.validStage1 && opcodeValid) {
            int abus1 = prev.abus1 & 0xFFFF;
            int bbus1 = prev.bbus1 & 0xFFFF;
            next.setStage2(switch (opcode) {
                case 0 -> {
                    int ans_plus;
                    yield ans_plus = abus1 + bbus1 & 0xFFFF;
                }
                case 1 -> {
                    int ans_minus;
                    yield ans_minus = abus1 - bbus1 & 0xFFFF;
                }
                case 2 -> {
                    int ans_bitand;
                    yield ans_bitand = abus1 & bbus1;
                }
                case 3 -> {
                    int ans_bitor;
                    yield ans_bitor = abus1 | bbus1;
                }
                case 4 -> {
                    int ans_bitxor;
                    yield ans_bitxor = abus1 ^ bbus1;
                }
                case 5 -> {
                    int ans_min;
                    yield ans_min = Math.min(abus1, bbus1);
                }
                case 6 -> {
                    int ans_count;
                    yield ans_count = Integer.bitCount(abus1 & 0xFF7F) + Integer.bitCount(abus1 & 8);
                }
                case 7 -> {
                    int ans_mult;
                    yield ans_mult = abus1 * bbus1 & 0xFFFF;
                }
                default -> throw new AssertionError();
            });
        }
    }

    public void testAlu16(Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, SvexManager<Address> sm) {
        int[] testVals;
        Alu16State state0 = new Alu16State();
        Alu16State state1 = new Alu16State();
        Alu16State state2 = new Alu16State();
        for (int abus : testVals = new int[]{0, 1, 65535, 5, 128, 8, 136}) {
            for (int bbus : testVals) {
                state0.invalidate();
                state0.setStage1(abus, bbus);
                for (int opcode = 0; opcode < 8; ++opcode) {
                    this.testAlu16(sm, svtvOutExprs, svtvNextStates, state0, 7 - opcode, abus, bbus);
                    TutorialHints.alu16$nextState(state0, state1, 7 - opcode, true, abus, true, bbus, true);
                    this.testAlu16(sm, svtvOutExprs, svtvNextStates, state1, opcode, bbus, abus);
                    TutorialHints.alu16$nextState(state1, state2, 7 - opcode, true, abus, true, bbus, true);
                    this.testAlu16(sm, svtvOutExprs, svtvNextStates, state2, 0, 0, 0);
                }
            }
        }
    }

    private void testAlu16(SvexManager<Address> sm, Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, Alu16State state, int opcodeVal, int abusVal, int bbusVal) {
        HashMap<Svar<Address>, Vec4> env = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedOut = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedState = new HashMap<Svar<Address>, Vec4>();
        if (state.validStage1) {
            DesignHints.putState(sm, env, "abus1", state.abus1 & 0xFFFF, 16);
            DesignHints.putState(sm, env, "bbus1", state.bbus1 & 0xFFFF, 16);
        }
        if (state.validStage2) {
            DesignHints.putState(sm, env, "out", state.out & 0xFFFF, 16);
        }
        DesignHints.putEnv(sm, env, "opcode", opcodeVal);
        DesignHints.putEnv(sm, env, "abus", abusVal);
        DesignHints.putEnv(sm, env, "bbus", bbusVal);
        if (state.validStage2) {
            DesignHints.putEnv(sm, expectedOut, "out", TutorialHints.alu16$out(state));
        }
        Alu16State nextState = new Alu16State();
        TutorialHints.alu16$nextState(state, nextState, opcodeVal, true, abusVal, true, bbusVal, true);
        if (nextState.validStage1) {
            DesignHints.putState(sm, expectedState, "abus1", nextState.abus1 & 0xFFFF, 16);
            DesignHints.putState(sm, expectedState, "bbus1", nextState.bbus1 & 0xFFFF, 16);
        }
        if (nextState.validStage2) {
            DesignHints.putState(sm, expectedState, "out", nextState.out & 0xFFFF, 16);
        }
        DesignHints.test(sm, "clk", null, svtvOutExprs, svtvNextStates, env, expectedOut, expectedState);
    }

    int boothenc$ppImpl(int abits, int b2, int minusb) {
        assert (abits >>> 3 == 0);
        assert (b2 >>> 16 == 0);
        assert (minusb >>> 17 == 0);
        int abit0 = abits & 1;
        int abit1 = abits >> 1 & 1;
        int abit2 = abits >> 2 & 1;
        int bsign = abit2 != 0 ? minusb : b2 << 16 >> 16 & 0x1FFFF;
        int shft = ~(abit0 ^ abit1) & 1;
        int zro = shft & ~(abit2 ^ abit1);
        int res1 = zro != 0 ? 0 : bsign;
        return shft != 0 ? res1 << 1 : res1 << 15 >> 15 & 0x3FFFF;
    }

    public static int boothenc$pp(int abits, int b2, int minusb) {
        assert (abits >>> 3 == 0);
        assert (b2 >>> 16 == 0);
        assert (minusb >>> 17 == 0);
        b2 = b2 << 16 >> 16;
        assert (minusb == (-b2 & 0x1FFFF));
        int abit0 = abits & 1;
        int abit1 = abits >> 1 & 1;
        int abit2 = abits >> 2 & 1;
        int enc = abit0 + abit1 - 2 * abit2;
        return enc * b2 & 0x3FFFF;
    }

    public void testBoothenc(Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, SvexManager<Address> sm) {
        int[] bVals;
        for (int b2 : bVals = new int[]{0, 1, 65535, 5, 128, 8, 136}) {
            int minusb = -(b2 << 16 >> 16) & 0x1FFFF;
            for (int abits = 0; abits < 8; ++abits) {
                this.testBoothenc(sm, svtvOutExprs, svtvNextStates, abits, b2, minusb);
            }
        }
    }

    private void testBoothenc(SvexManager<Address> sm, Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, int abits, int b2, int minusb) {
        HashMap<Svar<Address>, Vec4> env = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedOut = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedState = new HashMap<Svar<Address>, Vec4>();
        DesignHints.putEnv(sm, env, "abits", abits);
        DesignHints.putEnv(sm, env, "b", b2);
        DesignHints.putEnv(sm, env, "minusb", minusb);
        DesignHints.putEnv(sm, expectedOut, "pp", TutorialHints.boothenc$pp(abits, b2, minusb));
        DesignHints.test(sm, "clk", null, svtvOutExprs, svtvNextStates, env, expectedOut, expectedState);
    }

    public static int boothpipe$o(BoothpipeState st) {
        TutorialHints.check(st.validStage3);
        return st.o;
    }

    public static void boothpipe$nextState(BoothpipeState prev, BoothpipeState next, int a2, boolean aValid, int b2, boolean bValid, int en, boolean enValid) {
        next.invalidate();
        if (!enValid) {
            return;
        }
        assert (en >>> 1 == 0);
        if (en == 0) {
            if (prev.validStage1) {
                next.setStage1(prev.a_c1 & 0xFFFF, prev.b_c1 & 0xFFFF);
            }
            if (prev.validStage2) {
                next.setStage2(prev.pp01_c2, prev.pp23_c2, prev.pp45_c2, prev.pp67_c2);
            }
            if (prev.validStage3) {
                next.setStage3(prev.o);
            }
            return;
        }
        if (aValid && bValid) {
            assert (a2 >>> 16 == 0);
            assert (b2 >>> 16 == 0);
            next.setStage1(a2, b2);
        }
        if (prev.validStage1) {
            int a_c1 = prev.a_c1 & 0xFFFF;
            int b_c1 = prev.b_c1 & 0xFFFF;
            int minusb = -(b_c1 << 16 >> 16) & 0x1FFFF;
            int pp0 = TutorialHints.boothenc$pp(a_c1 << 1 & 7, b_c1, minusb);
            int pp1 = TutorialHints.boothenc$pp(a_c1 >> 1 & 7, b_c1, minusb);
            int pp2 = TutorialHints.boothenc$pp(a_c1 >> 3 & 7, b_c1, minusb);
            int pp3 = TutorialHints.boothenc$pp(a_c1 >> 5 & 7, b_c1, minusb);
            int pp4 = TutorialHints.boothenc$pp(a_c1 >> 7 & 7, b_c1, minusb);
            int pp5 = TutorialHints.boothenc$pp(a_c1 >> 9 & 7, b_c1, minusb);
            int pp6 = TutorialHints.boothenc$pp(a_c1 >> 11 & 7, b_c1, minusb);
            int pp7 = TutorialHints.boothenc$pp(a_c1 >> 13 & 7, b_c1, minusb);
            long pp01_c2 = (long)pp0 << 18 | (long)pp1;
            long pp23_c2 = (long)pp2 << 18 | (long)pp3;
            long pp45_c2 = (long)pp4 << 18 | (long)pp5;
            long pp67_c2 = (long)pp6 << 18 | (long)pp7;
            next.setStage2(pp01_c2, pp23_c2, pp45_c2, pp67_c2);
        }
        if (prev.validStage2) {
            int s7;
            long pp01_c2b = (prev.pp01_c2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFL;
            long pp23_c2b = (prev.pp23_c2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFL;
            long pp45_c2b = (prev.pp45_c2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFL;
            long pp67_c2b = (prev.pp67_c2 ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFL;
            int pp0_c2 = ~((int)(pp01_c2b >> 18)) & 0x3FFFF;
            int pp1_c2 = ~((int)pp01_c2b) & 0x3FFFF;
            int pp2_c2 = ~((int)(pp23_c2b >> 18)) & 0x3FFFF;
            int pp3_c2 = ~((int)pp23_c2b) & 0x3FFFF;
            int pp4_c2 = ~((int)(pp45_c2b >> 18)) & 0x3FFFF;
            int pp5_c2 = ~((int)pp45_c2b) & 0x3FFFF;
            int pp6_c2 = ~((int)(pp67_c2b >> 18)) & 0x3FFFF;
            int pp7_c2 = ~((int)pp67_c2b) & 0x3FFFF;
            int s0 = pp0_c2 << 14 >> 14;
            int s1 = s0 + (pp1_c2 << 14 >> 12);
            int s2 = s1 + (pp2_c2 << 14 >> 10);
            int s3 = s2 + (pp3_c2 << 14 >> 8);
            int s4 = s3 + (pp4_c2 << 14 >> 6);
            int s5 = s4 + (pp5_c2 << 14 >> 4);
            int s6 = s5 + (pp6_c2 << 14 >> 2);
            int o2 = s7 = s6 + (pp7_c2 << 14);
            next.setStage3(o2);
        } else {
            next.validStage3 = false;
        }
    }

    public void testBoothpipe(Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, SvexManager<Address> sm) {
        int[] testVals;
        BoothpipeState state0 = new BoothpipeState();
        BoothpipeState state1 = new BoothpipeState();
        BoothpipeState state2 = new BoothpipeState();
        BoothpipeState state3 = new BoothpipeState();
        BoothpipeState state4 = new BoothpipeState();
        for (int a2 : testVals = new int[]{0, 1, 5100, 128, 8, 136, 32768, 49232, 65535}) {
            for (int b2 : testVals) {
                state0.invalidate();
                state0.setStage1(a2, b2);
                this.testBoothpipe(sm, svtvOutExprs, svtvNextStates, state0, a2, b2, 1);
                TutorialHints.boothpipe$nextState(state0, state1, a2, true, b2, true, 1, true);
                this.testBoothpipe(sm, svtvOutExprs, svtvNextStates, state1, 0, 0, 1);
                TutorialHints.boothpipe$nextState(state1, state2, 0, true, 0, true, 1, true);
                this.testBoothpipe(sm, svtvOutExprs, svtvNextStates, state2, 0, 0, 1);
                TutorialHints.boothpipe$nextState(state2, state3, 0, true, 0, true, 1, true);
                this.testBoothpipe(sm, svtvOutExprs, svtvNextStates, state3, 0, 0, 1);
                TutorialHints.boothpipe$nextState(state3, state4, 0, true, 0, true, 0, true);
                this.testBoothpipe(sm, svtvOutExprs, svtvNextStates, state4, 0, 0, 0);
            }
        }
    }

    private void testBoothpipe(SvexManager<Address> sm, Map<Svar<Address>, Svex<Address>> svtvOutExprs, Map<Svar<Address>, Svex<Address>> svtvNextStates, BoothpipeState state, int a2, int b2, int en) {
        HashMap<Svar<Address>, Vec4> env = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedOut = new HashMap<Svar<Address>, Vec4>();
        HashMap<Svar<Address>, Vec4> expectedState = new HashMap<Svar<Address>, Vec4>();
        if (state.validStage1) {
            DesignHints.putState(sm, env, "a_c1", state.a_c1 & 0xFFFF, 16);
            DesignHints.putState(sm, env, "b_c1", state.b_c1 & 0xFFFF, 16);
        }
        if (state.validStage2) {
            DesignHints.putState(sm, env, "pp01_c2", state.pp01_c2, 36);
            DesignHints.putState(sm, env, "pp23_c2", state.pp23_c2, 36);
            DesignHints.putState(sm, env, "pp45_c2", state.pp45_c2, 36);
            DesignHints.putState(sm, env, "pp67_c2", state.pp67_c2, 36);
        }
        if (state.validStage3) {
            DesignHints.putState(sm, env, "o", (long)state.o & 0xFFFFFFFFL, 32);
        }
        DesignHints.putEnv(sm, env, "a", a2);
        DesignHints.putEnv(sm, env, "b", b2);
        DesignHints.putEnv(sm, env, "en", en);
        if (state.validStage3) {
            DesignHints.putEnv(sm, expectedOut, "o", (long)TutorialHints.boothpipe$o(state) & 0xFFFFFFFFL);
        }
        BoothpipeState nextState = new BoothpipeState();
        TutorialHints.boothpipe$nextState(state, nextState, a2, true, b2, true, en, true);
        if (nextState.validStage1) {
            DesignHints.putState(sm, expectedState, "a_c1", nextState.a_c1 & 0xFFFF, 16);
            DesignHints.putState(sm, expectedState, "b_c1", nextState.b_c1 & 0xFFFF, 16);
        }
        if (nextState.validStage2) {
            DesignHints.putState(sm, expectedState, "pp01_c2", nextState.pp01_c2, 36);
            DesignHints.putState(sm, expectedState, "pp23_c2", nextState.pp23_c2, 36);
            DesignHints.putState(sm, expectedState, "pp45_c2", nextState.pp45_c2, 36);
            DesignHints.putState(sm, expectedState, "pp67_c2", nextState.pp67_c2, 36);
        }
        if (nextState.validStage3) {
            DesignHints.putState(sm, expectedState, "o", (long)nextState.o & 0xFFFFFFFFL, 32);
        }
        DesignHints.test(sm, "clk", null, svtvOutExprs, svtvNextStates, env, expectedOut, expectedState);
    }

    public static void main(String[] args) {
        new DesignExplore<TutorialHints>(TutorialHints.class).main(args);
    }

    private static class Flop
    extends ParameterizedModule {
        Flop() {
            super("tutorial", "flop");
        }

        @Override
        protected Integer getDefaultInt(String paramName) {
            switch (paramName) {
                case "width": {
                    return 1;
                }
            }
            return null;
        }

        @Override
        protected boolean hasState() {
            return true;
        }

        @Override
        protected Module<Address> genModule() {
            int width = this.getIntParam("width");
            this.output("q", width);
            this.input("d", width);
            this.global("clk", 1);
            this.assign("q", width, this.ite(this.bitand(this.bitnot(this.v("clk", 1)), this.concat(this.q(1), this.v("clk"), this.q(0))), this.concat(this.q(width), this.v("d", 1), this.rsh(this.q(width), this.v("q", 1))), this.v("q", 1)));
            return this.getModule();
        }
    }

    private static class BoothFlop
    extends ParameterizedModule {
        BoothFlop() {
            super("tutorial", "boothflop");
        }

        @Override
        protected Integer getDefaultInt(String paramName) {
            switch (paramName) {
                case "width": {
                    return 1;
                }
            }
            return null;
        }

        @Override
        protected boolean hasState() {
            return true;
        }

        @Override
        protected Module<Address> genModule() {
            int width = this.getIntParam("width");
            this.output("q", width);
            this.input("d", width);
            this.input("clk", 1);
            this.assign("q", width, this.ite(this.bitand(this.bitnot(this.v("clk", 1)), this.concat(this.q(1), this.v("clk"), this.q(0))), this.concat(this.q(width), this.v("d", 1), this.rsh(this.q(width), this.v("q", 1))), this.v("q", 1)));
            return this.getModule();
        }
    }

    public static class CounterState {
        byte count;
        boolean countValid;

        void setStage1(int count) {
            assert (count >>> 4 == 0);
            this.count = (byte)count;
            this.countValid = true;
        }

        void invalidate() {
            this.countValid = false;
        }

        void check() {
            if (this.countValid) assert (this.count >>> 4 == 0);
        }
    }

    public static class Alu16State {
        short abus1;
        short bbus1;
        boolean validStage1;
        short out;
        boolean validStage2;

        void setStage1(int abus1, int bbus1) {
            assert (abus1 >>> 16 == 0);
            assert (bbus1 >>> 16 == 0);
            this.abus1 = (short)abus1;
            this.bbus1 = (short)bbus1;
            this.validStage1 = true;
        }

        void setStage2(int out) {
            assert (out >>> 16 == 0);
            this.out = (short)out;
            this.validStage2 = true;
        }

        void invalidate() {
            this.validStage2 = false;
            this.validStage1 = false;
        }

        void check() {
            if (this.validStage1) {
                assert (this.abus1 >>> 16 == 0);
                assert (this.bbus1 >>> 16 == 0);
            }
            if (this.validStage2) assert (this.out >>> 16 == 0);
        }
    }

    public static class BoothpipeState {
        short a_c1;
        short b_c1;
        boolean validStage1;
        long pp01_c2;
        long pp23_c2;
        long pp45_c2;
        long pp67_c2;
        boolean validStage2;
        int o;
        boolean validStage3;

        void setStage1(int a_c1, int b_c1) {
            assert (a_c1 >>> 16 == 0);
            assert (b_c1 >>> 16 == 0);
            this.a_c1 = (short)a_c1;
            this.b_c1 = (short)b_c1;
            this.validStage1 = true;
        }

        void setStage2(long pp01_c2, long pp23_c2, long pp45_c2, long pp67_c2) {
            assert (pp01_c2 >> 36 == 0L);
            assert (pp23_c2 >> 36 == 0L);
            assert (pp45_c2 >> 36 == 0L);
            assert (pp67_c2 >> 36 == 0L);
            this.pp01_c2 = pp01_c2;
            this.pp23_c2 = pp23_c2;
            this.pp45_c2 = pp45_c2;
            this.pp67_c2 = pp67_c2;
            this.validStage2 = true;
        }

        void setStage3(int o2) {
            this.o = o2;
            this.validStage3 = true;
        }

        void invalidate() {
            this.validStage3 = false;
            this.validStage2 = false;
            this.validStage1 = false;
        }

        void check() {
            if (this.validStage1) {
                assert (this.a_c1 >>> 16 == 0);
                assert (this.b_c1 >>> 16 == 0);
            }
            if (this.validStage2) {
                assert (this.pp01_c2 >>> 36 == 0L);
                assert (this.pp23_c2 >>> 36 == 0L);
                assert (this.pp45_c2 >>> 36 == 0L);
                assert (this.pp67_c2 >>> 36 == 0L);
            }
            if (this.validStage3) {
                // empty if block
            }
        }
    }
}

