/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.ElabMod;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.ACL2DesignJobs;
import com.sun.electric.tool.simulation.acl2.modsext.Compile;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExt;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.GenFsmNew;
import com.sun.electric.tool.simulation.acl2.modsext.ModExport;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarImpl;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.SvarNameTexter;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Reader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TraceSvtvJobs {
    private static final ACL2Object KEYWORD_PHASE = ACL2Object.valueOf("KEYWORD", "PHASE");

    public static <H extends DesignHints> void makeTraceSvtv(Class<H> cls, File saoFile, String designName) {
        new MakeTraceSvtvJob<H>(cls, saoFile, designName).startJob();
    }

    public static <H extends DesignHints> void readTraceSvtv(Class<H> cls, File saoFile) {
        new ReadTraceSvtvJob<H>(cls, saoFile).startJob();
    }

    public static <H extends DesignHints> void testTraceSvtv(Class<H> cls, File saoFile) {
        new TestTraceSvtvJob<H>(cls, saoFile).startJob();
    }

    private static class MakeTraceSvtvJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File saoFile;
        private final String designName;

        private MakeTraceSvtvJob(Class<H> cls, File saoFile, String designName) {
            super("Make SVTV Trace", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
            this.designName = designName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            try {
                ACL2Object.initHonsMananger(this.designName);
                DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                DesignExt design = new DesignExt(sr.root, designHints);
                for (ModuleExt mod2 : design.downTop.values()) {
                    if (mod2.parMod != null) continue;
                    ModName modName = mod2.modName;
                    File outDir = this.saoFile.getParentFile();
                    ArrayList<String> lines = new ArrayList<String>();
                    try (LineNumberReader in = new LineNumberReader(new InputStreamReader(ACL2DesignJobs.class.getResourceAsStream("defsvtv-trace.dat")));){
                        String line;
                        while ((line = in.readLine()) != null) {
                            lines.add(line);
                        }
                    }
                    File outFile = new File(outDir, String.valueOf(modName) + "-defsvtv-trace.lisp");
                    try (PrintStream out = new PrintStream(outFile);){
                        for (String line : lines) {
                            if (line.contains("$INPUT$")) {
                                for (ModExport export : mod2.exports) {
                                    if (!export.isInput()) continue;
                                    out.println(line.replace("$INPUT$", export.wire.getName().toString()));
                                }
                                continue;
                            }
                            if (line.contains("$OUTPUT")) {
                                for (ModExport export : mod2.exports) {
                                    if (!export.isOutput()) continue;
                                    out.println(line.replace("$OUTPUT$", export.wire.getName().toString()));
                                }
                                continue;
                            }
                            out.println(line.replace("$DESIGN$", this.designName).replace("$MODNAME$", modName.toString()));
                        }
                    }
                }
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }
    }

    private static class ReadTraceSvtvJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File saoFile;
        private DesignExt design;
        private SvarName.Builder<Address> snb;
        private SvarName.Builder<Address> modifiedSnb;
        private SvexManager<Address> sm;
        private Map<ACL2Object, Svex<Address>> svexCache;

        private ReadTraceSvtvJob(Class<H> cls, File saoFile) {
            super("Read SVTV Ttace", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            this.snb = new Address.SvarNameBuilder();
            this.sm = new SvexManager();
            this.svexCache = new HashMap<ACL2Object, Svex<Address>>();
            try {
                ACL2Object.initHonsMananger(this.saoFile.getName());
                DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                List<ACL2Object> traceList = Util.getList(sr.root, true);
                Util.check(traceList.size() == 26);
                Util.check(traceList.get(0).equals(ACL2Object.valueOf("KEYWORD", "DESIGN")));
                this.design = new DesignExt(traceList.get(1), designHints);
                Util.check(traceList.get(2).equals(ACL2Object.valueOf("KEYWORD", "OVERRIDDEN-ASSIGNS")));
                Map<Svar<Address>, Svex<Address>> overriddenAssigns = this.readSvexAlist(traceList.get(3));
                Util.check(traceList.get(4).equals(ACL2Object.valueOf("KEYWORD", "DELAYS")));
                Map<Svar<Address>, Svar<Address>> delays = this.readSvarMap(traceList.get(5));
                Util.check(traceList.get(6).equals(ACL2Object.valueOf("KEYWORD", "REWRITTEN-ASSIGNS")));
                Map<Svar<Address>, Svex<Address>> rewrittenAssigns = this.readSvexAlist(traceList.get(7));
                Util.check(traceList.get(8).equals(ACL2Object.valueOf("KEYWORD", "RAW-UPDATES")));
                Map<Svar<Address>, Svex<Address>> rawUpdates = this.readSvexAlist(traceList.get(9));
                Util.check(traceList.get(10).equals(ACL2Object.valueOf("KEYWORD", "UPDATES0")));
                Map<Svar<Address>, Svex<Address>> update0 = this.readSvexAlist(traceList.get(11));
                Util.check(traceList.get(12).equals(ACL2Object.valueOf("KEYWORD", "REST")));
                Map<Svar<Address>, Svex<Address>> rest = this.readSvexAlist(traceList.get(13));
                Util.check(traceList.get(14).equals(ACL2Object.valueOf("KEYWORD", "RES1")));
                Map<Svar<Address>, Svex<Address>> res1 = this.readSvexAlist(traceList.get(15));
                Util.check(traceList.get(16).equals(ACL2Object.valueOf("KEYWORD", "RES1-UPDATES")));
                Map<Svar<Address>, Svex<Address>> res1updates = this.readSvexAlist(traceList.get(17));
                Util.check(traceList.get(18).equals(ACL2Object.valueOf("KEYWORD", "RES1-UPDATES2")));
                Map<Svar<Address>, Svex<Address>> res1updates2 = this.readSvexAlist(traceList.get(19));
                Util.check(traceList.get(20).equals(ACL2Object.valueOf("KEYWORD", "UPDATES")));
                Map<Svar<Address>, Svex<Address>> updates = this.readSvexAlist(traceList.get(21));
                Util.check(traceList.get(22).equals(ACL2Object.valueOf("KEYWORD", "NEXT-STATES")));
                Map<Svar<Address>, Svex<Address>> nextStates = this.readSvexAlist(traceList.get(23));
                Util.check(traceList.get(24).equals(ACL2Object.valueOf("KEYWORD", "SVTV")));
                List<ACL2Object> svtvList = Util.getList(traceList.get(25), true);
                Util.check(ACL2.car(svtvList.get(0)).equals(ACL2Object.valueOf("SV", "NAME")));
                String designName = ACL2.symbol_name(ACL2.cdr(svtvList.get(0))).stringValueExact();
                Util.check(designName.endsWith("-svtv"));
                designName = designName.substring(0, designName.length() - "-svtv".length());
                System.out.println(designName);
                Util.check(ACL2.car(svtvList.get(1)).equals(ACL2Object.valueOf("SV", "OUTEXPRS")));
                Util.check(ACL2.car(svtvList.get(2)).equals(ACL2Object.valueOf("SV", "NEXTSTATE")));
                Util.check(ACL2.car(svtvList.get(3)).equals(ACL2Object.valueOf("SV", "INMASKS")));
                Util.check(ACL2.car(svtvList.get(4)).equals(ACL2Object.valueOf("SV", "OUTMASKS")));
                Util.check(ACL2.car(svtvList.get(5)).equals(ACL2Object.valueOf("SV", "ORIG-INS")));
                Util.check(ACL2.car(svtvList.get(6)).equals(ACL2Object.valueOf("SV", "ORIG-OVERRIDES")));
                Util.check(ACL2.car(svtvList.get(7)).equals(ACL2Object.valueOf("SV", "ORIG-OUTS")));
                Util.check(ACL2.car(svtvList.get(8)).equals(ACL2Object.valueOf("SV", "ORIG-INTERNALS")));
                Util.check(ACL2.car(svtvList.get(9)).equals(ACL2Object.valueOf("SV", "EXPANDED-INS")));
                Util.check(ACL2.car(svtvList.get(10)).equals(ACL2Object.valueOf("SV", "EXPANDED-OVERRIDES")));
                Util.check(ACL2.car(svtvList.get(11)).equals(ACL2Object.valueOf("SV", "NPHASES")));
                ModuleExt topMod = this.design.downTop.get(this.design.b.top);
                ElabMod topElabMod = topMod.elabMod;
                ElabMod.ModScope topScope = new ElabMod.ModScope(topElabMod);
                IndexName.curElabMod = topMod.elabMod;
                ModDb.FlattenResult flattenResult = topMod.elabMod.svexmodFlatten(this.design.b.modalist);
                List<Lhs<Address>> namedAliases = topScope.aliasesToAddress(flattenResult.aliases, this.sm);
                Compile<Address> compile = new Compile<Address>(namedAliases, flattenResult.assigns, this.sm);
                this.modifiedSnb = new ModifiedAddressBuilder(topMod.exports);
                Map<Svar<Address>, Svex<Address>> svtvOutExprs = this.readSvexAlist(ACL2.cdr(svtvList.get(1)), this.modifiedSnb);
                Map<Svar<Address>, Svex<Address>> svtvNextState = this.readSvexAlist(ACL2.cdr(svtvList.get(2)), this.modifiedSnb);
                Util.check(compile.resAssigns.equals(overriddenAssigns));
                this.checkSvexAlist(compile.resAssigns, traceList.get(3));
                Util.check(compile.resDelays.equals(delays));
                Util.check(compile.resDelaysAsACL2Object().equals(traceList.get(5)));
                Util.check(compile.resAssigns.keySet().equals(rewrittenAssigns.keySet()));
                this.checkSvarKeys(compile.resAssigns, traceList.get(7));
                Util.check(compile.resAssigns.keySet().equals(rawUpdates.keySet()));
                Util.check(compile.resAssigns.keySet().equals(update0.keySet()));
                this.checkSvarKeys(rawUpdates, traceList.get(11));
                Util.check(compile.resAssigns.keySet().equals(updates.keySet()));
                this.checkSvarKeys(rawUpdates, traceList.get(21));
                Util.check(compile.resDelays.keySet().equals(nextStates.keySet()));
                this.checkSvarKeys(compile.resDelays, traceList.get(23));
                Iterator<Map.Entry<Svar<Address>, Svex<Address>>> svtvOutExprsIter = svtvOutExprs.entrySet().iterator();
                for (ModExport export : topMod.exports) {
                    if (!export.isOutput()) continue;
                    Map.Entry<Svar<Address>, Svex<Address>> e2 = svtvOutExprsIter.next();
                    Svar<Address> svar = e2.getKey();
                    e2.getValue();
                    Util.check(svar.getDelay() == 0 && !svar.isNonblocking());
                    Address address = svar.getName();
                    Util.check(address.index == -1 && address.scope == 0);
                    Path.Wire pathWire = (Path.Wire)address.getPath();
                    Util.check(pathWire.name.equals(export.wire.getName()));
                }
                Util.check(!svtvOutExprsIter.hasNext());
                File outDir = this.saoFile.getParentFile();
                this.printAliases(namedAliases, new File(outDir, designName + "-aliases.txt"));
                this.printSvexarr(compile.svexarr, new File(outDir, designName + "-svexarr.txt"));
                this.printSvexalist(overriddenAssigns, new File(outDir, designName + "-overriddenAssigns.txt"));
                this.printVars(delays.keySet(), new File(outDir, designName + "-delays.txt"));
                this.printSvexalist(rewrittenAssigns, new File(outDir, designName + "-rewrittenAssigns.txt"));
                this.printSvexalist(rawUpdates, new File(outDir, designName + "-rawUpdates.txt"));
                this.printSvexalist(update0, new File(outDir, designName + "-update0.txt"));
                this.printSvexalist(rest, new File(outDir, designName + "-rest.txt"));
                this.printSvexalist(res1, new File(outDir, designName + "-res1.txt"));
                this.printSvexalist(res1updates, new File(outDir, designName + "-res1updates.txt"));
                this.printSvexalist(res1updates2, new File(outDir, designName + "-res1updates2.txt"));
                this.printSvexalist(updates, new File(outDir, designName + "-updates.txt"));
                this.printSvexalist(nextStates, new File(outDir, designName + "-nextState.txt"));
                this.printSvexalist(svtvOutExprs, new File(outDir, designName + "-svtvOutExprs.txt"));
                this.printSvexalist(svtvNextState, new File(outDir, designName + "-svtvNextState.txt"));
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e3) {
                boolean bl = false;
                return bl;
            }
            finally {
                IndexName.curElabMod = null;
                ACL2Object.closeHonsManager();
            }
            return true;
        }

        private Map<Svar<Address>, Svex<Address>> readSvexAlist(ACL2Object l2) {
            return this.readSvexAlist(l2, this.snb);
        }

        private Map<Svar<Address>, Svex<Address>> readSvexAlist(ACL2Object l2, SvarName.Builder<Address> snb) {
            LinkedHashMap<Svar<Address>, Svex<Address>> result = new LinkedHashMap<Svar<Address>, Svex<Address>>();
            for (ACL2Object pair : Util.getList(l2, true)) {
                Svex<Address> svex;
                Svar<Address> svar = SvarImpl.fromACL2(snb, this.sm, ACL2.car(pair));
                Svex<Address> old = result.put(svar, svex = Svex.fromACL2(snb, this.sm, ACL2.cdr(pair), this.svexCache));
                Util.check(old == null);
            }
            return result;
        }

        private Map<Svar<Address>, Svar<Address>> readSvarMap(ACL2Object l2) {
            LinkedHashMap<Svar<Address>, Svar<Address>> result = new LinkedHashMap<Svar<Address>, Svar<Address>>();
            for (ACL2Object pair : Util.getList(l2, true)) {
                Svar<Address> svarValue;
                Svar<Address> svarKey = SvarImpl.fromACL2(this.snb, this.sm, ACL2.car(pair));
                Svar<Address> old = result.put(svarKey, svarValue = SvarImpl.fromACL2(this.snb, this.sm, ACL2.cdr(pair)));
                Util.check(old == null);
            }
            return result;
        }

        private void checkSvexAlist(Map<Svar<Address>, Svex<Address>> svexAlist, ACL2Object l2) {
            for (Map.Entry<Svar<Address>, Svex<Address>> e2 : svexAlist.entrySet()) {
                Util.checkNotNil(ACL2.consp(l2));
                ACL2Object pair = ACL2.car(l2);
                Util.check(e2.getKey().getACL2Object().equals(ACL2.car(pair)));
                Util.check(e2.getValue().getACL2Object().equals(ACL2.cdr(pair)));
                l2 = ACL2.cdr(l2);
            }
            Util.checkNil(l2);
        }

        private <V> void checkSvarKeys(Map<Svar<Address>, V> map, ACL2Object l2) {
            List<ACL2Object> list = Util.getList(l2, true);
            Util.check(map.size() == list.size());
            int i2 = 0;
            for (Svar<Address> svar : map.keySet()) {
                ACL2Object pair = list.get(i2);
                Util.checkNotNil(ACL2.consp(pair));
                Util.check(svar.getACL2Object().equals(ACL2.car(pair)));
                ++i2;
            }
            assert (i2 == list.size());
        }

        void printAliases(List<Lhs<Address>> aliases, File outFile) throws FileNotFoundException {
            ElabMod topMod = this.design.moddb.topMod();
            assert (aliases.size() == topMod.modTotalWires());
            SvarNameTexter<Address> texter = topMod.getAddressTexter();
            try (PrintStream out = new PrintStream(outFile);){
                for (int i2 = 0; i2 < topMod.modTotalWires(); ++i2) {
                    Lhs<Address> lhs = aliases.get(i2);
                    out.println(i2 + ": " + String.valueOf(topMod.wireidxToPath(i2)) + " = " + lhs.toString(texter));
                }
            }
        }

        void printSvexarr(Svex<Address>[] svexarr, File outFile) throws FileNotFoundException {
            ElabMod topMod = this.design.moddb.topMod();
            assert (svexarr.length == topMod.modTotalWires());
            topMod.getAddressTexter();
            try (PrintStream out = new PrintStream(outFile);){
                for (int i2 = 0; i2 < topMod.modTotalWires(); ++i2) {
                    Svex<Address> svex = svexarr[i2];
                    String name = topMod.wireidxToPath(i2).toString();
                    out.print(i2 + ": " + name);
                    GenFsmNew.printSvex(out, 1, svex);
                    out.println();
                }
            }
        }

        void printVars(Set<Svar<Address>> vars, File outFile) throws FileNotFoundException {
            try (PrintStream out = new PrintStream(outFile);){
                for (Svar<Address> svar : vars) {
                    out.println(svar);
                }
            }
        }

        void printSvexalist(Map<Svar<Address>, Svex<Address>> alist, File outFile) throws FileNotFoundException {
            HashMap<Svex<Address>, String> names = new HashMap<Svex<Address>, String>();
            try (PrintStream out = new PrintStream(outFile);){
                Svar svar;
                block5: for (Map.Entry<Svar<Address>, Svex<Address>> e2 : alist.entrySet()) {
                    Svar<Address> svar2 = e2.getKey();
                    Svex<Address> svex = e2.getValue();
                    names.put(svex, svar2.toString());
                    int lsh = 0;
                    while (svex instanceof SvexCall) {
                        Svex<N>[] args;
                        SvexCall sc = (SvexCall)svex;
                        if (sc.fun != Vec4Concat.FUNCTION || !((args = sc.getArgs())[0] instanceof SvexQuote)) continue block5;
                        SvexQuote w = (SvexQuote)args[0];
                        if (!w.val.isIndex()) continue block5;
                        int wVal = ((Vec2)w.val).getVal().intValueExact();
                        if (args[1] instanceof SvexCall) {
                            String svarName = String.valueOf(svar2) + "[" + (lsh + wVal - 1) + ":" + lsh + "]";
                            names.put(args[1], svarName);
                        }
                        svex = args[2];
                        lsh += wVal;
                    }
                }
                Set<SvexCall<Address>> multirefs = Svex.multirefs(names.keySet());
                for (Svex svex : names.keySet()) {
                    if (!(svex instanceof SvexCall)) continue;
                    multirefs.add((SvexCall)svex);
                }
                block8: for (Map.Entry entry : alist.entrySet()) {
                    svar = (Svar)entry.getKey();
                    Svex svex = (Svex)entry.getValue();
                    int lsh = 0;
                    while (svex instanceof SvexCall) {
                        Svex<N>[] args;
                        SvexCall sc = (SvexCall)svex;
                        if (sc.fun != Vec4Concat.FUNCTION || !((args = sc.getArgs())[0] instanceof SvexQuote)) continue block8;
                        SvexQuote w = (SvexQuote)args[0];
                        if (!w.val.isIndex()) continue block8;
                        int wVal = ((Vec2)w.val).getVal().intValueExact();
                        if (args[1] instanceof SvexCall) {
                            String svarName = String.valueOf(svar) + "[" + (lsh + wVal - 1) + ":" + lsh + "]";
                            out.print(svarName);
                            this.printSvex(out, sc.getArgs()[1], multirefs, names, svarName, 1);
                            out.println();
                        }
                        svex = args[2];
                        lsh += wVal;
                    }
                }
                for (Map.Entry entry : alist.entrySet()) {
                    svar = (Svar)entry.getKey();
                    Svex svex = (Svex)entry.getValue();
                    String svarName = svar.toString();
                    out.print(svarName);
                    this.printSvex(out, svex, multirefs, names, svarName, 1);
                    out.println();
                }
            }
        }

        private void printSvex(PrintStream out, Svex<Address> top, Set<SvexCall<Address>> multirefs, Map<Svex<Address>, String> names, String multirefPrefix, int indent) {
            GenFsmNew.printSvex(out, indent, top, multirefs, names, multirefPrefix);
        }
    }

    private static class TestTraceSvtvJob<H extends DesignHints>
    extends Job {
        private final Class<H> cls;
        private final File saoFile;
        private DesignExt design;
        private SvarName.Builder<Address> snb;
        private SvarName.Builder<Address> modifiedSnb;
        private SvexManager<Address> sm;
        private Map<ACL2Object, Svex<Address>> svexCache;

        private TestTraceSvtvJob(Class<H> cls, File saoFile) {
            super("Test SVTV Ttace", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cls = cls;
            this.saoFile = saoFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doIt() throws JobException {
            this.snb = new Address.SvarNameBuilder();
            this.sm = new SvexManager();
            this.svexCache = new HashMap<ACL2Object, Svex<Address>>();
            try {
                ACL2Object.initHonsMananger(this.saoFile.getName());
                DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ACL2Reader sr = new ACL2Reader(this.saoFile);
                List<ACL2Object> traceList = Util.getList(sr.root, true);
                Util.check(traceList.size() == 26);
                Util.check(traceList.get(0).equals(ACL2Object.valueOf("KEYWORD", "DESIGN")));
                this.design = new DesignExt(traceList.get(1), designHints);
                Util.check(traceList.get(2).equals(ACL2Object.valueOf("KEYWORD", "OVERRIDDEN-ASSIGNS")));
                Util.check(traceList.get(4).equals(ACL2Object.valueOf("KEYWORD", "DELAYS")));
                Util.check(traceList.get(6).equals(ACL2Object.valueOf("KEYWORD", "REWRITTEN-ASSIGNS")));
                Util.check(traceList.get(8).equals(ACL2Object.valueOf("KEYWORD", "RAW-UPDATES")));
                Util.check(traceList.get(10).equals(ACL2Object.valueOf("KEYWORD", "UPDATES0")));
                Util.check(traceList.get(12).equals(ACL2Object.valueOf("KEYWORD", "REST")));
                Util.check(traceList.get(14).equals(ACL2Object.valueOf("KEYWORD", "RES1")));
                Util.check(traceList.get(16).equals(ACL2Object.valueOf("KEYWORD", "RES1-UPDATES")));
                Util.check(traceList.get(18).equals(ACL2Object.valueOf("KEYWORD", "RES1-UPDATES2")));
                Util.check(traceList.get(20).equals(ACL2Object.valueOf("KEYWORD", "UPDATES")));
                Map<Svar<Address>, Svex<Address>> updates = this.readSvexAlist(traceList.get(21));
                Util.check(traceList.get(22).equals(ACL2Object.valueOf("KEYWORD", "NEXT-STATES")));
                Util.check(traceList.get(24).equals(ACL2Object.valueOf("KEYWORD", "SVTV")));
                List<ACL2Object> svtvList = Util.getList(traceList.get(25), true);
                Util.check(ACL2.car(svtvList.get(0)).equals(ACL2Object.valueOf("SV", "NAME")));
                String designName = ACL2.symbol_name(ACL2.cdr(svtvList.get(0))).stringValueExact();
                Util.check(designName.endsWith("-svtv"));
                designName = designName.substring(0, designName.length() - "-svtv".length());
                System.out.println(designName);
                Util.check(ACL2.car(svtvList.get(1)).equals(ACL2Object.valueOf("SV", "OUTEXPRS")));
                Util.check(ACL2.car(svtvList.get(2)).equals(ACL2Object.valueOf("SV", "NEXTSTATE")));
                Util.check(ACL2.car(svtvList.get(3)).equals(ACL2Object.valueOf("SV", "INMASKS")));
                Util.check(ACL2.car(svtvList.get(4)).equals(ACL2Object.valueOf("SV", "OUTMASKS")));
                Util.check(ACL2.car(svtvList.get(5)).equals(ACL2Object.valueOf("SV", "ORIG-INS")));
                Util.check(ACL2.car(svtvList.get(6)).equals(ACL2Object.valueOf("SV", "ORIG-OVERRIDES")));
                Util.check(ACL2.car(svtvList.get(7)).equals(ACL2Object.valueOf("SV", "ORIG-OUTS")));
                Util.check(ACL2.car(svtvList.get(8)).equals(ACL2Object.valueOf("SV", "ORIG-INTERNALS")));
                Util.check(ACL2.car(svtvList.get(9)).equals(ACL2Object.valueOf("SV", "EXPANDED-INS")));
                Util.check(ACL2.car(svtvList.get(10)).equals(ACL2Object.valueOf("SV", "EXPANDED-OVERRIDES")));
                Util.check(ACL2.car(svtvList.get(11)).equals(ACL2Object.valueOf("SV", "NPHASES")));
                ModuleExt topMod = this.design.downTop.get(this.design.b.top);
                this.modifiedSnb = new ModifiedAddressBuilder(topMod.exports);
                Map<Svar<Address>, Svex<Address>> svtvOutExprs = this.readSvexAlist(ACL2.cdr(svtvList.get(1)), this.modifiedSnb);
                Map<Svar<Address>, Svex<Address>> svtvNextState = this.readSvexAlist(ACL2.cdr(svtvList.get(2)), this.modifiedSnb);
                System.out.println("Design name " + designName);
                System.out.println("Top mod " + String.valueOf(this.design.b.top));
                System.out.println("Outs:");
                for (Svar<Address> svar : svtvOutExprs.keySet()) {
                    System.out.println(svar);
                }
                System.out.println("States:");
                for (Svar<Address> svar : svtvNextState.keySet()) {
                    System.out.println(svar);
                }
                designHints.testSvtv(this.design.b.top, updates, svtvOutExprs, svtvNextState, this.sm);
            }
            catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                boolean bl = false;
                return bl;
            }
            finally {
                ACL2Object.closeHonsManager();
            }
            return true;
        }

        private Map<Svar<Address>, Svex<Address>> readSvexAlist(ACL2Object l2) {
            return this.readSvexAlist(l2, this.snb);
        }

        private Map<Svar<Address>, Svex<Address>> readSvexAlist(ACL2Object l2, SvarName.Builder<Address> snb) {
            LinkedHashMap<Svar<Address>, Svex<Address>> result = new LinkedHashMap<Svar<Address>, Svex<Address>>();
            for (ACL2Object pair : Util.getList(l2, true)) {
                Svex<Address> svex;
                Svar<Address> svar = SvarImpl.fromACL2(snb, this.sm, ACL2.car(pair));
                Svex<Address> old = result.put(svar, svex = Svex.fromACL2(snb, this.sm, ACL2.cdr(pair), this.svexCache));
                Util.check(old == null);
            }
            return result;
        }
    }

    private static class ModifiedAddressBuilder
    extends Address.SvarNameBuilder {
        private final Map<ACL2Object, ACL2Object> patchMap = new HashMap<ACL2Object, ACL2Object>();

        ModifiedAddressBuilder(List<ModExport> exports) {
            for (ModExport export : exports) {
                String nameStr = export.wire.getName().toString();
                ACL2Object sym = ACL2Object.valueOf("SV", nameStr);
                ACL2Object str = ACL2.symbol_name(sym);
                this.patchMap.put(sym, str);
            }
        }

        @Override
        public Address fromACL2(ACL2Object nameImpl) {
            ACL2Object patch = this.patchMap.get(nameImpl);
            if (patch == null && ACL2.consp(nameImpl).bool() && ACL2.car(nameImpl).equals(KEYWORD_PHASE)) {
                patch = ACL2.car(ACL2.cdr(nameImpl));
                Util.checkNotNil(ACL2.stringp(patch));
            }
            return super.fromACL2(patch != null ? patch : nameImpl);
        }
    }
}

