/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.DesignExt;
import com.sun.electric.tool.simulation.acl2.modsext.DriverExt;
import com.sun.electric.tool.simulation.acl2.modsext.GenBase;
import com.sun.electric.tool.simulation.acl2.modsext.ModInstExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Reader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenFsm
extends GenBase {
    private static final Vec4 X16 = Vec4.valueOf(BigInteger.valueOf(65535L), BigInteger.valueOf(0L));
    private String projName;
    private final Set<WireExt> knownWires = new HashSet<WireExt>();
    private final List<WireExt> sortedWires = new ArrayList<WireExt>();
    private final Map<WireExt, Map<Lhs<PathExt>, DriverExt>> wireDrivers = new HashMap<WireExt, Map<Lhs<PathExt>, DriverExt>>();
    private final Map<WireExt, Set<WireExt>> wireDependencies = new HashMap<WireExt, Set<WireExt>>();

    protected abstract boolean ignore_wire(WireExt var1);

    private static WireExt searchWire(ModuleExt m2, String name) {
        Name nm = Name.valueOf(name);
        for (WireExt w : m2.wires) {
            if (!w.getName().equals(nm)) continue;
            return w;
        }
        throw new RuntimeException();
    }

    private void topSort(WireExt w) {
        if (this.knownWires.contains(w)) {
            return;
        }
        Set<WireExt> deps = this.wireDependencies.get(w);
        if (deps == null) {
            System.out.println("Unknown " + String.valueOf(w));
        } else {
            for (WireExt wd : deps) {
                this.topSort(wd);
            }
        }
        this.knownWires.add(w);
        this.sortedWires.add(w);
    }

    private void genCurrentState(Name instname, int ffWidth, Lhrange<PathExt> lr, int rsh) {
        WireExt lw;
        Svar<PathExt> svar = lr.getVar();
        WireExt w = lw = (WireExt)svar.getName();
        if (lr.getWidth() != w.getWidth()) {
            throw new UnsupportedOperationException();
        }
        String s = w.getName().toString();
        assert (svar.getDelay() == 0);
        assert (!svar.isNonblocking());
        this.s();
        this.s("(define " + s + "-ext");
        this.sb(" ((st " + this.projName + "-st-p)");
        this.sb("  (in " + this.projName + "-in-p))");
        this.e();
        this.s(" :returns (" + s + " unsigned-" + w.getWidth() + "-p)");
        this.s(" (declare (ignore in))");
        String ff = "(" + this.projName + "-st->" + instname.toString() + " st)";
        if (w.getWidth() != ffWidth) {
            ff = w.getWidth() == 1 ? "(logbit " + rsh + " " + ff + ")" : (rsh == 0 ? "(loghead " + w.getWidth() + " " + ff + ")" : "(loghead " + w.getWidth() + " (logtail " + rsh + " " + ff + "))");
        }
        this.s(" " + ff + ")");
        this.e();
    }

    protected void showSvex(Svex<PathExt> sv) {
        if (sv instanceof SvexQuote) {
            Vec4 val = ((SvexQuote)sv).val;
            if (val.isVec2()) {
                this.s(String.valueOf(((Vec2)val).getVal()));
            } else {
                Util.check(val.equals(Vec4.X) || val.equals(X16));
                this.s("0");
            }
        } else if (sv instanceof SvexVar) {
            WireExt lw;
            WireExt w = lw = (WireExt)((SvexVar)sv).svar.getName();
            String s = w.getName().toString();
            this.s("(" + s + "-ext st in)");
        } else if (sv instanceof SvexCall) {
            SvexCall sc = (SvexCall)sv;
            Svex<N>[] nm = ACL2.symbol_name(sc.fun.fn).stringValueExact();
            Object lnm = "<" + (String)nm + ">";
            boolean boolBit = false;
            boolean neBit = false;
            switch (nm) {
                case "ID": {
                    break;
                }
                case "BITSEL": {
                    break;
                }
                case "UNFLOAT": {
                    break;
                }
                case "BITNOT": {
                    lnm = "lognot";
                    break;
                }
                case "BITAND": {
                    lnm = "logand";
                    break;
                }
                case "BITOR": {
                    lnm = "logior";
                    break;
                }
                case "BITXOR": {
                    lnm = "logxor";
                    break;
                }
                case "RES": {
                    break;
                }
                case "RESAND": {
                    break;
                }
                case "RESOR": {
                    break;
                }
                case "OVERRIDE": {
                    break;
                }
                case "ONP": {
                    break;
                }
                case "OFFP": {
                    break;
                }
                case "UAND": {
                    break;
                }
                case "UOR": {
                    break;
                }
                case "UXOR": {
                    break;
                }
                case "ZEROX": {
                    lnm = "loghead";
                    break;
                }
                case "SIGNX": {
                    lnm = "loghead";
                    break;
                }
                case "CONCAT": {
                    lnm = "logapp";
                    break;
                }
                case "BLKREV": {
                    break;
                }
                case "RSH": {
                    break;
                }
                case "LSH": {
                    break;
                }
                case "+": {
                    lnm = "+";
                    break;
                }
                case "B-": {
                    lnm = "-";
                    break;
                }
                case "U-": {
                    break;
                }
                case "*": {
                    lnm = "*";
                    break;
                }
                case "/": {
                    break;
                }
                case "%": {
                    break;
                }
                case "XDET": {
                    break;
                }
                case "<": {
                    lnm = "<";
                    boolBit = true;
                    break;
                }
                case "==": {
                    lnm = "=";
                    boolBit = true;
                    break;
                }
                case "===": {
                    break;
                }
                case "==?": {
                    break;
                }
                case "SAFER-==?": {
                    break;
                }
                case "==??": {
                    break;
                }
                case "CLOG2": {
                    break;
                }
                case "POW": {
                    break;
                }
                case "?": {
                    lnm = "if";
                    neBit = true;
                    break;
                }
                case "?*": {
                    break;
                }
                case "BIT?": {
                    break;
                }
                case "PARTSEL": {
                    lnm = "partsel";
                    break;
                }
                case "PARTINST": {
                    break;
                }
                default: {
                    Util.check(false);
                }
            }
            if (boolBit) {
                this.s("(bool->bit (" + (String)lnm);
            } else {
                this.s("(" + (String)lnm);
            }
            this.b();
            for (Svex<PathExt> svex : sc.getArgs()) {
                if (neBit) {
                    this.s("(not (= ");
                    this.showSvex(svex);
                    this.out.print(" 0))");
                    neBit = false;
                    continue;
                }
                this.showSvex(svex);
            }
            this.out.print(')');
            if (boolBit) {
                this.out.print(')');
            }
            this.e();
        } else assert (false);
    }

    protected void genDummyWireBody(String s, Map<Lhs<PathExt>, DriverExt> drv) {
        this.showSvex(drv.values().iterator().next().getOrigSvex());
    }

    private void genDummyWire(WireExt w) {
        String s = w.getName().toString();
        this.s();
        this.s("(define " + s + "-ext");
        this.sb("((st " + this.projName + "-st-p)");
        this.sb("(in " + this.projName + "-in-p))");
        this.e();
        this.s(" :returns (" + s + " unsigned-" + w.getWidth() + "-p)");
        this.s(";");
        Set<WireExt> deps = this.wireDependencies.get(w);
        for (WireExt wd : deps) {
            this.out.print(" " + String.valueOf(wd));
        }
        Map<Lhs<PathExt>, DriverExt> drv = this.wireDrivers.get(w);
        if (drv != null && !drv.isEmpty()) {
            this.genDummyWireBody(s, drv);
        } else {
            this.s("0");
        }
        this.out.print(')');
        this.e();
    }

    protected String getGatedClock(String s) {
        return null;
    }

    protected String[] getGatedClocks() {
        return new String[0];
    }

    private void genNextFlipFlop(Name instname, int ffWidth, Lhs<PathExt> r) {
        Lhrange lr;
        int i2;
        String s = instname.toString();
        this.s();
        this.s("(define " + s + "-next");
        this.sb("((st " + this.projName + "-st-p)");
        this.sb("(in " + this.projName + "-in-p))");
        this.e();
        this.s(":returns (" + s + " unsigned-" + ffWidth + "-p)");
        String clk = this.getGatedClock(s);
        if (clk != null) {
            this.s("(if (= (" + clk + "-ext st in) 1)");
            this.sb("(" + this.projName + "-st->" + s + " st)");
            this.e();
        }
        int rsh = ffWidth;
        for (i2 = 0; i2 < r.ranges.size() - 1; ++i2) {
            lr = r.ranges.get(r.ranges.size() - 1 - i2);
            this.sb("(logapp " + (rsh -= lr.getWidth()));
        }
        assert (rsh == r.ranges.get(0).getWidth());
        for (i2 = r.ranges.size() - 1; i2 >= 0; --i2) {
            lr = r.ranges.get(r.ranges.size() - 1 - i2);
            WireExt lw = (WireExt)lr.getVar().getName();
            String atomStr = "(" + lw.toString() + "-ext st in)";
            if (lr.getRsh() != 0) {
                atomStr = "(logtail " + lr.getRsh() + " " + atomStr + ")";
            }
            if (i2 == 0 && lr.getWidth() != lw.getWidth() - lr.getRsh()) {
                atomStr = "(loghead " + lr.getWidth() + " " + atomStr + ")";
            }
            this.s(atomStr);
            if (i2 != r.ranges.size() - 1) {
                this.out.print(")");
            }
            if (i2 == 0) {
                this.out.print(")");
                if (clk != null) {
                    this.out.print(")");
                }
            }
            this.out.print(" ; " + String.valueOf(lr));
            this.e();
        }
    }

    protected abstract boolean isFlipFlopIn(String var1, String var2);

    protected abstract boolean isFlipFlopOut(String var1, String var2);

    private void genNextState(ModuleExt m2) {
        this.s("(define next-state");
        this.sb("((st " + this.projName + "-st-p)");
        this.sb("(in " + this.projName + "-in-p))");
        this.e();
        this.s(":returns (nst " + this.projName + "-st-p)");
        this.s("(make-" + this.projName + "-st");
        this.b();
        for (Map.Entry<Lhs<PathExt>, Lhs<PathExt>> e1 : m2.aliaspairs.entrySet()) {
            Lhs<PathExt> l2 = e1.getKey();
            assert (l2.ranges.size() == 1);
            Lhrange lr = l2.ranges.get(0);
            assert (lr.getRsh() == 0);
            if (!(lr.getVar().getName() instanceof PathExt.PortInst)) continue;
            Svar svar = lr.getVar();
            PathExt.PortInst pi = (PathExt.PortInst)svar.getName();
            assert (svar.getDelay() == 0);
            assert (!svar.isNonblocking());
            ModInstExt inst = pi.inst;
            if (!this.isFlipFlopOut(inst.getModname().toString(), pi.getProtoName().toString())) continue;
            String s = inst.getInstname().toString();
            this.s(":" + s + " (" + s + "-next st in)");
        }
        this.out.print("))");
        this.e();
        this.e();
    }

    public void gen(ModuleExt m2) {
        Lhs l2;
        ModInstExt inst;
        PathExt.PortInst pi;
        Svar lVar;
        this.genAux();
        this.s();
        this.s("; Primary inputs");
        for (WireExt wireExt : m2.wires) {
            if (wireExt.isAssigned() || !wireExt.used || this.ignore_wire(wireExt)) continue;
            this.knownWires.add(wireExt);
            this.genInput(wireExt);
        }
        this.s();
        this.s("; Current state");
        for (Map.Entry entry : m2.aliaspairs.entrySet()) {
            Lhs l22 = (Lhs)entry.getKey();
            Lhs lhs = (Lhs)entry.getValue();
            assert (l22.ranges.size() == 1);
            Lhrange lr = l22.ranges.get(0);
            assert (lr.getRsh() == 0);
            lVar = lr.getVar();
            if (!(lVar.getName() instanceof PathExt.PortInst)) continue;
            pi = (PathExt.PortInst)lVar.getName();
            assert (lVar.getDelay() == 0);
            assert (!lVar.isNonblocking());
            inst = pi.inst;
            int ffWidth = pi.getWidth();
            if (!this.isFlipFlopOut(inst.getModname().toString(), pi.getProtoName().toString())) continue;
            int rsh = 0;
            for (Lhrange<PathExt> lhrange : lhs.ranges) {
                Svar svar = lhrange.getVar();
                assert (svar.getDelay() == 0);
                assert (!svar.isNonblocking());
                WireExt lw = (WireExt)svar.getName();
                this.knownWires.add(lw);
                this.genCurrentState(inst.getInstname(), ffWidth, lhrange, rsh);
                rsh += lhrange.getWidth();
            }
        }
        this.out.println();
        for (Map.Entry entry : m2.assigns.entrySet()) {
            l2 = (Lhs)entry.getKey();
            DriverExt driverExt = (DriverExt)entry.getValue();
            assert (!l2.ranges.isEmpty());
            for (int i2 = 0; i2 < l2.ranges.size(); ++i2) {
                Lhrange lr = l2.ranges.get(i2);
                Svar svar = lr.getVar();
                WireExt lw = (WireExt)svar.getName();
                Map<Lhs<PathExt>, DriverExt> drv = this.wireDrivers.get(lw);
                if (drv == null) {
                    drv = new LinkedHashMap<Lhs<PathExt>, DriverExt>();
                    this.wireDrivers.put(lw, drv);
                }
                drv.put(l2, driverExt);
                Set<WireExt> dep = this.wireDependencies.get(lw);
                if (dep == null) {
                    dep = new LinkedHashSet<WireExt>();
                    this.wireDependencies.put(lw, dep);
                    continue;
                }
                System.out.println("Twice " + String.valueOf(lw));
            }
        }
        for (Map.Entry entry : m2.aliaspairs.entrySet()) {
            l2 = (Lhs)entry.getKey();
            Lhs lhs = (Lhs)entry.getValue();
            assert (l2.ranges.size() == 1);
            Lhrange lr = l2.ranges.get(0);
            assert (lr.getRsh() == 0);
            lVar = lr.getVar();
            if (!(lVar.getName() instanceof PathExt.PortInst)) continue;
            pi = (PathExt.PortInst)lVar.getName();
            assert (lVar.getDelay() == 0);
            assert (!lVar.isNonblocking());
            inst = pi.inst;
            if (!this.isFlipFlopIn(inst.getModname().toString(), pi.getProtoName().toString())) continue;
            for (Lhrange lr1 : lhs.ranges) {
                Svar svar = lr1.getVar();
                assert (svar.getDelay() == 0);
                assert (!svar.isNonblocking());
                WireExt wireExt = (WireExt)svar.getName();
                this.topSort(wireExt);
            }
        }
        for (Iterator<Object> iterator : this.getGatedClocks()) {
            this.topSort(GenFsm.searchWire(m2, iterator));
        }
        this.s("; Wires");
        for (WireExt wireExt : this.sortedWires) {
            this.genDummyWire(wireExt);
        }
        this.s();
        this.s("; New state");
        for (Map.Entry entry : m2.aliaspairs.entrySet()) {
            Lhs l3 = (Lhs)entry.getKey();
            Lhs lhs = (Lhs)entry.getValue();
            assert (l3.ranges.size() == 1);
            Lhrange lr = l3.ranges.get(0);
            assert (lr.getRsh() == 0);
            lVar = lr.getVar();
            if (!(lVar.getName() instanceof PathExt.PortInst)) continue;
            pi = (PathExt.PortInst)lVar.getName();
            assert (lVar.getDelay() == 0);
            assert (!lVar.isNonblocking());
            inst = pi.inst;
            int ffWidth = pi.getWidth();
            if (!this.isFlipFlopIn(inst.getModname().toString(), pi.getProtoName().toString())) continue;
            this.genNextFlipFlop(inst.getInstname(), ffWidth, lhs);
        }
        this.s();
        this.genNextState(m2);
        this.s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gen(File saoFile, String outFileName) throws IOException {
        ACL2Reader sr = new ACL2Reader(saoFile);
        DesignExt design = new DesignExt(sr.root);
        ModuleExt m2 = design.downTop.get(design.getTop());
        this.projName = design.getTop().toString();
        try (PrintStream out = new PrintStream(outFileName);){
            this.out = out;
            this.gen(m2);
        }
        finally {
            this.out = null;
        }
    }

    protected void genAux() {
        this.s("(in-package \"ACL2\")");
        this.s();
        this.s("(include-book \"" + this.projName + "-state\")");
        this.s("(local (include-book \"ihs/logops-lemmas\" :dir :system))");
        this.s();
        this.s("(define partsel");
        this.sb("((lsb natp)");
        this.sb("(width natp)");
        this.s("(in integerp))");
        this.e();
        this.s("(loghead width (logtail lsb in)))");
        this.e();
        this.s();
        this.s("(local (in-theory (disable unsigned-byte-p loghead logtail logapp lognot logior (tau-system))))");
        this.s();
    }

    protected void genInput(WireExt w) {
        String s = w.getName().toString();
        this.s();
        this.s("(define " + s + "-ext");
        this.sb("((st " + this.projName + "-st-p)");
        this.sb("(in " + this.projName + "-in-p))");
        this.e();
        this.s(":returns (" + s + " unsigned-" + w.getWidth() + "-p)");
        this.s("(declare (ignore st))");
        this.s("(" + this.projName + "-in->" + s + " in))");
        this.e();
    }
}

