/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.modsext.GenFsmNew;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.modsext.WireExt;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4SignExt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ZeroExt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DriverExt {
    final ModuleExt parent;
    private final Driver<PathExt> b;
    final String name;
    private final Svex<PathExt> normSvex;
    private final Set<Svex<PathExt>> normSvexRecalc = new HashSet<Svex<PathExt>>();
    private final List<Svar<PathExt>> normVars;
    Map<Svar<PathExt>, BigInteger> crudeDeps0;
    Map<Svar<PathExt>, BigInteger> crudeDeps1;
    final List<Map<Svar<PathExt>, BigInteger>> fineBitLocDeps0 = new ArrayList<Map<Svar<PathExt>, BigInteger>>();
    final List<Map<Svar<PathExt>, BigInteger>> fineBitLocDeps1 = new ArrayList<Map<Svar<PathExt>, BigInteger>>();
    PathExt.Bit[] pathBits;
    boolean splitIt;

    DriverExt(ModuleExt parent, Driver<PathExt> b2, String name) {
        this.parent = parent;
        this.b = b2;
        this.name = name;
        Util.check(b2.strength == 6);
        for (Svar svar : b2.vars) {
            Util.check(svar.getName() instanceof WireExt);
        }
        this.normSvex = this.normAssign(b2.svex, parent.sm, this.normSvexRecalc);
        this.normVars = this.normSvex.collectVars();
    }

    public Svex<PathExt> getOrigSvex() {
        return this.b.svex;
    }

    public List<Svar<PathExt>> getOrigVars() {
        return this.b.vars;
    }

    public Svex<PathExt> getNormSvex() {
        return this.normSvex;
    }

    public List<Svar<PathExt>> getNormVars() {
        return this.normVars;
    }

    public int getStrength() {
        return this.b.strength;
    }

    public int getWidth() {
        return this.pathBits.length;
    }

    public PathExt.Bit getBit(int bit) {
        return this.pathBits[bit];
    }

    public <N extends SvarName> Svex<N> subst(Lhs<N>[] args, SvexManager<N> sm) {
        Svex<N> svexNorm;
        Svex<N> svexOrig = this.substOrig(args, sm);
        if (svexOrig != (svexNorm = this.substNorm(args, sm))) {
            System.out.print("ORIG:");
            GenFsmNew.printSvex(System.out, 2, this.getOrigSvex());
            System.out.print("NORM:");
            GenFsmNew.printSvex(System.out, 2, this.getNormSvex());
            System.out.print("ORIG:");
            GenFsmNew.printSvex(System.out, 2, svexOrig);
            System.out.print("NORM:");
            GenFsmNew.printSvex(System.out, 2, svexNorm);
            this.substNorm(args, sm);
        }
        return svexOrig;
    }

    public String toString() {
        assert (this.getStrength() == 6);
        return this.name != null ? this.name : this.getOrigSvex().toString();
    }

    void setSource(Lhs<PathExt> lhs) {
        assert (this.pathBits == null);
        this.pathBits = new PathExt.Bit[lhs.width()];
        int lsh = 0;
        for (Lhrange range : lhs.ranges) {
            Svar svar = range.getVar();
            Util.check(svar.getDelay() == 0);
            PathExt pathExt = (PathExt)svar.getName();
            for (int bit = 0; bit < range.getWidth(); ++bit) {
                this.pathBits[lsh + bit] = pathExt.getBit(range.getRsh() + bit);
                if (!(pathExt instanceof PathExt.PortInst)) continue;
                Util.check(this.pathBits[lsh + bit] == ((PathExt.PortInst)pathExt).getParentBit(lsh + bit));
            }
            lsh += range.getWidth();
        }
    }

    void markUsed() {
        for (Svar<PathExt> svar : this.getOrigVars()) {
            ((WireExt)svar.getName()).markUsed();
        }
    }

    Map<Svar<PathExt>, BigInteger> getCrudeDeps(boolean clockHigh) {
        return clockHigh ? this.crudeDeps1 : this.crudeDeps0;
    }

    List<Map<Svar<PathExt>, BigInteger>> getFineBitLocDeps(boolean clockHigh) {
        return clockHigh ? this.fineBitLocDeps1 : this.fineBitLocDeps0;
    }

    void computeDeps(int width, boolean clkVal, Map<Svar<PathExt>, Vec4> env, Map<SvexCall<PathExt>, SvexCall<PathExt>> patchMemoize) {
        Svex<PathExt> patched = this.getOrigSvex().patch(env, this.parent.sm, patchMemoize);
        BigInteger mask = BigIntegerUtil.logheadMask(width);
        Map<Svar<PathExt>, BigInteger> varsWithMasks = patched.collectVarsWithMasks(mask, true);
        if (clkVal) {
            this.crudeDeps1 = varsWithMasks;
        } else {
            this.crudeDeps0 = varsWithMasks;
        }
        HashMap<Svar<PathExt>, BigInteger> crudeDepsCheck = new HashMap<Svar<PathExt>, BigInteger>();
        List<Map<Svar<PathExt>, BigInteger>> fineDeps = this.getFineBitLocDeps(clkVal);
        fineDeps.clear();
        for (int bit = 0; bit < width; ++bit) {
            mask = BigInteger.ONE.shiftLeft(bit);
            Map<Svar<PathExt>, BigInteger> bitVarsWithMasks = patched.collectVarsWithMasks(mask, true);
            fineDeps.add(bitVarsWithMasks);
            for (Map.Entry<Svar<PathExt>, BigInteger> e2 : bitVarsWithMasks.entrySet()) {
                BigInteger crudeMask;
                Svar<PathExt> svar = e2.getKey();
                mask = e2.getValue();
                if (mask == null || mask.signum() == 0) continue;
                if (svar.getDelay() != 0) {
                    assert (svar.getDelay() == 1);
                    Map<Svar<PathExt>, BigInteger> stateVars = clkVal ? this.parent.stateVars1 : this.parent.stateVars0;
                    BigInteger oldMask = stateVars.get(svar);
                    if (oldMask == null) {
                        oldMask = BigInteger.ZERO;
                    }
                    stateVars.put(svar, oldMask.or(mask));
                }
                if ((crudeMask = (BigInteger)crudeDepsCheck.get(svar)) == null) {
                    crudeMask = BigInteger.ZERO;
                }
                crudeDepsCheck.put(svar, crudeMask.or(mask));
            }
        }
        Util.check(varsWithMasks.equals(crudeDepsCheck));
    }

    public String showFinePortDeps(Map<Object, Set<Object>> graph0, Map<Object, Set<Object>> graph1) {
        return this.parent.showFinePortDeps(this.pathBits, graph0, graph1);
    }

    List<Map<Svar<PathExt>, BigInteger>> gatherFineBitDeps(BitSet stateDeps, Map<Object, Set<Object>> graph) {
        return this.parent.gatherFineBitDeps(stateDeps, this.pathBits, graph);
    }

    private <N extends SvarName> Svex<N> substOrig(final Lhs<N>[] args, final SvexManager<N> sm) {
        Svex.TraverseVisitor visitor = new Svex.TraverseVisitor<PathExt, Svex<N>>(){
            final /* synthetic */ DriverExt this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Svex<N> visitQuote(Vec4 val) {
                return SvexQuote.valueOf(val);
            }

            @Override
            public Svex<N> visitVar(Svar<PathExt> svar) {
                int iArg = this.this$0.getOrigVars().indexOf(svar);
                Lhs arg = args[iArg];
                HashMap addDelayCache = new HashMap();
                return arg.toSvex(sm).addDelay(svar.getDelay(), sm, addDelayCache);
            }

            public Svex<N> visitCall(SvexFunction fun, Svex<PathExt>[] args2, Svex<N>[] argVals) {
                return fun.callStar(sm, argVals);
            }

            public Svex<N>[] newVals(int arity) {
                return Svex.newSvexArray(arity);
            }
        };
        return (Svex)this.getOrigSvex().traverse(visitor);
    }

    private Svex<PathExt> normAssign(Svex<PathExt> top, final SvexManager<PathExt> sm, final Set<Svex<PathExt>> recalcSet) {
        Svex.TraverseVisitor<PathExt, Svex<PathExt>> visitor = new Svex.TraverseVisitor<PathExt, Svex<PathExt>>(){
            final /* synthetic */ DriverExt this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Svex<PathExt> visitQuote(Vec4 val) {
                return SvexQuote.valueOf(val);
            }

            @Override
            public Svex<PathExt> visitVar(Svar<PathExt> svar) {
                SvexVar<PathExt> svex = sm.getSvex(svar);
                recalcSet.add(svex);
                return svex;
            }

            public Svex<PathExt> visitCall(SvexFunction fun, Svex<PathExt>[] args, Svex<PathExt>[] argVals) {
                if (fun == Vec4Rsh.FUNCTION && args[0] instanceof SvexQuote && args[1] instanceof SvexVar) {
                    assert (argVals[0] == args[0]);
                    Vec4 sh = ((SvexQuote)args[0]).val;
                    if (sh.isIndex()) {
                        int shVal = ((Vec2)sh).getVal().intValueExact();
                        assert (shVal > 0);
                        Svar svar = ((SvexVar)args[1]).svar;
                        int width = ((PathExt)svar.getName()).getWidth();
                        if (shVal >= width) {
                            return SvexQuote.Z();
                        }
                    }
                }
                Svex<PathExt> svex = fun.callStar(sm, argVals);
                if ((fun == Vec4Rsh.FUNCTION || fun == Vec4Concat.FUNCTION || fun == Vec4ZeroExt.FUNCTION || fun == Vec4SignExt.FUNCTION) && args[0] instanceof SvexQuote) {
                    for (Svex<PathExt> argVal : argVals) {
                        if (!recalcSet.contains(argVal)) continue;
                        recalcSet.add(svex);
                        break;
                    }
                }
                return svex;
            }

            public Svex<PathExt>[] newVals(int arity) {
                return Svex.newSvexArray(arity);
            }
        };
        return top.traverse(visitor);
    }

    private <N extends SvarName> Svex<N> substNorm(final Lhs<N>[] lhses, final SvexManager<N> sm) {
        SvexQuote.Z();
        Svex.TraverseVisitor visitor = new Svex.TraverseVisitor<PathExt, Svex<N>>(){
            final /* synthetic */ DriverExt this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Svex<N> visitQuote(Vec4 val) {
                return SvexQuote.valueOf(val);
            }

            @Override
            public Svex<N> visitVar(Svar<PathExt> svar) {
                int iArg = this.this$0.getOrigVars().indexOf(svar);
                Lhs arg = lhses[iArg];
                HashMap addDelayCache = new HashMap();
                return arg.toSvex(sm).addDelay(svar.getDelay(), sm, addDelayCache);
            }

            public Svex<N> visitCall(SvexFunction fun, Svex<PathExt>[] args, Svex<N>[] argVals) {
                if (fun == Vec4Rsh.FUNCTION && args[0] instanceof SvexQuote && this.this$0.normSvexRecalc.contains(args[1])) {
                    assert (argVals[0] == args[0]);
                    Vec4 sh = ((SvexQuote)args[0]).val;
                    if (sh.isIndex()) {
                        int shVal = ((Vec2)sh).getVal().intValueExact();
                        assert (shVal > 0);
                        return argVals[1].rsh(sm, shVal);
                    }
                } else if (fun == Vec4Concat.FUNCTION && args[0] instanceof SvexQuote && this.this$0.normSvexRecalc.contains(args[1])) {
                    assert (argVals[0] == args[0]);
                    Vec4 w = ((SvexQuote)args[0]).val;
                    if (w.isIndex()) {
                        int wVal = ((Vec2)w).getVal().intValueExact();
                        return argVals[1].concat(sm, wVal, argVals[2]);
                    }
                } else if (fun == Vec4ZeroExt.FUNCTION && args[0] instanceof SvexQuote && this.this$0.normSvexRecalc.contains(args[1])) {
                    assert (argVals[0] == args[0]);
                    Vec4 w = ((SvexQuote)args[0]).val;
                    if (w.isIndex()) {
                        int wVal = ((Vec2)w).getVal().intValueExact();
                        return argVals[1].zerox(sm, wVal);
                    }
                } else if (fun == Vec4SignExt.FUNCTION && args[0] instanceof SvexQuote && this.this$0.normSvexRecalc.contains(args[1])) {
                    assert (argVals[0] == args[0]);
                    Vec4 w = ((SvexQuote)args[0]).val;
                    if (w.isIndex()) {
                        int wVal = ((Vec2)w).getVal().intValueExact();
                        return argVals[1].signx(sm, wVal);
                    }
                }
                return sm.newCall(fun, argVals);
            }

            public Svex<N>[] newVals(int arity) {
                return Svex.newSvexArray(arity);
            }
        };
        return (Svex)this.getNormSvex().traverse(visitor);
    }
}

