/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Design;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.modsext.DesignHints;
import com.sun.electric.tool.simulation.acl2.modsext.GenFsmNew;
import com.sun.electric.tool.simulation.acl2.modsext.ParameterizedModule;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.ACL2Reader;
import com.sun.electric.util.acl2.ACL2Writer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;

public class DesignExplore<H extends DesignHints> {
    Class<H> cls;

    public DesignExplore(Class<H> cls) {
        this.cls = cls;
    }

    private static void help() {
        System.out.println("  showlibs <sao.file>");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLibs(String saoFileName, boolean checkElabMod) {
        File saoFile = new File(saoFileName);
        try {
            ACL2Object.initHonsMananger(saoFile.getName());
            DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ACL2Reader sr = new ACL2Reader(saoFile);
            Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
            Design<Address> design = new Design<Address>(snb, sr.root);
            ModDb modDb = checkElabMod ? new ModDb(design.modalist) : null;
            GenFsmNew gen = new GenFsmNew(designHints);
            gen.scanDesign(design, modDb);
            for (Map.Entry e2 : design.modalist.entrySet()) {
                ModName modName = e2.getKey();
                Module m2 = e2.getValue();
                if (gen.modToParMod.containsKey(modName)) continue;
                System.out.println(modName);
                if (!modName.isString()) {
                    System.out.println("!!! Difficult modName");
                }
                for (Wire wire : m2.wires) {
                    if (wire.name.isString()) continue;
                    System.out.println("!!! Difficult wire name " + String.valueOf(wire.name));
                }
                for (ModInst modInst : m2.insts) {
                    if (modInst.instname.isString()) continue;
                    System.out.println("!!! Difficult inst name " + String.valueOf(modInst.instname) + " " + String.valueOf(modInst.modname));
                }
                for (Assign assign : m2.assigns) {
                    if (!DesignExplore.easyLhs(assign.lhs, 1)) {
                        System.out.println("!!! Difficult assign " + String.valueOf(assign.lhs));
                    }
                    DesignExplore.checkAssign(assign);
                }
                for (Aliaspair aliaspair : m2.aliaspairs) {
                    if (aliaspair.lhs.ranges.size() != 1) {
                        System.out.println("!!! Difficult lhs size " + String.valueOf(aliaspair.lhs) + " = " + String.valueOf(aliaspair.rhs));
                    }
                    if (!DesignExplore.easyLhs(aliaspair.lhs, 1)) {
                        System.out.println("!!! Difficult lhs " + String.valueOf(aliaspair.lhs) + " = " + String.valueOf(aliaspair.rhs));
                    }
                    if (((Address)aliaspair.lhs.ranges.get((int)0).getVar().getName()).path.getDepth() == 1) {
                        if (!DesignExplore.easyLhs(aliaspair.rhs, 0)) {
                            System.out.println("!!! Difficult rhs " + String.valueOf(aliaspair.lhs) + " = " + String.valueOf(aliaspair.rhs));
                        }
                    } else {
                        if (aliaspair.rhs.ranges.size() != 1) {
                            System.out.println("!!! Difficult rhs size " + String.valueOf(aliaspair.lhs) + " = " + String.valueOf(aliaspair.rhs));
                        }
                        if (!DesignExplore.easyLhs(aliaspair.rhs, 1)) {
                            System.out.println("!!! Difficult rhs " + String.valueOf(aliaspair.lhs) + " = " + String.valueOf(aliaspair.rhs));
                        }
                        if (((Address)aliaspair.rhs.ranges.get((int)0).getVar().getName()).path.getDepth() != 1) {
                            System.out.println("!!! Difficult rhs depth " + String.valueOf(aliaspair.lhs) + " = " + String.valueOf(aliaspair.rhs));
                        }
                    }
                    if (((Address)aliaspair.lhs.ranges.get((int)0).getVar().getName()).path.getDepth() != 0) continue;
                }
            }
            gen.showLibs();
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e3) {
            System.out.println(e3.getMessage());
        }
        finally {
            ACL2Object.closeHonsManager();
        }
    }

    private static boolean easyLhs(Lhs<Address> lhs, int maxDepth) {
        for (Lhrange range : lhs.ranges) {
            Svar svar = range.getVar();
            if (svar == null) {
                return false;
            }
            if (svar.getDelay() != 0 || svar.isNonblocking()) {
                return false;
            }
            Address addr = (Address)svar.getName();
            if (addr.index != -1 || addr.scope != 0) {
                return false;
            }
            Path path = addr.getPath();
            if (path.getDepth() <= maxDepth) continue;
            return false;
        }
        return true;
    }

    private static void checkAssign(Assign<Address> assign) {
        if (assign.driver.strength != 6 && assign.driver.strength != 0) {
            System.out.println("!!! Difficult driver strength " + String.valueOf(assign.lhs) + " " + assign.driver.strength);
        }
        for (Svar svar : assign.driver.vars) {
            Path path;
            if (svar.getDelay() > 1 || svar.isNonblocking()) {
                System.out.println("!!! Difficult delay " + String.valueOf(assign.lhs) + " " + String.valueOf(svar));
            }
            Address addr = (Address)svar.getName();
            if (addr.index != -1 || addr.scope != 0) {
                System.out.println("!!! Difficult address " + String.valueOf(assign.lhs) + " " + String.valueOf(svar));
            }
            if ((path = addr.getPath()).getDepth() == 0) continue;
            System.out.println("!!! Difficult path " + String.valueOf(assign.lhs) + " " + String.valueOf(svar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strip(String saoFileName) {
        try {
            File saoFile = new File(saoFileName);
            ACL2Object.initHonsMananger(saoFile.getName());
            ACL2Reader sr = new ACL2Reader(saoFile);
            Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
            Design<Address> design = new Design<Address>(snb, sr.root);
            for (Module m2 : design.modalist.values()) {
                m2.wires.clear();
                m2.assigns.clear();
                m2.aliaspairs.clear();
            }
            File saoDir = saoFile.getParentFile();
            Object outFileName = saoFileName.endsWith(".sao") ? saoFileName.substring(0, saoFileName.length() - ".sao".length()) : saoFileName;
            outFileName = (String)outFileName + "-stripped.sao";
            File outFile = new File(saoDir, (String)outFileName);
            ACL2Writer.write(design.getACL2Object(), outFile);
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
        }
        finally {
            ACL2Object.closeHonsManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreParameterized(String saoFileName) {
        try {
            File saoFile = new File(saoFileName);
            ACL2Object.initHonsMananger(saoFile.getName());
            ACL2Reader sr = new ACL2Reader(saoFile);
            Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
            Design<Address> design = new Design<Address>(snb, sr.root);
            DesignHints designHints = (DesignHints)this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            GenFsmNew gen = new GenFsmNew(designHints);
            SvexFunction.isFnSym(ACL2.NIL);
            for (ModName modName : design.modalist.keySet()) {
                ParameterizedModule parMod = gen.matchParameterized(modName);
                if (parMod == null) continue;
                Module<Address> m2 = parMod.genModule();
                design.modalist.put(modName, m2);
            }
            File saoDir = saoFile.getParentFile();
            Object outFileName = saoFileName.endsWith("-stripped.sao") ? saoFileName.substring(0, saoFileName.length() - "-stripped.sao".length()) : (saoFileName.endsWith(".sao") ? saoFileName.substring(0, saoFileName.length() - ".sao".length()) : saoFileName);
            outFileName = (String)outFileName + "-restored.sao";
            File outFile = new File(saoDir, (String)outFileName);
            ACL2Writer.write(design.getACL2Object(), outFile);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
            System.out.println(e2.getMessage());
        }
        finally {
            ACL2Object.closeHonsManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMods(String saoFileName, String[] modNames) {
        try {
            File saoFile = new File(saoFileName);
            ACL2Object.initHonsMananger(saoFile.getName());
            ACL2Reader sr = new ACL2Reader(saoFile);
            Address.SvarNameBuilder snb = new Address.SvarNameBuilder();
            Design<Address> design = new Design<Address>(snb, sr.root);
            for (String modNameStr : modNames) {
                ModName modName = ModName.valueOf(modNameStr);
                DesignExplore.showMod(System.out, modName, design.modalist.get(modName));
            }
        }
        catch (IOException e2) {
            System.out.println(e2.getMessage());
        }
        finally {
            ACL2Object.closeHonsManager();
        }
    }

    public static void showMod(PrintStream out, ModName modName, Module<Address> mod2) {
        Lhs lhs;
        out.println();
        out.println("module " + String.valueOf(modName));
        for (Wire wire : mod2.wires) {
            out.println("  wire " + String.valueOf(wire));
        }
        for (ModInst modInst : mod2.insts) {
            out.println("  " + String.valueOf(modInst.modname) + " " + String.valueOf(modInst.instname));
        }
        for (Assign assign : mod2.assigns) {
            lhs = assign.lhs;
            Driver drv = assign.driver;
            out.print("  assign " + String.valueOf(lhs) + " = ");
            GenFsmNew.printSvex(out, 1, drv.svex);
        }
        for (Aliaspair aliaspair : mod2.aliaspairs) {
            lhs = aliaspair.lhs;
            Lhs rhs = aliaspair.rhs;
            out.println("  alias " + String.valueOf(lhs) + " = " + String.valueOf(rhs));
        }
        out.println("endmodule // " + String.valueOf(modName));
    }

    public void main(String[] args) {
        String command;
        if (args.length == 0) {
            DesignExplore.help();
        }
        switch (command = args[0]) {
            case "showlibs": {
                if (args.length != 2) {
                    DesignExplore.help();
                }
                this.showLibs(args[1], false);
                break;
            }
            case "showlibdb": {
                if (args.length != 2) {
                    DesignExplore.help();
                }
                this.showLibs(args[1], true);
                break;
            }
            case "strip": {
                if (args.length < 1) {
                    DesignExplore.help();
                }
                this.strip(args[1]);
                break;
            }
            case "restorepar": {
                if (args.length < 1) {
                    DesignExplore.help();
                }
                this.restoreParameterized(args[1]);
                break;
            }
            case "showmod": {
                if (args.length < 2) {
                    DesignExplore.help();
                }
                this.showMods(args[1], Arrays.copyOfRange(args, 2, args.length));
                break;
            }
            default: {
                DesignExplore.help();
            }
        }
    }
}

