/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.List;

public abstract class Path
implements SvarName {
    public static ACL2Object KEYWORD_WIRE = ACL2Object.valueOf("KEYWORD", "WIRE");
    public static ACL2Object KEYWORD_SCOPE = ACL2Object.valueOf("KEYWORD", "SCOPE");

    public static Path fromACL2(ACL2Object impl) {
        Path result;
        if (ACL2.consp(impl).bool() && Util.KEYWORD_ANONYMOIUS.bool() != ACL2.car(impl).bool()) {
            Name namespace = Name.fromACL2(ACL2.car(impl));
            Path scope = Path.fromACL2(ACL2.cdr(impl));
            result = new Scope(namespace, scope);
        } else {
            result = new Wire(Name.fromACL2(impl));
        }
        assert (((Object)result).hashCode() == impl.hashCode());
        return result;
    }

    public static Path simplePath(Name name) {
        return new Wire(name);
    }

    public static Path makePath(List<Name> scopes, Name name) {
        Path path = Path.simplePath(name);
        for (int i2 = scopes.size() - 1; i2 >= 0; --i2) {
            path = new Scope(scopes.get(i2), path);
        }
        return path;
    }

    public abstract ACL2Object getKind();

    public int getDepth() {
        Path path = this;
        int depth = 0;
        while (path instanceof Scope) {
            path = ((Scope)path).subpath;
            ++depth;
        }
        return depth;
    }

    public abstract Path append(Path var1);

    @Override
    public String toString(BigInteger mask) {
        Object s = this.toString();
        if (mask != null) {
            s = (String)s + "#" + mask.toString(16);
        }
        return s;
    }

    public static class Scope
    extends Path {
        public final Path subpath;
        public final Name namespace;
        private final int hashCode;

        Scope(Name namespace, Path subpath) {
            this.namespace = namespace;
            this.subpath = subpath;
            this.hashCode = ACL2Object.hashCodeOfCons(namespace.hashCode(), subpath.hashCode());
        }

        @Override
        public ACL2Object getKind() {
            return KEYWORD_SCOPE;
        }

        @Override
        public boolean isSimpleSvarName() {
            return false;
        }

        @Override
        public Path append(Path y) {
            return new Scope(this.namespace, this.subpath.append(y));
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 instanceof Scope) {
                Scope that = (Scope)o2;
                return this.hashCode == that.hashCode && this.namespace.equals(that.namespace) && this.subpath.equals(that.subpath);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        public ACL2Object getACL2Object() {
            ACL2Object result = ACL2.hons(this.namespace.getACL2Object(), this.subpath.getACL2Object());
            assert (result.hashCode() == this.hashCode());
            return result;
        }

        public String toString() {
            return String.valueOf(this.namespace) + "." + String.valueOf(this.subpath);
        }
    }

    public static class Wire
    extends Path {
        public final Name name;

        public Wire(Name name) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
        }

        @Override
        public ACL2Object getKind() {
            return KEYWORD_WIRE;
        }

        @Override
        public boolean isSimpleSvarName() {
            return this.name.isSimpleSvarName();
        }

        @Override
        public Path append(Path y) {
            return new Scope(this.name, y);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            return o2 instanceof Wire && this.name.equals(((Wire)o2).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public ACL2Object getACL2Object() {
            ACL2Object result = this.name.getACL2Object();
            assert (result.hashCode() == this.hashCode());
            return result;
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

