/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LhsArr {
    private final List<Lhs<IndexName>> arr;

    LhsArr(int totalWires) {
        this.arr = new ArrayList<Lhs<IndexName>>(totalWires);
        while (this.arr.size() < totalWires) {
            this.arr.add(null);
        }
    }

    public int size() {
        return this.arr.size();
    }

    public Lhs<IndexName> getLhs(int i2) {
        return this.arr.get(i2);
    }

    public Lhs<IndexName> getAlias(int i2) {
        return this.arr.get(i2);
    }

    public void setAlias(int i2, Lhs<IndexName> x) {
        this.arr.set(i2, x);
    }

    public List<Lhs<IndexName>> getArr() {
        return this.arr;
    }

    public List<Svar<IndexName>> aliasesVars() {
        ArrayList vars = new ArrayList();
        for (int i2 = this.arr.size() - 1; i2 >= 0; --i2) {
            this.getLhs(i2).vars(vars);
        }
        return vars;
    }

    public Svex<IndexName>[] toSvexarr(SvexManager<IndexName> sm) {
        Svex<N>[] result = Svex.newSvexArray(this.arr.size());
        for (int i2 = 0; i2 < this.arr.size(); ++i2) {
            result[i2] = this.arr.get(i2).toSvex(sm);
        }
        return result;
    }

    public static boolean svarIsBounded(Svar<IndexName> x, int bound) {
        return x.getName().getIndex() < bound;
    }

    public static boolean lhatomIsNormordered(int bound, int offset, Lhatom<IndexName> x) {
        Svar<IndexName> svar = x.getVar();
        if (svar == null) {
            return true;
        }
        int idx = svar.getName().getIndex();
        return idx < bound || idx == bound && x.getRsh() <= offset;
    }

    public static boolean lhsVarsIsNormordered(int bound, int offset, Lhs<IndexName> x) {
        for (Lhrange range : x.ranges) {
            if (!LhsArr.lhatomIsNormordered(bound, offset, range.getAtom())) {
                return false;
            }
            offset += range.getWidth();
        }
        return true;
    }

    public boolean isNormordered() {
        for (int n2 = 0; n2 < this.arr.size(); ++n2) {
            Lhs<IndexName> lhs = this.getAlias(n2);
            if (LhsArr.lhsVarsIsNormordered(n2, 0, lhs)) continue;
            return false;
        }
        return true;
    }

    private static void lhsCheckMasks(Lhs<IndexName> x, Map<Svar<IndexName>, BigInteger> maskAcc, Map<Svar<IndexName>, BigInteger> confAcc) {
        Lhs<IndexName> norm = x.norm();
        for (Lhrange range : norm.ranges) {
            Svar svar = range.getVar();
            if (svar == null) continue;
            BigInteger firstMask = BigIntegerUtil.logheadMask(range.getWidth()).shiftLeft(range.getRsh());
            BigInteger varMask = maskAcc.get(svar);
            if (varMask == null) {
                varMask = BigInteger.ZERO;
            }
            BigInteger conflict = firstMask.and(varMask);
            maskAcc.put(svar, firstMask.or(varMask));
            if (conflict.signum() == 0) continue;
            BigInteger oldConflict = confAcc.get(svar);
            if (oldConflict == null) {
                oldConflict = BigInteger.ZERO;
            }
            confAcc.put(svar, conflict.or(oldConflict));
        }
    }

    public static void assignsCheckMasks(Map<Lhs<IndexName>, Driver<IndexName>> assigns, Map<Svar<IndexName>, BigInteger> maskAcc, Map<Svar<IndexName>, BigInteger> confAcc) {
        for (Lhs<IndexName> lhs : assigns.keySet()) {
            LhsArr.lhsCheckMasks(lhs, maskAcc, confAcc);
        }
    }

    public Lhs<IndexName> aliasCanonicalize(Lhs<IndexName> x, int idx, int w, int offset) {
        Lhs.Decomp<IndexName> decomp = x.decomp();
        if (decomp.first == null || w == 0) {
            return new Lhs<IndexName>(Collections.emptyList());
        }
        int blockw = Math.min(w, decomp.first.getWidth());
        Lhs<IndexName> first = this.aliasCanonicalize(decomp.first, idx, blockw, offset);
        Lhs<IndexName> rest = this.aliasCanonicalize(decomp.rest, idx, w - blockw, offset + blockw);
        return first.concat(blockw, rest);
    }

    private Lhs<IndexName> aliasCanonicalize(Lhrange<IndexName> x, int idx, int w, int offset) {
        Svar<IndexName> svar = x.getVar();
        if (svar == null) {
            return new Lhs<IndexName>(Collections.emptyList());
        }
        int vidx = svar.getName().getIndex();
        if (vidx == idx && x.getRsh() == offset) {
            return new Lhs<IndexName>(Collections.singletonList(new Lhrange<IndexName>(w, x.getAtom())));
        }
        Lhs<IndexName> rsh = this.getAlias(vidx).rsh(x.getRsh());
        return this.aliasCanonicalize(rsh, vidx, w, x.getRsh());
    }

    public Lhs<IndexName> aliasCanonicalizeReplace(Lhs<IndexName> x, int idx, int w, int offset) {
        Lhs.Decomp<IndexName> decomp = x.decomp();
        if (decomp.first == null || w == 0) {
            return new Lhs<IndexName>(Collections.emptyList());
        }
        int blockw = Math.min(w, decomp.first.getWidth());
        Lhs<IndexName> newFirst = this.aliasCanonicalizeReplace(decomp.first, idx, blockw, offset);
        Lhs<IndexName> newRest = this.aliasCanonicalize(decomp.rest, idx, w - blockw, offset + blockw);
        return newFirst.concat(blockw, newRest);
    }

    private Lhs<IndexName> aliasCanonicalizeReplace(Lhrange<IndexName> x, int idx, int w, int offset) {
        Svar<IndexName> svar = x.getVar();
        if (svar == null) {
            return new Lhs<IndexName>(Collections.emptyList());
        }
        int vidx = svar.getName().getIndex();
        if (vidx == idx && x.getRsh() == offset) {
            return new Lhs<IndexName>(Collections.singletonList(new Lhrange<IndexName>(w, x.getAtom())));
        }
        Lhs<IndexName> wholeLhs = this.getAlias(vidx);
        Lhs<IndexName> leftPart = wholeLhs.rsh(x.getRsh());
        Lhs<IndexName> canon = this.aliasCanonicalizeReplace(leftPart, vidx, w, x.getRsh());
        Lhs<IndexName> leftPart2 = leftPart.rsh(w);
        Lhs<IndexName> wholeCanon = wholeLhs.concat(x.getRsh(), canon.concat(w, leftPart2));
        this.setAlias(vidx, wholeCanon);
        return canon;
    }

    private Lhs<IndexName> replaceRange(int start, int w, Lhs<IndexName> repl, Lhs<IndexName> x) {
        return x.concat(start, repl.concat(w, x.rsh(start + w)));
    }

    private void pairsSetAliases(Lhs<IndexName> x, Lhs<IndexName> y) {
        int grOffset;
        int grIdx;
        int lessOffset;
        int lessIdx;
        int yidx;
        Lhs<IndexName> nextY;
        Lhs<IndexName> nextX;
        int blkw;
        Lhs.Decomp<IndexName> dx = x.decomp();
        Lhs.Decomp<IndexName> dy = y.decomp();
        if (dx.first == null || dy.first == null) {
            return;
        }
        Lhrange xf = dx.first;
        Lhrange yf = dy.first;
        if (xf.getWidth() < yf.getWidth()) {
            blkw = xf.getWidth();
            nextX = dx.rest;
            nextY = y.rsh(xf.getWidth());
        } else if (yf.getWidth() < xf.getWidth()) {
            blkw = yf.getWidth();
            nextX = x.rsh(yf.getWidth());
            nextY = dy.rest;
        } else {
            blkw = xf.getWidth();
            nextX = dx.rest;
            nextY = dy.rest;
        }
        Svar varx = xf.getVar();
        Svar vary = yf.getVar();
        if (varx == null || vary == null || varx.equals(vary)) {
            this.pairsSetAliases(dx.rest, dy.rest);
            return;
        }
        int xidx = ((IndexName)varx.getName()).getIndex();
        if (xidx < (yidx = ((IndexName)vary.getName()).getIndex())) {
            lessIdx = xidx;
            lessOffset = xf.getRsh();
            grIdx = yidx;
            grOffset = yf.getRsh();
        } else if (yidx < xidx) {
            lessIdx = yidx;
            lessOffset = yf.getRsh();
            grIdx = xidx;
            grOffset = xf.getRsh();
        } else if (xf.getRsh() < yf.getRsh()) {
            lessIdx = xidx;
            lessOffset = xf.getRsh();
            grIdx = yidx;
            grOffset = yf.getRsh();
        } else {
            lessIdx = yidx;
            lessOffset = yf.getRsh();
            grIdx = xidx;
            grOffset = xf.getRsh();
        }
        Lhs<IndexName> greaterFull = this.getAlias(grIdx);
        Lhs<IndexName> lessFull = this.getAlias(lessIdx);
        Lhs<IndexName> lessRange = lessFull.rsh(lessOffset);
        Lhs<IndexName> greaterNew = this.replaceRange(grOffset, blkw, lessRange, greaterFull);
        this.setAlias(grIdx, greaterNew);
        this.pairsSetAliases(nextX, nextY);
    }

    public Lhs<IndexName> aliasCanonicalizeTop(Lhs<IndexName> x) {
        Lhs.Decomp<IndexName> decomp = x.decomp();
        if (decomp.first == null) {
            return new Lhs<IndexName>(Collections.emptyList());
        }
        Lhrange first = decomp.first;
        Svar svar = first.getVar();
        if (svar == null) {
            return this.aliasCanonicalizeTop(decomp.rest);
        }
        int idx = ((IndexName)svar.getName()).getIndex();
        Lhs<IndexName> low = this.aliasCanonicalize(this.getAlias(idx).rsh(first.getRsh()), idx, first.getWidth(), first.getRsh());
        Lhs<IndexName> high = this.aliasCanonicalizeTop(decomp.rest);
        return low.concat(first.getWidth(), high);
    }

    public Lhs<IndexName> aliasCanonicalizeReplaceTop(Lhs<IndexName> x) {
        Lhs.Decomp<IndexName> decomp = x.decomp();
        if (decomp.first == null) {
            return new Lhs<IndexName>(Collections.emptyList());
        }
        Lhrange first = decomp.first;
        Svar svar = first.getVar();
        if (svar == null) {
            Lhs<IndexName> restX = this.aliasCanonicalizeTop(decomp.rest);
            return restX.cons(first);
        }
        int idx = ((IndexName)svar.getName()).getIndex();
        Lhs<IndexName> alias2 = this.getAlias(idx);
        Lhs<IndexName> firstX = this.aliasCanonicalizeReplace(alias2.rsh(first.getRsh()), idx, first.getWidth(), first.getRsh());
        Lhs<IndexName> restX = this.aliasCanonicalizeReplaceTop(decomp.rest);
        return firstX.concat(first.getWidth(), restX);
    }

    private void addPair(Lhs<IndexName> x, Lhs<IndexName> y) {
        Lhs<IndexName> xCanon = this.aliasCanonicalizeTop(x);
        Lhs<IndexName> yCanon = this.aliasCanonicalizeTop(y);
        this.pairsSetAliases(xCanon, yCanon);
        this.aliasCanonicalizeReplaceTop(x);
        this.aliasCanonicalizeReplaceTop(y);
    }

    private void finishCanonicalize() {
        for (int n2 = 0; n2 < this.arr.size(); ++n2) {
            Lhs<IndexName> lhs = this.getAlias(n2);
            Lhs<IndexName> canon = this.aliasCanonicalize(lhs, n2, lhs.width(), 0);
            this.setAlias(n2, canon);
        }
    }

    public void putPairs(Collection<Aliaspair<IndexName>> aliaspairs) {
        for (Aliaspair<IndexName> aliaspair : aliaspairs) {
            this.addPair(aliaspair.lhs, aliaspair.rhs);
        }
    }

    public void canonicalizeAliasPairs(Collection<Aliaspair<IndexName>> aliaspairs) {
        this.putPairs(aliaspairs);
        this.finishCanonicalize();
    }

    public ACL2Object collectAliasesAsACL2Objects() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object result = ACL2.NIL;
        for (int i2 = this.arr.size() - 1; i2 >= 0; --i2) {
            result = ACL2.cons(this.arr.get(i2).getACL2Object(backedCache), result);
        }
        return result;
    }
}

