/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.SvarNameTexter;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Lhs<N extends SvarName>
implements ACL2Backed {
    public final List<Lhrange<N>> ranges = new LinkedList<Lhrange<N>>();
    private final int hashCode;
    private static final Lhs<?> EMPTY = new Lhs(Collections.emptyList());

    public Lhs(List<Lhrange<N>> ranges) {
        this.ranges.addAll(ranges);
        int hashCode = ACL2Object.HASH_CODE_NIL;
        for (int i2 = this.ranges.size() - 1; i2 >= 0; --i2) {
            Lhrange<N> range = this.ranges.get(i2);
            hashCode = ACL2Object.hashCodeOfCons(range.hashCode(), hashCode);
        }
        this.hashCode = hashCode;
    }

    public static <N extends SvarName> Lhs<N> empty() {
        return EMPTY;
    }

    public static <N extends SvarName> Lhs<N> fromACL2(SvarName.Builder<N> snb, SvexManager<N> sm, ACL2Object impl) {
        List<ACL2Object> l2 = Util.getList(impl, true);
        Util.check(!l2.isEmpty());
        ArrayList<Lhrange<N>> ranges = new ArrayList<Lhrange<N>>(l2.size());
        for (ACL2Object o2 : l2) {
            Lhrange<N> lhr = Lhrange.fromACL2(snb, sm, o2);
            ranges.add(lhr);
        }
        return new Lhs<N>(ranges);
    }

    public <N1 extends SvarName> Lhs<N1> convertVars(Function<N, N1> renameMap, SvexManager<N1> sm) {
        ArrayList<Lhrange<N>> newRanges = new ArrayList<Lhrange<N>>();
        for (Lhrange<N> range : this.ranges) {
            newRanges.add(range.convertVars(renameMap, sm));
        }
        return new Lhs<N>(newRanges);
    }

    public Vec4 eval(Map<Svar<N>, Vec4> env) {
        Vec4 result = Vec4.Z;
        for (int i2 = this.ranges.size() - 1; i2 >= 0; --i2) {
            Lhrange<N> range = this.ranges.get(i2);
            result = Vec4Concat.FUNCTION.apply(Vec2.valueOf(range.getWidth()), range.eval(env), result);
        }
        return result;
    }

    public int width() {
        int size = 0;
        for (Lhrange<N> lr : this.ranges) {
            size += lr.getWidth();
        }
        return size;
    }

    public Lhs<N> cons(Lhrange<N> x) {
        ArrayList<Lhrange<N>> newRanges = new ArrayList<Lhrange<N>>();
        if (this.ranges.isEmpty()) {
            if (x.getVar() != null) {
                newRanges.add(x);
            }
        } else {
            Lhrange<N> comb = x.combine(this.ranges.get(0));
            if (comb != null) {
                if (this.ranges.size() > 1 || comb.getVar() != null) {
                    newRanges.addAll(this.ranges);
                    this.ranges.set(0, comb);
                }
            } else {
                newRanges.add(x);
                newRanges.addAll(this.ranges);
            }
        }
        return new Lhs<N>(newRanges);
    }

    public Lhs<N> norm() {
        if (this.isNormp()) {
            return this;
        }
        ArrayList<Lhrange<N>> newRanges = new ArrayList<Lhrange<N>>();
        newRanges.addAll(this.ranges);
        for (int i2 = newRanges.size() - 1; i2 >= 0; --i2) {
            Lhrange range = (Lhrange)newRanges.get(i2);
            if (i2 == newRanges.size() - 1) {
                if (range.getVar() != null) continue;
                newRanges.remove(i2 - 1);
                continue;
            }
            Lhrange comb = range.combine((Lhrange)newRanges.get(i2 + 1));
            if (comb == null) continue;
            newRanges.remove(i2 + 1);
            newRanges.set(i2, comb);
        }
        if (newRanges.size() == 1 && ((Lhrange)newRanges.get(0)).getVar() == null) {
            newRanges.remove(0);
        }
        if (newRanges.equals(this.ranges)) {
            this.isNormp();
        }
        assert (!newRanges.equals(this.ranges));
        Lhs<N> newLhs = new Lhs<N>(newRanges);
        assert (newLhs.isNormp());
        return newLhs;
    }

    public boolean isNormp() {
        Svar<N> prevVar = null;
        int prevBit = -1;
        for (Lhrange<N> range : this.ranges) {
            Svar<N> svar = range.getVar();
            if (svar == null ? prevVar == null && prevBit >= 0 : svar.equals(prevVar) && range.getRsh() == prevBit) {
                return false;
            }
            prevVar = svar;
            prevBit = range.getRsh() + range.getWidth();
        }
        return prevVar != null || prevBit == -1;
    }

    public Lhs<N> concat(int w, Lhs<N> y) {
        ArrayList<Lhrange<N>> newRanges = new ArrayList<Lhrange<N>>();
        int ww = 0;
        for (int i2 = 0; i2 < this.ranges.size() && ww < w; ++i2) {
            Lhrange<N> range = this.ranges.get(i2);
            if (ww + range.getWidth() <= w) {
                newRanges.add(range);
                ww += range.getWidth();
                continue;
            }
            newRanges.add(new Lhrange<N>(w - ww, range.getAtom()));
            ww = w;
        }
        if (ww < w) {
            newRanges.add(new Lhrange(w - ww, Lhatom.Z()));
        }
        newRanges.addAll(y.ranges);
        return new Lhs<N>(newRanges).norm();
    }

    public Lhs<N> rsh(int sh) {
        ArrayList<Lhrange<N>> newRanges = new ArrayList<Lhrange<N>>(this.ranges);
        while (sh > 0 && !newRanges.isEmpty()) {
            Lhrange range = (Lhrange)newRanges.get(0);
            if (sh < range.getWidth()) {
                Lhatom atom = range.getAtom();
                Svar svar = atom.getVar();
                if (svar != null) {
                    atom = Lhatom.valueOf(svar, range.getRsh() + sh);
                }
                newRanges.set(0, new Lhrange(range.getWidth() - sh, atom));
                break;
            }
            newRanges.remove(0);
            sh -= range.getWidth();
        }
        return new Lhs<N>(newRanges).norm();
    }

    void vars(Collection<Svar<N>> vars) {
        for (Lhrange<N> range : this.ranges) {
            range.getAtom().vars(vars);
        }
    }

    public static <N extends SvarName> List<Svar<N>> lhslistVars(List<Lhs<N>> list) {
        ArrayList<Svar<N>> vars = new ArrayList<Svar<N>>();
        for (Lhs<N> lhs : list) {
            lhs.vars(vars);
        }
        return vars;
    }

    Lhrange<N> first() {
        Lhs<N> norm = this.norm();
        return norm.ranges.isEmpty() ? null : norm.ranges.get(0);
    }

    Lhs<N> rest() {
        Lhs<N> norm = this.norm();
        if (norm.ranges.isEmpty()) {
            return norm;
        }
        LinkedList<Lhrange<N>> newRanges = new LinkedList<Lhrange<N>>(norm.ranges);
        newRanges.pollFirst();
        return new Lhs<N>(newRanges);
    }

    public Decomp<N> decomp() {
        Lhs<N> norm = this.norm();
        if (norm.ranges.isEmpty()) {
            return new Decomp<N>(null, norm);
        }
        LinkedList<Lhrange<N>> newRanges = new LinkedList<Lhrange<N>>(norm.ranges);
        Lhrange<N> first = newRanges.pollFirst();
        Lhs<N> rest = new Lhs<N>(newRanges);
        return new Decomp<N>(first, rest);
    }

    public Svex<N> toSvex(SvexManager<N> sm) {
        Svex svex = SvexQuote.Z();
        for (int i2 = this.ranges.size() - 1; i2 >= 0; --i2) {
            Lhrange<N> range = this.ranges.get(i2);
            svex = range.getAtom().toSvex(sm).concat(sm, range.getWidth(), svex);
        }
        return svex;
    }

    public static <N extends SvarName> Lhs<N> makeSimpleLhs(int width, int rsh, Svar<N> svar) {
        Lhatom<N> atom = Lhatom.valueOf(svar, rsh);
        Lhrange<N> range = new Lhrange<N>(width, atom);
        return new Lhs<N>(Collections.singletonList(range));
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof Lhs) {
            Lhs that = (Lhs)o2;
            return this.hashCode == that.hashCode && this.ranges.equals(that.ranges);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ACL2Object getACL2Object(Map<ACL2Backed, ACL2Object> backedCache) {
        ACL2Object list = ACL2.NIL;
        for (int i2 = this.ranges.size() - 1; i2 >= 0; --i2) {
            list = ACL2.hons(this.ranges.get(i2).getACL2Object(backedCache), list);
        }
        assert (list.hashCode() == this.hashCode);
        return list;
    }

    public String toString() {
        Object s = "";
        for (int i2 = this.ranges.size() - 1; i2 >= 0; --i2) {
            s = (String)s + String.valueOf(this.ranges.get(i2));
            if (i2 <= 0) continue;
            s = (String)s + ",";
        }
        return s;
    }

    public String toString(SvarNameTexter<N> texter) {
        Object s = "";
        this.width();
        for (int i2 = this.ranges.size() - 1; i2 >= 0; --i2) {
            s = (String)s + this.ranges.get(i2).toString(texter);
            if (i2 <= 0) continue;
            s = (String)s + ",";
        }
        return s;
    }

    public static <N extends SvarName> Lhs<N>[] newLhsArray(int length) {
        return new Lhs[length];
    }

    public static class Decomp<N extends SvarName> {
        public final Lhrange<N> first;
        public final Lhs<N> rest;

        private Decomp(Lhrange<N> first, Lhs<N> rest) {
            this.first = first;
            this.rest = rest;
        }
    }
}

