/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.LhsArr;
import com.sun.electric.tool.simulation.acl2.mods.ModDb;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarNameTexter;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ElabMod {
    final ModName modName;
    final Wire[] wireTable;
    final Map<Name, Integer> wireNameIdxes = new HashMap<Name, Integer>();
    final int numBits;
    final ElabModInst[] modInstTable;
    final Map<Name, ElabModInst> modInstNameIdxes = new HashMap<Name, ElabModInst>();
    final int totalWires;
    final int totalBits;
    final int totalInsts;
    final int totalAssigns;
    final Module<Address> origMod;
    final int modMeas;

    ElabMod(ModName modName, Module<Address> origMod, Map<ModName, ElabMod> modnameIdxes) {
        this.modName = modName;
        this.origMod = origMod;
        this.wireTable = origMod.wires.toArray(new Wire[origMod.wires.size()]);
        int numBits = 0;
        for (int i2 = 0; i2 < this.wireTable.length; ++i2) {
            Wire wire = this.wireTable[i2];
            Integer old = this.wireNameIdxes.put(wire.name, i2);
            assert (old == null);
            numBits += wire.width;
        }
        this.numBits = numBits;
        this.modInstTable = new ElabModInst[origMod.insts.size()];
        int wireOfs = this.wireTable.length;
        int bitOfs = numBits;
        int instOfs = this.modInstTable.length;
        int assignOfs = origMod.assigns.size();
        int meas = 1;
        for (int i3 = 0; i3 < origMod.insts.size(); ++i3) {
            ElabModInst elabModInst;
            ModInst modInst = origMod.insts.get(i3);
            ElabMod modidx = modnameIdxes.get(modInst.modname);
            if (modidx == null) {
                throw new IllegalArgumentException();
            }
            this.modInstTable[i3] = elabModInst = new ElabModInst(i3, modInst.instname, modidx, wireOfs, instOfs, assignOfs, bitOfs);
            ElabModInst old = this.modInstNameIdxes.put(modInst.instname, elabModInst);
            assert (old == null);
            wireOfs += modidx.totalWires;
            bitOfs += modidx.totalBits;
            instOfs += modidx.totalInsts;
            assignOfs += modidx.totalAssigns;
            meas += 1 + elabModInst.instMeas;
        }
        this.totalWires = wireOfs;
        this.totalBits = bitOfs;
        this.totalInsts = instOfs;
        this.totalAssigns = assignOfs;
        this.modMeas = meas;
    }

    public ModName modidxGetName() {
        return this.modName;
    }

    public int modNWires() {
        return this.wireTable.length;
    }

    public int modNInsts() {
        return this.modInstTable.length;
    }

    public int modNAssigns() {
        return this.origMod.assigns.size();
    }

    public int modNBits() {
        return this.numBits;
    }

    public int modTotalWires() {
        return this.totalWires;
    }

    public int modTotalInsts() {
        return this.totalInsts;
    }

    public int modTotalAssigns() {
        return this.totalAssigns;
    }

    public int modTotalBits() {
        return this.totalBits;
    }

    public ElabModInst getInst(int instIndex) {
        return this.modInstTable[instIndex];
    }

    public int wireFindInst(int wire) {
        if (wire < this.wireTable.length || wire >= this.totalWires) {
            throw new IllegalArgumentException();
        }
        int minInst = 0;
        int maxInst = this.modInstTable.length;
        while (maxInst > 1 + minInst) {
            int guess = maxInst - minInst >> 1;
            int pivot = minInst + guess;
            int pivotOffset = this.modInstTable[pivot].wireOffset;
            if (wire < pivotOffset) {
                maxInst = pivot;
                continue;
            }
            minInst = pivot;
        }
        return minInst;
    }

    public int instFindInst(int inst) {
        if (inst < this.modInstTable.length || inst >= this.totalInsts) {
            throw new IllegalArgumentException();
        }
        int minInst = 0;
        int maxInst = this.modInstTable.length;
        while (maxInst > 1 + minInst) {
            int guess = maxInst - minInst >> 1;
            int pivot = minInst + guess;
            int pivotOffset = this.modInstTable[pivot].instOffset;
            if (inst < pivotOffset) {
                maxInst = pivot;
                continue;
            }
            minInst = pivot;
        }
        return minInst;
    }

    int assignFindInst(int assign) {
        if (assign < this.origMod.assigns.size() || assign >= this.totalAssigns) {
            throw new IllegalArgumentException();
        }
        int minInst = 0;
        int maxInst = this.modInstTable.length;
        while (maxInst > 1 + minInst) {
            int guess = maxInst - minInst >> 1;
            int pivot = minInst + guess;
            int pivotOffset = this.modInstTable[pivot].assignOffset;
            if (assign < pivotOffset) {
                maxInst = pivot;
                continue;
            }
            minInst = pivot;
        }
        return minInst;
    }

    public Path wireidxToPath(int wireidx) {
        if (wireidx < 0 || wireidx >= this.totalWires) {
            throw new IllegalArgumentException();
        }
        LinkedList<Name> stack = new LinkedList<Name>();
        ElabMod elabMod = this;
        while (wireidx >= elabMod.wireTable.length) {
            int instIdx = elabMod.wireFindInst(wireidx);
            ElabModInst elabModInst = elabMod.modInstTable[instIdx];
            stack.add(elabModInst.instName);
            wireidx -= elabModInst.wireOffset;
            elabMod = elabModInst.modidx;
        }
        return Path.makePath(stack, elabMod.wireTable[wireidx].name);
    }

    public Path[] wireidxToPaths(int[] wires) {
        Path[] result = new Path[wires.length];
        for (int i2 = 0; i2 < wires.length; ++i2) {
            result[i2] = this.wireidxToPath(wires[i2]);
        }
        return result;
    }

    public ModInst instIndexToInstDecl(int instidx) {
        ElabMod elabMod = this;
        while (instidx >= elabMod.modInstTable.length) {
            int instIdx = elabMod.instFindInst(instidx);
            ElabModInst elabModInst = elabMod.modInstTable[instIdx];
            instidx -= elabModInst.instOffset;
            elabMod = elabModInst.modidx;
        }
        return elabMod.origMod.insts.get(instidx);
    }

    public int pathToWireIdx(Path path) {
        int wireOffset = 0;
        ElabMod elabMod = this;
        while (path instanceof Path.Scope) {
            Path.Scope pathScope = (Path.Scope)path;
            ElabModInst instidx = elabMod.modInstNameIdxes.get(pathScope.namespace);
            if (instidx == null) {
                throw new RuntimeException("In module " + String.valueOf(elabMod.modName) + ": missing: " + String.valueOf(pathScope.namespace));
            }
            wireOffset += instidx.wireOffset;
            elabMod = instidx.modidx;
            path = pathScope.subpath;
        }
        Path.Wire pathWire = (Path.Wire)path;
        Integer wireIdx = elabMod.wireNameIdxes.get(pathWire.name);
        if (wireIdx == null) {
            throw new RuntimeException("In module " + String.valueOf(elabMod.modName) + ": missing: " + String.valueOf(pathWire.name));
        }
        return wireOffset + wireIdx;
    }

    public Wire pathToWireDecl(Path path) {
        ElabMod elabMod = this;
        while (path instanceof Path.Scope) {
            Path.Scope pathScope = (Path.Scope)path;
            ElabModInst instidx = elabMod.modInstNameIdxes.get(pathScope.namespace);
            if (instidx == null) {
                throw new RuntimeException("In module " + String.valueOf(elabMod.modName) + ": missing: " + String.valueOf(pathScope.namespace));
            }
            elabMod = instidx.modidx;
            path = pathScope.subpath;
        }
        Path.Wire pathWire = (Path.Wire)path;
        Integer wireIdx = elabMod.wireNameIdxes.get(pathWire.name);
        if (wireIdx == null) {
            throw new RuntimeException("In module " + String.valueOf(elabMod.modName) + ": missing: " + String.valueOf(pathWire.name));
        }
        return elabMod.wireTable[wireIdx];
    }

    private String pathToString(Path path, int width, int rsh) {
        Wire wire = this.pathToWireDecl(path);
        Object prefix = "";
        while (path instanceof Path.Scope) {
            Path.Scope ps = (Path.Scope)path;
            prefix = (String)prefix + String.valueOf(ps.namespace) + ".";
            path = ps.subpath;
        }
        Path.Wire pw = (Path.Wire)path;
        assert (pw.name.equals(wire.name));
        return (String)prefix + wire.toString(width, rsh);
    }

    public SvarNameTexter<IndexName> getIndexNameTexter() {
        return new SvarNameTexter<IndexName>(){

            @Override
            public String toString(IndexName name, int width, int rsh) {
                return ElabMod.this.pathToString(ElabMod.this.wireidxToPath(name.getIndex()), width, rsh);
            }
        };
    }

    public SvarNameTexter<Path> getPathTexter() {
        return new SvarNameTexter<Path>(){

            @Override
            public String toString(Path path, int width, int rsh) {
                return ElabMod.this.pathToString(path, width, rsh);
            }
        };
    }

    public SvarNameTexter<Address> getAddressTexter() {
        return new SvarNameTexter<Address>(){

            @Override
            public String toString(Address address, int width, int rsh) {
                Object s = ElabMod.this.pathToString(address.getPath(), width, rsh);
                if (address.index != -1) {
                    s = "{" + address.index + "}" + (String)s;
                }
                if (address.scope == -1) {
                    s = "/" + (String)s;
                } else {
                    for (int i2 = 0; i2 < address.scope; ++i2) {
                        s = "../" + (String)s;
                    }
                }
                return s;
            }
        };
    }

    public Svar<Address> svarNamedToIndexed(Svar<Address> svar, SvexManager<Address> sm) {
        int idx;
        Address addr = svar.getName();
        int n2 = idx = addr.scope != 0 ? -1 : this.pathToWireIdx(addr.getPath());
        if (addr.index == idx) {
            return svar;
        }
        Address newAddr = new Address(addr.getPath(), idx, addr.getScope());
        return sm.getVar(newAddr, svar.getDelay(), svar.isNonblocking());
    }

    private Svex<Address> svexNamedToIndex(Svex<Address> x, SvexManager<Address> sm, Map<Svex<Address>, Svex<Address>> svexCache) {
        Svex<Address> result = svexCache.get(x);
        if (result == null) {
            if (x instanceof SvexVar) {
                SvexVar xv = (SvexVar)x;
                Svar<Address> name = this.svarNamedToIndexed(xv.svar, sm);
                result = new SvexVar<Address>(name);
            } else if (x instanceof SvexQuote) {
                result = x;
            } else {
                SvexCall sc = (SvexCall)x;
                Svex<N>[] args = sc.getArgs();
                Svex<N>[] newArgs = Svex.newSvexArray(args.length);
                for (int i2 = 0; i2 < args.length; ++i2) {
                    newArgs[i2] = this.svexNamedToIndex(args[i2], sm, svexCache);
                }
                result = sm.newCall(sc.fun, newArgs);
            }
            svexCache.put(x, result);
        }
        return result;
    }

    private Lhs<Address> lhsNamedToIndex(Lhs<Address> x, SvexManager<Address> sm) {
        ArrayList newRanges = new ArrayList();
        for (Lhrange<Object> range : x.ranges) {
            Svar<Address> svar = range.getVar();
            if (svar != null) {
                svar = this.svarNamedToIndexed(svar, sm);
                Lhatom<Address> atom = Lhatom.valueOf(svar, range.getRsh());
                range = new Lhrange<Address>(range.getWidth(), atom);
            }
            newRanges.add(range);
        }
        return new Lhs<Address>(newRanges);
    }

    Module<Address> moduleNamedToIndex(Module<Address> m2) {
        SvexManager<Address> sm = new SvexManager<Address>();
        HashMap<Svex<Address>, Svex<Address>> svexCache = new HashMap<Svex<Address>, Svex<Address>>();
        ArrayList newAssigns = new ArrayList();
        for (Assign assign : m2.assigns) {
            Lhs<Address> newLhs = this.lhsNamedToIndex(assign.lhs, sm);
            Driver driver = assign.driver;
            Svex<Address> newSvex = this.svexNamedToIndex(driver.svex, sm, svexCache);
            Driver<Address> newDriver = new Driver<Address>(newSvex, driver.strength);
            Assign<Address> newAssign = new Assign<Address>(newLhs, newDriver);
            newAssigns.add(newAssign);
        }
        ArrayList newAliasepairs = new ArrayList();
        for (Aliaspair aliaspair : m2.aliaspairs) {
            Lhs<Address> newLhs = this.lhsNamedToIndex(aliaspair.lhs, sm);
            Lhs<Address> newRhs = this.lhsNamedToIndex(aliaspair.rhs, sm);
            Aliaspair<Address> newAliaspair = new Aliaspair<Address>(newLhs, newRhs);
            newAliasepairs.add(newAliaspair);
        }
        return new Module<Address>(sm, m2.wires, m2.insts, newAssigns, newAliasepairs);
    }

    void initializeAliases(int offset, SvexManager<IndexName> sm, LhsArr aliases) {
        for (Wire wire : this.wireTable) {
            IndexName name = IndexName.valueOf(offset);
            Svar<IndexName> svar = sm.getVar(name);
            Lhatom<IndexName> atom = Lhatom.valueOf(svar);
            Lhrange<IndexName> range = new Lhrange<IndexName>(wire.width, atom);
            Lhs<IndexName> lhs = new Lhs<IndexName>(Collections.singletonList(range));
            aliases.setAlias(offset, lhs);
            ++offset;
        }
    }

    void initialAliases(int offset, SvexManager<IndexName> sm, LhsArr aliases) {
        this.initializeAliases(offset, sm, aliases);
        for (ElabModInst inst : this.modInstTable) {
            inst.modidx.initialAliases(offset + inst.wireOffset, sm, aliases);
        }
    }

    public ModDb.FlattenResult svexmodFlatten(Map<ModName, Module<Address>> modalist) {
        ModScope modScope = new ModScope(this);
        ModDb.FlattenResult result = new ModDb.FlattenResult();
        SvexManager<IndexName> sm = result.sm;
        modScope.svexmodFlatten(modalist, result);
        result.aliases = this.initialAliases(sm);
        result.aliases.canonicalizeAliasPairs(result.aliaspairs);
        return result;
    }

    LhsArr initialAliases(SvexManager<IndexName> sm) {
        LhsArr aliases = new LhsArr(this.totalWires);
        this.initialAliases(0, sm, aliases);
        return aliases;
    }

    public static class ElabModInst {
        final int instIndex;
        final Name instName;
        final ElabMod modidx;
        public final int wireOffset;
        final int instOffset;
        public final int assignOffset;
        final int bitOffset;
        final int instMeas;

        ElabModInst(int instIndex, Name instName, ElabMod modidx, int wireOffset, int instOffset, int assignOffset, int bitOffset) {
            this.instIndex = instIndex;
            this.instName = instName;
            this.modidx = modidx;
            this.wireOffset = wireOffset;
            this.instOffset = instOffset;
            this.assignOffset = assignOffset;
            this.bitOffset = bitOffset;
            this.instMeas = modidx.modMeas + 1;
        }
    }

    public static class ModScope {
        final ElabMod modIdx;
        final int wireOffset;
        final int instOffset;
        final int assignOffset;
        final int bitOffset;
        final ModScope upper;

        public ModScope(ElabMod modIdx) {
            this(modIdx, 0, 0, 0, 0, null);
        }

        private ModScope(ElabMod modIdx, int wireOffset, int instOffset, int assignOffset, int bitOffset, ModScope upper) {
            this.modIdx = modIdx;
            this.wireOffset = wireOffset;
            this.instOffset = instOffset;
            this.assignOffset = assignOffset;
            this.bitOffset = bitOffset;
            this.upper = upper;
        }

        public ElabMod getMod() {
            return this.modIdx;
        }

        boolean okp() {
            if (this.upper == null) {
                return this.wireOffset == 0 && this.instOffset == 0;
            }
            return this.upper.okp() && this.upper.wireOffset <= this.wireOffset && this.modIdx.totalWires + this.wireOffset <= this.upper.modIdx.totalWires + this.upper.wireOffset && this.upper.instOffset <= this.instOffset && this.modIdx.totalInsts + this.instOffset >= this.upper.modIdx.totalInsts + this.upper.instOffset;
        }

        ModScope pushFrame(int instidx) {
            ElabModInst elabModInst = this.modIdx.modInstTable[instidx];
            return new ModScope(elabModInst.modidx, elabModInst.wireOffset + this.wireOffset, elabModInst.instOffset + this.instOffset, elabModInst.assignOffset + this.assignOffset, elabModInst.bitOffset + this.bitOffset, this);
        }

        ModScope top() {
            ModScope result = this;
            while (result.upper != null) {
                result = result.upper;
            }
            return result;
        }

        ModScope nth(int n2) {
            ModScope result = this;
            while (n2 > 0 && result.upper != null) {
                result = result.upper;
            }
            return result;
        }

        int addressToWireindex(Address addr) {
            ModScope scope1 = addr.scope == -1 ? this.top() : this.nth(addr.scope);
            return scope1.pathToWireindex(addr.path);
        }

        Wire addressToWiredecl(Address addr) {
            ModScope scope1 = addr.scope == -1 ? this.top() : this.nth(addr.scope);
            return scope1.pathToWiredecl(addr.path);
        }

        int pathToWireindex(Path path) {
            int localIdx = this.modIdx.pathToWireIdx(path);
            return localIdx + this.wireOffset;
        }

        Wire pathToWiredecl(Path path) {
            return this.modIdx.pathToWireDecl(path);
        }

        public int localBound() {
            return this.modIdx.wireTable.length;
        }

        public int totalBound() {
            return this.modIdx.totalWires;
        }

        public Svar<IndexName> absindexed(Svar<Address> x, SvexManager<IndexName> sm) {
            Address i2 = x.getName();
            int index = i2.index >= 0 ? this.wireOffset + i2.index : this.addressToWireindex(i2);
            return sm.getVar(IndexName.valueOf(index), x.getDelay(), x.isNonblocking());
        }

        public Svex<IndexName> absindexed(Svex<Address> x, SvexManager<IndexName> sm, Map<Svex<Address>, Svex<IndexName>> svexCache) {
            Svex<IndexName> result = svexCache.get(x);
            if (result == null) {
                if (x instanceof SvexVar) {
                    SvexVar xv = (SvexVar)x;
                    Svar<IndexName> name = this.absindexed(xv.svar, sm);
                    result = new SvexVar<IndexName>(name);
                } else if (x instanceof SvexQuote) {
                    result = SvexQuote.valueOf(((SvexQuote)x).val);
                } else {
                    SvexCall sc = (SvexCall)x;
                    Svex<N>[] args = sc.getArgs();
                    Svex<N>[] newArgs = Svex.newSvexArray(args.length);
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        newArgs[i2] = this.absindexed(args[i2], sm, svexCache);
                    }
                    result = sm.newCall(sc.fun, newArgs);
                }
                svexCache.put(x, result);
            }
            return result;
        }

        private Lhs<IndexName> absindexed(Lhs<Address> x, SvexManager<IndexName> sm) {
            ArrayList newRanges = new ArrayList();
            for (Lhrange range : x.ranges) {
                Lhatom<Object> newAtom;
                Svar<Address> svar = range.getVar();
                if (svar != null) {
                    Svar<IndexName> newSvar = this.absindexed(svar, sm);
                    newAtom = Lhatom.valueOf(newSvar, range.getRsh());
                } else {
                    newAtom = Lhatom.Z();
                }
                Lhrange newRange = new Lhrange(range.getWidth(), newAtom);
                newRanges.add(newRange);
            }
            return new Lhs<IndexName>(newRanges);
        }

        private void svexmodFlatten(Map<ModName, Module<Address>> modalist, ModDb.FlattenResult result) {
            Lhs<IndexName> newLhs;
            SvexManager<IndexName> sm = result.sm;
            HashMap<Svex<Address>, Svex<IndexName>> svexCache = new HashMap<Svex<Address>, Svex<IndexName>>();
            Module<Address> m2 = this.modIdx.origMod;
            for (Assign assign : m2.assigns) {
                newLhs = this.absindexed(assign.lhs, sm);
                Driver driver = assign.driver;
                Svex<IndexName> newSvex = this.absindexed(driver.svex, sm, svexCache);
                Driver<IndexName> newDriver = new Driver<IndexName>(newSvex, driver.strength);
                Assign<IndexName> newAssign = new Assign<IndexName>(newLhs, newDriver);
                result.assigns.add(newAssign);
            }
            for (Aliaspair aliaspair : m2.aliaspairs) {
                newLhs = this.absindexed(aliaspair.lhs, sm);
                Lhs<IndexName> newRhs = this.absindexed(aliaspair.rhs, sm);
                Aliaspair<IndexName> newAliaspair = new Aliaspair<IndexName>(newLhs, newRhs);
                result.aliaspairs.add(newAliaspair);
            }
            for (int instidx = 0; instidx < m2.insts.size(); ++instidx) {
                ModScope modScope = this.pushFrame(instidx);
                modScope.svexmodFlatten(modalist, result);
            }
        }

        private Svar<Path> indexedToPath(Svar<IndexName> var, SvexManager<Path> sm) {
            int idx = var.getName().getIndex();
            Path name = this.modIdx.wireidxToPath(idx);
            return sm.getVar(name);
        }

        private Svar<Address> indexedToAddress(Svar<IndexName> var, SvexManager<Address> sm) {
            int idx = var.getName().getIndex();
            Path path = this.modIdx.wireidxToPath(idx);
            Address address = new Address(path);
            return sm.getVar(address);
        }

        public Lhs<Path> indexedToPath(Lhs<IndexName> lhs, SvexManager<Path> sm) {
            ArrayList newRanges = new ArrayList();
            for (Lhrange range : lhs.ranges) {
                Svar<IndexName> svar = range.getVar();
                Lhatom<Object> newAtom = svar == null ? Lhatom.Z() : Lhatom.valueOf(this.indexedToPath(svar, sm), range.getRsh());
                newRanges.add(new Lhrange(range.getWidth(), newAtom));
            }
            return new Lhs<Path>(newRanges);
        }

        public Lhs<Address> indexedToAddress(Lhs<IndexName> lhs, SvexManager<Address> sm) {
            ArrayList newRanges = new ArrayList();
            for (Lhrange range : lhs.ranges) {
                Svar<IndexName> svar = range.getVar();
                Lhatom<Object> newAtom = svar == null ? Lhatom.Z() : Lhatom.valueOf(this.indexedToAddress(svar, sm), range.getRsh());
                newRanges.add(new Lhrange(range.getWidth(), newAtom));
            }
            return new Lhs<Address>(newRanges);
        }

        public List<Lhs<Path>> aliasesToPath(LhsArr aliases, SvexManager<Path> sm) {
            ArrayList<Lhs<Path>> result = new ArrayList<Lhs<Path>>(aliases.size());
            for (int i2 = 0; i2 < aliases.size(); ++i2) {
                result.add(this.indexedToPath(aliases.getAlias(i2), sm));
            }
            return result;
        }

        public List<Lhs<Address>> aliasesToAddress(LhsArr aliases, SvexManager<Address> sm) {
            ArrayList<Lhs<Address>> result = new ArrayList<Lhs<Address>>(aliases.size());
            for (int i2 = 0; i2 < aliases.size(); ++i2) {
                result.add(this.indexedToAddress(aliases.getAlias(i2), sm));
            }
            return result;
        }

        public ACL2Object aliasesToNamedACL2Object(LhsArr aliases, SvexManager<Path> sm) {
            List<Lhs<Path>> namedAliases = this.aliasesToPath(aliases, sm);
            ACL2Object result = ACL2.NIL;
            for (int i2 = namedAliases.size() - 1; i2 >= 0; --i2) {
                result = ACL2.cons(namedAliases.get(i2).getACL2Object(), result);
            }
            return result;
        }
    }
}

