/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.mods;

import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.List;

public class Address
implements SvarName {
    public static final ACL2Object KEYWORD_ADDRESS = ACL2Object.valueOf("KEYWORD", "ADDRESS");
    public static final ACL2Object KEYWORD_ROOT = ACL2Object.valueOf("KEYWORD", "ROOT");
    public static final int INDEX_NIL = -1;
    public static final int SCOPE_ROOT = -1;
    public final Path path;
    public final int index;
    public final int scope;
    private final int hashCode;

    Address(Path path) {
        this.path = path;
        this.index = -1;
        this.scope = 0;
        this.hashCode = path.hashCode();
    }

    Address(Path path, int index, int scope) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (index < -1 || scope < -1) {
            throw new IllegalArgumentException();
        }
        this.path = path;
        this.index = index;
        this.scope = scope;
        this.hashCode = index == -1 && scope == 0 ? path.hashCode() : ACL2Object.hashCodeOfCons(KEYWORD_ADDRESS.hashCode(), ACL2Object.hashCodeOfCons(path.hashCode(), ACL2Object.hashCodeOfCons(index >= 0 ? ACL2Object.hashCodeOf(index) : ACL2Object.HASH_CODE_NIL, ACL2Object.hashCodeOfCons(scope >= 0 ? ACL2Object.hashCodeOf(scope) : KEYWORD_ROOT.hashCode(), ACL2Object.HASH_CODE_NIL))));
    }

    public static Address valueOf(Path path) {
        return new Address(path);
    }

    @Override
    public boolean isSimpleSvarName() {
        return this.path.isSimpleSvarName() && this.index == -1 && this.scope == 0;
    }

    public static Address fromACL2(ACL2Object impl) {
        Address result;
        if (ACL2.consp(impl).bool() && KEYWORD_ADDRESS.equals(ACL2.car(impl))) {
            int scope;
            int index;
            List<ACL2Object> list = Util.getList(impl, true);
            Path path = Path.fromACL2(list.get(1));
            if (ACL2.integerp(list.get(2)).bool()) {
                index = list.get(2).intValueExact();
                Util.check(index >= 0);
            } else {
                Util.checkNil(list.get(2));
                index = -1;
            }
            if (KEYWORD_ROOT.equals(list.get(3))) {
                scope = -1;
            } else {
                scope = list.get(3).intValueExact();
                Util.check(scope >= 0);
            }
            result = new Address(path, index, scope);
        } else {
            Path path = Path.fromACL2(impl);
            result = new Address(path);
        }
        assert (result.hashCode() == impl.hashCode());
        return result;
    }

    public Path getPath() {
        return this.path;
    }

    public Integer getIndex() {
        return this.index >= 0 ? Integer.valueOf(this.index) : null;
    }

    public Integer getScope() {
        return this.scope >= 0 ? Integer.valueOf(this.scope) : null;
    }

    @Override
    public String toString(BigInteger mask) {
        return this.path.toString(mask);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof Address) {
            Address that = (Address)o2;
            return this.hashCode == that.hashCode && this.path.equals(that.path) && this.index == that.index && this.scope == that.scope;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ACL2Object getACL2Object() {
        ACL2Object result;
        ACL2Object pathImpl = this.path.getACL2Object();
        if (this.index == -1 && this.scope == 0) {
            result = pathImpl;
        } else {
            ACL2Object indexImpl = this.index >= 0 ? ACL2Object.valueOf(this.index) : ACL2.NIL;
            ACL2Object scopeImpl = this.scope >= 0 ? ACL2Object.valueOf(this.scope) : KEYWORD_ROOT;
            result = ACL2.hons(KEYWORD_ADDRESS, ACL2.hons(pathImpl, ACL2.hons(indexImpl, ACL2.hons(scopeImpl, ACL2.NIL))));
        }
        assert (result.hashCode() == this.hashCode());
        return result;
    }

    public String toString() {
        Object s = this.path.toString();
        if (this.scope == -1) {
            s = "/" + (String)s;
        } else if (this.scope > 0) {
            for (int i2 = 0; i2 < this.scope; ++i2) {
                s = "../" + (String)s;
            }
        }
        return s;
    }

    public static boolean svarIdxaddrOkp(Svar<Address> svar, int bound) {
        Address addr = svar.getName();
        return addr.index == -1 || addr.index < bound;
    }

    public static class SvarNameBuilder
    implements SvarName.Builder<Address> {
        @Override
        public Address fromACL2(ACL2Object impl) {
            return Address.fromACL2(impl);
        }
    }
}

