/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class BusSample<S extends Sample>
implements Sample {
    private final Sample[] vals;

    public BusSample(Sample[] vals) {
        int numValids = 0;
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (vals[i2] == null) continue;
            ++numValids;
        }
        this.vals = new Sample[numValids];
        int fill = 0;
        for (int i3 = 0; i3 < vals.length; ++i3) {
            if (vals[i3] == null) continue;
            this.vals[fill++] = vals[i3];
        }
    }

    public int getWidth() {
        return this.vals.length;
    }

    public S getTrace(int i2) {
        return (S)this.vals[i2];
    }

    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof BusSample)) {
            return false;
        }
        BusSample bo = (BusSample)o2;
        if (bo.vals.length != this.vals.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            if (this.vals[i2].equals(bo.vals[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            ret ^= this.vals[i2].hashCode();
        }
        return ret;
    }

    @Override
    public boolean isLogicX() {
        for (Sample s : this.vals) {
            if (s.isLogicX()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLogicZ() {
        for (Sample s : this.vals) {
            if (s.isLogicZ()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Sample lub(Sample s) {
        if (!(s instanceof BusSample)) {
            throw new RuntimeException("tried to call BusSample.lub(" + s.getClass().getName() + ")");
        }
        BusSample ds = (BusSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call lub() on BusSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = this.vals[i2].lub(ds.vals[i2]);
        }
        return new BusSample<S>(ret);
    }

    @Override
    public Sample glb(Sample s) {
        if (!(s instanceof BusSample)) {
            throw new RuntimeException("tried to call BusSample.glb(" + s.getClass().getName() + ")");
        }
        BusSample ds = (BusSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call glb() on BusSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i2 = 0; i2 < ret.length; ++i2) {
            ret[i2] = this.vals[i2].glb(ds.vals[i2]);
        }
        return new BusSample<S>(ret);
    }

    @Override
    public double getMinValue() {
        double min = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            min = Math.min(min, this.vals[i2].getMinValue());
        }
        return min;
    }

    @Override
    public double getMaxValue() {
        double max = -1.7976931348623157E308;
        for (int i2 = 0; i2 < this.vals.length; ++i2) {
            max = Math.max(max, this.vals[i2].getMaxValue());
        }
        return max;
    }

    public static <SS extends Sample> Signal<BusSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, int width) {
        throw new RuntimeException("not implemented");
    }

    public static <SS extends Sample> Signal<BusSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital, final Signal<SS>[] subsignals) {
        return new Signal<BusSample<SS>>(sc, sd, signalName, signalContext, digital){

            @Override
            public boolean isEmpty() {
                for (Signal sig : subsignals) {
                    if (sig.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Signal<?>[] getBusMembers() {
                return subsignals;
            }

            @Override
            public Signal.View<RangeSample<BusSample<SS>>> getRasterView(double t0, double t1, int numPixels) {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i2 = 0; i2 < subviews.length; ++i2) {
                    subviews[i2] = subsignals[i2].getRasterView(t0, t1, numPixels);
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i3 = 0; i3 < subviews.length; ++i3) {
                    Signal.View view = subviews[i3];
                    for (int j2 = 0; j2 < view.getNumEvents(); ++j2) {
                        Double t = view.getTime(j2);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i3);
                    }
                }
                final double[] times = new double[tm.size()];
                final RangeSample[] vals = new RangeSample[tm.size()];
                int i4 = 0;
                int[] event = new int[subviews.length];
                Sample[] minvals = new Sample[subviews.length];
                Sample[] maxvals = new Sample[subviews.length];
                for (Double t : tm.keySet()) {
                    times[i4] = t;
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator iterator = hs.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        if (subviews[v].getTime(event[v]) != t.doubleValue()) continue;
                        RangeSample rs = (RangeSample)subviews[v].getSample(event[v]);
                        if (rs != null) {
                            minvals[v] = rs.getMin();
                            maxvals[v] = rs.getMax();
                        }
                        int n2 = v;
                        event[n2] = event[n2] + 1;
                    }
                    vals[i4] = new RangeSample(new BusSample(minvals), new BusSample(maxvals));
                    ++i4;
                }
                return new Signal.View<RangeSample<BusSample<SS>>>(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int getNumEvents() {
                        return times.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times[event];
                    }

                    @Override
                    public RangeSample<BusSample<SS>> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public Signal.View<BusSample<SS>> getExactView() {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i2 = 0; i2 < subviews.length; ++i2) {
                    subviews[i2] = subsignals[i2].getExactView();
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i3 = 0; i3 < subviews.length; ++i3) {
                    Signal.View view = subviews[i3];
                    for (int j2 = 0; j2 < view.getNumEvents(); ++j2) {
                        Double t = view.getTime(j2);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i3);
                    }
                }
                final double[] times = new double[tm.size()];
                final BusSample[] vals = new BusSample[tm.size()];
                int i4 = 0;
                int[] event = new int[subviews.length];
                Sample[] sampleVals = new Sample[subviews.length];
                for (Double t : tm.keySet()) {
                    times[i4] = t;
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator iterator = hs.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        assert (subviews[v].getTime(event[v]) == t.doubleValue());
                        Object rs = subviews[v].getSample(event[v]);
                        if (rs != null) {
                            sampleVals[v] = rs;
                        }
                        int n2 = v;
                        event[n2] = event[n2] + 1;
                    }
                    vals[i4] = new BusSample(sampleVals);
                    ++i4;
                }
                return new Signal.View<BusSample<SS>>(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int getNumEvents() {
                        return times.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times[event];
                    }

                    @Override
                    public BusSample<SS> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public double getMinTime() {
                double min = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min = Math.min(min, sig.getMinTime());
                }
                return min;
            }

            @Override
            public double getMaxTime() {
                double max = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max = Math.max(max, sig.getMaxTime());
                }
                return max;
            }

            @Override
            public double getMinValue() {
                double min = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min = Math.min(min, sig.getMinValue());
                }
                return min;
            }

            @Override
            public double getMaxValue() {
                double max = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max = Math.max(max, sig.getMaxValue());
                }
                return max;
            }

            @Override
            public void plot(Panel panel, Graphics g2, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                Dimension sz = panel.getSize();
                int hei = sz.height;
                Signal<?> ds = ws.getSignal();
                Signal.View<RangeSample<?>> view = ds.getRasterView(panel.convertXScreenToData(0), panel.convertXScreenToData(sz.width), sz.width);
                int lastX = 0;
                int trueLen = (subsignals.length + 3) / 4 * 4;
                int[] values = new int[trueLen];
                for (int i2 = 0; i2 < view.getNumEvents(); ++i2) {
                    double xValue = view.getTime(i2);
                    RangeSample<?> rs = view.getSample(i2);
                    BusSample bs = (BusSample)rs.getMin();
                    int invert = trueLen - 1;
                    for (int j2 = 0; j2 < bs.getWidth(); ++j2) {
                        switch (DigitalSample.getState((DigitalSample)bs.getTrace(j2)) & 3) {
                            case 0: {
                                values[invert] = 0;
                                break;
                            }
                            case 2: {
                                values[invert] = 1;
                                break;
                            }
                            case 1: {
                                values[invert] = 2;
                                break;
                            }
                            case 3: {
                                values[invert] = 3;
                                break;
                            }
                            default: {
                                values[invert] = 4;
                            }
                        }
                        --invert;
                    }
                    int x = panel.convertXDataToScreen(xValue);
                    if (x >= panel.getVertAxisPos()) {
                        int j3;
                        if (x < panel.getVertAxisPos() + 5) {
                            if (panel.processALine(g2, x, hei / 2, x + 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                            if (panel.processALine(g2, x, hei / 2, x + 5, 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                        } else {
                            if (panel.processALine(g2, x - 5, 5, x + 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                            if (panel.processALine(g2, x + 5, 5, x - 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                        }
                        if (lastX + 5 < x - 5) {
                            if (panel.processALine(g2, lastX + 5, 5, x - 5, 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                            if (panel.processALine(g2, lastX + 5, hei - 5, x - 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                        }
                        Object valString = "0x";
                        for (j3 = 0; j3 < trueLen; ++j3) {
                            if (values[j3] == 4) {
                                valString = "?";
                                break;
                            }
                            if (values[j3] == 3) {
                                valString = "Z";
                                break;
                            }
                            if (values[j3] != 2) continue;
                            valString = "X";
                            break;
                        }
                        if (((String)valString).length() > 1) {
                            for (j3 = 0; j3 < trueLen; j3 += 4) {
                                int hexDigit = 0;
                                if (values[j3] == 1) {
                                    hexDigit += 8;
                                }
                                if (values[j3 + 1] == 1) {
                                    hexDigit += 4;
                                }
                                if (values[j3 + 2] == 1) {
                                    hexDigit += 2;
                                }
                                if (values[j3 + 3] == 1) {
                                    ++hexDigit;
                                }
                                valString = hexDigit < 10 ? (String)valString + (char)(48 + hexDigit) : (String)valString + (char)(65 + hexDigit - 10);
                            }
                        }
                        if (g2 != null) {
                            g2.setFont(panel.getWaveWindow().getFont());
                            GlyphVector gv = panel.getWaveWindow().getFont().createGlyphVector(panel.getWaveWindow().getFontRenderContext(), (String)valString);
                            Rectangle2D glyphBounds = gv.getLogicalBounds();
                            int textHei = (int)glyphBounds.getHeight();
                            g2.drawString((String)valString, x + 2, hei / 2 + textHei / 2);
                        }
                        if (forPs != null) {
                            Poly poly = new Poly(Poly.fromLambda(x + 2, hei / 2));
                            poly.setStyle(Poly.Type.TEXTLEFT);
                            poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(8));
                            poly.setString((String)valString);
                            forPs.add(poly);
                        }
                    }
                    lastX = x;
                }
                int wid = sz.width;
                if (lastX + 5 < wid) {
                    if (panel.processALine(g2, lastX + 5, 5, wid, 5, bounds, forPs, selectedObjects, ws, -1)) {
                        return;
                    }
                    if (panel.processALine(g2, lastX + 5, hei - 5, wid, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                        return;
                    }
                }
            }
        };
    }
}

