/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.sandbox;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.sandbox.ESandBox;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class TechExplorer
extends ESandBox {
    public static void main(String[] args) {
        try {
            String fileName = args[0];
            File electricJar = new File(fileName);
            if (!electricJar.exists()) {
                throw new FileNotFoundException(fileName);
            }
            TechExplorer m2 = new TechExplorer(electricJar);
            InputStream commandStream = System.in;
            if (args.length >= 2) {
                commandStream = new BufferedInputStream(new FileInputStream(args[1]));
            }
            m2.loop(commandStream);
            m2.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private TechExplorer(File electricJar) throws IOException, ClassNotFoundException, MalformedURLException, IllegalAccessException {
        super(electricJar.toURI().toURL());
    }

    public String[] initTechnologies(String args) throws IllegalAccessException, InvocationTargetException {
        if (this.Undo_changesQuiet != null) {
            this.Undo_changesQuiet.invoke(null, Boolean.TRUE);
        }
        if (this.Tool_initProjectSettings != null) {
            this.Tool_initProjectSettings.invoke(this.User_getUserTool.invoke(null, new Object[0]), new Object[0]);
        }
        this.Technology_initAllTechnologies.invoke(null, new Object[0]);
        ArrayList<String> technologies = new ArrayList<String>();
        Iterator tit = (Iterator)this.Technology_getTechnologies.invoke(null, new Object[0]);
        while (tit.hasNext()) {
            Object tech = tit.next();
            String techName = (String)this.Technology_getTechName.invoke(tech, new Object[0]);
            technologies.add(techName);
        }
        return technologies.toArray(new String[technologies.size()]);
    }

    public void dumpAll(String fileName) throws IllegalAccessException, InvocationTargetException {
        Iterator tit = (Iterator)this.Technology_getTechnologies.invoke(null, new Object[0]);
        while (tit.hasNext()) {
            Object tech = tit.next();
            String techName = (String)this.Technology_getTechName.invoke(tech, new Object[0]);
            System.out.println("Technology " + techName);
            Xml.Technology t = this.makeXml(techName);
            t.writeXml(fileName.replaceAll("lst", techName + "\\.xml"));
        }
    }

    public void dumpPrefs(String fileName) throws IOException {
        PrintWriter out = new PrintWriter(fileName);
        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName.replaceAll("\\.lst", "\\.bin"))));
        this.dumpPrefs(out, dout);
        out.close();
        dout.close();
    }

    private void dumpPrefs(PrintWriter out, DataOutputStream dout) throws IOException {
        try {
            Object factoryValue;
            String version = this.Version_getVersion.invoke(null, new Object[0]).toString();
            out.println("Version " + version);
            dout.writeUTF(version);
            Iterator tit = (Iterator)this.Technology_getTechnologies.invoke(null, new Object[0]);
            while (tit.hasNext()) {
                Object tech = tit.next();
                String techName = (String)this.Technology_getTechName.invoke(tech, new Object[0]);
                assert (techName.length() > 0);
                out.println("Technology " + techName);
                dout.writeUTF(techName);
                Iterator it = (Iterator)this.Technology_getLayers.invoke(tech, new Object[0]);
                while (it.hasNext()) {
                    Object layer = it.next();
                    String layerName = (String)this.Layer_getName.invoke(layer, new Object[0]);
                    assert (layerName.length() > 0);
                    Object pseudoLayer = null;
                    if (this.Layer_getPseudoLayer != null) {
                        pseudoLayer = this.Layer_getPseudoLayer.invoke(layer, new Object[0]);
                    }
                    out.print("Layer " + layerName);
                    dout.writeUTF(layerName);
                    String pseudoLayerName = "";
                    if (pseudoLayer != null) {
                        pseudoLayerName = (String)this.Layer_getName.invoke(pseudoLayer, new Object[0]);
                        assert (pseudoLayerName.length() > 0);
                        out.print(" " + pseudoLayerName);
                    }
                    dout.writeUTF(pseudoLayerName);
                    out.println();
                }
                dout.writeUTF("");
                it = (Iterator)this.Technology_getArcs.invoke(tech, new Object[0]);
                while (it.hasNext()) {
                    Object ap = it.next();
                    String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
                    out.println("Arc " + arcName);
                    dout.writeUTF(arcName);
                }
                dout.writeUTF("");
                it = (Iterator)this.Technology_getNodes.invoke(tech, new Object[0]);
                while (it.hasNext()) {
                    Object pn = it.next();
                    String nodeName = (String)this.PrimitiveNode_getName.invoke(pn, new Object[0]);
                    out.println("Node " + nodeName);
                    dout.writeUTF(nodeName);
                }
                dout.writeUTF("");
            }
            dout.writeUTF("");
            if (this.Setting_getSettings != null) {
                Collection allSettings = (Collection)this.Setting_getSettings.invoke(null, new Object[0]);
                for (Object setting : allSettings) {
                    String xmlPath = (String)this.Setting_getXmlPath.invoke(setting, new Object[0]);
                    Preferences prefs = (Preferences)this.Setting_prefs.get(setting);
                    String prefName = (String)this.Setting_getPrefName.invoke(setting, new Object[0]);
                    String prefPath = prefs.absolutePath() + "/" + prefName;
                    factoryValue = this.Setting_getFactoryValue.invoke(setting, new Object[0]);
                    out.println("Setting " + xmlPath + " " + prefPath + " <" + String.valueOf(factoryValue) + ">");
                    assert (xmlPath.length() > 0);
                    dout.writeUTF(xmlPath);
                    dout.writeUTF(prefPath);
                }
            }
            dout.writeUTF("");
            List allPrefs = (List)this.Pref_allPrefs.get(null);
            for (Object pref : allPrefs) {
                Preferences prefs = (Preferences)this.Pref_prefs.get(pref);
                String prefName = (String)this.Pref_getPrefName.invoke(pref, new Object[0]);
                String prefPath = prefs.absolutePath() + "/" + prefName;
                boolean isMeaning = this.Pref_getMeaning != null && this.Pref_getMeaning.invoke(pref, new Object[0]) != null;
                factoryValue = this.Pref_getFactoryValue.invoke(pref, new Object[0]);
                out.println((isMeaning ? "Mean " : "Pref ") + prefPath + " <" + String.valueOf(factoryValue) + ">");
                dout.writeUTF(prefPath);
                dout.writeBoolean(isMeaning);
            }
            dout.writeUTF("");
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
    }

    public Xml.Technology makeXml(String techName) throws IllegalAccessException, InvocationTargetException {
        Object tech = this.Technology_findTechnology.invoke(null, techName);
        Xml.Technology t = new Xml.Technology();
        t.techName = techName;
        t.className = tech.getClass().getName();
        if (t.className.equals("com.sun.electric.technology.Technology")) {
            t.className = null;
        }
        Xml.Version version = new Xml.Version();
        version.techVersion = 1;
        version.electricVersion = Technology.DISK_VERSION_1;
        t.versions.add(version);
        version = new Xml.Version();
        version.techVersion = 2;
        version.electricVersion = Technology.DISK_VERSION_2;
        t.versions.add(version);
        t.shortTechName = (String)this.Technology_getTechShortName.invoke(tech, new Object[0]);
        t.description = (String)this.Technology_getTechDesc.invoke(tech, new Object[0]);
        t.scaleValue = (Double)this.Technology_getScale.invoke(tech, new Object[0]);
        t.scaleRelevant = (Boolean)this.Technology_isScaleRelevant.invoke(tech, new Object[0]);
        t.resolutionValue = (Double)this.Technology_getResolution.invoke(tech, new Object[0]);
        t.defaultFoundry = "NONE";
        if (this.Technology_getPrefFoundry != null) {
            t.defaultFoundry = this.Technology_getPrefFoundry.invoke(tech, new Object[0]).toString();
        }
        t.minResistance = (Double)this.Technology_getMinResistance.invoke(tech, new Object[0]);
        t.minCapacitance = (Double)this.Technology_getMinCapacitance.invoke(tech, new Object[0]);
        int numTransparentLayers = (Integer)this.Technology_getNumTransparentLayers.invoke(tech, new Object[0]);
        if (numTransparentLayers > 0) {
            Color[] colorMap = (Color[])this.Technology_getColorMap.invoke(tech, new Object[0]);
            for (int i2 = 0; i2 < numTransparentLayers; ++i2) {
                Color transparentColor = colorMap[1 << i2];
                t.transparentLayers.add(transparentColor);
            }
        }
        int maxMetal = 0;
        Iterator it = (Iterator)this.Technology_getLayers.invoke(tech, new Object[0]);
        while (it.hasNext()) {
            Object layer = it.next();
            if (this.isPseudoLayer(layer)) continue;
            String layerName = (String)this.Layer_getName.invoke(layer, new Object[0]);
            Xml.Layer l2 = new Xml.Layer();
            l2.name = layerName;
            Object fun = this.Layer_getFunction.invoke(layer, new Object[0]);
            Layer.Function function = l2.function = fun != null ? (Layer.Function)((Object)this.LayerFunctions.get(fun)) : Layer.Function.UNKNOWN;
            if (l2.function.isMetal()) {
                maxMetal = Math.max(maxMetal, l2.function.getLevel());
            }
            l2.extraFunction = (Integer)this.Layer_getFunctionExtras.invoke(layer, new Object[0]);
            Object desc = this.Layer_getGraphics.invoke(layer, new Object[0]);
            boolean displayPatterned = (Boolean)this.EGraphics_isPatternedOnDisplay.invoke(desc, new Object[0]);
            boolean printPatterned = (Boolean)this.EGraphics_isPatternedOnPrinter.invoke(desc, new Object[0]);
            EGraphics.Outline outlineWhenPatterned = EGraphics.Outline.NOPAT;
            if (this.EGraphics_getOutlined != null) {
                Object outline = this.EGraphics_getOutlined.invoke(desc, new Object[0]);
                if (outline != null) {
                    outlineWhenPatterned = (EGraphics.Outline)((Object)this.EGraphicsOutlines.get(outline));
                }
            } else {
                if (this.EGraphics_isOutlinedOnDisplay != null && ((Boolean)this.EGraphics_isOutlinedOnDisplay.invoke(desc, new Object[0])).booleanValue()) {
                    outlineWhenPatterned = EGraphics.Outline.PAT_S;
                }
                if (this.EGraphics_isOutlinedOnPrinter != null && ((Boolean)this.EGraphics_isOutlinedOnPrinter.invoke(desc, new Object[0])).booleanValue()) {
                    outlineWhenPatterned = EGraphics.Outline.PAT_S;
                }
            }
            int transparentLayer = (Integer)this.EGraphics_getTransparentLayer.invoke(desc, new Object[0]);
            Color color = (Color)this.EGraphics_getColor.invoke(desc, new Object[0]);
            double opacity = (Double)this.EGraphics_getOpacity.invoke(desc, new Object[0]);
            boolean foreground = (Boolean)this.EGraphics_getForeground.invoke(desc, new Object[0]);
            int[] pattern = (int[])this.EGraphics_getPattern.invoke(desc, new Object[0]);
            EGraphics.J3DTransparencyOption mode = EGraphics.DEFAULT_MODE;
            if (this.Layer_getTransparencyMode != null) {
                mode = EGraphics.J3DTransparencyOption.valueOf((String)this.Layer_getTransparencyMode.invoke(layer, new Object[0]));
            }
            double factor = 0.0;
            if (this.Layer_getTransparencyFactor != null) {
                factor = (Double)this.Layer_getTransparencyFactor.invoke(layer, new Object[0]);
            }
            l2.desc = new EGraphics(displayPatterned, printPatterned, outlineWhenPatterned, transparentLayer, color.getRed(), color.getGreen(), color.getBlue(), opacity, foreground, pattern, mode, factor);
            l2.thick3D = (Double)this.Layer_getThickness.invoke(layer, new Object[0]);
            if (this.Layer_getDistance != null) {
                l2.height3D = (Double)this.Layer_getDistance.invoke(layer, new Object[0]);
            } else if (this.Layer_getHeight != null) {
                l2.height3D = (Double)this.Layer_getHeight.invoke(layer, new Object[0]);
            }
            l2.cif = (String)this.Layer_getCIFLayer.invoke(layer, new Object[0]);
            l2.skill = (String)this.Layer_getSkillLayer.invoke(layer, new Object[0]);
            l2.resistance = (Double)this.Layer_getResistance.invoke(layer, new Object[0]);
            l2.capacitance = (Double)this.Layer_getCapacitance.invoke(layer, new Object[0]);
            l2.edgeCapacitance = (Double)this.Layer_getEdgeCapacitance.invoke(layer, new Object[0]);
            l2.inductanceAreaFactor = (Double)this.Layer_getInductanceAreaFactor.invoke(layer, new Object[0]);
            l2.inductanceLengthFactor = (Double)this.Layer_getInductanceLengthFactor.invoke(layer, new Object[0]);
            t.layers.add(l2);
        }
        if (this.Technology_getNumMetals != null) {
            maxMetal = (Integer)this.Technology_getNumMetals.invoke(tech, new Object[0]);
        }
        t.maxNumMetals = t.defaultNumMetals = maxMetal;
        t.minNumMetals = t.defaultNumMetals;
        Map oldArcNames = this.Technology_getOldArcNames != null ? (Map)this.Technology_getOldArcNames.invoke(tech, new Object[0]) : Collections.emptyMap();
        Iterator it2 = (Iterator)this.Technology_getArcs.invoke(tech, new Object[0]);
        while (it2.hasNext()) {
            Object[] arcLayers;
            Object ap = it2.next();
            String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
            Xml.ArcProto a2 = new Xml.ArcProto();
            a2.name = arcName;
            for (Map.Entry e2 : oldArcNames.entrySet()) {
                if (e2.getValue() != ap) continue;
                a2.oldName = (String)e2.getKey();
            }
            a2.function = (ArcProto.Function)((Object)this.ArcProtoFunctions.get(this.ArcProto_getFunction.invoke(ap, new Object[0])));
            a2.wipable = (Boolean)this.ArcProto_isWipable.invoke(ap, new Object[0]);
            a2.curvable = (Boolean)this.ArcProto_isCurvable.invoke(ap, new Object[0]);
            a2.special = this.ArcProto_isSpecialArc != null && (Boolean)this.ArcProto_isSpecialArc.invoke(ap, new Object[0]) != false;
            a2.skipSizeInPalette = this.ArcProto_isSkipSizeInPalette != null && (Boolean)this.ArcProto_isSkipSizeInPalette.invoke(ap, new Object[0]) != false;
            a2.notUsed = (Boolean)this.ArcProto_isNotUsed.invoke(ap, new Object[0]);
            a2.extended = (Boolean)this.ArcProto_isExtended.invoke(ap, new Object[0]);
            a2.fixedAngle = (Boolean)this.ArcProto_isFixedAngle.invoke(ap, new Object[0]);
            a2.angleIncrement = (Integer)this.ArcProto_getAngleIncrement.invoke(ap, new Object[0]);
            if (this.ERC_getAntennaRatio != null) {
                a2.antennaRatio = (Double)this.ERC_getAntennaRatio.invoke(this.ERC_tool.get(null), ap);
            } else if (this.ArcProto_getAntennaRatio != null) {
                a2.antennaRatio = (Double)this.ArcProto_getAntennaRatio.invoke(ap, new Object[0]);
            }
            double defaultFullWidth = 0.0;
            if (this.ArcProto_getLambdaElibWidthOffset != null && this.ArcProto_getDefaultLambdaBaseWidth != null) {
                defaultFullWidth = (Double)this.ArcProto_getLambdaElibWidthOffset.invoke(ap, new Object[0]) + (Double)this.ArcProto_getDefaultLambdaBaseWidth.invoke(ap, new Object[0]);
            } else if (this.ArcProto_getDefaultLambdaFullWidth != null) {
                defaultFullWidth = (Double)this.ArcProto_getDefaultLambdaFullWidth.invoke(ap, new Object[0]);
            } else if (this.ArcProto_getDefaultWidth != null) {
                defaultFullWidth = (Double)this.ArcProto_getDefaultWidth.invoke(ap, new Object[0]);
            }
            double widthOffset = 0.0;
            if (this.ArcProto_getLambdaElibWidthOffset != null) {
                widthOffset = (Double)this.ArcProto_getLambdaElibWidthOffset.invoke(ap, new Object[0]);
            } else if (this.ArcProto_getLambdaWidthOffset != null) {
                widthOffset = (Double)this.ArcProto_getLambdaWidthOffset.invoke(ap, new Object[0]);
            } else if (this.ArcProto_getWidthOffset != null) {
                widthOffset = (Double)this.ArcProto_getWidthOffset.invoke(ap, new Object[0]);
            }
            if (widthOffset != 0.0) {
                a2.diskOffset.put(1, TechExplorer.round(0.5 * defaultFullWidth));
                a2.diskOffset.put(2, TechExplorer.round(0.5 * (defaultFullWidth - widthOffset)));
            } else {
                a2.diskOffset.put(2, TechExplorer.round(0.5 * defaultFullWidth));
            }
            for (Object arcLayer : arcLayers = (Object[])this.ArcProto_layers.get(ap)) {
                Xml.ArcLayer al = new Xml.ArcLayer();
                al.layer = (String)this.Layer_getName.invoke(this.TechnologyArcLayer_getLayer.invoke(arcLayer, new Object[0]), new Object[0]);
                al.style = (Poly.Type)((Object)this.PolyTypes.get(this.TechnologyArcLayer_getStyle.invoke(arcLayer, new Object[0])));
                double extend = 0.0;
                if (this.TechnologyArcLayer_getGridExtend != null) {
                    extend = DBMath.gridToLambda(((Integer)this.TechnologyArcLayer_getGridExtend.invoke(arcLayer, new Object[0])).intValue());
                } else {
                    double offset = 0.0;
                    if (this.TechnologyArcLayer_getLambdaOffset != null) {
                        offset = (Double)this.TechnologyArcLayer_getLambdaOffset.invoke(arcLayer, new Object[0]);
                    } else if (this.TechnologyArcLayer_getOffset != null) {
                        offset = (Double)this.TechnologyArcLayer_getOffset.invoke(arcLayer, new Object[0]);
                    }
                    extend = 0.5 * (defaultFullWidth - offset);
                }
                al.extend.addLambda(TechExplorer.round(extend));
                a2.arcLayers.add(al);
            }
            t.arcs.add(a2);
        }
        Map oldNodeNames = this.Technology_getOldNodeNames != null ? (Map)this.Technology_getOldNodeNames.invoke(tech, new Object[0]) : Collections.emptyMap();
        Iterator it3 = (Iterator)this.Technology_getNodes.invoke(tech, new Object[0]);
        while (it3.hasNext()) {
            ERectangle baseRectangle;
            Object pn = it3.next();
            String nodeName = (String)this.PrimitiveNode_getName.invoke(pn, new Object[0]);
            PrimitiveNode.Function fun = (PrimitiveNode.Function)((Object)this.PrimitiveNodeFunctions.get(this.PrimitiveNode_getFunction.invoke(pn, new Object[0])));
            Object[] nodeLayersArray = (Object[])this.PrimitiveNode_getLayers.invoke(pn, new Object[0]);
            double defWidth = (Double)this.PrimitiveNode_getDefWidth.invoke(pn, new Object[0]);
            double defHeight = (Double)this.PrimitiveNode_getDefHeight.invoke(pn, new Object[0]);
            Iterator ports = (Iterator)this.PrimitiveNode_getPorts.invoke(pn, new Object[0]);
            if (fun == PrimitiveNode.Function.NODE && nodeLayersArray.length == 1) {
                Xml.PureLayerNode pln = new Xml.PureLayerNode();
                pln.name = nodeName;
                for (Map.Entry e3 : oldNodeNames.entrySet()) {
                    if (e3.getValue() != pn) continue;
                    pln.oldName = (String)e3.getKey();
                }
                Object port = ports.next();
                pln.port = (String)this.PrimitivePort_getName.invoke(port, new Object[0]);
                pln.style = (Poly.Type)((Object)this.PolyTypes.get(this.TechnologyNodeLayer_getStyle.invoke(nodeLayersArray[0], new Object[0])));
                pln.size.addLambda(TechExplorer.round(defWidth));
                this.makePortArcs(pln.portArcs, tech, port, null);
                Xml.Layer layer = t.findLayer((String)this.Layer_getName.invoke(this.TechnologyNodeLayer_getLayer.invoke(nodeLayersArray[0], new Object[0]), new Object[0]));
                layer.pureLayerNode = pln;
                continue;
            }
            Xml.PrimitiveNodeGroup ng = new Xml.PrimitiveNodeGroup();
            ng.isSingleton = true;
            Xml.PrimitiveNode n2 = new Xml.PrimitiveNode();
            ng.nodes.add(n2);
            n2.name = nodeName;
            for (Map.Entry e4 : oldNodeNames.entrySet()) {
                if (e4.getValue() != pn) continue;
                n2.oldName = (String)e4.getKey();
            }
            n2.function = fun;
            ng.shrinkArcs = (Boolean)this.PrimitiveNode_isArcsShrink.invoke(pn, new Object[0]);
            ng.partialCircle = (Boolean)this.PrimitiveNode_isPartialCircle.invoke(pn, new Object[0]);
            ng.square = (Boolean)this.PrimitiveNode_isSquare.invoke(pn, new Object[0]);
            ng.canBeZeroSize = (Boolean)this.PrimitiveNode_isCanBeZeroSize.invoke(pn, new Object[0]);
            ng.wipes = (Boolean)this.PrimitiveNode_isWipeOn1or2.invoke(pn, new Object[0]);
            ng.lockable = (Boolean)this.PrimitiveNode_isLockedPrim.invoke(pn, new Object[0]);
            ng.edgeSelect = (Boolean)this.PrimitiveNode_isEdgeSelect.invoke(pn, new Object[0]);
            if (this.PrimitiveNode_isSkipSizeInPalette != null) {
                ng.skipSizeInPalette = (Boolean)this.PrimitiveNode_isSkipSizeInPalette.invoke(pn, new Object[0]);
            }
            ng.notUsed = (Boolean)this.PrimitiveNode_isNotUsed.invoke(pn, new Object[0]);
            if (this.PrimitiveNode_LOWVTBIT != null) {
                n2.lowVt = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_LOWVTBIT.get(null));
            }
            if (this.PrimitiveNode_HIGHVTBIT != null) {
                n2.highVt = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_HIGHVTBIT.get(null));
            }
            if (this.PrimitiveNode_NATIVEBIT != null) {
                n2.nativeBit = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_NATIVEBIT.get(null));
            }
            if (this.PrimitiveNode_OD18BIT != null) {
                n2.od18 = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_OD18BIT.get(null));
            }
            if (this.PrimitiveNode_OD25BIT != null) {
                n2.od25 = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_OD25BIT.get(null));
            }
            if (this.PrimitiveNode_OD33BIT != null) {
                n2.od33 = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_OD33BIT.get(null));
            }
            if (this.PrimitiveNode_CURVEPIN != null) {
                n2.curvePin = (Boolean)this.PrimitiveNode_isNodeBitOn.invoke(pn, this.PrimitiveNode_CURVEPIN.get(null));
            }
            EPoint sizeCorrector1 = null;
            EPoint sizeCorrector2 = null;
            if (this.PrimitiveNode_getSizeCorrector != null) {
                sizeCorrector1 = EPoint.snap((Point2D)this.PrimitiveNode_getSizeCorrector.invoke(pn, 0));
                sizeCorrector2 = EPoint.snap((Point2D)this.PrimitiveNode_getSizeCorrector.invoke(pn, 1));
            }
            double minWidth = 0.0;
            double minHeight = 0.0;
            String minSizeRule = null;
            if (this.classPrimitiveNodeNodeSizeRule != null) {
                Object rule = this.PrimitiveNode_getMinSizeRule.invoke(pn, new Object[0]);
                if (rule != null) {
                    minWidth = (Double)this.PrimitiveNodeNodeSizeRule_getWidth.invoke(rule, new Object[0]);
                    minHeight = (Double)this.PrimitiveNodeNodeSizeRule_getHeight.invoke(rule, new Object[0]);
                    minSizeRule = (String)this.PrimitiveNodeNodeSizeRule_getRuleName.invoke(rule, new Object[0]);
                }
            } else {
                minWidth = (Double)this.PrimitiveNode_getMinWidth.invoke(pn, new Object[0]);
                minHeight = (Double)this.PrimitiveNode_getMinHeight.invoke(pn, new Object[0]);
                minSizeRule = (String)this.PrimitiveNode_getMinSizeRule.invoke(pn, new Object[0]);
                if (minWidth == -1.0 && minHeight == -1.0 && minSizeRule.equals("")) {
                    minSizeRule = null;
                }
            }
            EPoint fullSize = null;
            if (minSizeRule != null) {
                ng.nodeSizeRule = new Xml.NodeSizeRule();
                ng.nodeSizeRule.width = minWidth;
                ng.nodeSizeRule.height = minHeight;
                ng.nodeSizeRule.rule = minSizeRule;
                fullSize = EPoint.fromLambda(0.5 * minWidth, 0.5 * minHeight);
            } else if (this.PrimitiveNode_getFullRectangle != null) {
                Rectangle2D r = (Rectangle2D)this.PrimitiveNode_getFullRectangle.invoke(pn, new Object[0]);
                fullSize = EPoint.fromLambda(0.5 * r.getWidth(), 0.5 * r.getHeight());
            } else {
                fullSize = sizeCorrector1;
            }
            if (fullSize == null) {
                fullSize = EPoint.fromLambda(0.5 * defWidth, 0.5 * defHeight);
            }
            ERectangle fullRectangle = ERectangle.fromLambda(-fullSize.getX(), -fullSize.getY(), 2.0 * fullSize.getX(), 2.0 * fullSize.getY());
            if (this.PrimitiveNode_getBaseRectangle != null) {
                baseRectangle = ERectangle.fromLambda((Rectangle2D)this.PrimitiveNode_getBaseRectangle.invoke(pn, new Object[0]));
            } else {
                double lx = fullRectangle.getLambdaMinX();
                double hx = fullRectangle.getLambdaMaxX();
                double ly = fullRectangle.getLambdaMinY();
                double hy = fullRectangle.getLambdaMaxY();
                Object sizeOffset = this.PrimitiveNode_getProtoSizeOffset.invoke(pn, new Object[0]);
                if (sizeOffset != null) {
                    lx += ((Double)this.SizeOffset_getLowXOffset.invoke(sizeOffset, new Object[0])).doubleValue();
                    hx -= ((Double)this.SizeOffset_getHighXOffset.invoke(sizeOffset, new Object[0])).doubleValue();
                    ly += ((Double)this.SizeOffset_getLowYOffset.invoke(sizeOffset, new Object[0])).doubleValue();
                    hy -= ((Double)this.SizeOffset_getHighYOffset.invoke(sizeOffset, new Object[0])).doubleValue();
                }
                baseRectangle = ERectangle.fromLambda(lx, ly, hx - lx, hy - ly);
            }
            ng.baseLX.value = baseRectangle.getLambdaMinX();
            ng.baseHX.value = baseRectangle.getLambdaMaxX();
            ng.baseLY.value = baseRectangle.getLambdaMinY();
            ng.baseHY.value = baseRectangle.getLambdaMaxY();
            if (sizeCorrector1 == null) {
                sizeCorrector1 = fullSize;
            }
            if (sizeCorrector2 == null) {
                sizeCorrector2 = EPoint.fromGrid(baseRectangle.getGridWidth() >> 1, baseRectangle.getGridHeight() >> 1);
            }
            if (!sizeCorrector2.equals(sizeCorrector1)) {
                ng.diskOffset.put(1, sizeCorrector1);
            }
            if (!sizeCorrector2.equals(EPoint.ORIGIN)) {
                ng.diskOffset.put(2, sizeCorrector2);
            }
            ng.defaultWidth.addLambda(TechExplorer.round(defWidth - fullRectangle.getLambdaWidth()));
            ng.defaultHeight.addLambda(TechExplorer.round(defHeight - fullRectangle.getLambdaHeight()));
            List<Object> nodeLayers = Arrays.asList(nodeLayersArray);
            Object[] electricalNodeLayersArray = (Object[])this.PrimitiveNode_getElectricalLayers.invoke(pn, new Object[0]);
            List<Object> electricalNodeLayers = nodeLayers;
            if (electricalNodeLayersArray != null) {
                electricalNodeLayers = Arrays.asList(electricalNodeLayersArray);
            }
            boolean isSerp = (Integer)this.PrimitiveNode_getSpecialType.invoke(pn, new Object[0]) == 1;
            int m2 = 0;
            for (Object nld : electricalNodeLayers) {
                int j2 = nodeLayers.indexOf(nld);
                if (j2 < 0) {
                    ng.nodeLayers.add(this.makeNodeLayerDetails(t, nld, isSerp, fullSize, false, true));
                    continue;
                }
                while (m2 < j2) {
                    ng.nodeLayers.add(this.makeNodeLayerDetails(t, nodeLayers.get(m2++), isSerp, fullSize, true, false));
                }
                ng.nodeLayers.add(this.makeNodeLayerDetails(t, nodeLayers.get(m2++), isSerp, fullSize, true, true));
            }
            while (m2 < nodeLayers.size()) {
                ng.nodeLayers.add(this.makeNodeLayerDetails(t, nodeLayers.get(m2++), isSerp, fullSize, true, false));
            }
            Iterator pit = (Iterator)this.PrimitiveNode_getPorts.invoke(pn, new Object[0]);
            while (pit.hasNext()) {
                Object pp = pit.next();
                Xml.PrimitivePort ppd = new Xml.PrimitivePort();
                ppd.name = (String)this.PrimitivePort_getName.invoke(pp, new Object[0]);
                ppd.portAngle = (Integer)this.PrimitivePort_getAngle.invoke(pp, new Object[0]);
                if (this.PrimitivePort_getAngleRange != null) {
                    ppd.portRange = (Integer)this.PrimitivePort_getAngleRange.invoke(pp, new Object[0]);
                } else {
                    int PORTARANGE = 130560;
                    int PORTARANGESH = 9;
                    ppd.portRange = ((Integer)this.PrimitivePort_lowLevelGetUserbits.invoke(pp, new Object[0]) & 0x1FE00) >> 9;
                }
                ppd.portTopology = (Integer)this.PrimitivePort_getTopology.invoke(pp, new Object[0]);
                Object lx = this.PrimitivePort_getLeft.invoke(pp, new Object[0]);
                Object hx = this.PrimitivePort_getRight.invoke(pp, new Object[0]);
                Object ly = this.PrimitivePort_getBottom.invoke(pp, new Object[0]);
                Object hy = this.PrimitivePort_getTop.invoke(pp, new Object[0]);
                ppd.lx.k = (Double)this.EdgeH_getMultiplier.invoke(lx, new Object[0]) * 2.0;
                ppd.lx.addLambda(TechExplorer.round((Double)this.EdgeH_getAdder.invoke(lx, new Object[0]) + fullSize.getLambdaX() * ppd.lx.k));
                ppd.hx.k = (Double)this.EdgeH_getMultiplier.invoke(hx, new Object[0]) * 2.0;
                ppd.hx.addLambda(TechExplorer.round((Double)this.EdgeH_getAdder.invoke(hx, new Object[0]) + fullSize.getLambdaX() * ppd.hx.k));
                ppd.ly.k = (Double)this.EdgeV_getMultiplier.invoke(ly, new Object[0]) * 2.0;
                ppd.ly.addLambda(TechExplorer.round((Double)this.EdgeV_getAdder.invoke(ly, new Object[0]) + fullSize.getLambdaY() * ppd.ly.k));
                ppd.hy.k = (Double)this.EdgeV_getMultiplier.invoke(hy, new Object[0]) * 2.0;
                ppd.hy.addLambda(TechExplorer.round((Double)this.EdgeV_getAdder.invoke(hy, new Object[0]) + fullSize.getLambdaY() * ppd.hy.k));
                this.makePortArcs(ppd.portArcs, tech, pp, null);
                ng.ports.add(ppd);
            }
            ng.specialType = (Integer)this.PrimitiveNode_getSpecialType.invoke(pn, new Object[0]);
            double[] specialValues = (double[])this.PrimitiveNode_getSpecialValues.invoke(pn, new Object[0]);
            if (specialValues != null) {
                ng.specialValues = (double[])specialValues.clone();
            }
            if (this.PrimitiveNode_getSpiceTemplate != null) {
                ng.spiceTemplate = (String)this.PrimitiveNode_getSpiceTemplate.invoke(pn, new Object[0]);
            }
            t.nodeGroups.add(ng);
        }
        TechExplorer.addSpiceHeader(t, 1, (String[])this.Technology_getSpiceHeaderLevel1.invoke(tech, new Object[0]));
        TechExplorer.addSpiceHeader(t, 2, (String[])this.Technology_getSpiceHeaderLevel2.invoke(tech, new Object[0]));
        TechExplorer.addSpiceHeader(t, 3, (String[])this.Technology_getSpiceHeaderLevel3.invoke(tech, new Object[0]));
        if (this.Technology_getNodesGrouped1 != null || this.Technology_getNodesGrouped2 != null) {
            Object[][] origPalette = null;
            if (this.Technology_getNodesGrouped1 != null) {
                origPalette = (Object[][])this.Technology_getNodesGrouped1.invoke(tech, new Object[0]);
            } else if (this.Technology_getNodesGrouped2 != null) {
                origPalette = (Object[][])this.Technology_getNodesGrouped2.invoke(tech, new Object[]{null});
            }
            if (origPalette != null) {
                int numRows = origPalette.length;
                int numCols = origPalette[0].length;
                for (Object[] row : origPalette) {
                    assert (row.length == numCols);
                }
                t.menuPalette = new Xml.MenuPalette();
                t.menuPalette.numColumns = numCols;
                for (int row = 0; row < numRows; ++row) {
                    for (int col = 0; col < numCols; ++col) {
                        Object origEntry = origPalette[row][col];
                        ArrayList<Object> newBox = new ArrayList<Object>();
                        if (origEntry instanceof List) {
                            List list = (List)origEntry;
                            for (Object o2 : list) {
                                if (o2 instanceof List) {
                                    List list2 = (List)o2;
                                    for (Object o22 : list2) {
                                        newBox.add(this.makeMenuEntry(t, o22));
                                    }
                                    continue;
                                }
                                newBox.add(this.makeMenuEntry(t, o2));
                            }
                        } else if (origEntry != null) {
                            newBox.add(this.makeMenuEntry(t, origEntry));
                        }
                        t.menuPalette.menuBoxes.add(newBox);
                    }
                }
            }
        }
        this.makeFoundries(t, tech);
        return t;
    }

    private void makeFoundries(Xml.Technology t, Object tech) throws IllegalAccessException, InvocationTargetException {
        Iterator fit;
        if (this.Technology_getFoundries == null) {
            return;
        }
        Object foundries = this.Technology_getFoundries.invoke(tech, new Object[0]);
        Iterator iterator = fit = foundries instanceof List ? ((List)foundries).iterator() : (Iterator)foundries;
        while (fit.hasNext()) {
            List rules;
            Object foundry = fit.next();
            Xml.Foundry f2 = new Xml.Foundry();
            f2.name = foundry.toString();
            if (this.Foundry_getGDSLayers != null) {
                Map gdsMap = (Map)this.Foundry_getGDSLayers.invoke(foundry, new Object[0]);
                for (Map.Entry e2 : gdsMap.entrySet()) {
                    String gds = (String)e2.getValue();
                    if (gds.length() == 0) continue;
                    Object layer = e2.getKey();
                    f2.layerGds.put((String)this.Layer_getName.invoke(layer, new Object[0]), gds);
                }
            }
            if ((rules = (List)this.Foundry_getRules.invoke(foundry, new Object[0])) == null) continue;
            for (Map.Entry rule : rules) {
                DRCTemplate.DRCRuleType type;
                String ruleName = (String)this.DRCTemplate_ruleName.get(rule);
                int when = (Integer)this.DRCTemplate_when.get(rule);
                int TSMC = 4096;
                int ST = 8192;
                int MOSIS = 16384;
                when &= 0xFFFF8FFF;
                if (this.classDRCTemplateDRCMode != null) {
                    int newWhen = 0;
                    for (Map.Entry e3 : this.DRCTemplateDRCModes.entrySet()) {
                        int oldMode = (Integer)this.DRCTemplateDrcMode_mode.invoke(e3.getKey(), new Object[0]);
                        if ((when & oldMode) != oldMode) continue;
                        newWhen |= ((DRCTemplate.DRCMode)((Object)e3.getValue())).mode();
                    }
                    when = newWhen;
                }
                if ((type = (DRCTemplate.DRCRuleType)((Object)this.DRCTemplateDRCRuleTypes.get(this.DRCTemplate_ruleType.get(rule)))) == null) continue;
                double maxWidth = (Double)this.DRCTemplate_maxWidth.get(rule);
                double minLength = (Double)this.DRCTemplate_minLength.get(rule);
                String name1 = (String)this.DRCTemplate_name1.get(rule);
                String name2 = (String)this.DRCTemplate_name2.get(rule);
                double[] values = null;
                if (this.DRCTemplate_values != null) {
                    values = (double[])this.DRCTemplate_values.get(rule);
                } else if (this.DRCTemplate_value1 != null & this.DRCTemplate_value2 != null) {
                    values = new double[]{(Double)this.DRCTemplate_value1.get(rule), (Double)this.DRCTemplate_value2.get(rule)};
                }
                values = (double[])values.clone();
                String nodeName = (String)this.DRCTemplate_nodeName.get(rule);
                int multiCuts = (Integer)this.DRCTemplate_multiCuts.get(rule);
                DRCTemplate r = null;
                r = nodeName != null ? new DRCTemplate(ruleName, when, type, name1, name2, values, nodeName, null) : new DRCTemplate(ruleName, when, type, maxWidth, minLength, name1, name2, values, multiCuts);
                f2.rules.add(r);
            }
            t.foundries.add(f2);
        }
    }

    private Xml.NodeLayer makeNodeLayerDetails(Xml.Technology t, Object nodeLayer, boolean isSerp, EPoint correction, boolean inLayers, boolean inElectricalLayers) throws IllegalAccessException, InvocationTargetException {
        Xml.NodeLayer nld = new Xml.NodeLayer();
        Object layer = this.TechnologyNodeLayer_getLayer.invoke(nodeLayer, new Object[0]);
        layer = this.Layer_getNonPseudoLayer.invoke(layer, new Object[0]);
        nld.layer = (String)this.Layer_getName.invoke(layer, new Object[0]);
        nld.style = (Poly.Type)((Object)this.PolyTypes.get(this.TechnologyNodeLayer_getStyle.invoke(nodeLayer, new Object[0])));
        nld.portNum = (Integer)this.TechnologyNodeLayer_getPortNum.invoke(nodeLayer, new Object[0]);
        nld.inLayers = inLayers;
        nld.inElectricalLayers = inElectricalLayers;
        nld.representation = (Integer)this.TechnologyNodeLayer_getRepresentation.invoke(nodeLayer, new Object[0]);
        Object[] points = (Object[])this.TechnologyNodeLayer_getPoints.invoke(nodeLayer, new Object[0]);
        if (points != null) {
            if (nld.representation == 1 || nld.representation == 3) {
                Object lx = this.TechnologyTechPoint_getX.invoke(points[0], new Object[0]);
                Object hx = this.TechnologyTechPoint_getX.invoke(points[1], new Object[0]);
                Object ly = this.TechnologyTechPoint_getY.invoke(points[0], new Object[0]);
                Object hy = this.TechnologyTechPoint_getY.invoke(points[1], new Object[0]);
                nld.lx.k = (Double)this.EdgeH_getMultiplier.invoke(lx, new Object[0]) * 2.0;
                nld.lx.addLambda(TechExplorer.round((Double)this.EdgeH_getAdder.invoke(lx, new Object[0]) + correction.getLambdaX() * nld.lx.k));
                nld.hx.k = (Double)this.EdgeH_getMultiplier.invoke(hx, new Object[0]) * 2.0;
                nld.hx.addLambda(TechExplorer.round((Double)this.EdgeH_getAdder.invoke(hx, new Object[0]) + correction.getLambdaX() * nld.hx.k));
                nld.ly.k = (Double)this.EdgeV_getMultiplier.invoke(ly, new Object[0]) * 2.0;
                nld.ly.addLambda(TechExplorer.round((Double)this.EdgeV_getAdder.invoke(ly, new Object[0]) + correction.getLambdaY() * nld.ly.k));
                nld.hy.k = (Double)this.EdgeV_getMultiplier.invoke(hy, new Object[0]) * 2.0;
                nld.hy.addLambda(TechExplorer.round((Double)this.EdgeV_getAdder.invoke(hy, new Object[0]) + correction.getLambdaY() * nld.hy.k));
            } else {
                for (Object p : points) {
                    nld.techPoints.add(this.correction(p, correction));
                }
            }
        }
        if (this.TechnologyNodeLayer_getMulticutSizeX != null) {
            nld.sizex = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSizeX.invoke(nodeLayer, new Object[0]));
            nld.sizey = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSizeY.invoke(nodeLayer, new Object[0]));
            nld.sep1d = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSep1D.invoke(nodeLayer, new Object[0]));
            nld.sep2d = TechExplorer.round((Double)this.TechnologyNodeLayer_getMulticutSep2D.invoke(nodeLayer, new Object[0]));
        }
        if (isSerp) {
            nld.lWidth = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineLWidth.invoke(nodeLayer, new Object[0]));
            nld.rWidth = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineRWidth.invoke(nodeLayer, new Object[0]));
            nld.tExtent = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineExtentT.invoke(nodeLayer, new Object[0]));
            nld.bExtent = TechExplorer.round((Double)this.TechnologyNodeLayer_getSerpentineExtentB.invoke(nodeLayer, new Object[0]));
        }
        return nld;
    }

    private Technology.TechPoint correction(Object p, EPoint correction) throws IllegalAccessException, InvocationTargetException {
        Object oh = this.TechnologyTechPoint_getX.invoke(p, new Object[0]);
        double mx = (Double)this.EdgeH_getMultiplier.invoke(oh, new Object[0]);
        EdgeH h2 = new EdgeH(mx, (Double)this.EdgeH_getAdder.invoke(oh, new Object[0]) + correction.getLambdaX() * mx * 2.0);
        Object ov = this.TechnologyTechPoint_getY.invoke(p, new Object[0]);
        double my = (Double)this.EdgeV_getMultiplier.invoke(ov, new Object[0]);
        EdgeV v = new EdgeV(my, (Double)this.EdgeV_getAdder.invoke(ov, new Object[0]) + correction.getLambdaY() * my * 2.0);
        return new Technology.TechPoint(h2, v);
    }

    private static void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    private Object makeMenuEntry(Xml.Technology t, Object entry) throws IllegalAccessException, InvocationTargetException {
        if (this.classArcProto.isInstance(entry)) {
            return t.findArc((String)this.ArcProto_getName.invoke(entry, new Object[0]));
        }
        if (this.classPrimitiveNode.isInstance(entry)) {
            this.PrimitiveNodeFunctions.get(this.PrimitiveNode_getFunction.invoke(entry, new Object[0]));
            String name = (String)this.PrimitiveNode_getName.invoke(entry, new Object[0]);
            return t.findNode(name);
        }
        if (this.classNodeInst.isInstance(entry)) {
            Xml.MenuNodeInst n2 = new Xml.MenuNodeInst();
            n2.protoName = (String)this.PrimitiveNode_getName.invoke(this.NodeInst_getProto.invoke(entry, new Object[0]), new Object[0]);
            n2.function = (PrimitiveNode.Function)((Object)this.PrimitiveNodeFunctions.get(this.NodeInst_getFunction.invoke(entry, new Object[0])));
            n2.rotation = (Integer)this.NodeInst_getAngle.invoke(entry, new Object[0]);
            Iterator it = (Iterator)this.ElectricObject_getVariables.invoke(entry, new Object[0]);
            while (it.hasNext()) {
                Object var = it.next();
                Object value = this.Variable_getObject.invoke(var, new Object[0]);
                if (!(value instanceof String)) continue;
                n2.text = (String)this.Variable_getObject.invoke(var, new Object[0]);
            }
            return n2;
        }
        if (entry.getClass().getName().equals("javax.swing.JPopupMenu$Separator")) {
            return "-";
        }
        assert (entry instanceof String);
        return entry;
    }

    private void makePortArcs(List<String> portArcs, Object tech, Object pp, Object excludeAp) throws IllegalAccessException, InvocationTargetException {
        Object[] connections;
        for (Object ap : connections = (Object[])this.PrimitivePort_getConnections.invoke(pp, new Object[0])) {
            if (ap == null || ap == excludeAp) continue;
            String arcName = (String)this.ArcProto_getName.invoke(ap, new Object[0]);
            if (this.Technology_findArcProto.invoke(tech, arcName) != ap) continue;
            portArcs.add(arcName);
        }
    }

    private boolean isPseudoLayer(Object layer) throws IllegalAccessException, InvocationTargetException {
        int extraFun = (Integer)this.Layer_getFunctionExtras.invoke(layer, new Object[0]);
        int PSEUDO = 4096;
        return (extraFun & 0x1000) != 0 || this.Layer_isPseudoLayer != null && (Boolean)this.Layer_isPseudoLayer.invoke(layer, new Object[0]) != false;
    }

    private static double round(double v) {
        v = DBMath.round(v);
        return v;
    }
}

