/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SoGWireQualityMetric;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.RoutingDebug;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableBoolean;
import com.sun.electric.util.math.MutableDouble;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SeaOfGatesEngine {
    private static final boolean MULTIPLEDESTINATIONS = true;
    private static final boolean CHECKBOTHDIRECTIONS = false;
    private static final boolean NOGRIDPENALTYATSOURCE = true;
    private static final boolean ANYPOINTONDESTINATION = true;
    private static final double GRAINSIZE = 1.0;
    private static final double SPINERATIO = 50.0;
    private static final int COSTALTERNATINGMETAL = 20;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 15;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    private static final int BLOCKAGEFAKEENDPOINT = 1;
    private static final int BLOCKAGEENDA = 2;
    private static final int BLOCKAGEENDB = 4;
    private static final int BLOCKAGEFAKEUSERSUPPLIED = 8;
    private static final int SHIFTBLOCKBITS = 4;
    public static SearchVertex svAborted = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0, null);
    public static SearchVertex svExhausted = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0, null);
    public static SearchVertex svLimited = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0, null);
    public static SearchVertex svAbandoned = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0, null);
    private static int numMetalLayers;
    private Environment env;
    private Cell cell;
    private boolean parallelDij;
    private ErrorLogger errorLogger;
    private Rectangle2D cellBounds;
    private ERectangle routingBoundsLimit;
    private Technology tech;
    private Layer[][] metalLayers;
    private Layer[] primaryMetalLayer;
    private Layer[] viaLayers;
    private Map<Layer, Layer> removeLayers;
    private ArcProto[][] metalArcs;
    private PrimitiveNode[][] metalPureLayerNodes;
    private ArcProto[] primaryMetalArc;
    private double[] maxDefArcWidth;
    private double[] minimumArea;
    private double minResolution;
    private double[] size2X;
    private double[] taperLength;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private boolean[] taperOnlyArcs;
    private MetalVias[] metalVias;
    private MetalVias[] metalVias2X;
    private SeaOfGates.SeaOfGatesTrack[][] metalGrid;
    private double[] metalGridRange;
    private double[] metalSurroundX;
    private double[] metalSurroundY;
    private double[] viaSurround;
    private double[] viaDiagonalDistance;
    private double[] viaColorDiffSpacing;
    private Method[] secretViaSpacingRules;
    private double[] viaSize;
    private BlockageTrees rTrees;
    private Map<Network, Integer> netIDs;
    private SeaOfGates.SeaOfGatesOptions prefs;
    private Handler handler;
    private EditingPreferences ep;
    private SeaOfGates.SeaOfGatesCellParameters sogp;
    private List<NeededRoute> tapRoutes;
    private boolean messagesQuiet;
    private int totalBlockages;
    private int blockagesFound;
    private Map<Double, Map<Double, double[]>>[] layerSurround;
    private SoGWireQualityMetric sogQual;
    Map<Integer, List<MutableInteger>> netIDsByValue = new HashMap<Integer, List<MutableInteger>>();
    private static boolean tsmcDesignRulesChecked;
    private static Class<?> tsmcDesignRulesClass;
    Map<Layer, List<Rectangle2D>> removeGeometry;

    public void routeIt(Handler handler, Cell cell, boolean quiet) {
        this.routeIt(handler, cell, quiet, null);
    }

    public void routeIt(Handler handler, Cell cell, boolean quiet, List<ArcInst> arcsToRoute) {
        this.routeIt(handler, cell, quiet, arcsToRoute, new SeaOfGates.SeaOfGatesCellParameters(cell));
    }

    /*
     * WARNING - void declaration
     */
    public void routeIt(Handler handler, Cell cell, boolean quiet, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesCellParameters sogp) {
        String whichRoute;
        this.messagesQuiet = quiet;
        this.handler = handler;
        this.ep = handler.getEditingPreferences();
        this.env = cell.getDatabase().getEnvironment();
        this.sogp = sogp;
        this.tapRoutes = new ArrayList<NeededRoute>();
        this.cell = cell;
        this.cellBounds = cell.getBounds();
        this.tech = cell.getTechnology();
        if (Job.getDebug()) {
            System.out.println("Preferences " + String.valueOf(this.prefs));
        }
        this.routingBoundsLimit = null;
        String routingBoundsLayerName = sogp.getRoutingBoundsLayerName();
        if (routingBoundsLayerName != null) {
            Layer boundsLayer = this.tech.findLayer(routingBoundsLayerName);
            if (boundsLayer == null) {
                if (!RoutingDebug.isActive()) {
                    System.out.println("WARNING: Routing bounds layer '" + routingBoundsLayerName + "' not found in technology " + this.tech.getTechName());
                }
            } else {
                ArrayList<NodeInst> boundsLayerNodes = new ArrayList<NodeInst>();
                Iterator<NodeInst> it = cell.getNodes();
                block0: while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (ni.isCellInstance() || ni.getFunction() != PrimitiveNode.Function.NODE) continue;
                    PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                    Technology.NodeLayer[] nodeLayerArray = pNp.getNodeLayers();
                    for (int i2 = 0; i2 < nodeLayerArray.length; ++i2) {
                        if (nodeLayerArray[i2].getLayer() != boundsLayer) continue;
                        boundsLayerNodes.add(ni);
                        continue block0;
                    }
                }
                if (boundsLayerNodes.size() == 0) {
                    if (!RoutingDebug.isActive()) {
                        System.out.println("WARNING: No nodes found with the routing bounds layer '" + routingBoundsLayerName + "'");
                    }
                } else if (boundsLayerNodes.size() > 1) {
                    if (!RoutingDebug.isActive()) {
                        System.out.println("WARNING: Found " + boundsLayerNodes.size() + " nodes with the routing bounds layer, must have only 1.");
                    }
                } else {
                    NodeInst ni = (NodeInst)boundsLayerNodes.get(0);
                    this.routingBoundsLimit = ni.getBounds();
                    if (!RoutingDebug.isActive()) {
                        System.out.println("NOTE: No routes will extend beyond " + TextUtils.formatDistance(this.routingBoundsLimit.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.routingBoundsLimit.getMaxX()) + " AND " + TextUtils.formatDistance(this.routingBoundsLimit.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.routingBoundsLimit.getMaxY()));
                    }
                }
            }
        }
        if (this.initializeDesignRules()) {
            return;
        }
        this.initializeGrids();
        this.netIDs = new HashMap<Network, Integer>();
        this.errorLogger = ErrorLogger.newInst("Routing (Sea of gates) " + cell.describe(false));
        this.prefs.theTimer = ElapseTimer.createInstance().start();
        Netlist netList = cell.getNetlist();
        List<String> netsToRoute = sogp.getNetsToRoute();
        if (this.prefs.netOrder == Routing.SoGNetOrder.SOGNETORDERDESCENDING || this.prefs.netOrder == Routing.SoGNetOrder.SOGNETORDERASCENDING) {
            Collections.sort(netsToRoute, new SortArcByDistance(cell, this.prefs.netOrder));
        } else if (netsToRoute != null && this.prefs.netOrder == Routing.SoGNetOrder.SOGNETORDERBUS) {
            HashMap<String, BusBitsNumberClass> busMap = new HashMap<String, BusBitsNumberClass>();
            ArrayList<String> simpleNets = new ArrayList<String>();
            for (String string : netsToRoute) {
                int index = string.indexOf("[");
                if (index != -1) {
                    String bus = string.substring(0, index);
                    BusBitsNumberClass list = (BusBitsNumberClass)busMap.get(bus);
                    if (list == null) {
                        list = new BusBitsNumberClass(bus);
                        busMap.put(bus, list);
                    }
                    list.bits.add(string.substring(index));
                    continue;
                }
                simpleNets.add(string);
            }
            ArrayList listToSort = new ArrayList(busMap.values());
            Collections.sort(listToSort, new SortByBusBitsNumberClass());
            netsToRoute.clear();
            for (BusBitsNumberClass bus : listToSort) {
                netsToRoute.addAll(bus.getNets());
            }
            netsToRoute.addAll(simpleNets);
        }
        if (netsToRoute != null && netsToRoute.size() > 0) {
            boolean allSelected = true;
            if (arcsToRoute != null) {
                Iterator<Object> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc || arcsToRoute.contains(ai)) continue;
                    allSelected = false;
                    break;
                }
            }
            if (allSelected) {
                arcsToRoute = new ArrayList<ArcInst>();
                for (String netName : netsToRoute) {
                    void var12_25;
                    Object var12_21 = null;
                    ArcInst ai = cell.findArc(netName);
                    if (ai != null) {
                        Network network = netList.getNetwork(ai, 0);
                    } else {
                        Netlist nl = cell.getNetlist();
                        Iterator<Network> it = nl.getNetworks();
                        while (it.hasNext()) {
                            void var12_23;
                            Network n2 = it.next();
                            Iterator<String> iterator = n2.getNames();
                            while (iterator.hasNext()) {
                                String nn = iterator.next();
                                if (!nn.equals(netName)) continue;
                                Network network = n2;
                                break;
                            }
                            if (var12_23 == null) continue;
                            break;
                        }
                    }
                    if (var12_25 == null) {
                        System.out.println("WARNING: Could not find network '" + netName + "' which was requested by the Sea-of-Gates Cell Properties");
                        continue;
                    }
                    Iterator<Object> it = var12_25.getArcs();
                    while (it.hasNext()) {
                        ai = it.next();
                        if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                        arcsToRoute.add(ai);
                    }
                }
                if (!RoutingDebug.isActive()) {
                    System.out.println("Routing " + arcsToRoute.size() + " arcs from the list given in the Sea-of-Gates Cell Properties");
                }
            }
        }
        if (arcsToRoute == null) {
            arcsToRoute = new ArrayList<ArcInst>();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                arcsToRoute.add(ai);
            }
        }
        if (arcsToRoute.isEmpty()) {
            return;
        }
        this.setProgressNote("Make list of routes...");
        if (!RoutingDebug.isActive()) {
            handler.startProgressDialog("Routing " + arcsToRoute.size() + " nets in cell " + cell.describe(false));
        }
        List<EPoint> linesInNonMahnattan = new ArrayList<EPoint>();
        RouteBatch[] routeBatches = this.makeListOfRoutes(netList, arcsToRoute, linesInNonMahnattan);
        MutableBoolean hadNonmanhattan = new MutableBoolean(linesInNonMahnattan.size() > 0);
        if (routeBatches.length == 0) {
            return;
        }
        if (RoutingDebug.isRewireNetworks()) {
            this.rewireNetworks(routeBatches);
            return;
        }
        ArrayList<NeededRoute> arrayList = new ArrayList<NeededRoute>();
        for (int b2 = 0; b2 < routeBatches.length; ++b2) {
            for (NeededRoute nr : routeBatches[b2].routesInBatch) {
                arrayList.add(nr);
            }
        }
        this.info("");
        this.info("Sea-of-gates router finding " + arrayList.size() + " paths on " + routeBatches.length + " networks in cell " + cell.describe(false));
        if (hadNonmanhattan.booleanValue()) {
            String info = "Found nonmanhattan geometry (" + linesInNonMahnattan.size() + " points). This may cause larger rectangular blockages, which may block too much.";
            if (linesInNonMahnattan.size() > 100) {
                linesInNonMahnattan = linesInNonMahnattan.subList(0, 100);
                info = info + ". Displaying only the first 100";
            }
            this.warn(info, cell, linesInNonMahnattan, null);
        }
        if (this.prefs.useGlobalRouter || RoutingDebug.isTestGlobalRouting()) {
            this.setProgressNote("Do Global Routing...");
            this.info("Doing Global Routing...");
            RouteBatch[] fakeRBs = null;
            if (RoutingDebug.isActive()) {
                HashMap<Network, RouteBatch> additionalRBs = new HashMap<Network, RouteBatch>();
                HashSet<ArcInst> arcsInCell = new HashSet<ArcInst>();
                for (ArcInst arcInst : arcsToRoute) {
                    arcsInCell.add(arcInst);
                }
                Iterator<ArcInst> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcProto bArc;
                    ArcInst arcInst = it.next();
                    if (arcInst.getProto() != Generic.tech().unrouted_arc || arcsInCell.contains(arcInst)) continue;
                    Network net = netList.getNetwork(arcInst, 0);
                    Object rb = (RouteBatch)additionalRBs.get(net);
                    if (rb == null) {
                        rb = new RouteBatch(net.getName());
                        additionalRBs.put(net, (RouteBatch)rb);
                    }
                    PortInst aPi = arcInst.getHeadPortInst();
                    PortInst bPi = arcInst.getTailPortInst();
                    ArcProto aArc = this.getMetalArcOnPort(aPi);
                    if (aArc == null || (bArc = this.getMetalArcOnPort(bPi)) == null) continue;
                    NeededRoute nr = new NeededRoute(net.getName(), aPi, bPi, aArc, bArc, null, 0.0);
                    ((RouteBatch)rb).addRoute(nr);
                }
                fakeRBs = new RouteBatch[additionalRBs.size()];
                int i3 = 0;
                for (Network net : additionalRBs.keySet()) {
                    fakeRBs[i3++] = (RouteBatch)additionalRBs.get(net);
                }
            }
            double wirePitch = Math.max(this.metalSurroundX[0], this.metalSurroundY[0]) + this.maxDefArcWidth[0];
            GlobalRouter gr = this.doGlobalRouting(cell, routeBatches, fakeRBs, wirePitch);
            ArrayList<NeededRoute> arrayList2 = new ArrayList<NeededRoute>();
            ArrayList<NeededRoute> withoutGR = new ArrayList<NeededRoute>();
            for (NeededRoute nr : arrayList) {
                if (nr.buckets != null) {
                    arrayList2.add(nr);
                    continue;
                }
                withoutGR.add(nr);
            }
            this.info("Global Routing planned " + arrayList2.size() + " paths in " + gr.getXBuckets() + "x" + gr.getYBuckets() + " buckets (" + withoutGR.size() + " paths are too short to route globally)");
            if (RoutingDebug.isActive()) {
                RoutingDebug.setGlobalRouting(gr);
            }
            if (RoutingDebug.isTestGlobalRouting()) {
                RoutingDebug.showGlobalRouting();
                return;
            }
            this.setProgressNote("Detail Route " + arrayList.size() + " paths...");
            this.info("Detail Routing " + arrayList.size() + " paths...");
        } else {
            this.setProgressNote("Route " + arrayList.size() + " paths...");
            this.info("Routing " + arrayList.size() + " paths...");
        }
        for (NeededRoute nr : arrayList) {
            nr.checkGridValidity();
        }
        if (RoutingDebug.isActive() && arrayList.size() > 0 && (whichRoute = RoutingDebug.getDesiredRouteToDebug()) != null) {
            NeededRoute nr = (NeededRoute)arrayList.get(0);
            for (NeededRoute nrTest : arrayList) {
                if (!nrTest.routeName.equalsIgnoreCase(whichRoute)) continue;
                nr = nrTest;
                break;
            }
            nr.setDebugging(RoutingDebug.isEndADebugging());
        }
        boolean parallel = this.prefs.useParallelRoutes;
        this.parallelDij = this.prefs.useParallelFromToRoutes;
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors <= 1) {
            this.parallelDij = false;
        }
        int numberOfThreads = numberOfProcessors;
        if (this.prefs.forcedNumberOfThreads > 0) {
            this.info("Forcing use of " + this.prefs.forcedNumberOfThreads + " threads");
            numberOfThreads = this.prefs.forcedNumberOfThreads;
        }
        if (!parallel) {
            numberOfThreads = 1;
        }
        if (numberOfThreads == 1) {
            parallel = false;
            this.parallelDij = false;
        }
        if (parallel) {
            String message = "NOTE: System has " + numberOfProcessors + " processors so";
            if (this.parallelDij) {
                message = message + " routing " + numberOfThreads / 2 + " paths in parallel";
                message = message + " and routing both directions of each path in parallel";
            } else {
                message = message + " routing " + numberOfThreads + " paths in parallel";
            }
            this.info(message);
        }
        if (numberOfThreads > 1) {
            this.doRoutingParallel(numberOfThreads, arrayList);
        } else {
            this.doRouting(arrayList);
        }
        if (!RoutingDebug.isActive()) {
            void var17_55;
            handler.flush(true);
            if (this.tapRoutes.size() > 0) {
                this.setProgressNote("Adding taps to spine routes...");
                this.info("------------------ Adding taps to spine routes...");
                if (numberOfThreads > 1) {
                    this.doRoutingParallel(numberOfThreads, this.tapRoutes);
                } else {
                    this.doRouting(this.tapRoutes);
                }
                handler.flush(true);
            }
            ArrayList<NeededRoute> redoRoutes = new ArrayList<NeededRoute>();
            boolean bl = false;
            while (var17_55 < routeBatches.length) {
                for (NeededRoute nr : routeBatches[var17_55].routesInBatch) {
                    if (nr.routedSuccess) continue;
                    redoRoutes.add(nr);
                    nr.buckets = null;
                    nr.errorMessage = null;
                    nr.complexityLimit = this.prefs.rerunComplexityLimit;
                    nr.makeWavefronts();
                }
                ++var17_55;
            }
            if (this.prefs.reRunFailedRoutes && redoRoutes.size() > 0) {
                this.setProgressNote("Re-Route " + redoRoutes.size() + " paths...");
                this.info("------------------ Re-Route " + redoRoutes.size() + " paths...");
                for (NeededRoute nr : redoRoutes) {
                    nr.reroute = true;
                    if (nr.loggedMessage == null) continue;
                    ArrayList<ErrorLogger.MessageLog> oldMessage = new ArrayList<ErrorLogger.MessageLog>();
                    oldMessage.add(nr.loggedMessage);
                    this.errorLogger.deleteMessages(oldMessage);
                }
                if (numberOfThreads > 1) {
                    this.doRoutingParallel(numberOfThreads, redoRoutes);
                } else {
                    this.doRouting(redoRoutes);
                }
                handler.flush(true);
            }
            RouteResolution routeResolution = new RouteResolution(cell.getId());
            for (int b4 = 0; b4 < routeBatches.length; ++b4) {
                for (NeededRoute nr : routeBatches[b4].routesInBatch) {
                    if (nr.routedSuccess) continue;
                    routeResolution.addUnrouted(nr.aPi, nr.bPi, nr.getName());
                }
            }
            handler.instantiate(routeResolution);
            handler.flush(true);
            this.summarize(routeBatches, arrayList);
        }
        handler.termLogging(this.errorLogger);
        handler.stopProgressDialog();
    }

    public RTNode<SOGBound> getMetalTree(Layer lay) {
        return this.rTrees.getMetalTree(lay).getRoot();
    }

    public Iterator<SOGBound> searchMetalTree(Layer lay, Rectangle2D bound) {
        return this.rTrees.getMetalTree(lay).search(bound);
    }

    private void rewireNetworks(RouteBatch[] routeBatches) {
        for (int b2 = 0; b2 < routeBatches.length; ++b2) {
            RouteBatch rb = routeBatches[b2];
            for (ArcInst ai : rb.unroutedArcs) {
                ai.kill();
            }
            for (NeededRoute nr : rb.routesInBatch) {
                EPoint aPt = nr.aPi.getCenter();
                EPoint bPt = nr.bPi.getCenter();
                ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, nr.aPi, nr.bPi, aPt, bPt, nr.getName());
            }
        }
        this.sogp.setSteinerDone(true);
        this.sogp.saveParameters(this.ep);
    }

    private void summarize(RouteBatch[] routeBatches, List<NeededRoute> allRoutes) {
        this.sogQual = new SoGWireQualityMetric("SoG");
        this.sogQual.setOutput(this.prefs.qualityPrintStream);
        for (int b2 = 0; b2 < routeBatches.length; ++b2) {
            this.sogQual.calculate(routeBatches[b2]);
        }
        this.prefs.theTimer.end();
        this.info("Cell " + this.cell.describe(false) + " routed " + this.sogQual.numRoutedSegments + " out of " + allRoutes.size() + " segments (took " + String.valueOf(this.prefs.theTimer) + ")");
        if (this.sogQual.numFailedSegments > 0) {
            this.info("NOTE: " + this.sogQual.numFailedSegments + " segments on " + this.sogQual.numFailedBatches + " nets were not routed");
        }
        this.info(this.sogQual.printAverageResults());
    }

    public String getRoutedNetRatio() {
        Object value = "";
        if (this.sogQual != null) {
            int total = this.sogQual.numFailedSegments + this.sogQual.numRoutedSegments;
            value = this.sogQual.numRoutedSegments + "/" + total;
        }
        return value;
    }

    public void setPrefs(SeaOfGates.SeaOfGatesOptions p) {
        this.prefs = p;
    }

    public SeaOfGates.SeaOfGatesOptions getPrefs() {
        return this.prefs;
    }

    public Technology getTech() {
        return this.tech;
    }

    public int getNumMetals() {
        return numMetalLayers;
    }

    public Layer getPrimaryMetalLayer(int layNum) {
        return this.primaryMetalLayer[layNum];
    }

    private boolean isOnMetalArc(int layNum, ArcProto ap) {
        for (int c2 = 0; c2 < this.metalArcs[layNum].length; ++c2) {
            if (this.metalArcs[layNum][c2] != ap) continue;
            return true;
        }
        return false;
    }

    public Layer getViaLayer(int layNum) {
        return this.viaLayers[layNum];
    }

    protected String describe(NodeInst ni) {
        NodeProto np = ni.getProto();
        boolean libDescribe = np instanceof Cell ? ((Cell)np).getLibrary() != this.cell.getLibrary() : ((PrimitiveNode)np).getTechnology() != this.tech;
        return libDescribe ? ni.libDescribe() : ni.noLibDescribe();
    }

    protected String describe(ArcInst ai) {
        ArcProto ap = ai.getProto();
        boolean libDescribe = ap.getTechnology() != this.tech;
        return libDescribe ? ai.libDescribe() : ai.noLibDescribe();
    }

    protected String describe(NodeProto np) {
        boolean libDescribe = np instanceof Cell ? ((Cell)np).getLibrary() != this.cell.getLibrary() : ((PrimitiveNode)np).getTechnology() != this.tech;
        return libDescribe ? np.libDescribe() : np.noLibDescribe();
    }

    protected String describe(ArcProto ap) {
        boolean libDescribe = ap.getTechnology() != this.tech;
        return libDescribe ? ap.getFullName() : ap.getName();
    }

    protected Environment getEnvironment() {
        return this.env;
    }

    protected boolean checkAbort() {
        return this.handler.checkAbort();
    }

    protected void trace(String msg) {
        this.handler.trace(msg);
    }

    protected void debug(String msg) {
        this.handler.debug(msg);
    }

    protected void info(String msg) {
        this.handler.info(msg);
    }

    protected void warn(String msg) {
        this.handler.warn(msg);
    }

    protected void warn(String msg, Cell cell, List<EPoint> linesToShow, List<PolyBase> polysToShow) {
        this.warn(msg);
        if (polysToShow != null) {
            this.errorLogger.logMessage(msg, null, polysToShow, cell, 0, false);
            return;
        }
        this.errorLogger.logMessageWithLines(msg, linesToShow, linesToShow, cell, 0, false);
    }

    protected void error(String msg) {
        this.handler.error(msg);
    }

    protected void setProgressNote(String message) {
        if (!RoutingDebug.isActive()) {
            this.handler.setProgressNote(message);
        }
    }

    protected void setProgressValue(int done, int total) {
        if (!RoutingDebug.isActive()) {
            this.handler.setProgressValue(done, total);
        }
    }

    void flush() {
        this.handler.flush(false);
    }

    protected abstract void doRoutingParallel(int var1, List<NeededRoute> var2);

    private void doRouting(List<NeededRoute> allRoutes) {
        int totalRoutes = allRoutes.size();
        for (int r = 0; r < totalRoutes; ++r) {
            Runnable[] runnables;
            if (this.checkAbort()) {
                this.info("Sea-of-gates routing aborted");
                break;
            }
            NeededRoute nr = allRoutes.get(r);
            this.setProgressValue(r, totalRoutes);
            String progMsg = "Routing network " + nr.routeName + "...";
            this.setProgressNote(progMsg);
            if (!this.messagesQuiet && !Job.getDebug()) {
                this.trace(progMsg);
            }
            if (nr.alreadyRouted) {
                ArrayList<PolyBase> polysInConnection = new ArrayList<PolyBase>();
                PolyBase.Point[] points = new PolyBase.Point[]{PolyBase.fromLambda(nr.aEndpoints.getCenterX(), nr.aEndpoints.getCenterY()), PolyBase.fromLambda(nr.bEndpoints.getCenterX(), nr.bEndpoints.getCenterY())};
                polysInConnection.add(new PolyBase(points));
                for (int i2 = 0; i2 < numMetalLayers; ++i2) {
                    RTNode<SOGBound> root = this.rTrees.metalTrees[i2].getRoot();
                    if (root == null) continue;
                    this.addNetsToList(root, nr.netID, polysInConnection);
                }
                if (this.prefs.runOnConnectedRoutes) {
                    this.warn("Network " + nr.getName() + " is already routed in the circuit, running router on it anyway", this.cell, null, polysInConnection);
                } else {
                    this.warn("Not routing network " + nr.getName() + " because it is already routed in the circuit", this.cell, null, polysInConnection);
                    continue;
                }
            }
            if ((runnables = this.findPath(nr)) != null) {
                for (Runnable runnable : runnables) {
                    runnable.run();
                }
            }
            if (nr.debuggingRouteFromA == null) continue;
            RoutingDebug.debugRoute(nr);
            break;
        }
    }

    private void addNetsToList(RTNode<SOGBound> node, MutableInteger net, List<PolyBase> polysInConnection) {
        for (int i2 = 0; i2 < node.getTotal(); ++i2) {
            if (node.getFlag()) {
                SOGBound b2 = (SOGBound)node.getChild(i2);
                if (b2.getNetID() == null || b2.getNetID().intValue() != net.intValue()) continue;
                ERectangle rect = b2.getBounds();
                polysInConnection.add(new PolyBase(rect));
                continue;
            }
            RTNode subNode = (RTNode)node.getChild(i2);
            this.addNetsToList(subNode, net, polysInConnection);
        }
    }

    public ErrorLogger getErrorLgger() {
        return this.errorLogger;
    }

    private boolean initializeDesignRules() {
        int i2;
        int i3;
        int i4;
        int metNum;
        numMetalLayers = 0;
        Iterator<Comparable> it = this.tech.getLayers();
        while (it.hasNext()) {
            Layer lay = it.next();
            if (!lay.getFunction().isMetal()) continue;
            metNum = lay.getFunction().getLevel();
            numMetalLayers = Math.max(metNum, numMetalLayers);
        }
        it = this.tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (!ap.getFunction().isMetal()) continue;
            metNum = ap.getFunction().getLevel();
            numMetalLayers = Math.max(metNum, numMetalLayers);
        }
        this.metalLayers = new Layer[numMetalLayers][];
        this.primaryMetalLayer = new Layer[numMetalLayers];
        List[] tempLayerList = new List[numMetalLayers];
        for (int i5 = 0; i5 < numMetalLayers; ++i5) {
            tempLayerList[i5] = new ArrayList();
        }
        Iterator<Layer> it2 = this.tech.getLayers();
        while (it2.hasNext()) {
            Layer lay = it2.next();
            if (!lay.getFunction().isMetal()) continue;
            int metNum2 = lay.getFunction().getLevel() - 1;
            tempLayerList[metNum2].add(lay);
        }
        for (int i6 = 0; i6 < numMetalLayers; ++i6) {
            Layer first;
            int colorNum;
            this.primaryMetalLayer[i6] = null;
            Collections.sort(tempLayerList[i6], new SortLayersByMaskNumber());
            if (tempLayerList[i6].size() > 1 && (colorNum = (first = (Layer)tempLayerList[i6].get(0)).getFunction().getMaskColor()) == 0) {
                this.primaryMetalLayer[i6] = (Layer)tempLayerList[i6].get(0);
                tempLayerList[i6].remove(0);
            }
            this.metalLayers[i6] = new Layer[tempLayerList[i6].size()];
            for (int c2 = 0; c2 < tempLayerList[i6].size(); ++c2) {
                this.metalLayers[i6][c2] = (Layer)tempLayerList[i6].get(c2);
            }
            if (this.primaryMetalLayer[i6] != null) continue;
            this.primaryMetalLayer[i6] = this.metalLayers[i6][0];
        }
        this.metalArcs = new ArcProto[numMetalLayers][];
        this.metalPureLayerNodes = new PrimitiveNode[numMetalLayers][];
        this.primaryMetalArc = new ArcProto[numMetalLayers];
        this.size2X = new double[numMetalLayers];
        this.taperLength = new double[numMetalLayers];
        boolean hasFavorites = false;
        this.favorArcs = new boolean[numMetalLayers];
        this.preventArcs = new boolean[numMetalLayers];
        this.taperOnlyArcs = new boolean[numMetalLayers];
        for (int i7 = 0; i7 < numMetalLayers; ++i7) {
            this.taperOnlyArcs[i7] = false;
            this.preventArcs[i7] = false;
            this.favorArcs[i7] = false;
        }
        List[] tempArcList = new List[numMetalLayers];
        for (int i8 = 0; i8 < numMetalLayers; ++i8) {
            tempArcList[i8] = new ArrayList();
        }
        Iterator<ArcProto> it3 = this.tech.getArcs();
        while (it3.hasNext()) {
            ArcProto ap = it3.next();
            if (!ap.getFunction().isMetal()) continue;
            int metNum3 = ap.getFunction().getLevel() - 1;
            tempArcList[metNum3].add(ap);
        }
        for (i4 = 0; i4 < numMetalLayers; ++i4) {
            Double d2;
            ArcProto first;
            int colorNum;
            this.primaryMetalArc[i4] = null;
            Collections.sort(tempArcList[i4], new SortArcsByMaskNumber());
            if (tempArcList[i4].size() > 1 && (colorNum = (first = (ArcProto)tempArcList[i4].get(0)).getMaskLayer()) == 0) {
                this.primaryMetalArc[i4] = (ArcProto)tempArcList[i4].get(0);
                tempArcList[i4].remove(0);
            }
            this.metalArcs[i4] = new ArcProto[tempArcList[i4].size()];
            this.metalPureLayerNodes[i4] = new PrimitiveNode[tempArcList[i4].size()];
            for (int c3 = 0; c3 < tempArcList[i4].size(); ++c3) {
                ArcProto ap = (ArcProto)tempArcList[i4].get(c3);
                int metNum4 = ap.getFunction().getLevel() - 1;
                this.metalArcs[i4][c3] = ap;
                Iterator<PrimitiveNode> it4 = this.tech.getNodes();
                while (it4.hasNext()) {
                    PrimitiveNode pNp = it4.next();
                    if (pNp.getFunction() != PrimitiveNode.Function.NODE) continue;
                    Iterator<Layer> lIt = pNp.getLayerIterator();
                    while (lIt.hasNext()) {
                        Layer lay = lIt.next();
                        if (!lay.getFunction().isMetal() || lay.getFunction().getLevel() - 1 != metNum4 || lay.getFunction().getMaskColor() != ap.getMaskLayer()) continue;
                        this.metalPureLayerNodes[i4][c3] = pNp;
                        break;
                    }
                    if (this.metalPureLayerNodes[i4][c3] == null) continue;
                    break;
                }
                if (this.sogp.isFavored(ap)) {
                    this.favorArcs[metNum4] = true;
                    hasFavorites = true;
                }
                if (this.sogp.isPrevented(ap)) {
                    this.preventArcs[metNum4] = true;
                }
                if (!this.sogp.isTaperOnly(ap)) continue;
                this.taperOnlyArcs[metNum4] = true;
            }
            if (this.primaryMetalArc[i4] == null) {
                this.primaryMetalArc[i4] = this.metalArcs[i4][0];
            }
            this.size2X[i4] = (d2 = this.sogp.get2XWidth(this.primaryMetalArc[i4])) == null ? 0.0 : d2;
            d2 = this.sogp.getTaperLength(this.primaryMetalArc[i4]);
            this.taperLength[i4] = d2 == null ? -1.0 : d2;
        }
        if (!hasFavorites) {
            for (i4 = 0; i4 < numMetalLayers; ++i4) {
                this.favorArcs[i4] = true;
            }
        }
        boolean failure = false;
        for (i3 = 0; i3 < numMetalLayers; ++i3) {
            int c4;
            if (this.metalLayers[i3].length == 0) {
                this.error("Cannot find layer for Metal " + (i3 + 1) + " in technology " + this.tech.getTechName());
                failure = true;
            }
            if (this.metalArcs[i3].length == 0) {
                this.error("Cannot find arc for Metal " + (i3 + 1) + " in technology " + this.tech.getTechName());
                failure = true;
            }
            for (int c5 = 0; c5 < this.metalPureLayerNodes[i3].length; ++c5) {
                if (this.metalPureLayerNodes[i3][c5] != null) continue;
                this.error("Cannot find pure-layer node for Metal " + (i3 + 1) + " color " + (c5 + 1) + " in technology " + this.tech.getTechName());
                failure = true;
            }
            if (this.metalLayers[i3].length != this.metalArcs[i3].length) {
                Object layMsg = "";
                for (int c6 = 0; c6 < this.metalLayers[i3].length; ++c6) {
                    if (((String)layMsg).length() > 0) {
                        layMsg = (String)layMsg + ", ";
                    }
                    layMsg = (String)layMsg + this.metalLayers[i3][c6].getName();
                }
                Object arcMsg = "";
                for (int c7 = 0; c7 < this.metalArcs[i3].length; ++c7) {
                    if (((String)arcMsg).length() > 0) {
                        arcMsg = (String)arcMsg + ", ";
                    }
                    arcMsg = (String)arcMsg + this.metalArcs[i3][c7].getName();
                }
                this.warn("Metal " + (i3 + 1) + " in technology " + this.tech.getTechName() + " has " + this.metalLayers[i3].length + " mask layers (" + (String)layMsg + ") but " + this.metalArcs[i3].length + " mask arcs (" + (String)arcMsg + "). Making them equal length.");
                if (this.metalLayers[i3].length > this.metalArcs[i3].length) {
                    Layer[] newMetalLayers = new Layer[this.metalArcs[i3].length];
                    for (c4 = 0; c4 < newMetalLayers.length; ++c4) {
                        newMetalLayers[c4] = this.metalLayers[i3][c4];
                    }
                    this.metalLayers[i3] = newMetalLayers;
                } else {
                    ArcProto[] newMetalArcs = new ArcProto[this.metalLayers[i3].length];
                    for (c4 = 0; c4 < newMetalArcs.length; ++c4) {
                        newMetalArcs[c4] = this.metalArcs[i3][c4];
                    }
                    this.metalArcs[i3] = newMetalArcs;
                }
            }
            if (this.metalLayers[i3].length != this.metalArcs[i3].length) continue;
            boolean badOrder = false;
            Object layMsg = "";
            Object arcMsg = "";
            for (c4 = 0; c4 < this.metalLayers[i3].length; ++c4) {
                int layMask = this.metalLayers[i3][c4].getFunction().getMaskColor();
                int arcMask = this.metalArcs[i3][c4].getMaskLayer();
                if (((String)layMsg).length() > 0) {
                    layMsg = (String)layMsg + ", ";
                }
                layMsg = (String)layMsg + layMask;
                if (((String)arcMsg).length() > 0) {
                    arcMsg = (String)arcMsg + ", ";
                }
                arcMsg = (String)arcMsg + arcMask;
                if (layMask == arcMask) continue;
                badOrder = true;
            }
            if (!badOrder) continue;
            this.error("Metal " + (i3 + 1) + " in technology " + this.tech.getTechName() + " has layer masks " + (String)layMsg + " but arc masks " + (String)arcMsg);
            failure = true;
        }
        if (failure) {
            return true;
        }
        this.removeLayers = new HashMap<Layer, Layer>();
        for (i3 = 0; i3 < numMetalLayers; ++i3) {
            for (int j2 = 0; j2 < this.metalLayers[i3].length; ++j2) {
                Layer metLay = this.metalLayers[i3][j2];
                ArcProto metAp = this.metalArcs[i3][j2];
                String removeLayerName = this.sogp.getRemoveLayer(metAp);
                if (removeLayerName == null) continue;
                Layer removeLay = this.tech.findLayer(removeLayerName);
                if (removeLay == null) {
                    System.out.println("WARNING: Unknown removal layer: " + removeLayerName);
                    continue;
                }
                this.removeLayers.put(removeLay, metLay);
            }
        }
        this.viaLayers = new Layer[numMetalLayers - 1];
        this.metalVias = new MetalVias[numMetalLayers - 1];
        for (i3 = 0; i3 < numMetalLayers - 1; ++i3) {
            this.metalVias[i3] = new MetalVias();
        }
        this.metalVias2X = new MetalVias[numMetalLayers - 1];
        for (i3 = 0; i3 < numMetalLayers - 1; ++i3) {
            this.metalVias2X[i3] = new MetalVias();
        }
        List[] tempViaLayerList = new List[numMetalLayers - 1];
        for (int i9 = 0; i9 < numMetalLayers - 1; ++i9) {
            tempViaLayerList[i9] = new ArrayList();
        }
        Iterator<Layer> it5 = this.tech.getLayers();
        while (it5.hasNext()) {
            int viaNum;
            Layer lay = it5.next();
            if (!lay.getFunction().isContact() || (viaNum = lay.getFunction().getLevel() - 2) < 0) continue;
            tempViaLayerList[viaNum].add(lay);
        }
        for (int i10 = 0; i10 < numMetalLayers - 1; ++i10) {
            Collections.sort(tempViaLayerList[i10], new SortLayersByMaskNumber());
            this.viaLayers[i10] = (Layer)tempViaLayerList[i10].get(0);
        }
        String ignorePattern = this.sogp.getIgnorePrimitives();
        String accept1XPattern = this.sogp.getAcceptOnly1XPrimitives();
        String accept2XPattern = this.sogp.getAcceptOnly2XPrimitives();
        boolean contactsCanRotate = this.sogp.isContactsRotate();
        Pattern ignorePat = ignorePattern != null ? Pattern.compile(ignorePattern) : null;
        Pattern acceptPat1X = accept1XPattern != null ? Pattern.compile(accept1XPattern) : null;
        Pattern acceptPat2X = accept2XPattern != null ? Pattern.compile(accept2XPattern) : null;
        Iterator<PrimitiveNode> it6 = this.tech.getNodes();
        block28: while (it6.hasNext()) {
            Matcher matcher;
            Matcher matcher2;
            PrimitiveNode np = it6.next();
            if (np.isNotUsed() || !np.getFunction().isContact() || ignorePat != null && (matcher2 = ignorePat.matcher(np.getName())).find()) continue;
            boolean is1XContact = false;
            boolean is2XContact = false;
            if (acceptPat1X == null) {
                is1XContact = true;
            } else {
                matcher = acceptPat1X.matcher(np.getName());
                is1XContact = matcher.find();
            }
            if (acceptPat2X == null) {
                is2XContact = true;
            } else {
                matcher = acceptPat2X.matcher(np.getName());
                is2XContact = matcher.find();
            }
            if (!is1XContact && !is2XContact) continue;
            MetalVias[] whichOnes = is1XContact ? this.metalVias : this.metalVias2X;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i11 = 0; i11 < numMetalLayers - 1; ++i11) {
                if ((!this.isOnMetalArc(i11, conns[0]) || !this.isOnMetalArc(i11 + 1, conns[1])) && (!this.isOnMetalArc(i11, conns[1]) || !this.isOnMetalArc(i11 + 1, conns[0]))) continue;
                boolean square = true;
                boolean offCenter = false;
                Technology.NodeLayer[] dummyNi = NodeInst.makeDummyInstance((NodeProto)np, this.ep);
                Poly[] conPolys = this.tech.getShapeOfNode((NodeInst)dummyNi);
                int horMet = -1;
                int verMet = -1;
                double horMetInset = 0.0;
                double verMetInset = 0.0;
                int horMetColor = 0;
                int verMetColor = 0;
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (!lFun.isMetal()) continue;
                    FixpRectangle conRect = conPoly.getBounds2D();
                    if (((RectangularShape)conRect).getWidth() != ((RectangularShape)conRect).getHeight()) {
                        square = false;
                        if (((RectangularShape)conRect).getWidth() > ((RectangularShape)conRect).getHeight()) {
                            horMet = lFun.getLevel() - 1;
                            horMetColor = lFun.getMaskColor();
                            horMetInset = dummyNi.getYSize() - ((RectangularShape)conRect).getHeight();
                        } else {
                            verMet = lFun.getLevel() - 1;
                            verMetColor = lFun.getMaskColor();
                            verMetInset = dummyNi.getXSize() - ((RectangularShape)conRect).getWidth();
                        }
                    }
                    if (((RectangularShape)conRect).getCenterX() == 0.0 && ((RectangularShape)conRect).getCenterY() == 0.0) continue;
                    offCenter = true;
                }
                if (square || offCenter) {
                    verMet = -1;
                    horMet = -1;
                } else if (horMet < 0 || verMet < 0) {
                    verMet = -1;
                    horMet = -1;
                }
                whichOnes[i11].addVia(np, 0, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                if (!contactsCanRotate) continue block28;
                if (offCenter) {
                    whichOnes[i11].addVia(np, 90, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                    whichOnes[i11].addVia(np, 180, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                    whichOnes[i11].addVia(np, 270, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                    continue block28;
                }
                if (square) continue block28;
                whichOnes[i11].addVia(np, 90, verMet, verMetColor, verMetInset, horMet, horMetColor, horMetInset);
                continue block28;
            }
        }
        for (int i12 = 0; i12 < numMetalLayers - 1; ++i12) {
            if (this.metalArcs[i12].length > 1 || this.metalArcs[i12 + 1].length > 1) {
                boolean[][] masks = new boolean[this.metalArcs[i12].length][this.metalArcs[i12 + 1].length];
                for (int c1 = 0; c1 < this.metalArcs[i12].length; ++c1) {
                    for (int c2 = 0; c2 < this.metalArcs[i12 + 1].length; ++c2) {
                        masks[c1][c2] = false;
                    }
                }
                ArrayList<MetalVia> allContacts = new ArrayList<MetalVia>();
                for (MetalVia mv : this.metalVias[i12].getVias()) {
                    allContacts.add(mv);
                }
                for (MetalVia mv : this.metalVias2X[i12].getVias()) {
                    allContacts.add(mv);
                }
                for (MetalVia mv : allContacts) {
                    int met1 = -1;
                    int met1c = -1;
                    int met2 = -1;
                    int met2c = -1;
                    for (Technology.NodeLayer nl : mv.via.getNodeLayers()) {
                        Layer layer = nl.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        if (met1 < 0) {
                            met1 = layer.getFunction().getLevel();
                            met1c = layer.getFunction().getMaskColor();
                            continue;
                        }
                        met2 = layer.getFunction().getLevel();
                        met2c = layer.getFunction().getMaskColor();
                    }
                    if (met1 < 0 || met2 < 0) continue;
                    if (met1 != i12 + 1 || met2 != i12 + 2) {
                        this.warn("Contact " + mv.via.getName() + " in technology " + this.tech.getTechName() + " bridges metals " + (i12 + 1) + " and " + (i12 + 2) + " but mentions different metals in its name");
                        continue;
                    }
                    if (met1c == 0) {
                        if (this.metalArcs[i12].length > 1) {
                            this.warn("Contact " + mv.via.getName() + " in technology " + this.tech.getTechName() + " does not specify mask for metal " + (i12 + 1));
                        }
                        met1c = 1;
                    }
                    if (met2c == 0) {
                        if (this.metalArcs[i12 + 1].length > 1) {
                            this.warn("Contact " + mv.via.getName() + " in technology " + this.tech.getTechName() + " does not specify mask for metal " + (i12 + 2));
                        }
                        met2c = 1;
                    }
                    masks[met1c - 1][met2c - 1] = true;
                }
                for (int c1 = 0; c1 < this.metalArcs[i12].length; ++c1) {
                    for (int c2 = 0; c2 < this.metalArcs[i12 + 1].length; ++c2) {
                        if (masks[c1][c2]) continue;
                        this.warn("No metal-" + (i12 + 1) + " to metal-" + (i12 + 2) + " contact in technology " + this.tech.getTechName() + " that bridges metal-" + (i12 + 1) + "/mask-" + (c1 + 1) + " and metal-" + (i12 + 2) + "/mask-" + (c2 + 1));
                    }
                }
            }
            boolean noContact = false;
            if (this.metalVias[i12].getVias().size() == 0) {
                this.warn("Cannot find contact node between Metal " + (i12 + 1) + " and Metal " + (i12 + 2) + " in technology " + this.tech.getTechName() + ". Ignoring Metal layers " + (i12 + 2) + " and higher.");
                noContact = true;
            } else if (this.viaLayers[i12] == null) {
                this.warn("Cannot find contact layer between Metal " + (i12 + 1) + " and Metal " + (i12 + 2) + " in technology " + this.tech.getTechName() + ". Ignoring Metal layers " + (i12 + 2) + " and higher.");
                noContact = true;
            }
            if (!noContact) continue;
            for (int j3 = i12 + 1; j3 < numMetalLayers; ++j3) {
                this.preventArcs[j3] = true;
            }
            break;
        }
        DRC.DRCPreferences dp = new DRC.DRCPreferences(false);
        this.minResolution = dp.getResolution(this.tech).getLambda();
        this.layerSurround = new Map[numMetalLayers];
        for (int i13 = 0; i13 < numMetalLayers; ++i13) {
            this.layerSurround[i13] = new HashMap<Double, Map<Double, double[]>>();
        }
        this.metalSurroundX = new double[numMetalLayers];
        this.metalSurroundY = new double[numMetalLayers];
        this.maxDefArcWidth = new double[numMetalLayers];
        this.minimumArea = new double[numMetalLayers];
        MutableDouble mutableDist = new MutableDouble(0.0);
        for (i2 = 0; i2 < numMetalLayers; ++i2) {
            if (this.metalLayers[i2] == null) continue;
            this.minimumArea[i2] = 0.0;
            DRCTemplate minAreaRule = DRC.getMinValue(this.primaryMetalLayer[i2], DRCTemplate.DRCRuleType.MINAREA);
            if (minAreaRule != null) {
                this.minimumArea[i2] = minAreaRule.getValue(0);
            }
            this.maxDefArcWidth[i2] = 0.0;
            this.metalSurroundY[i2] = 0.0;
            this.metalSurroundX[i2] = 0.0;
            for (int c8 = 0; c8 < this.metalArcs[i2].length; ++c8) {
                this.maxDefArcWidth[i2] = Math.max(this.maxDefArcWidth[i2], this.metalArcs[i2][c8].getDefaultLambdaBaseWidth(this.ep));
                DRCTemplate rule = DRC.getSpacingRule(this.metalLayers[i2][c8], null, this.metalLayers[i2][c8], null, false, -1, this.metalArcs[i2][c8].getDefaultLambdaBaseWidth(this.ep), 50.0);
                if (rule != null) {
                    this.metalSurroundX[i2] = Math.max(this.metalSurroundX[i2], rule.getValue(0));
                    this.metalSurroundY[i2] = rule.getNumValues() > 1 ? Math.max(this.metalSurroundY[i2], rule.getValue(1)) : this.metalSurroundX[i2];
                }
                if (!DRC.getMaxSurround(this.metalLayers[i2][c8], Double.MAX_VALUE, mutableDist)) continue;
                this.metalSurroundX[i2] = Math.max(this.metalSurroundX[i2], mutableDist.doubleValue());
                if (this.metalSurroundY[i2] == mutableDist.doubleValue()) continue;
                this.metalSurroundY[i2] = Math.max(this.metalSurroundY[i2], mutableDist.doubleValue());
            }
        }
        this.viaSurround = new double[numMetalLayers - 1];
        this.viaSize = new double[numMetalLayers - 1];
        this.viaDiagonalDistance = new double[numMetalLayers - 1];
        this.viaColorDiffSpacing = new double[numMetalLayers - 1];
        this.secretViaSpacingRules = new Method[numMetalLayers - 1];
        for (i2 = 0; i2 < numMetalLayers - 1; ++i2) {
            Layer lay = this.viaLayers[i2];
            if (lay == null) continue;
            this.secretViaSpacingRules[i2] = SeaOfGatesEngine.getViaSpacingChecker(this.tech, i2);
            double spacing = 2.0;
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, this.maxDefArcWidth[i2], 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            this.viaSurround[i2] = spacing;
            double diagonalDist = 0.0;
            DRCTemplate ruleDiagonalVia = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.DIAGONALVIA);
            if (ruleDiagonalVia != null) {
                diagonalDist = ruleDiagonalVia.getValue(0);
            }
            this.viaDiagonalDistance[i2] = diagonalDist;
            double colorDiffDist = 0.0;
            DRCTemplate ruleColorDiffVia = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.DIFFMASKSEP);
            if (ruleColorDiffVia != null) {
                colorDiffDist = ruleColorDiffVia.getValue(0);
            }
            this.viaColorDiffSpacing[i2] = colorDiffDist;
            double width = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            ArrayList<MetalVia> nps = new ArrayList<MetalVia>();
            for (MetalVia mv : this.metalVias[i2].getVias()) {
                nps.add(mv);
            }
            for (MetalVia mv : this.metalVias2X[i2].getVias()) {
                nps.add(mv);
            }
            for (MetalVia mv : nps) {
                NodeInst dummyNi = NodeInst.makeDummyInstance((NodeProto)mv.via, this.ep);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    if (!conPoly.getLayer().getFunction().isContact()) continue;
                    FixpRectangle bounds = conPoly.getBounds2D();
                    width = Math.max(width, ((RectangularShape)bounds).getWidth());
                    width = Math.max(width, ((RectangularShape)bounds).getHeight());
                }
            }
            this.viaSize[i2] = width;
        }
        return false;
    }

    private static boolean hasTSMCDesignRules() {
        if (!tsmcDesignRulesChecked) {
            tsmcDesignRulesChecked = true;
            try {
                tsmcDesignRulesClass = Class.forName("com.sun.electric.plugins.tsmc.TSMCDesignRules");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return tsmcDesignRulesClass != null;
    }

    private static Method getViaSpacingChecker(Technology tech, int metalNo) {
        if (!SeaOfGatesEngine.hasTSMCDesignRules()) {
            return null;
        }
        String methodName = "tsmcVia" + (metalNo + 1) + "RuleFor" + tech.getTechName().toUpperCase();
        try {
            Method viaSpacingCheckMethod = tsmcDesignRulesClass.getMethod(methodName, List.class);
            return viaSpacingCheckMethod;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void initializeGrids() {
        this.metalGrid = new SeaOfGates.SeaOfGatesTrack[numMetalLayers][];
        this.metalGridRange = new double[numMetalLayers];
        for (int i2 = 0; i2 < numMetalLayers; ++i2) {
            int j2;
            ArcProto ap = this.primaryMetalArc[i2];
            String arcGrid = this.sogp.getGrid(ap);
            if (arcGrid == null) {
                this.metalGrid[i2] = null;
                this.metalGridRange[i2] = 0.0;
                continue;
            }
            ArrayList<SeaOfGates.SeaOfGatesTrack> found = new ArrayList<SeaOfGates.SeaOfGatesTrack>();
            String[] parts = arcGrid.split(",");
            for (j2 = 0; j2 < parts.length; ++j2) {
                String part = parts[j2].trim();
                if (part.length() == 0) continue;
                int trackColor = SeaOfGates.SeaOfGatesTrack.getSpecificMaskNumber(part);
                if (!Character.isDigit(part.charAt(part.length() - 1))) {
                    part = part.substring(0, part.length() - 1);
                }
                double val = TextUtils.atof(part);
                found.add(new SeaOfGates.SeaOfGatesTrack(val, trackColor));
            }
            Collections.sort(found);
            this.metalGrid[i2] = new SeaOfGates.SeaOfGatesTrack[found.size()];
            for (j2 = 0; j2 < found.size(); ++j2) {
                this.metalGrid[i2][j2] = (SeaOfGates.SeaOfGatesTrack)found.get(j2);
            }
            this.metalGridRange[i2] = this.metalGrid[i2][found.size() - 1].getCoordinate() - this.metalGrid[i2][0].getCoordinate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private RouteBatch[] makeListOfRoutes(Netlist netList, List<ArcInst> arcsToRoute, List<EPoint> linesInNonMahnattan) {
        HashMap seen = new HashMap();
        for (int b2 = 0; b2 < arcsToRoute.size(); ++b2) {
            void var8_9;
            ArcInst ai = arcsToRoute.get(b2);
            Network net = netList.getNetwork(ai, 0);
            if (net == null) {
                this.warn("Arc " + this.describe(ai) + " has no network!");
                continue;
            }
            List list = (List)seen.get(net);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                seen.put(net, arrayList);
            }
            boolean exists = false;
            for (ArcInst oldAI : var8_9) {
                if (oldAI.getHeadPortInst().getPortProto() == ai.getHeadPortInst().getPortProto() && oldAI.getHeadPortInst().getNodeInst() == ai.getHeadPortInst().getNodeInst() && oldAI.getTailPortInst().getPortProto() == ai.getTailPortInst().getPortProto() && oldAI.getTailPortInst().getNodeInst() == ai.getTailPortInst().getNodeInst()) {
                    exists = true;
                    break;
                }
                if (oldAI.getHeadPortInst().getPortProto() != ai.getTailPortInst().getPortProto() || oldAI.getHeadPortInst().getNodeInst() != ai.getTailPortInst().getNodeInst() || oldAI.getTailPortInst().getPortProto() != ai.getHeadPortInst().getPortProto() || oldAI.getTailPortInst().getNodeInst() != ai.getHeadPortInst().getNodeInst()) continue;
                exists = true;
                break;
            }
            if (exists) {
                String warnMsg = "Arc from (" + TextUtils.formatDistance(ai.getHeadLocation().getX()) + "," + TextUtils.formatDistance(ai.getHeadLocation().getY()) + ") to (" + TextUtils.formatDistance(ai.getTailLocation().getX()) + "," + TextUtils.formatDistance(ai.getTailLocation().getY()) + ") is redundant";
                Iterator<EPoint> linesToShow = new ArrayList();
                linesToShow.add(EPoint.fromLambda(ai.getHeadLocation().getX(), ai.getHeadLocation().getY()));
                linesToShow.add(EPoint.fromLambda(ai.getTailLocation().getX(), ai.getTailLocation().getY()));
                this.warn(warnMsg, netList.getCell(), (List<EPoint>)((Object)linesToShow), null);
                continue;
            }
            var8_9.add(ai);
        }
        ArrayList<RoutesOnNetwork> allRoutes = new ArrayList<RoutesOnNetwork>();
        ArrayList<Network> allNets = new ArrayList<Network>();
        for (Network network : seen.keySet()) {
            allNets.add(network);
        }
        if (this.prefs.netOrder == Routing.SoGNetOrder.SOGNETORDERORIGINAL) {
            Collections.sort(allNets);
        }
        for (Network network : allNets) {
            Object ai2;
            RoutesOnNetwork ron = new RoutesOnNetwork(network.getName());
            allRoutes.add(ron);
            List arcsOnNet = (List)seen.get(network);
            for (ArcInst ai2 : arcsOnNet) {
                ron.unroutedArcs.add(ai2);
                if (ron.addUnorderedPort(ai2.getHeadPortInst())) {
                    this.warn("Arc " + this.describe(ai2) + " has an unconnectable end (on " + ai2.getHeadPortInst().getNodeInst().describe(false) + ")");
                }
                if (!ron.addUnorderedPort(ai2.getTailPortInst())) continue;
                this.warn("Arc " + this.describe(ai2) + " has an unconnectable end (on " + ai2.getTailPortInst().getNodeInst().describe(false) + ")");
            }
            if (this.sogp.isSteinerDone()) {
                for (Object ai2 : arcsOnNet) {
                    ron.getPairs().add(new SteinerTree.SteinerTreePortPair(((ArcInst)ai2).getHeadPortInst(), ((ArcInst)ai2).getTailPortInst()));
                }
                continue;
            }
            if (this.prefs.enableSpineRouting) {
                ron.setupSpineInfo(this.prefs.disableAdvancedSpineRouting);
                continue;
            }
            ArrayList<SteinerTree.SteinerTreePort> portList = new ArrayList<SteinerTree.SteinerTreePort>();
            ai2 = ron.unorderedPorts.iterator();
            while (ai2.hasNext()) {
                PortInst pi = (PortInst)ai2.next();
                portList.add(new PortInstShadow(pi));
            }
            SteinerTree st = new SteinerTree(portList, this.prefs.disableAdvancedSpineRouting);
            ron.pairs = st.getTreeBranches();
            if (ron.pairs != null) continue;
            String errMsg = "Arcs in " + network.getName() + " do not make valid connection: deleted";
            this.error(errMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            for (ArcInst delAi : ron.unroutedArcs) {
                lineList.add(delAi.getHeadLocation());
                lineList.add(delAi.getTailLocation());
            }
            this.errorLogger.logMessageWithLines(errMsg, null, lineList, this.cell, 0, true);
        }
        if (RoutingDebug.isShowingSpines()) {
            RoutingDebug.showSpineNetworks(allRoutes);
            return new RouteBatch[0];
        }
        if (this.buildRTrees(netList, arcsToRoute, linesInNonMahnattan)) {
            this.info("Non-Manhattan geometry found");
        }
        this.totalBlockages = this.getNumBlockages();
        this.blockagesFound = 0;
        this.setProgressNote("Extract connectivity (" + this.totalBlockages + " blockages)");
        this.setProgressValue(0, 100);
        for (RoutesOnNetwork routesOnNetwork : allRoutes) {
            double minWidth = this.getMinWidth(routesOnNetwork.unorderedPorts);
            for (int i2 = 0; i2 < routesOnNetwork.getPairs().size(); ++i2) {
                ArcProto bArc;
                SteinerTree.SteinerTreePort obj2;
                SteinerTree.SteinerTreePortPair stpp = routesOnNetwork.getPairs().get(i2);
                SteinerTree.SteinerTreePort obj1 = stpp.getPort1();
                if (obj1 instanceof PortInstShadow) {
                    obj1 = ((PortInstShadow)obj1).getPortInst();
                }
                if ((obj2 = stpp.getPort2()) instanceof PortInstShadow) {
                    obj2 = ((PortInstShadow)obj2).getPortInst();
                }
                PortInst aPi = (PortInst)obj1;
                PortInst bPi = (PortInst)obj2;
                ArcProto aArc = this.getMetalArcOnPort(aPi);
                if (aArc == null || (bArc = this.getMetalArcOnPort(bPi)) == null) continue;
                NeededRoute nr = new NeededRoute(routesOnNetwork.getName(), aPi, bPi, aArc, bArc, stpp.getSpineTaps(), minWidth);
                Iterator<ArcInst> it = routesOnNetwork.unroutedArcs.iterator();
                ArcInst sampleArc = it.next();
                Network net = netList.getNetwork(sampleArc, 0);
                nr.setNetID(net);
                nr.growNetwork();
                boolean aInvalid = nr.invalidPort(true, false, aPi);
                boolean bInvalid = nr.invalidPort(false, false, bPi);
                if (aInvalid || bInvalid) continue;
                routesOnNetwork.neededRoutes.add(nr);
            }
        }
        this.setProgressNote("Final Prepare for Routing...");
        this.setProgressValue(0, 100);
        TreeMap<Integer, TreeSet<RoutesOnNetwork>> uniqueNets = new TreeMap<Integer, TreeSet<RoutesOnNetwork>>();
        for (RoutesOnNetwork ron : allRoutes) {
            int netNumber = -1;
            for (NeededRoute nr : ron.neededRoutes) {
                int thisNetNumber = nr.netID.intValue();
                if (netNumber < 0) {
                    netNumber = thisNetNumber;
                }
                if (netNumber == thisNetNumber) continue;
                this.error("Error: network " + ron.getName() + " has network IDs " + netNumber + " and " + thisNetNumber);
            }
            Integer id = netNumber;
            TreeSet<RoutesOnNetwork> mergedRoutes = (TreeSet<RoutesOnNetwork>)uniqueNets.get(id);
            if (mergedRoutes == null) {
                mergedRoutes = new TreeSet<RoutesOnNetwork>();
                uniqueNets.put(id, mergedRoutes);
            }
            mergedRoutes.add(ron);
        }
        ArrayList<RouteBatch> arrayList = new ArrayList<RouteBatch>();
        for (Integer netID : uniqueNets.keySet()) {
            Set mergedRoutes = (Set)uniqueNets.get(netID);
            RouteBatch rb = null;
            for (RoutesOnNetwork ron : mergedRoutes) {
                if (rb == null) {
                    rb = new RouteBatch(ron.getName());
                    arrayList.add(rb);
                }
                for (ArcInst ai : ron.unroutedArcs) {
                    rb.unroutedArcs.add(ai);
                    if (rb.isPwrGnd) continue;
                    Network net = netList.getNetwork(ai, 0);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export e2 = it.next();
                        if (!e2.isGround() && !e2.isPower()) continue;
                        rb.isPwrGnd = true;
                        break;
                    }
                    PortProto headPort = ai.getHeadPortInst().getPortProto();
                    PortProto tailPort = ai.getTailPortInst().getPortProto();
                    if (!headPort.isGround() && !headPort.isPower() && !tailPort.isGround() && !tailPort.isPower()) continue;
                    rb.isPwrGnd = true;
                }
                for (NeededRoute nr : ron.neededRoutes) {
                    nr.setBatchInfo(rb, rb.routesInBatch.size());
                    double dX = nr.getAX() - nr.getBX();
                    double dY = nr.getAY() - nr.getBY();
                    rb.length += Math.sqrt(dX * dX + dY * dY);
                    rb.addRoute(nr);
                }
            }
        }
        for (RouteBatch rb : arrayList) {
            for (NeededRoute nr : rb.routesInBatch) {
                nr.addBlockagesAtPorts(nr.aPi);
                nr.addBlockagesAtPorts(nr.bPi);
                if (nr.spineTaps == null) continue;
                for (PortInst pi : nr.spineTaps) {
                    nr.addBlockagesAtPorts(pi);
                }
            }
        }
        if (this.prefs.netOrder == Routing.SoGNetOrder.SOGNETORDERORIGINAL) {
            Collections.sort(arrayList);
        }
        RouteBatch[] routeBatches = new RouteBatch[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            routeBatches[i3] = (RouteBatch)arrayList.get(i3);
        }
        for (RouteBatch rb : arrayList) {
            for (NeededRoute nr : rb.routesInBatch) {
                boolean paren = false;
                if (nr.batch.routesInBatch.size() > 1) {
                    nr.routeName = nr.routeName + " (" + (nr.routeInBatch + 1) + " of " + nr.batch.routesInBatch.size();
                    paren = true;
                }
                if (nr.spineTaps != null) {
                    nr.routeName = nr.routeName + (paren ? ", " : " (") + "spine";
                    paren = true;
                }
                if (!paren) continue;
                nr.routeName = nr.routeName + ")";
            }
        }
        return routeBatches;
    }

    private ArcProto getMetalArcOnPort(PortInst pi) {
        ArcProto[] arcs = this.getPossibleConnections(pi.getPortProto());
        for (int j2 = 0; j2 < arcs.length; ++j2) {
            if (arcs[j2].getTechnology() != this.tech || !arcs[j2].getFunction().isMetal()) continue;
            return arcs[j2];
        }
        String errorMsg = "Cannot connect port " + pi.getPortProto().getName() + " of node " + this.describe(pi.getNodeInst()) + " because it has no metal connection in " + this.tech.getTechName() + " technology";
        this.error(errorMsg);
        ArrayList<Poly> polyList = new ArrayList<Poly>();
        polyList.add(pi.getPoly());
        this.errorLogger.logMessage(errorMsg, polyList, this.cell, 0, true);
        return null;
    }

    Runnable[] findPath(NeededRoute nr) {
        nr.makeWavefronts();
        if (nr.checkEndSurround()) {
            return null;
        }
        Wavefront d1 = nr.dirAtoB;
        Wavefront d2 = nr.dirBtoA;
        if (DBMath.rectsIntersect(d1.fromRect, d1.toPE.getRect()) && d1.toZ == d1.fromZ) {
            double xVal = (Math.max(d1.fromRect.getMinX(), d1.toPE.getRect().getMinX()) + Math.min(d1.fromRect.getMaxX(), d1.toPE.getRect().getMaxX())) / 2.0;
            double yVal = (Math.max(d1.fromRect.getMinY(), d1.toPE.getRect().getMinY()) + Math.min(d1.fromRect.getMaxY(), d1.toPE.getRect().getMaxY())) / 2.0;
            SearchVertex sv = new SearchVertex(xVal, yVal, d1.toZ, d1.toC, 0, null, null, 0, d1, 0, null);
            if (nr.debuggingRouteFromA != null) {
                RoutingDebug.ensureDebuggingShadow(sv, false);
            }
            nr.completeRoute(sv);
            return null;
        }
        if (this.parallelDij) {
            DijkstraParallel aToB = new DijkstraParallel(d1, d2);
            DijkstraParallel bToA = new DijkstraParallel(d2, d1);
            return new Runnable[]{aToB, bToA};
        }
        return new Runnable[]{new DijkstraTwoWay(nr, d1, d2)};
    }

    private SearchVertex tryToFindPath(Wavefront a2, Wavefront b2) {
        ArrayList<SearchVertex> bestPath = null;
        SearchVertex bestSV = null;
        double bestDistance = Double.MAX_VALUE;
        for (int z = 0; z < a2.searchVertexPlanes.length; ++z) {
            Map<Integer, Map<Integer, SearchVertex>> plane = a2.searchVertexPlanes[z];
            if (plane == null) continue;
            for (Integer y : plane.keySet()) {
                Map<Integer, SearchVertex> row = plane.get(y);
                if (row == null) continue;
                double yCoord = (double)y.intValue() / 400.0;
                for (Integer x : row.keySet()) {
                    int i2;
                    String error;
                    int highMetal;
                    SearchVertex lastSv;
                    double dY;
                    double dX;
                    SearchVertex prev;
                    SearchVertex foundInA = row.get(x);
                    double xCoord = (double)x.intValue() / 400.0;
                    SearchVertex foundInB = b2.getVertex(xCoord, yCoord, z);
                    if (foundInB == null) continue;
                    double total = 0.0;
                    SearchVertex sv = foundInA;
                    while (sv != null && (prev = sv.last) != null) {
                        dX = sv.getX() - prev.getX();
                        dY = sv.getY() - prev.getY();
                        total += Math.sqrt(dX * dX + dY * dY);
                        if (sv.getZ() != prev.getZ()) {
                            total += 1.0;
                        }
                        sv = sv.last;
                    }
                    sv = foundInB;
                    while (sv != null && (prev = sv.last) != null) {
                        dX = sv.getX() - prev.getX();
                        dY = sv.getY() - prev.getY();
                        total += Math.sqrt(dX * dX + dY * dY);
                        if (sv.getZ() != prev.getZ()) {
                            total += 1.0;
                        }
                        sv = sv.last;
                    }
                    boolean better = DBMath.isLessThan(total, bestDistance);
                    if (!better) continue;
                    boolean fail = false;
                    SearchVertex sv2 = foundInB;
                    while (sv2 != null) {
                        if (sv2.getSize() != null && (lastSv = sv2.last) != null) {
                            int lowMetal = Math.min(sv2.getZ(), lastSv.getZ());
                            highMetal = Math.max(sv2.getZ(), lastSv.getZ());
                            for (Poly conPoly : sv2.getCutPolys()) {
                                error = a2.validCut(foundInA, lowMetal, highMetal, conPoly.getBounds2D(), conPoly.getLayer());
                                if (error == null) continue;
                                fail = true;
                                break;
                            }
                            if (fail) break;
                        }
                        sv2 = sv2.last;
                    }
                    if (fail) continue;
                    sv2 = foundInA;
                    while (sv2 != null) {
                        if (sv2.getSize() != null && (lastSv = sv2.last) != null) {
                            int lowMetal = Math.min(sv2.getZ(), lastSv.getZ());
                            highMetal = Math.max(sv2.getZ(), lastSv.getZ());
                            for (Poly conPoly : sv2.getCutPolys()) {
                                error = b2.validCut(foundInB, lowMetal, highMetal, conPoly.getBounds2D(), conPoly.getLayer());
                                if (error == null) continue;
                                fail = true;
                                break;
                            }
                            if (fail) break;
                        }
                        sv2 = sv2.last;
                    }
                    if (fail) continue;
                    SearchVertex svCurrent = null;
                    ArrayList<SearchVertex> halfPath = new ArrayList<SearchVertex>();
                    SearchVertex svBuild = foundInB;
                    while (svBuild != null) {
                        SearchVertex svAdd = new SearchVertex(svBuild);
                        if (svCurrent == null && halfPath.size() > 0 && ((SearchVertex)halfPath.get(halfPath.size() - 1)).getZ() != svAdd.getZ()) {
                            svCurrent = (SearchVertex)halfPath.get(halfPath.size() - 1);
                        }
                        halfPath.add(svAdd);
                        svBuild = svBuild.last;
                    }
                    ArrayList<SearchVertex> path = new ArrayList<SearchVertex>();
                    Point2D lastSize = null;
                    Poly[] lastCuts = null;
                    int lastCutNumber = 0;
                    for (i2 = 0; i2 < halfPath.size(); ++i2) {
                        SearchVertex thisOne = (SearchVertex)halfPath.get(i2);
                        Point2D thisSize = thisOne.size;
                        Poly[] thisCuts = thisOne.getCutPolys();
                        int thisCutNumber = thisOne.zv & 0xFF;
                        thisOne.size = lastSize;
                        thisOne.cutPolys = lastCuts;
                        thisOne.zv = thisOne.zv & 0xFFFFFF00 | lastCutNumber & 0xFF;
                        lastSize = thisSize;
                        lastCuts = thisCuts;
                        lastCutNumber = thisCutNumber;
                    }
                    for (i2 = halfPath.size() - 1; i2 >= 0; --i2) {
                        path.add((SearchVertex)halfPath.get(i2));
                    }
                    svBuild = foundInA;
                    while (svBuild != null) {
                        path.add(new SearchVertex(svBuild));
                        svBuild = svBuild.last;
                    }
                    for (i2 = 0; i2 < path.size() - 1; ++i2) {
                        SearchVertex sv22;
                        SearchVertex sv1 = (SearchVertex)path.get(i2);
                        sv1.last = sv22 = (SearchVertex)path.get(i2 + 1);
                    }
                    ((SearchVertex)path.get((int)(path.size() - 1))).last = null;
                    boolean finalDest = false;
                    if (svCurrent == null) {
                        svCurrent = (SearchVertex)path.get(0);
                        finalDest = true;
                    }
                    StringBuffer message = new StringBuffer();
                    MutableBoolean err = new MutableBoolean(false);
                    SearchVertexAddon sva = a2.determineMinimumArea(svCurrent, svCurrent.getX(), svCurrent.getY(), svCurrent.getC(), svCurrent.getZ(), svCurrent.getC(), svCurrent.getZ(), null, 0.0, 0.0, err, message, finalDest);
                    if (sva != null) {
                        SearchVertex svGoodInsertion = null;
                        SearchVertex svAnyInsertion = null;
                        SearchVertex sv3 = svCurrent;
                        while (sv3 != null) {
                            if (sv3.addOn == null) {
                                if (svAnyInsertion == null) {
                                    svAnyInsertion = sv3;
                                }
                                if (sv3.getZ() != svCurrent.getZ()) {
                                    svGoodInsertion = sv3;
                                    break;
                                }
                            }
                            sv3 = sv3.last;
                        }
                        if (svGoodInsertion != null) {
                            svGoodInsertion.addOn = sva;
                        } else if (svAnyInsertion != null) {
                            svAnyInsertion.addOn = sva;
                        } else {
                            System.out.println("!!!!!!!!!!! ERROR: Failed to insert minimum area geometry " + TextUtils.formatDistance(sva.addedGeometry[0].getMinX()) + "<=X<=" + TextUtils.formatDistance(sva.addedGeometry[0].getMaxX()) + " AND " + TextUtils.formatDistance(sva.addedGeometry[0].getMinY()) + "<=Y<=" + TextUtils.formatDistance(sva.addedGeometry[0].getMaxY()) + "," + sva.pureLayerNode.describe(false));
                            continue;
                        }
                    }
                    if (err.booleanValue()) continue;
                    bestDistance = total;
                    bestPath = path;
                    bestSV = foundInA;
                }
            }
        }
        if (bestPath != null) {
            System.out.println("Network " + a2.nr.routeName + " failed in both directions, but found a common point at (" + TextUtils.formatDistance(bestSV.xv) + "," + TextUtils.formatDistance(bestSV.yv) + ")");
            SearchVertex result = (SearchVertex)bestPath.get(0);
            result.wf = a2;
            return result;
        }
        return null;
    }

    private double getMinWidth(List<PortInst> orderedPorts) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > this.prefs.maxArcWidth) {
            minWidth = this.prefs.maxArcWidth;
        }
        return minWidth;
    }

    private ArcProto[] getPossibleConnections(PortProto pp) {
        Export e2;
        Variable var;
        ArcProto[] poss = pp.getBasePort().getConnections();
        if (pp instanceof Export && (var = (e2 = (Export)pp).getVar(Export.EXPORT_PREFERRED_ARCS)) != null) {
            String[] arcNames = (String[])var.getObject();
            ArcProto[] arcs = new ArcProto[arcNames.length];
            boolean allFound = true;
            for (int j2 = 0; j2 < arcNames.length; ++j2) {
                arcs[j2] = ArcProto.findArcProto(arcNames[j2]);
                if (arcs[j2] != null) continue;
                allFound = false;
            }
            if (allFound) {
                return arcs;
            }
        }
        return poss;
    }

    private static boolean inDestGrid(FixpRectangle toRectGridded, double x, double y) {
        if (x < toRectGridded.getMinX()) {
            return false;
        }
        if (x > toRectGridded.getMaxX()) {
            return false;
        }
        if (y < toRectGridded.getMinY()) {
            return false;
        }
        return !(y > toRectGridded.getMaxY());
    }

    private double cutDistance(Rectangle2D cut1, Rectangle2D cut2) {
        double cut1CornerY;
        double cut2CornerY;
        double cut1CornerX;
        double cut2CornerX;
        if (cut1.getMinX() <= cut2.getMaxX() && cut1.getMaxX() >= cut2.getMinX()) {
            if (cut1.getMinY() <= cut2.getMaxY() && cut1.getMaxY() >= cut2.getMinY()) {
                return 0.0;
            }
            if ((cut1.getMinY() + cut1.getMaxY()) / 2.0 > (cut2.getMinY() + cut2.getMaxY()) / 2.0) {
                return cut1.getMinY() - cut2.getMaxY();
            }
            return cut2.getMinY() - cut1.getMaxY();
        }
        if (cut1.getMinY() <= cut2.getMaxY() && cut1.getMaxY() >= cut2.getMinY()) {
            if ((cut1.getMinX() + cut1.getMaxX()) / 2.0 > (cut2.getMinX() + cut2.getMaxX()) / 2.0) {
                return cut1.getMinX() - cut2.getMaxX();
            }
            return cut2.getMinX() - cut1.getMaxX();
        }
        if ((cut2.getMinX() + cut2.getMaxX()) / 2.0 < (cut1.getMinX() + cut1.getMaxX()) / 2.0) {
            cut2CornerX = cut2.getMaxX();
            cut1CornerX = cut1.getMinX();
        } else {
            cut2CornerX = cut2.getMinX();
            cut1CornerX = cut1.getMaxX();
        }
        if ((cut2.getMinY() + cut2.getMaxY()) / 2.0 < (cut1.getMinY() + cut1.getMaxY()) / 2.0) {
            cut2CornerY = cut2.getMaxY();
            cut1CornerY = cut1.getMinY();
        } else {
            cut2CornerY = cut2.getMinY();
            cut1CornerY = cut1.getMaxY();
        }
        double dX = cut2CornerX - cut1CornerX;
        double dY = cut2CornerY - cut1CornerY;
        return Math.sqrt(dX * dX + dY * dY);
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c2 = it.next();
            ArcInst ai = c2.getArc();
            ArcProto ap = ai.getProto();
            if (this.sogp.isPrevented(ap) || !ap.getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    void getOptimizedList(SearchVertex initialVertex, List<SearchVertex> realVertices) {
        realVertices.clear();
        SearchVertex vertex = initialVertex;
        if (vertex != null) {
            SearchVertex lastVertex = vertex;
            vertex = vertex.last;
            realVertices.add(lastVertex);
            while (vertex != null) {
                if (lastVertex.getZ() != vertex.getZ()) {
                    lastVertex = vertex;
                    vertex = vertex.last;
                    realVertices.add(lastVertex);
                    continue;
                }
                double dx = vertex.getX() - lastVertex.getX();
                double dy = vertex.getY() - lastVertex.getY();
                lastVertex = vertex;
                vertex = vertex.last;
                while (!(vertex == null || lastVertex.getZ() != vertex.getZ() || dx == 0.0 && vertex.getX() - lastVertex.getX() != 0.0 || dy == 0.0 && vertex.getY() - lastVertex.getY() != 0.0)) {
                    lastVertex = vertex;
                    vertex = vertex.last;
                }
                realVertices.add(lastVertex);
            }
        }
    }

    private int getNumBlockages() {
        int total = 0;
        for (int i2 = 0; i2 < numMetalLayers; ++i2) {
            BlockageTree bTree = this.rTrees.getMetalTree(this.primaryMetalLayer[i2]);
            if (bTree.root == null) continue;
            total += this.getNumLeafs(bTree.root);
        }
        return total;
    }

    private int getNumLeafs(RTNode<SOGBound> branch) {
        int total = 0;
        for (int i2 = 0; i2 < branch.getTotal(); ++i2) {
            if (branch.getFlag()) {
                ++total;
                continue;
            }
            RTNode<SOGBound> subrt = branch.getChildTree(i2);
            total += this.getNumLeafs(subrt);
        }
        return total;
    }

    private boolean buildRTrees(Netlist netList, List<ArcInst> arcsToRoute, List<EPoint> linesInNonMahnattan) {
        this.rTrees = new BlockageTrees(numMetalLayers);
        MutableInteger nextNetNumber = new MutableInteger(1);
        HashMap<Network, Integer> netNumbers = new HashMap<Network, Integer>();
        for (ArcInst ai : arcsToRoute) {
            Network net = netList.getNetwork(ai, 0);
            Integer netNumber = (Integer)netNumbers.get(net);
            if (netNumber != null) continue;
            netNumber = nextNetNumber.intValue() << 4;
            netNumbers.put(net, netNumber);
            if (RoutingDebug.isActive()) {
                RoutingDebug.setNetName(netNumber, net.getName());
            }
            nextNetNumber.increment();
            this.netIDs.put(net, netNumber);
        }
        this.setProgressNote("Find blockages...");
        this.setProgressValue(0, 100);
        this.removeGeometry = new HashMap<Layer, List<Rectangle2D>>();
        boolean retval = this.addArea(this.cell, this.cellBounds, Orientation.IDENT.pureRotate(), true, nextNetNumber, linesInNonMahnattan);
        List<SeaOfGates.SeaOfGatesExtraBlockage> list = this.sogp.getBlockages();
        for (SeaOfGates.SeaOfGatesExtraBlockage sogeb : list) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(sogeb.getLX(), sogeb.getLY(), sogeb.getHX() - sogeb.getLX(), sogeb.getHY() - sogeb.getLY());
            int metNo = sogeb.getLayer().getFunction().getLevel() - 1;
            Layer layer = this.primaryMetalLayer[metNo];
            Integer nn = nextNetNumber.intValue() << 4 | 8;
            nextNetNumber.increment();
            MutableInteger netID = new MutableInteger(nn);
            this.addRectangle(bounds, layer, netID, false, false);
        }
        for (Layer metLayer : this.removeGeometry.keySet()) {
            List<Rectangle2D> removeRects = this.removeGeometry.get(metLayer);
            for (Rectangle2D rect : removeRects) {
                int metNum = metLayer.getFunction().getLevel() - 1;
                int metCol = metLayer.getFunction().getMaskColor();
                Layer primaryMetLayer = this.primaryMetalLayer[metNum];
                BlockageTree bTree = this.rTrees.getMetalTree(primaryMetLayer);
                ArrayList<SOGBound> thingsThatGetRemoved = new ArrayList<SOGBound>();
                Iterator<SOGBound> sea = bTree.search(rect);
                while (sea.hasNext()) {
                    ERectangle bound;
                    SOGBound sBound = sea.next();
                    if (sBound.getMaskColor() != metCol || ((RectangularShape)(bound = sBound.getBounds())).getMaxX() <= rect.getMinX() || ((RectangularShape)bound).getMinX() >= rect.getMaxX() || ((RectangularShape)bound).getMaxY() <= rect.getMinY() || ((RectangularShape)bound).getMinY() >= rect.getMaxY()) continue;
                    thingsThatGetRemoved.add(sBound);
                }
                RTNode<SOGBound> rootFixp = bTree.getRoot();
                for (SOGBound s : thingsThatGetRemoved) {
                    RTNode<SOGBound> newRootFixp = RTNode.unLinkGeom(null, rootFixp, s);
                    if (newRootFixp == rootFixp) continue;
                    rootFixp = newRootFixp;
                    bTree.setRoot(rootFixp);
                }
                for (SOGBound s : thingsThatGetRemoved) {
                    PolyMerge merge = new PolyMerge();
                    merge.addRectangle(metLayer, s.getBounds());
                    merge.subtract(metLayer, new Poly(rect));
                    List<PolyBase> remaining = merge.getMergedPoints(metLayer, true);
                    for (PolyBase pb : remaining) {
                        ERectangle reducedBound = ERectangle.fromLambda(pb.getBounds2D());
                        SOGBound sogb = new SOGBound(reducedBound, s.getNetID(), s.getMaskColor());
                        RTNode<SOGBound> newRootFixp = RTNode.linkGeom(null, rootFixp, sogb);
                        if (newRootFixp == rootFixp) continue;
                        rootFixp = newRootFixp;
                        bTree.setRoot(rootFixp);
                    }
                }
            }
        }
        return retval;
    }

    private boolean addArea(Cell cell, Rectangle2D bounds, FixpTransform transToTop, boolean topLevel, MutableInteger nextNetNumber, List<EPoint> linesInNonMahnattan) {
        boolean hasNonmanhattan = false;
        int numCells = 0;
        Iterator<Geometric> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance()) {
                    ++numCells;
                    continue;
                }
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                if (pNp.getFunction() == PrimitiveNode.Function.PIN) continue;
                FixpTransform nodeTrans = ni.rotateOut(transToTop);
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                MutableInteger netNumber = null;
                List<Integer> exclusionLayers = null;
                if (pNp == Generic.tech().routeNode) {
                    Integer nn = nextNetNumber.intValue() << 4;
                    nextNetNumber.increment();
                    netNumber = new MutableInteger(nn);
                    exclusionLayers = this.parseExclusionLayers(ni);
                }
                for (int i2 = 0; i2 < nodeInstPolyList.length; ++i2) {
                    Poly poly = nodeInstPolyList[i2];
                    if (exclusionLayers != null) {
                        for (Integer lay : exclusionLayers) {
                            poly.setLayer(this.primaryMetalLayer[lay]);
                            if (!this.addLayer(poly, nodeTrans, netNumber, false, linesInNonMahnattan, true)) continue;
                            hasNonmanhattan = true;
                        }
                        continue;
                    }
                    if (!this.addLayer(poly, nodeTrans, netNumber, false, linesInNonMahnattan, true)) continue;
                    hasNonmanhattan = true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            if (ai.getProto() == Generic.tech().unrouted_arc) continue;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i3 = 0; i3 < polys.length; ++i3) {
                Poly poly = polys[i3];
                if (!this.addLayer(poly, transToTop, null, false, linesInNonMahnattan, true)) continue;
                hasNonmanhattan = true;
            }
        }
        int cellCount = 0;
        Iterator<Geometric> it2 = cell.searchIterator(bounds);
        while (it2.hasNext()) {
            NodeInst ni;
            Geometric geom = it2.next();
            if (!(geom instanceof NodeInst) || !(ni = (NodeInst)geom).isCellInstance()) continue;
            if (topLevel) {
                this.setProgressValue(++cellCount, numCells + 1);
            }
            Rectangle2D.Double subBounds = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            DBMath.transformRect(subBounds, ni.transformIn());
            FixpTransform transBack = ni.transformOut(transToTop);
            this.addArea((Cell)ni.getProto(), subBounds, transBack, false, nextNetNumber, linesInNonMahnattan);
        }
        return hasNonmanhattan;
    }

    private List<Integer> parseExclusionLayers(NodeInst ni) {
        ArrayList<Integer> exclusionLayers = new ArrayList<Integer>();
        String layers = "";
        Variable var = ni.getVar(Generic.ROUTING_EXCLUSION);
        if (var != null) {
            layers = var.getPureValue(-1);
        }
        layers.replaceAll(" ", "");
        if (layers.length() == 0) {
            return exclusionLayers;
        }
        if (layers.equalsIgnoreCase("all")) {
            for (int i2 = 0; i2 < this.getNumMetals(); ++i2) {
                exclusionLayers.add(i2);
            }
            return exclusionLayers;
        }
        int pt = 0;
        while (pt < layers.length()) {
            int layNum = TextUtils.atoi(layers.substring(pt));
            while (pt < layers.length() && Character.isDigit(layers.charAt(pt))) {
                ++pt;
            }
            if (pt >= layers.length() || layers.charAt(pt) == ',') {
                exclusionLayers.add(layNum - 1);
                if (pt >= layers.length()) continue;
                ++pt;
                continue;
            }
            if (layers.charAt(pt) != '-' || pt >= layers.length() - 1) {
                System.out.println("ERROR: Routing exclusion node " + ni.describe(false) + " has invalid exclusion description: " + layers);
                break;
            }
            int layEnd = TextUtils.atoi(layers.substring(++pt));
            while (pt < layers.length() && Character.isDigit(layers.charAt(pt))) {
                ++pt;
            }
            for (int i3 = layNum; i3 <= layEnd; ++i3) {
                exclusionLayers.add(i3 - 1);
            }
            if (pt >= layers.length()) continue;
            if (layers.charAt(pt) != ',') {
                System.out.println("ERROR: Routing exclusion node " + ni.describe(false) + " has invalid exclusion description: " + layers);
                break;
            }
            ++pt;
        }
        return exclusionLayers;
    }

    private boolean addLayer(PolyBase poly, FixpTransform trans, MutableInteger netID, boolean lockTree, List<EPoint> linesInNonMahnattan, boolean merge) {
        boolean isNonmanhattan = false;
        Layer layer = poly.getLayer();
        Layer.Function fun = layer.getFunction();
        Layer removeAp = this.removeLayers.get(layer);
        if (removeAp != null) {
            List<Rectangle2D> geomsToRemove = this.removeGeometry.get(removeAp);
            if (geomsToRemove == null) {
                geomsToRemove = new ArrayList<Rectangle2D>();
                this.removeGeometry.put(removeAp, geomsToRemove);
            }
            poly.transform(trans);
            FixpRectangle bounds = poly.getBox();
            if (bounds == null) {
                return true;
            }
            geomsToRemove.add(bounds);
            return false;
        }
        if (fun.isMetal()) {
            if (poly.getStyle() != Poly.Type.FILLED) {
                return false;
            }
            poly.transform(trans);
            FixpRectangle bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID, lockTree);
                PolyBase.Point[] points = poly.getPoints();
                for (int i2 = 1; i2 < points.length; ++i2) {
                    if (points[i2 - 1].getX() == points[i2].getX() || points[i2 - 1].getY() == points[i2].getY()) continue;
                    isNonmanhattan = true;
                    linesInNonMahnattan.add(EPoint.fromLambda(points[i2 - 1].getX(), points[i2 - 1].getY()));
                    linesInNonMahnattan.add(EPoint.fromLambda(points[i2].getX(), points[i2].getY()));
                }
            } else {
                this.addRectangle(bounds, layer, netID, lockTree, merge);
            }
        } else if (fun.isContact()) {
            FixpRectangle bounds = poly.getBounds2D();
            DBMath.transformRect((Rectangle2D)bounds, trans);
            this.addVia(ERectangle.fromLambda(bounds), layer, netID, lockTree);
        }
        return isNonmanhattan;
    }

    public static String describeMetal(int metal, int color) {
        String ret = "M" + (metal + 1);
        if (color > 0) {
            ret = ret + (char)(97 + color - 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOGBound addRectangle(Rectangle2D bounds, Layer layer, MutableInteger netID, boolean lockTree, boolean merge) {
        RTNode<SOGBound> rootFixp;
        SOGBound sogb = null;
        BlockageTree bTree = this.rTrees.getMetalTree(layer);
        if (merge) {
            ArrayList<Object> removeThese = null;
            Iterator<SOGBound> sea = bTree.search(bounds);
            while (sea.hasNext()) {
                SOGBound sBound = sea.next();
                if (sBound instanceof SOGPoly) continue;
                ERectangle eRectangle = sBound.getBounds();
                if (eRectangle.getMinX() <= bounds.getMinX() && eRectangle.getMaxX() >= bounds.getMaxX() && eRectangle.getMinY() <= bounds.getMinY() && eRectangle.getMaxY() >= bounds.getMaxY()) {
                    return null;
                }
                if (!(bounds.getMinX() <= eRectangle.getMinX()) || !(bounds.getMaxX() >= eRectangle.getMaxX()) || !(bounds.getMinY() <= eRectangle.getMinY()) || !(bounds.getMaxY() >= eRectangle.getMaxY())) continue;
                if (removeThese == null) {
                    removeThese = new ArrayList<Object>();
                }
                removeThese.add(sBound);
            }
            if (removeThese != null) {
                if (lockTree) {
                    bTree.lock();
                }
                try {
                    rootFixp = bTree.getRoot();
                    for (SOGBound sOGBound : removeThese) {
                        RTNode<SOGBound> newRootFixp = RTNode.unLinkGeom(null, rootFixp, sOGBound);
                        if (newRootFixp == rootFixp) continue;
                        rootFixp = newRootFixp;
                        bTree.setRoot(rootFixp);
                    }
                }
                finally {
                    if (lockTree) {
                        bTree.unlock();
                    }
                }
            }
        }
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGBound> newRootFixp;
            int maskLayer = layer.getFunction().getMaskColor();
            sogb = new SOGBound(ERectangle.fromLambda(bounds), netID, maskLayer);
            rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
        return sogb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPolygon(PolyBase poly, Layer layer, MutableInteger netID, boolean lockTree) {
        BlockageTree bTree = this.rTrees.getMetalTree(layer);
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGBound> newRootFixp;
            int maskLayer = layer.getFunction().getMaskColor();
            SOGPoly sogb = new SOGPoly(ERectangle.fromLambda(poly.getBounds2D()), netID, poly, maskLayer);
            RTNode<SOGBound> rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVia(ERectangle rect, Layer layer, MutableInteger netID, boolean lockTree) {
        BlockageTree bTree = this.rTrees.getViaTree(layer);
        int color = layer.getFunction().getMaskColor();
        Iterator<SOGBound> it = bTree.search(rect);
        while (it.hasNext()) {
            SOGBound sogb = it.next();
            if (sogb.getBounds().getCenterX() != rect.getCenterX() || sogb.getBounds().getCenterY() != rect.getCenterY()) continue;
            if (sogb.getMaskColor() == 0 && color != 0) {
                sogb.setMaskColor(color);
            }
            return;
        }
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGBound> newRootFixp;
            SOGVia sogb = new SOGVia(rect, netID);
            sogb.setMaskColor(color);
            RTNode<SOGBound> rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
    }

    public GlobalRouter doGlobalRouting(Cell cell, RouteBatch[] routeBatches, RouteBatch[] fakeBatches, double wirePitch) {
        GlobalRouter gr = new GlobalRouter(cell, routeBatches, fakeBatches, wirePitch);
        gr.solve();
        return gr;
    }

    static {
        tsmcDesignRulesChecked = false;
    }

    public static interface Handler {
        public EditingPreferences getEditingPreferences();

        public boolean checkAbort();

        public void trace(String var1);

        public void debug(String var1);

        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);

        public void termLogging(ErrorLogger var1);

        public void startProgressDialog(String var1);

        public void stopProgressDialog();

        public void setProgressNote(String var1);

        public void setProgressValue(long var1, long var3);

        public void instantiate(RouteResolution var1);

        public String getRoutingCellName();

        public void flush(boolean var1);
    }

    private static class SortArcByDistance
    implements Comparator<String> {
        Cell theCell;
        Routing.SoGNetOrder sortingType;

        SortArcByDistance(Cell cell, Routing.SoGNetOrder type) {
            this.theCell = cell;
            this.sortingType = type;
        }

        @Override
        public int compare(String s1, String s2) {
            ArcInst a1 = this.theCell.findArc(s1);
            ArcInst a2 = this.theCell.findArc(s2);
            double d1 = a1.getLambdaLength();
            double d2 = a2.getLambdaLength();
            switch (this.sortingType) {
                case SOGNETORDERPERCENTAGE: {
                    if (d1 > d2) {
                        return 1;
                    }
                    if (!(d1 < d2)) break;
                    return -1;
                }
                case SOGNETORDERDESCENDING: {
                    if (d1 < d2) {
                        return 1;
                    }
                    if (!(d1 > d2)) break;
                    return -1;
                }
            }
            return 0;
        }
    }

    private static class BusBitsNumberClass {
        String netName;
        List<String> bits;

        BusBitsNumberClass(String name) {
            this.netName = name;
            this.bits = new ArrayList<String>();
        }

        List<String> getNets() {
            ArrayList<String> l2 = new ArrayList<String>();
            for (String bit : this.bits) {
                l2.add(this.netName + bit);
            }
            return l2;
        }
    }

    private static class SortByBusBitsNumberClass
    implements Comparator<BusBitsNumberClass> {
        private SortByBusBitsNumberClass() {
        }

        @Override
        public int compare(BusBitsNumberClass s1, BusBitsNumberClass s2) {
            int l2;
            int l1 = s1.bits.size();
            if (l1 > (l2 = s2.bits.size())) {
                return -1;
            }
            if (l1 < l2) {
                return 1;
            }
            return s1.netName.compareToIgnoreCase(s2.netName);
        }
    }

    class RouteBatch
    implements Comparable<RouteBatch> {
        Set<ArcInst> unroutedArcs;
        Set<NodeInst> unroutedNodes;
        List<NeededRoute> routesInBatch;
        boolean isPwrGnd;
        double length;
        String netName;
        private RouteResolution resolution;
        private final ReentrantLock completedRouteLock = new ReentrantLock();

        public RouteBatch(String nn) {
            this.unroutedArcs = new HashSet<ArcInst>();
            this.unroutedNodes = new HashSet<NodeInst>();
            this.routesInBatch = new ArrayList<NeededRoute>();
            CellId destCellId = SeaOfGatesEngine.this.cell.getId();
            this.resolution = new RouteResolution(destCellId);
            this.isPwrGnd = false;
            this.length = 0.0;
            this.netName = nn;
        }

        public void addRoute(NeededRoute nr) {
            this.routesInBatch.add(nr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completedRoute(NeededRoute nr, Wavefront winningWF, SearchVertex result) {
            this.completedRouteLock.lock();
            nr.winningWF = winningWF;
            try {
                if (winningWF != null && winningWF.vertices != null) {
                    winningWF.createRoute();
                }
                for (ArcInst aiKill : this.unroutedArcs) {
                    this.resolution.killArc(aiKill);
                }
                for (NodeInst niKill : this.unroutedNodes) {
                    this.resolution.killNode(niKill);
                }
                this.unroutedArcs.clear();
                this.unroutedNodes.clear();
                SeaOfGatesEngine.this.handler.instantiate(this.resolution);
                if (nr.spineTaps != null) {
                    SeaOfGatesEngine.this.handler.flush(true);
                    int tapNumber = 1;
                    for (SearchVertex sv : nr.spineTapMap.keySet()) {
                        int thisTapNumber = tapNumber++;
                        PortInst aPi = nr.spineTapMap.get(sv);
                        ArcProto aArc = SeaOfGatesEngine.this.getMetalArcOnPort(aPi);
                        ImmutableNodeInst ini = nr.spineTapNIMap.get(aPi);
                        if (ini == null) continue;
                        NodeInst ni = SeaOfGatesEngine.this.cell.getNodeById(ini.nodeId);
                        if (SeaOfGatesEngine.this.handler.getRoutingCellName() != null) {
                            NodeInst otherNi;
                            String realCellName = SeaOfGatesEngine.this.handler.getRoutingCellName() + "{lay}";
                            Cell realCell = SeaOfGatesEngine.this.cell.getLibrary().findNodeProto(realCellName);
                            if (realCell != null && (otherNi = realCell.getNodeById(ini.nodeId)) != null) {
                                ni = otherNi;
                            }
                        }
                        if (ni == null) continue;
                        PortInst bPi = ni.getOnlyPortInst();
                        ArcProto bArc = SeaOfGatesEngine.this.getMetalArcOnPort(bPi);
                        if (aArc == null || bArc == null) continue;
                        Object routeName = nr.routeName;
                        if (((String)routeName).endsWith("spine)")) {
                            routeName = ((String)routeName).substring(0, ((String)routeName).length() - 1) + " tap " + thisTapNumber + ")";
                        }
                        NeededRoute nrTap = new NeededRoute((String)routeName, aPi, bPi, aArc, bArc, null, nr.minWidth);
                        nrTap.setNetID(nr.netID);
                        boolean aInvalid = nrTap.invalidPort(true, true, aPi);
                        boolean bInvalid = nrTap.invalidPort(false, true, bPi);
                        if (aInvalid || bInvalid) continue;
                        nrTap.growNetwork();
                        SeaOfGatesEngine.this.tapRoutes.add(nrTap);
                        nrTap.setBatchInfo(nr.batch, thisTapNumber);
                    }
                }
            }
            finally {
                this.completedRouteLock.unlock();
            }
        }

        @Override
        public int compareTo(RouteBatch other) {
            if (this.isPwrGnd != other.isPwrGnd) {
                if (this.isPwrGnd) {
                    return -1;
                }
                return 1;
            }
            if (this.length < other.length) {
                return -1;
            }
            if (this.length > other.length) {
                return 1;
            }
            return 0;
        }
    }

    public class NeededRoute {
        private String routeName;
        private RouteBatch batch;
        private int routeInBatch;
        private final Rectangle2D routeBounds;
        private MutableInteger netID;
        private final double minWidth;
        private Rectangle2D jumpBound;
        private int complexityLimit;
        private int maxDistance;
        private PossibleEndpoints aEndpoints;
        private PossibleEndpoints bEndpoints;
        private double aTaperWid;
        private double bTaperWid;
        private double aTaperLen;
        private double bTaperLen;
        private final PortInst aPi;
        private final PortInst bPi;
        private int aZ;
        private int bZ;
        private int aC;
        private int bC;
        private boolean alreadyRouted;
        private Boolean debuggingRouteFromA;
        private PossibleEndpoint replaceA;
        private PossibleEndpoint replaceB;
        private int replaceAZ;
        private int replaceBZ;
        private int replaceAC;
        private int replaceBC;
        private final List<PortInst> spineTaps;
        private final Map<SearchVertex, PortInst> spineTapMap;
        private final Map<PortInst, ImmutableNodeInst> spineTapNIMap;
        private final Poly aPoly;
        private final Poly bPoly;
        private Rectangle2D[] buckets;
        private Map<Layer, List<SOGBound>> endBlockages;
        private volatile boolean routedSuccess;
        private String errorMessage;
        private boolean reroute;
        private SeaOfGates.SeaOfGatesTrack[][] gridLocationsX;
        private SeaOfGates.SeaOfGatesTrack[][] gridLocationsY;
        private Map<SOGBound, Integer> extractList;
        private boolean[] overridePreventArcs;
        private boolean[] forceGridArcs;
        private double[] overrideMetalWidth;
        private double[] overrideMetalSpacingX;
        private double[] overrideMetalSpacingY;
        private double[][] overrideMetalSpacings;
        private Wavefront winningWF = null;
        private Wavefront dirAtoB;
        private Wavefront dirBtoA;
        private ErrorLogger.MessageLog loggedMessage;

        public NeededRoute(String routeName, PortInst aPi, PortInst bPi, ArcProto aArc, ArcProto bArc, List<PortInst> spineTaps, double minWidth) {
            double aY;
            double bY;
            double aX;
            double bX;
            int z;
            this.routeName = routeName;
            this.spineTaps = spineTaps;
            this.complexityLimit = SeaOfGatesEngine.this.prefs.complexityLimit;
            this.maxDistance = SeaOfGatesEngine.this.prefs.maxDistance;
            this.alreadyRouted = false;
            this.replaceB = null;
            this.replaceA = null;
            this.replaceBZ = 0;
            this.replaceAZ = 0;
            this.replaceBC = 0;
            this.replaceAC = 0;
            if (spineTaps == null) {
                this.spineTapMap = null;
                this.spineTapNIMap = null;
            } else {
                this.spineTapMap = new HashMap<SearchVertex, PortInst>();
                this.spineTapNIMap = new HashMap<PortInst, ImmutableNodeInst>();
            }
            this.overrideMetalWidth = null;
            this.overrideMetalSpacingY = null;
            this.overrideMetalSpacingX = null;
            this.overrideMetalSpacings = new double[numMetalLayers][];
            block0: for (z = 0; z < numMetalLayers; ++z) {
                for (int c2 = 0; c2 < SeaOfGatesEngine.this.metalArcs[z].length; ++c2) {
                    if (SeaOfGatesEngine.this.sogp.getDefaultWidthOverride(SeaOfGatesEngine.this.metalArcs[z][c2]) == null) continue;
                    minWidth = 0.0;
                    continue block0;
                }
            }
            this.minWidth = minWidth;
            for (z = 0; z < numMetalLayers; ++z) {
                this.overrideMetalSpacings[z] = null;
                Double overrideWidth = null;
                boolean hadXOverride = false;
                boolean hadYOverride = false;
                for (int c3 = 0; c3 < SeaOfGatesEngine.this.metalArcs[z].length; ++c3) {
                    DRCTemplate rule;
                    int cc;
                    int i2;
                    SeaOfGates.SeaOfGatesArcProperties sogap;
                    Double o2 = SeaOfGatesEngine.this.sogp.getDefaultWidthOverride(SeaOfGatesEngine.this.metalArcs[z][c3]);
                    if (o2 == null) continue;
                    if (overrideWidth == null || o2 > overrideWidth) {
                        overrideWidth = o2;
                    }
                    if ((sogap = SeaOfGatesEngine.this.sogp.getOverridesForArcsOnNet(routeName, SeaOfGatesEngine.this.metalArcs[z][c3])) != null && sogap.getWidthOverride() != null) {
                        overrideWidth = sogap.getWidthOverride();
                    }
                    if (overrideWidth != null) {
                        if (this.overrideMetalWidth == null) {
                            this.overrideMetalWidth = new double[numMetalLayers];
                            for (int i3 = 0; i3 < numMetalLayers; ++i3) {
                                if (SeaOfGatesEngine.this.metalArcs[i3] == null) continue;
                                for (int cc2 = 0; cc2 < SeaOfGatesEngine.this.metalArcs[i3].length; ++cc2) {
                                    this.overrideMetalWidth[i3] = Math.max(SeaOfGatesEngine.this.metalArcs[i3][cc2].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), minWidth);
                                }
                            }
                        }
                        this.overrideMetalWidth[z] = overrideWidth;
                    }
                    Double overrideSpacingX = SeaOfGatesEngine.this.sogp.getDefaultSpacingOverride(SeaOfGatesEngine.this.metalArcs[z][c3], 0);
                    Double overrideSpacingY = SeaOfGatesEngine.this.sogp.getDefaultSpacingOverride(SeaOfGatesEngine.this.metalArcs[z][c3], 1);
                    if (sogap != null && sogap.getSpacingOverride(0) != null) {
                        overrideSpacingX = sogap.getSpacingOverride(0);
                    }
                    if (sogap != null && sogap.getSpacingOverride(1) != null) {
                        overrideSpacingY = sogap.getSpacingOverride(1);
                    }
                    if (overrideSpacingX != null) {
                        hadXOverride = true;
                        if (this.overrideMetalSpacingX == null) {
                            this.overrideMetalSpacingX = new double[numMetalLayers];
                            for (i2 = 0; i2 < numMetalLayers; ++i2) {
                                this.overrideMetalSpacingX[i2] = 0.0;
                                if (SeaOfGatesEngine.this.metalLayers[i2] == null || SeaOfGatesEngine.this.metalArcs[i2] == null) continue;
                                for (cc = 0; cc < SeaOfGatesEngine.this.metalArcs[i2].length; ++cc) {
                                    rule = DRC.getSpacingRule(SeaOfGatesEngine.this.metalLayers[i2][cc], null, SeaOfGatesEngine.this.metalLayers[i2][cc], null, false, -1, SeaOfGatesEngine.this.metalArcs[i2][cc].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), 50.0);
                                    if (rule == null) continue;
                                    this.overrideMetalSpacingX[i2] = rule.getValue(0);
                                }
                            }
                        }
                        this.overrideMetalSpacingX[z] = overrideSpacingX;
                    }
                    if (overrideSpacingY == null) continue;
                    hadYOverride = true;
                    if (this.overrideMetalSpacingY == null) {
                        this.overrideMetalSpacingY = new double[numMetalLayers];
                        for (i2 = 0; i2 < numMetalLayers; ++i2) {
                            this.overrideMetalSpacingY[i2] = 0.0;
                            if (SeaOfGatesEngine.this.metalLayers[i2] == null || SeaOfGatesEngine.this.metalArcs[i2] == null) continue;
                            for (cc = 0; cc < SeaOfGatesEngine.this.metalArcs[i2].length; ++cc) {
                                rule = DRC.getSpacingRule(SeaOfGatesEngine.this.metalLayers[i2][cc], null, SeaOfGatesEngine.this.metalLayers[i2][cc], null, false, -1, SeaOfGatesEngine.this.metalArcs[i2][cc].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), 50.0);
                                if (rule == null) continue;
                                this.overrideMetalSpacingY[i2] = rule.getNumValues() <= 1 ? rule.getValue(0) : rule.getValue(1);
                            }
                        }
                    }
                    this.overrideMetalSpacingY[z] = overrideSpacingY;
                }
                if (!hadXOverride || !hadYOverride) continue;
                this.overrideMetalSpacings[z] = new double[]{this.overrideMetalSpacingX[z], this.overrideMetalSpacingY[z]};
            }
            this.aPi = aPi;
            this.bPi = bPi;
            this.aPoly = aPi.getPoly();
            this.bPoly = bPi.getPoly();
            FixpRectangle aRect = this.aPoly.getBounds2D();
            FixpRectangle bRect = this.bPoly.getBounds2D();
            if (bRect.getMaxX() < aRect.getMinX()) {
                bX = this.upToGrain(bRect.getCenterX());
                aX = this.downToGrain(aRect.getCenterX());
            } else if (bRect.getMinX() > aRect.getMaxX()) {
                bX = this.downToGrain(bRect.getCenterX());
                aX = this.upToGrain(aRect.getCenterX());
            } else {
                double xVal = (Math.max(bRect.getMinX(), aRect.getMinX()) + Math.min(bRect.getMaxX(), aRect.getMaxX())) / 2.0;
                bX = aX = this.upToGrain(xVal);
            }
            if (bRect.getMaxY() < aRect.getMinY()) {
                bY = this.upToGrain(bRect.getCenterY());
                aY = this.downToGrain(aRect.getCenterY());
            } else if (bRect.getMinY() > aRect.getMaxY()) {
                bY = this.downToGrain(bRect.getCenterY());
                aY = this.upToGrain(aRect.getCenterY());
            } else {
                double yVal = (Math.max(bRect.getMinY(), aRect.getMinY()) + Math.min(bRect.getMaxY(), aRect.getMaxY())) / 2.0;
                bY = aY = this.upToGrain(yVal);
            }
            this.aZ = aArc.getFunction().getLevel() - 1;
            this.bZ = bArc.getFunction().getLevel() - 1;
            this.aC = aArc.getMaskLayer();
            this.bC = bArc.getMaskLayer();
            double lowX = Math.min(aRect.getMinX(), bRect.getMinX());
            double highX = Math.max(aRect.getMaxX(), bRect.getMaxX());
            double lowY = Math.min(aRect.getMinY(), bRect.getMinY());
            double highY = Math.max(aRect.getMaxY(), bRect.getMaxY());
            double gap = DRC.getWorstSpacingDistance(SeaOfGatesEngine.this.tech, -1) * (double)this.maxDistance;
            Rectangle2D.Double testBounds = new Rectangle2D.Double(lowX - gap, lowY - gap, highX - lowX + gap * 2.0, highY - lowY + gap * 2.0);
            this.buildGrids(aX, aY, bX, bY, testBounds);
            double aLX = this.getLowerXGrid(this.aZ, aRect.getMinX()).getCoordinate();
            double aHX = this.getUpperXGrid(this.aZ, aRect.getMaxX()).getCoordinate();
            double aLY = this.getLowerYGrid(this.aZ, aRect.getMinY()).getCoordinate();
            double aHY = this.getUpperYGrid(this.aZ, aRect.getMaxY()).getCoordinate();
            FixpRectangle aRectGridded = FixpRectangle.from(new Rectangle2D.Double(aLX, aLY, aHX - aLX, aHY - aLY));
            double bLX = this.getLowerXGrid(this.bZ, bRect.getMinX()).getCoordinate();
            double bHX = this.getUpperXGrid(this.bZ, bRect.getMaxX()).getCoordinate();
            double bLY = this.getLowerYGrid(this.bZ, bRect.getMinY()).getCoordinate();
            double bHY = this.getUpperYGrid(this.bZ, bRect.getMaxY()).getCoordinate();
            FixpRectangle bRectGridded = FixpRectangle.from(new Rectangle2D.Double(bLX, bLY, bHX - bLX, bHY - bLY));
            this.aEndpoints = new PossibleEndpoints(aX, aY, aRect, aRectGridded);
            this.bEndpoints = new PossibleEndpoints(bX, bY, bRect, bRectGridded);
            double maxStrayFromRouteBoundsX = gap;
            double maxStrayFromRouteBoundsY = gap;
            double griddedLowX = Math.min(this.getLowerXGrid(this.aZ, lowX - maxStrayFromRouteBoundsX).getCoordinate(), this.getLowerXGrid(this.bZ, lowX - maxStrayFromRouteBoundsX).getCoordinate());
            double griddedHighX = Math.max(this.getUpperXGrid(this.aZ, highX + maxStrayFromRouteBoundsX).getCoordinate(), this.getUpperXGrid(this.bZ, highX + maxStrayFromRouteBoundsX).getCoordinate());
            double griddedLowY = Math.min(this.getLowerYGrid(this.aZ, lowY - maxStrayFromRouteBoundsY).getCoordinate(), this.getLowerYGrid(this.bZ, lowY - maxStrayFromRouteBoundsY).getCoordinate());
            double griddedHighY = Math.max(this.getUpperYGrid(this.aZ, highY + maxStrayFromRouteBoundsY).getCoordinate(), this.getUpperYGrid(this.bZ, highY + maxStrayFromRouteBoundsY).getCoordinate());
            if (SeaOfGatesEngine.this.routingBoundsLimit != null) {
                if (griddedLowX < SeaOfGatesEngine.this.routingBoundsLimit.getMinX()) {
                    griddedLowX = SeaOfGatesEngine.this.routingBoundsLimit.getMinX();
                }
                if (griddedHighX > SeaOfGatesEngine.this.routingBoundsLimit.getMaxX()) {
                    griddedHighX = SeaOfGatesEngine.this.routingBoundsLimit.getMaxX();
                }
                if (griddedLowY < SeaOfGatesEngine.this.routingBoundsLimit.getMinY()) {
                    griddedLowY = SeaOfGatesEngine.this.routingBoundsLimit.getMinY();
                }
                if (griddedHighY > SeaOfGatesEngine.this.routingBoundsLimit.getMaxY()) {
                    griddedHighY = SeaOfGatesEngine.this.routingBoundsLimit.getMaxY();
                }
            }
            this.routeBounds = new Rectangle2D.Double(griddedLowX, griddedLowY, griddedHighX - griddedLowX, griddedHighY - griddedLowY);
            this.jumpBound = new Rectangle2D.Double(Math.min(aX, bX), Math.min(aY, bY), Math.abs(aX - bX), Math.abs(aY - bY));
            this.overridePreventArcs = null;
            List<ArcProto> arcs = SeaOfGatesEngine.this.sogp.getArcsOnNet(routeName);
            if (arcs != null && arcs.size() > 0) {
                this.overridePreventArcs = new boolean[numMetalLayers];
                for (int i4 = 0; i4 < numMetalLayers; ++i4) {
                    this.overridePreventArcs[i4] = true;
                }
                for (ArcProto ap : arcs) {
                    int metNum = ap.getFunction().getLevel() - 1;
                    this.overridePreventArcs[metNum] = false;
                }
            }
            this.forceGridArcs = new boolean[numMetalLayers];
            for (int i5 = 0; i5 < numMetalLayers; ++i5) {
                this.forceGridArcs[i5] = false;
                for (int c4 = 0; c4 < SeaOfGatesEngine.this.metalArcs[i5].length; ++c4) {
                    if (!SeaOfGatesEngine.this.sogp.isGridForced(SeaOfGatesEngine.this.metalArcs[i5][c4])) continue;
                    this.forceGridArcs[i5] = true;
                }
            }
            this.aTaperWid = this.getTaperWidth(aPi, this.aZ);
            this.bTaperWid = this.getTaperWidth(bPi, this.bZ);
            this.aTaperLen = SeaOfGatesEngine.this.taperLength[this.aZ];
            this.bTaperLen = SeaOfGatesEngine.this.taperLength[this.bZ];
            if (DBMath.areEquals(this.aTaperWid, this.getUntaperedArcWidth(this.aZ))) {
                this.aTaperLen = -1.0;
            }
            if (DBMath.areEquals(this.bTaperWid, this.getUntaperedArcWidth(this.bZ))) {
                this.bTaperLen = -1.0;
            }
        }

        public boolean getRoutedSucess() {
            return this.routedSuccess;
        }

        public boolean isAlreadyRouted() {
            return this.alreadyRouted;
        }

        public Wavefront getWavefront() {
            return this.winningWF;
        }

        public Wavefront getWavefrontAtoB() {
            return this.dirAtoB;
        }

        public Wavefront getWavefrontBtoA() {
            return this.dirBtoA;
        }

        public double getATaperWidth() {
            return this.aTaperWid;
        }

        public double getBTaperWidth() {
            return this.bTaperWid;
        }

        public double getATaperLength() {
            return this.aTaperLen;
        }

        public double getBTaperLength() {
            return this.bTaperLen;
        }

        public PossibleEndpoints getAPossibleEndpoints() {
            return this.aEndpoints;
        }

        public PossibleEndpoints getBPossibleEndpoints() {
            return this.bEndpoints;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setDebugging(Boolean fromA) {
            this.debuggingRouteFromA = fromA;
        }

        public void checkGridValidity() {
            ArrayList<EPoint> offGrid;
            boolean hor;
            if (this.forceGridArcs[this.aZ]) {
                hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (this.aZ % 2 == 0) {
                        hor = false;
                    }
                } else if (this.aZ % 2 != 0) {
                    hor = false;
                }
                if (!hor && !this.isOnXGrid(this.aZ, this.getAX())) {
                    offGrid = new ArrayList<EPoint>();
                    offGrid.add(this.aEndpoints.getCenter());
                    offGrid.add(this.aEndpoints.getCenter());
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.aEndpoints.getCenterX()) + "," + TextUtils.formatDistance(this.aEndpoints.getCenterY()) + "," + SeaOfGatesEngine.describeMetal(this.aZ, this.aC) + ") is not on X grid (nearest X grids are at " + TextUtils.formatDistance(this.getLowerXGrid(this.aZ, this.aEndpoints.getCenterX()).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperXGrid(this.aZ, this.aEndpoints.getCenterX()).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
                if (hor && !this.isOnYGrid(this.aZ, this.aEndpoints.getCenterY())) {
                    offGrid = new ArrayList();
                    offGrid.add(this.aEndpoints.getCenter());
                    offGrid.add(this.aEndpoints.getCenter());
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.aEndpoints.getCenterX()) + "," + TextUtils.formatDistance(this.aEndpoints.getCenterY()) + "," + SeaOfGatesEngine.describeMetal(this.aZ, this.aC) + ") is not on Y grid (nearest Y grids are at " + TextUtils.formatDistance(this.getLowerYGrid(this.aZ, this.aEndpoints.getCenterY()).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperYGrid(this.aZ, this.aEndpoints.getCenterY()).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
            }
            if (this.forceGridArcs[this.bZ]) {
                hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (this.bZ % 2 == 0) {
                        hor = false;
                    }
                } else if (this.bZ % 2 != 0) {
                    hor = false;
                }
                if (!hor && !this.isOnXGrid(this.bZ, this.bEndpoints.getCenterX())) {
                    offGrid = new ArrayList();
                    offGrid.add(this.bEndpoints.getCenter());
                    offGrid.add(this.bEndpoints.getCenter());
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.bEndpoints.getCenterX()) + "," + TextUtils.formatDistance(this.bEndpoints.getCenterY()) + "," + SeaOfGatesEngine.describeMetal(this.bZ, this.bC) + ") is not on X grid (nearest X grids are at " + TextUtils.formatDistance(this.getLowerXGrid(this.bZ, this.bEndpoints.getCenterX()).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperXGrid(this.bZ, this.bEndpoints.getCenterX()).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
                if (hor && !this.isOnYGrid(this.bZ, this.bEndpoints.getCenterY())) {
                    offGrid = new ArrayList();
                    offGrid.add(this.bEndpoints.getCenter());
                    offGrid.add(this.bEndpoints.getCenter());
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.bEndpoints.getCenterX()) + "," + TextUtils.formatDistance(this.bEndpoints.getCenterY()) + "," + SeaOfGatesEngine.describeMetal(this.bZ, this.bC) + ") is not on Y grid (nearest Y grids are at " + TextUtils.formatDistance(this.getLowerYGrid(this.bZ, this.bEndpoints.getCenterY()).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperYGrid(this.bZ, this.bEndpoints.getCenterY()).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
            }
        }

        public SeaOfGates.SeaOfGatesTrack[][] getXRoutingGrid() {
            return this.gridLocationsX;
        }

        public SeaOfGates.SeaOfGatesTrack[][] getYRoutingGrid() {
            return this.gridLocationsY;
        }

        public void buildGrids(double aX, double aY, double bX, double bY, Rectangle2D bounds) {
            int metIndex;
            int metNum;
            this.gridLocationsX = new SeaOfGates.SeaOfGatesTrack[numMetalLayers][];
            this.gridLocationsY = new SeaOfGates.SeaOfGatesTrack[numMetalLayers][];
            for (metNum = 1; metNum <= numMetalLayers; ++metNum) {
                double high;
                double low;
                metIndex = metNum - 1;
                SeaOfGates.SeaOfGatesTrack[] thisGrid = SeaOfGatesEngine.this.metalGrid[metIndex];
                if (thisGrid == null || !SeaOfGatesEngine.this.sogp.isForceHorVer() && !SeaOfGatesEngine.this.sogp.isFavorHorVer()) continue;
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 != 0) {
                        hor = false;
                    }
                } else if (metNum % 2 == 0) {
                    hor = false;
                }
                double offset = thisGrid[0].getCoordinate();
                double range = thisGrid[thisGrid.length - 1].getCoordinate() - offset;
                if (!((range += thisGrid[1].getCoordinate() - thisGrid[0].getCoordinate()) > 0.0)) continue;
                ArrayList<SeaOfGates.SeaOfGatesTrack> values = new ArrayList<SeaOfGates.SeaOfGatesTrack>();
                if (hor) {
                    low = bounds.getMinY();
                    high = bounds.getMaxY();
                } else {
                    low = bounds.getMinX();
                    high = bounds.getMaxX();
                }
                double lowGroup = Math.floor((low - offset) / range) * range;
                double highGroup = Math.ceil((high - offset) / range) * range;
                for (double v = lowGroup; v <= highGroup; v += range) {
                    for (int i2 = 0; i2 < thisGrid.length; ++i2) {
                        double val = v + thisGrid[i2].getCoordinate();
                        int maskNum = thisGrid[i2].getMaskNum();
                        if (!(val >= low) || !(val <= high)) continue;
                        values.add(new SeaOfGates.SeaOfGatesTrack(val, maskNum));
                    }
                }
                if (values.size() < 2) continue;
                if (hor) {
                    this.gridLocationsY[metIndex] = this.makeArrayOfUniqueTracks(values);
                    continue;
                }
                this.gridLocationsX[metIndex] = this.makeArrayOfUniqueTracks(values);
            }
            for (metNum = 1; metNum <= numMetalLayers; ++metNum) {
                SeaOfGates.SeaOfGatesTrack t2;
                SeaOfGates.SeaOfGatesTrack t1;
                SeaOfGates.SeaOfGatesTrack[][] gridLocations;
                metIndex = metNum - 1;
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 != 0) {
                        hor = false;
                    }
                } else if (metNum % 2 == 0) {
                    hor = false;
                }
                if (hor) {
                    gridLocations = this.gridLocationsX;
                    t1 = this.getClosestXGrid(this.aZ, aX);
                    t2 = this.getClosestXGrid(this.bZ, bX);
                } else {
                    gridLocations = this.gridLocationsY;
                    t1 = this.getClosestXGrid(this.aZ, aY);
                    t2 = this.getClosestXGrid(this.bZ, bY);
                }
                ArrayList<SeaOfGates.SeaOfGatesTrack> values = new ArrayList<SeaOfGates.SeaOfGatesTrack>();
                boolean realGrid = false;
                if (metIndex > 0) {
                    realGrid |= this.gridAlternateLayer(metIndex, -1, values, t1, t2, gridLocations);
                }
                if (metIndex < numMetalLayers - 1) {
                    realGrid |= this.gridAlternateLayer(metIndex, 1, values, t1, t2, gridLocations);
                }
                if (!realGrid) continue;
                gridLocations[metIndex] = this.makeArrayOfUniqueTracks(values);
            }
        }

        private SeaOfGates.SeaOfGatesTrack[] makeArrayOfUniqueTracks(List<SeaOfGates.SeaOfGatesTrack> values) {
            Collections.sort(values);
            for (int i2 = 1; i2 < values.size(); ++i2) {
                if (!DBMath.areEquals(values.get(i2 - 1).getCoordinate(), values.get(i2).getCoordinate())) continue;
                values.remove(i2);
                --i2;
            }
            SeaOfGates.SeaOfGatesTrack[] gridLocations = new SeaOfGates.SeaOfGatesTrack[values.size()];
            int i3 = 0;
            for (SeaOfGates.SeaOfGatesTrack v : values) {
                gridLocations[i3++] = v;
            }
            return gridLocations;
        }

        private boolean gridAlternateLayer(int curLayer, int diff, List<SeaOfGates.SeaOfGatesTrack> values, SeaOfGates.SeaOfGatesTrack t1, SeaOfGates.SeaOfGatesTrack t2, SeaOfGates.SeaOfGatesTrack[][] gridLocations) {
            if (SeaOfGatesEngine.this.sogp.isPrevented(SeaOfGatesEngine.this.primaryMetalArc[curLayer])) {
                return false;
            }
            int altLayer = curLayer + diff;
            if (gridLocations[altLayer] == null) {
                values.add(t1);
                values.add(t2);
                return false;
            }
            for (int i2 = 0; i2 < gridLocations[altLayer].length; ++i2) {
                values.add(new SeaOfGates.SeaOfGatesTrack(gridLocations[altLayer][i2].getCoordinate(), gridLocations[altLayer][i2].getMaskNum()));
            }
            return true;
        }

        public SeaOfGates.SeaOfGatesTrack getLowerXGrid(int metNum, double value) {
            return this.findLowerValue(this.gridLocationsX[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getUpperXGrid(int metNum, double value) {
            return this.findUpperValue(this.gridLocationsX[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getClosestXGrid(int metNum, double value) {
            return this.findClosestValue(this.gridLocationsX[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getLowerYGrid(int metNum, double value) {
            return this.findLowerValue(this.gridLocationsY[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getUpperYGrid(int metNum, double value) {
            return this.findUpperValue(this.gridLocationsY[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getClosestYGrid(int metNum, double value) {
            return this.findClosestValue(this.gridLocationsY[metNum], value);
        }

        public boolean isOnXGrid(int metNum, double value) {
            return this.isOnGrid(this.gridLocationsX[metNum], value);
        }

        public boolean isOnYGrid(int metNum, double value) {
            return this.isOnGrid(this.gridLocationsY[metNum], value);
        }

        private SeaOfGates.SeaOfGatesTrack findLowerValue(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid == null) {
                return new SeaOfGates.SeaOfGatesTrack(value, 0);
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (DBMath.isLessThanOrEqualTo(value, thisGrid[lo].getCoordinate())) {
                return thisGrid[lo];
            }
            if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[hi].getCoordinate())) {
                return thisGrid[hi];
            }
            for (int i2 = 0; i2 < 1000; ++i2) {
                int med = (hi + lo) / 2;
                if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[med].getCoordinate()) && DBMath.isLessThan(value, thisGrid[med + 1].getCoordinate())) {
                    return thisGrid[med];
                }
                if (DBMath.isLessThan(value, thisGrid[med].getCoordinate())) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return new SeaOfGates.SeaOfGatesTrack(value, 0);
        }

        private SeaOfGates.SeaOfGatesTrack findUpperValue(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid == null) {
                return new SeaOfGates.SeaOfGatesTrack(value, 0);
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (DBMath.isLessThanOrEqualTo(value, thisGrid[lo].getCoordinate())) {
                return thisGrid[lo];
            }
            if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[hi].getCoordinate())) {
                return thisGrid[hi];
            }
            for (int i2 = 0; i2 < 1000; ++i2) {
                int med = (hi + lo) / 2;
                if (DBMath.isGreaterThan(value, thisGrid[med].getCoordinate()) && DBMath.isLessThanOrEqualTo(value, thisGrid[med + 1].getCoordinate())) {
                    return thisGrid[med + 1];
                }
                if (DBMath.isLessThanOrEqualTo(value, thisGrid[med].getCoordinate())) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return new SeaOfGates.SeaOfGatesTrack(value, 0);
        }

        private SeaOfGates.SeaOfGatesTrack findClosestValue(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid == null) {
                return new SeaOfGates.SeaOfGatesTrack(value, 0);
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (DBMath.isLessThanOrEqualTo(value, thisGrid[lo].getCoordinate())) {
                return thisGrid[lo];
            }
            if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[hi].getCoordinate())) {
                return thisGrid[hi];
            }
            for (int i2 = 0; i2 < 1000; ++i2) {
                int med = (hi + lo) / 2;
                if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[med].getCoordinate()) && DBMath.isLessThan(value, thisGrid[med + 1].getCoordinate())) {
                    if (DBMath.isLessThan(value - thisGrid[med].getCoordinate(), thisGrid[med + 1].getCoordinate() - value)) {
                        return thisGrid[med];
                    }
                    return thisGrid[med + 1];
                }
                if (DBMath.isLessThanOrEqualTo(value, thisGrid[med].getCoordinate())) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return new SeaOfGates.SeaOfGatesTrack(value, 0);
        }

        private boolean isOnGrid(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid != null) {
                int lo = 0;
                int hi = thisGrid.length - 1;
                if (DBMath.isLessThan(value, thisGrid[lo].getCoordinate())) {
                    return false;
                }
                if (DBMath.isGreaterThan(value, thisGrid[hi].getCoordinate())) {
                    return false;
                }
                for (int i2 = 0; i2 < 1000; ++i2) {
                    int med = (hi + lo) / 2;
                    if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[med].getCoordinate()) && DBMath.isLessThanOrEqualTo(value, thisGrid[med + 1].getCoordinate())) {
                        return DBMath.areEquals(value, thisGrid[med].getCoordinate()) || DBMath.areEquals(thisGrid[med + 1].getCoordinate(), value);
                    }
                    if (DBMath.isLessThanOrEqualTo(value, thisGrid[med].getCoordinate())) {
                        hi = med;
                        continue;
                    }
                    lo = med;
                }
                return false;
            }
            return true;
        }

        private double upToGrain(double v) {
            return v;
        }

        private double upToGrainAlways(double v) {
            return Math.ceil(v);
        }

        private double downToGrain(double v) {
            return v;
        }

        private double downToGrainAlways(double v) {
            return Math.floor(v);
        }

        private ContactPlacementError canPlaceContact(PrimitiveNode np, int newMetal, int offendingMetal, int offendingMetalColor, double conX, double conY, double conWid, double conHei, Orientation orient, Boolean endA) {
            NodeInst dummyNi = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(conX, conY), conWid, conHei, orient);
            Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
            FixpTransform trans = null;
            int blockFactor = endA == null ? 0 : (endA != false ? 2 : 4);
            MutableInteger mi = new MutableInteger(this.netID.intValue() + blockFactor);
            if (orient != Orientation.IDENT) {
                trans = dummyNi.rotateOut();
            }
            for (int p = 0; p < conPolys.length; ++p) {
                double halfHeight;
                Poly conPoly = conPolys[p];
                Layer conLayer = conPoly.getLayer();
                if (!conLayer.getFunction().isMetal()) continue;
                if (trans != null) {
                    conPoly.transform(trans);
                }
                FixpRectangle conRect = conPoly.getBounds2D();
                boolean found = false;
                for (int c2 = 0; c2 < SeaOfGatesEngine.this.metalLayers[offendingMetal].length; ++c2) {
                    if (conLayer != SeaOfGatesEngine.this.metalLayers[offendingMetal][c2] || conLayer.getFunction().getMaskColor() != offendingMetalColor) continue;
                    found = true;
                }
                if (found) {
                    EPoint problem = null;
                    if (!this.isPointInMetal(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMinY(), offendingMetal, mi)) {
                        problem = EPoint.fromLambda(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMinY());
                    }
                    if (problem == null && !this.isPointInMetal(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMaxY(), offendingMetal, mi)) {
                        problem = EPoint.fromLambda(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMaxY());
                    }
                    if (problem == null && !this.isPointInMetal(((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMaxY(), offendingMetal, mi)) {
                        problem = EPoint.fromLambda(((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMaxY());
                    }
                    if (problem == null && !this.isPointInMetal(((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMinY(), offendingMetal, mi)) {
                        problem = EPoint.fromLambda(((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMinY());
                    }
                    if (problem == null && !this.isPointInMetal(((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY(), offendingMetal, mi)) {
                        problem = EPoint.fromLambda(((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY());
                    }
                    if (problem != null) {
                        ContactPlacementError cpe = new ContactPlacementError(offendingMetal);
                        cpe.missingRect = conRect;
                        return cpe;
                    }
                }
                found = false;
                int color = -1;
                for (int c3 = 0; c3 < SeaOfGatesEngine.this.metalLayers[newMetal].length; ++c3) {
                    if (conLayer != SeaOfGatesEngine.this.metalLayers[newMetal][c3]) continue;
                    found = true;
                    color = c3;
                }
                if (!found) continue;
                double[] fromSurround = this.getSpacingRule(newMetal, SeaOfGatesEngine.this.maxDefArcWidth[newMetal], -1.0);
                double halfWidth = ((RectangularShape)conRect).getWidth() / 2.0;
                SOGBound block = this.getMetalBlockage(this.netID, newMetal, color, halfWidth, halfHeight = ((RectangularShape)conRect).getHeight() / 2.0, fromSurround, ((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY());
                if (block == null) continue;
                ContactPlacementError cpe = new ContactPlacementError(newMetal);
                cpe.offendingRect = block.bound;
                return cpe;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPointInMetal(double x, double y, int metalNo, MutableInteger netID) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[metalNo]);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                Rectangle2D.Double searchArea = new Rectangle2D.Double(x, y, 0.0, 0.0);
                Iterator<SOGBound> sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    SOGBound sBound = sea.next();
                    if (!sBound.containsPoint(x, y)) continue;
                    if (netID != null) {
                        if (!sBound.isSameBasicNet(netID)) continue;
                        int endBits = 6;
                        if ((sBound.getNetID().intValue() & endBits) != (netID.intValue() & endBits)) continue;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                bTree.unlock();
            }
            return false;
        }

        private Orientation getMVSize(MetalVia mv, double x, double y, double lastX, double lastY, MutableDouble wid, MutableDouble hei) {
            double arcWid;
            PrimitiveNode np = mv.via;
            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
            SizeOffset so = np.getProtoSizeOffset();
            double minWid = this.minWidth;
            double minHei = this.minWidth;
            double xOffset = so.getLowXOffset() + so.getHighXOffset();
            double yOffset = so.getLowYOffset() + so.getHighYOffset();
            double conWid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, minWid) + xOffset;
            double conHei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, minHei) + yOffset;
            if (mv.horMetal >= 0 && (arcWid = this.getArcWidth(mv.horMetal, x, y, lastX, lastY) + mv.horMetalInset) > conHei) {
                conHei = arcWid;
            }
            if (mv.verMetal >= 0 && (arcWid = this.getArcWidth(mv.verMetal, x, y, lastX, lastY) + mv.verMetalInset) > conWid) {
                conWid = arcWid;
            }
            wid.setValue(conWid);
            hei.setValue(conHei);
            return orient;
        }

        private boolean invalidPort(boolean endA, boolean tap, PortInst pi) {
            return this.invalidPortNEW(endA, tap, pi);
        }

        private boolean invalidPortNEW(boolean endA, boolean tap, PortInst pi) {
            Boolean end;
            EPoint pt = pi.getCenter();
            double conX = pt.getX();
            double conY = pt.getY();
            ArcProto[] conns = SeaOfGatesEngine.this.getPossibleConnections(pi.getPortProto());
            for (int j2 = 0; j2 < conns.length; ++j2) {
                ArcProto ap = conns[j2];
                if (ap.getTechnology() != SeaOfGatesEngine.this.tech || !ap.getFunction().isMetal() || this.preventArc(conns[j2].getFunction().getLevel() - 1)) continue;
                return false;
            }
            HashMap whatWasChecked = new HashMap();
            HashMap<Integer, Point> contactInvalidColors = new HashMap<Integer, Point>();
            int realOffendingMetal = 0;
            Boolean bl = end = tap ? null : Boolean.valueOf(endA);
            if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() || SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                PossibleEndpoints possibleVias = endA ? this.aEndpoints : this.bEndpoints;
                for (int j3 = 0; j3 < conns.length; ++j3) {
                    boolean hor;
                    int newMetalColor;
                    int newMetal;
                    int offendingMetalColor;
                    int offendingMetal;
                    block68: {
                        ArcProto ap = conns[j3];
                        if (ap.getTechnology() != SeaOfGatesEngine.this.tech || !ap.getFunction().isMetal()) continue;
                        offendingMetal = conns[j3].getFunction().getLevel() - 1;
                        offendingMetalColor = conns[j3].getMaskLayer();
                        newMetal = 0;
                        newMetalColor = 0;
                        int lowerMetal = offendingMetal - 1;
                        int upperMetal = offendingMetal + 1;
                        List<MetalVia> mvs = null;
                        if (SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer() && lowerMetal >= 0 && !this.preventArc(lowerMetal)) {
                            mvs = SeaOfGatesEngine.this.metalVias[lowerMetal].getVias();
                            newMetal = lowerMetal;
                        }
                        if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() && upperMetal < numMetalLayers && !this.preventArc(upperMetal)) {
                            mvs = SeaOfGatesEngine.this.metalVias[upperMetal - 1].getVias();
                            newMetal = upperMetal;
                        }
                        if (mvs == null) continue;
                        hor = true;
                        if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                            if (newMetal % 2 == 0) {
                                hor = false;
                            }
                        } else if (newMetal % 2 != 0) {
                            hor = false;
                        }
                        if (hor) {
                            sogt = this.getClosestYGrid(newMetal, conY);
                            if (sogt != null) {
                                newMetalColor = sogt.getMaskNum();
                            }
                        } else {
                            sogt = this.getClosestXGrid(newMetal, conX);
                            if (sogt != null) {
                                newMetalColor = sogt.getMaskNum();
                            }
                        }
                        HashMap<PrimitiveNode, ContactPlacementError> checkedThese = (HashMap<PrimitiveNode, ContactPlacementError>)whatWasChecked.get(newMetal);
                        if (checkedThese == null) {
                            checkedThese = new HashMap<PrimitiveNode, ContactPlacementError>();
                            whatWasChecked.put(newMetal, checkedThese);
                        }
                        boolean hasContacts = false;
                        for (MetalVia mv : mvs) {
                            if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                            hasContacts = true;
                        }
                        if (!hasContacts) {
                            realOffendingMetal = offendingMetal;
                            contactInvalidColors.put(newMetal, new Point(offendingMetalColor, newMetalColor));
                        }
                        if (this.forceGridArcs[newMetal]) {
                            PossibleEndpoint vtvl;
                            ContactPlacementError cpe;
                            Orientation orient;
                            MutableDouble conHei;
                            MutableDouble conWid;
                            PrimitiveNode np;
                            int index = 0;
                            if (hor) {
                                if (this.gridLocationsY[newMetal] != null) {
                                    conY = this.getClosestYGrid(newMetal, conY).getCoordinate();
                                    for (index = 0; index < this.gridLocationsY[newMetal].length && this.gridLocationsY[newMetal][index].getCoordinate() != conY; ++index) {
                                    }
                                }
                            } else if (this.gridLocationsX[newMetal] != null) {
                                conX = this.getClosestXGrid(newMetal, conX).getCoordinate();
                                for (index = 0; index < this.gridLocationsX[newMetal].length && this.gridLocationsX[newMetal][index].getCoordinate() != conX; ++index) {
                                }
                            }
                            int startIndex = index;
                            while (true) {
                                if (hor) {
                                    if (index < 0 || index >= this.gridLocationsY[newMetal].length) break;
                                    sogt = this.gridLocationsY[newMetal][index];
                                    conY = sogt.getCoordinate();
                                    newMetalColor = sogt.getMaskNum();
                                    if (conY < this.routeBounds.getMinY() || conY > this.routeBounds.getMaxY()) {
                                        break;
                                    }
                                } else {
                                    if (index < 0 || index >= this.gridLocationsX[newMetal].length) break;
                                    sogt = this.gridLocationsX[newMetal][index];
                                    conX = sogt.getCoordinate();
                                    newMetalColor = sogt.getMaskNum();
                                    if (conX < this.routeBounds.getMinX() || conX > this.routeBounds.getMaxX()) break;
                                }
                                boolean foundLocation = false;
                                for (MetalVia mv : mvs) {
                                    if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                                    np = mv.via;
                                    conWid = new MutableDouble(0.0);
                                    conHei = new MutableDouble(0.0);
                                    orient = this.getMVSize(mv, conX, conY, conX, conY, conWid, conHei);
                                    cpe = this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, end);
                                    if (cpe != null) {
                                        if (checkedThese.get(np) != null) continue;
                                        checkedThese.put(np, cpe);
                                        continue;
                                    }
                                    vtvl = new PossibleEndpoint(EPoint.fromLambda(conX, conY), mv, conWid.doubleValue(), conHei.doubleValue(), orient);
                                    possibleVias.add(vtvl);
                                    foundLocation = true;
                                }
                                if (!foundLocation && Math.abs(index - startIndex) > 5) break;
                                ++index;
                            }
                            index = startIndex - 1;
                            while (true) {
                                if (hor) {
                                    if (index < 0 || index >= this.gridLocationsY[newMetal].length) break block68;
                                    sogt = this.gridLocationsY[newMetal][index];
                                    conY = sogt.getCoordinate();
                                    newMetalColor = sogt.getMaskNum();
                                    if (conY < this.routeBounds.getMinY() || conY > this.routeBounds.getMaxY()) {
                                        break block68;
                                    }
                                } else {
                                    if (index < 0 || index >= this.gridLocationsX[newMetal].length) break block68;
                                    sogt = this.gridLocationsX[newMetal][index];
                                    conX = sogt.getCoordinate();
                                    newMetalColor = sogt.getMaskNum();
                                    if (conX < this.routeBounds.getMinX() || conX > this.routeBounds.getMaxX()) break block68;
                                }
                                boolean foundLocation = false;
                                for (MetalVia mv : mvs) {
                                    if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                                    np = mv.via;
                                    conWid = new MutableDouble(0.0);
                                    conHei = new MutableDouble(0.0);
                                    orient = this.getMVSize(mv, conX, conY, conX, conY, conWid, conHei);
                                    cpe = this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, end);
                                    if (cpe != null) {
                                        if (checkedThese.get(np) != null) continue;
                                        checkedThese.put(np, cpe);
                                        continue;
                                    }
                                    vtvl = new PossibleEndpoint(EPoint.fromLambda(conX, conY), mv, conWid.doubleValue(), conHei.doubleValue(), orient);
                                    possibleVias.add(vtvl);
                                    foundLocation = true;
                                }
                                if (foundLocation || Math.abs(index - startIndex) <= 5) {
                                    --index;
                                    continue;
                                }
                                break block68;
                                break;
                            }
                        }
                        for (MetalVia mv : mvs) {
                            if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                            MutableDouble conWid = new MutableDouble(0.0);
                            MutableDouble conHei = new MutableDouble(0.0);
                            Orientation orient = this.getMVSize(mv, conX, conY, conX, conY, conWid, conHei);
                            ContactPlacementError cpe = this.canPlaceContact(mv.via, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, end);
                            if (cpe != null) {
                                checkedThese.put(mv.via, cpe);
                                continue;
                            }
                            PossibleEndpoint vtvl = new PossibleEndpoint(EPoint.fromLambda(conX, conY), mv, conWid.doubleValue(), conHei.doubleValue(), orient);
                            possibleVias.add(vtvl);
                        }
                    }
                    if (!possibleVias.hasEndpoints()) continue;
                    EPoint otherEnd = endA ? this.bEndpoints.getCenter() : this.aEndpoints.getCenter();
                    double closestDist = Double.MAX_VALUE;
                    PossibleEndpoint closestEP = null;
                    for (PossibleEndpoint vtvl : possibleVias.getEndpoints()) {
                        double dist = vtvl.coord.distance(otherEnd);
                        if (closestEP != null && !(dist < closestDist)) continue;
                        closestEP = vtvl;
                        closestDist = dist;
                    }
                    if (endA) {
                        dX = closestEP.coord.getX() - this.aEndpoints.getCenterX();
                        dY = closestEP.coord.getY() - this.aEndpoints.getCenterY();
                        this.aEndpoints.setCenterX(closestEP.coord.getX());
                        this.aEndpoints.setCenterY(closestEP.coord.getY());
                        pts = this.aPoly.getPoints();
                        for (int i2 = 0; i2 < pts.length; ++i2) {
                            pts[i2].setLocation(pts[i2].getX() + dX, pts[i2].getY() + dY);
                        }
                        this.aEndpoints.setRect(this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY(), 0.0, 0.0);
                        double aLX = this.getLowerXGrid(this.aZ, this.aEndpoints.getRect().getMinX()).getCoordinate();
                        double aHX = this.getUpperXGrid(this.aZ, this.aEndpoints.getRect().getMaxX()).getCoordinate();
                        double aLY = this.getLowerYGrid(this.aZ, this.aEndpoints.getRect().getMinY()).getCoordinate();
                        double aHY = this.getUpperYGrid(this.aZ, this.aEndpoints.getRect().getMaxY()).getCoordinate();
                        this.aEndpoints.setGriddedRect(aLX, aHX, aLY, aHY);
                        this.aZ = newMetal;
                        if (this.forceGridArcs[newMetal]) {
                            if (hor) {
                                sogt = this.getClosestYGrid(newMetal, this.aEndpoints.getCenterY());
                                if (sogt != null) {
                                    newMetalColor = sogt.getMaskNum();
                                }
                            } else {
                                sogt = this.getClosestXGrid(newMetal, this.aEndpoints.getCenterX());
                                if (sogt != null) {
                                    newMetalColor = sogt.getMaskNum();
                                }
                            }
                        }
                        this.aC = newMetalColor;
                        this.jumpBound = new Rectangle2D.Double(Math.min(this.aEndpoints.getCenterX(), this.bEndpoints.getCenterX()), Math.min(this.aEndpoints.getCenterY(), this.bEndpoints.getCenterY()), Math.abs(this.aEndpoints.getCenterX() - this.bEndpoints.getCenterX()), Math.abs(this.aEndpoints.getCenterY() - this.bEndpoints.getCenterY()));
                        this.replaceA = closestEP;
                        this.replaceAZ = offendingMetal;
                        if (offendingMetalColor > 0) {
                            this.replaceAC = offendingMetalColor - 1;
                        }
                        this.aTaperWid = this.getUntaperedArcWidth(newMetal);
                        this.aTaperLen = -1.0;
                    } else {
                        dX = closestEP.coord.getX() - this.bEndpoints.getCenterX();
                        dY = closestEP.coord.getY() - this.bEndpoints.getCenterY();
                        this.bEndpoints.setCenterX(closestEP.coord.getX());
                        this.bEndpoints.setCenterY(closestEP.coord.getY());
                        pts = this.bPoly.getPoints();
                        for (int i3 = 0; i3 < pts.length; ++i3) {
                            pts[i3].setLocation(pts[i3].getX() + dX, pts[i3].getY() + dY);
                        }
                        this.bEndpoints.setRect(this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY(), 0.0, 0.0);
                        double bLX = this.getLowerXGrid(this.bZ, this.bEndpoints.getRect().getMinX()).getCoordinate();
                        double bHX = this.getUpperXGrid(this.bZ, this.bEndpoints.getRect().getMaxX()).getCoordinate();
                        double bLY = this.getLowerYGrid(this.bZ, this.bEndpoints.getRect().getMinY()).getCoordinate();
                        double bHY = this.getUpperYGrid(this.bZ, this.bEndpoints.getRect().getMaxY()).getCoordinate();
                        this.bEndpoints.setGriddedRect(bLX, bHX, bLY, bHY);
                        this.bZ = newMetal;
                        if (this.forceGridArcs[newMetal]) {
                            if (hor) {
                                sogt = this.getClosestYGrid(newMetal, this.bEndpoints.getCenterY());
                                if (sogt != null) {
                                    newMetalColor = sogt.getMaskNum();
                                }
                            } else {
                                sogt = this.getClosestXGrid(newMetal, this.bEndpoints.getCenterX());
                                if (sogt != null) {
                                    newMetalColor = sogt.getMaskNum();
                                }
                            }
                        }
                        this.bC = newMetalColor;
                        this.jumpBound = new Rectangle2D.Double(Math.min(this.aEndpoints.getCenterX(), this.bEndpoints.getCenterX()), Math.min(this.aEndpoints.getCenterY(), this.bEndpoints.getCenterY()), Math.abs(this.aEndpoints.getCenterX() - this.bEndpoints.getCenterX()), Math.abs(this.aEndpoints.getCenterY() - this.bEndpoints.getCenterY()));
                        this.replaceB = closestEP;
                        this.replaceBZ = offendingMetal;
                        if (offendingMetalColor > 0) {
                            this.replaceBC = offendingMetalColor - 1;
                        }
                        this.bTaperWid = this.getUntaperedArcWidth(newMetal);
                        this.bTaperLen = -1.0;
                    }
                    NodeInst dummyNi = NodeInst.makeDummyInstance(closestEP.viaToPlace.via, SeaOfGatesEngine.this.ep, closestEP.coord, closestEP.viaSizeX, closestEP.viaSizeY, closestEP.viaOrient);
                    Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                    FixpTransform trans = null;
                    if (closestEP.viaOrient != Orientation.IDENT) {
                        trans = dummyNi.rotateOut();
                    }
                    for (int p = 0; p < conPolys.length; ++p) {
                        Poly conPoly = conPolys[p];
                        Layer conLayer = conPoly.getLayer();
                        if (trans != null) {
                            conPoly.transform(trans);
                        }
                        FixpRectangle conRect = conPoly.getBounds2D();
                        Layer.Function fun = conLayer.getFunction();
                        if (fun.isMetal()) {
                            SeaOfGatesEngine.this.addRectangle(conRect, conLayer, this.netID, false, false);
                            continue;
                        }
                        if (!fun.isContact()) continue;
                        SeaOfGatesEngine.this.addVia(ERectangle.fromLambda(conRect), conLayer, this.netID, false);
                    }
                    possibleVias.finishedAddingEndpoints();
                    return false;
                }
            }
            String msg = "Route '" + this.routeName + "' at (" + TextUtils.formatDistance(pt.getX()) + "," + TextUtils.formatDistance(pt.getY()) + ") from port " + pi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(pi.getNodeInst()) + " cannot connect";
            if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() || SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                msg = msg + " (allowed to go";
                if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer()) {
                    msg = SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer() ? msg + " up/down" : msg + " down";
                } else if (SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                    msg = msg + " up";
                }
                msg = msg + " one layer)";
            }
            if (whatWasChecked.size() > 0) {
                boolean first = true;
                for (Integer m2 : whatWasChecked.keySet()) {
                    msg = first ? msg + " because" : msg + " and";
                    first = false;
                    Point invalidColors = (Point)contactInvalidColors.get(m2);
                    if (invalidColors != null) {
                        msg = msg + " no contact exists from metal-" + (realOffendingMetal + 1) + " mask color " + invalidColors.x + " to metal-" + (m2 + 1) + " mask color " + invalidColors.y;
                        continue;
                    }
                    msg = msg + " contact(s) cannot be placed:";
                    Map contacts = (Map)whatWasChecked.get(m2);
                    boolean firstPrim = true;
                    for (PrimitiveNode pNp : contacts.keySet()) {
                        ContactPlacementError cpe = (ContactPlacementError)contacts.get(pNp);
                        msg = firstPrim ? msg + " " : msg + " / ";
                        firstPrim = false;
                        msg = msg + cpe.getError(pNp);
                    }
                }
            } else {
                msg = msg + " because all connecting layers have been prevented by Routing Preferences";
            }
            SeaOfGatesEngine.this.error(msg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(new PolyBase(pt.getX(), pt.getY(), 0.0, 0.0));
            SeaOfGatesEngine.this.errorLogger.logMessageWithLines(msg, polyList, null, SeaOfGatesEngine.this.cell, 0, true);
            return true;
        }

        private boolean invalidPortOLD(boolean endA, boolean tap, PortInst pi) {
            EPoint pt = pi.getCenter();
            double conX = pt.getX();
            double conY = pt.getY();
            ArcProto[] conns = SeaOfGatesEngine.this.getPossibleConnections(pi.getPortProto());
            for (int j2 = 0; j2 < conns.length; ++j2) {
                ArcProto ap = conns[j2];
                if (ap.getTechnology() != SeaOfGatesEngine.this.tech || !ap.getFunction().isMetal() || this.preventArc(conns[j2].getFunction().getLevel() - 1)) continue;
                return false;
            }
            HashMap whatWasChecked = new HashMap();
            HashMap<Integer, Point> contactInvalidColors = new HashMap<Integer, Point>();
            int realOffendingMetal = 0;
            Boolean end = tap ? null : Boolean.valueOf(endA);
            double endCoord = 0.0;
            if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() || SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                for (int j3 = 0; j3 < conns.length; ++j3) {
                    HashMap<PrimitiveNode, ContactPlacementError> checkedThese;
                    SeaOfGates.SeaOfGatesTrack sogt;
                    ArcProto ap = conns[j3];
                    if (ap.getTechnology() != SeaOfGatesEngine.this.tech || !ap.getFunction().isMetal()) continue;
                    int offendingMetal = conns[j3].getFunction().getLevel() - 1;
                    int offendingMetalColor = conns[j3].getMaskLayer();
                    int newMetal = 0;
                    int newMetalColor = 0;
                    int lowerMetal = offendingMetal - 1;
                    int upperMetal = offendingMetal + 1;
                    List<MetalVia> mvs = null;
                    if (SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer() && lowerMetal >= 0 && !this.preventArc(lowerMetal)) {
                        mvs = SeaOfGatesEngine.this.metalVias[lowerMetal].getVias();
                        newMetal = lowerMetal;
                    }
                    if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() && upperMetal < numMetalLayers && !this.preventArc(upperMetal)) {
                        mvs = SeaOfGatesEngine.this.metalVias[upperMetal - 1].getVias();
                        newMetal = upperMetal;
                    }
                    if (mvs == null) continue;
                    boolean hor = true;
                    if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                        if (newMetal % 2 == 0) {
                            hor = false;
                        }
                    } else if (newMetal % 2 != 0) {
                        hor = false;
                    }
                    if ((sogt = hor ? this.getClosestYGrid(newMetal, conY) : this.getClosestXGrid(newMetal, conX)) != null) {
                        newMetalColor = sogt.getMaskNum();
                    }
                    if ((checkedThese = (HashMap<PrimitiveNode, ContactPlacementError>)whatWasChecked.get(newMetal)) == null) {
                        checkedThese = new HashMap<PrimitiveNode, ContactPlacementError>();
                        whatWasChecked.put(newMetal, checkedThese);
                    }
                    boolean hasContacts = false;
                    for (MetalVia mv : mvs) {
                        if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                        hasContacts = true;
                    }
                    if (!hasContacts) {
                        realOffendingMetal = offendingMetal;
                        contactInvalidColors.put(newMetal, new Point(offendingMetalColor, newMetalColor));
                    }
                    MetalVia viaToPlace = null;
                    double viaToPlaceX = 0.0;
                    double viaToPlaceY = 0.0;
                    double viaSizeX = 0.0;
                    double viaSizeY = 0.0;
                    Orientation viaOrient = Orientation.IDENT;
                    if (this.forceGridArcs[newMetal]) {
                        int index = 0;
                        int dir2 = 0;
                        if (hor) {
                            if (this.gridLocationsY[newMetal] != null) {
                                double otherY;
                                double d2 = otherY = endA ? this.bEndpoints.getCenterY() : this.aEndpoints.getCenterY();
                                if (otherY < conY) {
                                    sogt = this.getLowerYGrid(newMetal, conY);
                                    dir2 = -1;
                                } else {
                                    sogt = this.getUpperYGrid(newMetal, conY);
                                    dir2 = 1;
                                }
                                conY = sogt.getCoordinate();
                                newMetalColor = sogt.getMaskNum();
                                for (index = 0; index < this.gridLocationsY[newMetal].length && this.gridLocationsY[newMetal][index].getCoordinate() != conY; ++index) {
                                }
                            }
                        } else if (this.gridLocationsX[newMetal] != null) {
                            double otherX;
                            double d3 = otherX = endA ? this.bEndpoints.getCenterX() : this.aEndpoints.getCenterX();
                            if (otherX < conX) {
                                sogt = this.getLowerXGrid(newMetal, conX);
                                dir2 = -1;
                            } else {
                                sogt = this.getUpperXGrid(newMetal, conX);
                                dir2 = 1;
                            }
                            conX = sogt.getCoordinate();
                            newMetalColor = sogt.getMaskNum();
                            for (index = 0; index < this.gridLocationsX[newMetal].length && this.gridLocationsX[newMetal][index].getCoordinate() != conX; ++index) {
                            }
                        }
                        int startIndex = index;
                        endCoord = hor ? (endA ? this.bEndpoints.getCenterY() : this.aEndpoints.getCenterY()) : (endA ? this.bEndpoints.getCenterX() : this.aEndpoints.getCenterX());
                        while (true) {
                            boolean tooFar = false;
                            if (hor) {
                                if (dir2 < 0) {
                                    if (conY < endCoord) {
                                        tooFar = true;
                                    }
                                } else if (conY > endCoord) {
                                    tooFar = true;
                                }
                            } else if (dir2 < 0) {
                                if (conX < endCoord) {
                                    tooFar = true;
                                }
                            } else if (conX > endCoord) {
                                tooFar = true;
                            }
                            if (tooFar && viaToPlace != null) break;
                            for (MetalVia mv : mvs) {
                                if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                                PrimitiveNode np = mv.via;
                                MutableDouble conWid = new MutableDouble(0.0);
                                MutableDouble conHei = new MutableDouble(0.0);
                                Orientation orient = this.getMVSize(mv, conX, conY, conX, conY, conWid, conHei);
                                ContactPlacementError cpe = this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, end);
                                if (cpe != null) {
                                    if (checkedThese.get(np) != null) continue;
                                    checkedThese.put(np, cpe);
                                    continue;
                                }
                                viaToPlace = mv;
                                viaToPlaceX = conX;
                                viaToPlaceY = conY;
                                viaSizeX = conWid.doubleValue();
                                viaSizeY = conHei.doubleValue();
                                viaOrient = orient;
                                break;
                            }
                            index += dir2;
                            if (hor) {
                                if (index < 0 || index >= this.gridLocationsY[newMetal].length) break;
                                sogt = this.gridLocationsY[newMetal][index];
                                conY = sogt.getCoordinate();
                                newMetalColor = sogt.getMaskNum();
                                continue;
                            }
                            if (index < 0 || index >= this.gridLocationsX[newMetal].length) break;
                            sogt = this.gridLocationsX[newMetal][index];
                            conX = sogt.getCoordinate();
                            newMetalColor = sogt.getMaskNum();
                        }
                        if (viaToPlace == null) {
                            dir2 = -dir2;
                            index = startIndex + dir2;
                            while (true) {
                                if (hor) {
                                    if (index < 0 || index >= this.gridLocationsY[newMetal].length) break;
                                    sogt = this.gridLocationsY[newMetal][index];
                                    conY = sogt.getCoordinate();
                                    newMetalColor = sogt.getMaskNum();
                                } else {
                                    if (index < 0 || index >= this.gridLocationsX[newMetal].length) break;
                                    sogt = this.gridLocationsX[newMetal][index];
                                    conX = sogt.getCoordinate();
                                    newMetalColor = sogt.getMaskNum();
                                }
                                for (MetalVia mv : mvs) {
                                    if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                                    PrimitiveNode np = mv.via;
                                    MutableDouble conWid = new MutableDouble(0.0);
                                    MutableDouble conHei = new MutableDouble(0.0);
                                    Orientation orient = this.getMVSize(mv, conX, conY, conX, conY, conWid, conHei);
                                    ContactPlacementError cpe = this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, end);
                                    if (cpe != null) {
                                        if (checkedThese.get(np) != null) continue;
                                        checkedThese.put(np, cpe);
                                        continue;
                                    }
                                    viaToPlace = mv;
                                    viaToPlaceX = conX;
                                    viaToPlaceY = conY;
                                    viaSizeX = conWid.doubleValue();
                                    viaSizeY = conHei.doubleValue();
                                    viaOrient = orient;
                                    break;
                                }
                                if (viaToPlace == null) {
                                    index += dir2;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        for (MetalVia mv : mvs) {
                            if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                            PrimitiveNode np = mv.via;
                            MutableDouble conWid = new MutableDouble(0.0);
                            MutableDouble conHei = new MutableDouble(0.0);
                            Orientation orient = this.getMVSize(mv, conX, conY, conX, conY, conWid, conHei);
                            ContactPlacementError cpe = this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, end);
                            if (cpe != null) {
                                checkedThese.put(np, cpe);
                                continue;
                            }
                            viaToPlace = mv;
                            viaToPlaceX = conX;
                            viaToPlaceY = conY;
                            viaSizeX = conWid.doubleValue();
                            viaSizeY = conHei.doubleValue();
                            viaOrient = orient;
                            break;
                        }
                    }
                    if (viaToPlace == null) continue;
                    String msg = "Route '" + this.routeName + "' at (" + TextUtils.formatDistance(pt.getX()) + "," + TextUtils.formatDistance(pt.getY()) + ") from port " + pi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(pi.getNodeInst()) + " is disallowed on Metal " + (offendingMetal + 1) + " so inserting " + viaToPlace.via.describe(false);
                    if (!DBMath.areEquals(pt.getX(), viaToPlaceX) || !DBMath.areEquals(pt.getY(), viaToPlaceY)) {
                        msg = msg + " at (" + TextUtils.formatDistance(viaToPlaceX) + "," + TextUtils.formatDistance(viaToPlaceY) + ")";
                    }
                    msg = msg + " and routing from Metal " + (newMetal + 1);
                    SeaOfGatesEngine.this.warn(msg);
                    if (endA) {
                        dX = viaToPlaceX - this.aEndpoints.getCenterX();
                        dY = viaToPlaceY - this.aEndpoints.getCenterY();
                        this.aEndpoints.setCenterX(viaToPlaceX);
                        this.aEndpoints.setCenterY(viaToPlaceY);
                        pts = this.aPoly.getPoints();
                        for (int i2 = 0; i2 < pts.length; ++i2) {
                            pts[i2].setLocation(pts[i2].getX() + dX, pts[i2].getY() + dY);
                        }
                        this.aEndpoints.setRect(this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY(), 0.0, 0.0);
                        double aLX = this.getLowerXGrid(this.aZ, this.aEndpoints.getRect().getMinX()).getCoordinate();
                        double aHX = this.getUpperXGrid(this.aZ, this.aEndpoints.getRect().getMaxX()).getCoordinate();
                        double aLY = this.getLowerYGrid(this.aZ, this.aEndpoints.getRect().getMinY()).getCoordinate();
                        double aHY = this.getUpperYGrid(this.aZ, this.aEndpoints.getRect().getMaxY()).getCoordinate();
                        this.aEndpoints.setGriddedRect(aLX, aHX, aLY, aHY);
                        this.aZ = newMetal;
                        if (this.forceGridArcs[newMetal] && (sogt = hor ? this.getClosestYGrid(newMetal, this.aEndpoints.getCenterY()) : this.getClosestXGrid(newMetal, this.aEndpoints.getCenterX())) != null) {
                            newMetalColor = sogt.getMaskNum();
                        }
                        this.aC = newMetalColor;
                        this.jumpBound = new Rectangle2D.Double(Math.min(this.aEndpoints.getCenterX(), this.bEndpoints.getCenterX()), Math.min(this.aEndpoints.getCenterY(), this.bEndpoints.getCenterY()), Math.abs(this.aEndpoints.getCenterX() - this.bEndpoints.getCenterX()), Math.abs(this.aEndpoints.getCenterY() - this.bEndpoints.getCenterY()));
                        this.replaceA = new PossibleEndpoint(this.aEndpoints.getCenter(), viaToPlace, viaSizeX, viaSizeY, viaOrient);
                        this.replaceAZ = offendingMetal;
                        if (offendingMetalColor > 0) {
                            this.replaceAC = offendingMetalColor - 1;
                        }
                        this.aTaperWid = this.getUntaperedArcWidth(newMetal);
                        this.aTaperLen = -1.0;
                    } else {
                        dX = viaToPlaceX - this.bEndpoints.getCenterX();
                        dY = viaToPlaceY - this.bEndpoints.getCenterY();
                        this.bEndpoints.setCenterX(viaToPlaceX);
                        this.bEndpoints.setCenterY(viaToPlaceY);
                        pts = this.bPoly.getPoints();
                        for (int i3 = 0; i3 < pts.length; ++i3) {
                            pts[i3].setLocation(pts[i3].getX() + dX, pts[i3].getY() + dY);
                        }
                        this.bEndpoints.setRect(this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY(), 0.0, 0.0);
                        double bLX = this.getLowerXGrid(this.bZ, this.bEndpoints.getRect().getMinX()).getCoordinate();
                        double bHX = this.getUpperXGrid(this.bZ, this.bEndpoints.getRect().getMaxX()).getCoordinate();
                        double bLY = this.getLowerYGrid(this.bZ, this.bEndpoints.getRect().getMinY()).getCoordinate();
                        double bHY = this.getUpperYGrid(this.bZ, this.bEndpoints.getRect().getMaxY()).getCoordinate();
                        this.bEndpoints.setGriddedRect(bLX, bHX, bLY, bHY);
                        this.bZ = newMetal;
                        if (this.forceGridArcs[newMetal] && (sogt = hor ? this.getClosestYGrid(newMetal, this.bEndpoints.getCenterY()) : this.getClosestXGrid(newMetal, this.bEndpoints.getCenterX())) != null) {
                            newMetalColor = sogt.getMaskNum();
                        }
                        this.bC = newMetalColor;
                        this.jumpBound = new Rectangle2D.Double(Math.min(this.aEndpoints.getCenterX(), this.bEndpoints.getCenterX()), Math.min(this.aEndpoints.getCenterY(), this.bEndpoints.getCenterY()), Math.abs(this.aEndpoints.getCenterX() - this.bEndpoints.getCenterX()), Math.abs(this.aEndpoints.getCenterY() - this.bEndpoints.getCenterY()));
                        this.replaceB = new PossibleEndpoint(this.bEndpoints.getCenter(), viaToPlace, viaSizeX, viaSizeY, viaOrient);
                        this.replaceBZ = offendingMetal;
                        if (offendingMetalColor > 0) {
                            this.replaceBC = offendingMetalColor - 1;
                        }
                        this.bTaperWid = this.getUntaperedArcWidth(newMetal);
                        this.bTaperLen = -1.0;
                    }
                    NodeInst dummyNi = NodeInst.makeDummyInstance(viaToPlace.via, SeaOfGatesEngine.this.ep, EPoint.fromLambda(viaToPlaceX, viaToPlaceY), viaSizeX, viaSizeY, viaOrient);
                    Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                    FixpTransform trans = null;
                    if (viaOrient != Orientation.IDENT) {
                        trans = dummyNi.rotateOut();
                    }
                    for (int p = 0; p < conPolys.length; ++p) {
                        Poly conPoly = conPolys[p];
                        Layer conLayer = conPoly.getLayer();
                        if (trans != null) {
                            conPoly.transform(trans);
                        }
                        FixpRectangle conRect = conPoly.getBounds2D();
                        Layer.Function fun = conLayer.getFunction();
                        if (fun.isMetal()) {
                            SeaOfGatesEngine.this.addRectangle(conRect, conLayer, this.netID, false, false);
                            continue;
                        }
                        if (!fun.isContact()) continue;
                        SeaOfGatesEngine.this.addVia(ERectangle.fromLambda(conRect), conLayer, this.netID, false);
                    }
                    return false;
                }
            }
            String msg = "Route '" + this.routeName + "' at (" + TextUtils.formatDistance(pt.getX()) + "," + TextUtils.formatDistance(pt.getY()) + ") from port " + pi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(pi.getNodeInst()) + " cannot connect";
            if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() || SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                msg = msg + " (allowed to go";
                if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer()) {
                    msg = SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer() ? msg + " up/down" : msg + " down";
                } else if (SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                    msg = msg + " up";
                }
                msg = msg + " one layer)";
            }
            if (whatWasChecked.size() > 0) {
                boolean first = true;
                for (Integer m2 : whatWasChecked.keySet()) {
                    msg = first ? msg + " because" : msg + " and";
                    first = false;
                    Point invalidColors = (Point)contactInvalidColors.get(m2);
                    if (invalidColors != null) {
                        msg = msg + " no contact exists from metal-" + (realOffendingMetal + 1) + " mask color " + invalidColors.x + " to metal-" + (m2 + 1) + " mask color " + invalidColors.y;
                        continue;
                    }
                    msg = msg + " contact(s) cannot be placed:";
                    Map contacts = (Map)whatWasChecked.get(m2);
                    boolean firstPrim = true;
                    for (PrimitiveNode pNp : contacts.keySet()) {
                        ContactPlacementError cpe = (ContactPlacementError)contacts.get(pNp);
                        msg = firstPrim ? msg + " " : msg + " / ";
                        firstPrim = false;
                        msg = msg + cpe.getError(pNp);
                    }
                }
            } else {
                msg = msg + " because all connecting layers have been prevented by Routing Preferences";
            }
            SeaOfGatesEngine.this.error(msg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(new PolyBase(pt.getX(), pt.getY(), 0.0, 0.0));
            SeaOfGatesEngine.this.errorLogger.logMessageWithLines(msg, polyList, null, SeaOfGatesEngine.this.cell, 0, true);
            return true;
        }

        private double getTaperWidth(PortInst pi, int metalNo) {
            PortProto pp = pi.getPortProto();
            NodeInst ni = pi.getNodeInst();
            FixpTransform trans = ni.rotateOut();
            while (ni.isCellInstance()) {
                Export e2 = (Export)pp;
                ni = e2.getOriginalPort().getNodeInst();
                pp = e2.getOriginalPort().getPortProto();
                trans.concatenate(ni.rotateOut());
            }
            Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
            for (int i2 = 0; i2 < polys.length; ++i2) {
                Poly poly = polys[i2];
                boolean found = false;
                for (int j2 = 0; j2 < SeaOfGatesEngine.this.metalLayers[metalNo].length; ++j2) {
                    if (SeaOfGatesEngine.this.metalLayers[metalNo][j2] != poly.getLayer()) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                poly.transform(trans);
                FixpRectangle rect = poly.getBounds2D();
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isForceHorVer()) {
                    if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                        if (metalNo % 2 == 0) {
                            hor = false;
                        }
                    } else if (metalNo % 2 != 0) {
                        hor = false;
                    }
                    if (hor) {
                        return rect.getHeight();
                    }
                    return rect.getWidth();
                }
                return Math.min(rect.getWidth(), rect.getHeight());
            }
            return this.getUntaperedArcWidth(metalNo);
        }

        public void makeWavefronts() {
            this.dirAtoB = new Wavefront(this, this.aPi, this.aEndpoints.getRect(), this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY(), this.aZ, this.aC, this.aTaperLen, 2, this.bPi, this.bEndpoints, this.bZ, this.bC, this.bTaperLen, 1, true, this.debuggingRouteFromA != null && this.debuggingRouteFromA != false);
            this.dirBtoA = new Wavefront(this, this.bPi, this.bEndpoints.getRect(), this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY(), this.bZ, this.bC, this.bTaperLen, 4, this.aPi, this.aEndpoints, this.aZ, this.aC, this.aTaperLen, -1, false, this.debuggingRouteFromA != null && this.debuggingRouteFromA == false);
        }

        public void setBatchInfo(RouteBatch batch, int routeInBatch) {
            this.batch = batch;
            this.routeInBatch = routeInBatch;
        }

        public int getNumInBatch() {
            return this.batch.routesInBatch.size();
        }

        public int getRouteInBatch() {
            return this.routeInBatch;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public void setNetID(MutableInteger id) {
            this.netID = id;
        }

        private void setNetID(Network net) {
            Integer netIDI = SeaOfGatesEngine.this.netIDs.get(net);
            assert (netIDI != null);
            this.netID = new MutableInteger(netIDI);
            List<MutableInteger> theseNetIDs = SeaOfGatesEngine.this.netIDsByValue.get(netIDI);
            if (theseNetIDs == null) {
                theseNetIDs = new ArrayList<MutableInteger>();
                SeaOfGatesEngine.this.netIDsByValue.put(netIDI, theseNetIDs);
            }
            theseNetIDs.add(this.netID);
        }

        public boolean is2X(int metNum, double fX, double fY, double tX, double tY) {
            double wid;
            return SeaOfGatesEngine.this.size2X[metNum] != 0.0 && (wid = this.getArcWidth(metNum, fX, fY, tX, tY)) >= SeaOfGatesEngine.this.size2X[metNum];
        }

        public double getArcWidth(int metNum, double fX, double fY, double tX, double tY) {
            Boolean hor = null;
            if (SeaOfGatesEngine.this.sogp.isForceHorVer()) {
                hor = Boolean.TRUE;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 == 0) {
                        hor = Boolean.FALSE;
                    }
                } else if (metNum % 2 != 0) {
                    hor = Boolean.FALSE;
                }
            }
            boolean foundATaper = false;
            boolean foundBTaper = false;
            if (this.aZ == metNum) {
                if (hor == null || hor.booleanValue()) {
                    if (DBMath.areEquals(fY, this.aEndpoints.getCenterY()) && (this.aTaperLen < 0.0 || Math.abs(fX - this.aEndpoints.getCenterX()) < this.aTaperLen)) {
                        foundATaper = true;
                    }
                    if (DBMath.areEquals(tY, this.aEndpoints.getCenterY()) && (this.aTaperLen < 0.0 || Math.abs(tX - this.aEndpoints.getCenterX()) < this.aTaperLen)) {
                        foundATaper = true;
                    }
                }
                if (hor == null || !hor.booleanValue()) {
                    if (DBMath.areEquals(fX, this.aEndpoints.getCenterX()) && (this.aTaperLen < 0.0 || Math.abs(fY - this.aEndpoints.getCenterY()) < this.aTaperLen)) {
                        foundATaper = true;
                    }
                    if (DBMath.areEquals(tX, this.aEndpoints.getCenterX()) && (this.aTaperLen < 0.0 || Math.abs(tY - this.aEndpoints.getCenterY()) < this.aTaperLen)) {
                        foundATaper = true;
                    }
                }
            }
            if (this.bZ == metNum) {
                if (hor == null || hor.booleanValue()) {
                    if (DBMath.areEquals(fY, this.bEndpoints.getCenterY()) && (this.bTaperLen < 0.0 || Math.abs(fX - this.bEndpoints.getCenterX()) < this.bTaperLen)) {
                        foundBTaper = true;
                    }
                    if (DBMath.areEquals(tY, this.bEndpoints.getCenterY()) && (this.bTaperLen < 0.0 || Math.abs(tX - this.bEndpoints.getCenterX()) < this.bTaperLen)) {
                        foundBTaper = true;
                    }
                }
                if (hor == null || !hor.booleanValue()) {
                    if (DBMath.areEquals(fX, this.bEndpoints.getCenterX()) && (this.bTaperLen < 0.0 || Math.abs(fY - this.bEndpoints.getCenterY()) < this.bTaperLen)) {
                        foundBTaper = true;
                    }
                    if (DBMath.areEquals(tX, this.bEndpoints.getCenterX()) && (this.bTaperLen < 0.0 || Math.abs(tY - this.bEndpoints.getCenterY()) < this.bTaperLen)) {
                        foundBTaper = true;
                    }
                }
            }
            if (foundATaper && foundBTaper) {
                return Math.max(this.aTaperWid, this.bTaperWid);
            }
            if (foundATaper) {
                return this.aTaperWid;
            }
            if (foundBTaper) {
                return this.bTaperWid;
            }
            return this.getUntaperedArcWidth(metNum);
        }

        public double getUntaperedArcWidth(int metNum) {
            if (this.overrideMetalWidth != null) {
                return this.overrideMetalWidth[metNum];
            }
            double width = Math.max(SeaOfGatesEngine.this.maxDefArcWidth[metNum], this.minWidth);
            return width;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public double[] getSpacingRule(int layer, double width, double length) {
            Double wid;
            Map<Double, double[]> widMap;
            if (this.overrideMetalSpacings[layer] != null) {
                return this.overrideMetalSpacings[layer];
            }
            if (width < 0.0) {
                width = SeaOfGatesEngine.this.maxDefArcWidth[layer];
            }
            if (length < 0.0) {
                length = 50.0;
            }
            if ((widMap = SeaOfGatesEngine.this.layerSurround[layer].get(wid = Double.valueOf(width))) == null) {
                Map<Double, Map<Double, double[]>>[] mapArray = SeaOfGatesEngine.this.layerSurround;
                // MONITORENTER : SeaOfGatesEngine.this.layerSurround
                widMap = SeaOfGatesEngine.this.layerSurround[layer].get(wid);
                if (widMap == null) {
                    widMap = new HashMap<Double, double[]>();
                    SeaOfGatesEngine.this.layerSurround[layer].put(wid, widMap);
                }
                // MONITOREXIT : mapArray
            }
            Double len = length;
            double[] value = new double[2];
            double[] cachedValue = widMap.get(len);
            if (cachedValue != null) {
                value[0] = cachedValue[0];
                value[1] = cachedValue[1];
            } else {
                value[0] = 0.0;
                value[1] = -1.0;
                for (int c2 = 0; c2 < SeaOfGatesEngine.this.metalLayers[layer].length; ++c2) {
                    Layer lay = SeaOfGatesEngine.this.metalLayers[layer][c2];
                    DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, width, length);
                    if (rule == null) continue;
                    value[0] = Math.max(value[0], rule.getValue(0));
                    if (rule.getNumValues() <= 1) continue;
                    value[1] = Math.max(value[1], rule.getValue(1));
                }
                if (value[1] < 0.0) {
                    value[1] = value[0];
                }
                widMap.put(len, value);
            }
            if (this.overrideMetalSpacingX != null) {
                value[0] = this.overrideMetalSpacingX[layer];
            }
            if (this.overrideMetalSpacingY == null) return value;
            value[1] = this.overrideMetalSpacingY[layer];
            return value;
        }

        public boolean preventArc(int metNum) {
            if (this.overridePreventArcs != null) {
                return this.overridePreventArcs[metNum];
            }
            return SeaOfGatesEngine.this.preventArcs[metNum];
        }

        public String getName() {
            return this.routeName;
        }

        public Rectangle2D getBounds() {
            return this.routeBounds;
        }

        public PortInst getAPort() {
            return this.aPi;
        }

        public PortInst getBPort() {
            return this.bPi;
        }

        public double getAX() {
            return this.aEndpoints.getCenterX();
        }

        public double getAY() {
            return this.aEndpoints.getCenterY();
        }

        public double getBX() {
            return this.bEndpoints.getCenterX();
        }

        public double getBY() {
            return this.bEndpoints.getCenterY();
        }

        public RTNode<SOGBound> getViaTree(Layer lay) {
            return SeaOfGatesEngine.this.rTrees.getViaTree(lay).getRoot();
        }

        public Iterator<SOGBound> searchViaTree(Layer lay, Rectangle2D bound) {
            return SeaOfGatesEngine.this.rTrees.getViaTree(lay).search(bound);
        }

        public Rectangle2D[] getGRBuckets() {
            return this.buckets;
        }

        public boolean checkEndSurround() {
            double[] toSurround;
            double toMetalSpacing;
            double[] fromSurround;
            double fromMetalSpacing = this.getArcWidth(this.aZ, this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY(), this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY()) / 2.0;
            SOGBound block = this.getMetalBlockage(this.netID, this.aZ, this.aC, fromMetalSpacing, fromMetalSpacing, fromSurround = this.getSpacingRule(this.aZ, SeaOfGatesEngine.this.maxDefArcWidth[this.aZ], -1.0), this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY());
            if (block != null && !SeaOfGatesEngine.this.sogp.isGridForced(SeaOfGatesEngine.this.primaryMetalArc[this.aZ])) {
                FixpRectangle fromRect = this.aPoly.getBounds2D();
                double stepSize = fromMetalSpacing + Math.max(fromSurround[0], fromSurround[1]);
                if (stepSize > 0.0 && (((RectangularShape)fromRect).getWidth() > 0.0 || ((RectangularShape)fromRect).getHeight() > 0.0)) {
                    for (double x = ((RectangularShape)fromRect).getMinX(); x <= ((RectangularShape)fromRect).getMaxX(); x += stepSize) {
                        for (double y = ((RectangularShape)fromRect).getMinY(); y <= ((RectangularShape)fromRect).getMaxY(); y += stepSize) {
                            SOGBound stepBlock = this.getMetalBlockage(this.netID, this.aZ, this.aC, fromMetalSpacing, fromMetalSpacing, fromSurround, x, y);
                            if (stepBlock != null) continue;
                            this.aEndpoints.setCenterX(x);
                            this.aEndpoints.setCenterY(y);
                            block = null;
                            break;
                        }
                        if (block == null) break;
                    }
                }
                if (block != null) {
                    String errorMsg = "Cannot route from port " + this.aPi.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.aPi.getNodeInst()) + " at (" + TextUtils.formatDistance(this.aEndpoints.getCenterX()) + "," + TextUtils.formatDistance(this.aEndpoints.getCenterY()) + ") because it is blocked on layer " + SeaOfGatesEngine.describeMetal(this.aZ, this.aC) + " [needs " + TextUtils.formatDistance(fromMetalSpacing + Math.max(fromSurround[0], fromSurround[1])) + " all around, blockage is " + TextUtils.formatDistance(block.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(block.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.getBounds().getMaxY()) + " on net " + String.valueOf(block.getNetID()) + " but routing net " + String.valueOf(this.netID) + "]";
                    if (this.reroute) {
                        errorMsg = "(Retry) " + errorMsg;
                    }
                    SeaOfGatesEngine.this.error(errorMsg);
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY(), (fromMetalSpacing + fromSurround[0]) * 2.0, (fromMetalSpacing + fromSurround[1]) * 2.0));
                    polyList.add(new PolyBase(block.getBounds()));
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMinY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, SeaOfGatesEngine.this.cell, 0, true);
                    return true;
                }
            }
            if ((block = this.getMetalBlockage(this.netID, this.bZ, this.bC, toMetalSpacing = this.getArcWidth(this.bZ, this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY(), this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY()) / 2.0, toMetalSpacing, toSurround = this.getSpacingRule(this.bZ, SeaOfGatesEngine.this.maxDefArcWidth[this.bZ], -1.0), this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY())) != null && !SeaOfGatesEngine.this.sogp.isGridForced(SeaOfGatesEngine.this.primaryMetalArc[this.bZ])) {
                FixpRectangle toRect = this.bPoly.getBounds2D();
                double stepSize = toMetalSpacing + Math.max(toSurround[0], toSurround[1]);
                if (stepSize > 0.0 && (((RectangularShape)toRect).getWidth() > 0.0 || ((RectangularShape)toRect).getHeight() > 0.0)) {
                    for (double x = ((RectangularShape)toRect).getMinX(); x <= ((RectangularShape)toRect).getMaxX(); x += stepSize) {
                        for (double y = ((RectangularShape)toRect).getMinY(); y <= ((RectangularShape)toRect).getMaxY(); y += stepSize) {
                            SOGBound stepBlock = this.getMetalBlockage(this.netID, this.bZ, this.bC, toMetalSpacing, toMetalSpacing, toSurround, x, y);
                            if (stepBlock != null) continue;
                            this.bEndpoints.setCenterX(x);
                            this.bEndpoints.setCenterY(y);
                            block = null;
                            break;
                        }
                        if (block == null) break;
                    }
                }
                if (block != null) {
                    String errorMsg = "Cannot route to port " + this.bPi.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.bPi.getNodeInst()) + " at (" + TextUtils.formatDistance(this.bEndpoints.getCenterX()) + "," + TextUtils.formatDistance(this.bEndpoints.getCenterY()) + ") because it is blocked on layer " + SeaOfGatesEngine.describeMetal(this.bZ, this.bC) + " [needs " + TextUtils.formatDistance(toMetalSpacing + Math.max(toSurround[0], toSurround[1])) + " all around, blockage is " + TextUtils.formatDistance(block.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(block.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.getBounds().getMaxY()) + " on net " + String.valueOf(block.getNetID()) + " but routing net " + String.valueOf(this.netID) + "]";
                    if (this.reroute) {
                        errorMsg = "(Retry) " + errorMsg;
                    }
                    SeaOfGatesEngine.this.error(errorMsg);
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY(), (toMetalSpacing + toSurround[0]) * 2.0, (toMetalSpacing + toSurround[1]) * 2.0));
                    polyList.add(new PolyBase(block.getBounds()));
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMinY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, SeaOfGatesEngine.this.cell, 0, true);
                    return true;
                }
            }
            return false;
        }

        private void growNetwork() {
            Iterator<SOGBound> it;
            Iterator<SOGBound> it2;
            this.extractList = new HashMap<SOGBound, Integer>();
            MutableInteger miA = new MutableInteger(this.netID.intValue() | 2);
            MutableInteger miB = new MutableInteger(this.netID.intValue() | 4);
            this.growPoint(this.aEndpoints.getCenterX(), this.aEndpoints.getCenterY(), this.aZ, miA);
            while ((it2 = this.extractList.keySet().iterator()).hasNext()) {
                SOGBound sBound = it2.next();
                Integer layerNumInt = this.extractList.get(sBound);
                this.extractList.remove(sBound);
                this.growArea(sBound, layerNumInt, sBound.getNetID());
            }
            boolean alreadyDone = this.growPoint(this.bEndpoints.getCenterX(), this.bEndpoints.getCenterY(), this.bZ, miB);
            if (alreadyDone) {
                this.alreadyRouted = true;
            }
            if (this.spineTaps != null) {
                for (PortInst pi : this.spineTaps) {
                    ArcProto ap = SeaOfGatesEngine.this.getMetalArcOnPort(pi);
                    if (ap == null) continue;
                    int z = ap.getFunction().getLevel() - 1;
                    EPoint pt = pi.getCenter();
                    this.growPoint(pt.getX(), pt.getY(), z, this.netID);
                }
            }
            while ((it = this.extractList.keySet().iterator()).hasNext()) {
                SOGBound sBound = it.next();
                Integer layerNumInt = this.extractList.get(sBound);
                this.extractList.remove(sBound);
                this.growArea(sBound, layerNumInt, sBound.getNetID());
            }
            this.extractList = null;
        }

        private boolean growPoint(double x, double y, int layerNum, MutableInteger idNumber) {
            Rectangle2D.Double search = new Rectangle2D.Double(x, y, 0.0, 0.0);
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[layerNum]);
            if (bTree.isEmpty()) {
                return false;
            }
            boolean foundNet = false;
            Iterator<SOGBound> sea = bTree.search(search);
            while (sea.hasNext()) {
                SOGBound sBound = sea.next();
                if (sBound.isUserSuppliedBlockage() || !sBound.containsPoint(x, y)) continue;
                if (sBound.getNetID() == null) {
                    sBound.setNetID(idNumber);
                    if (this.extractList.get(sBound) != null) continue;
                    this.extractList.put(sBound, layerNum);
                    ++SeaOfGatesEngine.this.blockagesFound;
                    if (SeaOfGatesEngine.this.blockagesFound % 100 != 0) continue;
                    SeaOfGatesEngine.this.setProgressValue(SeaOfGatesEngine.this.blockagesFound, SeaOfGatesEngine.this.totalBlockages);
                    continue;
                }
                if (sBound.isSameBasicNet(idNumber)) {
                    foundNet = true;
                }
                sBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
            }
            return foundNet;
        }

        private void growArea(SOGBound sBound, int layerNum, MutableInteger idNumber) {
            SOGVia subBound;
            Iterator<SOGBound> sea;
            BlockageTree viaTree;
            BlockageTree metalTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[layerNum]);
            ERectangle bound = sBound.getBounds();
            Iterator<SOGBound> sea2 = metalTree.search(bound);
            while (sea2.hasNext()) {
                SOGBound subBound2 = sea2.next();
                if (subBound2.isUserSuppliedBlockage() || (sBound instanceof SOGPoly || subBound2 instanceof SOGPoly) && !this.doesIntersect(sBound, subBound2)) continue;
                if (subBound2.getNetID() == null) {
                    subBound2.setNetID(idNumber);
                    if (this.extractList.get(subBound2) != null) continue;
                    this.extractList.put(subBound2, layerNum);
                    ++SeaOfGatesEngine.this.blockagesFound;
                    if (SeaOfGatesEngine.this.blockagesFound % 100 != 0) continue;
                    SeaOfGatesEngine.this.setProgressValue(SeaOfGatesEngine.this.blockagesFound, SeaOfGatesEngine.this.totalBlockages);
                    continue;
                }
                subBound2.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
            }
            if (layerNum > 0 && !(viaTree = SeaOfGatesEngine.this.rTrees.getViaTree(SeaOfGatesEngine.this.viaLayers[layerNum - 1])).isEmpty()) {
                sea = viaTree.search(bound);
                while (sea.hasNext()) {
                    subBound = (SOGVia)sea.next();
                    if (sBound instanceof SOGPoly && !this.doesIntersect(sBound, subBound)) continue;
                    if (subBound.getNetID() == null) {
                        subBound.setNetID(idNumber);
                        this.growPoint(subBound.getBounds().getCenterX(), subBound.getBounds().getCenterY(), layerNum - 1, idNumber);
                        continue;
                    }
                    subBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
                }
            }
            if (layerNum < numMetalLayers - 1) {
                BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(SeaOfGatesEngine.this.viaLayers[layerNum]);
                sea = bTree.search(bound);
                while (sea.hasNext()) {
                    subBound = (SOGVia)sea.next();
                    if (sBound instanceof SOGPoly && !this.doesIntersect(sBound, subBound)) continue;
                    if (subBound.getNetID() == null) {
                        subBound.setNetID(idNumber);
                        this.growPoint(subBound.getBounds().getCenterX(), subBound.getBounds().getCenterY(), layerNum + 1, idNumber);
                        continue;
                    }
                    subBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
                }
            }
        }

        private boolean doesIntersect(SOGBound bound1, SOGBound bound2) {
            EPoint[] points2;
            EPoint[] points1;
            if (!bound1.isManhattan() || !bound2.isManhattan()) {
                return true;
            }
            if (bound1 instanceof SOGPoly) {
                SOGPoly p = (SOGPoly)bound1;
                PolyBase.Point[] po = p.poly.getPoints();
                points1 = new EPoint[po.length];
                for (int i2 = 0; i2 < po.length; ++i2) {
                    points1[i2] = EPoint.fromLambda(po[i2].getX(), po[i2].getY());
                }
            } else {
                points1 = new EPoint[5];
                ERectangle r = bound1.getBounds();
                points1[0] = EPoint.fromLambda(r.getMinX(), r.getMinY());
                points1[1] = EPoint.fromLambda(r.getMinX(), r.getMaxY());
                points1[2] = EPoint.fromLambda(r.getMaxX(), r.getMaxY());
                points1[3] = EPoint.fromLambda(r.getMaxX(), r.getMinY());
                points1[4] = EPoint.fromLambda(r.getMinX(), r.getMinY());
            }
            if (bound2 instanceof SOGPoly) {
                SOGPoly p = (SOGPoly)bound2;
                PolyBase.Point[] po = p.poly.getPoints();
                points2 = new EPoint[po.length];
                for (int i3 = 0; i3 < po.length; ++i3) {
                    points2[i3] = EPoint.fromLambda(po[i3].getX(), po[i3].getY());
                }
            } else {
                points2 = new EPoint[5];
                ERectangle r = bound2.getBounds();
                points2[0] = EPoint.fromLambda(r.getMinX(), r.getMinY());
                points2[1] = EPoint.fromLambda(r.getMinX(), r.getMaxY());
                points2[2] = EPoint.fromLambda(r.getMaxX(), r.getMaxY());
                points2[3] = EPoint.fromLambda(r.getMaxX(), r.getMinY());
                points2[4] = EPoint.fromLambda(r.getMinX(), r.getMinY());
            }
            for (int i4 = 1; i4 < points1.length; ++i4) {
                EPoint p1a = points1[i4 - 1];
                EPoint p1b = points1[i4];
                if (p1a.getX() == p1b.getX() && p1a.getY() == p1b.getY()) continue;
                double l1X = Math.min(p1a.getX(), p1b.getX());
                double h1X = Math.max(p1a.getX(), p1b.getX());
                double l1Y = Math.min(p1a.getY(), p1b.getY());
                double h1Y = Math.max(p1a.getY(), p1b.getY());
                for (int j2 = 1; j2 < points2.length; ++j2) {
                    EPoint p2a = points2[j2 - 1];
                    EPoint p2b = points2[j2];
                    if (p2a.getX() == p2b.getX() && p2a.getY() == p2b.getY()) continue;
                    double l2X = Math.min(p2a.getX(), p2b.getX());
                    double h2X = Math.max(p2a.getX(), p2b.getX());
                    double l2Y = Math.min(p2a.getY(), p2b.getY());
                    double h2Y = Math.max(p2a.getY(), p2b.getY());
                    if (!(l1X == h1X ? (l2X == h2X ? l1X == l2X && h1Y > l2Y && h2Y > l1Y : l1X > l2X && l1X < h2X && l2Y > l1Y && l2Y < h1Y) : (l2Y == h2Y ? l1Y == l2Y && h1X > l2X && h2X > l1X : l1Y > l2Y && l1Y < h2Y && l2X > l1X && l2X < h1X))) continue;
                    return true;
                }
            }
            Poly p1 = new Poly(points1);
            if (p1.contains(points2[0])) {
                return true;
            }
            Poly p2 = new Poly(points2);
            return p2.contains(points1[0]);
        }

        private void addBlockagesAtPorts(PortInst pi) {
            MutableInteger netIDUse = new MutableInteger(this.netID.intValue() + 1);
            Poly poly = pi.getPoly();
            FixpRectangle portBounds = poly.getBounds2D();
            ArcProto[] poss = SeaOfGatesEngine.this.getPossibleConnections(pi.getPortProto());
            int lowMetal = -1;
            int highMetal = -1;
            for (int i2 = 0; i2 < poss.length; ++i2) {
                if (poss[i2].getTechnology() != SeaOfGatesEngine.this.tech || !poss[i2].getFunction().isMetal()) continue;
                int level = poss[i2].getFunction().getLevel();
                if (lowMetal < 0) {
                    lowMetal = highMetal = level;
                    continue;
                }
                lowMetal = Math.min(lowMetal, level);
                highMetal = Math.max(highMetal, level);
            }
            if (lowMetal < 0) {
                return;
            }
            double x = pi.getCenter().getX();
            double y = pi.getCenter().getY();
            HashMap<Layer, ArrayList<Rectangle2D.Double>> blockageRects = new HashMap<Layer, ArrayList<Rectangle2D.Double>>();
            for (int via = lowMetal - 2; via < highMetal; ++via) {
                List<MetalVia> mvs2X;
                if (via < 0 || via >= numMetalLayers - 1) continue;
                List<MetalVia> mvs = SeaOfGatesEngine.this.metalVias[via].getVias();
                if ((this.is2X(via, x, y, x, y) || via + 1 < numMetalLayers && this.is2X(via + 1, x, y, x, y)) && (mvs2X = SeaOfGatesEngine.this.metalVias2X[via].getVias()).size() > 0) {
                    mvs = mvs2X;
                }
                int upper = mvs.size();
                for (int j2 = 0; j2 < upper; ++j2) {
                    MetalVia mv = mvs.get(j2);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, this.minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, this.minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummy);
                    for (int i3 = 0; i3 < polys.length; ++i3) {
                        Poly metalPoly = polys[i3];
                        Layer layer = metalPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        FixpRectangle metalBounds = metalPoly.getBounds2D();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(((RectangularShape)metalBounds).getMinX() + ((RectangularShape)portBounds).getCenterX(), ((RectangularShape)metalBounds).getMinY() + ((RectangularShape)portBounds).getCenterY(), ((RectangularShape)metalBounds).getWidth(), ((RectangularShape)metalBounds).getHeight());
                        int layNum = layer.getFunction().getLevel() - 1;
                        boolean hor = true;
                        if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                            if (layNum % 2 == 0) {
                                hor = false;
                            }
                        } else if (layNum % 2 != 0) {
                            hor = false;
                        }
                        if (this.forceGridArcs[layNum] && (hor ? !this.isOnYGrid(layNum, bounds.getCenterY()) : !this.isOnXGrid(layNum, bounds.getCenterX()))) continue;
                        boolean free = true;
                        BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(layer);
                        if (!bTree.isEmpty()) {
                            Iterator<SOGBound> sea = bTree.search(bounds);
                            while (sea.hasNext()) {
                                SOGBound sBound = sea.next();
                                int netValue = 0;
                                if (sBound.getNetID() != null) {
                                    netValue = sBound.getNetID().intValue();
                                }
                                if (netValue != this.netID.intValue() || sBound.getBounds().getMinX() > bounds.getMinX() || sBound.getBounds().getMaxX() < bounds.getMaxX() || sBound.getBounds().getMinY() > bounds.getMinY() || sBound.getBounds().getMaxY() < bounds.getMaxY()) continue;
                                free = false;
                                break;
                            }
                        }
                        if (!free) continue;
                        ArrayList<Rectangle2D.Double> rects = (ArrayList<Rectangle2D.Double>)blockageRects.get(layer);
                        if (rects == null) {
                            rects = new ArrayList<Rectangle2D.Double>();
                            blockageRects.put(layer, rects);
                        }
                        rects.add(bounds);
                    }
                }
            }
            for (Layer layer : blockageRects.keySet()) {
                List rects = (List)blockageRects.get(layer);
                for (int i4 = 0; i4 < rects.size(); ++i4) {
                    Rectangle2D bound1 = (Rectangle2D)rects.get(i4);
                    for (int j3 = 0; j3 < rects.size(); ++j3) {
                        if (j3 == i4) continue;
                        Rectangle2D bound2 = (Rectangle2D)rects.get(j3);
                        if (!(bound1.getMinX() <= bound2.getMinX()) || !(bound1.getMaxX() >= bound2.getMaxX()) || !(bound1.getMinY() <= bound2.getMinY()) || !(bound1.getMaxY() >= bound2.getMaxY())) continue;
                        rects.remove(j3);
                        if (i4 > j3) {
                            --i4;
                        }
                        --j3;
                    }
                }
                for (Rectangle2D bounds : rects) {
                    List<SOGBound> blocksOnLayer;
                    SOGBound rtn = SeaOfGatesEngine.this.addRectangle(bounds, layer, netIDUse, false, false);
                    if (this.endBlockages == null) {
                        this.endBlockages = new HashMap<Layer, List<SOGBound>>();
                    }
                    if ((blocksOnLayer = this.endBlockages.get(layer)) == null) {
                        blocksOnLayer = new ArrayList<SOGBound>();
                        this.endBlockages.put(layer, blocksOnLayer);
                    }
                    blocksOnLayer.add(rtn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SOGBound getMetalBlockage(MutableInteger netID, int metNo, int maskColor, double halfWidth, double halfHeight, double[] surround, double x, double y) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[metNo]);
            bTree.lock();
            try {
                double lX = x - halfWidth - surround[0];
                double hX = x + halfWidth + surround[0];
                double lY = y - halfHeight - surround[1];
                double hY = y + halfHeight + surround[1];
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                Iterator<SOGBound> sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    PolyBase poly;
                    SOGBound sBound = sea.next();
                    ERectangle bound = sBound.getBounds();
                    if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lX) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hX) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lY) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hY) || sBound.getMaskColor() == maskColor && netID != null && sBound.isSameBasicNet(netID) || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
                    SOGBound sOGBound = sBound;
                    return sOGBound;
                }
                SOGBound sOGBound = null;
                return sOGBound;
            }
            finally {
                bTree.unlock();
            }
        }

        public void completeRoute(SearchVertex result) {
            if (result.wf != null) {
                result.wf.vertices = new ArrayList<SearchVertex>();
                SeaOfGatesEngine.this.getOptimizedList(result, result.wf.vertices);
                assert (!result.wf.vertices.isEmpty());
                if (this.spineTaps != null) {
                    for (PortInst pi : this.spineTaps) {
                        EPoint pt = pi.getCenter();
                        SearchVertex lastSV = result.wf.vertices.get(0);
                        double bestDist = Double.MAX_VALUE;
                        Point2D bestLoc = null;
                        int bestInsertPos = 0;
                        for (int i2 = 1; i2 < result.wf.vertices.size(); ++i2) {
                            SearchVertex sv = result.wf.vertices.get(i2);
                            if (lastSV.getZ() == sv.getZ()) {
                                double dist;
                                Point2D loc = GenMath.closestPointToSegment(new Point2D.Double(lastSV.getX(), lastSV.getY()), new Point2D.Double(sv.getX(), sv.getY()), (Point2D)pt);
                                double locX = loc.getX();
                                double locY = loc.getY();
                                if (this.gridLocationsX[sv.getZ()] != null && this.forceGridArcs[sv.getZ()]) {
                                    locX = this.getClosestXGrid(sv.getZ(), locX).getCoordinate();
                                }
                                if (this.gridLocationsY[sv.getZ()] != null && this.forceGridArcs[sv.getZ()]) {
                                    locY = this.getClosestYGrid(sv.getZ(), locY).getCoordinate();
                                }
                                if ((dist = Math.abs(locX - pt.getX()) + Math.abs(locY - pt.getY())) < bestDist) {
                                    bestDist = dist;
                                    bestLoc = new Point2D.Double(locX, locY);
                                    bestInsertPos = i2;
                                }
                            }
                            lastSV = sv;
                        }
                        if (bestLoc == null) continue;
                        SearchVertex last = result.wf.vertices.get(bestInsertPos);
                        SearchVertex svTap = new SearchVertex(bestLoc.getX(), bestLoc.getY(), last.getZ(), last.getC(), 0, null, null, 0, null, 0, null);
                        result.wf.vertices.add(bestInsertPos, svTap);
                        this.spineTapMap.put(svTap, pi);
                    }
                }
                this.routedSuccess = true;
            } else if (result != svAbandoned) {
                if (result == svLimited) {
                    this.errorMessage = "Search for '" + this.routeName + "' too complex (took more than " + this.complexityLimit + " steps)";
                } else if (result == svExhausted) {
                    this.errorMessage = "Search for '" + this.routeName + "' examined all possibilities without success";
                } else {
                    assert (result == svAborted);
                    this.errorMessage = "Search for '" + this.routeName + "' aborted by user";
                }
                if (this.reroute) {
                    this.errorMessage = "(Retry) " + this.errorMessage;
                }
                boolean isAnError = true;
                if (this.alreadyRouted) {
                    this.errorMessage = this.errorMessage + ", but route already exists in the circuit";
                    SeaOfGatesEngine.this.warn(this.errorMessage);
                    isAnError = false;
                } else {
                    SeaOfGatesEngine.this.error(this.errorMessage);
                }
                if (result == svLimited || result == svExhausted) {
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(this.aEndpoints.getCenter());
                    lineList.add(this.bEndpoints.getCenter());
                    this.loggedMessage = SeaOfGatesEngine.this.errorLogger.logMessageWithLines(this.errorMessage, null, lineList, SeaOfGatesEngine.this.cell, 0, isAnError);
                }
            }
            this.batch.completedRoute(this, result.wf, result);
        }

        private class ContactPlacementError {
            public int metalLayer;
            public ERectangle offendingRect;
            public Rectangle2D missingRect;

            public ContactPlacementError(int metalLayer) {
                this.metalLayer = metalLayer;
            }

            public String getError(PrimitiveNode pNp) {
                Object msg = pNp.describe(false);
                msg = this.missingRect != null ? (String)msg + " is missing Metal " + (this.metalLayer + 1) + " at " + TextUtils.formatDistance(this.missingRect.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.missingRect.getMaxX()) + " and " + TextUtils.formatDistance(this.missingRect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.missingRect.getMaxY()) : (String)msg + " has spacing error to Metal " + (this.metalLayer + 1) + " at " + TextUtils.formatDistance(this.offendingRect.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.offendingRect.getMaxX()) + " and " + TextUtils.formatDistance(this.offendingRect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.offendingRect.getMaxY());
                return msg;
            }
        }
    }

    public class GlobalRouter {
        private int numXBuckets;
        private int numYBuckets;
        private GRBucket[] buckets;
        private GREdge[] edges;
        private List<GRNet> nets;

        public List<GRNet> getNets() {
            return this.nets;
        }

        public int getXBuckets() {
            return this.numXBuckets;
        }

        public int getYBuckets() {
            return this.numYBuckets;
        }

        public GlobalRouter(Cell c2, RouteBatch[] routeBatches, RouteBatch[] fakeBatches, double wirePitch) {
            int eid;
            int y;
            int x;
            ERectangle bounds;
            int size;
            int total = 0;
            for (RouteBatch rb : routeBatches) {
                total += rb.routesInBatch.size();
            }
            if (fakeBatches != null) {
                for (RouteBatch rb : fakeBatches) {
                    total += rb.routesInBatch.size();
                }
            }
            if ((size = (int)Math.sqrt(total)) < 2) {
                size = 2;
            }
            if ((bounds = c2.getBounds()).getWidth() > bounds.getHeight()) {
                this.numXBuckets = size;
                this.numYBuckets = (int)Math.round((double)size * bounds.getHeight() / bounds.getWidth());
                if (this.numYBuckets < 2) {
                    this.numYBuckets = 2;
                }
            } else {
                this.numXBuckets = (int)Math.round((double)size * bounds.getWidth() / bounds.getHeight());
                if (this.numXBuckets < 2) {
                    this.numXBuckets = 2;
                }
                this.numYBuckets = size;
            }
            double bucketWidth = bounds.getWidth() / (double)this.numXBuckets;
            double bucketHeight = bounds.getHeight() / (double)this.numYBuckets;
            int capacity = (int)Math.round(bucketWidth / wirePitch);
            if (capacity < 1) {
                capacity = 1;
            }
            this.buckets = new GRBucket[this.numXBuckets * this.numYBuckets];
            int t = 0;
            for (int y2 = 0; y2 < this.numYBuckets; ++y2) {
                for (int x2 = 0; x2 < this.numXBuckets; ++x2) {
                    double lX = bounds.getMinX() + (double)x2 * bucketWidth;
                    double hX = lX + bucketWidth;
                    double lY = bounds.getMinY() + (double)y2 * bucketHeight;
                    double hY = lY + bucketHeight;
                    this.buckets[t++] = new GRBucket(t, new Rectangle2D.Double(lX, lY, hX - lX, hY - lY));
                }
            }
            int numEdges = this.numXBuckets * (this.numYBuckets - 1) + this.numYBuckets * (this.numXBuckets - 1);
            this.edges = new GREdge[numEdges];
            int e2 = 0;
            for (x = 0; x < this.numXBuckets; ++x) {
                for (y = 1; y < this.numYBuckets; ++y) {
                    int sid = y * this.numXBuckets + x;
                    eid = (y - 1) * this.numXBuckets + x;
                    this.edges[e2++] = new GREdge(this.buckets[sid], this.buckets[eid], capacity);
                }
            }
            for (x = 1; x < this.numXBuckets; ++x) {
                for (y = 0; y < this.numYBuckets; ++y) {
                    int sid = y * this.numXBuckets + x;
                    eid = y * this.numXBuckets + (x - 1);
                    this.edges[e2++] = new GREdge(this.buckets[sid], this.buckets[eid], capacity);
                }
            }
            this.nets = new ArrayList<GRNet>();
            this.addBatches(routeBatches, bounds, bucketWidth, bucketHeight);
            if (fakeBatches != null) {
                this.addBatches(fakeBatches, bounds, bucketWidth, bucketHeight);
            }
        }

        private void addBatches(RouteBatch[] batches, ERectangle bounds, double bucketWidth, double bucketHeight) {
            for (RouteBatch rb : batches) {
                GRNet nn = null;
                for (NeededRoute nr : rb.routesInBatch) {
                    int x1 = (int)((nr.aEndpoints.getCenterX() - bounds.getMinX()) / bucketWidth);
                    int y1 = (int)((nr.aEndpoints.getCenterY() - bounds.getMinY()) / bucketHeight);
                    int x2 = (int)((nr.bEndpoints.getCenterX() - bounds.getMinX()) / bucketWidth);
                    int bucket1 = y1 * this.numXBuckets + x1;
                    int y2 = (int)((nr.bEndpoints.getCenterY() - bounds.getMinY()) / bucketHeight);
                    int bucket2 = y2 * this.numXBuckets + x2;
                    if (bucket1 == bucket2) continue;
                    if (nn == null) {
                        nn = new GRNet();
                        this.nets.add(nn);
                    }
                    GRWire w = new GRWire(nr, this.buckets[bucket1], this.buckets[bucket2], nr.aEndpoints.getCenter(), nr.bEndpoints.getCenter());
                    nn.addWire(w);
                }
            }
        }

        public void solve() {
            ElapseTimer theTimer = ElapseTimer.createInstance().start();
            this.route();
            theTimer.end();
            SeaOfGatesEngine.this.info("Global routing: initialized (took " + String.valueOf(theTimer) + ")");
            int iterations = 4;
            for (int iteration = 0; iteration < iterations; ++iteration) {
                theTimer.start();
                this.ripupReroute();
                theTimer.end();
                SeaOfGatesEngine.this.info("Global routing: Rip-up and reroute pass " + iteration + " (took " + String.valueOf(theTimer) + ")");
            }
            for (GRNet net : this.nets) {
                for (GRWire wire : net.wires) {
                    wire.setPathOnRoute();
                }
            }
        }

        private void route() {
            for (GRNet net : this.nets) {
                for (GRWire w : net.getWires()) {
                    if (w.setShortestPath()) {
                        SeaOfGatesEngine.this.error("ERROR: No path from " + String.valueOf(w.n1) + " to " + String.valueOf(w.n2));
                    }
                    w.addPath(1);
                }
            }
        }

        private void ripupReroute() {
            for (GRNet net : this.nets) {
                for (GRWire w : net.getWires()) {
                    w.addPath(-1);
                    if (w.setShortestPath()) {
                        SeaOfGatesEngine.this.error("ERROR: No path from " + String.valueOf(w.n1) + " to " + String.valueOf(w.n2));
                    }
                    w.addPath(1);
                }
            }
        }
    }

    public static class RouteResolution
    implements Serializable {
        final CellId cellId;
        final List<RouteNode> nodesToRoute = new ArrayList<RouteNode>();
        final List<RouteArc> arcsToRoute = new ArrayList<RouteArc>();
        final List<Integer> nodesIDsToKill = new ArrayList<Integer>();
        final List<Integer> arcsIDsToKill = new ArrayList<Integer>();
        final Map<RouteAddUnrouted, String> unroutedToAdd = new HashMap<RouteAddUnrouted, String>();

        public RouteResolution(CellId cellId) {
            this.cellId = cellId;
        }

        public void addNode(RouteNode rn) {
            this.nodesToRoute.add(rn);
        }

        public void addArc(RouteArc ra) {
            this.arcsToRoute.add(ra);
        }

        public void killNode(NodeInst ni) {
            this.nodesIDsToKill.add(ni.getNodeId());
        }

        public void killArc(ArcInst ai) {
            this.arcsIDsToKill.add(ai.getArcId());
        }

        public void addUnrouted(PortInst piA, PortInst piB, String name) {
            this.unroutedToAdd.put(new RouteAddUnrouted(piA, piB), name);
        }

        public void clearRoutes() {
            this.nodesToRoute.clear();
            this.arcsToRoute.clear();
            this.nodesIDsToKill.clear();
            this.arcsIDsToKill.clear();
            this.unroutedToAdd.clear();
        }
    }

    private class BlockageTrees {
        private final BlockageTree[] metalTrees;
        private final BlockageTree[] viaTrees;

        BlockageTrees(int numMetals) {
            this.metalTrees = new BlockageTree[numMetals];
            this.viaTrees = new BlockageTree[numMetals];
            for (int i2 = 0; i2 < this.metalTrees.length; ++i2) {
                this.metalTrees[i2] = new BlockageTree(null);
                this.viaTrees[i2] = new BlockageTree(null);
            }
        }

        private BlockageTree getMetalTree(Layer lay) {
            if (lay == null) {
                return BlockageTree.emptyTree;
            }
            return this.metalTrees[lay.getFunction().getLevel() - 1];
        }

        private BlockageTree getViaTree(Layer lay) {
            if (lay == null) {
                return BlockageTree.emptyTree;
            }
            return this.viaTrees[lay.getFunction().getLevel() - 1];
        }
    }

    private static class BlockageTree {
        private final ReentrantLock lock = new ReentrantLock();
        private RTNode<SOGBound> root;
        public static BlockageTree emptyTree = new BlockageTree(null);

        private BlockageTree(RTNode<SOGBound> root) {
            this.root = root;
        }

        private void lock() {
            this.lock.lock();
        }

        private void unlock() {
            this.lock.unlock();
        }

        private RTNode<SOGBound> getRoot() {
            return this.root;
        }

        private void setRoot(RTNode<SOGBound> root) {
            this.root = root;
        }

        private boolean isEmpty() {
            return this.root == null;
        }

        private Iterator<SOGBound> search(Rectangle2D searchArea) {
            if (this.root == null) {
                return Collections.emptyList().iterator();
            }
            RTNode.Search<SOGBound> it = new RTNode.Search<SOGBound>(searchArea, this.root, true);
            return it;
        }
    }

    public static class PossibleEndpoints {
        private double x;
        private double y;
        private EPoint coord;
        private FixpRectangle rect;
        private FixpRectangle rectGridded;
        private List<PossibleEndpoint> choices;

        public PossibleEndpoints(double x, double y, FixpRectangle rect, FixpRectangle rectGridded) {
            this.x = x;
            this.y = y;
            this.coord = null;
            this.rect = rect;
            this.rectGridded = rectGridded;
            this.choices = null;
        }

        public void setCenterX(double v) {
            this.x = v;
            this.coord = null;
        }

        public void setCenterY(double v) {
            this.y = v;
            this.coord = null;
        }

        public void setRect(double x, double y, double w, double h2) {
            this.rect.setRect(x, y, w, h2);
        }

        public void setGriddedRect(double lX, double hX, double lY, double hY) {
            this.rectGridded = FixpRectangle.from(new Rectangle2D.Double(lX, lY, hX - lX, hY - lY));
        }

        public void add(PossibleEndpoint pe) {
            if (this.choices == null) {
                this.choices = new ArrayList<PossibleEndpoint>();
            }
            this.choices.add(pe);
        }

        public double getCenterX() {
            return this.x;
        }

        public double getCenterY() {
            return this.y;
        }

        public EPoint getCenter() {
            if (this.coord == null) {
                this.coord = EPoint.fromLambda(this.x, this.y);
            }
            return this.coord;
        }

        public FixpRectangle getRect() {
            return this.rect;
        }

        public FixpRectangle getGriddedRect() {
            return this.rectGridded;
        }

        public boolean hasEndpoints() {
            return this.choices != null;
        }

        public List<PossibleEndpoint> getEndpoints() {
            return this.choices;
        }

        public void finishedAddingEndpoints() {
            if (this.hasEndpoints()) {
                PossibleEndpoint peFirst = this.choices.get(0);
                double lX = peFirst.coord.getX();
                double hX = peFirst.coord.getX();
                double lY = peFirst.coord.getY();
                double hY = peFirst.coord.getY();
                for (int i2 = 1; i2 < this.choices.size(); ++i2) {
                    PossibleEndpoint pe = this.choices.get(i2);
                    if (pe.coord.getX() < lX) {
                        lX = pe.coord.getX();
                    }
                    if (pe.coord.getX() > hX) {
                        hX = pe.coord.getX();
                    }
                    if (pe.coord.getY() < lY) {
                        lY = pe.coord.getY();
                    }
                    if (!(pe.coord.getY() > hY)) continue;
                    hY = pe.coord.getY();
                }
                this.rect.setRect(lX, lY, hX - lX, hY - lY);
                this.rectGridded.setRect(lX, lY, hX - lX, hY - lY);
                boolean pointValid = false;
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), this.x) || !DBMath.areEquals(pe.coord.getY(), this.y)) continue;
                    pointValid = true;
                }
                if (!pointValid) {
                    double cX = (lX + hX) / 2.0;
                    double cY = (lY + hY) / 2.0;
                    PossibleEndpoint bestPE = null;
                    double bestDist = Double.MAX_VALUE;
                    for (PossibleEndpoint pe : this.choices) {
                        double dy;
                        double dx = cX - pe.coord.getX();
                        double dist = Math.sqrt(dx * dx + (dy = cY - pe.coord.getY()) * dy);
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                        bestPE = pe;
                    }
                    this.x = bestPE.coord.getX();
                    this.y = bestPE.coord.getY();
                    this.coord = bestPE.coord;
                }
            }
        }

        public EPoint getClosestPoint(double curX, double curY) {
            if (this.hasEndpoints()) {
                PossibleEndpoint bestPE = null;
                double bestDist = Double.MAX_VALUE;
                for (PossibleEndpoint pe : this.choices) {
                    double dy;
                    double dx = curX - pe.coord.getX();
                    double dist = Math.sqrt(dx * dx + (dy = curY - pe.coord.getY()) * dy);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestPE = pe;
                }
                if (bestPE != null) {
                    return bestPE.getCoord();
                }
            }
            return EPoint.fromLambda(this.x, this.y);
        }

        public boolean isToPoint(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), curX) || !DBMath.areEquals(pe.coord.getY(), curY)) continue;
                    return true;
                }
                return false;
            }
            return DBMath.pointInRect(EPoint.fromLambda(curX, curY), this.rect);
        }

        public boolean isWithinNonzeroX(double curX, double curY) {
            if (this.rectGridded.getWidth() == 0.0 || !DBMath.areEquals(curX, this.x)) {
                return false;
            }
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), curX) || !DBMath.areEquals(pe.coord.getY(), curY)) continue;
                    return true;
                }
                return false;
            }
            return DBMath.areEquals(curY, this.y);
        }

        public boolean isWithinNonzeroY(double curX, double curY) {
            if (this.rectGridded.getHeight() == 0.0 || !DBMath.areEquals(curY, this.y)) {
                return false;
            }
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), curX) || !DBMath.areEquals(pe.coord.getY(), curY)) continue;
                    return true;
                }
                return false;
            }
            return DBMath.areEquals(curX, this.x);
        }

        public double getClosestX(double curX) {
            if (this.hasEndpoints()) {
                PossibleEndpoint bestPE = null;
                double bestDist = Double.MAX_VALUE;
                for (PossibleEndpoint pe : this.choices) {
                    double dist = Math.abs(curX - pe.coord.getX());
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestPE = pe;
                }
                if (bestPE != null) {
                    return bestPE.getCoord().getX();
                }
            }
            return this.x;
        }

        public double getClosestY(double curY) {
            if (this.hasEndpoints()) {
                PossibleEndpoint bestPE = null;
                double bestDist = Double.MAX_VALUE;
                for (PossibleEndpoint pe : this.choices) {
                    double dist = Math.abs(curY - pe.coord.getY());
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestPE = pe;
                }
                if (bestPE != null) {
                    return bestPE.getCoord().getY();
                }
            }
            return this.y;
        }

        public boolean isBelowX(double curX) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(pe.coord.getX() >= curX)) continue;
                    return false;
                }
                return true;
            }
            return this.x < curX;
        }

        public boolean isAboveX(double curX) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(pe.coord.getX() <= curX)) continue;
                    return false;
                }
                return true;
            }
            return this.x > curX;
        }

        public boolean isBelowY(double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(pe.coord.getY() >= curY)) continue;
                    return false;
                }
                return true;
            }
            return this.y < curY;
        }

        public boolean isAboveY(double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(pe.coord.getY() <= curY)) continue;
                    return false;
                }
                return true;
            }
            return this.y > curY;
        }

        public boolean atGoalPoint(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), curX) || !DBMath.areEquals(pe.coord.getY(), curY)) continue;
                    return true;
                }
                return false;
            }
            return SeaOfGatesEngine.inDestGrid(this.rectGridded, curX, curY);
        }

        public boolean isOutOfGoalX(double curX) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), curX)) continue;
                    return true;
                }
                return false;
            }
            return curX > this.rect.getMaxX() || curX < this.rect.getMinX();
        }

        public boolean isOutOfGoalY(double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getY(), curY)) continue;
                    return true;
                }
                return false;
            }
            return curY > this.rect.getMaxY() || curY < this.rect.getMinY();
        }

        public boolean isOnGoalAxis(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!DBMath.areEquals(pe.coord.getX(), curX) && !DBMath.areEquals(pe.coord.getY(), curY)) continue;
                    return true;
                }
                return false;
            }
            return DBMath.areEquals(curX, this.x) || DBMath.areEquals(curY, this.y);
        }

        public double getDistToGoal(double curX, double curY) {
            if (this.hasEndpoints()) {
                PossibleEndpoint bestPE = null;
                double bestDist = Double.MAX_VALUE;
                for (PossibleEndpoint pe : this.choices) {
                    double dy;
                    double dx = curX - pe.coord.getX();
                    double dist = Math.sqrt(dx * dx + (dy = curY - pe.coord.getY()) * dy);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                    bestPE = pe;
                }
                if (bestPE != null) {
                    return bestDist;
                }
            }
            return Math.sqrt((curX - this.x) * (curX - this.x) + (curY - this.y) * (curY - this.y));
        }

        public Double getGoalWithinX(double lowX, double highX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (curY != pe.coord.getY() || !(lowX < pe.coord.getX()) || !(highX > pe.coord.getX())) continue;
                    return pe.coord.getX();
                }
                return null;
            }
            if (curY == this.y && lowX < this.x && highX > this.x) {
                return this.x;
            }
            return null;
        }

        public Double getGoalWithinY(double curX, double lowY, double highY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (curX != pe.coord.getX() || !(lowY < pe.coord.getY()) || !(highY > pe.coord.getY())) continue;
                    return pe.coord.getY();
                }
                return null;
            }
            if (curX == this.x && lowY < this.y && highY > this.y) {
                return this.y;
            }
            return null;
        }

        public Double getGoalAboveX(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(curX > pe.coord.getX()) || !DBMath.areEquals(curY, pe.coord.getY())) continue;
                    return pe.coord.getX();
                }
                return null;
            }
            if (curX > this.x && curY >= this.rect.getMinY() && curY <= this.rect.getMaxY()) {
                return this.x;
            }
            return null;
        }

        public Double getGoalBelowX(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(curX < pe.coord.getX()) || !DBMath.areEquals(curY, pe.coord.getY())) continue;
                    return pe.coord.getX();
                }
                return null;
            }
            if (curX < this.x && curY >= this.rect.getMinY() && curY <= this.rect.getMaxY()) {
                return this.x;
            }
            return null;
        }

        public Double getGoalAboveY(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(curY > pe.coord.getY()) || !DBMath.areEquals(curX, pe.coord.getX())) continue;
                    return pe.coord.getY();
                }
                return null;
            }
            if (curY > this.y && curX >= this.rect.getMinX() && curX <= this.rect.getMaxX()) {
                return this.y;
            }
            return null;
        }

        public Double getGoalBelowY(double curX, double curY) {
            if (this.hasEndpoints()) {
                for (PossibleEndpoint pe : this.choices) {
                    if (!(curY < pe.coord.getY()) || !DBMath.areEquals(curX, pe.coord.getX())) continue;
                    return pe.coord.getY();
                }
                return null;
            }
            if (curY < this.y && curX >= this.rect.getMinX() && curX <= this.rect.getMaxX()) {
                return this.y;
            }
            return null;
        }
    }

    public static class SOGBound
    extends SOGNetID
    implements RTBounds {
        private ERectangle bound;
        private int maskLayer;

        SOGBound(ERectangle bound, MutableInteger netID, int maskLayer) {
            super(netID);
            this.bound = bound;
            this.maskLayer = maskLayer;
        }

        @Override
        public ERectangle getBounds() {
            return this.bound;
        }

        public int getMaskColor() {
            return this.maskLayer;
        }

        public void setMaskColor(int c2) {
            this.maskLayer = c2;
        }

        public boolean containsPoint(double x, double y) {
            return x >= this.bound.getMinX() && x <= this.bound.getMaxX() && y >= this.bound.getMinY() && y <= this.bound.getMaxY();
        }

        public boolean isManhattan() {
            return true;
        }

        public String toString() {
            return "SOGBound on net " + String.valueOf(this.getNetID());
        }
    }

    private static class SortLayersByMaskNumber
    implements Comparator<Layer> {
        private SortLayersByMaskNumber() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            int m1 = l1.getFunction().getMaskColor();
            int m2 = l2.getFunction().getMaskColor();
            return m1 - m2;
        }
    }

    private static class SortArcsByMaskNumber
    implements Comparator<ArcProto> {
        private SortArcsByMaskNumber() {
        }

        @Override
        public int compare(ArcProto a1, ArcProto a2) {
            int m1 = a1.getMaskLayer();
            int m2 = a2.getMaskLayer();
            return m1 - m2;
        }
    }

    private class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o2, int hm, int hmc, double hmi, int vm, int vmc, double vmi) {
            this.vias.add(new MetalVia(pn, o2, hm, hmc, hmi, vm, vmc, vmi));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;
        int horMetal;
        int verMetal;
        int horMetalColor;
        int verMetalColor;
        double horMetalInset;
        double verMetalInset;

        MetalVia(PrimitiveNode v, int o2, int hm, int hmc, double hmi, int vm, int vmc, double vmi) {
            this.via = v;
            this.orientation = o2;
            this.horMetal = hm;
            this.horMetalColor = hmc;
            this.horMetalInset = hmi;
            this.verMetal = vm;
            this.verMetalColor = vmc;
            this.verMetalInset = vmi;
        }
    }

    public static class RoutesOnNetwork
    implements Comparable<RoutesOnNetwork> {
        private String netName;
        private List<SteinerTree.SteinerTreePortPair> pairs;
        List<ArcInst> unroutedArcs;
        List<PortInst> unorderedPorts;
        List<NeededRoute> neededRoutes;

        RoutesOnNetwork(String netName) {
            this.netName = netName;
            this.pairs = new ArrayList<SteinerTree.SteinerTreePortPair>();
            this.unroutedArcs = new ArrayList<ArcInst>();
            this.unorderedPorts = new ArrayList<PortInst>();
            this.neededRoutes = new ArrayList<NeededRoute>();
        }

        public List<SteinerTree.SteinerTreePortPair> getPairs() {
            return this.pairs;
        }

        public String getName() {
            return this.netName;
        }

        public boolean addUnorderedPort(PortInst pi) {
            if (pi.getNodeInst().isCellInstance() || ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() != Generic.tech()) {
                if (!this.unorderedPorts.contains(pi)) {
                    this.unorderedPorts.add(pi);
                }
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void setupSpineInfo(boolean disableAdvancedSpineRouting) {
            HashSet<PortInst> uniquePorts = new HashSet<PortInst>();
            for (PortInst pi : this.unorderedPorts) {
                uniquePorts.add(pi);
            }
            TreeMap<Double, List<PortInst>> xMap = new TreeMap<Double, List<PortInst>>();
            TreeMap<Double, List<PortInst>> yMap = new TreeMap<Double, List<PortInst>>();
            for (PortInst pi : uniquePorts) {
                void var9_17;
                EPoint pt = pi.getCenter();
                Double d2 = pt.getX();
                List list = (List)xMap.get(d2);
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    xMap.put(d2, arrayList);
                }
                var9_17.add(pi);
                Double yv = pt.getY();
                ArrayList<PortInst> yTotal = (ArrayList<PortInst>)yMap.get(yv);
                if (yTotal == null) {
                    yTotal = new ArrayList<PortInst>();
                    yMap.put(yv, yTotal);
                }
                yTotal.add(pi);
            }
            List<SteinerTree.SteinerTreePortPair> xClusters = this.generateSpines(xMap);
            List<SteinerTree.SteinerTreePortPair> yClusters = this.generateSpines(yMap);
            if (xClusters.size() == 0 && yClusters.size() == 0) {
                Iterator<SteinerTree.SteinerTreePortPair> portList = new ArrayList<SteinerTree.SteinerTreePort>();
                for (PortInst portInst : uniquePorts) {
                    portList.add((SteinerTree.SteinerTreePortPair)((Object)new PortInstShadow(portInst)));
                }
                SteinerTree steinerTree = new SteinerTree((List<SteinerTree.SteinerTreePort>)((Object)portList), disableAdvancedSpineRouting);
                for (SteinerTree.SteinerTreePortPair stpp : steinerTree.getTreeBranches()) {
                    this.pairs.add(stpp);
                }
                return;
            }
            Collections.sort(xClusters, new SortSpinesByNumberOfTaps());
            Collections.sort(yClusters, new SortSpinesByNumberOfTaps());
            this.eliminateSpinePoints(xClusters, yClusters);
            this.eliminateSpinePoints(yClusters, xClusters);
            for (SteinerTree.SteinerTreePortPair steinerTreePortPair : xClusters) {
                this.pairs.add(steinerTreePortPair);
            }
            for (SteinerTree.SteinerTreePortPair steinerTreePortPair : yClusters) {
                this.pairs.add(steinerTreePortPair);
            }
            ArrayList<Set<SteinerTree.SteinerTreePort>> allPortGroups = new ArrayList<Set<SteinerTree.SteinerTreePort>>();
            for (SteinerTree.SteinerTreePortPair steinerTreePortPair : this.pairs) {
                HashSet<Object> portsInSpine = new HashSet<Object>();
                portsInSpine.add(steinerTreePortPair.getPort1());
                portsInSpine.add(steinerTreePortPair.getPort2());
                List<PortInst> taps = steinerTreePortPair.getSpineTaps();
                if (taps != null) {
                    Iterator<PortInst> iterator = taps.iterator();
                    while (iterator.hasNext()) {
                        PortInst pi = iterator.next();
                        portsInSpine.add(pi);
                    }
                }
                HashSet foundPortGroups = new HashSet();
                for (SteinerTree.SteinerTreePort steinerTreePort : portsInSpine) {
                    Set<SteinerTree.SteinerTreePort> portGroup = this.findPortGroup(steinerTreePort, allPortGroups);
                    if (portGroup == null) continue;
                    foundPortGroups.add(portGroup);
                }
                if (foundPortGroups.size() == 0) {
                    allPortGroups.add(portsInSpine);
                    continue;
                }
                ArrayList<Set> otherPortGroups = new ArrayList<Set>();
                Object var14_37 = null;
                for (Set set : foundPortGroups) {
                    void var14_38;
                    if (var14_38 == null) {
                        Set set2 = set;
                        for (SteinerTree.SteinerTreePort steinerTreePort : portsInSpine) {
                            set2.add(steinerTreePort);
                        }
                        continue;
                    }
                    for (SteinerTree.SteinerTreePort steinerTreePort : set) {
                        var14_38.add(steinerTreePort);
                    }
                    otherPortGroups.add(set);
                }
                for (Set set : otherPortGroups) {
                    allPortGroups.remove(set);
                }
            }
            HashSet<PortInst> hashSet = new HashSet<PortInst>();
            for (PortInst pi : uniquePorts) {
                hashSet.add(pi);
            }
            for (SteinerTree.SteinerTreePortPair stpp : this.pairs) {
                hashSet.remove(stpp.getPort1());
                hashSet.remove(stpp.getPort2());
                for (PortInst pi : stpp.getSpineTaps()) {
                    hashSet.remove(pi);
                }
            }
            for (PortInst pi : hashSet) {
                HashSet<PortInst> portsInSpine = new HashSet<PortInst>();
                portsInSpine.add(pi);
                allPortGroups.add(portsInSpine);
            }
            while (allPortGroups.size() > 1) {
                void var14_42;
                Set set = (Set)allPortGroups.get(0);
                double bestDist = Double.MAX_VALUE;
                Set bestGroup = null;
                SteinerTree.SteinerTreePort bestFirstPort = null;
                Object var14_41 = null;
                for (int i2 = 1; i2 < allPortGroups.size(); ++i2) {
                    Set set3 = (Set)allPortGroups.get(i2);
                    for (SteinerTree.SteinerTreePort steinerTreePort : set) {
                        for (SteinerTree.SteinerTreePort stpOther : set3) {
                            double dist = steinerTreePort.getCenter().distance(stpOther.getCenter());
                            if (!(dist < bestDist)) continue;
                            bestDist = dist;
                            bestFirstPort = steinerTreePort;
                            SteinerTree.SteinerTreePort steinerTreePort2 = stpOther;
                            bestGroup = set3;
                        }
                    }
                }
                SteinerTree.SteinerTreePortPair stpp = new SteinerTree.SteinerTreePortPair(bestFirstPort, (SteinerTree.SteinerTreePort)var14_42);
                this.pairs.add(stpp);
                for (SteinerTree.SteinerTreePort stp : set) {
                    bestGroup.add(stp);
                }
                allPortGroups.remove(0);
            }
        }

        private Set<SteinerTree.SteinerTreePort> findPortGroup(SteinerTree.SteinerTreePort pi, List<Set<SteinerTree.SteinerTreePort>> allPortGroups) {
            for (Set<SteinerTree.SteinerTreePort> portGroup : allPortGroups) {
                if (!portGroup.contains(pi)) continue;
                return portGroup;
            }
            return null;
        }

        private void eliminateSpinePoints(List<SteinerTree.SteinerTreePortPair> goodSet, List<SteinerTree.SteinerTreePortPair> otherSet) {
            for (int i2 = 0; i2 < goodSet.size(); ++i2) {
                SteinerTree.SteinerTreePort p2;
                SteinerTree.SteinerTreePortPair stpp = goodSet.get(i2);
                SteinerTree.SteinerTreePort p1 = stpp.getPort1();
                if (!this.findPortInSpine(p1, otherSet) || !this.findPortInSpine(p2 = stpp.getPort2(), otherSet)) continue;
                List<PortInst> taps = stpp.getSpineTaps();
                if (taps != null) {
                    boolean anyMissing = false;
                    for (PortInst pi : taps) {
                        if (this.findPortInSpine(pi, otherSet)) continue;
                        anyMissing = true;
                        break;
                    }
                    if (anyMissing) continue;
                }
                goodSet.remove(i2);
                --i2;
            }
        }

        private boolean findPortInSpine(SteinerTree.SteinerTreePort stp, List<SteinerTree.SteinerTreePortPair> otherSet) {
            for (SteinerTree.SteinerTreePortPair stpp : otherSet) {
                if (stpp.getPort1() == stp) {
                    return true;
                }
                if (stpp.getPort2() == stp) {
                    return true;
                }
                List<PortInst> taps = stpp.getSpineTaps();
                if (taps == null) continue;
                for (PortInst pi : taps) {
                    if (pi != stp) continue;
                    return true;
                }
            }
            return false;
        }

        private List<SteinerTree.SteinerTreePortPair> generateSpines(Map<Double, List<PortInst>> map) {
            ArrayList clusters = new ArrayList();
            ArrayList<Double> mapCoords = new ArrayList<Double>();
            for (Double v : map.keySet()) {
                mapCoords.add(v);
            }
            int startIndex = 0;
            ArrayList<PortInst> bestCluster = null;
            for (int index = 0; index < mapCoords.size(); ++index) {
                int total = 0;
                double d2 = 0.0;
                double highX = 0.0;
                double lowY = 0.0;
                double highY = 0.0;
                for (int i2 = startIndex; i2 <= index; ++i2) {
                    Double v = (Double)mapCoords.get(i2);
                    List<PortInst> ports = map.get(v);
                    for (PortInst pi : ports) {
                        EPoint pt = pi.getCenter();
                        if (total == 0) {
                            d2 = highX = pt.getX();
                            lowY = highY = pt.getY();
                        } else {
                            if (pt.getX() < d2) {
                                d2 = pt.getX();
                            }
                            if (pt.getX() > highX) {
                                highX = pt.getX();
                            }
                            if (pt.getY() < lowY) {
                                lowY = pt.getY();
                            }
                            if (pt.getY() > highY) {
                                highY = pt.getY();
                            }
                        }
                        ++total;
                    }
                }
                double width = highX - d2;
                double height = highY - lowY;
                if (width * 50.0 > height && height * 50.0 > width) {
                    if (bestCluster != null) {
                        clusters.add(bestCluster);
                    }
                    bestCluster = null;
                    startIndex = index--;
                    continue;
                }
                ArrayList<PortInst> cluster = new ArrayList<PortInst>();
                for (int i3 = startIndex; i3 <= index; ++i3) {
                    Double v = (Double)mapCoords.get(i3);
                    List<PortInst> ports = map.get(v);
                    for (PortInst pi : ports) {
                        cluster.add(pi);
                    }
                }
                if (cluster.size() <= 2) continue;
                bestCluster = cluster;
            }
            if (bestCluster != null) {
                clusters.add(bestCluster);
            }
            ArrayList<SteinerTree.SteinerTreePortPair> pairs = new ArrayList<SteinerTree.SteinerTreePortPair>();
            for (List list : clusters) {
                PortInst first = (PortInst)list.get(0);
                EPoint firstPT = first.getCenter();
                double bestDist = 0.0;
                PortInst end1 = null;
                PortInst end2 = null;
                for (int i4 = 1; i4 < list.size(); ++i4) {
                    PortInst pi = (PortInst)list.get(i4);
                    EPoint pt = pi.getCenter();
                    double dist = firstPT.distance(pt);
                    if (!(dist > bestDist)) continue;
                    bestDist = dist;
                    end1 = pi;
                }
                EPoint end1PT = end1.getCenter();
                bestDist = 0.0;
                for (int i5 = 0; i5 < list.size(); ++i5) {
                    EPoint pt;
                    double dist;
                    PortInst pi = (PortInst)list.get(i5);
                    if (pi == end1 || !((dist = end1PT.distance(pt = pi.getCenter())) > bestDist)) continue;
                    bestDist = dist;
                    end2 = pi;
                }
                SteinerTree.SteinerTreePortPair stpp = new SteinerTree.SteinerTreePortPair(end1, end2);
                for (int i6 = 0; i6 < list.size(); ++i6) {
                    PortInst pi = (PortInst)list.get(i6);
                    if (pi == end1 || pi == end2) continue;
                    stpp.addTapPort(pi);
                }
                pairs.add(stpp);
            }
            return pairs;
        }

        @Override
        public int compareTo(RoutesOnNetwork other) {
            return this.getName().compareTo(other.getName());
        }

        private static class SortSpinesByNumberOfTaps
        implements Comparator<SteinerTree.SteinerTreePortPair> {
            private SortSpinesByNumberOfTaps() {
            }

            @Override
            public int compare(SteinerTree.SteinerTreePortPair stpp1, SteinerTree.SteinerTreePortPair stpp2) {
                List<PortInst> taps1 = stpp1.getSpineTaps();
                List<PortInst> taps2 = stpp2.getSpineTaps();
                int tapCount1 = taps1 == null ? 0 : taps1.size();
                int tapCount2 = taps2 == null ? 0 : taps2.size();
                return tapCount1 - tapCount2;
            }
        }
    }

    private static class PortInstShadow
    implements SteinerTree.SteinerTreePort {
        private PortInst pi;
        private EPoint ctr;

        PortInstShadow(PortInst pi) {
            this.pi = pi;
            this.ctr = pi.getNodeInst().getShapeOfPort(pi.getPortProto()).getCenter();
        }

        @Override
        public EPoint getCenter() {
            return this.ctr;
        }

        public PortInst getPortInst() {
            return this.pi;
        }
    }

    public class Wavefront {
        final NeededRoute nr;
        final boolean aToB;
        private final OrderedSearchVertex active;
        private final List<SearchVertex> inactive;
        List<SearchVertex> vertices;
        volatile boolean abort;
        private boolean debuggingWavefront;
        private SearchVertex solution;
        final PortInst from;
        final PortInst to;
        final double fromX;
        final double fromY;
        final FixpRectangle fromRect;
        final int fromZ;
        final int fromC;
        public PossibleEndpoints toPE;
        final int toZ;
        final int toC;
        final double fromTaperLen;
        final double toTaperLen;
        int numStepsMade;
        Rectangle2D[] orderedBuckets;
        int[] orderedBase;
        final int fromBit;
        final int globalRoutingDelta;
        final Map<Integer, Map<Integer, SearchVertex>>[] searchVertexPlanes = new Map[numMetalLayers];
        private boolean finished;
        private List<SearchVertex> optimizedList = new ArrayList<SearchVertex>();
        private String[] debugString;

        Wavefront(NeededRoute nr, PortInst from, FixpRectangle fromRect, double fromX, double fromY, int fromZ, int fromC, double fromTaperLen, int fromBit, PortInst to, PossibleEndpoints toPE, int toZ, int toC, double toTaperLen, int globalRoutingDelta, Boolean aToB, boolean debugIt) {
            this.nr = nr;
            this.from = from;
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.fromC = fromC;
            this.fromRect = fromRect;
            this.fromBit = fromBit;
            this.to = to;
            this.toPE = toPE;
            this.toZ = toZ;
            this.toC = toC;
            this.fromTaperLen = fromTaperLen;
            this.toTaperLen = toTaperLen;
            if (nr.buckets == null) {
                globalRoutingDelta = 0;
            }
            this.globalRoutingDelta = globalRoutingDelta;
            this.aToB = aToB;
            this.numStepsMade = 0;
            this.active = new OrderedSearchVertex();
            this.inactive = new ArrayList<SearchVertex>();
            this.vertices = null;
            this.abort = false;
            this.debuggingWavefront = debugIt;
            SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, fromC, 0, null, null, 0, this, 0, null);
            if (this.debuggingWavefront) {
                RoutingDebug.ensureDebuggingShadow(svStart, true);
            }
            if (globalRoutingDelta != 0) {
                this.orderedBuckets = new Rectangle2D[nr.buckets.length];
                this.orderedBase = new int[nr.buckets.length];
                if (globalRoutingDelta > 0) {
                    svStart.globalRoutingBucket = 0;
                    for (int i2 = 0; i2 < nr.buckets.length; ++i2) {
                        int lastInRun = i2;
                        for (int j2 = i2 + 1; j2 < nr.buckets.length; ++j2) {
                            if (nr.buckets[i2].getMinX() == nr.buckets[j2].getMinX() && nr.buckets[i2].getMaxX() == nr.buckets[j2].getMaxX()) {
                                lastInRun = j2;
                            }
                            if (nr.buckets[i2].getMinY() == nr.buckets[j2].getMinY() && nr.buckets[i2].getMaxY() == nr.buckets[j2].getMaxY()) {
                                lastInRun = j2;
                            }
                            if (lastInRun != j2) break;
                        }
                        double lX = Math.min(nr.buckets[i2].getMinX(), nr.buckets[lastInRun].getMinX());
                        double hX = Math.max(nr.buckets[i2].getMaxX(), nr.buckets[lastInRun].getMaxX());
                        double lY = Math.min(nr.buckets[i2].getMinY(), nr.buckets[lastInRun].getMinY());
                        double hY = Math.max(nr.buckets[i2].getMaxY(), nr.buckets[lastInRun].getMaxY());
                        Rectangle2D.Double combinedRun = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                        int initially = i2;
                        if (i2 > 0) {
                            --initially;
                        }
                        for (int pos = i2; pos <= lastInRun; ++pos) {
                            this.orderedBuckets[pos] = combinedRun;
                            this.orderedBase[pos] = initially;
                            initially = i2;
                        }
                        if (lastInRun != nr.buckets.length - 1) {
                            i2 = lastInRun - 1;
                            continue;
                        }
                        break;
                    }
                } else {
                    svStart.globalRoutingBucket = nr.buckets.length - 1;
                    for (int i3 = nr.buckets.length - 1; i3 >= 0; --i3) {
                        int lastInRun = i3;
                        for (int j3 = i3 - 1; j3 >= 0; --j3) {
                            if (nr.buckets[i3].getMinX() == nr.buckets[j3].getMinX() && nr.buckets[i3].getMaxX() == nr.buckets[j3].getMaxX()) {
                                lastInRun = j3;
                            }
                            if (nr.buckets[i3].getMinY() == nr.buckets[j3].getMinY() && nr.buckets[i3].getMaxY() == nr.buckets[j3].getMaxY()) {
                                lastInRun = j3;
                            }
                            if (lastInRun != j3) break;
                        }
                        double lX = Math.min(nr.buckets[i3].getMinX(), nr.buckets[lastInRun].getMinX());
                        double hX = Math.max(nr.buckets[i3].getMaxX(), nr.buckets[lastInRun].getMaxX());
                        double lY = Math.min(nr.buckets[i3].getMinY(), nr.buckets[lastInRun].getMinY());
                        double hY = Math.max(nr.buckets[i3].getMaxY(), nr.buckets[lastInRun].getMaxY());
                        Rectangle2D.Double combinedRun = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                        int initially = i3;
                        if (i3 < nr.buckets.length - 1) {
                            ++initially;
                        }
                        for (int pos = i3; pos >= lastInRun; --pos) {
                            this.orderedBuckets[pos] = combinedRun;
                            this.orderedBase[pos] = initially;
                            initially = i3;
                        }
                        if (lastInRun != 0) {
                            i3 = lastInRun + 1;
                            continue;
                        }
                        break;
                    }
                }
            }
            svStart.cost = 0;
            this.setVertex(fromX, fromY, fromZ, svStart);
            this.active.add(svStart);
        }

        public boolean isAtoB() {
            return this.aToB;
        }

        public PortInst getFromPortInst() {
            return this.from;
        }

        public PortInst getToPortInst() {
            return this.to;
        }

        public double getFromX() {
            return this.fromX;
        }

        public double getFromY() {
            return this.fromY;
        }

        public int getFromZ() {
            return this.fromZ;
        }

        public int getFromMask() {
            return this.fromC;
        }

        public PossibleEndpoints getTo() {
            return this.toPE;
        }

        public int getToZ() {
            return this.toZ;
        }

        public int getToMask() {
            return this.toC;
        }

        public Set<SearchVertex> getActive() {
            return this.active.getSet();
        }

        public List<SearchVertex> getInactive() {
            return this.inactive;
        }

        public NeededRoute getNeededRoute() {
            return this.nr;
        }

        public int getGRDirection() {
            return this.globalRoutingDelta;
        }

        public Rectangle2D[] getOrderedBuckets() {
            return this.orderedBuckets;
        }

        public SearchVertex getFinalSearchVertex() {
            return this.solution;
        }

        public SearchVertex getNextSearchVertex() {
            SearchVertex sv = this.active.getFirst();
            if (sv == null) {
                return svExhausted;
            }
            return sv;
        }

        public SearchVertex getVertex(double x, double y, int z) {
            Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                return null;
            }
            Map<Integer, SearchVertex> row = plane.get((int)Math.round(y * 400.0));
            if (row == null) {
                return null;
            }
            SearchVertex found = row.get((int)Math.round(x * 400.0));
            return found;
        }

        public void setVertex(double x, double y, int z, SearchVertex sv) {
            Integer iY;
            Map<Integer, SearchVertex> row;
            Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                this.searchVertexPlanes[z] = plane = new TreeMap<Integer, Map<Integer, SearchVertex>>();
            }
            if ((row = plane.get(iY = Integer.valueOf((int)Math.round(y * 400.0)))) == null) {
                row = new TreeMap<Integer, SearchVertex>();
                plane.put(iY, row);
            }
            row.put((int)Math.round(x * 400.0), sv);
        }

        public Map<Integer, Map<Integer, SearchVertex>>[] getSearchVertexPlanes() {
            return this.searchVertexPlanes;
        }

        private void initDebugStrings() {
            this.debugString = new String[7];
        }

        private void setDebugStringHeader(String str) {
            this.debugString[0] = str;
        }

        private void setDebugString(int direction, String str) {
            this.debugString[direction + 1] = str;
        }

        private void addDebugString(int direction, String str) {
            int n2 = direction + 1;
            this.debugString[n2] = this.debugString[n2] + str;
        }

        private void completeDebugString(int direction, String str) {
            int n2 = direction + 1;
            this.debugString[n2] = this.debugString[n2] + str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SearchVertex advanceWavefront() {
            int lastDirection;
            ++this.numStepsMade;
            if (this.numStepsMade > this.nr.complexityLimit) {
                this.solution = svLimited;
                return this.solution;
            }
            SearchVertex svCurrent = this.getNextSearchVertex();
            if (svCurrent == svExhausted) {
                this.solution = svCurrent;
                return this.solution;
            }
            this.active.remove(svCurrent);
            this.inactive.add(svCurrent);
            double curX = svCurrent.getX();
            double curY = svCurrent.getY();
            int curZ = svCurrent.getZ();
            int curC = svCurrent.getC();
            if (this.debuggingWavefront) {
                this.initDebugStrings();
                String str = "At: (" + TextUtils.formatDistance(curX) + "," + TextUtils.formatDistance(curY) + "," + SeaOfGatesEngine.describeMetal(curZ, curC) + "), Cost: " + svCurrent.cost;
                str = this.globalRoutingDelta == 0 ? str + ", NO Global Routing" : str + ", Global Routing Bucket: " + svCurrent.globalRoutingBucket;
                this.setDebugStringHeader(str);
            }
            if ((lastDirection = svCurrent.getAutoGen()) >= 0) {
                svCurrent.generateIntermediateVertex(lastDirection, this.toPE.getGriddedRect(), SeaOfGatesEngine.this.cell);
            }
            SearchVertex destinationSV = null;
            block17: for (int i2 = 0; i2 < 6; ++i2) {
                int c2;
                Object costExplanation;
                int newCost;
                SearchVertex svNext;
                boolean penaltyOffGridY;
                boolean penaltyOffGridX;
                SearchVertex alreadyThere;
                int nZ;
                double nY;
                double nX;
                int dz;
                double dy;
                double dx;
                block230: {
                    block228: {
                        block229: {
                            boolean foundDest;
                            SearchVertexAddon extraGeometryforMinArea;
                            Point2D.Double size;
                            Poly[] cuts;
                            int whichContact;
                            int nC;
                            boolean closeToEnd;
                            boolean tooFarFromEnd;
                            block227: {
                                String[] failureReasons;
                                List<MetalVia> nps;
                                int highMetal;
                                int lowMetal;
                                block226: {
                                    block225: {
                                        List<MetalVia> nps2X;
                                        block219: {
                                            block222: {
                                                block223: {
                                                    block224: {
                                                        block221: {
                                                            block220: {
                                                                double distY;
                                                                double distX;
                                                                double dist;
                                                                dx = 0.0;
                                                                dy = 0.0;
                                                                dz = 0;
                                                                tooFarFromEnd = false;
                                                                closeToEnd = false;
                                                                StringBuffer jumpExplanation = null;
                                                                if (this.debuggingWavefront) {
                                                                    jumpExplanation = new StringBuffer();
                                                                }
                                                                switch (i2) {
                                                                    case 0: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.setDebugString(i2, "Cannot move in -X axis");
                                                                            continue block17;
                                                                        }
                                                                        dx = this.toPE.isWithinNonzeroX(curX, curY) ? this.toPE.getClosestX(curX) - curX : (this.toPE.atGoalPoint(curX - 1.0, curY) ? -1.0 : this.nr.getLowerXGrid(curZ, curX - 1.0).getCoordinate() - curX);
                                                                        if (!(this.nr.gridLocationsX[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.upToGrainAlways(curX + dx)) == curX + dx)) {
                                                                            dx = intermediate - curX;
                                                                        }
                                                                        if (this.toPE.isBelowX(curX) && (dx = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) >= 0.0) {
                                                                            dx = -1.0;
                                                                        }
                                                                        if (this.debuggingWavefront) {
                                                                            this.setDebugString(i2, "Move " + (dx < 0.0 ? "" : "+") + TextUtils.formatDistance(dx));
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.addDebugString(i2, " [" + jumpExplanation.toString() + "]");
                                                                            } else if (!this.toPE.isBelowX(curX)) {
                                                                                this.addDebugString(i2, " [already at Y=" + TextUtils.formatDistance(curX) + " which is to left of " + TextUtils.formatDistance(this.toPE.getCenterX()) + "]");
                                                                            }
                                                                        }
                                                                        if (this.nr.gridLocationsX[curZ] == null || !this.nr.forceGridArcs[curZ] || this.toPE.atGoalPoint(curX + dx, curY) && curZ == this.toZ) break;
                                                                        double gridX = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate();
                                                                        if (gridX == curX) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.addDebugString(i2, ", but gridded right to " + TextUtils.formatDistance(gridX) + " (no movement)");
                                                                            continue block17;
                                                                        }
                                                                        dx = gridX - curX;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.setDebugString(i2, "Cannot move in +X axis");
                                                                            continue block17;
                                                                        }
                                                                        dx = this.toPE.isWithinNonzeroX(curX, curY) ? this.toPE.getClosestX(curX) - curX : (this.toPE.atGoalPoint(curX + 1.0, curY) ? 1.0 : this.nr.getLowerXGrid(curZ, curX + 1.0).getCoordinate() - curX);
                                                                        if (!(this.nr.gridLocationsX[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.downToGrainAlways(curX + dx)) == curX + dx)) {
                                                                            dx = intermediate - curX;
                                                                        }
                                                                        if (this.toPE.isAboveX(curX) && (dx = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) <= 0.0) {
                                                                            dx = 1.0;
                                                                        }
                                                                        if (this.debuggingWavefront) {
                                                                            this.setDebugString(i2, "Move " + (dx < 0.0 ? "" : "+") + TextUtils.formatDistance(dx));
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.addDebugString(i2, " [" + jumpExplanation.toString() + "]");
                                                                            } else if (!this.toPE.isAboveX(curX)) {
                                                                                this.addDebugString(i2, " [already at Y=" + TextUtils.formatDistance(curX) + " which is to right of " + TextUtils.formatDistance(this.toPE.getCenterX()) + "]");
                                                                            }
                                                                        }
                                                                        if (this.nr.gridLocationsX[curZ] == null || !this.nr.forceGridArcs[curZ] || this.toPE.atGoalPoint(curX + dx, curY) && curZ == this.toZ) break;
                                                                        double gridX = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate();
                                                                        if (gridX == curX) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.addDebugString(i2, ", but gridded left to " + TextUtils.formatDistance(gridX) + " (no movement)");
                                                                            continue block17;
                                                                        }
                                                                        dx = gridX - curX;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.setDebugString(i2, "Cannot move in -Y axis");
                                                                            continue block17;
                                                                        }
                                                                        dy = this.toPE.isWithinNonzeroY(curX, curY) ? this.toPE.getClosestY(curX) - curY : (this.toPE.atGoalPoint(curX, curY - 1.0) ? -1.0 : this.nr.getLowerYGrid(curZ, curY - 1.0).getCoordinate() - curY);
                                                                        if (!(this.nr.gridLocationsY[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.upToGrainAlways(curY + dy)) == curY + dy)) {
                                                                            dy = intermediate - curY;
                                                                        }
                                                                        if (this.toPE.isBelowY(curY) && (dy = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) >= 0.0) {
                                                                            dy = -1.0;
                                                                        }
                                                                        if (this.debuggingWavefront) {
                                                                            this.setDebugString(i2, "Move " + (dy < 0.0 ? "" : "+") + TextUtils.formatDistance(dy));
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.addDebugString(i2, " [" + jumpExplanation.toString() + "]");
                                                                            } else if (!this.toPE.isBelowY(curY)) {
                                                                                this.addDebugString(i2, " [already at Y=" + TextUtils.formatDistance(curY) + " which is below " + TextUtils.formatDistance(this.toPE.getCenterY()) + "]");
                                                                            }
                                                                        }
                                                                        if (this.nr.gridLocationsY[curZ] == null || !this.nr.forceGridArcs[curZ] || this.toPE.atGoalPoint(curX, curY + dy) && curZ == this.toZ) break;
                                                                        double gridY = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate();
                                                                        if (gridY == curY) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.addDebugString(i2, ", but gridded up to " + TextUtils.formatDistance(gridY) + " (no movement)");
                                                                            continue block17;
                                                                        }
                                                                        dy = gridY - curY;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.setDebugString(i2, "Cannot move in +Y axis");
                                                                            continue block17;
                                                                        }
                                                                        dy = this.toPE.isWithinNonzeroY(curX, curY) ? this.toPE.getClosestY(curX) - curY : (this.toPE.atGoalPoint(curX, curY + 1.0) ? 1.0 : this.nr.getLowerYGrid(curZ, curY + 1.0).getCoordinate() - curY);
                                                                        if (!(this.nr.gridLocationsY[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.downToGrainAlways(curY + dy)) == curY + dy)) {
                                                                            dy = intermediate - curY;
                                                                        }
                                                                        if (this.toPE.isAboveY(curY) && (dy = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) <= 0.0) {
                                                                            dy = 1.0;
                                                                        }
                                                                        if (this.debuggingWavefront) {
                                                                            this.setDebugString(i2, "Move " + (dy < 0.0 ? "" : "+") + TextUtils.formatDistance(dy));
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.addDebugString(i2, " [" + jumpExplanation.toString() + "]");
                                                                            } else if (!this.toPE.isAboveY(curY)) {
                                                                                this.addDebugString(i2, " [already at Y=" + TextUtils.formatDistance(curY) + " which is above " + TextUtils.formatDistance(this.toPE.getCenterY()) + "]");
                                                                            }
                                                                        }
                                                                        if (this.nr.gridLocationsY[curZ] == null || !this.nr.forceGridArcs[curZ] || this.toPE.atGoalPoint(curX, curY + dy) && curZ == this.toZ) break;
                                                                        double gridY = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate();
                                                                        if (gridY == curY) {
                                                                            if (!this.debuggingWavefront) continue block17;
                                                                            this.addDebugString(i2, ", but gridded down to " + TextUtils.formatDistance(gridY) + " (no movement)");
                                                                            continue block17;
                                                                        }
                                                                        dy = gridY - curY;
                                                                        break;
                                                                    }
                                                                    case 4: {
                                                                        dz = -1;
                                                                        if (!this.debuggingWavefront) break;
                                                                        this.setDebugString(i2, "Move -1");
                                                                        break;
                                                                    }
                                                                    case 5: {
                                                                        dz = 1;
                                                                        if (!this.debuggingWavefront) break;
                                                                        this.setDebugString(i2, "Move +1");
                                                                    }
                                                                }
                                                                nX = curX + dx;
                                                                nY = curY + dy;
                                                                nZ = curZ + dz;
                                                                nC = curC;
                                                                if (dz != 0) break block220;
                                                                if (this.fromTaperLen >= 0.0 && !svCurrent.isOffInitialSegment() && (dist = Math.sqrt((distX = nX - this.fromX) * distX + (distY = nY - this.fromY) * distY)) > this.fromTaperLen) {
                                                                    if (!this.debuggingWavefront) continue;
                                                                    this.completeDebugString(i2, ": initial taper is " + TextUtils.formatDistance(dist) + " from start but maximum taper is " + TextUtils.formatDistance(this.fromTaperLen));
                                                                    continue;
                                                                }
                                                                break block219;
                                                            }
                                                            if (nZ < 0 || nZ >= numMetalLayers) {
                                                                if (!this.debuggingWavefront) continue;
                                                                this.completeDebugString(i2, ": Out Of Bounds");
                                                                continue;
                                                            }
                                                            if (this.nr.preventArc(nZ)) {
                                                                if (!this.debuggingWavefront) continue;
                                                                this.completeDebugString(i2, ": Disallowed Arc");
                                                                continue;
                                                            }
                                                            if (this.nr.forceGridArcs[nZ]) {
                                                                boolean hor = true;
                                                                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                    if (nZ % 2 == 0) {
                                                                        hor = false;
                                                                    }
                                                                } else if (nZ % 2 != 0) {
                                                                    hor = false;
                                                                }
                                                                if (!hor && !this.nr.isOnXGrid(nZ, curX)) {
                                                                    if (!this.debuggingWavefront) continue;
                                                                    this.setDebugString(i2, "Not on metal " + (nZ + 1) + " X grid");
                                                                    continue;
                                                                }
                                                                if (hor && !this.nr.isOnYGrid(nZ, curY)) {
                                                                    if (!this.debuggingWavefront) continue;
                                                                    this.setDebugString(i2, "Not on metal " + (nZ + 1) + " Y grid");
                                                                    continue;
                                                                }
                                                            }
                                                            if (nZ == this.toZ && this.toTaperLen >= 0.0 && this.toPE.isOnGoalAxis(nX, nY)) {
                                                                double closest = this.toPE.getDistToGoal(nX, nY);
                                                                if (closest > this.toTaperLen) {
                                                                    if (SeaOfGatesEngine.this.taperOnlyArcs[nZ]) {
                                                                        if (!this.debuggingWavefront) continue;
                                                                        this.completeDebugString(i2, ": Taper-only layer too far from destination");
                                                                        continue;
                                                                    }
                                                                    tooFarFromEnd = true;
                                                                } else {
                                                                    closeToEnd = true;
                                                                }
                                                            }
                                                            if (SeaOfGatesEngine.this.metalLayers[nZ].length != 1) break block221;
                                                            nC = 0;
                                                            break block219;
                                                        }
                                                        if (!SeaOfGatesEngine.this.sogp.isForceHorVer()) break block222;
                                                        if (nZ % 2 == 0 != SeaOfGatesEngine.this.sogp.isHorizontalEven()) break block223;
                                                        if (this.nr.gridLocationsX[nZ] != null) break block224;
                                                        System.out.println("WARNING: No X grid information for Metal " + (nZ + 1));
                                                        break block222;
                                                    }
                                                    SeaOfGates.SeaOfGatesTrack sogt = this.nr.getClosestXGrid(nZ, nX);
                                                    nC = sogt.getMaskNum();
                                                    if (nC != 0) {
                                                        if (this.nr.is2X(nZ, curX, curY, nX, nY)) {
                                                            nC = SeaOfGatesEngine.this.metalLayers[nZ].length + 1 - nC;
                                                        }
                                                        break block222;
                                                    } else {
                                                        System.out.println("WARNING: No mask color for Metal " + (nZ + 1) + " at X=" + TextUtils.formatDistance(nX));
                                                    }
                                                    break block222;
                                                }
                                                if (this.nr.gridLocationsY[nZ] == null) {
                                                    System.out.println("WARNING: No Y grid information for Metal " + (nZ + 1));
                                                } else {
                                                    SeaOfGates.SeaOfGatesTrack sogt = this.nr.getClosestYGrid(nZ, nY);
                                                    nC = sogt.getMaskNum();
                                                    if (nC != 0) {
                                                        if (this.nr.is2X(nZ, curX, curY, nX, nY)) {
                                                            nC = SeaOfGatesEngine.this.metalLayers[nZ].length + 1 - nC;
                                                        }
                                                    } else {
                                                        System.out.println("WARNING: No mask color for Metal " + (nZ + 1) + " at Y=" + TextUtils.formatDistance(nY));
                                                    }
                                                }
                                            }
                                            if (nC == 0) {
                                                nC = curC;
                                                if (nZ == this.toZ) {
                                                    nC = this.toC;
                                                }
                                                if (SeaOfGatesEngine.this.tech.hasColoredMetalLayer(SeaOfGatesEngine.this.primaryMetalLayer[nZ])) {
                                                    BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[nZ]);
                                                    bTree.lock();
                                                    try {
                                                        if (!bTree.isEmpty()) {
                                                            Rectangle2D.Double searchArea = new Rectangle2D.Double(nX, nY, 0.0, 0.0);
                                                            Iterator<SOGBound> sea = bTree.search(searchArea);
                                                            while (sea.hasNext()) {
                                                                SOGBound sBound = sea.next();
                                                                if (!sBound.isSameBasicNet(this.nr.netID)) continue;
                                                                nC = sBound.getMaskColor();
                                                            }
                                                        }
                                                    }
                                                    finally {
                                                        bTree.unlock();
                                                    }
                                                }
                                            }
                                        }
                                        if (this.globalRoutingDelta != 0) {
                                            Rectangle2D limit = this.orderedBuckets[svCurrent.globalRoutingBucket];
                                            if (nX < limit.getMinX()) {
                                                nX = limit.getMinX();
                                                if (!this.toPE.atGoalPoint(nX, curY)) {
                                                    nX = this.nr.getUpperXGrid(curZ, nX).getCoordinate();
                                                }
                                                if ((dx = nX - curX) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i2, ": Out Of Global Routing X Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nX > limit.getMaxX()) {
                                                nX = limit.getMaxX();
                                                if (!this.toPE.atGoalPoint(nX, curY)) {
                                                    nX = this.nr.getLowerXGrid(curZ, nX).getCoordinate();
                                                }
                                                if ((dx = nX - curX) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i2, ": Out Of Global Routing X Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nY < limit.getMinY()) {
                                                nY = limit.getMinY();
                                                if (!this.toPE.atGoalPoint(curX, nY)) {
                                                    nY = this.nr.getUpperYGrid(curZ, nY).getCoordinate();
                                                }
                                                if ((dy = nY - curY) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i2, ": Out Of Global Routing Y Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nY > limit.getMaxY()) {
                                                nY = limit.getMaxY();
                                                if (!this.toPE.atGoalPoint(curX, nY)) {
                                                    nY = this.nr.getLowerYGrid(curZ, nY).getCoordinate();
                                                }
                                                if ((dy = nY - curY) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i2, ": Out Of Global Routing Y Bounds");
                                                    continue;
                                                }
                                            }
                                        }
                                        if (nX < this.nr.routeBounds.getMinX()) {
                                            nX = this.nr.routeBounds.getMinX();
                                            if (!this.toPE.atGoalPoint(nX, curY)) {
                                                nX = this.nr.getUpperXGrid(curZ, nX).getCoordinate();
                                            }
                                            if ((dx = nX - curX) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i2, ": Out Of X Bounds");
                                                continue;
                                            }
                                        }
                                        if (nX > this.nr.routeBounds.getMaxX()) {
                                            nX = this.nr.routeBounds.getMaxX();
                                            if (!this.toPE.atGoalPoint(nX, curY)) {
                                                nX = this.nr.getLowerXGrid(curZ, nX).getCoordinate();
                                            }
                                            if ((dx = nX - curX) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i2, ": Out Of X Bounds");
                                                continue;
                                            }
                                        }
                                        if (nY < this.nr.routeBounds.getMinY()) {
                                            nY = this.nr.routeBounds.getMinY();
                                            if (!this.toPE.atGoalPoint(curX, nY)) {
                                                nY = this.nr.getUpperYGrid(curZ, nY).getCoordinate();
                                            }
                                            if ((dy = nY - curY) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i2, ": Out Of Y Bounds");
                                                continue;
                                            }
                                        }
                                        if (nY > this.nr.routeBounds.getMaxY()) {
                                            nY = this.nr.routeBounds.getMaxY();
                                            if (!this.toPE.atGoalPoint(curX, nY)) {
                                                nY = this.nr.getLowerYGrid(curZ, nY).getCoordinate();
                                            }
                                            if ((dy = nY - curY) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i2, ": Out Of Y Bounds");
                                                continue;
                                            }
                                        }
                                        if ((alreadyThere = this.getVertex(nX, nY, nZ)) != null && !this.active.inList(alreadyThere)) {
                                            if (!this.debuggingWavefront) continue;
                                            this.completeDebugString(i2, ": Already Visited");
                                            continue;
                                        }
                                        whichContact = 0;
                                        cuts = null;
                                        size = null;
                                        extraGeometryforMinArea = null;
                                        if (dz == 0) break block225;
                                        lowMetal = Math.min(curZ, nZ);
                                        highMetal = Math.max(curZ, nZ);
                                        nps = SeaOfGatesEngine.this.metalVias[lowMetal].getVias();
                                        if ((this.nr.is2X(lowMetal, curX, curY, nX, nY) || this.nr.is2X(highMetal, curX, curY, nX, nY)) && (nps2X = SeaOfGatesEngine.this.metalVias2X[lowMetal].getVias()).size() > 0) {
                                            nps = nps2X;
                                        }
                                        whichContact = -1;
                                        failureReasons = null;
                                        if (this.debuggingWavefront) {
                                            failureReasons = new String[nps.size()];
                                        }
                                        break block226;
                                    }
                                    double width = this.nr.getArcWidth(nZ, curX, curY, nX, nY);
                                    double metalSpacing = width / 2.0;
                                    boolean allClear = false;
                                    double initNX = nX;
                                    double initNY = nY;
                                    Object explanation = null;
                                    if (this.debuggingWavefront) {
                                        explanation = "";
                                    }
                                    while (true) {
                                        SOGBound sb;
                                        SearchVertex prevPath = svCurrent;
                                        double checkX = (curX + nX) / 2.0;
                                        double checkY = (curY + nY) / 2.0;
                                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                                        while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                                            if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                                                checkY = (prevPath.last.yv + nY) / 2.0;
                                                halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                                                prevPath = prevPath.last;
                                                continue;
                                            }
                                            if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                                            checkX = (prevPath.last.xv + nX) / 2.0;
                                            halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                                            prevPath = prevPath.last;
                                        }
                                        StringBuffer reason = null;
                                        if (this.debuggingWavefront) {
                                            reason = new StringBuffer();
                                        }
                                        if ((sb = this.getMetalBlockageAndNotch(nZ, nC, halfWid, halfHei, checkX, checkY, prevPath, false, reason)) == null) {
                                            allClear = true;
                                            break;
                                        }
                                        if (this.debuggingWavefront) {
                                            explanation = (String)explanation + ": Blocked on " + SeaOfGatesEngine.describeMetal(nZ, nC) + " because proposed " + TextUtils.formatDistance(checkX - halfWid) + "<=X<=" + TextUtils.formatDistance(checkX + halfWid) + " and " + TextUtils.formatDistance(checkY - halfHei) + "<=Y<=" + TextUtils.formatDistance(checkY + halfHei) + " is less than " + TextUtils.formatDistance(metalSpacing) + " to " + TextUtils.formatDistance(sb.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(sb.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(sb.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(sb.getBounds().getMaxY()) + " (" + reason.toString() + " error)";
                                        }
                                        if (i2 == 0) {
                                            newNX = nX + 1.0;
                                            newNX = !this.nr.forceGridArcs[nZ] && this.toPE.atGoalPoint(newNX, curY) ? this.nr.downToGrainAlways(newNX) : this.nr.getUpperXGrid(curZ, newNX).getCoordinate();
                                            if (newNX >= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0) {
                                                break;
                                            }
                                        } else if (i2 == 1) {
                                            newNX = nX - 1.0;
                                            newNX = !this.nr.forceGridArcs[nZ] && this.toPE.atGoalPoint(newNX, curY) ? this.nr.upToGrainAlways(newNX) : this.nr.getLowerXGrid(curZ, newNX).getCoordinate();
                                            if (newNX <= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0) {
                                                break;
                                            }
                                        } else if (i2 == 2) {
                                            newNY = nY + 1.0;
                                            newNY = !this.nr.forceGridArcs[nZ] && this.toPE.atGoalPoint(curX, newNY) ? this.nr.downToGrainAlways(newNY) : this.nr.getUpperYGrid(curZ, newNY).getCoordinate();
                                            if (newNY >= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0) {
                                                break;
                                            }
                                        } else if (i2 == 3) {
                                            newNY = nY - 1.0;
                                            newNY = !this.nr.forceGridArcs[nZ] && this.toPE.atGoalPoint(curX, newNY) ? this.nr.upToGrainAlways(newNY) : this.nr.getLowerYGrid(curZ, newNY).getCoordinate();
                                            if (newNY <= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0) break;
                                        }
                                        nX = curX + dx;
                                        nY = curY + dy;
                                    }
                                    if (!allClear) {
                                        double[] surround;
                                        double halfHei;
                                        if (!this.debuggingWavefront) continue;
                                        double checkX = (curX + nX) / 2.0;
                                        double checkY = (curY + nY) / 2.0;
                                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                                        SOGBound sb = this.nr.getMetalBlockage(this.nr.netID, nZ, nC, halfWid, halfHei = metalSpacing + Math.abs(dy) / 2.0, surround = this.nr.getSpacingRule(nZ, SeaOfGatesEngine.this.maxDefArcWidth[nZ], -1.0), checkX, checkY);
                                        explanation = sb != null ? (String)explanation + ": Blocked" : (String)explanation + ": Blocked, Notch";
                                        this.completeDebugString(i2, (String)explanation);
                                        continue;
                                    }
                                    if (!this.debuggingWavefront) break block227;
                                    if (initNX != nX || initNY != nY) {
                                        explanation = (String)explanation + " so move only ";
                                        switch (i2) {
                                            case 0: {
                                                explanation = (String)explanation + TextUtils.formatDistance(Math.abs(dx));
                                                break;
                                            }
                                            case 1: {
                                                explanation = (String)explanation + TextUtils.formatDistance(dx);
                                                break;
                                            }
                                            case 2: {
                                                explanation = (String)explanation + TextUtils.formatDistance(Math.abs(dy));
                                                break;
                                            }
                                            case 3: {
                                                explanation = (String)explanation + TextUtils.formatDistance(dy);
                                                break;
                                            }
                                        }
                                    }
                                    this.addDebugString(i2, (String)explanation);
                                    break block227;
                                }
                                for (int contactNo = 0; contactNo < nps.size(); ++contactNo) {
                                    MetalVia mv = nps.get(contactNo);
                                    if (mv.horMetal == curZ) {
                                        if (mv.horMetalColor != curC || mv.verMetalColor != nC) {
                                            if (!this.debuggingWavefront) continue;
                                            failureReasons[contactNo] = "masks are " + mv.horMetalColor + " and " + mv.verMetalColor + " but want masks " + curC + " and " + nC;
                                            continue;
                                        }
                                    } else if (mv.verMetal == curZ && (mv.verMetalColor != curC || mv.horMetalColor != nC)) {
                                        if (!this.debuggingWavefront) continue;
                                        failureReasons[contactNo] = "masks are " + mv.verMetalColor + " and " + mv.horMetalColor + " but want masks " + curC + " and " + nC;
                                        continue;
                                    }
                                    MutableDouble conWid = new MutableDouble(0.0);
                                    MutableDouble conHei = new MutableDouble(0.0);
                                    double lastX = nX;
                                    double lastY = nY;
                                    SearchVertex prev = svCurrent.getLast();
                                    if (prev != null) {
                                        lastX = prev.getX();
                                        lastY = prev.getY();
                                        if (closeToEnd && (lastX != this.fromX || lastY != this.fromY)) {
                                            EPoint closest = this.toPE.getClosestPoint(curX, curY);
                                            lastX = closest.getX();
                                            lastY = closest.getY();
                                        }
                                    }
                                    Orientation orient = this.nr.getMVSize(mv, nX, nY, lastX, lastY, conWid, conHei);
                                    PrimitiveNode np = mv.via;
                                    NodeInst dummyNi = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(nX, nY), conWid.doubleValue(), conHei.doubleValue(), orient);
                                    Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                                    FixpTransform trans = null;
                                    if (orient != Orientation.IDENT) {
                                        trans = dummyNi.rotateOut();
                                    }
                                    int cutCount = 0;
                                    for (int p = 0; p < conPolys.length; ++p) {
                                        if (!conPolys[p].getLayer().getFunction().isContact()) continue;
                                        ++cutCount;
                                    }
                                    Poly[] curCuts = new Poly[cutCount];
                                    cutCount = 0;
                                    Object failedReason = null;
                                    boolean contactFailed = false;
                                    for (int p = 0; p < conPolys.length; ++p) {
                                        Poly conPoly = conPolys[p];
                                        if (trans != null) {
                                            conPoly.transform(trans);
                                        }
                                        FixpRectangle conRect = conPoly.getBounds2D();
                                        Layer conLayer = conPoly.getLayer();
                                        Layer.Function lFun = conLayer.getFunction();
                                        if (lFun.isMetal()) {
                                            SOGBound sb;
                                            int metalNo = lFun.getLevel() - 1;
                                            int maskNo = lFun.getMaskColor();
                                            double halfWid = ((RectangularShape)conRect).getWidth() / 2.0;
                                            double halfHei = ((RectangularShape)conRect).getHeight() / 2.0;
                                            StringBuffer reason = null;
                                            if (this.debuggingWavefront) {
                                                reason = new StringBuffer();
                                            }
                                            if ((sb = this.getMetalBlockageAndNotch(metalNo, maskNo, halfWid, halfHei, ((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY(), svCurrent, false, reason)) == null) continue;
                                            contactFailed = true;
                                            if (!this.debuggingWavefront) break;
                                            SizeOffset so = np.getProtoSizeOffset();
                                            double xOffset = so.getLowXOffset() + so.getHighXOffset();
                                            double yOffset = so.getLowYOffset() + so.getHighYOffset();
                                            failedReason = "layer " + conLayer.getName() + " of " + TextUtils.formatDistance(conWid.doubleValue() - xOffset) + "x" + TextUtils.formatDistance(conHei.doubleValue() - yOffset) + " " + np.describe(false) + " at " + TextUtils.formatDistance(((RectangularShape)conRect).getMinX()) + "<=X<=" + TextUtils.formatDistance(((RectangularShape)conRect).getMaxX()) + " and " + TextUtils.formatDistance(((RectangularShape)conRect).getMinY()) + "<=Y<=" + TextUtils.formatDistance(((RectangularShape)conRect).getMaxY()) + " on net " + String.valueOf(this.nr.netID) + " has " + reason.toString() + " error with " + TextUtils.formatDistance(sb.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(sb.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(sb.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(sb.getBounds().getMaxY()) + " on net " + String.valueOf(sb.getNetID());
                                            break;
                                        }
                                        if (!lFun.isContact()) continue;
                                        String error = this.validCut(svCurrent, lowMetal, highMetal, conRect, conLayer);
                                        if (error != null) {
                                            if (this.debuggingWavefront) {
                                                failedReason = error;
                                            }
                                            contactFailed = true;
                                            break;
                                        }
                                        curCuts[cutCount++] = conPoly;
                                    }
                                    if (contactFailed) {
                                        if (!this.debuggingWavefront) continue;
                                        failureReasons[contactNo] = failedReason;
                                        continue;
                                    }
                                    StringBuffer message = new StringBuffer();
                                    MutableBoolean error = new MutableBoolean(false);
                                    extraGeometryforMinArea = this.determineMinimumArea(svCurrent, nX, nY, nC, nZ, curC, curZ, mv, conWid.doubleValue(), conHei.doubleValue(), error, message, false);
                                    if (error.booleanValue()) {
                                        if (message.length() <= 0 || !this.debuggingWavefront) continue;
                                        failureReasons[contactNo] = message.toString();
                                        continue;
                                    }
                                    whichContact = contactNo;
                                    cuts = curCuts;
                                    size = new Point2D.Double(conWid.doubleValue(), conHei.doubleValue());
                                    break;
                                }
                                if (whichContact < 0) {
                                    if (!this.debuggingWavefront) continue;
                                    Object further = ": Blocked because:";
                                    for (int contactNo = 0; contactNo < failureReasons.length; ++contactNo) {
                                        MetalVia mv = nps.get(contactNo);
                                        further = (String)further + "|In " + SeaOfGatesEngine.this.describe(mv.via);
                                        if (mv.orientation != 0) {
                                            further = (String)further + " (rotated " + mv.orientation + ")";
                                        }
                                        further = (String)further + " cannot place: " + failureReasons[contactNo];
                                    }
                                    this.completeDebugString(i2, (String)further);
                                    continue;
                                }
                            }
                            boolean bl = foundDest = this.toPE.isToPoint(nX, nY) && nZ == this.toZ;
                            if (svCurrent.isMustCompleteRoute() && !foundDest) {
                                if (!this.debuggingWavefront) continue;
                                this.completeDebugString(i2, ": Switched to taper layer so must connect to destination");
                                continue;
                            }
                            if (svCurrent.isCantCompleteRoute() && foundDest) {
                                if (!this.debuggingWavefront) continue;
                                this.completeDebugString(i2, ": Switched to taper layer too far from destination");
                                continue;
                            }
                            if (foundDest) {
                                StringBuffer message = new StringBuffer();
                                MutableBoolean error = new MutableBoolean(false);
                                extraGeometryforMinArea = this.determineMinimumArea(svCurrent, nX, nY, nC, nZ, curC, curZ, null, 0.0, 0.0, error, message, true);
                                if (error.booleanValue()) {
                                    if (message.length() <= 0 || !this.debuggingWavefront) continue;
                                    this.completeDebugString(i2, ": Blocked because " + message.toString());
                                    continue;
                                }
                            }
                            boolean hor = true;
                            if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                if ((nZ + 1) % 2 != 0) {
                                    hor = false;
                                }
                            } else if ((nZ + 1) % 2 == 0) {
                                hor = false;
                            }
                            if (this.nr.forceGridArcs[nZ] && !foundDest) {
                                if (this.nr.gridLocationsX[nZ] != null && hor && !this.nr.isOnXGrid(nZ, nX)) {
                                    if (!this.debuggingWavefront) continue;
                                    this.completeDebugString(i2, ": Not on X grid");
                                    continue;
                                }
                                if (this.nr.gridLocationsY[nZ] != null && !hor && !this.nr.isOnYGrid(nZ, nY)) {
                                    if (!this.debuggingWavefront) continue;
                                    this.completeDebugString(i2, ": Not on Y grid");
                                    continue;
                                }
                            }
                            penaltyOffGridX = false;
                            boolean inGoalX = this.toPE.isOutOfGoalX(nX);
                            if ((inGoalX &= nX != this.fromX) || this.nr.forceGridArcs[nZ]) {
                                if (this.nr.gridLocationsX[nZ] == null) {
                                    penaltyOffGridX = this.nr.downToGrainAlways(nX) != nX;
                                } else if (!hor) {
                                    penaltyOffGridX = !this.nr.isOnXGrid(nZ, nX);
                                }
                            }
                            penaltyOffGridY = false;
                            boolean inGoalY = this.toPE.isOutOfGoalY(nY);
                            if ((inGoalY &= nY != this.fromY) || this.nr.forceGridArcs[nZ]) {
                                if (this.nr.gridLocationsY[nZ] == null) {
                                    penaltyOffGridY = this.nr.downToGrainAlways(nY) != nY;
                                } else if (hor) {
                                    penaltyOffGridY = !this.nr.isOnYGrid(nZ, nY);
                                }
                            }
                            int newFlags = svCurrent.flags;
                            if (curZ != nZ) {
                                newFlags &= 0xFFFFFFFD;
                            }
                            if (dz != 0) {
                                newFlags |= 1;
                            }
                            if (tooFarFromEnd) {
                                newFlags |= 2;
                            }
                            if (closeToEnd) {
                                newFlags |= 4;
                            }
                            svNext = new SearchVertex(nX, nY, nZ, nC, whichContact, cuts, size, Math.min(curZ, nZ), this, newFlags, extraGeometryforMinArea);
                            if (this.debuggingWavefront) {
                                RoutingDebug.ensureDebuggingShadow(svNext, false);
                            }
                            if (dz == 0 && (Math.abs(dx) >= 2.0 || Math.abs(dy) >= 2.0)) {
                                svNext.setAutoGen(i2);
                            }
                            svNext.last = svCurrent;
                            if (foundDest) {
                                if (this.debuggingWavefront) {
                                    RoutingDebug.saveSVLink(svNext, i2);
                                    this.completeDebugString(i2, ": Found Destination!");
                                }
                                destinationSV = svNext;
                                continue;
                            }
                            if (this.globalRoutingDelta != 0) {
                                svNext.globalRoutingBucket = this.getNextBucket(svCurrent, nX, nY);
                            }
                            newCost = svCurrent.cost;
                            costExplanation = "";
                            double distBefore = this.toPE.getDistToGoal(curX, curY);
                            double distAfter = this.toPE.getDistToGoal(nX, nY);
                            c2 = (int)((distAfter - distBefore) / 5.0);
                            newCost += c2;
                            if (this.debuggingWavefront) {
                                costExplanation = " [COST: Progress-to-target=" + c2;
                            }
                            if (dx != 0.0) {
                                if (!this.toPE.isOutOfGoalX(curX)) {
                                    c2 = 7;
                                    newCost += c2;
                                    if (this.debuggingWavefront) {
                                        costExplanation = (String)costExplanation + " Zero-X-progress=" + c2;
                                    }
                                } else if ((this.toPE.getCenterX() - curX) * dx < 0.0) {
                                    if (!this.toPE.isOutOfGoalY(curY)) {
                                        c2 = 1;
                                        newCost += c2;
                                        if (this.debuggingWavefront) {
                                            costExplanation = (String)costExplanation + " Backward-X-progress-at-dest-Y=" + c2;
                                        }
                                    } else {
                                        c2 = 15;
                                        newCost += c2;
                                        if (this.debuggingWavefront) {
                                            costExplanation = (String)costExplanation + " Backward-X-progress=" + c2;
                                        }
                                    }
                                }
                                if (SeaOfGatesEngine.this.sogp.isFavorHorVer() && nZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                    c2 = (int)Math.round(20.0 * Math.abs(dx));
                                    newCost += c2;
                                    if (this.debuggingWavefront) {
                                        costExplanation = (String)costExplanation + " Not-alternating-metal=" + c2;
                                    }
                                }
                            }
                            if (dy != 0.0) {
                                if (!this.toPE.isOutOfGoalY(curY)) {
                                    c2 = 7;
                                    newCost += c2;
                                    if (this.debuggingWavefront) {
                                        costExplanation = (String)costExplanation + " Zero-Y-progress=" + c2;
                                    }
                                } else if ((this.toPE.getCenterY() - curY) * dy < 0.0) {
                                    if (!this.toPE.isOutOfGoalX(curX)) {
                                        c2 = 1;
                                        newCost += c2;
                                        if (this.debuggingWavefront) {
                                            costExplanation = (String)costExplanation + " Backward-Y-progress-at-dest-X=" + c2;
                                        }
                                    } else {
                                        c2 = 15;
                                        newCost += c2;
                                        if (this.debuggingWavefront) {
                                            costExplanation = (String)costExplanation + " Backward-Y-progress=" + c2;
                                        }
                                    }
                                }
                                if (SeaOfGatesEngine.this.sogp.isFavorHorVer() && nZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                    c2 = (int)Math.round(20.0 * Math.abs(dy));
                                    newCost += c2;
                                    if (this.debuggingWavefront) {
                                        costExplanation = (String)costExplanation + " Not-alternating-metal=" + c2;
                                    }
                                }
                            }
                            if (dz == 0) break block228;
                            if (this.toZ != curZ) break block229;
                            c2 = 8;
                            newCost += c2;
                            if (this.debuggingWavefront) {
                                costExplanation = (String)costExplanation + " Layer-change=" + c2;
                            }
                            break block230;
                        }
                        if ((this.toZ - curZ) * dz < 0) {
                            c2 = 9;
                            newCost += c2;
                            if (this.debuggingWavefront) {
                                costExplanation = (String)costExplanation + " Layer-change-wrong-direction=" + c2;
                            }
                        }
                        break block230;
                    }
                    double jumpSize1 = Math.abs(this.getJumpSize(svCurrent, nX, nY, nZ, dx, dy, null));
                    double jumpSize2 = Math.abs(this.getJumpSize(svCurrent, curX, curY, curZ, -dx, -dy, null));
                    if (jumpSize1 > 1.0 && jumpSize2 > 1.0 && (c2 = (int)(jumpSize1 * jumpSize2 / 10.0)) > 0) {
                        newCost += c2;
                        if (this.debuggingWavefront) {
                            costExplanation = (String)costExplanation + " Fragments-track=" + c2;
                        }
                    }
                    if (svCurrent.last != null) {
                        boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                        boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                        if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                            c2 = 1;
                            newCost += c2;
                            if (this.debuggingWavefront) {
                                costExplanation = (String)costExplanation + " Turning=" + c2;
                            }
                        }
                    }
                }
                if (!SeaOfGatesEngine.this.favorArcs[nZ]) {
                    c2 = (int)((double)(80 * Math.abs(dz)) + 10.0 * Math.abs(dx + dy));
                    newCost += c2;
                    if (this.debuggingWavefront) {
                        costExplanation = (String)costExplanation + " Layer-unfavored=" + c2;
                    }
                }
                if (penaltyOffGridX) {
                    c2 = 15;
                    newCost += c2;
                    if (this.debuggingWavefront) {
                        costExplanation = (String)costExplanation + " Off-X-grid=" + c2;
                    }
                }
                if (penaltyOffGridY) {
                    c2 = 15;
                    newCost += c2;
                    if (this.debuggingWavefront) {
                        costExplanation = (String)costExplanation + " Off-Y-grid=" + c2;
                    }
                }
                svNext.cost = newCost;
                if (alreadyThere != null) {
                    if (alreadyThere.getCost() < svNext.getCost()) {
                        if (!this.debuggingWavefront) continue;
                        this.completeDebugString(i2, ": Already planned at lower cost (" + alreadyThere.getCost() + ")");
                        continue;
                    }
                    this.active.remove(alreadyThere);
                }
                this.setVertex(nX, nY, nZ, svNext);
                this.active.add(svNext);
                if (this.debuggingWavefront) {
                    this.completeDebugString(i2, ": To (" + TextUtils.formatDistance(svNext.getX()) + "," + TextUtils.formatDistance(svNext.getY()) + "," + svNext.describeMetal() + ")" + (String)costExplanation + "]");
                }
                if (!this.debuggingWavefront) continue;
                RoutingDebug.saveSVLink(svNext, i2);
            }
            if (this.debuggingWavefront) {
                RoutingDebug.saveSVDetails(svCurrent, this.debugString, false);
            }
            if (destinationSV != null) {
                this.solution = destinationSV;
            }
            return destinationSV;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String validCut(SearchVertex svCurrent, int lowMetal, int highMetal, Rectangle2D conRect, Layer conLayer) {
            SearchVertex lastSv;
            double spacingDist = SeaOfGatesEngine.this.viaSurround[lowMetal];
            double diagonalViaDist = SeaOfGatesEngine.this.viaDiagonalDistance[lowMetal];
            double colorDiffDist = SeaOfGatesEngine.this.viaColorDiffSpacing[lowMetal];
            double surround = spacingDist;
            if (colorDiffDist > surround) {
                surround = colorDiffDist;
            }
            if (diagonalViaDist * 2.0 > surround) {
                surround = diagonalViaDist * 2.0;
            }
            double rectLX = conRect.getMinX();
            double rectHX = conRect.getMaxX();
            double rectLY = conRect.getMinY();
            double rectHY = conRect.getMaxY();
            ArrayList<SOGBound> viasInArea = new ArrayList<SOGBound>();
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(conLayer);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    String string = null;
                    return string;
                }
                Rectangle2D.Double searchArea = new Rectangle2D.Double(rectLX - surround - 1.0, rectLY - surround - 1.0, conRect.getWidth() + surround * 2.0 + 2.0, conRect.getHeight() + surround * 2.0 + 2.0);
                Iterator<SOGBound> sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    SOGVia sLoc = (SOGVia)sea.next();
                    Poly[] rect = sLoc.getBounds();
                    if (sLoc.isSameBasicNet(this.nr.netID) && DBMath.areEquals(rect.getCenterX(), conRect.getCenterX()) && DBMath.areEquals(rect.getCenterY(), conRect.getCenterY())) continue;
                    viasInArea.add(sLoc);
                }
            }
            finally {
                bTree.unlock();
            }
            Object sv = svCurrent;
            while (sv != null && (lastSv = ((SearchVertex)sv).last) != null) {
                Poly[] svCutPolys;
                if (Math.min(((SearchVertex)sv).getZ(), lastSv.getZ()) == lowMetal && Math.max(((SearchVertex)sv).getZ(), lastSv.getZ()) == highMetal && (svCutPolys = ((SearchVertex)sv).getCutLayer() == lowMetal ? ((SearchVertex)sv).getCutPolys() : lastSv.getCutPolys()) != null) {
                    for (Poly cutPoly : svCutPolys) {
                        FixpRectangle rect = cutPoly.getBounds2D();
                        double dist = SeaOfGatesEngine.this.cutDistance(conRect, rect);
                        if (!DBMath.isLessThan(dist, surround)) continue;
                        SOGBound conSB = new SOGBound(ERectangle.fromLambda(rect), null, cutPoly.getLayer().getFunction().getMaskColor());
                        viasInArea.add(conSB);
                    }
                }
                sv = ((SearchVertex)sv).last;
            }
            if (viasInArea.size() == 0) {
                return null;
            }
            for (SOGBound sb : viasInArea) {
                double dist = SeaOfGatesEngine.this.cutDistance(conRect, sb.getBounds());
                if (DBMath.isLessThan(dist, spacingDist)) {
                    return "cut " + conLayer.getName() + " at " + TextUtils.formatDistance(rectLX) + "<=X<=" + TextUtils.formatDistance(rectHX) + " and " + TextUtils.formatDistance(rectLY) + "<=Y<=" + TextUtils.formatDistance(rectHY) + " less than " + TextUtils.formatDistance(spacingDist) + " to cut at (" + TextUtils.formatDistance(sb.getBounds().getCenterX()) + "," + TextUtils.formatDistance(sb.getBounds().getCenterY()) + ")";
                }
                if (!(colorDiffDist > 0.0) || sb.getMaskColor() != 0 && conLayer.getFunction().getMaskColor() != 0 && sb.getMaskColor() != conLayer.getFunction().getMaskColor() || !DBMath.isLessThan(dist, colorDiffDist)) continue;
                return "cut " + conLayer.getName() + " at " + TextUtils.formatDistance(rectLX) + "<=X<=" + TextUtils.formatDistance(rectHX) + " and " + TextUtils.formatDistance(rectLY) + "<=Y<=" + TextUtils.formatDistance(rectHY) + " less than " + TextUtils.formatDistance(colorDiffDist) + " to cut colored " + sb.getMaskColor() + " at (" + TextUtils.formatDistance(sb.getBounds().getCenterX()) + "," + TextUtils.formatDistance(sb.getBounds().getCenterY()) + ")";
            }
            SOGBound conSB = new SOGBound(ERectangle.fromLambda(conRect), null, conLayer.getFunction().getMaskColor());
            viasInArea.add(conSB);
            Method secretViaRules = SeaOfGatesEngine.this.secretViaSpacingRules[lowMetal];
            if (secretViaRules != null) {
                try {
                    String err = (String)secretViaRules.invoke(null, viasInArea);
                    if (err != null) {
                        return err;
                    }
                }
                catch (InvocationTargetException err) {
                }
                catch (IllegalAccessException err) {
                    // empty catch block
                }
            }
            if (diagonalViaDist > 0.0) {
                int totViasM2;
                int totViasM1;
                if (viasInArea.size() >= 3) {
                    Rectangle2D[] rects = new Rectangle2D[3];
                    int totVias = viasInArea.size();
                    totViasM1 = totVias - 1;
                    totViasM2 = totViasM1 - 1;
                    for (int i2 = 0; i2 < totViasM2; ++i2) {
                        ERectangle rect1 = ((SOGBound)viasInArea.get(i2)).getBounds();
                        for (int j2 = i2 + 1; j2 < totViasM1; ++j2) {
                            ERectangle rect2 = ((SOGBound)viasInArea.get(j2)).getBounds();
                            for (int k2 = j2 + 1; k2 < totVias; ++k2) {
                                ERectangle rect3 = ((SOGBound)viasInArea.get(k2)).getBounds();
                                boolean zigZag = false;
                                rects[0] = rect1;
                                rects[1] = rect2;
                                rects[2] = rect3;
                                Arrays.sort(rects, new SortRectsByCenter(true));
                                if (rects[0].getMaxX() < rects[1].getMinX() && rects[1].getMaxX() < rects[2].getMinX()) {
                                    if (rects[1].getMaxY() < rects[0].getMinY() && rects[1].getMaxY() < rects[2].getMinY()) {
                                        zigZag = true;
                                    } else if (rects[1].getMinY() > rects[0].getMaxY() && rects[1].getMinY() > rects[2].getMaxY()) {
                                        zigZag = true;
                                    }
                                }
                                if (!zigZag) {
                                    Arrays.sort(rects, new SortRectsByCenter(false));
                                    if (rects[0].getMaxY() < rects[1].getMinY() && rects[1].getMaxY() < rects[2].getMinY()) {
                                        if (rects[1].getMaxX() < rects[0].getMinX() && rects[1].getMaxX() < rects[2].getMinX()) {
                                            zigZag = true;
                                        } else if (rects[1].getMinX() > rects[0].getMaxX() && rects[1].getMinX() > rects[2].getMaxX()) {
                                            zigZag = true;
                                        }
                                    }
                                }
                                if (!zigZag) continue;
                                double dist1 = SeaOfGatesEngine.this.cutDistance(rect1, rect2);
                                double dist2 = SeaOfGatesEngine.this.cutDistance(rect2, rect3);
                                double dist3 = SeaOfGatesEngine.this.cutDistance(rect3, rect1);
                                ERectangle centerCut = null;
                                ERectangle cut1 = null;
                                ERectangle cut2 = null;
                                if (DBMath.isLessThan(dist1, diagonalViaDist) && DBMath.isLessThan(dist2, diagonalViaDist)) {
                                    centerCut = rect2;
                                    cut1 = rect1;
                                    cut2 = rect3;
                                }
                                if (DBMath.isLessThan(dist2, diagonalViaDist) && DBMath.isLessThan(dist3, diagonalViaDist)) {
                                    centerCut = rect3;
                                    cut1 = rect1;
                                    cut2 = rect2;
                                }
                                if (DBMath.isLessThan(dist1, diagonalViaDist) && DBMath.isLessThan(dist3, diagonalViaDist)) {
                                    centerCut = rect1;
                                    cut1 = rect2;
                                    cut2 = rect3;
                                }
                                if (centerCut == null) continue;
                                String msg = "cut " + conLayer.getName() + " at " + TextUtils.formatDistance(((RectangularShape)centerCut).getMinX()) + "<=X<=" + TextUtils.formatDistance(((RectangularShape)centerCut).getMaxX()) + " and " + TextUtils.formatDistance(((RectangularShape)centerCut).getMinY()) + "<=Y<=" + TextUtils.formatDistance(((RectangularShape)centerCut).getMaxY()) + " is less than " + TextUtils.formatDistance(diagonalViaDist) + " from cuts at (" + TextUtils.formatDistance(((RectangularShape)cut1).getCenterX()) + "," + TextUtils.formatDistance(((RectangularShape)cut1).getCenterY()) + ") and (" + TextUtils.formatDistance(((RectangularShape)cut2).getCenterX()) + "," + TextUtils.formatDistance(((RectangularShape)cut2).getCenterY()) + ")";
                                return msg;
                            }
                        }
                    }
                }
                if (viasInArea.size() >= 4) {
                    Rectangle2D[] rects = new Rectangle2D[4];
                    int totVias = viasInArea.size();
                    totViasM1 = totVias - 1;
                    totViasM2 = totViasM1 - 1;
                    int totViasM3 = totViasM2 - 1;
                    for (int i3 = 0; i3 < totViasM3; ++i3) {
                        ERectangle rect1 = ((SOGBound)viasInArea.get(i3)).getBounds();
                        for (int j3 = i3 + 1; j3 < totViasM2; ++j3) {
                            ERectangle rect2 = ((SOGBound)viasInArea.get(j3)).getBounds();
                            for (int k3 = j3 + 1; k3 < totViasM1; ++k3) {
                                ERectangle rect3 = ((SOGBound)viasInArea.get(k3)).getBounds();
                                for (int l2 = k3 + 1; l2 < totVias; ++l2) {
                                    ERectangle rect4 = ((SOGBound)viasInArea.get(l2)).getBounds();
                                    boolean inALine = false;
                                    rects[0] = rect1;
                                    rects[1] = rect2;
                                    rects[2] = rect3;
                                    rects[3] = rect4;
                                    Arrays.sort(rects, new SortRectsByCenter(true));
                                    if (rects[0].getMaxX() < rects[1].getMinX() && rects[1].getMaxX() < rects[2].getMinX() && rects[2].getMaxX() < rects[3].getMinX()) {
                                        if (rects[0].getCenterY() < rects[1].getCenterY() && rects[1].getCenterY() < rects[2].getCenterY() && rects[2].getCenterY() < rects[3].getCenterY()) {
                                            inALine = true;
                                        } else if (rects[3].getCenterY() < rects[2].getCenterY() && rects[2].getCenterY() < rects[1].getCenterY() && rects[1].getCenterY() < rects[0].getCenterY()) {
                                            inALine = true;
                                        }
                                    }
                                    if (!inALine) {
                                        Arrays.sort(rects, new SortRectsByCenter(false));
                                        if (rects[0].getMaxY() < rects[1].getMinY() && rects[1].getMaxY() < rects[2].getMinY() && rects[2].getMaxY() < rects[3].getMinY()) {
                                            if (rects[0].getCenterX() < rects[1].getCenterX() && rects[1].getCenterX() < rects[2].getCenterX() && rects[2].getCenterX() < rects[3].getCenterX()) {
                                                inALine = true;
                                            } else if (rects[3].getCenterX() < rects[2].getCenterX() && rects[2].getCenterX() < rects[1].getCenterX() && rects[1].getCenterX() < rects[0].getCenterX()) {
                                                inALine = true;
                                            }
                                        }
                                    }
                                    if (!inALine || DBMath.isGreaterThanOrEqualTo(SeaOfGatesEngine.this.cutDistance(rects[0], rects[1]), diagonalViaDist) || DBMath.isGreaterThanOrEqualTo(SeaOfGatesEngine.this.cutDistance(rects[1], rects[2]), diagonalViaDist) || DBMath.isGreaterThanOrEqualTo(SeaOfGatesEngine.this.cutDistance(rects[2], rects[3]), diagonalViaDist)) continue;
                                    String msg = "cut " + conLayer.getName() + " at " + TextUtils.formatDistance(conRect.getMinX()) + "<=X<=" + TextUtils.formatDistance(conRect.getMaxX()) + " and " + TextUtils.formatDistance(conRect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(conRect.getMaxY()) + " forms 4-in-a-row line spaced " + TextUtils.formatDistance(diagonalViaDist) + " or less among cuts at (" + TextUtils.formatDistance(rects[0].getCenterX()) + "," + TextUtils.formatDistance(rects[0].getCenterY()) + ") and (" + TextUtils.formatDistance(rects[1].getCenterX()) + "," + TextUtils.formatDistance(rects[1].getCenterY()) + ") and (" + TextUtils.formatDistance(rects[2].getCenterX()) + "," + TextUtils.formatDistance(rects[2].getCenterY()) + ") and (" + TextUtils.formatDistance(rects[3].getCenterX()) + "," + TextUtils.formatDistance(rects[3].getCenterY()) + ")";
                                    return msg;
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }

        private SearchVertexAddon determineMinimumArea(SearchVertex svCurrent, double curX, double curY, int curC, int curZ, int metCol, int metNum, MetalVia mv, double conWid, double conHei, MutableBoolean error, StringBuffer message, boolean finalDest) {
            if (SeaOfGatesEngine.this.minimumArea[metNum] <= 0.0) {
                return null;
            }
            List<SearchVertexAddon> possibleCorrections = this.getExtraGeometryForMinArea(svCurrent, mv, conWid, conHei, curX, curY, curZ, metNum, metCol, finalDest);
            if (possibleCorrections == null) {
                return null;
            }
            boolean rbError = false;
            boolean anyError = false;
            for (SearchVertexAddon sva : possibleCorrections) {
                Rectangle2D rect;
                int i2;
                boolean failed;
                Rectangle2D[] addedGeoms = sva.getGeometry();
                if (SeaOfGatesEngine.this.routingBoundsLimit != null) {
                    failed = false;
                    for (i2 = 0; i2 < addedGeoms.length; ++i2) {
                        rect = addedGeoms[i2];
                        if (!(rect.getMinX() < SeaOfGatesEngine.this.routingBoundsLimit.getMinX() || rect.getMaxX() > SeaOfGatesEngine.this.routingBoundsLimit.getMaxX() || rect.getMinY() < SeaOfGatesEngine.this.routingBoundsLimit.getMinY()) && !(rect.getMaxY() > SeaOfGatesEngine.this.routingBoundsLimit.getMaxY())) continue;
                        if (this.debuggingWavefront) {
                            if (anyError) {
                                message.append(", ");
                            } else {
                                message.append("problem with extra piece of layer " + SeaOfGatesEngine.this.primaryMetalLayer[metNum].getName() + " for minimum area:");
                            }
                            message.append(" is outside of routing bounds at " + TextUtils.formatDistance(rect.getMinX()) + "<=X<=" + TextUtils.formatDistance(rect.getMaxX()) + " and " + TextUtils.formatDistance(rect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(rect.getMaxY()));
                            if (!rbError) {
                                message.append(" (routing bounds is " + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMinX()) + "<=X<=" + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMaxX()) + " and " + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMinY()) + "<=Y<=" + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMaxY()) + ")");
                            }
                        }
                        rbError = true;
                        anyError = true;
                        failed = true;
                        break;
                    }
                    if (failed) continue;
                }
                failed = false;
                for (i2 = 0; i2 < addedGeoms.length; ++i2) {
                    SOGBound sb;
                    rect = addedGeoms[i2];
                    double halfWid = rect.getWidth() / 2.0;
                    double halfHei = rect.getHeight() / 2.0;
                    StringBuffer reason = null;
                    if (this.debuggingWavefront) {
                        reason = new StringBuffer();
                    }
                    if ((sb = this.getMetalBlockageAndNotch(metNum, metCol, halfWid, halfHei, rect.getCenterX(), rect.getCenterY(), svCurrent, true, reason)) == null) continue;
                    if (this.debuggingWavefront) {
                        if (anyError) {
                            message.append(", ");
                        } else {
                            message.append("problem with extra piece of layer " + SeaOfGatesEngine.this.primaryMetalLayer[metNum].getName() + " for minimum area:");
                        }
                        message.append(" rect " + TextUtils.formatDistance(rect.getMinX()) + "<=X<=" + TextUtils.formatDistance(rect.getMaxX()) + " and " + TextUtils.formatDistance(rect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(rect.getMaxY()) + " has " + reason.toString() + " error with " + TextUtils.formatDistance(sb.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(sb.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(sb.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(sb.getBounds().getMaxY()));
                    }
                    anyError = true;
                    failed = true;
                    break;
                }
                if (failed) continue;
                return sva;
            }
            if (anyError) {
                error.setValue(true);
            }
            return null;
        }

        private List<SearchVertexAddon> getExtraGeometryForMinArea(SearchVertex svCurrent, MetalVia mv, double wid, double hei, double curX, double curY, int curZ, int metNum, int metCol, boolean finalDest) {
            Rectangle2D boundPrev;
            PossibleEndpoint added;
            SeaOfGatesEngine.this.getOptimizedList(svCurrent, this.optimizedList);
            if (finalDest) {
                SearchVertex svInsert = new SearchVertex(curX, curY, curZ, 0, 0, null, null, 0, this, 0, null);
                this.optimizedList.add(0, svInsert);
            }
            PossibleEndpoint possibleEndpoint = added = this.aToB ? this.nr.replaceA : this.nr.replaceB;
            if (added != null) {
                MetalVia realMV = added.viaToPlace;
                int newMetal = this.optimizedList.get(this.optimizedList.size() - 1).getZ() == realMV.horMetal ? realMV.verMetal : realMV.horMetal;
                Point2D.Double size = new Point2D.Double(realMV.via.getDefWidth(SeaOfGatesEngine.this.ep), realMV.via.getDefHeight(SeaOfGatesEngine.this.ep));
                this.optimizedList.get((int)(this.optimizedList.size() - 1)).size = size;
                SearchVertex svInsert = new SearchVertex(this.fromX, this.fromY, newMetal, 0, 0, null, size, 0, this, 0, null);
                this.optimizedList.add(svInsert);
            }
            if (finalDest) {
                PossibleEndpoint addedFinal;
                PossibleEndpoint possibleEndpoint2 = addedFinal = this.aToB ? this.nr.replaceA : this.nr.replaceB;
                if (addedFinal != null) {
                    MetalVia realMV = addedFinal.viaToPlace;
                    int newMetal = this.optimizedList.get(0).getZ() == realMV.horMetal ? realMV.verMetal : realMV.horMetal;
                    Point2D.Double size = new Point2D.Double(realMV.via.getDefWidth(SeaOfGatesEngine.this.ep), realMV.via.getDefHeight(SeaOfGatesEngine.this.ep));
                    this.optimizedList.get((int)0).size = size;
                    SearchVertex svInsert = new SearchVertex(this.toPE.getCenterX(), this.toPE.getCenterY(), newMetal, 0, 0, null, size, 0, this, 0, null);
                    this.optimizedList.add(0, svInsert);
                }
            }
            int lastInd = this.optimizedList.size() - 1;
            int prevViaMet = 0;
            for (int ind = 1; ind < this.optimizedList.size(); ++ind) {
                SearchVertex sv = this.optimizedList.get(ind);
                SearchVertex lastSv = this.optimizedList.get(ind - 1);
                if (sv.getZ() == lastSv.getZ()) continue;
                prevViaMet = Math.min(sv.getZ(), lastSv.getZ());
                lastInd = ind - 1;
                break;
            }
            SearchVertex svLast = this.optimizedList.get(lastInd);
            double width = this.nr.getArcWidth(metNum, curX, curY, svLast.getX(), svLast.getY());
            Point2D.Double head = new Point2D.Double(curX, curY);
            Point2D.Double tail = new Point2D.Double(svLast.getX(), svLast.getY());
            int ang = 0;
            if (((Point2D)head).getX() != ((Point2D)tail).getX() || ((Point2D)head).getY() != ((Point2D)tail).getY()) {
                ang = GenMath.figureAngle(tail, head);
            }
            Poly poly = Poly.makeEndPointPoly(head.distance(tail), width, ang, head, width / 2.0, tail, width / 2.0, Poly.Type.FILLED);
            FixpRectangle boundArc = poly.getBounds2D();
            Rectangle2D bound = mv == null ? boundArc : this.getContactGeometry(mv, wid, hei, curX, curY, metNum);
            if (svLast.size == null) {
                boundPrev = boundArc;
            } else {
                MetalVia mvPrev;
                List<MetalVia> nps2X;
                List<MetalVia> npsPrev = SeaOfGatesEngine.this.metalVias[prevViaMet].getVias();
                if ((this.nr.is2X(prevViaMet, svLast.getX(), svLast.getY(), svLast.getX(), svLast.getY()) || prevViaMet + 1 < numMetalLayers && this.nr.is2X(prevViaMet + 1, svLast.getX(), svLast.getY(), svLast.getX(), svLast.getY())) && (nps2X = SeaOfGatesEngine.this.metalVias2X[prevViaMet].getVias()).size() > 0) {
                    npsPrev = nps2X;
                }
                if ((boundPrev = this.getContactGeometry(mvPrev = npsPrev.get(svLast.getContactNo()), svLast.size.getX(), svLast.size.getY(), svLast.getX(), svLast.getY(), metNum)) == null) {
                    boundPrev = bound;
                }
            }
            if (bound != null && bound.getWidth() * bound.getHeight() >= SeaOfGatesEngine.this.minimumArea[metNum]) {
                return null;
            }
            if (boundPrev != null && boundPrev.getWidth() * boundPrev.getHeight() >= SeaOfGatesEngine.this.minimumArea[metNum]) {
                return null;
            }
            if (boundArc != null && ((RectangularShape)boundArc).getWidth() * ((RectangularShape)boundArc).getHeight() >= SeaOfGatesEngine.this.minimumArea[metNum]) {
                return null;
            }
            int c2 = metCol;
            if (c2 > 0) {
                --c2;
            }
            PrimitiveNode pNp = SeaOfGatesEngine.this.metalPureLayerNodes[metNum][c2];
            ArrayList<SearchVertexAddon> possibleCorrections = new ArrayList<SearchVertexAddon>();
            boolean metHor = true;
            if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                if (metNum % 2 == 0) {
                    metHor = false;
                }
            } else if (metNum % 2 != 0) {
                metHor = false;
            }
            Boolean hor = null;
            if (SeaOfGatesEngine.this.sogp.isForceHorVer()) {
                hor = metHor;
            } else if (bound.equals(boundArc) && boundPrev.equals(boundArc)) {
                hor = ((RectangularShape)boundArc).getWidth() > ((RectangularShape)boundArc).getHeight() ? Boolean.TRUE : (((RectangularShape)boundArc).getWidth() < ((RectangularShape)boundArc).getHeight() ? Boolean.FALSE : Boolean.valueOf(metHor));
            } else {
                if (bound.getMinX() == boundPrev.getMinX() && bound.getMinX() == ((RectangularShape)boundArc).getMinX() && bound.getMaxX() == boundPrev.getMaxX() && bound.getMaxX() == ((RectangularShape)boundArc).getMaxX()) {
                    hor = Boolean.FALSE;
                }
                if (bound.getMinY() == boundPrev.getMinY() && bound.getMinY() == ((RectangularShape)boundArc).getMinY() && bound.getMaxY() == boundPrev.getMaxY() && bound.getMaxY() == ((RectangularShape)boundArc).getMaxY()) {
                    hor = hor == null ? Boolean.TRUE : Boolean.valueOf(metHor);
                }
            }
            if (hor != null) {
                if (hor.booleanValue()) {
                    double lX = Math.min(bound.getMinX(), Math.min(boundPrev.getMinX(), ((RectangularShape)boundArc).getMinX()));
                    double hX = Math.max(bound.getMaxX(), Math.max(boundPrev.getMaxX(), ((RectangularShape)boundArc).getMaxX()));
                    double area = (hX - lX) * (bound.getMaxY() - bound.getMinY());
                    if (DBMath.isLessThan(area, SeaOfGatesEngine.this.minimumArea[metNum])) {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[metNum] - area) / (bound.getMaxY() - bound.getMinY());
                        double extraLengthGrid = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        double extraLengthHalfGrid = Math.ceil(extraLength / 2.0 / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        Rectangle2D.Double solution1 = new Rectangle2D.Double(hX, bound.getMinY(), extraLengthHalfGrid, bound.getHeight());
                        Rectangle2D.Double solution2 = new Rectangle2D.Double(lX - extraLengthHalfGrid, bound.getMinY(), extraLengthHalfGrid, bound.getHeight());
                        possibleCorrections.add(new SearchVertexAddon(solution1, solution2, pNp));
                        solution1 = new Rectangle2D.Double(hX, bound.getMinY(), extraLengthGrid, bound.getHeight());
                        solution2 = new Rectangle2D.Double(lX - extraLengthGrid, bound.getMinY(), extraLengthGrid, bound.getHeight());
                        if (bound.getCenterX() > boundPrev.getCenterX()) {
                            possibleCorrections.add(new SearchVertexAddon(solution1, null, pNp));
                            possibleCorrections.add(new SearchVertexAddon(solution2, null, pNp));
                        } else {
                            possibleCorrections.add(new SearchVertexAddon(solution2, null, pNp));
                            possibleCorrections.add(new SearchVertexAddon(solution1, null, pNp));
                        }
                    }
                } else {
                    double lY = Math.min(bound.getMinY(), Math.min(boundPrev.getMinY(), ((RectangularShape)boundArc).getMinY()));
                    double hY = Math.max(bound.getMaxY(), Math.max(boundPrev.getMaxY(), ((RectangularShape)boundArc).getMaxY()));
                    double area = (hY - lY) * (bound.getMaxX() - bound.getMinX());
                    if (DBMath.isLessThan(area, SeaOfGatesEngine.this.minimumArea[metNum])) {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[metNum] - area) / (bound.getMaxX() - bound.getMinX());
                        double extraLengthGrid = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        double extraLengthHalfGrid = Math.ceil(extraLength / 2.0 / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        Rectangle2D.Double solution1 = new Rectangle2D.Double(bound.getMinX(), hY, bound.getWidth(), extraLengthHalfGrid);
                        Rectangle2D.Double solution2 = new Rectangle2D.Double(bound.getMinX(), lY - extraLengthHalfGrid, bound.getWidth(), extraLengthHalfGrid);
                        possibleCorrections.add(new SearchVertexAddon(solution1, solution2, pNp));
                        solution1 = new Rectangle2D.Double(bound.getMinX(), hY, bound.getWidth(), extraLengthGrid);
                        solution2 = new Rectangle2D.Double(bound.getMinX(), lY - extraLengthGrid, bound.getWidth(), extraLengthGrid);
                        if (bound.getCenterY() > boundPrev.getCenterY()) {
                            possibleCorrections.add(new SearchVertexAddon(solution1, null, pNp));
                            possibleCorrections.add(new SearchVertexAddon(solution2, null, pNp));
                        } else {
                            possibleCorrections.add(new SearchVertexAddon(solution2, null, pNp));
                            possibleCorrections.add(new SearchVertexAddon(solution1, null, pNp));
                        }
                    }
                }
            } else {
                PolyMerge pm = new PolyMerge();
                Layer layer = SeaOfGatesEngine.this.primaryMetalLayer[metNum];
                pm.addPolygon(layer, new PolyBase(bound));
                pm.addPolygon(layer, new PolyBase(boundPrev));
                pm.addPolygon(layer, new PolyBase(boundArc));
                double area = pm.getAreaOfLayer(layer);
                if (DBMath.isLessThan(area, SeaOfGatesEngine.this.minimumArea[metNum])) {
                    if (bound.getCenterX() == boundPrev.getCenterX() && bound.getCenterY() != boundPrev.getCenterY()) {
                        double lY = Math.min(bound.getMinY(), Math.min(boundPrev.getMinY(), ((RectangularShape)boundArc).getMinY()));
                        double hY = Math.max(bound.getMaxY(), Math.max(boundPrev.getMaxY(), ((RectangularShape)boundArc).getMaxY()));
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[metNum] - area) / (bound.getMaxX() - bound.getMinX());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        Rectangle2D.Double solution = bound.getCenterY() > boundPrev.getCenterY() ? new Rectangle2D.Double(bound.getMinX(), hY, bound.getWidth(), extraLength) : new Rectangle2D.Double(bound.getMinX(), lY - extraLength, bound.getWidth(), extraLength);
                        possibleCorrections.add(new SearchVertexAddon(solution, null, pNp));
                    } else if (bound.getCenterX() != boundPrev.getCenterX() && bound.getCenterY() == boundPrev.getCenterY()) {
                        double lX = Math.min(bound.getMinX(), Math.min(boundPrev.getMinX(), ((RectangularShape)boundArc).getMinX()));
                        double hX = Math.max(bound.getMaxX(), Math.max(boundPrev.getMaxX(), ((RectangularShape)boundArc).getMaxX()));
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[metNum] - area) / (bound.getMaxY() - bound.getMinY());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        Rectangle2D.Double solution = bound.getCenterX() > boundPrev.getCenterX() ? new Rectangle2D.Double(hX, bound.getMinY(), extraLength, bound.getHeight()) : new Rectangle2D.Double(lX - extraLength, bound.getMinY(), extraLength, bound.getHeight());
                        possibleCorrections.add(new SearchVertexAddon(solution, null, pNp));
                    } else if (bound.getWidth() > bound.getHeight()) {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[metNum] - area) / (bound.getMaxY() - bound.getMinY());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        Rectangle2D.Double solution = bound.getCenterX() > boundPrev.getCenterX() ? new Rectangle2D.Double(bound.getMaxX(), bound.getMinY(), extraLength, bound.getHeight()) : new Rectangle2D.Double(bound.getMinX() - extraLength, bound.getMinY(), extraLength, bound.getHeight());
                        possibleCorrections.add(new SearchVertexAddon(solution, null, pNp));
                    } else {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[metNum] - area) / (bound.getMaxX() - bound.getMinX());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        Rectangle2D.Double solution = bound.getCenterY() > boundPrev.getCenterY() ? new Rectangle2D.Double(bound.getMinX(), bound.getMaxY(), bound.getWidth(), extraLength) : new Rectangle2D.Double(bound.getMinX(), bound.getMinY() - extraLength, bound.getWidth(), extraLength);
                        possibleCorrections.add(new SearchVertexAddon(solution, null, pNp));
                    }
                }
            }
            return possibleCorrections;
        }

        private Rectangle2D getContactGeometry(MetalVia mv, double wid, double hei, double curX, double curY, int metNum) {
            PrimitiveNode np = mv.via;
            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
            NodeInst ni = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(curX, curY), wid, hei, orient);
            FixpTransform trans = null;
            if (orient != Orientation.IDENT) {
                trans = ni.rotateOut();
            }
            Poly[] polys = np.getTechnology().getShapeOfNode(ni);
            for (int j2 = 0; j2 < polys.length; ++j2) {
                Poly poly = polys[j2];
                if (poly.getLayer().getFunction().getLevel() != metNum + 1) continue;
                if (trans != null) {
                    poly.transform(trans);
                }
                return poly.getBounds2D();
            }
            return null;
        }

        private int getNextBucket(SearchVertex svCurrent, double nX, double nY) {
            Rectangle2D limit;
            int start;
            int bucket;
            for (bucket = start = this.orderedBase[svCurrent.globalRoutingBucket]; bucket >= 0 && bucket < this.nr.buckets.length; bucket += this.globalRoutingDelta) {
                limit = this.nr.buckets[bucket];
                if (!DBMath.isGreaterThanOrEqualTo(nX, limit.getMinX()) || !DBMath.isLessThanOrEqualTo(nX, limit.getMaxX()) || !DBMath.isGreaterThanOrEqualTo(nY, limit.getMinY()) || !DBMath.isLessThanOrEqualTo(nY, limit.getMaxY())) continue;
                return bucket;
            }
            for (bucket = start - this.globalRoutingDelta; bucket >= 0 && bucket < this.nr.buckets.length; bucket -= this.globalRoutingDelta) {
                limit = this.nr.buckets[bucket];
                if (!DBMath.isGreaterThanOrEqualTo(nX, limit.getMinX()) || !DBMath.isLessThanOrEqualTo(nX, limit.getMaxX()) || !DBMath.isGreaterThanOrEqualTo(nY, limit.getMinY()) || !DBMath.isLessThanOrEqualTo(nY, limit.getMaxY())) continue;
                return bucket;
            }
            SeaOfGatesEngine.this.error("ERROR: Could not find next bucket going from (" + TextUtils.formatDistance(svCurrent.xv) + "," + TextUtils.formatDistance(svCurrent.yv) + ") to (" + TextUtils.formatDistance(nX) + "," + TextUtils.formatDistance(nY) + ") starting at bucket " + this.orderedBase[svCurrent.globalRoutingBucket] + " (really " + svCurrent.globalRoutingBucket + ") and going " + this.globalRoutingDelta);
            return svCurrent.globalRoutingBucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createRoute() {
            SearchVertex sv;
            int i2;
            double width;
            Layer layer;
            Object type;
            RouteNode goal;
            RouteNode newRN;
            Orientation orient;
            PrimitiveNode pNp;
            String msg;
            EPoint ctr;
            int parenPos;
            String routeName;
            if (this.toPE != null && this.toPE.hasEndpoints()) {
                PossibleEndpoint replace;
                SearchVertex finalSV = this.optimizedList.get(0);
                PossibleEndpoint possibleEndpoint = replace = this.aToB ? this.nr.replaceB : this.nr.replaceA;
                if (replace.coord.getX() == finalSV.getX() && replace.coord.getY() == finalSV.getY()) {
                    this.optimizedList.remove(0);
                    finalSV = this.optimizedList.get(0);
                    this.vertices.remove(0);
                }
                for (PossibleEndpoint pe : this.toPE.choices) {
                    if (pe.coord.getX() != finalSV.getX() || pe.coord.getY() != finalSV.getY()) continue;
                    if (this.aToB) {
                        this.nr.replaceB = pe;
                        this.nr.bEndpoints.setCenterX(finalSV.getX());
                        this.nr.bEndpoints.setCenterY(finalSV.getY());
                        break;
                    }
                    this.nr.replaceA = pe;
                    this.nr.aEndpoints.setCenterX(finalSV.getX());
                    this.nr.aEndpoints.setCenterY(finalSV.getY());
                    break;
                }
            }
            if ((routeName = this.nr.routeName).endsWith("...")) {
                routeName = routeName.substring(0, routeName.length() - 3);
            }
            if ((parenPos = routeName.lastIndexOf(40)) > 0) {
                routeName = routeName.substring(0, parenPos);
            }
            String origRouteName = routeName;
            RouteNode fromRN = new RouteNode(this.from);
            RouteNode toRN = new RouteNode(this.to);
            RouteResolution resolution = this.nr.batch.resolution;
            if (this.nr.replaceA != null) {
                ctr = this.nr.bPi.getCenter();
                msg = "Route '" + origRouteName + "' at (" + TextUtils.formatDistance(ctr.getX()) + "," + TextUtils.formatDistance(ctr.getY()) + ") from port " + this.nr.aPi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(this.nr.aPi.getNodeInst()) + " is disallowed on Metal " + (this.nr.replaceAZ + 1) + " so inserting " + this.nr.replaceA.viaToPlace.via.describe(false);
                if (!DBMath.areEquals(ctr.getX(), this.nr.replaceA.coord.getX()) || !DBMath.areEquals(ctr.getY(), this.nr.replaceA.coord.getY())) {
                    msg = msg + " at (" + TextUtils.formatDistance(this.nr.replaceA.coord.getX()) + "," + TextUtils.formatDistance(this.nr.replaceA.coord.getY()) + ")";
                }
                msg = msg + " and routing from Metal " + (this.nr.aZ + 1);
                SeaOfGatesEngine.this.warn(msg);
                pNp = this.nr.replaceA.viaToPlace.via;
                orient = Orientation.fromJava(this.nr.replaceA.viaToPlace.orientation * 10, false, false);
                newRN = new RouteNode(pNp, SeaOfGatesEngine.this, this.nr.aEndpoints.getCenter(), pNp.getDefWidth(SeaOfGatesEngine.this.ep), pNp.getDefHeight(SeaOfGatesEngine.this.ep), orient, null, this.nr);
                resolution.addNode(newRN);
                goal = this.fromBit == 2 ? fromRN : toRN;
                for (RouteArc ra : resolution.arcsToRoute) {
                    if (ra.from == goal) {
                        ra.from = newRN;
                    }
                    if (ra.to != goal) continue;
                    ra.to = newRN;
                }
                if (SeaOfGatesEngine.this.prefs.resultCellName == null) {
                    type = SeaOfGatesEngine.this.metalArcs[this.nr.replaceAZ][this.nr.replaceAC];
                    layer = SeaOfGatesEngine.this.metalLayers[this.nr.replaceAZ][this.nr.replaceAC];
                    width = this.nr.getArcWidth(this.nr.replaceAZ, this.nr.aEndpoints.getCenterX(), this.nr.aEndpoints.getCenterY(), this.nr.aEndpoints.getCenterX(), this.nr.aEndpoints.getCenterY());
                    resolution.addArc(new RouteArc((ArcProto)type, routeName, SeaOfGatesEngine.this, layer, width, newRN, goal, this.nr));
                }
                if (this.fromBit == 2) {
                    fromRN = newRN;
                } else {
                    toRN = newRN;
                }
                routeName = null;
            }
            if (this.nr.replaceB != null) {
                ctr = this.nr.bPi.getCenter();
                msg = "Route '" + origRouteName + "' at (" + TextUtils.formatDistance(ctr.getX()) + "," + TextUtils.formatDistance(ctr.getY()) + ") from port " + this.nr.bPi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(this.nr.bPi.getNodeInst()) + " is disallowed on Metal " + (this.nr.replaceBZ + 1) + " so inserting " + this.nr.replaceB.viaToPlace.via.describe(false);
                if (!DBMath.areEquals(ctr.getX(), this.nr.replaceB.coord.getX()) || !DBMath.areEquals(ctr.getY(), this.nr.replaceB.coord.getY())) {
                    msg = msg + " at (" + TextUtils.formatDistance(this.nr.replaceB.coord.getX()) + "," + TextUtils.formatDistance(this.nr.replaceB.coord.getY()) + ")";
                }
                msg = msg + " and routing from Metal " + (this.nr.bZ + 1);
                SeaOfGatesEngine.this.warn(msg);
                pNp = this.nr.replaceB.viaToPlace.via;
                orient = Orientation.fromJava(this.nr.replaceB.viaToPlace.orientation * 10, false, false);
                newRN = new RouteNode(pNp, SeaOfGatesEngine.this, this.nr.bEndpoints.getCenter(), pNp.getDefWidth(SeaOfGatesEngine.this.ep), pNp.getDefHeight(SeaOfGatesEngine.this.ep), orient, null, this.nr);
                resolution.addNode(newRN);
                goal = this.fromBit == 2 ? toRN : fromRN;
                for (RouteArc ra : resolution.arcsToRoute) {
                    if (ra.from == goal) {
                        ra.from = newRN;
                    }
                    if (ra.to != goal) continue;
                    ra.to = newRN;
                }
                if (SeaOfGatesEngine.this.prefs.resultCellName == null) {
                    type = SeaOfGatesEngine.this.metalArcs[this.nr.replaceBZ][this.nr.replaceBC];
                    layer = SeaOfGatesEngine.this.metalLayers[this.nr.replaceBZ][this.nr.replaceBC];
                    width = this.nr.getArcWidth(this.nr.replaceBZ, this.nr.bEndpoints.getCenterX(), this.nr.bEndpoints.getCenterY(), this.nr.bEndpoints.getCenterX(), this.nr.bEndpoints.getCenterY());
                    resolution.addArc(new RouteArc((ArcProto)type, routeName, SeaOfGatesEngine.this, layer, width, newRN, goal, this.nr));
                }
                if (this.fromBit == 2) {
                    toRN = newRN;
                } else {
                    fromRN = newRN;
                }
                routeName = null;
            }
            RouteNode lastRN = toRN;
            Poly toPoly = this.to.getPoly();
            if (!DBMath.pointInRect(this.toPE.getCenter(), this.toPE.getRect()) && this.vertices.size() >= 2) {
                SearchVertex v1 = this.vertices.get(0);
                SearchVertex v2 = this.vertices.get(1);
                int tc = this.toC;
                if (tc > 0) {
                    --tc;
                }
                ArcProto type2 = SeaOfGatesEngine.this.metalArcs[this.toZ][tc];
                Layer layer2 = SeaOfGatesEngine.this.metalLayers[this.toZ][tc];
                double width2 = this.nr.getArcWidth(this.toZ, this.toPE.getCenterX(), this.toPE.getCenterY(), this.toPE.getCenterX(), this.toPE.getCenterY());
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[this.toZ][tc].findPinProto();
                if (v1.getX() == v2.getX()) {
                    rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(v1.getX(), toPoly.getCenterY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                    ra = new RouteArc(type2, routeName, SeaOfGatesEngine.this, layer2, width2, rn, toRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                } else if (v1.getY() == v2.getY()) {
                    rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(toPoly.getCenterX(), v1.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                    ra = new RouteArc(type2, routeName, SeaOfGatesEngine.this, layer2, width2, rn, toRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                }
            }
            for (i2 = 0; i2 < this.vertices.size(); ++i2) {
                RouteNode piRN;
                sv = this.vertices.get(i2);
                boolean madeContacts = false;
                while (i2 < this.vertices.size() - 1) {
                    List<MetalVia> nps2X;
                    SearchVertex svNext = this.vertices.get(i2 + 1);
                    if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                    int metNum = Math.min(sv.getZ(), svNext.getZ());
                    List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[metNum].getVias();
                    if ((this.nr.is2X(metNum, sv.getX(), sv.getY(), sv.getX(), sv.getY()) || metNum + 1 < numMetalLayers && this.nr.is2X(metNum + 1, sv.getX(), sv.getY(), sv.getX(), sv.getY())) && (nps2X = SeaOfGatesEngine.this.metalVias2X[metNum].getVias()).size() > 0) {
                        nps = nps2X;
                    }
                    int whichContact = sv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient2 = Orientation.fromJava(mv.orientation * 10, false, false);
                    Point2D size = sv.getSize();
                    double conWid = size.getX();
                    double conHei = size.getY();
                    double otherX = sv.getX();
                    double otherY = sv.getY();
                    if (i2 > 0) {
                        otherX = this.vertices.get(i2 - 1).getX();
                        otherY = this.vertices.get(i2 - 1).getY();
                    }
                    double width3 = this.nr.getArcWidth(sv.getZ(), sv.getX(), sv.getY(), otherX, otherY);
                    int sCol = sv.getC();
                    if (sCol > 0) {
                        --sCol;
                    }
                    ArcProto type3 = SeaOfGatesEngine.this.metalArcs[sv.getZ()][sCol];
                    Layer layer3 = SeaOfGatesEngine.this.metalLayers[sv.getZ()][sCol];
                    RouteNode rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(sv.getX(), sv.getY()), conWid, conHei, orient2, null, this.nr);
                    resolution.addNode(rn);
                    RouteArc ra = new RouteArc(type3, routeName, SeaOfGatesEngine.this, layer3, width3, lastRN, rn, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                    madeContacts = true;
                    sv = svNext;
                    ++i2;
                }
                if (madeContacts && i2 != this.vertices.size() - 1) continue;
                int sCol = sv.getC();
                if (sCol > 0) {
                    --sCol;
                }
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[sv.getZ()][sCol].findPinProto();
                if (i2 == this.vertices.size() - 1) {
                    piRN = fromRN;
                    if (!DBMath.pointInRect(EPoint.fromLambda(sv.getX(), sv.getY()), this.fromRect) && this.vertices.size() >= 2) {
                        int fc = this.fromC;
                        if (fc > 0) {
                            --fc;
                        }
                        SearchVertex v1 = this.vertices.get(this.vertices.size() - 2);
                        SearchVertex v2 = this.vertices.get(this.vertices.size() - 1);
                        ArcProto type4 = SeaOfGatesEngine.this.metalArcs[this.fromZ][fc];
                        Layer layer4 = SeaOfGatesEngine.this.metalLayers[this.fromZ][fc];
                        double width4 = this.nr.getArcWidth(this.fromZ, this.fromX, this.fromY, this.fromX, this.fromY);
                        if (v1.getX() == v2.getX()) {
                            PrimitiveNode pNp2 = SeaOfGatesEngine.this.metalArcs[this.fromZ][fc].findPinProto();
                            piRN = new RouteNode(pNp2, SeaOfGatesEngine.this, EPoint.fromLambda(v1.getX(), this.fromY), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                            resolution.addNode(piRN);
                            ra = new RouteArc(type4, routeName, SeaOfGatesEngine.this, layer4, width4, piRN, fromRN, this.nr);
                            routeName = null;
                            resolution.addArc(ra);
                        } else if (v1.getY() == v2.getY()) {
                            PrimitiveNode pNp3 = SeaOfGatesEngine.this.metalArcs[this.fromZ][fc].findPinProto();
                            piRN = new RouteNode(pNp3, SeaOfGatesEngine.this, EPoint.fromLambda(this.fromX, v1.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                            resolution.addNode(piRN);
                            ra = new RouteArc(type4, routeName, SeaOfGatesEngine.this, layer4, width4, piRN, fromRN, this.nr);
                            routeName = null;
                            resolution.addArc(ra);
                        }
                    }
                } else {
                    PortInst pi = null;
                    double width5 = np.getDefWidth(SeaOfGatesEngine.this.ep);
                    double height = np.getDefHeight(SeaOfGatesEngine.this.ep);
                    if (np.getFunction().isPin()) {
                        width5 = height = this.nr.getArcWidth(sv.getZ(), sv.getX(), sv.getY(), sv.getX(), sv.getY());
                    }
                    if (this.nr.spineTapMap != null) {
                        pi = this.nr.spineTapMap.get(sv);
                    }
                    piRN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(sv.getX(), sv.getY()), width5, height, Orientation.IDENT, pi, this.nr);
                    resolution.addNode(piRN);
                }
                if (lastRN != null) {
                    ArcProto type5 = SeaOfGatesEngine.this.metalArcs[sv.getZ()][sCol];
                    Layer layer5 = SeaOfGatesEngine.this.metalLayers[sv.getZ()][sCol];
                    Layer primaryLayer = SeaOfGatesEngine.this.primaryMetalLayer[sv.getZ()];
                    double width6 = this.nr.getArcWidth(sv.getZ(), sv.getX(), sv.getY(), sv.getX(), sv.getY());
                    if (i2 == 0 && !DBMath.rectsIntersect(lastRN.rect, piRN.rect)) {
                        boolean covered;
                        double hY;
                        double lY;
                        double hX;
                        double lX;
                        double tY;
                        double tX;
                        double fY;
                        double fX;
                        block65: {
                            fX = lastRN.getLoc().getX();
                            fY = lastRN.getLoc().getY();
                            tX = piRN.getLoc().getX();
                            tY = piRN.getLoc().getY();
                            lX = Math.min(fX, tX) - width6 / 2.0;
                            hX = Math.max(fX, tX) + width6 / 2.0;
                            lY = Math.min(fY, tY) - width6 / 2.0;
                            hY = Math.max(fY, tY) + width6 / 2.0;
                            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(primaryLayer);
                            covered = false;
                            bTree.lock();
                            try {
                                if (bTree.isEmpty()) break block65;
                                Iterator<SOGBound> sea = bTree.search(searchArea);
                                while (sea.hasNext()) {
                                    SOGBound sBound = sea.next();
                                    ERectangle bound = sBound.getBounds();
                                    if (!(((RectangularShape)bound).getMinX() <= lX) || !(((RectangularShape)bound).getMaxX() >= hX) || !(((RectangularShape)bound).getMinY() <= lY) || !(((RectangularShape)bound).getMaxY() >= hY)) continue;
                                    covered = true;
                                    break;
                                }
                            }
                            finally {
                                bTree.unlock();
                            }
                        }
                        if (!covered) {
                            boolean geomOK = false;
                            if (fX == tX || fY == tY) {
                                SOGBound errSV = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (hX - lX) / 2.0, (hY - lY) / 2.0, (hX + lX) / 2.0, (hY + lY) / 2.0, null, false, null);
                                if (errSV == null) {
                                    geomOK = true;
                                }
                            } else {
                                double bend1X = fX;
                                double bend1Y = tY;
                                double bend2X = tX;
                                double bend2Y = fY;
                                double bend1aLX = lX;
                                double bend1aHX = lX + width6;
                                double bend1aLY = lY;
                                double bend1aHY = hY;
                                double bend1bLX = lX;
                                double bend1bHX = hX;
                                double bend1bLY = hY - width6;
                                double bend1bHY = hY;
                                double bend2aLX = lX;
                                double bend2aHX = hX;
                                double bend2aLY = lY;
                                double bend2aHY = lY + width6;
                                double bend2bLX = hX - width6;
                                double bend2bHX = hX;
                                double bend2bLY = lY;
                                double bend2bHY = hY;
                                SOGBound errSVa = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend1aHX - bend1aLX) / 2.0, (bend1aHY - bend1aLY) / 2.0, (bend1aHX + bend1aLX) / 2.0, (bend1aHY + bend1aLY) / 2.0, null, false, null);
                                SOGBound errSVb = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend1bHX - bend1bLX) / 2.0, (bend1bHY - bend1bLY) / 2.0, (bend1bHX + bend1bLX) / 2.0, (bend1bHY + bend1bLY) / 2.0, null, false, null);
                                if (errSVa == null && errSVb == null) {
                                    RouteNode bend1RN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(bend1X, bend1Y), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                                    resolution.addNode(bend1RN);
                                    ra = new RouteArc(type5, routeName, SeaOfGatesEngine.this, layer5, width6, piRN, bend1RN, this.nr);
                                    routeName = null;
                                    resolution.addArc(ra);
                                    piRN = bend1RN;
                                    geomOK = true;
                                    System.out.println("AVOIDED UNIVERSAL ARC BECAUSE BEND 1 WORKS");
                                } else {
                                    errSVa = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend2aHX - bend2aLX) / 2.0, (bend2aHY - bend2aLY) / 2.0, (bend2aHX + bend2aLX) / 2.0, (bend2aHY + bend2aLY) / 2.0, null, false, null);
                                    errSVb = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend2bHX - bend2bLX) / 2.0, (bend2bHY - bend2bLY) / 2.0, (bend2bHX + bend2bLX) / 2.0, (bend2bHY + bend2bLY) / 2.0, null, false, null);
                                    if (errSVa == null && errSVb == null) {
                                        RouteNode bend2RN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(bend2X, bend2Y), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                                        resolution.addNode(bend2RN);
                                        ra = new RouteArc(type5, routeName, SeaOfGatesEngine.this, layer5, width6, piRN, bend2RN, this.nr);
                                        routeName = null;
                                        resolution.addArc(ra);
                                        piRN = bend2RN;
                                        geomOK = true;
                                        System.out.println("AVOIDED UNIVERSAL ARC BECAUSE BEND 2 WORKS");
                                    }
                                }
                            }
                            if (!geomOK) {
                                type5 = Generic.tech().universal_arc;
                                layer5 = null;
                                width6 = 0.0;
                            } else {
                                System.out.println("AVOIDED UNIVERSAL ARC FROM (" + TextUtils.formatDistance(lastRN.loc.getX()) + "," + TextUtils.formatDistance(lastRN.loc.getY()) + ") TO (" + TextUtils.formatDistance(piRN.loc.getX()) + "," + TextUtils.formatDistance(piRN.loc.getY()) + ") BECAUSE EXISTING LAYER IS DRC CLEAN");
                            }
                        } else {
                            System.out.println("AVOIDED UNIVERSAL ARC BECAUSE EXISTING LAYER SURROUNDS OK");
                        }
                    }
                    RouteArc ra = new RouteArc(type5, routeName, SeaOfGatesEngine.this, layer5, width6, lastRN, piRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                }
                lastRN = piRN;
            }
            for (i2 = 0; i2 < this.vertices.size(); ++i2) {
                sv = this.vertices.get(i2);
                SearchVertexAddon sva = sv.getMoreGeometry();
                if (sva == null) continue;
                Rectangle2D[] addedGeometry = sva.getGeometry();
                PrimitiveNode pNp4 = sva.getPureLayerNode();
                for (int j2 = 0; j2 < addedGeometry.length; ++j2) {
                    Rectangle2D geomPiece = addedGeometry[j2];
                    RouteNode rn = new RouteNode(pNp4, SeaOfGatesEngine.this, EPoint.fromLambda(geomPiece.getCenterX(), geomPiece.getCenterY()), geomPiece.getWidth(), geomPiece.getHeight(), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                }
            }
            if (this.nr.endBlockages != null) {
                ArrayList<Layer> allLayers = new ArrayList<Layer>();
                for (Layer lay : this.nr.endBlockages.keySet()) {
                    allLayers.add(lay);
                }
                for (Layer lay : allLayers) {
                    BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(lay);
                    bTree.lock();
                    try {
                        List<SOGBound> endBlocks = this.nr.endBlockages.get(lay);
                        for (SOGBound endBlock : endBlocks) {
                            RTNode<SOGBound> origRoot = bTree.getRoot();
                            RTNode<SOGBound> newRoot = RTNode.unLinkGeom(null, origRoot, endBlock, false);
                            if (newRoot == origRoot) continue;
                            bTree.setRoot(newRoot);
                        }
                        this.nr.endBlockages.remove(lay);
                    }
                    finally {
                        bTree.unlock();
                    }
                }
            }
        }

        private Double getHorizontalBlockage(double xPos, double yPos, double drDist, double xBlock, double yBlock) {
            double dY = yBlock - yPos;
            if (dY >= drDist) {
                return null;
            }
            double dX = Math.sqrt(drDist * drDist - dY * dY);
            if (xPos > xBlock) {
                return xBlock + dX;
            }
            return xBlock - dX;
        }

        private Double getVerticalBlockage(double xPos, double yPos, double drDist, double xBlock, double yBlock) {
            double dX = xBlock - xPos;
            if (dX >= drDist) {
                return null;
            }
            double dY = Math.sqrt(drDist * drDist - dX * dX);
            if (yPos > yBlock) {
                return yBlock + dY;
            }
            return yBlock - dY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double getJumpSize(SearchVertex sv, double curX, double curY, int curZ, double dx, double dy, StringBuffer explanation) {
            double initialDY;
            double initialDX;
            Rectangle2D jumpBound = this.nr.jumpBound;
            double width = this.nr.getArcWidth(curZ, curX, curY, curX + dx, curY + dy);
            double halfWidth = width / 2.0;
            double[] fromSurround = this.nr.getSpacingRule(curZ, width, 50.0);
            double lX = curX - halfWidth;
            double hX = curX + halfWidth;
            double lY = curY - halfWidth;
            double hY = curY + halfWidth;
            if (dx > 0.0) {
                hX = jumpBound.getMaxX() + halfWidth;
            } else if (dx < 0.0) {
                lX = jumpBound.getMinX() - halfWidth;
            } else if (dy > 0.0) {
                hY = jumpBound.getMaxY() + halfWidth;
            } else if (dy < 0.0) {
                lY = jumpBound.getMinY() - halfWidth;
            }
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[curZ]);
            SOGNetID topX = null;
            SOGNetID botX = null;
            SOGNetID topY = null;
            SOGNetID botY = null;
            bTree.lock();
            try {
                if (!bTree.isEmpty()) {
                    double lXSearch = lX - fromSurround[0];
                    double hXSearch = hX + fromSurround[0];
                    double lYSearch = lY - fromSurround[1];
                    double hYSearch = hY + fromSurround[1];
                    Rectangle2D.Double searchArea = new Rectangle2D.Double(lXSearch, lYSearch, hXSearch - lXSearch, hYSearch - lYSearch);
                    Iterator<SOGBound> sea = bTree.search(searchArea);
                    while (sea.hasNext()) {
                        double yBlock;
                        double xBlock;
                        double drDist;
                        SOGBound sBound = sea.next();
                        ERectangle bound = sBound.getBounds();
                        if (sBound.isSameBasicNet(this.nr.netID)) continue;
                        if (lX <= ((RectangularShape)bound).getMaxX() && hX >= ((RectangularShape)bound).getMinX()) {
                            if (lY <= ((RectangularShape)bound).getMaxY() && hY >= ((RectangularShape)bound).getMinY()) {
                                if (dx > 0.0 && ((RectangularShape)bound).getMinX() - fromSurround[0] < hX) {
                                    hX = ((RectangularShape)bound).getMinX() - fromSurround[0];
                                    topX = sBound;
                                }
                                if (dx < 0.0 && ((RectangularShape)bound).getMaxX() + fromSurround[0] > lX) {
                                    lX = ((RectangularShape)bound).getMaxX() + fromSurround[0];
                                    botX = sBound;
                                }
                                if (dy > 0.0 && ((RectangularShape)bound).getMinY() - fromSurround[1] < hY) {
                                    hY = ((RectangularShape)bound).getMinY() - fromSurround[1];
                                    topY = sBound;
                                }
                                if (!(dy < 0.0) || !(((RectangularShape)bound).getMaxY() + fromSurround[1] > lY)) continue;
                                lY = ((RectangularShape)bound).getMaxY() + fromSurround[1];
                                botY = sBound;
                                continue;
                            }
                            diff = (lY + hY) / 2.0 > (((RectangularShape)bound).getMinY() + ((RectangularShape)bound).getMaxY()) / 2.0 ? lY - ((RectangularShape)bound).getMaxY() : ((RectangularShape)bound).getMinY() - hY;
                            if (DBMath.isGreaterThanOrEqualTo(diff, fromSurround[1])) {
                                continue;
                            }
                        } else if (lY <= ((RectangularShape)bound).getMaxY() && hY >= ((RectangularShape)bound).getMinY()) {
                            diff = (lX + hX) / 2.0 > (((RectangularShape)bound).getMinX() + ((RectangularShape)bound).getMaxX()) / 2.0 ? lX - ((RectangularShape)bound).getMaxX() : ((RectangularShape)bound).getMinX() - hX;
                            if (DBMath.isGreaterThanOrEqualTo(diff, fromSurround[0])) {
                                continue;
                            }
                        } else {
                            double diff;
                            double cut1CornerY;
                            double cut2CornerY;
                            double cut1CornerX;
                            double cut2CornerX;
                            if ((((RectangularShape)bound).getMinX() + ((RectangularShape)bound).getMaxX()) / 2.0 < (lX + hX) / 2.0) {
                                cut2CornerX = ((RectangularShape)bound).getMaxX();
                                cut1CornerX = lX;
                            } else {
                                cut2CornerX = ((RectangularShape)bound).getMinX();
                                cut1CornerX = hX;
                            }
                            if ((((RectangularShape)bound).getMinY() + ((RectangularShape)bound).getMaxY()) / 2.0 < (lY + hY) / 2.0) {
                                cut2CornerY = ((RectangularShape)bound).getMaxY();
                                cut1CornerY = lY;
                            } else {
                                cut2CornerY = ((RectangularShape)bound).getMinY();
                                cut1CornerY = hY;
                            }
                            double dX = Math.abs(cut2CornerX - cut1CornerX);
                            double dY = Math.abs(cut2CornerY - cut1CornerY);
                            if (DBMath.isGreaterThanOrEqualTo(dX, fromSurround[0]) || DBMath.isGreaterThanOrEqualTo(dY, fromSurround[1]) || DBMath.isGreaterThanOrEqualTo(diff = Math.sqrt(dX * dX + dY * dY), Math.max(fromSurround[0], fromSurround[1]))) continue;
                        }
                        if (dx != 0.0) {
                            drDist = Math.max(fromSurround[0], fromSurround[1]);
                            xBlock = ((RectangularShape)bound).getCenterX() < curX ? ((RectangularShape)bound).getMaxX() : ((RectangularShape)bound).getMinX();
                            yBlock = ((RectangularShape)bound).getCenterY() < curY ? ((RectangularShape)bound).getMaxY() : ((RectangularShape)bound).getMinY();
                            Double lYintX = this.getHorizontalBlockage(curX, lY, drDist, xBlock, yBlock);
                            Double hYintX = this.getHorizontalBlockage(curX, hY, drDist, xBlock, yBlock);
                            if (dx < 0.0) {
                                if (lYintX != null && lYintX > lX && lYintX <= curX) {
                                    lX = lYintX;
                                    botX = sBound;
                                }
                                if (hYintX == null || !(hYintX > lX) || !(hYintX <= curX)) continue;
                                lX = hYintX;
                                botX = sBound;
                                continue;
                            }
                            if (lYintX != null && lYintX < hX && lYintX >= curX) {
                                hX = lYintX;
                                topX = sBound;
                            }
                            if (hYintX == null || !(hYintX < hX) || !(hYintX >= curX)) continue;
                            hX = hYintX;
                            topX = sBound;
                            continue;
                        }
                        drDist = Math.max(fromSurround[0], fromSurround[1]);
                        xBlock = ((RectangularShape)bound).getCenterX() < curX ? ((RectangularShape)bound).getMaxX() : ((RectangularShape)bound).getMinX();
                        yBlock = ((RectangularShape)bound).getCenterY() < curY ? ((RectangularShape)bound).getMaxY() : ((RectangularShape)bound).getMinY();
                        Double lXintY = this.getVerticalBlockage(lX, curY, drDist, xBlock, yBlock);
                        Double hXintY = this.getVerticalBlockage(hX, curY, drDist, xBlock, yBlock);
                        if (dy < 0.0) {
                            if (lXintY != null && lXintY > lY && lXintY <= curY) {
                                lY = lXintY;
                                botY = sBound;
                            }
                            if (hXintY == null || !(hXintY > lY) || !(hXintY <= curY)) continue;
                            lY = hXintY;
                            botY = sBound;
                            continue;
                        }
                        if (lXintY != null && lXintY < hY && lXintY >= curY) {
                            hY = lXintY;
                            topY = sBound;
                        }
                        if (hXintY == null || !(hXintY < hY) || !(hXintY >= curY)) continue;
                        hY = hXintY;
                        topY = sBound;
                    }
                }
            }
            finally {
                bTree.unlock();
            }
            if (dx > 0.0) {
                Double goalX;
                Double goalX2;
                initialDX = dx = this.nr.downToGrain(hX - halfWidth) - curX;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && dx > this.fromTaperLen) {
                    dx = this.fromTaperLen;
                }
                if (curZ == this.toZ && (goalX2 = this.toPE.getGoalWithinX(curX, curX + dx, curY)) != null) {
                    dx = goalX2 - curX;
                }
                if ((goalX = this.toPE.getGoalAboveX(curX + dx, curY)) != null && curZ == this.toZ) {
                    dx = goalX - curX;
                } else {
                    Rectangle2D limit;
                    if (!this.toPE.atGoalPoint(curX + dx, curY)) {
                        dx = this.nr.getLowerXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (this.globalRoutingDelta != 0 && curX + dx > (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMaxX()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dx = limit.getMaxX() - curX;
                        if (curX >= originalBucket.getMinX() && curX >= originalBucket.getMaxX() && curX + dx > originalBucket.getMaxX()) {
                            dx -= originalBucket.getWidth() / 2.0;
                        }
                        dx = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (this.toPE.isOutOfGoalX(curX + dx)) {
                        dx = this.nr.downToGrainAlways(curX + dx) - curX;
                    }
                }
                if (explanation != null) {
                    if (topX == null) {
                        if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && initialDX > this.fromTaperLen) {
                            explanation.append("went full taper distance of " + TextUtils.formatDistance(this.fromTaperLen));
                        } else {
                            explanation.append("went to jump bound " + TextUtils.formatDistance(this.nr.jumpBound.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxX()) + " and " + TextUtils.formatDistance(this.nr.jumpBound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxY()));
                        }
                    } else {
                        explanation.append("blocked by rect at " + TextUtils.formatDistance(((SOGBound)topX).bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(((SOGBound)topX).bound.getMaxX()) + " and " + TextUtils.formatDistance(((SOGBound)topX).bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(((SOGBound)topX).bound.getMaxY()) + " on net " + String.valueOf(topX.getNetID()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                        if (fromSurround[0] != fromSurround[1]) {
                            explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                        }
                        explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                    }
                }
                return dx;
            }
            if (dx < 0.0) {
                Double goalX;
                Double goalX3;
                initialDX = dx = this.nr.upToGrain(lX + halfWidth) - curX;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && -dx > this.fromTaperLen) {
                    dx = -this.fromTaperLen;
                }
                if (curZ == this.toZ && (goalX3 = this.toPE.getGoalWithinX(curX + dx, curX, curY)) != null) {
                    dx = goalX3 - curX;
                }
                if ((goalX = this.toPE.getGoalBelowX(curX + dx, curY)) != null && curZ == this.toZ) {
                    dx = goalX - curX;
                } else {
                    Rectangle2D limit;
                    if (!this.toPE.atGoalPoint(curX + dx, curY)) {
                        dx = this.nr.getUpperXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (this.globalRoutingDelta != 0 && curX + dx < (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMinX()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dx = limit.getMinX() - curX;
                        if (curX >= originalBucket.getMinX() && curX >= originalBucket.getMaxX() && curX + dx < originalBucket.getMinX()) {
                            dx += originalBucket.getWidth() / 2.0;
                        }
                        dx = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (this.toPE.isOutOfGoalX(curX + dx)) {
                        dx = this.nr.upToGrainAlways(curX + dx) - curX;
                    }
                }
                if (explanation != null) {
                    if (botX == null) {
                        if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && -initialDX > this.fromTaperLen) {
                            explanation.append("went full taper distance of " + TextUtils.formatDistance(this.fromTaperLen));
                        } else {
                            explanation.append("went to jump bound " + TextUtils.formatDistance(this.nr.jumpBound.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxX()) + " and " + TextUtils.formatDistance(this.nr.jumpBound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxY()));
                        }
                    } else {
                        explanation.append("blocked by rect at " + TextUtils.formatDistance(((SOGBound)botX).bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(((SOGBound)botX).bound.getMaxX()) + " and " + TextUtils.formatDistance(((SOGBound)botX).bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(((SOGBound)botX).bound.getMaxY()) + " on net " + String.valueOf(botX.getNetID()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                        if (fromSurround[0] != fromSurround[1]) {
                            explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                        }
                        explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                    }
                }
                return dx;
            }
            if (dy > 0.0) {
                Double goalY;
                Double goalY2;
                initialDY = dy = this.nr.downToGrain(hY - halfWidth) - curY;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && dy > this.fromTaperLen) {
                    dy = this.fromTaperLen;
                }
                if (curZ == this.toZ && (goalY2 = this.toPE.getGoalWithinY(curX, curY, curY + dy)) != null) {
                    dy = goalY2 - curY;
                }
                if ((goalY = this.toPE.getGoalAboveY(curX, curY + dy)) != null && curZ == this.toZ) {
                    dy = goalY - curY;
                } else {
                    Rectangle2D limit;
                    if (!this.toPE.atGoalPoint(curX, curY + dy)) {
                        dy = this.nr.getLowerYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (this.globalRoutingDelta != 0 && curY + dy > (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMaxY()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dy = limit.getMaxY() - curY;
                        if (curY >= originalBucket.getMinY() && curY >= originalBucket.getMaxY() && curY + dy > originalBucket.getMaxY()) {
                            dy -= originalBucket.getHeight() / 2.0;
                        }
                        dy = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (this.toPE.isOutOfGoalY(curY + dy)) {
                        dy = this.nr.downToGrainAlways(curY + dy) - curY;
                    }
                }
                if (explanation != null) {
                    if (topY == null) {
                        if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && initialDY > this.fromTaperLen) {
                            explanation.append("went full taper distance of " + TextUtils.formatDistance(this.fromTaperLen));
                        } else {
                            explanation.append("went to jump bound " + TextUtils.formatDistance(this.nr.jumpBound.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxX()) + " and " + TextUtils.formatDistance(this.nr.jumpBound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxY()));
                        }
                    } else {
                        explanation.append("blocked by rect at " + TextUtils.formatDistance(((SOGBound)topY).bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(((SOGBound)topY).bound.getMaxX()) + " and " + TextUtils.formatDistance(((SOGBound)topY).bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(((SOGBound)topY).bound.getMaxY()) + " on net " + String.valueOf(topY.getNetID()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                        if (fromSurround[0] != fromSurround[1]) {
                            explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                        }
                        explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                    }
                }
                return dy;
            }
            if (dy < 0.0) {
                Double goalY;
                Double goalY3;
                initialDY = dy = this.nr.upToGrain(lY + halfWidth) - curY;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && -dy > this.fromTaperLen) {
                    dy = -this.fromTaperLen;
                }
                if (curZ == this.toZ && (goalY3 = this.toPE.getGoalWithinY(curX, curY + dy, curY)) != null) {
                    dy = goalY3 - curY;
                }
                if ((goalY = this.toPE.getGoalBelowY(curX, curY + dy)) != null && curZ == this.toZ) {
                    dy = goalY - curY;
                } else {
                    Rectangle2D limit;
                    if (!this.toPE.atGoalPoint(curX, curY + dy)) {
                        dy = this.nr.getUpperYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (this.globalRoutingDelta != 0 && curY + dy < (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMinY()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dy = limit.getMinY() - curY;
                        if (curY >= originalBucket.getMinY() && curY >= originalBucket.getMaxY() && curY + dy < originalBucket.getMinY()) {
                            dy += originalBucket.getHeight() / 2.0;
                        }
                        dy = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (this.toPE.isOutOfGoalY(curY + dy)) {
                        dy = this.nr.upToGrainAlways(curY + dy) - curY;
                    }
                }
                if (explanation != null) {
                    if (botY == null) {
                        if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && -initialDY > this.fromTaperLen) {
                            explanation.append("went full taper distance of " + TextUtils.formatDistance(this.fromTaperLen));
                        } else {
                            explanation.append("went to jump bound " + TextUtils.formatDistance(this.nr.jumpBound.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxX()) + " and " + TextUtils.formatDistance(this.nr.jumpBound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.nr.jumpBound.getMaxY()));
                        }
                    } else {
                        explanation.append("blocked by rect at " + TextUtils.formatDistance(((SOGBound)botY).bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(((SOGBound)botY).bound.getMaxX()) + " and " + TextUtils.formatDistance(((SOGBound)botY).bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(((SOGBound)botY).bound.getMaxY()) + " on net " + String.valueOf(botY.getNetID()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                        if (fromSurround[0] != fromSurround[1]) {
                            explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                        }
                        explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                    }
                }
                return dy;
            }
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SOGBound getMetalBlockageAndNotch(int metNo, int maskNo, double halfWidth, double halfHeight, double x, double y, SearchVertex svCurrent, boolean minArea, StringBuffer explaination) {
            int maskIndex = maskNo;
            if (maskIndex > 0) {
                --maskIndex;
            }
            Layer layer = SeaOfGatesEngine.this.metalLayers[metNo][maskIndex];
            Layer primaryLayer = SeaOfGatesEngine.this.primaryMetalLayer[metNo];
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(primaryLayer);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    SOGBound sOGBound = null;
                    return sOGBound;
                }
                double metLX = x - halfWidth;
                double metHX = x + halfWidth;
                double metLY = y - halfHeight;
                double metHY = y + halfHeight;
                Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
                double metWid = Math.min(halfWidth, halfHeight) * 2.0;
                double metLen = Math.max(halfWidth, halfHeight) * 2.0;
                double surroundX = SeaOfGatesEngine.this.metalSurroundX[metNo];
                double surroundY = SeaOfGatesEngine.this.metalSurroundY[metNo];
                double lX = metLX - surroundX;
                double hX = metHX + surroundX;
                double lY = metLY - surroundY;
                double hY = metHY + surroundY;
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                ArrayList<SOGBound> nodeRecsOnPath = new ArrayList<SOGBound>();
                ArrayList<SOGBound> recsOnPath = new ArrayList<SOGBound>();
                if (svCurrent != null) {
                    SeaOfGatesEngine.this.getOptimizedList(svCurrent, this.optimizedList);
                    for (int ind = 1; ind < this.optimizedList.size(); ++ind) {
                        Poly poly;
                        FixpRectangle bound;
                        SearchVertex sv = this.optimizedList.get(ind);
                        SearchVertex lastSv = this.optimizedList.get(ind - 1);
                        if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                        if (sv.getZ() != lastSv.getZ()) {
                            List<MetalVia> nps2X;
                            int metNum = Math.min(sv.getZ(), lastSv.getZ());
                            List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[metNum].getVias();
                            if ((this.nr.is2X(metNum, sv.getX(), sv.getY(), sv.getX(), sv.getY()) || metNum + 1 < numMetalLayers && this.nr.is2X(metNum + 1, sv.getX(), sv.getY(), sv.getX(), sv.getY())) && (nps2X = SeaOfGatesEngine.this.metalVias2X[metNum].getVias()).size() > 0) {
                                nps = nps2X;
                            }
                            int whichContact = lastSv.getContactNo();
                            MetalVia mv = nps.get(whichContact);
                            PrimitiveNode np = mv.via;
                            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                            SizeOffset so = np.getProtoSizeOffset();
                            double xOffset = so.getLowXOffset() + so.getHighXOffset();
                            double yOffset = so.getLowYOffset() + so.getHighYOffset();
                            double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, this.nr.minWidth) + xOffset;
                            double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, this.nr.minWidth) + yOffset;
                            NodeInst ni = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(sv.getX(), sv.getY()), wid, hei, orient);
                            FixpTransform trans = null;
                            if (orient != Orientation.IDENT) {
                                trans = ni.rotateOut();
                            }
                            Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                            for (int i2 = 0; i2 < polys.length; ++i2) {
                                FixpRectangle bound2;
                                Poly poly2 = polys[i2];
                                if (poly2.getLayer() != layer) continue;
                                if (trans != null) {
                                    poly2.transform(trans);
                                }
                                if (((RectangularShape)(bound2 = poly2.getBounds2D())).getMaxX() <= lX || ((RectangularShape)bound2).getMinX() >= hX || ((RectangularShape)bound2).getMaxY() <= lY || ((RectangularShape)bound2).getMinY() >= hY) continue;
                                SOGBound bb = new SOGBound(ERectangle.fromLambda(bound2), this.nr.netID, sv.getC());
                                recsOnPath.add(bb);
                                if (minArea) continue;
                                nodeRecsOnPath.add(bb);
                            }
                            continue;
                        }
                        double width = this.nr.getArcWidth(metNo, lastSv.getX(), lastSv.getY(), sv.getX(), sv.getY());
                        Point2D.Double head = new Point2D.Double(sv.getX(), sv.getY());
                        Point2D.Double tail = new Point2D.Double(lastSv.getX(), lastSv.getY());
                        int ang = 0;
                        if (((Point2D)head).getX() != ((Point2D)tail).getX() || ((Point2D)head).getY() != ((Point2D)tail).getY()) {
                            ang = GenMath.figureAngle(tail, head);
                        }
                        if (((RectangularShape)(bound = (poly = Poly.makeEndPointPoly(head.distance(tail), width, ang, head, width / 2.0, tail, width / 2.0, Poly.Type.FILLED)).getBounds2D())).getMaxX() <= lX || ((RectangularShape)bound).getMinX() >= hX || ((RectangularShape)bound).getMaxY() <= lY || ((RectangularShape)bound).getMinY() >= hY) continue;
                        SOGBound bb = new SOGBound(ERectangle.fromLambda(bound), this.nr.netID, sv.getC());
                        recsOnPath.add(bb);
                        if (minArea) continue;
                        nodeRecsOnPath.add(bb);
                    }
                }
                SOGBound violation = null;
                Iterator<SOGBound> sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    Rectangle2D.Double drcArea;
                    PolyBase poly;
                    SOGBound sBound = sea.next();
                    ERectangle bound = sBound.getBounds();
                    if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                    double drWid = 0.0;
                    double drLen = 0.0;
                    drWid = Math.max(Math.min(bound.getWidth(), bound.getHeight()), Math.min(metWid, metLen));
                    drLen = Math.max(Math.max(bound.getWidth(), bound.getHeight()), Math.max(metWid, metLen));
                    double[] spacing = this.nr.getSpacingRule(metNo, drWid, drLen);
                    double lXAllow = metLX - spacing[0];
                    double hXAllow = metHX + spacing[0];
                    double lYAllow = metLY - spacing[1];
                    double hYAllow = metHY + spacing[1];
                    if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lXAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hXAllow) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lYAllow) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hYAllow)) continue;
                    if (sBound.isSameBasicNet(this.nr.netID)) {
                        boolean notPseudoBlockage = false;
                        if (!sBound.isPseudoBlockage()) {
                            notPseudoBlockage = true;
                        }
                        if (!notPseudoBlockage) continue;
                        if (bound.getMinX() <= metLX && bound.getMaxX() >= metHX && bound.getMinY() <= metLY && bound.getMaxY() >= metHY) {
                            SOGBound ni = null;
                            return ni;
                        }
                        boolean notch = this.foundANotch(bTree, metBound, bound, this.nr.netID, recsOnPath, spacing);
                        if (!notch) continue;
                        violation = sBound;
                        continue;
                    }
                    if (sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(drcArea = new Rectangle2D.Double(lXAllow, lYAllow, hXAllow - lXAllow, hYAllow - lYAllow))) continue;
                    violation = sBound;
                    if (explaination == null) break;
                    explaination.append("spacing [X=" + TextUtils.formatDistance(spacing[0]) + ", Y=" + TextUtils.formatDistance(spacing[1]) + "]");
                    break;
                }
                if (violation != null) {
                    sea = violation;
                    return sea;
                }
                double[] spacing = this.nr.getSpacingRule(metNo, Math.min(metWid, metLen), Math.max(metWid, metLen));
                for (SOGBound sBound : nodeRecsOnPath) {
                    if (!this.foundANotch(bTree, metBound, sBound.getBounds(), this.nr.netID, recsOnPath, spacing)) continue;
                    if (explaination != null) {
                        explaination.append("notch");
                    }
                    SOGBound sOGBound = sBound;
                    return sOGBound;
                }
                Iterator iterator = null;
                return iterator;
            }
            finally {
                bTree.unlock();
            }
        }

        private boolean foundANotch(BlockageTree bTree, Rectangle2D metBound, Rectangle2D bound, MutableInteger netID, List<SOGBound> recsOnPath, double[] dist) {
            boolean vOverlap;
            boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
            boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
            if (hOverlap && vOverlap) {
                return false;
            }
            if (hOverlap) {
                double ptY;
                if (metBound.getCenterY() > bound.getCenterY()) {
                    if (metBound.getMinY() - bound.getMaxY() > dist[1]) {
                        return false;
                    }
                    ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
                } else {
                    if (bound.getMinY() - metBound.getMaxY() > dist[1]) {
                        return false;
                    }
                    ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
                }
                double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
                double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
                double pt3X = (pt1X + pt2X) / 2.0;
                if (!this.pointInRTree(bTree, pt1X, ptY, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(bTree, pt2X, ptY, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(bTree, pt3X, ptY, netID, recsOnPath);
            }
            if (vOverlap) {
                double ptX;
                if (metBound.getCenterX() > bound.getCenterX()) {
                    if (metBound.getMinX() - bound.getMaxX() > dist[0]) {
                        return false;
                    }
                    ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
                } else {
                    if (bound.getMinX() - metBound.getMaxX() > dist[0]) {
                        return false;
                    }
                    ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
                }
                double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
                double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
                double pt3Y = (pt1Y + pt2Y) / 2.0;
                if (!this.pointInRTree(bTree, ptX, pt1Y, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(bTree, ptX, pt2Y, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(bTree, ptX, pt3Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            return false;
        }

        private boolean pointInRTree(BlockageTree bTree, double x, double y, MutableInteger netID, List<SOGBound> recsOnPath) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(x - 0.5, y - 0.5, 1.0, 1.0);
            Iterator<SOGBound> sea = bTree.search(searchArea);
            while (sea.hasNext()) {
                SOGBound sBound = sea.next();
                if (!sBound.isSameBasicNet(netID) || DBMath.isGreaterThan(sBound.getBounds().getMinX(), x) || DBMath.isLessThan(sBound.getBounds().getMaxX(), x) || DBMath.isGreaterThan(sBound.getBounds().getMinY(), y) || DBMath.isLessThan(sBound.getBounds().getMaxY(), y)) continue;
                return true;
            }
            for (SOGBound bound : recsOnPath) {
                if (DBMath.isGreaterThan(bound.getBounds().getMinX(), x) || DBMath.isLessThan(bound.getBounds().getMaxX(), x) || DBMath.isGreaterThan(bound.getBounds().getMinY(), y) || DBMath.isLessThan(bound.getBounds().getMaxY(), y)) continue;
                return true;
            }
            return false;
        }

        private class SortRectsByCenter
        implements Comparator<Rectangle2D> {
            private boolean doX;

            public SortRectsByCenter(boolean doX) {
                this.doX = doX;
            }

            @Override
            public int compare(Rectangle2D r1, Rectangle2D r2) {
                double v2;
                double v1;
                if (this.doX) {
                    v1 = r1.getCenterX();
                    v2 = r2.getCenterX();
                } else {
                    v1 = r1.getCenterY();
                    v2 = r2.getCenterY();
                }
                if (v1 < v2) {
                    return -1;
                }
                if (v1 > v2) {
                    return 1;
                }
                return 0;
            }
        }
    }

    public static class SearchVertex
    implements Comparable<SearchVertex> {
        private static final int OFFINITIALSEGMENT = 1;
        private static final int TOOFARFROMEND = 2;
        private static final int CLOSETOEND = 4;
        private final double xv;
        private final double yv;
        private int zv;
        private int cv;
        private int cost;
        private int cutLayer;
        private int autoGen;
        private int flags;
        private int globalRoutingBucket;
        private Poly[] cutPolys;
        private Point2D size;
        private SearchVertex last;
        private Wavefront wf;
        private SearchVertexAddon addOn;

        SearchVertex(double x, double y, int z, int c2, int whichContact, Poly[] conPolys, Point2D size, int cl, Wavefront w, int flags, SearchVertexAddon minareaGeom) {
            this.xv = x;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cv = c2;
            this.cutPolys = conPolys;
            this.size = size;
            this.cutLayer = cl;
            this.autoGen = -1;
            this.flags = flags;
            this.globalRoutingBucket = -1;
            this.wf = w;
            this.addOn = minareaGeom;
        }

        public SearchVertex(SearchVertex sv) {
            this.xv = sv.xv;
            this.yv = sv.yv;
            this.zv = sv.zv;
            this.cv = sv.cv;
            this.cost = sv.cost;
            this.cutLayer = sv.cutLayer;
            this.autoGen = sv.autoGen;
            this.flags = sv.flags;
            this.globalRoutingBucket = sv.globalRoutingBucket;
            this.cutPolys = sv.cutPolys;
            this.size = sv.size;
            this.last = sv.last;
            this.wf = sv.wf;
            this.addOn = sv.addOn;
        }

        public double getX() {
            return this.xv;
        }

        public double getY() {
            return this.yv;
        }

        public int getZ() {
            return this.zv >> 8;
        }

        public String describeMetal() {
            String ret = "M" + (this.getZ() + 1);
            if (this.cv > 0) {
                ret = ret + (char)(97 + this.cv - 1);
            }
            return ret;
        }

        public int getC() {
            return this.cv;
        }

        public SearchVertex getLast() {
            return this.last;
        }

        public int getCost() {
            return this.cost;
        }

        public SearchVertexAddon getMoreGeometry() {
            return this.addOn;
        }

        public int getGRBucket() {
            return this.globalRoutingBucket;
        }

        public Wavefront getWavefront() {
            return this.wf;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Poly[] getCutPolys() {
            return this.cutPolys;
        }

        Point2D getSize() {
            return this.size;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        int getAutoGen() {
            return this.autoGen;
        }

        void setAutoGen(int a2) {
            this.autoGen = a2;
        }

        public boolean isOffInitialSegment() {
            return (this.flags & 1) != 0;
        }

        public boolean isCantCompleteRoute() {
            return (this.flags & 2) != 0;
        }

        public boolean isMustCompleteRoute() {
            return (this.flags & 4) != 0;
        }

        @Override
        public int compareTo(SearchVertex svo) {
            int diff = this.cost - svo.cost;
            if (diff != 0) {
                return diff;
            }
            if (this.wf != null) {
                double otherDist;
                double thisDist = Math.abs(this.xv - this.wf.toPE.getCenterX()) + Math.abs(this.yv - this.wf.toPE.getCenterY()) + (double)Math.abs(this.getZ() - this.wf.toZ);
                if (thisDist < (otherDist = Math.abs(svo.xv - this.wf.toPE.getCenterX()) + Math.abs(svo.yv - this.wf.toPE.getCenterY()) + (double)Math.abs(svo.getZ() - this.wf.toZ))) {
                    return -1;
                }
                if (thisDist > otherDist) {
                    return 1;
                }
            }
            return 0;
        }

        private void generateIntermediateVertex(int lastDirection, FixpRectangle toRectGridded, Cell cell) {
            block27: {
                NeededRoute nr = this.wf.nr;
                SearchVertex prevSV = this.last;
                double dX = 0.0;
                double dY = 0.0;
                if (this.getX() > prevSV.getX()) {
                    dX = -1.0;
                } else if (this.getX() < prevSV.getX()) {
                    dX = 1.0;
                } else if (this.getY() > prevSV.getY()) {
                    dY = -1.0;
                } else if (this.getY() < prevSV.getY()) {
                    dY = 1.0;
                }
                if (dX == 0.0 && dY == 0.0) {
                    return;
                }
                int z = this.getZ();
                int c2 = this.getC();
                double newX = this.getX();
                double newY = this.getY();
                do {
                    if (dX < 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newX = nr.getLowerXGrid(z, newX - 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX -= 1.0, newY)) {
                            newX = nr.getLowerXGrid(z, newX).getCoordinate();
                        }
                    }
                    if (dX > 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newX = nr.getUpperXGrid(z, newX + 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX += 1.0, newY)) {
                            newX = nr.getUpperXGrid(z, newX).getCoordinate();
                        }
                    }
                    if (dY < 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newY = nr.getLowerYGrid(z, newY - 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY -= 1.0)) {
                            newY = nr.getLowerYGrid(z, newY).getCoordinate();
                        }
                    }
                    if (dY > 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newY = nr.getUpperYGrid(z, newY + 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY += 1.0)) {
                            newY = nr.getUpperYGrid(z, newY).getCoordinate();
                        }
                    }
                    if (dX < 0.0 && newX <= prevSV.getX() || dX > 0.0 && newX >= prevSV.getX() || dY < 0.0 && newY <= prevSV.getY() || dY > 0.0 && newY >= prevSV.getY()) break block27;
                } while (this.wf.getVertex(newX, newY, z) != null);
                SearchVertex svIntermediate = new SearchVertex(newX, newY, z, c2, this.getContactNo(), this.getCutPolys(), this.getSize(), z, this.wf, this.last.flags, null);
                if (this.wf.debuggingWavefront) {
                    RoutingDebug.ensureDebuggingShadow(svIntermediate, false);
                }
                if (this.wf.globalRoutingDelta != 0) {
                    svIntermediate.globalRoutingBucket = this.wf.getNextBucket(this, newX, newY);
                }
                svIntermediate.setAutoGen(lastDirection);
                svIntermediate.last = prevSV;
                svIntermediate.cost = this.cost + 1;
                this.wf.setVertex(newX, newY, z, svIntermediate);
                this.wf.active.add(svIntermediate);
            }
        }
    }

    public static class SearchVertexAddon {
        private Rectangle2D[] addedGeometry;
        private PrimitiveNode pureLayerNode;

        public SearchVertexAddon(Rectangle2D geom1, Rectangle2D geom2, PrimitiveNode pNp) {
            if (geom2 == null) {
                this.addedGeometry = new Rectangle2D[1];
                this.addedGeometry[0] = geom1;
            } else {
                this.addedGeometry = new Rectangle2D[2];
                this.addedGeometry[0] = geom1;
                this.addedGeometry[1] = geom2;
            }
            this.pureLayerNode = pNp;
        }

        public Rectangle2D[] getGeometry() {
            return this.addedGeometry;
        }

        public PrimitiveNode getPureLayerNode() {
            return this.pureLayerNode;
        }
    }

    private class DijkstraParallel
    implements Runnable {
        private final Wavefront wf;
        private final Wavefront otherWf;

        private DijkstraParallel(Wavefront wf, Wavefront otherWf) {
            this.wf = wf;
            this.otherWf = otherWf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success;
            Environment.setThreadEnvironment(SeaOfGatesEngine.this.env);
            SearchVertex result = null;
            while (result == null) {
                if (this.wf.abort) {
                    result = svAbandoned;
                    continue;
                }
                result = this.wf.advanceWavefront();
            }
            boolean bl = success = result.wf != null;
            if (success) assert (result.wf == this.wf);
            NeededRoute neededRoute = this.wf.nr;
            synchronized (neededRoute) {
                assert (!this.wf.finished);
                if (!this.otherWf.finished) {
                    this.otherWf.abort = true;
                    if (success) {
                        this.wf.nr.routedSuccess = true;
                    }
                }
                this.wf.finished = true;
            }
            this.wf.nr.completeRoute(result);
        }
    }

    private class DijkstraTwoWay
    implements Runnable {
        private final NeededRoute nr;
        private final Wavefront dirAtoB;
        private final Wavefront dirBtoA;

        private DijkstraTwoWay(NeededRoute nr, Wavefront dirAtoB, Wavefront dirBtoA) {
            this.nr = nr;
            this.dirAtoB = dirAtoB;
            this.dirBtoA = dirBtoA;
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(SeaOfGatesEngine.this.env);
            SearchVertex result = null;
            SearchVertex resultA = null;
            SearchVertex resultB = null;
            boolean forceBothDirectionsToFinish = false;
            if (this.nr.debuggingRouteFromA != null) {
                forceBothDirectionsToFinish = true;
            }
            if (forceBothDirectionsToFinish) {
                while (result == null) {
                    boolean bGood;
                    if (resultA == null) {
                        resultA = this.dirAtoB.advanceWavefront();
                    }
                    if (resultB == null) {
                        resultB = this.dirBtoA.advanceWavefront();
                    }
                    if (resultA == svAborted || resultB == svAborted) {
                        this.nr.completeRoute(svAborted);
                        return;
                    }
                    if (resultA == null || resultB == null) continue;
                    if (!(resultA != svLimited && resultA != svExhausted || resultB != svLimited && resultB != svExhausted)) {
                        result = SeaOfGatesEngine.this.tryToFindPath(this.dirAtoB, this.dirBtoA);
                        if (result == null) {
                            this.nr.completeRoute(resultA);
                            return;
                        }
                        resultA = result;
                    }
                    boolean aGood = resultA != null && resultA != svAbandoned && resultA != svLimited && resultA != svExhausted;
                    boolean bl = bGood = resultB != null && resultB != svAbandoned && resultB != svLimited && resultB != svExhausted;
                    if (aGood && bGood) {
                        ArrayList<SearchVertex> aList = new ArrayList<SearchVertex>();
                        SeaOfGatesEngine.this.getOptimizedList(resultA, aList);
                        int aVias = 0;
                        double aLength = 0.0;
                        for (int i2 = 1; i2 < aList.size(); ++i2) {
                            SearchVertex svLast = (SearchVertex)aList.get(i2 - 1);
                            SearchVertex sv = (SearchVertex)aList.get(i2);
                            if (svLast.getZ() != sv.getZ()) {
                                ++aVias;
                                continue;
                            }
                            double dX = Math.abs(svLast.getX() - sv.getX());
                            double dY = Math.abs(svLast.getY() - sv.getY());
                            aLength += Math.sqrt(dY * dY + dX * dX);
                        }
                        ArrayList<SearchVertex> bList = new ArrayList<SearchVertex>();
                        SeaOfGatesEngine.this.getOptimizedList(resultB, bList);
                        int bVias = 0;
                        double bLength = 0.0;
                        for (int i3 = 1; i3 < aList.size(); ++i3) {
                            SearchVertex svLast = (SearchVertex)aList.get(i3 - 1);
                            SearchVertex sv = (SearchVertex)aList.get(i3);
                            if (svLast.getZ() != sv.getZ()) {
                                ++aVias;
                                continue;
                            }
                            double dX = Math.abs(svLast.getX() - sv.getX());
                            double dY = Math.abs(svLast.getY() - sv.getY());
                            bLength += Math.sqrt(dY * dY + dX * dX);
                        }
                        if (aLength < bLength || aLength == bLength && aVias < bVias) {
                            resultB = null;
                        } else {
                            resultA = null;
                        }
                    }
                    if ((result = resultA) != null && result != svAbandoned && result != svLimited && result != svExhausted || resultB == svAbandoned || resultB == svLimited || resultB == svExhausted) continue;
                    result = resultB;
                }
            } else {
                while (result == null) {
                    if (resultA == null) {
                        resultA = this.dirAtoB.advanceWavefront();
                    }
                    if (resultB == null) {
                        resultB = this.dirBtoA.advanceWavefront();
                    }
                    if (resultA == null && resultB == null) continue;
                    if (resultA == svAborted || resultB == svAborted) {
                        this.nr.completeRoute(svAborted);
                        return;
                    }
                    if (!(resultA != svLimited && resultA != svExhausted || resultB != svLimited && resultB != svExhausted)) {
                        result = SeaOfGatesEngine.this.tryToFindPath(this.dirAtoB, this.dirBtoA);
                        if (result == null) {
                            this.nr.completeRoute(resultA);
                            return;
                        }
                        resultA = result;
                    }
                    if ((result = resultA) != null && result != svAbandoned && result != svLimited && result != svExhausted || resultB == svAbandoned || resultB == svLimited || resultB == svExhausted) continue;
                    result = resultB;
                }
            }
            this.nr.completeRoute(result);
        }
    }

    public static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(ERectangle bound, MutableInteger netID, PolyBase poly, int maskLayer) {
            super(bound, netID, maskLayer);
            this.poly = poly;
        }

        @Override
        public boolean containsPoint(double x, double y) {
            return this.poly.isInside(new Point2D.Double(x, y));
        }

        @Override
        public boolean isManhattan() {
            PolyBase.Point[] pts = this.poly.getPoints();
            for (int i2 = 1; i2 < pts.length; ++i2) {
                if (pts[i2].getX() == pts[i2 - 1].getX() || pts[i2].getY() == pts[i2 - 1].getY()) continue;
                return false;
            }
            return true;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    public static class SOGVia
    extends SOGBound {
        SOGVia(ERectangle rect, MutableInteger netID) {
            super(rect, netID, 0);
        }

        @Override
        public String toString() {
            return "SOGVia on net " + String.valueOf(this.getNetID());
        }
    }

    private static class GRWavefrontPoint
    implements Comparable<GRWavefrontPoint> {
        private GRBucket n;
        private double cost;

        public GRWavefrontPoint(GRBucket n2, double c2) {
            this.n = n2;
            this.cost = c2;
        }

        public GRBucket getBucket() {
            return this.n;
        }

        public double getCost() {
            return this.cost;
        }

        @Override
        public int compareTo(GRWavefrontPoint other) {
            if (this.cost < other.cost) {
                return -1000000000;
            }
            if (this.cost > other.cost) {
                return 1000000000;
            }
            return this.n.compareTo(other.n);
        }
    }

    private static class GRPathElement {
        private GRBucket n;
        private GREdge e;

        public GRPathElement(GRBucket n2, GREdge e2) {
            this.n = n2;
            this.e = e2;
        }

        public GRBucket getBucket() {
            return this.n;
        }

        public GREdge getEdge() {
            return this.e;
        }
    }

    private static class GREdge {
        private GRBucket n1;
        private GRBucket n2;
        private int current;
        private final int capacity;
        private final double minCost;
        private final double maxCost;

        public GREdge(GRBucket n1, GRBucket n2, int cap) {
            this.n1 = n1;
            this.n2 = n2;
            this.current = 0;
            this.minCost = 1.0;
            this.maxCost = 16.0;
            this.capacity = cap;
            n1.addEdge(this);
            n2.addEdge(this);
        }

        public void changeCurrentValue(int delta) {
            this.current += delta;
        }

        public GRBucket getOtherOne(GRBucket thisOne) {
            return thisOne == this.n1 ? this.n2 : this.n1;
        }

        double usageCost() {
            if (this.current <= 0) {
                return this.minCost;
            }
            if (this.current >= this.capacity) {
                return this.maxCost;
            }
            double ratio = (double)this.current / (double)this.capacity;
            return this.minCost + (this.maxCost - this.minCost) * ratio;
        }
    }

    public static class GRWire {
        private GRBucket n1;
        private GRBucket n2;
        private EPoint pt1;
        private EPoint pt2;
        private List<GRPathElement> path;
        private NeededRoute nr;

        public GRWire(NeededRoute nr, GRBucket n1, GRBucket n2, EPoint pt1, EPoint pt2) {
            this.nr = nr;
            this.n1 = n1;
            this.n2 = n2;
            this.pt1 = pt1;
            this.pt2 = pt2;
        }

        public void setPathOnRoute() {
            this.nr.buckets = new Rectangle2D[this.path.size()];
            for (int i2 = 0; i2 < this.path.size(); ++i2) {
                this.nr.buckets[i2] = this.path.get((int)i2).getBucket().bounds;
            }
        }

        public int getNumPathElements() {
            return this.path.size();
        }

        public GRBucket getPathBucket(int index) {
            return this.path.get(index).getBucket();
        }

        public GRBucket getBucket1() {
            return this.n1;
        }

        public GRBucket getBucket2() {
            return this.n2;
        }

        public EPoint getPoint1() {
            return this.pt1;
        }

        public EPoint getPoint2() {
            return this.pt2;
        }

        public NeededRoute getNeededRoute() {
            return this.nr;
        }

        private void addPath(int width) {
            for (GRPathElement pe : this.path) {
                if (pe.getEdge() == null) continue;
                pe.getEdge().changeCurrentValue(width);
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean setShortestPath() {
            start = this.n1;
            finish = this.n2;
            this.path = new ArrayList<GRPathElement>();
            if (start == finish) {
                return false;
            }
            h = new TreeSet<GRWavefrontPoint>();
            clean = new ArrayList<GRBucket>();
            current = start;
            h.add(new GRWavefrontPoint(current, 0.0));
            while (true) {
                if ((it = h.iterator()).hasNext()) {
                    he = (GRWavefrontPoint)it.next();
                    current = he.getBucket();
                    h.remove(he);
                    if (current.getCost() != he.getCost()) {
                        continue;
                    }
                } else {
                    current = null;
                }
                if (current == null || current == finish) break;
                he = current.getEdges().iterator();
                while (true) {
                    if (!he.hasNext()) ** break;
                    e = (GREdge)he.next();
                    next = e.getOtherOne(current);
                    if (next == start) continue;
                    cost = current.getCost() + e.usageCost();
                    if (next.getPrevEdge() != null && !(next.getCost() > cost)) continue;
                    next.setCost(cost);
                    h.add(new GRWavefrontPoint(next, cost));
                    if (next.getPrevEdge() == null) {
                        clean.add(next);
                    }
                    next.setPrevEdge(e);
                }
                break;
            }
            if (current == finish) {
                while (current != null) {
                    pe = new GRPathElement(current, current.getPrevEdge());
                    this.path.add(pe);
                    current = pe.getEdge() == null ? null : pe.getEdge().getOtherOne(current);
                }
            } else {
                return true;
            }
            Collections.reverse(this.path);
            for (GRBucket n : clean) {
                n.setPrevEdge(null);
                n.setCost(0.0);
            }
            return false;
        }
    }

    public static class GRNet {
        private List<GRWire> wires = new ArrayList<GRWire>();

        GRNet() {
        }

        public void addWire(GRWire w) {
            this.wires.add(w);
        }

        public List<GRWire> getWires() {
            return this.wires;
        }
    }

    public static class GRBucket
    implements Comparable<GRBucket> {
        private int id;
        private Rectangle2D bounds;
        private List<GREdge> edges;
        private double cost;
        private GREdge prev;

        public GRBucket(int id, Rectangle2D bounds) {
            this.id = id;
            this.bounds = bounds;
            this.edges = new ArrayList<GREdge>();
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public double getCost() {
            return this.cost;
        }

        public void setCost(double c2) {
            this.cost = c2;
        }

        public GREdge getPrevEdge() {
            return this.prev;
        }

        public void setPrevEdge(GREdge e2) {
            this.prev = e2;
        }

        public void addEdge(GREdge e2) {
            this.edges.add(e2);
        }

        public List<GREdge> getEdges() {
            return this.edges;
        }

        public String toString() {
            return "BUCKET-" + this.id;
        }

        @Override
        public int compareTo(GRBucket other) {
            return this.id - other.id;
        }
    }

    public static class SOGNetID {
        private MutableInteger netID;

        SOGNetID(MutableInteger netID) {
            this.netID = netID;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public void setNetID(MutableInteger n2) {
            this.netID = n2;
        }

        public void updateNetID(MutableInteger n2, Map<Integer, List<MutableInteger>> netIDsByValue) {
            if (this.isSameBasicNet(n2)) {
                return;
            }
            List<MutableInteger> oldNetIDs = netIDsByValue.get(this.netID.intValue());
            if (oldNetIDs == null) {
                return;
            }
            Integer netIDI = n2.intValue();
            List<MutableInteger> newNetIDs = netIDsByValue.get(netIDI);
            if (newNetIDs == null) {
                newNetIDs = new ArrayList<MutableInteger>();
                netIDsByValue.put(netIDI, newNetIDs);
            }
            for (MutableInteger mi : oldNetIDs) {
                mi.setValue(n2.intValue());
                newNetIDs.add(mi);
            }
            oldNetIDs.clear();
        }

        public boolean isSameBasicNet(MutableInteger otherNetID) {
            int netValue = 0;
            if (this.netID != null) {
                netValue = this.netID.intValue();
            }
            return netValue >> 4 == otherNetID.intValue() >> 4;
        }

        public boolean isPseudoBlockage() {
            if (this.netID == null) {
                return false;
            }
            return (this.netID.intValue() & 1) != 0;
        }

        public boolean isUserSuppliedBlockage() {
            if (this.netID == null) {
                return false;
            }
            return (this.netID.intValue() & 8) != 0;
        }
    }

    private class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            PrimitiveNode pn1 = mv1.via;
            PrimitiveNode pn2 = mv2.via;
            double sz1 = pn1.getDefWidth(SeaOfGatesEngine.this.ep) * pn1.getDefHeight(SeaOfGatesEngine.this.ep);
            if (sz1 < (sz2 = pn2.getDefWidth(SeaOfGatesEngine.this.ep) * pn2.getDefHeight(SeaOfGatesEngine.this.ep))) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    public static class OrderedSearchVertex {
        TreeMap<Integer, List<SearchVertex>> listBetter = new TreeMap();

        OrderedSearchVertex() {
        }

        public Set<SearchVertex> getSet() {
            TreeSet<SearchVertex> totalList = new TreeSet<SearchVertex>();
            for (Integer key : this.listBetter.keySet()) {
                List<SearchVertex> curList = this.listBetter.get(key);
                for (SearchVertex sv : curList) {
                    totalList.add(sv);
                }
            }
            return totalList;
        }

        public void add(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList == null) {
                curList = new ArrayList<SearchVertex>();
                this.listBetter.put(key, curList);
            }
            curList.add(sv);
        }

        public void remove(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList != null) {
                curList.remove(sv);
                if (curList.size() == 0) {
                    this.listBetter.remove(key);
                }
            } else {
                System.out.println("++++++++++ COULD NOT REMOVE SEARCH VERTEX");
            }
        }

        public boolean inList(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList == null) {
                return false;
            }
            return curList.contains(sv);
        }

        public SearchVertex getFirst() {
            if (this.listBetter.size() == 0) {
                return null;
            }
            Integer key = this.listBetter.firstKey();
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList.size() == 0) {
                System.out.println("+++++++++++++ HMMM, FIRST KEY HAS NOTHING (" + key + ")");
            }
            return curList.get(0);
        }
    }

    public class RouteArc
    implements Serializable {
        private ArcProto type;
        private double wid;
        private RouteNode from;
        private RouteNode to;
        private String netName;

        public RouteArc(ArcProto type, String netName, SeaOfGatesEngine soge, Layer layer, double wid, RouteNode from, RouteNode to, NeededRoute nr) {
            this.type = type;
            this.netName = netName;
            this.wid = wid;
            this.from = from;
            this.to = to;
            EPoint fromLoc = from.loc;
            EPoint toLoc = to.loc;
            Poly poly = null;
            if (fromLoc.getX() == toLoc.getX()) {
                poly = new Poly(fromLoc.getX(), (fromLoc.getY() + toLoc.getY()) / 2.0, wid, Math.abs(fromLoc.getY() - toLoc.getY()) + wid);
            } else if (fromLoc.getY() == toLoc.getY()) {
                poly = new Poly((fromLoc.getX() + toLoc.getX()) / 2.0, fromLoc.getY(), Math.abs(fromLoc.getX() - toLoc.getX()) + wid, wid);
            } else if (from.rect.getMaxX() >= to.rect.getMinX() && from.rect.getMinX() <= to.rect.getMaxX()) {
                double x = (Math.max(from.rect.getMinX(), to.rect.getMinX()) + Math.min(from.rect.getMaxX(), to.rect.getMaxX())) / 2.0;
                if (fromLoc.getX() != x) {
                    from.loc = EPoint.fromLambda(x, from.loc.getY());
                }
                if (toLoc.getX() != x) {
                    to.loc = EPoint.fromLambda(x, to.loc.getY());
                }
                poly = new Poly(x, (fromLoc.getY() + toLoc.getY()) / 2.0, wid, Math.abs(fromLoc.getY() - toLoc.getY()) + wid);
            } else if (from.rect.getMaxY() >= to.rect.getMinY() && from.rect.getMinY() <= to.rect.getMaxY()) {
                double y = (Math.max(from.rect.getMinY(), to.rect.getMinY()) + Math.min(from.rect.getMaxY(), to.rect.getMaxY())) / 2.0;
                if (fromLoc.getY() != y) {
                    from.loc = EPoint.fromLambda(from.loc.getX(), y);
                }
                if (toLoc.getY() != y) {
                    to.loc = EPoint.fromLambda(to.loc.getX(), y);
                }
                poly = new Poly((fromLoc.getX() + toLoc.getX()) / 2.0, y, Math.abs(fromLoc.getX() - toLoc.getX()) + wid, wid);
            } else {
                Object layerName = "";
                if (layer != null) {
                    layerName = " " + layer.getName();
                }
                System.out.println("WARNING: angled" + (String)layerName + " wire from (" + TextUtils.formatDistance(fromLoc.getX()) + "," + TextUtils.formatDistance(fromLoc.getY()) + ") to (" + TextUtils.formatDistance(toLoc.getX()) + "," + TextUtils.formatDistance(toLoc.getY()) + ")");
            }
            if (poly != null && layer != null) {
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                soge.addLayer(poly, GenMath.MATID, nr.getNetID(), true, null, false);
            }
        }

        ArcProto getProto() {
            return this.type;
        }

        ArcProtoId getProtoId() {
            return this.type.getId();
        }

        RouteNode getTail() {
            return this.to;
        }

        RouteNode getHead() {
            return this.from;
        }

        String getName() {
            return this.netName;
        }

        double getWidth() {
            return this.wid;
        }

        long getGridExtendOverMin() {
            return DBMath.lambdaToGrid(0.5 * this.wid) - this.type.getBaseExtend().getGrid();
        }

        int getFlags(EditingPreferences ep) {
            return this.type.getDefaultInst((EditingPreferences)ep).flags;
        }
    }

    public static class RouteNode
    implements Serializable {
        private boolean exists;
        private NodeProto np;
        private EPoint loc;
        private FixpRectangle rect;
        private double wid;
        private double hei;
        private Orientation orient;
        private PortInst pi;
        private int terminalNodeID;
        private PortProtoId terminalNodePort;
        private PortInst tapConnection;
        private NeededRoute nr;

        public RouteNode(NodeProto np, SeaOfGatesEngine soge, EPoint loc, double wid, double hei, Orientation orient, PortInst tapConnection, NeededRoute nr) {
            this.exists = false;
            this.np = np;
            this.loc = loc;
            long x = FixpCoord.lambdaToFixp(loc.getX());
            long y = FixpCoord.lambdaToFixp(loc.getY());
            this.rect = FixpRectangle.fromFixpDiagonal(x, y, x, y);
            this.wid = wid;
            this.hei = hei;
            this.orient = orient;
            this.pi = null;
            this.tapConnection = tapConnection;
            this.nr = nr;
            if (np.getFunction() == PrimitiveNode.Function.PIN) {
                return;
            }
            NodeInst ni = NodeInst.makeDummyInstance(np, soge.ep, loc, wid, hei, orient);
            FixpTransform trans = ni.rotateOut();
            Poly[] nodeInstPolyList = np.getTechnology().getShapeOfNode(ni, true, false, null);
            for (int i2 = 0; i2 < nodeInstPolyList.length; ++i2) {
                Poly poly = nodeInstPolyList[i2];
                if (poly.getPort() == null) continue;
                ((PolyBase)poly).transform(trans);
                poly.setStyle(Poly.Type.FILLED);
                soge.addLayer(poly, GenMath.MATID, nr.getNetID(), true, null, false);
            }
        }

        public RouteNode(PortInst pi) {
            this.exists = true;
            this.pi = pi;
            this.terminalNodeID = pi.getNodeInst().getNodeId();
            this.terminalNodePort = pi.getPortProto().getId();
            this.loc = pi.getCenter();
            this.rect = pi.getPoly().getBounds2D();
        }

        boolean exists() {
            return this.exists;
        }

        NodeProto getProto() {
            return this.np;
        }

        NodeProtoId getProtoId() {
            return this.np.getId();
        }

        void setPi(PortInst pi) {
            this.pi = pi;
        }

        PortInst getPi() {
            return this.pi;
        }

        PortInst getTapConnection() {
            return this.tapConnection;
        }

        void setTapConnection(ImmutableNodeInst ini) {
            if (this.tapConnection != null) {
                this.nr.spineTapNIMap.put(this.tapConnection, ini);
            }
        }

        Name getBaseName() {
            assert (!this.exists);
            PrimitiveNode pn = (PrimitiveNode)this.np;
            return pn.getPrimitiveFunction(this.getTechBits()).getBasename();
        }

        Orientation getOrient() {
            return this.orient;
        }

        EPoint getLoc() {
            return this.loc;
        }

        double getWidth() {
            return this.wid;
        }

        double getHeight() {
            return this.hei;
        }

        EPoint getSize() {
            if (this.np instanceof Cell) {
                return EPoint.ORIGIN;
            }
            PrimitiveNode pn = (PrimitiveNode)this.np;
            ERectangle fullRectangle = pn.getFullRectangle();
            long sizeX = DBMath.lambdaToSizeGrid(this.wid) - fullRectangle.getGridWidth();
            long sizeY = DBMath.lambdaToSizeGrid(this.hei) - fullRectangle.getGridHeight();
            return EPoint.fromGrid(sizeX, sizeY);
        }

        int getTechBits() {
            return 0;
        }

        int getNodeId() {
            assert (this.exists);
            return this.terminalNodeID;
        }

        PortProtoId getPortProtoId() {
            if (this.exists) {
                return this.terminalNodePort;
            }
            PrimitiveNode pn = (PrimitiveNode)this.np;
            assert (pn.getNumPorts() == 1);
            return pn.getPort(0).getId();
        }
    }

    public static class RouteAddUnrouted
    implements Serializable {
        private int nodeIDA;
        private int nodeIDB;
        private PortInst piA;
        private PortInst piB;
        private PortProtoId portIdA;
        private PortProtoId portIdB;
        private EPoint locA;
        private EPoint locB;

        public RouteAddUnrouted(PortInst piA, PortInst piB) {
            this.piA = piA;
            this.nodeIDA = piA.getNodeInst().getNodeId();
            this.portIdA = piA.getPortProto().getId();
            this.locA = piA.getCenter();
            this.piB = piB;
            this.nodeIDB = piB.getNodeInst().getNodeId();
            this.portIdB = piB.getPortProto().getId();
            this.locB = piB.getCenter();
        }

        int getTailId() {
            return this.nodeIDA;
        }

        PortInst getTailPort() {
            return this.piA;
        }

        PortProtoId getTailPortProtoId() {
            return this.portIdA;
        }

        EPoint getTailLocation() {
            return this.locA;
        }

        int getHeadId() {
            return this.nodeIDB;
        }

        PortInst getHeadPort() {
            return this.piB;
        }

        PortProtoId getHeadPortProtoId() {
            return this.portIdB;
        }

        EPoint getHeadLocation() {
            return this.locB;
        }
    }

    public static class PossibleEndpoint {
        EPoint coord;
        MetalVia viaToPlace;
        double viaSizeX;
        double viaSizeY;
        Orientation viaOrient;

        PossibleEndpoint(EPoint coord, MetalVia mv, double sX, double sY, Orientation o2) {
            this.coord = coord;
            this.viaToPlace = mv;
            this.viaSizeX = sX;
            this.viaSizeY = sY;
            this.viaOrient = o2;
        }

        public EPoint getCoord() {
            return this.coord;
        }
    }
}

