/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.routing.metrics.RoutingMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class StackedViasAmountMetric
extends RoutingMetric<Integer> {
    @Override
    public Integer calculate(Cell cell) {
        Integer result = 0;
        HashMap<Network, ArrayList<NodeInst>> contactsOnNets = new HashMap<Network, ArrayList<NodeInst>>();
        Netlist nl = cell.getNetlist();
        Iterator<Comparable<NodeInst>> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.getFunction().isContact()) continue;
            Network net = nl.getNetwork(ni, ni.getOnlyPortInst().getPortProto(), 0);
            ArrayList<NodeInst> contactsOnNet = (ArrayList<NodeInst>)contactsOnNets.get(net);
            if (contactsOnNet == null) {
                contactsOnNet = new ArrayList<NodeInst>();
                contactsOnNets.put(net, contactsOnNet);
            }
            contactsOnNet.add(ni);
        }
        it = cell.getNetlist().getNetworks();
        while (it.hasNext()) {
            Network net = (Network)it.next();
            List contactsOnNet = (List)contactsOnNets.get(net);
            if (contactsOnNet == null) continue;
            HashMap<Integer, Boolean> visitedPairs = new HashMap<Integer, Boolean>();
            for (NodeInst node : contactsOnNet) {
                PortInst port = node.getOnlyPortInst();
                NodeProto np = node.getProto();
                EPoint center = port.getCenter();
                result = result + this.isPortStacked(node, np, port, center, visitedPairs);
            }
        }
        return result;
    }

    private int isPortStacked(NodeInst ni, NodeProto np, PortInst port, EPoint center, HashMap<Integer, Boolean> visitedPairs) {
        int count = 0;
        int index1 = ni.hashCode();
        Iterator<Connection> connIt = port.getConnections();
        while (connIt.hasNext()) {
            int index;
            Connection con = connIt.next();
            int thatEndIndex = 1 - con.getEndIndex();
            PortInst p = con.getArc().getConnection(thatEndIndex).getPortInst();
            NodeInst otherNi = p.getNodeInst();
            if (otherNi.getProto() == np) continue;
            int index2 = otherNi.hashCode();
            int n2 = index = index1 < index2 ? index1 ^ index2 : index2 ^ index1;
            if (!otherNi.getFunction().isContact() || visitedPairs.get(index) != null) continue;
            visitedPairs.put(index, true);
            EPoint cen = p.getCenter();
            if (!cen.equals(center)) continue;
            ++count;
        }
        return count;
    }
}

