/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.experimentalLeeMoore2.BacktraceState;
import com.sun.electric.tool.routing.experimentalLeeMoore2.DemandTemplateHandler;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterPathFinder;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.JobMessage;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RegionDirection;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RoutingFrameLeeMoore;
import com.sun.electric.tool.routing.experimentalLeeMoore2.SegPart;
import com.sun.electric.tool.routing.experimentalLeeMoore2.Vector2i;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.BrokenBarrierException;

public class GlobalRouterThreadV3
implements Runnable {
    ArrayList<Integer> non_routable = new ArrayList();
    int slave_id;
    ArrayList<JobMessage> internal_fwd_jobs = new ArrayList();
    ArrayList<JobMessage> internal_bckwd_jobs = new ArrayList();
    Vector<RegionDirection> backtrace;
    GlobalRouterV3 rm;
    int debug_bt_skips = 0;

    public GlobalRouterThreadV3(GlobalRouterV3 gr, int slave_id) {
        this.rm = gr;
        this.slave_id = slave_id;
    }

    private JobMessage DoForwardJob(JobMessage entry) {
        GlobalRouterV3.RegionRepresentation region = this.rm.RegionAt(entry.position.x, entry.position.y);
        GlobalRouterV3.SegmentInfo seg_info = region.segment_infos[entry.seg_id];
        JobMessage ret = null;
        if (seg_info.RefreshSegment(entry.step_num, entry.weight, entry.min_dir)) {
            Vector2i end_point = this.rm.segments[entry.seg_id].end;
            if (entry.position.x == end_point.x && entry.position.y == end_point.y) {
                JobMessage bwd_job;
                ret = bwd_job = new JobMessage(entry.seg_id, entry.position, entry.weight, this.rm.max_detour);
            }
            for (RegionDirection dir2 : RegionDirection.values()) {
                boolean to_vert;
                if (dir2 == RegionDirection.rd_undefined || !this.rm.IsCoordinateValid(this.rm.GetNeighborX(entry.position.x, dir2), this.rm.GetNeighborY(entry.position.y, dir2))) continue;
                double weight = entry.weight;
                boolean from_hor = entry.min_dir == RegionDirection.rd_left || entry.min_dir == RegionDirection.rd_right;
                boolean from_vert = entry.min_dir == RegionDirection.rd_up || entry.min_dir == RegionDirection.rd_down;
                boolean to_hor = dir2 == RegionDirection.rd_left || dir2 == RegionDirection.rd_right;
                boolean bl = to_vert = dir2 == RegionDirection.rd_up || dir2 == RegionDirection.rd_down;
                if (from_hor && to_vert || from_vert && to_hor) {
                    weight += this.rm.via_cost;
                }
                GlobalRouterV3.RegionBorder border = region.GetRegionBorder(dir2);
                double congestion_w = this.rm.RegionAt(this.rm.GetNeighborX(entry.position.x, dir2), this.rm.GetNeighborY(entry.position.y, dir2)).getCongestionWeight();
                if (border.IsBlocked()) continue;
                weight = congestion_w;
                weight = Math.max(entry.weight, weight);
                GlobalRouterV3.SegmentInfo neighbor_info = this.rm.RegionAt((int)entry.position.x, (int)entry.position.y, (RegionDirection)dir2).segment_infos[entry.seg_id];
                int detour_inc = seg_info.is_on_min_path && neighbor_info.is_on_min_path ? 0 : 1;
                JobMessage job_to_send = new JobMessage(entry.seg_id, this.rm.GetNeighborPos(entry.position, dir2), entry.step_num + detour_inc, weight, GlobalRouterV3.GetOppositeDir(dir2));
                this.internal_fwd_jobs.add(job_to_send);
            }
        }
        return ret;
    }

    private boolean DoBackwardJob(JobMessage entry) {
        GlobalRouterV3.RegionRepresentation region = this.rm.RegionAt(entry.position.x, entry.position.y);
        GlobalRouterV3.SegmentInfo seg_info = region.segment_infos[entry.seg_id];
        seg_info.was_part_of_bt = true;
        Vector2i start_point = this.rm.segments[entry.seg_id].start;
        if (entry.position.x == start_point.x && entry.position.y == start_point.y) {
            return true;
        }
        BacktraceState min = seg_info.GetMin(entry.step_num);
        GlobalRouterV3.RegionBorder passed_border = this.rm.RegionAt(entry.position.x, entry.position.y).GetRegionBorder(min.dir);
        if (!passed_border.SoftPassBorder(entry.seg_id)) {
            return false;
        }
        RegionDirection dir_to_get_here = GlobalRouterV3.GetOppositeDir(min.dir);
        this.backtrace.add(0, dir_to_get_here);
        JobMessage job_to_send = new JobMessage(entry.seg_id, this.rm.GetNeighborPos(entry.position, min.dir), min.path_length);
        this.internal_bckwd_jobs.add(job_to_send);
        return true;
    }

    private Vector2i BackwardPropagation() {
        while (!this.internal_bckwd_jobs.isEmpty()) {
            JobMessage internal_bwd_job = this.internal_bckwd_jobs.get(0);
            this.internal_bckwd_jobs.remove(0);
            if (this.DoBackwardJob(internal_bwd_job)) continue;
            return internal_bwd_job.position;
        }
        return null;
    }

    private JobMessage PutShortestPath(List<RegionDirection> dirs, Vector2i start, int seg_id) {
        JobMessage job_to_send;
        double next_w;
        GlobalRouterV3.RegionBorder b2;
        Vector2i pos = new Vector2i(start);
        Iterator<RegionDirection> it = dirs.iterator();
        double w = 0.0;
        GlobalRouterV3.RegionRepresentation region = this.rm.RegionAt(pos.x, pos.y);
        GlobalRouterV3.SegmentInfo seg_info = region.segment_infos[seg_id];
        seg_info.is_on_min_path = true;
        if (!it.hasNext()) {
            for (RegionDirection rd : RegionDirection.values()) {
                if (rd == RegionDirection.rd_undefined || !this.rm.IsCoordinateValid(this.rm.GetNeighborX(pos.x, rd), this.rm.GetNeighborY(pos.y, rd))) continue;
                b2 = region.GetRegionBorder(rd);
                next_w = b2.GetWeight();
                if (b2.IsBlocked()) continue;
                job_to_send = new JobMessage(seg_id, this.rm.GetNeighborPos(pos, rd), 1, next_w += w, GlobalRouterV3.GetOppositeDir(rd));
                this.internal_fwd_jobs.add(job_to_send);
            }
        }
        while (it.hasNext()) {
            for (RegionDirection rd : RegionDirection.values()) {
                if (rd == RegionDirection.rd_undefined || !this.rm.IsCoordinateValid(this.rm.GetNeighborX(pos.x, rd), this.rm.GetNeighborY(pos.y, rd))) continue;
                b2 = region.GetRegionBorder(rd);
                next_w = b2.GetWeight();
                if (b2.IsBlocked()) continue;
                job_to_send = new JobMessage(seg_id, this.rm.GetNeighborPos(pos, rd), 1, next_w += w, GlobalRouterV3.GetOppositeDir(rd));
                this.internal_fwd_jobs.add(job_to_send);
            }
            RegionDirection cur_dir = it.next();
            GlobalRouterV3.RegionBorder border = region.GetRegionBorder(cur_dir);
            double bw = border.GetWeight();
            if (border.IsBlocked()) {
                return null;
            }
            w += bw;
            pos = this.rm.GetNeighborPos(pos, cur_dir);
            region = this.rm.RegionAt(pos.x, pos.y);
            seg_info = region.segment_infos[seg_id];
            seg_info.is_on_min_path = true;
        }
        return new JobMessage(seg_id, pos, w, this.rm.max_detour);
    }

    private void FindRoutes() {
        JobMessage job = this.rm.PollSegmentJob();
        while (job != null) {
            for (int i2 = 0; i2 < this.rm.regions_x * this.rm.regions_y; ++i2) {
                this.rm.regions[i2].segment_infos[job.seg_id] = new GlobalRouterV3.SegmentInfo(this.rm);
            }
            Vector2i source = new Vector2i(this.rm.segments[job.seg_id].start);
            Vector2i sink = new Vector2i(this.rm.segments[job.seg_id].end);
            GlobalRouterPathFinder path_finder = new GlobalRouterPathFinder(this.rm);
            List<RegionDirection> rd_path = path_finder.FindShortestPath(job.seg_id);
            JobMessage best_job = null;
            if (rd_path != null) {
                best_job = this.PutShortestPath(rd_path, source, job.seg_id);
            }
            if (rd_path == null || best_job == null) {
                DemandTemplateHandler dth = new DemandTemplateHandler(this);
                dth.DecrementDemandEstimate(source, sink);
                this.non_routable.add(job.seg_id);
            } else {
                while (!this.internal_fwd_jobs.isEmpty()) {
                    JobMessage internal_job = this.internal_fwd_jobs.get(0);
                    this.internal_fwd_jobs.remove(0);
                    int seg_id = internal_job.seg_id;
                    JobMessage bwd_job = this.DoForwardJob(internal_job);
                    if (bwd_job != null && bwd_job.weight < best_job.weight) {
                        best_job = bwd_job;
                    }
                    if (internal_job.step_num <= this.rm.max_detour && !this.internal_fwd_jobs.isEmpty()) continue;
                    this.internal_bckwd_jobs.add(best_job);
                    this.backtrace = new Vector();
                    Vector2i error_pos = this.BackwardPropagation();
                    if (error_pos != null) {
                        Vector2i it = new Vector2i(error_pos);
                        for (int i3 = 0; i3 < this.backtrace.size(); ++i3) {
                            RegionDirection curr_dir = this.backtrace.get(i3);
                            it = this.rm.GetNeighborPos(it, curr_dir);
                        }
                        this.non_routable.add(job.seg_id);
                    } else {
                        if (this.backtrace.size() > 0) {
                            RegionDirection start_dir = this.backtrace.get(0);
                            Vector2i start = this.rm.segments[seg_id].start;
                            if (start_dir == RegionDirection.rd_left || start_dir == RegionDirection.rd_right) {
                                double y = this.rm.segments[seg_id].d_start_y % this.rm.region_height;
                                int sy_pos = (int)Math.floor((y - this.rm.tileSize / 2.0) / this.rm.tileSize);
                                this.rm.RegionAt(start.x, start.y).GetRegionBorder(start_dir).FromSoftToPriv(seg_id, sy_pos);
                            } else if (start_dir == RegionDirection.rd_up || start_dir == RegionDirection.rd_down) {
                                double x = this.rm.segments[seg_id].d_start_x % this.rm.region_width;
                                int sx_pos = (int)Math.floor((x - this.rm.tileSize / 2.0) / this.rm.tileSize);
                                this.rm.RegionAt(start.x, start.y).GetRegionBorder(start_dir).FromSoftToPriv(seg_id, sx_pos);
                            }
                            start_dir = null;
                            start = null;
                            RegionDirection end_dir = GlobalRouterV3.GetOppositeDir(this.backtrace.get(this.backtrace.size() - 1));
                            Vector2i end = this.rm.segments[seg_id].end;
                            if (end_dir == RegionDirection.rd_left || end_dir == RegionDirection.rd_right) {
                                double y = this.rm.segments[seg_id].d_end_y % this.rm.region_height;
                                int ey_pos = (int)Math.floor((y - this.rm.tileSize / 2.0) / this.rm.tileSize);
                                this.rm.RegionAt(end.x, end.y).GetRegionBorder(end_dir).FromSoftToPriv(seg_id, ey_pos);
                            } else if (end_dir == RegionDirection.rd_up || end_dir == RegionDirection.rd_down) {
                                double x = this.rm.segments[seg_id].d_end_x % this.rm.region_width;
                                int ex_pos = (int)Math.floor((x - this.rm.tileSize / 2.0) / this.rm.tileSize);
                                this.rm.RegionAt(end.x, end.y).GetRegionBorder(end_dir).FromSoftToPriv(seg_id, ex_pos);
                            }
                        }
                        this.rm.OfferBacktrace(this.backtrace, seg_id);
                    }
                    DemandTemplateHandler dth = new DemandTemplateHandler(this);
                    dth.DecrementDemandEstimate(source, sink);
                    break;
                }
            }
            this.internal_fwd_jobs.clear();
            job = this.rm.PollSegmentJob();
        }
    }

    private void SortPassesV2() {
        Vector<Integer> passes;
        for (int y = this.slave_id; y < this.rm.regions_y; y += this.rm.num_threads) {
            passes = this.rm.RegionAt(0, y).GetRegionBorder(RegionDirection.rd_right).HardPassBorderV2();
            for (int x = 1; x < this.rm.regions_x - 1; ++x) {
                passes = this.rm.RegionAt(x, y).GetRegionBorder(RegionDirection.rd_right).HardPassBorderV2(passes);
            }
        }
        for (int x = this.slave_id; x < this.rm.regions_x; x += this.rm.num_threads) {
            passes = this.rm.RegionAt(x, 0).GetRegionBorder(RegionDirection.rd_up).HardPassBorderV2();
            for (int y = 1; y < this.rm.regions_y - 1; ++y) {
                passes = this.rm.RegionAt(x, y).GetRegionBorder(RegionDirection.rd_up).HardPassBorderV2(passes);
            }
        }
    }

    private void CreateOutput() {
        GlobalRouterV3.SegBtPair sbtp = this.rm.PollBacktrace();
        Vector<RegionDirection> bt = sbtp.backtrace;
        int seg_id = sbtp.seg_id;
        while (bt != null) {
            if (!this.rm.not_routed.contains(sbtp.seg_id)) {
                RoutingFrameLeeMoore.Coordinate cur_coordinate;
                Vector2i current_region_pos = new Vector2i(this.rm.segments[seg_id].start);
                int start_layer = this.rm.electric_segments.get(seg_id).getStartLayers().get(0).getMetalNumber();
                int finish_layer = this.rm.electric_segments.get(seg_id).getFinishLayers().get(0).getMetalNumber();
                ArrayList<SegPart> coarse_route = new ArrayList<SegPart>();
                ArrayList<Vector2i> visited_routes = new ArrayList<Vector2i>();
                visited_routes.add(new Vector2i(this.rm.segments[seg_id].start));
                RoutingFrameLeeMoore.Coordinate last_coordinate = new RoutingFrameLeeMoore.Coordinate(this.rm.segments[seg_id].d_start_x, this.rm.segments[seg_id].d_start_y, start_layer);
                for (RegionDirection direction : bt) {
                    int pos_in_list;
                    Vector2i next_region_pos = this.rm.GetNeighborPos(current_region_pos, direction);
                    visited_routes.add(new Vector2i(next_region_pos));
                    GlobalRouterV3.RegionBorder border = this.rm.RegionAt(current_region_pos.x, current_region_pos.y).GetRegionBorder(direction);
                    int pos_in_vertical_border = pos_in_list = border.GetHardPos(seg_id);
                    int pos_in_horizontal_border = pos_in_list;
                    double offset_hor = (double)pos_in_horizontal_border * this.rm.tileSize + this.rm.tileSize;
                    double offset_vert = (double)pos_in_vertical_border * this.rm.tileSize + this.rm.tileSize;
                    double cur_seg_pos_x = (double)current_region_pos.x * this.rm.region_width;
                    double cur_seg_pos_y = (double)current_region_pos.y * this.rm.region_height;
                    RoutingFrameLeeMoore.ManhattenAlignment cur_seg_pos_align = RoutingFrameLeeMoore.ManhattenAlignment.ma_undefined;
                    switch (direction) {
                        case rd_left: {
                            cur_seg_pos_x += 0.0;
                            cur_seg_pos_y += offset_vert;
                            cur_seg_pos_align = RoutingFrameLeeMoore.ManhattenAlignment.ma_horizontal;
                            break;
                        }
                        case rd_right: {
                            cur_seg_pos_x += this.rm.region_width;
                            cur_seg_pos_y += offset_vert;
                            cur_seg_pos_align = RoutingFrameLeeMoore.ManhattenAlignment.ma_horizontal;
                            break;
                        }
                        case rd_up: {
                            cur_seg_pos_x += offset_hor;
                            cur_seg_pos_y += this.rm.region_height;
                            cur_seg_pos_align = RoutingFrameLeeMoore.ManhattenAlignment.ma_vertical;
                            break;
                        }
                        case rd_down: {
                            cur_seg_pos_x += offset_hor;
                            cur_seg_pos_y += 0.0;
                            cur_seg_pos_align = RoutingFrameLeeMoore.ManhattenAlignment.ma_vertical;
                            break;
                        }
                    }
                    cur_coordinate = new RoutingFrameLeeMoore.Coordinate(cur_seg_pos_x, cur_seg_pos_y, start_layer, cur_seg_pos_align);
                    SegPart sub_r_wrapper = new SegPart();
                    ArrayList<RoutingFrameLeeMoore.Coordinate> sub_r = new ArrayList<RoutingFrameLeeMoore.Coordinate>();
                    sub_r.add(last_coordinate);
                    sub_r.add(cur_coordinate);
                    sub_r_wrapper.segment_part = sub_r;
                    sub_r_wrapper.id = seg_id;
                    coarse_route.add(sub_r_wrapper);
                    this.rm.AddRouteToOutReg(current_region_pos, sub_r_wrapper);
                    current_region_pos = next_region_pos;
                    last_coordinate = cur_coordinate;
                }
                cur_coordinate = new RoutingFrameLeeMoore.Coordinate(this.rm.segments[seg_id].d_end_x, this.rm.segments[seg_id].d_end_y, finish_layer);
                SegPart sub_r_wrapper = new SegPart();
                ArrayList<RoutingFrameLeeMoore.Coordinate> sub_r = new ArrayList<RoutingFrameLeeMoore.Coordinate>();
                sub_r.add(last_coordinate);
                sub_r.add(cur_coordinate);
                sub_r_wrapper.segment_part = sub_r;
                sub_r_wrapper.id = seg_id;
                coarse_route.add(sub_r_wrapper);
                this.rm.AddRouteToOutReg(current_region_pos, sub_r_wrapper);
                this.rm.OfferCoarseRoute(coarse_route, seg_id, visited_routes);
            } else {
                ++this.debug_bt_skips;
            }
            sbtp = this.rm.PollBacktrace();
            bt = sbtp.backtrace;
            seg_id = sbtp.seg_id;
        }
    }

    private void EstimateDemand() {
        GlobalRouterV3.SegmentRepresentation seg_rep = this.rm.PollDemandEstimationJob();
        while (seg_rep != null) {
            DemandTemplateHandler dth = new DemandTemplateHandler(this);
            dth.AddDemandEstimate(seg_rep.start, seg_rep.end);
            seg_rep = this.rm.PollDemandEstimationJob();
        }
    }

    private void RemoveFailedSegments() {
        int seg_id = this.rm.PollFailedId();
        while (seg_id >= 0) {
            GlobalRouterV3.RouteToStitch rts = null;
            rts = this.rm.output_coarse_routes.get(seg_id);
            if (rts == null) {
                seg_id = this.rm.PollFailedId();
                continue;
            }
            ArrayList<Vector2i> route = rts.region_positions;
            Iterator<Vector2i> it = route.iterator();
            if (it.hasNext()) {
                Vector2i next;
                Vector2i cur = it.next();
                Vector2i vector2i = next = it.hasNext() ? it.next() : null;
                while (next != null) {
                    RegionDirection dir2 = this.rm.DirFromTo(cur, next);
                    if (dir2 != RegionDirection.rd_undefined) {
                        GlobalRouterV3.RegionBorder b2 = this.rm.RegionAt(cur.x, cur.y).GetRegionBorder(dir2);
                        b2.RevertHardPass(seg_id);
                    }
                    cur = next;
                    next = it.hasNext() ? it.next() : null;
                }
            }
            seg_id = this.rm.PollFailedId();
        }
    }

    @Override
    public void run() {
        this.RemoveFailedSegments();
        try {
            this.rm.barrier.await();
        }
        catch (InterruptedException ex) {
            return;
        }
        catch (BrokenBarrierException ex) {
            return;
        }
        if (this.slave_id == 0) {
            this.rm.ResetOutputRoutes();
        }
        this.EstimateDemand();
        try {
            this.rm.barrier.await();
        }
        catch (InterruptedException ex) {
            return;
        }
        catch (BrokenBarrierException ex) {
            return;
        }
        this.FindRoutes();
        this.rm.OfferUnrouted(this.non_routable);
        try {
            this.rm.barrier.await();
        }
        catch (InterruptedException ex) {
            return;
        }
        catch (BrokenBarrierException ex) {
            return;
        }
        this.SortPassesV2();
        try {
            this.rm.barrier.await();
        }
        catch (InterruptedException ex) {
            return;
        }
        catch (BrokenBarrierException ex) {
            return;
        }
        this.CreateOutput();
        try {
            this.rm.barrier.await();
        }
        catch (InterruptedException ex) {
            return;
        }
        catch (BrokenBarrierException ex) {
            return;
        }
    }
}

