/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.datastructures;

public abstract class PriorityQueue<E> {
    private int capacity = 0;
    private int size = 0;
    private E[] elements = null;
    final int MIN_CAPA = 32;

    public E[] getElements() {
        return this.elements;
    }

    public E top() {
        assert (this.size > 0);
        return this.elements[1];
    }

    public void pop() {
        this.remove(1);
    }

    public void clear() {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            this.set_index(this.elements[i2], 0);
        }
        this.size = 0;
    }

    public void setEmpty() {
        this.size = 0;
    }

    private void remove(int i2) {
        assert (i2 <= this.size);
        this.set_index(this.elements[i2], 0);
        int bubble = this.move_bubble_down(i2);
        if (bubble != this.size) {
            this.insert_and_bubble_up(bubble, this.elements[this.size]);
        }
        --this.size;
    }

    public void push(E element) {
        if (this.size >= this.capacity) {
            this.resize(2 * this.capacity);
        }
        this.insert_and_bubble_up(++this.size, element);
    }

    public int size() {
        return this.size;
    }

    public boolean empty() {
        return this.size == 0;
    }

    private void insert_and_bubble_up(int i2, E element) {
        while (i2 >= 2 && this.less(element, this.elements[i2 / 2])) {
            this.store_element(i2, this.elements[i2 / 2]);
            i2 /= 2;
        }
        this.store_element(i2, element);
    }

    private int move_bubble_down(int i2) {
        int sz = this.size;
        int right_child = i2 * 2 + 1;
        while (right_child <= sz) {
            if (this.less(this.elements[right_child - 1], this.elements[right_child])) {
                --right_child;
            }
            this.store_element(i2, this.elements[right_child]);
            i2 = right_child;
            right_child = i2 * 2 + 1;
        }
        if (right_child - 1 == sz) {
            this.store_element(i2, this.elements[right_child - 1]);
            i2 = right_child - 1;
        }
        return i2;
    }

    private void resize(int new_capacity) {
        this.capacity = new_capacity < 32 ? 32 : new_capacity;
        E[] new_elements = this.alloc_array(this.capacity + 1);
        if (this.elements != null) {
            for (int i2 = 1; i2 <= this.size; ++i2) {
                new_elements[i2] = this.elements[i2];
            }
        }
        assert (new_elements != null);
        assert (this.capacity >= this.size);
        this.elements = new_elements;
    }

    private void store_element(int i2, E element) {
        this.elements[i2] = element;
        this.set_index(this.elements[i2], i2);
    }

    public void update(E element) {
        int i2 = this.get_index(element);
        if (i2 == 0) {
            this.push(element);
        } else {
            this.set_index(this.elements[i2], 0);
            int bubble = this.move_bubble_down(i2);
            this.insert_and_bubble_up(bubble, element);
        }
    }

    public void remove(E element) {
        int i2 = this.get_index(element);
        if (i2 > 0) {
            this.remove(i2);
        }
    }

    protected abstract boolean less(E var1, E var2);

    protected abstract int get_index(E var1);

    protected abstract void set_index(E var1, int var2);

    protected abstract E[] alloc_array(int var1);
}

