/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.datastructures;

import java.util.Vector;

public class Array3D<T> {
    private int wx;
    private int wy;
    private int wz;
    private int sz;
    private Vector<T> field;
    private T defaultValue;

    public Array3D(int wx, int wy, int wz, T defaultValue, boolean fillWithDefault) {
        this.wx = wx;
        this.wy = wy;
        this.wz = wz;
        this.sz = this.wx * this.wy * this.wz;
        this.defaultValue = defaultValue;
        this.field = new Vector(this.sz);
        this.field.setSize(this.sz);
        if (fillWithDefault) {
            this.fillWith(defaultValue);
        }
    }

    public boolean inRange(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.wx && y < this.wy && z < this.wz;
    }

    private int getOff(int x, int y, int z) {
        if (!this.inRange(x, y, z)) {
            return -1;
        }
        int off = x + y * this.wx + z * this.wx * this.wy;
        assert (off >= 0 && off < this.sz);
        return off;
    }

    public T getAt(int x, int y, int z) {
        int off = this.getOff(x, y, z);
        if (off == -1) {
            return this.defaultValue;
        }
        return this.field.elementAt(off);
    }

    public void setAt(int x, int y, int z, T newValue) {
        int off = this.getOff(x, y, z);
        assert (off != -1);
        this.field.setElementAt(newValue, off);
    }

    public void fillWith(T fillElement) {
        for (int i2 = 0; i2 < this.sz; ++i2) {
            this.field.setElementAt(fillElement, i2);
        }
    }

    public Array3D<T> clone() {
        Array3D<T> n2 = new Array3D<T>(this.wx, this.wy, this.wz, this.defaultValue, false);
        for (int i2 = 0; i2 < this.sz; ++i2) {
            n2.field.setElementAt(this.field.elementAt(i2), i2);
        }
        return n2;
    }

    public int getWidthX() {
        return this.wx;
    }

    public int getWidthY() {
        return this.wy;
    }

    public int getWidthZ() {
        return this.wz;
    }
}

