/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.experimentalAStar1.AStarRoutingFrame;
import com.sun.electric.tool.routing.experimentalAStar2.AStarRouter;
import com.sun.electric.tool.routing.experimentalLeeMoore1.yana;
import com.sun.electric.tool.routing.experimentalLeeMoore3.RoutingFrameLeeMoore;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableDouble;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public abstract class RoutingFrame {
    private static final boolean DEBUGROUTES = false;
    private static RoutingFrame[] routingAlgorithms = new RoutingFrame[]{new AStarRoutingFrame(), new AStarRouter(), new com.sun.electric.tool.routing.experimentalAStar3.AStarRouter(), new yana(), new com.sun.electric.tool.routing.experimentalLeeMoore2.RoutingFrameLeeMoore(), new RoutingFrameLeeMoore()};
    private ArrayList<RoutingParameter> allParameters = new ArrayList();

    public static RoutingFrame[] getRoutingAlgorithms() {
        return routingAlgorithms;
    }

    protected void runRouting(Cell cell, List<RoutingSegment> segmentsToRoute, List<RoutingLayer> allLayers, List<RoutingContact> allContacts, List<RoutingGeometry> blockages) {
    }

    public String getAlgorithmName() {
        return "?";
    }

    public List<RoutingParameter> getParameters() {
        return this.allParameters;
    }

    private int indexOfParameter(String parameterKey) {
        for (int j2 = 0; j2 < this.allParameters.size(); ++j2) {
            if (!parameterKey.equals(this.allParameters.get((int)j2).key)) continue;
            return j2;
        }
        return -1;
    }

    public int doRouting(Cell cell, EditingPreferences ep, RoutingPrefs routingOptions) {
        RoutingLayer rl;
        Layer lay;
        double width;
        Netlist netList = cell.getNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return 0;
        }
        HashMap<Layer, RoutingLayer> routingLayers = new HashMap<Layer, RoutingLayer>();
        ArrayList<RoutingLayer> allLayers = new ArrayList<RoutingLayer>();
        Technology tech = cell.getTechnology();
        MutableDouble mutableDist = new MutableDouble(0.0);
        Iterator<Comparable<ArcProto>> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (!ap.getFunction().isMetal()) continue;
            Layer layer = ap.getLayer(0);
            double minWidth = ap.getDefaultLambdaBaseWidth(ep);
            DRC.getMaxSurround(layer, Double.MAX_VALUE, mutableDist);
            double maxSurround = mutableDist.doubleValue();
            RoutingLayer rl2 = new RoutingLayer(layer, ap, ep, minWidth, maxSurround);
            routingLayers.put(layer, rl2);
            allLayers.add(rl2);
        }
        it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (!layer.getFunction().isContact() || layer.getFunction().getLevel() == 0) continue;
            DRC.getMaxSurround(layer, Double.MAX_VALUE, mutableDist);
            double maxSurround = mutableDist.doubleValue();
            RoutingLayer rl3 = new RoutingLayer(layer, null, ep, 0.0, maxSurround);
            routingLayers.put(layer, rl3);
            allLayers.add(rl3);
        }
        for (RoutingLayer rl4 : allLayers) {
            Layer layer = rl4.layer;
            for (RoutingLayer oRl : allLayers) {
                Layer oLayer = oRl.layer;
                width = 3.0;
                double length = 50.0;
                DRCTemplate rule = DRC.getSpacingRule(layer, null, oLayer, null, false, -1, width, length);
                if (rule == null) continue;
                rl4.minSpacing.put(oRl, rule.getValue(0));
            }
        }
        ArrayList<RoutingContact> allContacts = new ArrayList<RoutingContact>();
        Iterator<PrimitiveNode> it2 = tech.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode pnp = it2.next();
            if (pnp.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            ArrayList<RoutingGeometry> contactGeom = new ArrayList<RoutingGeometry>();
            Technology.NodeLayer[] nLayers = pnp.getNodeLayers();
            Layer cutLayer = null;
            width = pnp.getDefWidth(ep);
            double height = pnp.getDefHeight(ep);
            for (int i2 = 0; i2 < nLayers.length; ++i2) {
                lay = nLayers[i2].getLayer();
                if (lay.getFunction().isContact()) {
                    cutLayer = lay;
                    continue;
                }
                rl = (RoutingLayer)routingLayers.get(lay);
                if (rl == null) continue;
                EdgeH left = nLayers[i2].getLeftEdge();
                double leftSide = left.getAdder().getLambda() + left.getMultiplier() * width;
                EdgeH right = nLayers[i2].getRightEdge();
                double rightSide = right.getAdder().getLambda() + right.getMultiplier() * width;
                EdgeV top = nLayers[i2].getTopEdge();
                double topSide = top.getAdder().getLambda() + top.getMultiplier() * height;
                EdgeV bot = nLayers[i2].getBottomEdge();
                double botSide = bot.getAdder().getLambda() + bot.getMultiplier() * height;
                Rectangle2D.Double bounds = new Rectangle2D.Double(leftSide, topSide, rightSide - leftSide, botSide - topSide);
                RoutingGeometry rg = new RoutingGeometry(rl, bounds, 0);
                contactGeom.add(rg);
            }
            RoutingLayer first = null;
            RoutingLayer second = null;
            PrimitivePort pp = pnp.getPort(0);
            ArcProto[] arcs = pp.getConnections();
            for (int i3 = 0; i3 < arcs.length; ++i3) {
                if (arcs[i3].getTechnology() == Generic.tech()) continue;
                for (int j2 = 0; j2 < arcs[i3].getNumArcLayers(); ++j2) {
                    Layer lay2 = arcs[i3].getLayer(j2);
                    RoutingLayer rl5 = (RoutingLayer)routingLayers.get(lay2);
                    if (rl5 == null) continue;
                    if (first == null) {
                        first = rl5;
                        continue;
                    }
                    if (second != null) continue;
                    second = rl5;
                }
            }
            if (first == null || second == null || cutLayer == null) continue;
            double spacing = 2.0;
            double arcWidth = 3.0;
            double arcLength = 50.0;
            DRCTemplate ruleSpacing = DRC.getSpacingRule(cutLayer, null, cutLayer, null, false, -1, arcWidth, arcLength);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double cutWidth = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(cutLayer, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                cutWidth = ruleWidth.getValue(0);
            }
            double viaSurround = spacing + cutWidth;
            RoutingContact rc = new RoutingContact(pnp, ep, contactGeom, first, second, viaSurround);
            allContacts.add(rc);
        }
        ArrayList<RoutingGeometry> blockages = new ArrayList<RoutingGeometry>();
        HashMap<ArcInst, Integer> netIDs = new HashMap<ArcInst, Integer>();
        GeometryVisitor visitor = new GeometryVisitor(routingLayers, blockages, netIDs);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        ArrayList<RoutingSegment> segmentsToRoute = new ArrayList<RoutingSegment>();
        Iterator<ArcInst> it3 = cell.getArcs();
        while (it3.hasNext()) {
            ArcInst ai = it3.next();
            if (ai.getProto() != Generic.tech().unrouted_arc) continue;
            ArrayList<RoutingLayer> startLayers = new ArrayList<RoutingLayer>();
            ArcProto[] startArcs = ai.getHeadPortInst().getPortProto().getBasePort().getConnections();
            for (int i4 = 0; i4 < startArcs.length; ++i4) {
                if (startArcs[i4].getTechnology() == Generic.tech()) continue;
                for (int j3 = 0; j3 < startArcs[i4].getNumArcLayers(); ++j3) {
                    lay = startArcs[i4].getLayer(j3);
                    rl = (RoutingLayer)routingLayers.get(lay);
                    if (rl == null) continue;
                    startLayers.add(rl);
                }
            }
            ArrayList<RoutingLayer> finishLayers = new ArrayList<RoutingLayer>();
            ArcProto[] endArcs = ai.getTailPortInst().getPortProto().getBasePort().getConnections();
            for (int i5 = 0; i5 < endArcs.length; ++i5) {
                if (endArcs[i5].getTechnology() == Generic.tech()) continue;
                for (int j4 = 0; j4 < endArcs[i5].getNumArcLayers(); ++j4) {
                    Layer lay3 = endArcs[i5].getLayer(j4);
                    RoutingLayer rl6 = (RoutingLayer)routingLayers.get(lay3);
                    if (rl6 == null) continue;
                    finishLayers.add(rl6);
                }
            }
            RoutingEnd startPI = new RoutingEnd(ai.getHeadPortInst());
            RoutingEnd finishPI = new RoutingEnd(ai.getTailPortInst());
            ArrayList<Geometric> thingsToDelete = new ArrayList<Geometric>();
            thingsToDelete.add(ai);
            Integer netID = (Integer)netIDs.get(ai);
            String netName = netList.getNetworkName(ai);
            RoutingSegment rs = new RoutingSegment(startPI, startLayers, finishPI, finishLayers, netID == null ? 0 : netID, netName, thingsToDelete);
            segmentsToRoute.add(rs);
        }
        ElapseTimer timer = ElapseTimer.createInstance().start();
        System.out.println("Running Routing on cell '" + cell.describe(false) + "' using the '" + this.getAlgorithmName() + "' algorithm");
        for (RoutingParameter par : this.allParameters) {
            par.setValue(routingOptions.getParameter(par));
        }
        this.runRouting(cell, segmentsToRoute, allLayers, allContacts, blockages);
        int numRouted = 0;
        for (RoutingSegment rs : segmentsToRoute) {
            List<RoutePoint> contacts = rs.routedPoints;
            List<RouteWire> wires = rs.routedWires;
            if (contacts.isEmpty() && wires.isEmpty()) continue;
            HashMap<RoutePoint, PortInst> builtContacts = new HashMap<RoutePoint, PortInst>();
            for (RoutePoint rp : contacts) {
                RoutingContact rc = rp.getContact();
                if (rc == RoutingContact.FINISHPOINT || rc == RoutingContact.STARTPOINT) continue;
                Orientation orient = Orientation.fromAngle(rp.angle);
                double width2 = rc.np.getDefWidth(ep);
                double height = rc.np.getDefHeight(ep);
                NodeInst ni = NodeInst.makeInstance(rc.np, ep, rp.loc, width2, height, cell, orient, null);
                builtContacts.put(rp, ni.getOnlyPortInst());
            }
            for (RouteWire rw : wires) {
                ArcProto ap;
                ArcInst ai;
                RoutePoint finish;
                PortInst finishPI;
                RoutePoint start = rw.start;
                PortInst startPI = (PortInst)builtContacts.get(start);
                if (startPI == null) {
                    if (start.getContact() == RoutingContact.STARTPOINT) {
                        startPI = rs.startEnd.pi;
                    } else if (start.getContact() == RoutingContact.FINISHPOINT) {
                        startPI = rs.finishEnd.pi;
                    }
                    if (startPI == null) {
                        System.out.println("CANNOT DETERMINE STARTING POINT OF WIRE");
                    }
                }
                if ((finishPI = (PortInst)builtContacts.get(finish = rw.end)) == null) {
                    if (finish.getContact() == RoutingContact.STARTPOINT) {
                        finishPI = rs.startEnd.pi;
                    } else if (finish.getContact() == RoutingContact.FINISHPOINT) {
                        finishPI = rs.finishEnd.pi;
                    }
                    if (finishPI == null) {
                        System.out.println("CANNOT DETERMINE ENDING POINT OF WIRE");
                    }
                }
                if ((ai = ArcInst.makeInstanceBase(ap = rw.layer.ap, ep, rw.width, startPI, finishPI)) == null) {
                    System.out.println("FAILED TO RUN ARC");
                    continue;
                }
                if (start.loc.getX() == finish.loc.getX() || start.loc.getY() == finish.loc.getY()) continue;
                ai.setFixedAngle(false);
            }
            for (Geometric geom : rs.thingsToDelete) {
                if (!(geom instanceof ArcInst)) continue;
                ((ArcInst)geom).kill();
            }
            for (Geometric geom : rs.thingsToDelete) {
                if (!(geom instanceof NodeInst)) continue;
                ((NodeInst)geom).kill();
            }
            ++numRouted;
        }
        timer.end();
        System.out.println("Routed " + numRouted + " out of " + segmentsToRoute.size() + " segments (took " + String.valueOf(timer) + ")");
        return numRouted;
    }

    public class RoutingParameter {
        public static final int TYPEINTEGER = 1;
        public static final int TYPESTRING = 2;
        public static final int TYPEDOUBLE = 3;
        public static final int TYPEBOOLEAN = 4;
        private final String key;
        private final String title;
        private final Object factoryValue;
        private Object cachedValue;
        private final int type;
        private int tempInt;
        private String tempString;
        private double tempDouble;
        private boolean tempBoolean;
        private boolean tempValueSet;

        public RoutingParameter(String name, String title, int factory) {
            this.key = RoutingFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = Integer.valueOf(factory);
            this.type = 1;
            this.tempValueSet = false;
            RoutingFrame.this.allParameters.add(this);
        }

        public RoutingParameter(String name, String title, String factory) {
            this.key = RoutingFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = String.valueOf(factory);
            this.type = 2;
            this.tempValueSet = false;
            RoutingFrame.this.allParameters.add(this);
        }

        public RoutingParameter(String name, String title, double factory) {
            this.key = RoutingFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = Double.valueOf(factory);
            this.type = 3;
            this.tempValueSet = false;
            RoutingFrame.this.allParameters.add(this);
        }

        public RoutingParameter(String name, String title, boolean factory) {
            this.key = RoutingFrame.this.getAlgorithmName() + "-" + name;
            this.title = title;
            this.cachedValue = this.factoryValue = Boolean.valueOf(factory);
            this.type = 4;
            this.tempValueSet = false;
            RoutingFrame.this.allParameters.add(this);
        }

        public RoutingFrame getOwner() {
            return RoutingFrame.this;
        }

        public String getName() {
            return this.title;
        }

        public int getType() {
            return this.type;
        }

        public int getIntValue() {
            return (Integer)this.cachedValue;
        }

        public String getStringValue() {
            return (String)this.cachedValue;
        }

        public double getDoubleValue() {
            return (Double)this.cachedValue;
        }

        public boolean getBooleanValue() {
            return (Boolean)this.cachedValue;
        }

        private void setValue(Object value) {
            assert (value.getClass() == this.factoryValue.getClass());
            if (value.equals(this.factoryValue)) {
                value = this.factoryValue;
            }
            this.cachedValue = value;
        }

        public int getTempIntValue() {
            return this.tempInt;
        }

        public String getTempStringValue() {
            return this.tempString;
        }

        public double getTempDoubleValue() {
            return this.tempDouble;
        }

        public boolean getTempBooleanValue() {
            return this.tempBoolean;
        }

        public void setTempIntValue(int i2) {
            this.tempInt = i2;
            this.tempValueSet = true;
        }

        public void setTempStringValue(String s) {
            this.tempString = s;
            this.tempValueSet = true;
        }

        public void setTempDoubleValue(double d2) {
            this.tempDouble = d2;
            this.tempValueSet = true;
        }

        public void setTempBooleanValue(boolean d2) {
            this.tempBoolean = d2;
            this.tempValueSet = true;
        }

        public boolean hasTempValue() {
            return this.tempValueSet;
        }

        public void clearTempValue() {
            this.tempValueSet = false;
        }
    }

    public static class RoutingLayer {
        private Layer layer;
        private ArcProto ap;
        private double minWidth;
        private double maxSurround;
        private Map<RoutingLayer, Double> minSpacing;
        private RoutingContact pin;
        private boolean isMetal;

        public RoutingLayer(Layer layer, ArcProto ap, EditingPreferences ep, double minWidth, double maxSurround) {
            this.layer = layer;
            this.ap = ap;
            this.minWidth = minWidth;
            this.maxSurround = maxSurround;
            this.isMetal = layer.getFunction().isMetal();
            this.minSpacing = new HashMap<RoutingLayer, Double>();
            if (ap != null) {
                PrimitiveNode pinNP = ap.findPinProto();
                this.pin = new RoutingContact(pinNP, ep, null, this, this, 0.0);
            }
        }

        public String getName() {
            return this.layer.getName();
        }

        public boolean isMetal() {
            return this.isMetal;
        }

        public int getMetalNumber() {
            return this.layer.getFunction().getLevel();
        }

        public RoutingContact getPin() {
            return this.pin;
        }

        public double getMinWidth() {
            return this.minWidth;
        }

        public double getMaxSurround() {
            return this.maxSurround;
        }

        public double getMinSpacing(RoutingLayer other) {
            Double dist = this.minSpacing.get(other);
            if (dist == null) {
                return 0.0;
            }
            return dist;
        }
    }

    public static class RoutingGeometry {
        private RoutingLayer layer;
        private Rectangle2D bounds;
        private int netID;

        public RoutingGeometry(RoutingLayer layer, Rectangle2D bounds, int netID) {
            this.layer = layer;
            this.bounds = bounds;
            this.netID = netID;
        }

        public RoutingLayer getLayer() {
            return this.layer;
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public int getNetID() {
            return this.netID;
        }
    }

    public static class RoutingContact {
        private PrimitiveNode np;
        private List<RoutingGeometry> layers;
        private RoutingLayer first;
        private RoutingLayer second;
        private double viaSpacing;
        private double defWidth;
        private double defHeight;
        public static RoutingContact STARTPOINT = new RoutingContact(null, null, null, null, null, 0.0);
        public static RoutingContact FINISHPOINT = new RoutingContact(null, null, null, null, null, 0.0);

        public RoutingContact(PrimitiveNode np, EditingPreferences ep, List<RoutingGeometry> layers, RoutingLayer first, RoutingLayer second, double viaSpacing) {
            this.np = np;
            this.layers = layers;
            this.first = first;
            this.second = second;
            this.viaSpacing = viaSpacing;
            if (np != null) {
                this.defWidth = np.getDefWidth(ep);
                this.defHeight = np.getDefHeight(ep);
            }
        }

        public String getName() {
            if (this == STARTPOINT) {
                return "START-POINT";
            }
            if (this == FINISHPOINT) {
                return "FINISH-POINT";
            }
            return this.np.describe(false);
        }

        public List<RoutingGeometry> getGeometry() {
            return this.layers;
        }

        public RoutingLayer getFirstLayer() {
            return this.first;
        }

        public RoutingLayer getSecondLayer() {
            return this.second;
        }

        public double getViaSpacing() {
            return this.viaSpacing;
        }

        public double getDefWidth() {
            return this.defWidth;
        }

        public double getDefHeight() {
            return this.defHeight;
        }
    }

    private class GeometryVisitor
    extends HierarchyEnumerator.Visitor {
        private Map<Layer, RoutingLayer> routingLayers;
        private List<RoutingGeometry> blockages;
        private Map<ArcInst, Integer> netIDs;

        public GeometryVisitor(Map<Layer, RoutingLayer> routingLayers, List<RoutingGeometry> blockages, Map<ArcInst, Integer> netIDs) {
            this.routingLayers = routingLayers;
            this.blockages = blockages;
            this.netIDs = netIDs;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Netlist nl = info.getNetlist();
            FixpTransform trans = info.getTransformToRoot();
            Iterator<Geometric> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                int netID = -1;
                Network net = nl.getNetwork(ai, 0);
                if (net != null) {
                    netID = info.getNetID(net);
                }
                for (int i2 = 0; i2 < polys.length; ++i2) {
                    ((PolyBase)polys[i2]).transform(trans);
                    this.addGeometry(cell, polys[i2], this.blockages, netID);
                }
                if (!info.isRootCell() || ai.getProto() != Generic.tech().unrouted_arc) continue;
                this.netIDs.put(ai, netID);
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (ni.isCellInstance() || ni.getFunction() == PrimitiveNode.Function.PIN) continue;
                FixpTransform nodeTrans = ni.rotateOut(trans);
                Technology tech = ni.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, true, false, null);
                for (int i3 = 0; i3 < polys.length; ++i3) {
                    Network net;
                    Poly poly = polys[i3];
                    ((PolyBase)poly).transform(nodeTrans);
                    int netID = -1;
                    if (poly.getPort() != null && (net = nl.getNetwork(ni, poly.getPort(), 0)) != null) {
                        netID = info.getNetID(net);
                    }
                    this.addGeometry(cell, poly, this.blockages, netID);
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        private void addGeometry(Cell cell, PolyBase poly, List<RoutingGeometry> blockages, int netID) {
            RoutingLayer rl = this.routingLayers.get(poly.getLayer());
            if (rl == null) {
                return;
            }
            FixpRectangle bounds = poly.getBounds2D();
            RoutingGeometry rg = new RoutingGeometry(rl, bounds, netID);
            blockages.add(rg);
        }
    }

    public static class RoutingEnd {
        private PortInst pi;
        private Point2D location;

        public RoutingEnd(PortInst pi) {
            this.pi = pi;
            this.location = pi.getCenter();
        }

        public Point2D getLocation() {
            return this.location;
        }

        public String describe() {
            return this.pi.getPortProto().getName() + " of node " + this.pi.getNodeInst().describe(false);
        }
    }

    public static class RoutingSegment {
        private RoutingEnd startEnd;
        private RoutingEnd finishEnd;
        private List<RoutingLayer> startLayers;
        private List<RoutingLayer> finishLayers;
        private double startWidestArc;
        private double finishWidestArc;
        private List<RoutePoint> routedPoints;
        private List<RouteWire> routedWires;
        private String netName;
        private int netID;
        private List<Geometric> thingsToDelete;

        public RoutingSegment(RoutingEnd startEnd, List<RoutingLayer> startLayers, RoutingEnd finishEnd, List<RoutingLayer> finishLayers, int netID, String netName, List<Geometric> thingsToDelete) {
            this.startLayers = startLayers;
            this.startEnd = startEnd;
            this.startWidestArc = this.getWidestMetalArcOnPort(startEnd.pi);
            this.finishLayers = finishLayers;
            this.finishEnd = finishEnd;
            this.finishWidestArc = this.getWidestMetalArcOnPort(finishEnd.pi);
            this.netID = netID;
            this.netName = netName;
            this.thingsToDelete = thingsToDelete;
            this.routedPoints = new ArrayList<RoutePoint>();
            this.routedWires = new ArrayList<RouteWire>();
        }

        public RoutingEnd getStartEnd() {
            return this.startEnd;
        }

        public List<RoutingLayer> getStartLayers() {
            return this.startLayers;
        }

        public double getWidestArcAtStart() {
            return this.startWidestArc;
        }

        public RoutingEnd getFinishEnd() {
            return this.finishEnd;
        }

        public List<RoutingLayer> getFinishLayers() {
            return this.finishLayers;
        }

        public double getWidestArcAtFinish() {
            return this.finishWidestArc;
        }

        public int getNetID() {
            return this.netID;
        }

        public String getNetName() {
            return this.netName;
        }

        public void addWire(RouteWire rw) {
            this.routedWires.add(rw);
        }

        public void addWireEnd(RoutePoint rp) {
            this.routedPoints.add(rp);
        }

        private double getWidestMetalArcOnPort(PortInst pi) {
            Export export;
            PortInst exportedInst;
            double width2;
            double width = 0.0;
            Iterator<Connection> it = pi.getConnections();
            while (it.hasNext()) {
                double newWidth;
                Connection c2 = it.next();
                ArcInst ai = c2.getArc();
                if (!ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
                width = newWidth;
            }
            NodeInst ni = pi.getNodeInst();
            if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
                width = width2;
            }
            return width;
        }
    }

    public static class RoutingPrefs
    extends PrefPackage {
        private Object[][] values;
        private static final String NODE_NAME = "tool/routing";

        public RoutingPrefs(boolean factory) {
            super(factory);
            Preferences prefs = (factory ? RoutingPrefs.getFactoryPrefRoot() : RoutingPrefs.getPrefRoot()).node(NODE_NAME);
            this.values = new Object[routingAlgorithms.length][];
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                RoutingFrame rf = routingAlgorithms[i2];
                this.values[i2] = new Object[rf.allParameters.size()];
                for (int j2 = 0; j2 < rf.allParameters.size(); ++j2) {
                    RoutingParameter par = rf.allParameters.get(j2);
                    String key = rf.getAlgorithmName() + "-" + par.key;
                    Object value = switch (par.type) {
                        case 1 -> prefs.getInt(key, (Integer)par.factoryValue);
                        case 2 -> String.valueOf(prefs.get(key, (String)par.factoryValue));
                        case 3 -> prefs.getDouble(key, (Double)par.factoryValue);
                        case 4 -> prefs.getBoolean(key, (Boolean)par.factoryValue);
                        default -> throw new AssertionError();
                    };
                    if (value.equals(par.factoryValue)) {
                        value = par.factoryValue;
                    }
                    this.values[i2][j2] = value;
                }
            }
        }

        @Override
        protected void putPrefs(Preferences prefRoot, boolean removeDefaults) {
            super.putPrefs(prefRoot, removeDefaults);
            Preferences prefs = prefRoot.node(NODE_NAME);
            assert (this.values.length == routingAlgorithms.length);
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                RoutingFrame rf = routingAlgorithms[i2];
                assert (this.values[i2].length == rf.allParameters.size());
                block7: for (int j2 = 0; j2 < rf.allParameters.size(); ++j2) {
                    RoutingParameter par = rf.allParameters.get(j2);
                    String key = rf.getAlgorithmName() + "-" + par.key;
                    Object v = this.values[i2][j2];
                    if (removeDefaults && v.equals(par.factoryValue)) {
                        prefs.remove(key);
                        continue;
                    }
                    switch (par.type) {
                        case 1: {
                            prefs.putInt(key, (Integer)v);
                            continue block7;
                        }
                        case 2: {
                            prefs.put(key, (String)v);
                            continue block7;
                        }
                        case 3: {
                            prefs.putDouble(key, (Double)v);
                            continue block7;
                        }
                        case 4: {
                            prefs.putBoolean(key, (Boolean)v);
                            continue block7;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
            }
        }

        public Object getParameter(RoutingParameter par) {
            int i2 = this.indexOfFrame(par);
            RoutingFrame rf = routingAlgorithms[i2];
            int j2 = rf.indexOfParameter(par.key);
            return this.values[i2][j2];
        }

        public RoutingPrefs withParameter(RoutingParameter par, Object value) {
            RoutingFrame rf;
            int j2;
            int i2 = this.indexOfFrame(par);
            Object oldValue = this.values[i2][j2 = (rf = routingAlgorithms[i2]).indexOfParameter(par.key)];
            if (oldValue.equals(value)) {
                return this;
            }
            assert (value.getClass() == par.factoryValue.getClass());
            if (value.equals(par.factoryValue)) {
                value = par.factoryValue;
            }
            Object[] vs = (Object[])this.values[i2].clone();
            vs[j2] = value;
            Object[][] newValues = (Object[][])this.values.clone();
            newValues[i2] = vs;
            return (RoutingPrefs)this.withField("values", newValues);
        }

        private int indexOfFrame(RoutingParameter par) {
            RoutingFrame rf = par.getOwner();
            for (int i2 = 0; i2 < routingAlgorithms.length; ++i2) {
                if (rf.getClass() != routingAlgorithms[i2].getClass()) continue;
                return i2;
            }
            return -1;
        }
    }

    public static class RoutePoint {
        private RoutingContact contact;
        private Point2D loc;
        private int angle;

        public RoutePoint(RoutingContact contact, Point2D loc, int angle) {
            this.contact = contact;
            this.loc = loc;
            this.angle = angle;
        }

        public RoutingContact getContact() {
            return this.contact;
        }

        public Point2D getLocation() {
            return this.loc;
        }
    }

    public static class RouteWire {
        private RoutingLayer layer;
        private RoutePoint start;
        private RoutePoint end;
        private double width;

        public RouteWire(RoutingLayer layer, RoutePoint start, RoutePoint end, double width) {
            this.layer = layer;
            this.start = start;
            this.end = end;
            this.width = width;
        }
    }
}

