/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProjectLibrary
implements Serializable {
    private String projDirectory;
    private Library lib;
    private List<ProjectCell> allCells = new ArrayList<ProjectCell>();
    private HashMap<Cell, ProjectCell> byCell = new HashMap();
    private transient RandomAccessFile raf;
    private transient FileLock lock;

    private ProjectLibrary() {
    }

    static ProjectLibrary createProject(Library lib) {
        ProjectLibrary pl = new ProjectLibrary();
        pl.lib = lib;
        Variable var = lib.getVar(Project.PROJPATHKEY);
        if (var == null) {
            return pl;
        }
        URL url = TextUtils.makeURLToFile((String)var.getObject());
        if (!TextUtils.URLExists(url)) {
            url = null;
            if (Project.getRepositoryLocation().length() > 0 && !TextUtils.URLExists(url = TextUtils.makeURLToFile(Project.getRepositoryLocation() + File.separator + lib.getName() + File.separator + "project.proj"))) {
                url = null;
            }
            if (url == null) {
                String userFile = OpenFile.chooseInputFile(FileType.PROJECT, "Find Project File for " + String.valueOf(lib), null);
                if (userFile == null) {
                    return pl;
                }
                url = TextUtils.makeURLToFile(userFile);
            }
        }
        String projectFile = url.getFile();
        String projDir = "";
        int sepPos = projectFile.lastIndexOf(47);
        if (sepPos >= 0) {
            projDir = projectFile.substring(0, sepPos);
        }
        try {
            pl.raf = new RandomAccessFile(projectFile, "r");
        }
        catch (FileNotFoundException e2) {
            System.out.println("Cannot read file: " + projectFile);
            return pl;
        }
        if (Project.getRepositoryLocation().length() == 0) {
            int nextSepPos;
            String repositoryLocation = null;
            if (sepPos > 1 && (nextSepPos = projectFile.lastIndexOf(47, sepPos - 1)) >= 0) {
                repositoryLocation = projectFile.substring(0, nextSepPos);
            }
            if (repositoryLocation == null) {
                Job.getUserInterface().showInformationMessage("You should setup Project Management by choosing a Repository location.  Use the 'Project Management' tab under General Preferences", "Setup Project Management");
            } else {
                Project.setRepositoryLocation(repositoryLocation);
            }
        }
        pl.projDirectory = projDir;
        pl.loadProjectFile();
        try {
            pl.raf.close();
        }
        catch (IOException e3) {
            System.out.println("Error closing project file");
        }
        return pl;
    }

    void addProjectCell(ProjectCell pc) {
        this.allCells.add(pc);
        Collections.sort(this.allCells, new OrderedProjectCells());
    }

    void removeProjectCell(ProjectCell pc) {
        for (ProjectCell c2 : this.allCells) {
            if (!c2.getCellName().equals(pc.getCellName()) || c2.getVersion() != pc.getVersion() || c2.getView() != pc.getView()) continue;
            this.allCells.remove(c2);
            break;
        }
        if (pc.getCell() != null) {
            this.byCell.remove(pc.getCell());
        }
        Collections.sort(this.allCells, new OrderedProjectCells());
    }

    void linkProjectCellToCell(ProjectCell pc, Cell cell) {
        if (cell == null) {
            pc.setLatestVersion(false);
            this.byCell.remove(pc.getCell());
        } else {
            this.byCell.put(cell, pc);
        }
        pc.setCell(cell);
    }

    void ignoreCell(Cell cell) {
        this.byCell.remove(cell);
    }

    boolean isEmpty() {
        return this.allCells.size() == 0;
    }

    Library getLibrary() {
        return this.lib;
    }

    Iterator<ProjectCell> getProjectCells() {
        return this.allCells.iterator();
    }

    String getProjectDirectory() {
        return this.projDirectory;
    }

    void setProjectDirectory(String dir2) {
        this.projDirectory = dir2;
    }

    ProjectCell findProjectCell(Cell cell) {
        ProjectCell pc = this.byCell.get(cell);
        return pc;
    }

    ProjectCell findProjectCellByNameView(String name, View view) {
        for (ProjectCell pc : this.allCells) {
            if (!pc.getCellName().equals(name) || pc.getView() != view) continue;
            return pc;
        }
        return null;
    }

    ProjectCell findProjectCellByNameViewVersion(String name, View view, int version) {
        for (ProjectCell pc : this.allCells) {
            if (!pc.getCellName().equals(name) || pc.getView() != view || pc.getVersion() != version) continue;
            return pc;
        }
        return null;
    }

    void lockProjectFile() throws JobException {
        String errMsg = this.tryLockProjectFile();
        if (errMsg != null) {
            throw new JobException("Cannot lock the project file (" + errMsg + ").  It may be in use by another user, or it may be damaged.");
        }
    }

    static void lockManyProjectFiles(Set<ProjectLibrary> projectFiles) throws JobException {
        ArrayList<ProjectLibrary> didThem = new ArrayList<ProjectLibrary>();
        for (ProjectLibrary pl : projectFiles) {
            String errMsg = pl.tryLockProjectFile();
            if (errMsg != null) {
                for (ProjectLibrary uPl : didThem) {
                    uPl.releaseProjectFileLock(false);
                }
                throw new JobException("Cannot lock the project file for library " + pl.lib.getName() + "(" + errMsg + ").  It may be in use by another user, or it may be damaged.");
            }
            didThem.add(pl);
        }
    }

    private String tryLockProjectFile() {
        String projectFile = this.projDirectory + File.separator + "project.proj";
        try {
            this.raf = new RandomAccessFile(projectFile, "rw");
        }
        catch (FileNotFoundException e2) {
            return "Cannot read file " + projectFile;
        }
        FileChannel fc = this.raf.getChannel();
        try {
            this.lock = fc.lock();
        }
        catch (IOException e1) {
            String errMsg = "Unable to lock project file";
            try {
                this.raf.close();
            }
            catch (IOException e2) {
                errMsg = "Unable to close project file";
            }
            this.raf = null;
            return errMsg;
        }
        Object errMsg = this.loadProjectFile();
        if (errMsg != null) {
            try {
                this.lock.release();
                this.raf.close();
            }
            catch (IOException e3) {
                errMsg = (String)errMsg + "; Unable to release project file lock";
            }
            this.raf = null;
        }
        return errMsg;
    }

    void releaseProjectFileLock(boolean save) {
        if (save) {
            FileChannel fc = this.raf.getChannel();
            try {
                fc.position(0L);
                fc.truncate(0L);
                for (ProjectCell pc : this.allCells) {
                    String line = "::" + pc.getCellName() + ":" + pc.getVersion() + "-" + pc.getView().getFullName() + "." + pc.getLibExtension() + ":" + pc.getOwner() + ":" + pc.getLastOwner() + ":" + pc.getComment() + "\n";
                    ByteBuffer bb = ByteBuffer.wrap(line.getBytes());
                    fc.write(bb);
                }
            }
            catch (IOException e2) {
                System.out.println("Error saving project file");
            }
        }
        try {
            this.lock.release();
            this.raf.close();
        }
        catch (IOException e3) {
            System.out.println("Unable to unlock and close project file");
            this.lock = null;
        }
    }

    static void releaseManyProjectFiles(Set<ProjectLibrary> projectFiles) {
        for (ProjectLibrary pl : projectFiles) {
            pl.releaseProjectFileLock(true);
        }
    }

    private String loadProjectFile() {
        String cellEntry;
        this.allCells.clear();
        this.byCell.clear();
        int[] colonPos = new int[6];
        while (true) {
            String userLine = null;
            try {
                userLine = this.raf.readLine();
            }
            catch (IOException e2) {
                userLine = null;
            }
            if (userLine == null) break;
            ProjectCell pc = new ProjectCell(null, this);
            int prevPos = 0;
            for (int i2 = 0; i2 < 6; ++i2) {
                colonPos[i2] = userLine.indexOf(58, prevPos);
                prevPos = colonPos[i2] + 1;
                if (prevPos > 0) continue;
                return "Too few keywords in project file: " + userLine;
            }
            if (colonPos[0] != 0) {
                return "Missing initial ':' in project file: " + userLine;
            }
            pc.setCellName(userLine.substring(colonPos[1] + 1, colonPos[2]));
            String section = userLine.substring(colonPos[2] + 1, colonPos[3]);
            int dashPos = section.indexOf(45);
            if (dashPos < 0) {
                return "Missing '-' after version number in project file: " + userLine;
            }
            int dotPos = section.indexOf(46);
            if (dotPos < 0) {
                return "Missing '.' after view type in project file: " + userLine;
            }
            pc.setVersion(TextUtils.atoi(section.substring(0, dashPos)));
            String viewPart = section.substring(dashPos + 1, dotPos);
            pc.setView(View.findView(viewPart));
            String fileType = section.substring(dotPos + 1);
            if (fileType.equals("elib")) {
                pc.setLibType(FileType.ELIB);
            } else if (fileType.equals("jelib")) {
                pc.setLibType(FileType.JELIB);
            } else if (fileType.equals("txt")) {
                pc.setLibType(FileType.READABLEDUMP);
            } else {
                return "Unknown library type in project file: " + userLine;
            }
            pc.setOwner(userLine.substring(colonPos[3] + 1, colonPos[4]));
            pc.setLastOwner(userLine.substring(colonPos[4] + 1, colonPos[5]));
            pc.setComment(userLine.substring(colonPos[5] + 1));
            for (ProjectCell opc : this.allCells) {
                if (opc == pc || !opc.getCellName().equalsIgnoreCase(pc.getCellName()) || opc.getView() != pc.getView() || opc.getVersion() != pc.getVersion()) continue;
                System.out.println("Error in project file: version " + pc.getVersion() + ", view '" + pc.getView().getFullName() + "' of cell '" + pc.getCellName() + "' exists twice");
            }
            pc.setLatestVersion(false);
            String cellName = pc.describeWithVersion();
            Cell cell = this.lib.findNodeProto(cellName);
            pc.setCell(cell);
            if (cell == null) continue;
            if (cell.getVersion() > pc.getVersion() && !pc.getOwner().equals(Project.getCurrentUserName())) {
                if (pc.getOwner().length() == 0) {
                    System.out.println("WARNING: " + String.valueOf(cell) + " is being edited, but it is not checked-out");
                } else {
                    System.out.println("WARNING: " + String.valueOf(cell) + " is being edited, but it is checked-out to " + pc.getOwner());
                }
            }
            this.byCell.put(cell, pc);
        }
        HashMap<String, ProjectCell> mostRecent = new HashMap<String, ProjectCell>();
        for (ProjectCell pc : this.allCells) {
            cellEntry = pc.describe();
            ProjectCell recent = (ProjectCell)mostRecent.get(cellEntry);
            if (recent != null && recent.getVersion() > pc.getVersion()) continue;
            mostRecent.put(cellEntry, pc);
        }
        Iterator<ProjectCell> iterator = this.allCells.iterator();
        while (iterator.hasNext()) {
            ProjectCell pc;
            cellEntry = (pc = iterator.next()).describe();
            ProjectCell recent = (ProjectCell)mostRecent.get(cellEntry);
            pc.setLatestVersion(recent == pc);
        }
        return null;
    }

    private static class OrderedProjectCells
    implements Comparator<ProjectCell> {
        private OrderedProjectCells() {
        }

        @Override
        public int compare(ProjectCell pc1, ProjectCell pc2) {
            int diff = pc1.getCellName().compareTo(pc2.getCellName());
            if (diff != 0) {
                return diff;
            }
            diff = pc1.getView().getFullName().compareTo(pc2.getView().getFullName());
            if (diff != 0) {
                return diff;
            }
            return pc1.getVersion() - pc2.getVersion();
        }
    }
}

