/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.placement.simulatedAnnealing2.ProxyNode;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PositionIndex {
    public AreaSnapshot area = new AreaSnapshot();
    private AreaSnapshot area_buffer = new AreaSnapshot();
    private ArrayList<ProxyNode>[][] buckets;
    private double bucketSize;
    private int bucketCount;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock read = this.rwl.readLock();
    private final Lock write = this.rwl.writeLock();

    PositionIndex(double chipLength, ArrayList<ProxyNode> nodesToPlace) {
        double totalWidth = 0.0;
        double totalHeight = 0.0;
        for (ProxyNode p : nodesToPlace) {
            totalWidth += p.width;
            totalHeight += p.height;
        }
        this.bucketSize = (totalWidth + totalHeight) / (double)(2 * nodesToPlace.size());
        this.bucketCount = (int)Math.ceil(chipLength / this.bucketSize);
        this.buckets = new ArrayList[this.bucketCount][this.bucketCount];
        for (int i2 = 0; i2 < this.bucketCount; ++i2) {
            for (int j2 = 0; j2 < this.bucketCount; ++j2) {
                this.buckets[i2][j2] = new ArrayList();
            }
        }
        for (ProxyNode p : nodesToPlace) {
            this.put(p, p.getPlacementX(), p.getPlacementY());
        }
        this.swapAreaBuffer();
    }

    private void put(ProxyNode node) {
        this.put(node, node.getPlacementX(), node.getPlacementY());
    }

    private void put(ProxyNode node, double posX, double posY) {
        double l2 = posX - node.width / 2.0;
        double r = posX + node.width / 2.0;
        double t = posY - node.height / 2.0;
        double b2 = posY + node.height / 2.0;
        int minX = this.bucketNum(l2);
        int minY = this.bucketNum(t);
        int maxX = this.bucketNum(r);
        int maxY = this.bucketNum(b2);
        this.area_buffer.add(node, l2, r, t, b2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                this.buckets[x][y].add(node);
            }
        }
    }

    private void remove(ProxyNode node) {
        double l2 = node.getPlacementX() - node.width / 2.0;
        double r = node.getPlacementX() + node.width / 2.0;
        double t = node.getPlacementY() - node.height / 2.0;
        double b2 = node.getPlacementY() + node.height / 2.0;
        int minX = this.bucketNum(l2);
        int minY = this.bucketNum(t);
        int maxX = this.bucketNum(r);
        int maxY = this.bucketNum(b2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                this.buckets[x][y].remove(node);
            }
        }
        if (node == this.area_buffer.node_minX || node == this.area_buffer.node_maxX || node == this.area_buffer.node_minY || node == this.area_buffer.node_maxY || node == this.area_buffer.node_sndMaxX || node == this.area_buffer.node_sndMinX || node == this.area_buffer.node_sndMaxY || node == this.area_buffer.node_sndMinY) {
            this.calcBoundaries();
        }
    }

    private void calcBoundaries() {
        this.area_buffer = new AreaSnapshot();
        for (int i2 = 0; i2 < this.bucketCount; ++i2) {
            for (int j2 = 0; j2 < this.bucketCount; ++j2) {
                for (ProxyNode node : this.buckets[i2][j2]) {
                    double l2 = node.getPlacementX() - node.width / 2.0;
                    double r = node.getPlacementX() + node.width / 2.0;
                    double t = node.getPlacementY() - node.height / 2.0;
                    double b2 = node.getPlacementY() + node.height / 2.0;
                    this.area_buffer.add(node, l2, r, t, b2);
                }
            }
        }
    }

    public void swap(ProxyNode node1, ProxyNode node2) {
        double x = node1.getPlacementX();
        double y = node1.getPlacementY();
        this.write.lock();
        this.remove(node1);
        this.remove(node2);
        node1.setPlacement(node2.getPlacementX(), node2.getPlacementY());
        node2.setPlacement(x, y);
        this.put(node1);
        this.put(node2);
        this.swapAreaBuffer();
        this.write.unlock();
    }

    public void rotate(ProxyNode node, Orientation o2) {
        this.write.lock();
        this.remove(node);
        node.setPlacementOrientation(o2, false);
        this.put(node);
        this.swapAreaBuffer();
        this.write.unlock();
    }

    public void move(ProxyNode node, double newX, double newY) {
        this.write.lock();
        this.remove(node);
        node.setPlacement(newX, newY);
        this.put(node, newX, newY);
        this.swapAreaBuffer();
        this.write.unlock();
    }

    private void swapAreaBuffer() {
        this.area = this.area_buffer;
        this.area_buffer = this.area.clone();
    }

    public List<ProxyNode> getPossibleOverlaps(ProxyNode node) {
        ArrayList<ProxyNode> result = new ArrayList<ProxyNode>();
        int minX = this.bucketNum(node.getPlacementX() - node.width / 2.0);
        int minY = this.bucketNum(node.getPlacementY() - node.height / 2.0);
        int maxX = this.bucketNum(node.getPlacementX() + node.width / 2.0);
        int maxY = this.bucketNum(node.getPlacementY() + node.height / 2.0);
        this.read.lock();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                result.addAll(this.buckets[x][y]);
            }
        }
        this.read.unlock();
        return result;
    }

    private final int bucketNum(double pos) {
        int bucket = (int)Math.floor((pos + this.bucketSize * (double)this.bucketCount / 2.0) / this.bucketSize);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= this.bucketCount) {
            bucket = this.bucketCount - 1;
        }
        return bucket;
    }

    public static class AreaSnapshot {
        public double maxX = -1.7976931348623157E308;
        public double minX = Double.MAX_VALUE;
        public double maxY = -1.7976931348623157E308;
        public double minY = Double.MAX_VALUE;
        public double sndMaxX = this.maxX;
        public double sndMinX = this.minX;
        public double sndMaxY = this.maxY;
        public double sndMinY = this.minY;
        public ProxyNode node_maxX = null;
        public ProxyNode node_maxY = null;
        public ProxyNode node_minY = null;
        public ProxyNode node_minX = null;
        public ProxyNode node_sndMaxX = null;
        public ProxyNode node_sndMaxY = null;
        public ProxyNode node_sndMinY = null;
        public ProxyNode node_sndMinX = null;

        protected AreaSnapshot clone() {
            AreaSnapshot clone = new AreaSnapshot();
            clone.maxX = this.maxX;
            clone.minX = this.minX;
            clone.maxY = this.maxY;
            clone.minY = this.minY;
            clone.sndMaxX = this.sndMaxX;
            clone.sndMaxY = this.sndMaxY;
            clone.sndMinX = this.sndMinX;
            clone.sndMinY = this.sndMinY;
            clone.node_maxX = this.node_maxX;
            clone.node_maxY = this.node_maxY;
            clone.node_minX = this.node_minX;
            clone.node_minY = this.node_minY;
            clone.node_sndMaxX = this.node_sndMaxX;
            clone.node_sndMaxY = this.node_sndMaxY;
            clone.node_sndMinX = this.node_sndMinX;
            clone.node_sndMinY = this.node_sndMinY;
            return clone;
        }

        public double getArea() {
            return (this.maxX - this.minX) * (this.maxY - this.minY);
        }

        public double areaForDummy(ProxyNode node, ProxyNode dummy) {
            double lminX = this.minX;
            double lmaxX = this.maxX;
            double lminY = this.minY;
            double lmaxY = this.maxY;
            double ld = dummy.getPlacementX() - dummy.width / 2.0;
            double rd = dummy.getPlacementX() + dummy.width / 2.0;
            double td = dummy.getPlacementY() - dummy.height / 2.0;
            double bd = dummy.getPlacementY() + dummy.height / 2.0;
            if (node == this.node_maxX) {
                lmaxX = this.sndMaxX;
            }
            if (node == this.node_minX) {
                lminX = this.sndMinX;
            }
            if (node == this.node_minY) {
                lminY = this.sndMinY;
            }
            if (node == this.node_maxY) {
                lmaxY = this.sndMaxY;
            }
            if (ld < lminX) {
                lminX = ld;
            }
            if (rd > lmaxX) {
                lmaxX = rd;
            }
            if (td < lminY) {
                lminY = td;
            }
            if (bd > lmaxY) {
                lmaxY = bd;
            }
            return (lmaxX - lminX) * (lmaxY - lminY);
        }

        public double areaForDummy(ProxyNode node1, ProxyNode node2, ProxyNode dummy1, ProxyNode dummy2) {
            double lminX = this.minX;
            double lmaxX = this.maxX;
            double lminY = this.minY;
            double lmaxY = this.maxY;
            double ld1 = dummy1.getPlacementX() - dummy1.width / 2.0;
            double rd1 = dummy1.getPlacementX() + dummy1.width / 2.0;
            double td1 = dummy1.getPlacementY() - dummy1.height / 2.0;
            double bd1 = dummy1.getPlacementY() + dummy1.height / 2.0;
            double ld2 = dummy2.getPlacementX() - dummy2.width / 2.0;
            double rd2 = dummy2.getPlacementX() + dummy2.width / 2.0;
            double td2 = dummy2.getPlacementY() - dummy2.height / 2.0;
            double bd2 = dummy2.getPlacementY() + dummy2.height / 2.0;
            if (node1 == this.node_maxX || node2 == this.node_maxX) {
                lmaxX = this.sndMaxX;
            }
            if (node1 == this.node_minX || node2 == this.node_minX) {
                lminX = this.sndMinX;
            }
            if (node1 == this.node_minY || node2 == this.node_minY) {
                lminY = this.sndMinY;
            }
            if (node1 == this.node_maxY || node2 == this.node_maxY) {
                lmaxY = this.sndMaxY;
            }
            if (ld1 < lminX) {
                lminX = ld1;
            }
            if (rd1 > lmaxX) {
                lmaxX = rd1;
            }
            if (td1 < lminY) {
                lminY = td1;
            }
            if (bd1 > lmaxY) {
                lmaxY = bd1;
            }
            if (ld2 < lminX) {
                lminX = ld2;
            }
            if (rd2 > lmaxX) {
                lmaxX = rd2;
            }
            if (td2 < lminY) {
                lminY = td2;
            }
            if (bd2 > lmaxY) {
                lmaxY = bd2;
            }
            return (lmaxX - lminX) * (lmaxY - lminY);
        }

        public void add(ProxyNode node, double l2, double r, double t, double b2) {
            if (node == this.node_minX || node == this.node_minY || node == this.node_maxX || node == this.node_maxY) {
                return;
            }
            if (l2 < this.sndMinX) {
                this.sndMinX = l2;
                this.node_sndMinX = node;
                if (l2 < this.minX) {
                    this.sndMinX = this.minX;
                    this.minX = l2;
                    this.node_sndMinX = this.node_minX;
                    this.node_minX = node;
                }
            }
            if (r > this.sndMaxX) {
                this.sndMaxX = r;
                this.node_sndMaxX = node;
                if (r > this.maxX) {
                    this.sndMaxX = this.maxX;
                    this.maxX = r;
                    this.node_sndMaxX = this.node_maxX;
                    this.node_maxX = node;
                }
            }
            if (t < this.sndMinY) {
                this.sndMinY = t;
                this.node_sndMinY = node;
                if (t < this.minY) {
                    this.sndMinY = this.minY;
                    this.minY = t;
                    this.node_sndMinY = this.node_minY;
                    this.node_minY = node;
                }
            }
            if (b2 > this.sndMaxY) {
                this.sndMaxY = b2;
                this.node_sndMaxY = node;
                if (b2 > this.maxY) {
                    this.sndMaxY = this.maxY;
                    this.maxY = b2;
                    this.node_sndMaxY = this.node_maxY;
                    this.node_maxY = node;
                }
            }
        }
    }
}

