/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing2.ProxyNode;
import java.util.List;
import java.util.Map;

public abstract class Metric {
    public double overlap(ProxyNode node1, ProxyNode node2) {
        double minDistX;
        double X1 = node1.getPlacementX();
        double X2 = node2.getPlacementX();
        double width1 = node1.width / 2.0;
        double width2 = node2.width / 2.0;
        double distX = Math.abs(X1 - X2);
        if (distX < (minDistX = width1 + width2)) {
            double minDistY;
            double Y1 = node1.getPlacementY();
            double Y2 = node2.getPlacementY();
            double height1 = node1.height / 2.0;
            double height2 = node2.height / 2.0;
            double distY = Math.abs(Y1 - Y2);
            if (distY < (minDistY = height1 + height2)) {
                double minX1 = X1 - width1;
                double minX2 = X2 - width2;
                double maxX1 = X1 + width1;
                double maxX2 = X2 + width2;
                double minY1 = Y1 - height1;
                double minY2 = Y2 - height2;
                double maxY1 = Y1 + height1;
                double maxY2 = Y2 + height2;
                return (Math.min(maxX2, maxX1) - Math.max(minX1, minX2)) * (Math.min(maxY2, maxY1) - Math.max(minY1, minY2));
            }
        }
        return 0.0;
    }

    public double overlap(ProxyNode node, List<ProxyNode> nodes) {
        double overlap = 0.0;
        for (ProxyNode n2 : nodes) {
            if (n2 == node) continue;
            overlap += this.overlap(node, n2);
        }
        return overlap;
    }

    public double overlap(List<ProxyNode> nodes) {
        double overlap = 0.0;
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            for (int j2 = i2 + 1; j2 < nodes.size(); ++j2) {
                overlap += this.overlap(nodes.get(i2), nodes.get(j2));
            }
        }
        return overlap;
    }

    public double area(List<ProxyNode> nodes) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (ProxyNode node : nodes) {
            double currMinX = node.getPlacementX() - node.width / 2.0;
            double currMinY = node.getPlacementY() - node.height / 2.0;
            double currMaxX = node.getPlacementX() + node.width / 2.0;
            double currMaxY = node.getPlacementY() + node.height / 2.0;
            if (currMinX < minX) {
                minX = currMinX;
            }
            if (currMinY < minY) {
                minY = currMinY;
            }
            if (currMaxX > maxX) {
                maxX = currMaxX;
            }
            if (!(currMaxY > maxY)) continue;
            maxY = currMaxY;
        }
        return (maxX - minX) * (maxY - minY);
    }

    public abstract double netLength(PlacementFrame.PlacementNetwork var1);

    public abstract double netLength(PlacementFrame.PlacementNetwork var1, Map<PlacementFrame.PlacementNode, ProxyNode> var2, ProxyNode[] var3, ProxyNode[] var4);

    public double netLength(PlacementFrame.PlacementNetwork network, Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap) {
        return this.netLength(network, proxyMap, new ProxyNode[0], new ProxyNode[0]);
    }

    public double netLength(List<PlacementFrame.PlacementNetwork> networks, Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap) {
        double length = 0.0;
        for (PlacementFrame.PlacementNetwork net : networks) {
            length += this.netLength(net, proxyMap, new ProxyNode[0], new ProxyNode[0]);
        }
        return length;
    }

    public double netLength(List<PlacementFrame.PlacementNetwork> networks) {
        double length = 0.0;
        for (PlacementFrame.PlacementNetwork net : networks) {
            length += this.netLength(net);
        }
        return length;
    }
}

