/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing2.Metric;
import com.sun.electric.tool.placement.simulatedAnnealing2.ProxyNode;
import java.util.Map;

public final class BoundingBoxMetric
extends Metric {
    @Override
    public double netLength(PlacementFrame.PlacementNetwork net) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (PlacementFrame.PlacementPort port : net.getPortsOnNet()) {
            double currX = port.getPlacementNode().getPlacementX() + port.getRotatedOffX();
            double currY = port.getPlacementNode().getPlacementY() + port.getRotatedOffY();
            if (currX < minX) {
                minX = currX;
            }
            if (currY < minY) {
                minY = currY;
            }
            if (currX > maxX) {
                maxX = currX;
            }
            if (!(currY > maxY)) continue;
            maxY = currY;
        }
        return Math.abs(maxX - minX) + Math.abs(maxY - minY);
    }

    @Override
    public double netLength(PlacementFrame.PlacementNetwork net, Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap, ProxyNode[] originals, ProxyNode[] replacements) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (PlacementFrame.PlacementPort port : net.getPortsOnNet()) {
            ProxyNode proxy = proxyMap.get(port.getPlacementNode());
            for (int i2 = 0; i2 < originals.length; ++i2) {
                if (proxy != originals[i2]) continue;
                proxy = replacements[i2];
            }
            double currX = proxy.getPlacementX() + port.getRotatedOffX();
            double currY = proxy.getPlacementY() + port.getRotatedOffY();
            if (currX < minX) {
                minX = currX;
            }
            if (currY < minY) {
                minY = currY;
            }
            if (currX > maxX) {
                maxX = currX;
            }
            if (!(currY > maxY)) continue;
            maxY = currY;
        }
        return Math.abs(maxX - minX) + Math.abs(maxY - minY);
    }
}

