/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing1.metrics.AOMetric;
import com.sun.electric.tool.placement.simulatedAnnealing1.metrics.BBMetric;
import java.util.List;
import java.util.Random;

public class SA_Test
extends PlacementFrame {
    private double INITIAL_TEMP = 1.0E7;
    private int INNER_ITERATIONS = 200;
    private Random rand = new Random();

    @Override
    public String getAlgorithmName() {
        return "SA_Test";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        double delta;
        double afterScore;
        int i2;
        double temp = this.INITIAL_TEMP;
        double ratio = 0.99;
        double maxX = 0.0;
        double maxY = 0.0;
        int accepts = 1;
        int declines = 1;
        BBMetric bbMetric = new BBMetric(allNetworks);
        PlacementFrame.PlacementNode[] nodes = new PlacementFrame.PlacementNode[nodesToPlace.size()];
        for (int i3 = 0; i3 < nodesToPlace.size(); ++i3) {
            nodes[i3] = nodesToPlace.get(i3);
        }
        AOMetric aoMetric = new AOMetric(nodes);
        for (int i4 = 0; i4 < nodesToPlace.size(); ++i4) {
            PlacementFrame.PlacementNode n2 = nodes[i4];
            n2.setPlacement((double)i4 * 1.0 % Math.sqrt(nodes.length) * 200.0, Math.round((double)i4 * 1.0 / Math.sqrt(nodes.length)) * 200L);
        }
        double w = 0.0;
        double h2 = 0.0;
        for (int i5 = 0; i5 < nodesToPlace.size(); ++i5) {
            PlacementFrame.PlacementNode n3 = nodes[i5];
            if (n3.getWidth() > w) {
                w = n3.getWidth();
            }
            if (!(n3.getHeight() > h2)) continue;
            h2 = n3.getHeight();
        }
        for (PlacementFrame.PlacementNode node : nodes) {
            if (node.getPlacementX() > maxX) {
                maxX = node.getPlacementX();
            }
            if (!(node.getPlacementY() > maxY)) continue;
            maxY = node.getPlacementY();
        }
        double beforeScore = bbMetric.getScore();
        System.out.println("START: " + bbMetric.getScore());
        while (temp > 0.01) {
            for (i2 = 0; i2 < this.INNER_ITERATIONS; ++i2) {
                int index = (int)Math.round(this.rand.nextDouble() * (double)(nodes.length - 1));
                int index2 = (int)Math.round(this.rand.nextDouble() * (double)(nodes.length - 1));
                PlacementFrame.PlacementNode node1 = nodes[index];
                PlacementFrame.PlacementNode node2 = nodes[index2];
                double x1 = node1.getPlacementX();
                double y1 = node1.getPlacementY();
                double x2 = node2.getPlacementX();
                double y2 = node2.getPlacementY();
                node1.setPlacement(x2, y2);
                node2.setPlacement(x1, y1);
                afterScore = bbMetric.getScore();
                delta = afterScore - beforeScore;
                if (!(delta < 0.0) && !(this.rand.nextDouble() < Math.exp(-delta / temp))) {
                    node1.setPlacement(x1, y1);
                    node2.setPlacement(x2, y2);
                    ++declines;
                    continue;
                }
                ++accepts;
                beforeScore = afterScore;
            }
            System.out.println(temp *= ratio);
            System.out.println("SCORE: " + beforeScore);
            System.out.println("Accepts=" + accepts + ", declines=" + declines + ", ratio=" + accepts / declines);
        }
        temp = this.INITIAL_TEMP;
        accepts = 1;
        declines = 1;
        beforeScore = aoMetric.getScore();
        while (temp > 0.01) {
            for (i2 = 0; i2 < this.INNER_ITERATIONS; ++i2) {
                int index = (int)Math.round(this.rand.nextDouble() * (double)(nodes.length - 1));
                PlacementFrame.PlacementNode node1 = nodes[index];
                double x1 = node1.getPlacementX();
                double y1 = node1.getPlacementY();
                double newX = 0.0;
                double newY = 0.0;
                boolean sx = true;
                boolean sy = true;
                if (x1 < maxX / 2.0) {
                    newX = x1 + this.rand.nextDouble() * (node1.getWidth() / 20.0);
                } else {
                    newX = x1 - this.rand.nextDouble() * (node1.getWidth() / 20.0);
                    sx = false;
                }
                if (y1 < maxY / 2.0) {
                    newY = y1 + this.rand.nextDouble() * (node1.getHeight() / 20.0);
                } else {
                    newY = y1 - this.rand.nextDouble() * (node1.getHeight() / 20.0);
                    sy = false;
                }
                node1.setPlacement(newX, newY);
                afterScore = aoMetric.getScore();
                delta = afterScore - beforeScore;
                if (!(delta <= 0.0)) {
                    node1.setPlacement(x1, y1);
                    ++declines;
                    if (this.rand.nextBoolean()) {
                        if (sx) {
                            newX = x1 + this.rand.nextDouble() * (node1.getWidth() / 20.0);
                            newY = y1;
                        } else {
                            newX = x1 - this.rand.nextDouble() * (node1.getWidth() / 20.0);
                            newY = y1;
                        }
                    } else if (sy) {
                        newX = x1;
                        newY = y1 + this.rand.nextDouble() * (node1.getHeight() / 20.0);
                    } else {
                        newX = x1;
                        newY = y1 - this.rand.nextDouble() * (node1.getHeight() / 20.0);
                    }
                    node1.setPlacement(newX, newY);
                    afterScore = aoMetric.getScore();
                    delta = afterScore - beforeScore;
                    if (!(delta <= 0.0)) {
                        node1.setPlacement(x1, y1);
                        continue;
                    }
                    beforeScore = afterScore;
                    ++accepts;
                    continue;
                }
                ++accepts;
                beforeScore = afterScore;
            }
            System.out.println(temp *= ratio);
            System.out.println("SCORE: " + beforeScore);
            System.out.println("Accepts=" + accepts + ", declines=" + declines + ", ratio=" + accepts / declines);
        }
        for (i2 = 0; i2 < nodes.length; ++i2) {
            nodesToPlace.set(i2, nodes[i2]);
        }
        System.out.println("Final Bounding Box: " + bbMetric.getScore());
    }
}

