/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DeltaBBMetric {
    static List<PlacementFrame.PlacementNode> nodesToPlace;
    static List<PlacementFrame.PlacementNetwork> allNetworks;
    static Reference ref;
    static List<Integer>[] networksOfNode;
    public static Map<PlacementFrame.PlacementNode, Integer> nodeBlocks;

    public static void init(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks) {
        int i2;
        DeltaBBMetric.allNetworks = allNetworks;
        DeltaBBMetric.nodesToPlace = nodesToPlace;
        nodeBlocks = new HashMap<PlacementFrame.PlacementNode, Integer>();
        Iterator<PlacementFrame.PlacementNode> it = nodesToPlace.iterator();
        for (i2 = 0; i2 < nodesToPlace.size(); ++i2) {
            nodeBlocks.put(it.next(), i2);
        }
        networksOfNode = new LinkedList[nodesToPlace.size()];
        for (i2 = 0; i2 < networksOfNode.length; ++i2) {
            DeltaBBMetric.networksOfNode[i2] = new LinkedList<Integer>();
        }
        for (int i3 = 0; i3 < allNetworks.size(); ++i3) {
            PlacementFrame.PlacementNetwork w = allNetworks.get(i3);
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            for (PlacementFrame.PlacementPort p : pp) {
                PlacementFrame.PlacementNode n2 = p.getPlacementNode();
                Integer ii = i3;
                if (networksOfNode[nodeBlocks.get(n2)].contains(ii)) continue;
                networksOfNode[nodeBlocks.get(n2)].add(ii);
            }
        }
    }

    public static void setRef(Reference ref) {
        DeltaBBMetric.ref = ref;
    }

    public static double compute(List<Block> blocks, double[] netLengths) {
        double completeLength = DeltaBBMetric.ref.netLength;
        HashSet<Integer> changedNet = new HashSet<Integer>();
        for (Block b2 : blocks) {
            for (Integer j2 : networksOfNode[b2.getNr()]) {
                changedNet.add(j2);
            }
        }
        for (Integer i2 : changedNet) {
            PlacementFrame.PlacementNetwork w = allNetworks.get(i2);
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            double left = Double.POSITIVE_INFINITY;
            double right = Double.NEGATIVE_INFINITY;
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            for (PlacementFrame.PlacementPort p : pp) {
                int blockId = nodeBlocks.get(p.getPlacementNode());
                double offX = p.getOffX();
                double offY = p.getOffY();
                Block b3 = null;
                for (Block currBlock : blocks) {
                    if (currBlock.getNr() != blockId) continue;
                    b3 = currBlock;
                }
                Orientation o2 = b3 != null ? b3.getOrientation() : p.getPlacementNode().getPlacementOrientation();
                if (o2 != Orientation.IDENT) {
                    FixpTransform trans = o2.pureRotate();
                    Point2D.Double offset = new Point2D.Double(offX, offY);
                    trans.transform(offset, offset);
                    offX = ((Point2D)offset).getX();
                    offY = ((Point2D)offset).getY();
                }
                double xpos = b3 != null ? b3.getX() + offX : p.getPlacementNode().getPlacementX() + offX;
                double ypos = b3 != null ? b3.getY() + offY : p.getPlacementNode().getPlacementY() + offY;
                if (xpos < left) {
                    left = xpos;
                }
                if (xpos > right) {
                    right = xpos;
                }
                if (ypos > top) {
                    top = ypos;
                }
                if (!(ypos < bottom)) continue;
                bottom = ypos;
            }
            netLengths[i2.intValue()] = right - left + (top - bottom);
            completeLength += netLengths[i2];
            completeLength -= DeltaBBMetric.ref.netLengths[i2];
        }
        return completeLength;
    }

    public static double old_compute(List<Block> blocks, double[] netLengths) {
        double completeLength = 0.0;
        int n2 = 0;
        for (PlacementFrame.PlacementNetwork w : allNetworks) {
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            double left = Double.POSITIVE_INFINITY;
            double right = Double.NEGATIVE_INFINITY;
            double top = Double.NEGATIVE_INFINITY;
            double bottom = Double.POSITIVE_INFINITY;
            for (PlacementFrame.PlacementPort p : pp) {
                int blockId = nodeBlocks.get(p.getPlacementNode());
                double offX = p.getOffX();
                double offY = p.getOffY();
                Block b2 = null;
                for (Block currBlock : blocks) {
                    if (currBlock.getNr() != blockId) continue;
                    b2 = currBlock;
                }
                Orientation o2 = b2 != null ? b2.getOrientation() : p.getPlacementNode().getPlacementOrientation();
                if (o2 != Orientation.IDENT) {
                    FixpTransform trans = o2.pureRotate();
                    Point2D.Double offset = new Point2D.Double(offX, offY);
                    trans.transform(offset, offset);
                    offX = ((Point2D)offset).getX();
                    offY = ((Point2D)offset).getY();
                }
                double xpos = b2 != null ? b2.getX() + offX : p.getPlacementNode().getPlacementX() + offX;
                double ypos = b2 != null ? b2.getY() + offY : p.getPlacementNode().getPlacementY() + offY;
                if (xpos < left) {
                    left = xpos;
                }
                if (xpos > right) {
                    right = xpos;
                }
                if (ypos > top) {
                    top = ypos;
                }
                if (!(ypos < bottom)) continue;
                bottom = ypos;
            }
            completeLength += right - left + (top - bottom);
            netLengths[n2] = right - left + (top - bottom);
            ++n2;
        }
        return completeLength;
    }

    public static double compute() {
        double completeLength = 0.0;
        int n2 = 0;
        for (PlacementFrame.PlacementNetwork w : allNetworks) {
            List<PlacementFrame.PlacementPort> pp = w.getPortsOnNet();
            if (w.getPortsOnNet().size() == 0) {
                System.exit(-1337);
            }
            double l2 = pp.get(0).getPlacementNode().getPlacementX() + pp.get(0).getRotatedOffX();
            double r = pp.get(0).getPlacementNode().getPlacementX() + pp.get(0).getRotatedOffX();
            double u = pp.get(0).getPlacementNode().getPlacementY() + pp.get(0).getRotatedOffY();
            double d2 = pp.get(0).getPlacementNode().getPlacementY() + pp.get(0).getRotatedOffY();
            for (PlacementFrame.PlacementPort p : pp) {
                double xpos = p.getPlacementNode().getPlacementX() + p.getRotatedOffX();
                double ypos = p.getPlacementNode().getPlacementY() + p.getRotatedOffY();
                if (xpos < l2) {
                    l2 = xpos;
                } else if (xpos > r) {
                    r = xpos;
                }
                if (ypos < d2) {
                    d2 = ypos;
                    continue;
                }
                if (!(ypos > u)) continue;
                u = ypos;
            }
            completeLength += r - l2 + (u - d2);
            DeltaBBMetric.ref.netLengths[n2] = r - l2 + (u - d2);
            ++n2;
        }
        return completeLength;
    }
}

