/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class UniformGrid {
    LinkedList<Integer>[][] grid;
    LinkedList<Integer>[] cellOfNode;
    double left;
    double right;
    double top;
    double bottom;
    double cellW;
    int w;
    int h;

    UniformGrid(List<PlacementFrame.PlacementNode> nodesToPlace, double left, double right, double top, double bottom, double cellW) {
        this.cellOfNode = new LinkedList[nodesToPlace.size()];
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
        this.cellW = cellW;
        this.w = Math.max((int)Math.ceil((right - left) / cellW), 1);
        this.h = Math.max((int)Math.ceil((top - bottom) / cellW), 1);
        this.grid = new LinkedList[this.w][this.h];
    }

    public int getCellX(double xPos) {
        int x = (int)((xPos - this.left) / this.cellW);
        if (x < 0) {
            x = 0;
        }
        if (x >= this.w) {
            x = this.w - 1;
        }
        return x;
    }

    public int getCellY(double yPos) {
        int y = (int)((yPos - this.bottom) / this.cellW);
        if (y < 0) {
            y = 0;
        }
        if (y >= this.h) {
            y = this.h - 1;
        }
        return y;
    }

    public LinkedList<Integer> insert(int i2, double xPos, double yPos) {
        int y;
        int x = this.getCellX(xPos);
        if (this.grid[x][y = this.getCellY(yPos)] == null) {
            this.grid[x][y] = new LinkedList();
        }
        this.grid[x][y].add(i2);
        this.cellOfNode[i2] = this.grid[x][y];
        LinkedList<Integer> cellList = this.cellOfNode[i2];
        return cellList;
    }

    public void remove(int nodeIndex) {
        LinkedList<Integer> cellList = this.cellOfNode[nodeIndex];
        if (cellList == null) {
            System.out.println("ARRAY PANIC in remove in UniformGrid");
        }
        Iterator it = cellList.iterator();
        while (it.hasNext()) {
            if ((Integer)it.next() != nodeIndex) continue;
            it.remove();
            return;
        }
    }

    public double collide(Block b2, List<Block> deltas, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps) {
        double overlap = 0.0;
        int x = this.getCellX(b2.getX());
        int y = this.getCellY(b2.getY());
        Block orig = new Block();
        orig.valuesFrom(nodesToPlace.get(b2.getNr()));
        orig.number = b2.getNr();
        int oldX = this.getCellX(orig.getX());
        int oldY = this.getCellY(orig.getY());
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                overlap += this.collideCell(b2, deltas, nodesToPlace, overlaps, x + i2, y + j2, false);
                overlap -= this.collideCell(orig, deltas, nodesToPlace, overlaps, oldX + i2, oldY + j2, true);
            }
        }
        return overlap;
    }

    public double collideCell(Block b2, List<Block> deltas, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps, int x, int y, boolean oldBlock) {
        if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
            return 0.0;
        }
        if (this.grid[x][y] == null) {
            return 0.0;
        }
        double overlap = 0.0;
        Block other = new Block();
        Iterator<Block> iB = deltas.iterator();
        Block deltaBlock = iB.next();
        for (Integer i2 : this.grid[x][y]) {
            if (i2.intValue() == b2.getNr()) continue;
            other.valuesFrom(nodesToPlace.get(i2));
            while (deltaBlock.getNr() < i2 && iB.hasNext()) {
                deltaBlock = iB.next();
            }
            if (deltaBlock.getNr() == i2.intValue()) continue;
            overlap += b2.intersectionArea(other);
            if (oldBlock) {
                int n2 = b2.getNr();
                overlaps[n2] = overlaps[n2] - b2.intersectionArea(other);
                continue;
            }
            int n3 = b2.getNr();
            overlaps[n3] = overlaps[n3] + b2.intersectionArea(other);
        }
        return overlap;
    }

    public double collide(int nodeId, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps) {
        double overlap = 0.0;
        PlacementFrame.PlacementNode n2 = nodesToPlace.get(nodeId);
        Block b2 = new Block();
        b2.valuesFrom(n2);
        b2.number = nodeId;
        int x = this.getCellX(b2.getX());
        int y = this.getCellY(b2.getY());
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                overlap += this.collideCell(b2, nodesToPlace, overlaps, x + i2, y + j2);
            }
        }
        return overlap;
    }

    public double collideCell(Block b2, List<PlacementFrame.PlacementNode> nodesToPlace, double[] overlaps, int x, int y) {
        if (x < 0 || x >= this.w || y < 0 || y >= this.h) {
            return 0.0;
        }
        if (this.grid[x][y] == null) {
            return 0.0;
        }
        double overlap = 0.0;
        Block other = new Block();
        for (Integer i2 : this.grid[x][y]) {
            if (i2 >= b2.getNr()) {
                return overlap;
            }
            other.valuesFrom(nodesToPlace.get(i2));
            overlap += b2.intersectionArea(other);
            int n2 = b2.getNr();
            overlaps[n2] = overlaps[n2] + b2.intersectionArea(other);
        }
        return overlap;
    }

    public void draw(Graphics g2, double scale) {
        for (int i2 = 0; i2 < this.w; ++i2) {
            for (int j2 = 0; j2 < this.h; ++j2) {
                g2.setColor(new Color((float)i2 / (float)this.w, (float)j2 / (float)this.h, 0.3f, 0.7f));
                g2.drawRect((int)(this.left * scale + (double)i2 * this.cellW * scale), (int)(this.bottom * scale + (double)j2 * this.cellW * scale), (int)(this.cellW * scale), (int)(this.cellW * scale));
                g2.drawString("(" + i2 + "," + j2 + ")", (int)(this.left * scale + (double)i2 * this.cellW * scale), (int)(this.bottom * scale + (double)j2 * this.cellW * scale));
            }
        }
    }
}

