/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Individual;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Population<I extends Individual>
implements Runnable {
    private I[] indis;
    private int maxIndividuals;
    private Random rand;
    private long evolutionStepTime;
    double p;

    Population(List<PlacementFrame.PlacementNode> nodes, List<PlacementFrame.PlacementNetwork> allNets, I[] indis, long evolutionStepTime, Random r) {
        this.rand = r;
        this.indis = indis;
    }

    public void setProgress(double p) {
        this.p = p;
        for (int i2 = 0; i2 < this.indis.length; ++i2) {
            ((Individual)this.indis[i2]).setProgress(p);
        }
    }

    public void insert(I immigrant) {
        ((Individual)this.indis[this.indis.length - 1]).copyFrom(immigrant);
    }

    private void evolveCompetition() {
        long t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < this.evolutionStepTime) {
            Arrays.sort(this.indis);
            for (int j2 = this.maxIndividuals / 2; j2 < this.maxIndividuals; ++j2) {
                int momPos = this.rand.nextInt(this.maxIndividuals / 2);
                int dadPos = this.rand.nextInt(this.maxIndividuals / 2);
                ((Individual)this.indis[j2]).deriveFrom(this.indis[momPos], this.indis[dadPos], this.rand);
            }
        }
    }

    public I getChampion() {
        int pos = 0;
        int c2 = 0;
        double badness = ((Individual)this.indis[0]).getBadness();
        for (I i2 : this.indis) {
            if (((Individual)i2).getBadness() < badness) {
                pos = c2;
                badness = ((Individual)i2).getBadness();
            }
            ++c2;
        }
        return this.indis[pos];
    }

    public I getRandomOne() {
        return this.indis[this.rand.nextInt(this.indis.length)];
    }

    @Override
    public void run() {
        this.evolveCompetition();
    }
}

