/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.Individual;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.tool.placement.genetic2.metrics.DeltaBBMetric;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class DeltaIndividual
extends Individual<DeltaIndividual> {
    public List<Block> blocks = new ArrayList<Block>();
    private double[] hashes = new double[3];
    double[] overlaps;
    double[] netLengths;
    double spread;

    DeltaIndividual(Reference ref, Random rand) {
        super(ref);
        int i2;
        this.netLengths = new double[ref.netLengths.length];
        for (i2 = 0; i2 < ref.netLengths.length; ++i2) {
            this.netLengths[i2] = ref.netLengths[i2];
        }
        this.overlaps = new double[ref.overlaps.length];
        for (i2 = 0; i2 < ref.overlaps.length; ++i2) {
            this.overlaps[i2] = ref.overlaps[i2];
        }
        this.mutate(rand);
        this.evaluate();
    }

    @Override
    public void reboot(Random rand) {
        this.blocks.clear();
        this.mutate(rand);
        this.evaluate();
    }

    public void prepareForTest() {
        int i2 = 0;
        while (i2 < 10) {
            int nodeNr = i2++;
            PlacementFrame.PlacementNode n2 = (PlacementFrame.PlacementNode)this.nodesToPlace.get(nodeNr);
            this.blocks.add(new Block(n2.getPlacementX(), n2.getPlacementY(), n2.getWidth(), n2.getHeight(), n2.getPlacementOrientation(), nodeNr));
        }
        Collections.sort(this.blocks);
    }

    @Override
    public void setProgress(double p) {
        this.p = p;
    }

    @Override
    public void writeToPlacement(List<PlacementFrame.PlacementNode> nodesToPlace) {
        for (Block b2 : this.blocks) {
            nodesToPlace.get(b2.getNr()).setPlacement(b2.getX(), b2.getY());
            nodesToPlace.get(b2.getNr()).setOrientation(b2.getOrientation());
        }
    }

    @Override
    public int compareTo(DeltaIndividual other) {
        if (this.getBadness() < other.getBadness()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void copyFrom(DeltaIndividual other) {
        int i2;
        if (this == other) {
            return;
        }
        this.blocks.clear();
        for (Block b2 : other.blocks) {
            this.blocks.add(new Block(b2));
        }
        this.netLengths = new double[this.ref.netLengths.length];
        for (i2 = 0; i2 < this.ref.netLengths.length; ++i2) {
            this.netLengths[i2] = this.ref.netLengths[i2];
        }
        this.overlaps = new double[this.ref.overlaps.length];
        for (i2 = 0; i2 < this.ref.overlaps.length; ++i2) {
            this.overlaps[i2] = this.ref.overlaps[i2];
        }
        this.setBadness(other.badnessComponents);
    }

    @Override
    public void deriveFrom(DeltaIndividual mom, DeltaIndividual dad, Random rand) {
        if (this == mom || this == dad) {
            return;
        }
        this.blocks.clear();
        for (Block b2 : mom.blocks) {
            this.blocks.add(new Block(b2));
        }
        for (Block b2 : dad.blocks) {
            this.blocks.add(new Block(b2));
        }
        Collections.sort(this.blocks);
        int pos = 0;
        int usedNr = -1;
        int prevNr = -1;
        while (pos < this.blocks.size()) {
            if (rand.nextDouble() > 0.5 && this.blocks.get(pos).getNr() != prevNr || this.blocks.get(pos).getNr() == usedNr) {
                prevNr = this.blocks.get(pos).getNr();
                this.blocks.remove(pos);
                continue;
            }
            prevNr = this.blocks.get(pos).getNr();
            usedNr = this.blocks.get(pos).getNr();
            ++pos;
        }
        this.mutate(rand);
        this.evaluate();
    }

    @Override
    public double distance(DeltaIndividual other) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.netLengths.length; ++i2) {
            d2 += Math.abs(this.netLengths[i2] - other.netLengths[i2]);
        }
        return d2;
    }

    @Override
    public double distance() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.netLengths.length; ++i2) {
            d2 += Math.abs(this.netLengths[i2] - this.ref.netLengths[i2]);
        }
        return d2;
    }

    public void swapBlocks(Random rand) {
        int a2 = rand.nextInt(this.nodesToPlace.size());
        int b2 = rand.nextInt(this.nodesToPlace.size());
        Block one = this.insertBlock(rand, a2, false);
        Block two = this.insertBlock(rand, b2, false);
        double ax = one.getX();
        double ay = one.getY();
        one.setPos(two.getX(), two.getY());
        two.setPos(ax, ay);
    }

    public Block insertBlock(Random rand, int nodeNr, boolean mutation) {
        PlacementFrame.PlacementNode n2 = (PlacementFrame.PlacementNode)this.nodesToPlace.get(nodeNr);
        double xmut = 0.0;
        double ymut = 0.0;
        if (mutation) {
            xmut = this.ref.avgW * rand.nextGaussian();
            ymut = this.ref.avgW * rand.nextGaussian();
        }
        Block b2 = new Block(n2.getPlacementX() + xmut, n2.getPlacementY() + ymut, n2.getWidth(), n2.getHeight(), n2.getPlacementOrientation(), nodeNr);
        this.blocks.add(b2);
        Collections.sort(this.blocks);
        for (int i2 = 1; i2 < this.blocks.size(); ++i2) {
            if (this.blocks.get(i2).getNr() != this.blocks.get(i2 - 1).getNr()) continue;
            if (rand.nextDouble() > 0.5) {
                b2 = this.blocks.get(i2 - 1);
                this.blocks.remove(i2);
                continue;
            }
            b2 = this.blocks.get(i2);
            this.blocks.remove(i2 - 1);
        }
        return b2;
    }

    @Override
    public void mutate(Random rand) {
        int i2;
        if (this.blocks.size() < 50 && (this.blocks.size() == 0 || rand.nextDouble() > 0.5)) {
            int nodeNr = rand.nextInt(this.nodesToPlace.size());
            this.insertBlock(rand, nodeNr, true);
        }
        if (rand.nextDouble() > 0.5 && this.blocks.size() > 1) {
            this.blocks.remove(rand.nextInt(this.blocks.size()));
        }
        int disturbedPositions = Math.abs((int)(rand.nextGaussian() * 3.0));
        int disturbedOrientations = Math.abs((int)(rand.nextGaussian() * 1.0));
        int swaps = Math.abs((int)(rand.nextGaussian() * 2.0 * (1.0 - this.p)));
        for (i2 = 0; i2 < disturbedPositions; ++i2) {
            this.blocks.get(rand.nextInt(this.blocks.size())).disturb(this.ref.avgW, rand);
        }
        for (i2 = 0; i2 < disturbedOrientations; ++i2) {
            this.blocks.get(rand.nextInt(this.blocks.size())).disturbOrientation(rand);
        }
        for (i2 = 0; i2 < swaps; ++i2) {
            this.swapBlocks(rand);
        }
    }

    @Override
    public double calculateOverlap() {
        double overlap = this.ref.badnessComponents[1];
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            this.overlaps[i2] = this.ref.overlaps[i2];
        }
        Block otherOrig = new Block();
        Block orig = new Block();
        for (int n2 = 0; n2 < this.blocks.size(); ++n2) {
            Block b2 = this.blocks.get(n2);
            overlap += this.ref.grid.collide(b2, this.blocks, this.nodesToPlace, this.overlaps);
            orig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr()));
            for (int i3 = 0; i3 < n2; ++i3) {
                Block otherBlock = this.blocks.get(i3);
                otherOrig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(otherBlock.getNr()));
                overlap -= orig.intersectionArea(otherOrig);
                overlap += b2.intersectionArea(otherBlock);
                int n3 = b2.getNr();
                this.overlaps[n3] = this.overlaps[n3] - orig.intersectionArea(otherOrig);
                int n4 = b2.getNr();
                this.overlaps[n4] = this.overlaps[n4] + b2.intersectionArea(otherBlock);
            }
        }
        return overlap;
    }

    public double old_calculateOverlap() {
        double overlap = this.ref.badnessComponents[1];
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            this.overlaps[i2] = this.ref.overlaps[i2];
        }
        Block other = new Block();
        Block orig = new Block();
        Iterator<Block> ib = this.blocks.iterator();
        Block deltaBlock = ib.next();
        for (int n2 = 0; n2 < this.blocks.size(); ++n2) {
            Block b2 = this.blocks.get(n2);
            orig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr()));
            ib = this.blocks.iterator();
            deltaBlock = ib.next();
            for (int i3 = 0; i3 < this.nodesToPlace.size(); ++i3) {
                if (i3 > deltaBlock.getNr() && ib.hasNext()) {
                    deltaBlock = ib.next();
                }
                if (i3 == b2.getNr()) continue;
                if (i3 < b2.getNr() && deltaBlock.getNr() == i3) {
                    other.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(i3));
                    overlap -= orig.intersectionArea(other);
                    int n3 = b2.getNr();
                    this.overlaps[n3] = this.overlaps[n3] - orig.intersectionArea(other);
                    int n4 = b2.getNr();
                    this.overlaps[n4] = this.overlaps[n4] + b2.intersectionArea(deltaBlock);
                    overlap += b2.intersectionArea(deltaBlock);
                    continue;
                }
                if (deltaBlock.getNr() == i3) continue;
                other.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(i3));
                overlap -= orig.intersectionArea(other);
                int n5 = i3;
                this.overlaps[n5] = this.overlaps[n5] - orig.intersectionArea(other);
                int n6 = i3;
                this.overlaps[n6] = this.overlaps[n6] + b2.intersectionArea(other);
                overlap += b2.intersectionArea(other);
            }
        }
        return overlap;
    }

    @Override
    public double getBoundingBoxArea() {
        Iterator it = this.nodesToPlace.iterator();
        Iterator<Block> ib = this.blocks.iterator();
        Block deltaBlock = ib.next();
        Block b2 = new Block();
        PlacementFrame.PlacementNode n2 = (PlacementFrame.PlacementNode)it.next();
        b2.setPos(n2.getPlacementX(), n2.getPlacementY());
        b2.setOrientation(n2.getPlacementOrientation());
        double left = b2.getLeft();
        double top = b2.getTop();
        double right = b2.getRight();
        double bottom = b2.getBottom();
        for (int i2 = 1; i2 < this.nodesToPlace.size(); ++i2) {
            n2 = (PlacementFrame.PlacementNode)it.next();
            b2.setPos(n2.getPlacementX(), n2.getPlacementY());
            b2.setOrientation(n2.getPlacementOrientation());
            if (i2 > deltaBlock.getNr() && ib.hasNext()) {
                deltaBlock = ib.next();
            }
            if (deltaBlock.getNr() == i2) {
                if (deltaBlock.getLeft() < left) {
                    left = deltaBlock.getLeft();
                }
                if (deltaBlock.getTop() > top) {
                    top = deltaBlock.getTop();
                }
                if (deltaBlock.getRight() > right) {
                    right = deltaBlock.getRight();
                }
                if (!(deltaBlock.getBottom() < bottom)) continue;
                bottom = deltaBlock.getBottom();
                continue;
            }
            if (b2.getLeft() < left) {
                left = b2.getLeft();
            }
            if (b2.getTop() > top) {
                top = b2.getTop();
            }
            if (b2.getRight() > right) {
                right = b2.getRight();
            }
            if (!(b2.getBottom() < bottom)) continue;
            bottom = b2.getBottom();
        }
        return (top - bottom) * (right - left);
    }

    @Override
    public double getSemiperimeterLength() {
        Iterator it = this.nodesToPlace.iterator();
        Iterator<Block> ib = this.blocks.iterator();
        Block deltaBlock = ib.next();
        Block b2 = new Block();
        PlacementFrame.PlacementNode n2 = (PlacementFrame.PlacementNode)it.next();
        b2.valuesFrom(n2);
        double left = b2.getLeft();
        double top = b2.getTop();
        double right = b2.getRight();
        double bottom = b2.getBottom();
        if (deltaBlock.getNr() == 0) {
            if (deltaBlock.getLeft() < left) {
                left = deltaBlock.getLeft();
            }
            if (deltaBlock.getTop() > top) {
                top = deltaBlock.getTop();
            }
            if (deltaBlock.getRight() > right) {
                right = deltaBlock.getRight();
            }
            if (deltaBlock.getBottom() < bottom) {
                bottom = deltaBlock.getBottom();
            }
        } else {
            if (b2.getLeft() < left) {
                left = b2.getLeft();
            }
            if (b2.getTop() > top) {
                top = b2.getTop();
            }
            if (b2.getRight() > right) {
                right = b2.getRight();
            }
            if (b2.getBottom() < bottom) {
                bottom = b2.getBottom();
            }
        }
        for (int i2 = 1; i2 < this.nodesToPlace.size(); ++i2) {
            n2 = (PlacementFrame.PlacementNode)it.next();
            b2.valuesFrom(n2);
            if (i2 > deltaBlock.getNr() && ib.hasNext()) {
                deltaBlock = ib.next();
            }
            if (deltaBlock.getNr() == i2) {
                if (deltaBlock.getLeft() < left) {
                    left = deltaBlock.getLeft();
                }
                if (deltaBlock.getTop() > top) {
                    top = deltaBlock.getTop();
                }
                if (deltaBlock.getRight() > right) {
                    right = deltaBlock.getRight();
                }
                if (!(deltaBlock.getBottom() < bottom)) continue;
                bottom = deltaBlock.getBottom();
                continue;
            }
            if (b2.getLeft() < left) {
                left = b2.getLeft();
            }
            if (b2.getTop() > top) {
                top = b2.getTop();
            }
            if (b2.getRight() > right) {
                right = b2.getRight();
            }
            if (!(b2.getBottom() < bottom)) continue;
            bottom = b2.getBottom();
        }
        return top - bottom + (right - left);
    }

    @Override
    public double getNetLength() {
        return this.badnessComponents[0];
    }

    @Override
    public void evaluate() {
        int i2;
        this.netLengths = new double[this.ref.netLengths.length];
        for (i2 = 0; i2 < this.ref.netLengths.length; ++i2) {
            this.netLengths[i2] = this.ref.netLengths[i2];
        }
        this.overlaps = new double[this.ref.overlaps.length];
        for (i2 = 0; i2 < this.ref.overlaps.length; ++i2) {
            this.overlaps[i2] = this.ref.overlaps[i2];
        }
        this.badnessComponents[0] = DeltaBBMetric.compute(this.blocks, this.netLengths);
        this.badnessComponents[1] = this.calculateOverlap();
        this.badnessComponents[2] = this.calculateSpread();
        this.hashes[0] = this.getXHash();
        this.hashes[1] = this.getYHash();
        this.hashes[2] = this.getRotHash();
    }

    @Override
    public double getSize() {
        return this.blocks.size();
    }

    @Override
    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * (1.0 + 300.0 * this.p * this.p);
        return badness += 1.0E-5 * this.badnessComponents[2];
    }

    public double calculateSpread() {
        this.spread = this.ref.spread;
        Block refBlock = new Block();
        for (Block b2 : this.blocks) {
            refBlock.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr()));
            this.spread -= Math.sqrt(refBlock.getX() * refBlock.getX() + refBlock.getY() * refBlock.getY()) * refBlock.getWidth() * refBlock.getHeight();
            this.spread += Math.sqrt(b2.getX() * b2.getX() + b2.getY() * b2.getY()) * b2.getWidth() * b2.getHeight();
        }
        return this.spread;
    }

    @Override
    public void setBadness(double[] otherComponents) {
        for (int i2 = 0; i2 < this.badnessComponents.length; ++i2) {
            this.badnessComponents[i2] = otherComponents[i2];
        }
    }

    @Override
    public double getXHash() {
        double r = 0.0;
        for (Block b2 : this.blocks) {
            r += b2.getX() - ((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr())).getPlacementX();
        }
        r = Math.abs(r);
        return (Math.sin((r /= 5000.0) * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getYHash() {
        double r = 0.0;
        for (Block b2 : this.blocks) {
            r += b2.getY() - ((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr())).getPlacementY();
        }
        r = Math.abs(r);
        return (Math.sin((r /= 5000.0) * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getRotHash() {
        double r = 0.0;
        for (Block b2 : this.blocks) {
            Orientation o2 = b2.getOrientation();
            if (o2 == ((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr())).getPlacementOrientation()) {
                r += 0.0;
                continue;
            }
            if (o2 == Orientation.IDENT) {
                r += 0.1;
                continue;
            }
            if (o2 == Orientation.R) {
                r -= 0.2;
                continue;
            }
            if (o2 == Orientation.RR) {
                r += 0.3;
                continue;
            }
            if (o2 == Orientation.RRR) {
                r -= 0.4;
                continue;
            }
            if (o2 == Orientation.X) {
                r += 0.5;
                continue;
            }
            if (o2 == Orientation.XR) {
                r -= 0.6;
                continue;
            }
            if (o2 == Orientation.XRR) {
                r += 0.7;
                continue;
            }
            if (o2 == Orientation.XRRR) {
                r -= 0.8;
                continue;
            }
            if (o2 == Orientation.Y) {
                r += 0.9;
                continue;
            }
            if (o2 == Orientation.YR) {
                r -= 1.0;
                continue;
            }
            if (o2 == Orientation.YRR) {
                r += 1.1;
                continue;
            }
            if (o2 == Orientation.YRRR) {
                r -= 1.2;
                continue;
            }
            if (o2 == Orientation.XY) {
                r += 1.3;
                continue;
            }
            if (o2 == Orientation.XYR) {
                r -= 1.4;
                continue;
            }
            if (o2 == Orientation.XYRR) {
                r += 1.5;
                continue;
            }
            if (o2 != Orientation.XYRRR) continue;
            r -= 1.6;
        }
        return (Math.sin((r /= 50.0) * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getHash() {
        double b2;
        for (b2 = this.getBadness(); b2 > 2.0; b2 /= 10.0) {
        }
        b2 = (Math.sin(b2 * Math.PI) + 1.0) / 2.0;
        double h2 = this.hashes[0] + this.hashes[1] + this.hashes[2] + b2;
        return h2;
    }

    @Override
    public double[] getHashes() {
        return this.hashes;
    }
}

