/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic2.Block;
import com.sun.electric.tool.placement.genetic2.Individual;
import com.sun.electric.tool.placement.genetic2.Reference;
import com.sun.electric.tool.placement.genetic2.metrics.BBMetric;
import com.sun.electric.util.math.Orientation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassicIndividual
extends Individual<ClassicIndividual> {
    private Block[] blocks;
    private double[] badnessComponents = new double[3];
    private double[] hashes;
    Reference ref;
    double[] netLengths;
    private BBMetric m_bb;
    public ReadWriteLock rwLock;
    double p;

    ClassicIndividual(Reference ref, Random rand) {
        super(ref);
        this.ref = ref;
        this.rwLock = new ReentrantReadWriteLock();
        this.m_bb = new BBMetric(this.nodesToPlace, this.allNetworks);
        this.blocks = new Block[this.nodesToPlace.size()];
        this.hashes = new double[3];
        for (int i2 = 0; i2 < this.nodesToPlace.size(); ++i2) {
            this.blocks[i2] = new Block();
            this.blocks[i2].valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(i2));
        }
        this.evaluate();
    }

    @Override
    public void setProgress(double p) {
        this.p = p;
    }

    @Override
    public void reboot(Random rand) {
    }

    @Override
    public void writeToPlacement(List<PlacementFrame.PlacementNode> nodesToPlace) {
        for (int i2 = 0; i2 < nodesToPlace.size(); ++i2) {
            Block b2 = this.blocks[i2];
            PlacementFrame.PlacementNode n2 = nodesToPlace.get(i2);
            n2.setPlacement(b2.getX(), b2.getY());
            n2.setOrientation(b2.getOrientation());
        }
    }

    @Override
    public int compareTo(ClassicIndividual other) {
        if (this.getBadness() < other.getBadness()) {
            return -1;
        }
        return 1;
    }

    @Override
    public void copyFrom(ClassicIndividual other) {
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            this.blocks[i2].setPos(other.getBlockAt(i2).getX(), other.getBlockAt(i2).getY());
            this.blocks[i2].setOrientation(other.getBlockAt(i2).getOrientation());
        }
        this.setBadness(other.badnessComponents);
    }

    @Override
    public void deriveFrom(ClassicIndividual mom, ClassicIndividual dad, Random rand) {
        if (rand.nextDouble() > 0.5) {
            ClassicIndividual t = mom;
            mom = dad;
            dad = t;
        }
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            if (rand.nextDouble() > 0.5) {
                this.blocks[i2].setPos(mom.getBlockAt(i2).getX(), mom.getBlockAt(i2).getY());
                this.blocks[i2].setOrientation(mom.getBlockAt(i2).getOrientation());
                continue;
            }
            this.blocks[i2].setPos(dad.getBlockAt(i2).getX(), dad.getBlockAt(i2).getY());
            this.blocks[i2].setOrientation(dad.getBlockAt(i2).getOrientation());
        }
        this.mutate(rand);
        this.evaluate();
    }

    @Override
    public double distance(ClassicIndividual other) {
        double distance = 0.0;
        double[] h2 = other.getHashes();
        return distance += (this.hashes[0] - h2[0]) * (this.hashes[0] - h2[0]) + (this.hashes[1] - h2[1]) * (this.hashes[1] - h2[1]) + (this.hashes[2] - h2[2]) * (this.hashes[2] - h2[2]);
    }

    public Block getBlockAt(int i2) {
        return this.blocks[i2];
    }

    public void swapBlocks(int a2, int b2) {
        double ax = this.blocks[a2].getX();
        double ay = this.blocks[a2].getY();
        this.blocks[a2].setPos(this.blocks[b2].getX(), this.blocks[b2].getY());
        this.blocks[b2].setPos(ax, ay);
    }

    @Override
    public void mutate(Random rand) {
        int i2;
        int disturbedPositions = Math.abs((int)(rand.nextGaussian() * 3.0));
        int disturbedOrientations = Math.abs((int)(rand.nextGaussian() * 1.0));
        int swaps = Math.abs((int)(rand.nextGaussian() * 1.0));
        for (i2 = 0; i2 < disturbedPositions; ++i2) {
            this.blocks[rand.nextInt(this.blocks.length)].disturb(this.ref.avgW, rand);
        }
        for (i2 = 0; i2 < disturbedOrientations; ++i2) {
            this.blocks[rand.nextInt(this.blocks.length)].disturbOrientation(rand);
        }
        for (i2 = 0; i2 < swaps; ++i2) {
            int pos1 = rand.nextInt(this.blocks.length);
            int pos2 = rand.nextInt(this.blocks.length);
            this.swapBlocks(pos1, pos2);
        }
    }

    public void mutateAndEvaluate(ClassicIndividual original, Random rand) {
        int pos;
        int i2;
        HashSet<Integer> changedBlocks = new HashSet<Integer>();
        int disturbedPositions = Math.abs((int)(rand.nextGaussian() * 3.0));
        int disturbedOrientations = Math.abs((int)(rand.nextGaussian() * 1.0));
        int swaps = Math.abs((int)(rand.nextGaussian() * 1.0));
        for (i2 = 0; i2 < disturbedPositions; ++i2) {
            pos = rand.nextInt(this.blocks.length);
            this.blocks[rand.nextInt(this.blocks.length)].disturb(this.ref.avgW, rand);
            changedBlocks.add(pos);
        }
        for (i2 = 0; i2 < disturbedOrientations; ++i2) {
            pos = rand.nextInt(this.blocks.length);
            this.blocks[rand.nextInt(this.blocks.length)].disturbOrientation(rand);
            changedBlocks.add(pos);
        }
        for (i2 = 0; i2 < swaps; ++i2) {
            int pos1 = rand.nextInt(this.blocks.length);
            int pos2 = rand.nextInt(this.blocks.length);
            this.swapBlocks(pos1, pos2);
            changedBlocks.add(pos1);
            changedBlocks.add(pos2);
        }
        if (changedBlocks.size() == 0) {
            return;
        }
        this.badnessComponents[0] = this.m_bb.compute(this.blocks);
        this.badnessComponents[1] = this.calculateChangedOverlap(original, changedBlocks);
        this.badnessComponents[2] = this.getSemiperimeterLength();
    }

    public double calculateChangedOverlap(ClassicIndividual original, HashSet<Integer> changedBlocks) {
        double overlap = original.badnessComponents[1];
        Block otherOrig = new Block();
        Block orig = new Block();
        Iterator<Integer> it = changedBlocks.iterator();
        for (int n2 = 0; n2 < changedBlocks.size(); ++n2) {
            Block b2 = this.blocks[it.next()];
            orig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(b2.getNr()));
            for (int i2 = 0; i2 < n2; ++i2) {
                Block otherBlock = this.blocks[i2];
                otherOrig.valuesFrom((PlacementFrame.PlacementNode)this.nodesToPlace.get(otherBlock.getNr()));
                overlap -= orig.intersectionArea(otherOrig);
                overlap += b2.intersectionArea(otherBlock);
            }
        }
        return overlap;
    }

    @Override
    public double calculateOverlap() {
        double overlap = 0.0;
        for (int i2 = 0; i2 < this.blocks.length; ++i2) {
            for (int j2 = 0; j2 < i2; ++j2) {
                overlap += this.blocks[i2].intersectionArea(this.blocks[j2]);
            }
        }
        return overlap;
    }

    @Override
    public double getBoundingBoxArea() {
        double left = this.blocks[0].getLeft();
        double top = this.blocks[0].getTop();
        double right = this.blocks[0].getRight();
        double bottom = this.blocks[0].getBottom();
        for (Block b2 : this.blocks) {
            if (b2.getLeft() < left) {
                left = b2.getLeft();
            }
            if (b2.getTop() > top) {
                top = b2.getTop();
            }
            if (b2.getRight() > right) {
                right = b2.getRight();
            }
            if (!(b2.getBottom() < bottom)) continue;
            bottom = b2.getBottom();
        }
        return (top - bottom) * (right - left);
    }

    @Override
    public double getSemiperimeterLength() {
        double left = this.blocks[0].getLeft();
        double top = this.blocks[0].getTop();
        double right = this.blocks[0].getRight();
        double bottom = this.blocks[0].getBottom();
        for (Block b2 : this.blocks) {
            if (b2.getLeft() < left) {
                left = b2.getLeft();
            }
            if (b2.getTop() > top) {
                top = b2.getTop();
            }
            if (b2.getRight() > right) {
                right = b2.getRight();
            }
            if (!(b2.getBottom() < bottom)) continue;
            bottom = b2.getBottom();
        }
        return top - bottom + (right - left);
    }

    @Override
    public double getNetLength() {
        return this.badnessComponents[0];
    }

    @Override
    public void evaluate() {
        this.badnessComponents[0] = this.m_bb.compute(this.blocks);
        this.badnessComponents[1] = this.calculateOverlap();
        this.badnessComponents[2] = this.getSemiperimeterLength();
    }

    public double sqr(double a2) {
        return a2 * a2;
    }

    @Override
    public double getBadness() {
        double badness = 0.0;
        badness += this.badnessComponents[0];
        badness += this.badnessComponents[1] * 0.5;
        return badness += this.badnessComponents[2] * 1.0;
    }

    @Override
    public void setBadness(double[] otherComponents) {
        for (int i2 = 0; i2 < this.badnessComponents.length; ++i2) {
            this.badnessComponents[i2] = otherComponents[i2];
        }
    }

    @Override
    public double getXHash() {
        double r = 0.0;
        for (Block b2 : this.blocks) {
            r += b2.getX();
        }
        for (r = Math.abs(r); r > 2.0; r /= 10.0) {
        }
        return (Math.sin(r * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getYHash() {
        double r = 0.0;
        for (Block b2 : this.blocks) {
            r += b2.getY();
        }
        for (r = Math.abs(r); r > 2.0; r /= 10.0) {
        }
        return (Math.sin(r * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double getRotHash() {
        double r = 0.0;
        for (Block b2 : this.blocks) {
            Orientation o2 = b2.getOrientation();
            if (o2 == Orientation.IDENT) {
                r += 0.1;
                continue;
            }
            if (o2 == Orientation.R) {
                r += 0.2;
                continue;
            }
            if (o2 == Orientation.RR) {
                r += 0.3;
                continue;
            }
            if (o2 == Orientation.RRR) {
                r += 0.4;
                continue;
            }
            if (o2 == Orientation.X) {
                r += 0.5;
                continue;
            }
            if (o2 == Orientation.XR) {
                r += 0.6;
                continue;
            }
            if (o2 == Orientation.XRR) {
                r += 0.7;
                continue;
            }
            if (o2 == Orientation.XRRR) {
                r += 0.8;
                continue;
            }
            if (o2 == Orientation.Y) {
                r += 0.9;
                continue;
            }
            if (o2 == Orientation.YR) {
                r += 1.0;
                continue;
            }
            if (o2 == Orientation.YRR) {
                r += 1.1;
                continue;
            }
            if (o2 == Orientation.YRRR) {
                r += 1.2;
                continue;
            }
            if (o2 == Orientation.XY) {
                r += 1.3;
                continue;
            }
            if (o2 == Orientation.XYR) {
                r += 1.4;
                continue;
            }
            if (o2 == Orientation.XYRR) {
                r += 1.5;
                continue;
            }
            if (o2 != Orientation.XYRRR) continue;
            r += 1.6;
        }
        while (r > 2.0) {
            r /= 10.0;
        }
        return (Math.sin(r * Math.PI) + 1.0) / 2.0;
    }

    @Override
    public double[] getHashes() {
        return this.hashes;
    }
}

