/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.util.math.Orientation;
import java.util.Random;

public class Block
implements Comparable<Block> {
    Orientation o;
    private double width;
    private double height;
    private double halfWidth;
    private double halfHeight;
    private double xPos;
    private double yPos;
    int number = -1;

    public Block() {
    }

    public Block(Block b2) {
        this.xPos = b2.xPos;
        this.yPos = b2.yPos;
        this.width = b2.width;
        this.height = b2.height;
        this.halfWidth = b2.halfWidth;
        this.halfHeight = b2.halfHeight;
        this.o = b2.o;
        this.number = b2.number;
    }

    public Block(double x, double y, double w, double h2) {
        this.width = w;
        this.halfWidth = this.width / 2.0;
        this.height = h2;
        this.halfHeight = this.height / 2.0;
        this.xPos = x;
        this.yPos = y;
        this.o = Orientation.IDENT;
    }

    public Block(double x, double y, double w, double h2, Orientation o2, int number) {
        this.width = w;
        this.halfWidth = this.width / 2.0;
        this.height = h2;
        this.halfHeight = this.height / 2.0;
        this.xPos = x;
        this.yPos = y;
        this.o = o2;
        this.number = number;
    }

    public void valuesFrom(PlacementFrame.PlacementNode n2) {
        this.xPos = n2.getPlacementX();
        this.yPos = n2.getPlacementY();
        this.width = n2.getWidth();
        this.halfWidth = this.width / 2.0;
        this.height = n2.getHeight();
        this.halfHeight = this.height / 2.0;
        this.o = n2.getPlacementOrientation();
    }

    @Override
    public int compareTo(Block other) {
        if (this.getNr() < other.getNr()) {
            return -1;
        }
        if (this.getNr() > other.getNr()) {
            return 1;
        }
        return 0;
    }

    public int getNr() {
        return this.number;
    }

    public Orientation getOrientation() {
        return this.o;
    }

    public void setOrientation(Orientation o2) {
        this.o = o2;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getX() {
        return this.xPos;
    }

    public double getY() {
        return this.yPos;
    }

    public double getLeft() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.xPos - this.halfHeight;
        }
        return this.xPos - this.halfWidth;
    }

    public double getTop() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.yPos + this.halfWidth;
        }
        return this.yPos + this.halfHeight;
    }

    public double getRight() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.xPos + this.halfHeight;
        }
        return this.xPos + this.halfWidth;
    }

    public double getBottom() {
        if (this.o == Orientation.R || this.o == Orientation.RRR || this.o == Orientation.XR || this.o == Orientation.XRRR || this.o == Orientation.YR || this.o == Orientation.YRRR || this.o == Orientation.XYR || this.o == Orientation.XYRRR) {
            return this.yPos - this.halfWidth;
        }
        return this.yPos - this.halfHeight;
    }

    public boolean intersects(Block other) {
        return other.getLeft() < this.getRight() && other.getRight() > this.getLeft() && other.getTop() > this.getBottom() && other.getBottom() < this.getTop();
    }

    public double intersectionArea(Block other) {
        if (this.intersects(other)) {
            double left = Math.max(this.getLeft(), other.getLeft());
            double top = Math.min(this.getTop(), other.getTop());
            double right = Math.min(this.getRight(), other.getRight());
            double bottom = Math.max(this.getBottom(), other.getBottom());
            return (top - bottom) * (right - left);
        }
        return 0.0;
    }

    public void setPos(double x, double y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void disturb(double avgW, Random rand) {
        this.xPos += 1.0 * avgW * rand.nextGaussian();
        this.yPos += 1.0 * avgW * rand.nextGaussian();
    }

    public void disturbToCenter(double avgW, Random rand) {
        this.xPos = this.xPos *= rand.nextDouble();
        this.yPos = this.yPos *= rand.nextDouble();
    }

    public void disturbOrientation(Random rand) {
        switch (rand.nextInt(16)) {
            case 0: {
                this.o = Orientation.IDENT;
                break;
            }
            case 1: {
                this.o = Orientation.R;
                break;
            }
            case 2: {
                this.o = Orientation.RR;
                break;
            }
            case 3: {
                this.o = Orientation.RRR;
                break;
            }
            case 4: {
                this.o = Orientation.X;
                break;
            }
            case 5: {
                this.o = Orientation.XR;
                break;
            }
            case 6: {
                this.o = Orientation.XRR;
                break;
            }
            case 7: {
                this.o = Orientation.XRRR;
                break;
            }
            case 8: {
                this.o = Orientation.Y;
                break;
            }
            case 9: {
                this.o = Orientation.YR;
                break;
            }
            case 10: {
                this.o = Orientation.YRR;
                break;
            }
            case 11: {
                this.o = Orientation.YRRR;
                break;
            }
            case 12: {
                this.o = Orientation.XY;
                break;
            }
            case 13: {
                this.o = Orientation.XYR;
                break;
            }
            case 14: {
                this.o = Orientation.XYRR;
                break;
            }
            case 15: {
                this.o = Orientation.XYRRR;
            }
        }
    }
}

