/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.Metric;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import com.sun.electric.tool.placement.genetic1.g1.PlacementNodeProxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class MetricBoundingBox3
implements Metric {
    static HashMap<int[], Integer> port2ProxyIndexMap;
    static int[][][] net2PlacementPortsXYOffset;
    static Level LOG_LEVEL;
    public static double cutOffThreshhold;
    public static int nodeThreshhold;

    public MetricBoundingBox3(List<PlacementFrame.PlacementNetwork> networks, PlacementNodeProxy[] nodeProxies) {
        if (port2ProxyIndexMap == null) {
            this.generatePortToProxyIndexMap(networks, nodeProxies);
        }
    }

    void generatePortToProxyIndexMap(List<PlacementFrame.PlacementNetwork> networks, PlacementNodeProxy[] nodeProxies) {
        GeneticPlacement.logger.debug("start precalculating portToProxyIndexMap");
        int allocationCounter = 0;
        int cutOffBarrier = (int)(cutOffThreshhold * (double)nodeProxies.length);
        if (nodeProxies.length > nodeThreshhold) {
            for (PlacementFrame.PlacementNetwork net : networks) {
                if (net.getPortsOnNet().size() > cutOffBarrier) continue;
                ++allocationCounter;
            }
        } else {
            allocationCounter = networks.size();
        }
        net2PlacementPortsXYOffset = new int[allocationCounter][][];
        port2ProxyIndexMap = new HashMap(networks.size());
        int netIndex = 0;
        for (int i2 = 0; i2 < networks.size(); ++i2) {
            PlacementFrame.PlacementNetwork curNet = networks.get(i2);
            if (nodeProxies.length > nodeThreshhold && curNet.getPortsOnNet().size() > cutOffBarrier) continue;
            MetricBoundingBox3.net2PlacementPortsXYOffset[netIndex] = new int[curNet.getPortsOnNet().size()][];
            block2: for (int p = 0; p < curNet.getPortsOnNet().size(); ++p) {
                PlacementFrame.PlacementPort curPort = curNet.getPortsOnNet().get(p);
                MetricBoundingBox3.net2PlacementPortsXYOffset[netIndex][p] = new int[2];
                MetricBoundingBox3.net2PlacementPortsXYOffset[netIndex][p][0] = (short)curPort.getOffX();
                MetricBoundingBox3.net2PlacementPortsXYOffset[netIndex][p][1] = (short)curPort.getOffY();
                List<PlacementNodeProxy> nodeProxyList = Arrays.asList(nodeProxies);
                if (port2ProxyIndexMap.containsKey(net2PlacementPortsXYOffset[netIndex][p])) continue;
                for (PlacementNodeProxy proxy : nodeProxies) {
                    if (proxy.node != curPort.getPlacementNode()) continue;
                    port2ProxyIndexMap.put(net2PlacementPortsXYOffset[netIndex][p], nodeProxyList.indexOf(proxy));
                    continue block2;
                }
            }
            ++netIndex;
        }
        GeneticPlacement.logger.debug("done precalculating portToProxyIndexMap");
    }

    @Override
    public void evaluate(List<Chromosome> population) {
        for (Chromosome c2 : population) {
            if (!c2.altered) continue;
            c2.fitness = 0.0;
        }
        for (Object net : (Iterator<Chromosome>)net2PlacementPortsXYOffset) {
            for (Chromosome c3 : population) {
                if (!c3.altered) continue;
                c3.fitness = c3.fitness + this.compute((int[][])net, c3);
            }
        }
        for (Chromosome c4 : population) {
            c4.altered = false;
        }
    }

    @Override
    public double evaluate(Chromosome c2) {
        double sum = 0.0;
        for (int[][] net : net2PlacementPortsXYOffset) {
            if (net.length == 1) continue;
            sum += this.compute(net, c2);
        }
        assert (sum != 0.0);
        return sum;
    }

    private int getPortXOffset(int[] port, short geneRotation) {
        switch (geneRotation) {
            case 0: {
                return port[0];
            }
            case 900: {
                return -port[1];
            }
            case 1800: {
                return -port[0];
            }
            case 2700: {
                return port[1];
            }
        }
        System.err.println(this.getClass().getName() + " unsupported rotation angle: " + geneRotation);
        return -1;
    }

    public int getPortYOffset(int[] port, short geneRotation) {
        switch (geneRotation) {
            case 0: {
                return port[1];
            }
            case 900: {
                return port[0];
            }
            case 1800: {
                return -port[1];
            }
            case 2700: {
                return -port[0];
            }
        }
        System.err.println(this.getClass().getName() + " unsupported rotation angle: " + geneRotation);
        return -1;
    }

    private double compute(int[][] net, Chromosome c2) {
        double bottom;
        double right;
        int indexOfProxy = port2ProxyIndexMap.get(net[0]);
        short rotation = 0;
        int addendX = 0;
        int addendY = 0;
        if (indexOfProxy < c2.GeneRotation.length) {
            rotation = c2.GeneRotation[indexOfProxy];
            addendX = c2.GeneXPos[indexOfProxy];
            addendY = c2.GeneYPos[indexOfProxy];
        }
        double portX = this.getPortXOffset(net[0], rotation) + addendX;
        double portY = this.getPortYOffset(net[0], rotation) + addendY;
        double left = right = portX;
        double top = bottom = portY;
        for (int i2 = 1; i2 < net.length; ++i2) {
            indexOfProxy = port2ProxyIndexMap.get(net[i2]);
            short rotation2 = 0;
            int addendX2 = 0;
            int addendY2 = 0;
            if (indexOfProxy < c2.GeneRotation.length) {
                rotation2 = c2.GeneRotation[indexOfProxy];
                addendX2 = c2.GeneXPos[indexOfProxy];
                addendY2 = c2.GeneYPos[indexOfProxy];
            }
            portX = this.getPortXOffset(net[i2], rotation2) + addendX2;
            portY = this.getPortYOffset(net[i2], rotation2) + addendY2;
            if (portX < left) {
                left = portX;
            } else if (portX > right) {
                right = portX;
            }
            if (portY > top) {
                top = portY;
                continue;
            }
            if (!(portY < bottom)) continue;
            bottom = portY;
        }
        return right - left + (top - bottom);
    }

    static {
        LOG_LEVEL = Level.FINER;
        cutOffThreshhold = 0.85;
        nodeThreshhold = 100;
    }
}

