/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1.g1;

import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.Crossover;
import com.sun.electric.tool.placement.genetic1.Population;
import com.sun.electric.tool.placement.genetic1.g1.GenePlacementLeftRightAlignedDrop;
import com.sun.electric.tool.placement.genetic1.g1.GeneticPlacement;
import java.util.ArrayList;
import java.util.Random;

public class CycleCrossoverFavoringStrongParents
implements Crossover {
    float crossOverRate;
    Random r;
    boolean[] isPositionUsed;
    int[] P1genePosToNodeIndex;
    int[] P2genePosToNodeIndex;

    public CycleCrossoverFavoringStrongParents(float crossOverRate, Random r, int chromsomeSize) {
        this.crossOverRate = crossOverRate;
        this.r = r;
        this.isPositionUsed = new boolean[chromsomeSize];
        this.P1genePosToNodeIndex = new int[chromsomeSize];
        this.P2genePosToNodeIndex = new int[chromsomeSize];
    }

    @Override
    public void crossover(Population population) {
        assert (this.r != null) : "set random seed value before first use";
        int nbrOfCrossovers = Math.round((float)population.chromosomes.size() * this.crossOverRate);
        int nbrOfGenesPerChromsome = GeneticPlacement.nodeProxies.length;
        ArrayList<Chromosome> offsprings = new ArrayList<Chromosome>(nbrOfCrossovers);
        Chromosome[] P1 = new Chromosome[nbrOfCrossovers];
        Chromosome[] P2 = new Chromosome[nbrOfCrossovers];
        double sumOfAllFitnessValues = 0.0;
        for (Chromosome c2 : population.chromosomes) {
            sumOfAllFitnessValues += 1.0 / c2.fitness;
        }
        block1: for (int i2 = 0; i2 < nbrOfCrossovers; ++i2) {
            double canidateSelector = this.r.nextDouble() * sumOfAllFitnessValues;
            double currentFitnessSum = 0.0;
            for (Chromosome c3 : population.chromosomes) {
                if (!((currentFitnessSum += 1.0 / c3.fitness) >= canidateSelector)) continue;
                P1[i2] = c3;
                break;
            }
            canidateSelector = this.r.nextDouble() * sumOfAllFitnessValues;
            currentFitnessSum = 0.0;
            for (Chromosome c3 : population.chromosomes) {
                if (!((currentFitnessSum += 1.0 / c3.fitness) >= canidateSelector)) continue;
                if (P1[i2] == c3) {
                    int indexOfC = population.chromosomes.indexOf(c3);
                    if (indexOfC == population.chromosomes.size() - 1) {
                        P2[i2] = population.chromosomes.get(0);
                        continue;
                    }
                    P2[i2] = population.chromosomes.get(indexOfC + 1);
                    continue;
                }
                P2[i2] = c3;
                continue block1;
            }
        }
        for (int i3 = 0; i3 < nbrOfCrossovers; ++i3) {
            assert (P1[i3] != null);
            assert (P2[i3] != null);
            assert (P1[i3] != P2[i3]);
            Chromosome offspring = new Chromosome(nbrOfGenesPerChromsome);
            GenePlacementLeftRightAlignedDrop.generateGenePos2IndexMapping(P1[i3].Index2GenePositionInChromosome, this.P1genePosToNodeIndex);
            GenePlacementLeftRightAlignedDrop.generateGenePos2IndexMapping(P2[i3].Index2GenePositionInChromosome, this.P2genePosToNodeIndex);
            for (int ind = 0; ind < this.isPositionUsed.length; ++ind) {
                this.isPositionUsed[ind] = false;
            }
            for (int nbrOfPlacedNodes = 0; nbrOfPlacedNodes < this.isPositionUsed.length; ++nbrOfPlacedNodes) {
                int indexOfProxy = this.r.nextInt(this.isPositionUsed.length);
                while (this.isPositionUsed[indexOfProxy]) {
                    if (++indexOfProxy != this.isPositionUsed.length) continue;
                    indexOfProxy = 0;
                }
                do {
                    offspring.Index2GenePositionInChromosome[indexOfProxy] = P1[i3].Index2GenePositionInChromosome[indexOfProxy];
                    this.isPositionUsed[indexOfProxy] = true;
                    offspring.GeneRotation[indexOfProxy] = P1[i3].GeneRotation[indexOfProxy];
                    offspring.GeneXPadding[indexOfProxy] = P1[i3].GeneXPadding[indexOfProxy];
                    offspring.GeneYPadding[indexOfProxy] = P1[i3].GeneYPadding[indexOfProxy];
                } while (!this.isPositionUsed[indexOfProxy = this.P2genePosToNodeIndex[P1[i3].Index2GenePositionInChromosome[indexOfProxy]]]);
                Chromosome swapChromosome = P1[i3];
                P1[i3] = P2[i3];
                P2[i3] = swapChromosome;
                int[] swapIndex = this.P1genePosToNodeIndex;
                this.P1genePosToNodeIndex = this.P2genePosToNodeIndex;
                this.P2genePosToNodeIndex = swapIndex;
            }
            assert (offspring.isIndex2GenePosValid());
            offsprings.add(offspring);
        }
        for (Chromosome c4 : offsprings) {
            assert (c4.size() == GeneticPlacement.nodeProxies.length);
        }
        population.chromosomes.addAll(offsprings);
    }
}

