/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.placement.PlacementAdapter;
import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.PlacementFrameElectric;
import com.sun.electric.util.math.MutableDouble;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BottomUpPartition
extends PlacementFrameElectric {
    private static final boolean NEWCLUSTERMETHOD = true;

    @Override
    public String getAlgorithmName() {
        return "Bottom-Up-Partition";
    }

    @Override
    public void runPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace, String cellName, Job job) {
        this.doBottomUp(placementNodes, allNetworks, exportsToPlace);
        this.setFailure(true);
    }

    public Library doBottomUp(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, List<PlacementAdapter.PlacementExport> exportsToPlace) {
        PortInst pi;
        PlacementAdapter.PlacementPort app;
        PlacementFrame.PlacementNode pNode;
        NodeInst ni;
        Object lastPI;
        double girth = BottomUpPartition.getStandardCellSize(placementNodes, null);
        double minMacroArea = girth * girth * 100.0;
        HashSet<PlacementFrame.PlacementNode> macroNodes = new HashSet<PlacementFrame.PlacementNode>();
        for (PlacementFrame.PlacementNode pNode2 : placementNodes) {
            if (!(pNode2.getWidth() * pNode2.getHeight() >= minMacroArea)) continue;
            macroNodes.add(pNode2);
        }
        System.out.println("Found " + macroNodes.size() + " macro cells");
        Map<Double, List<PNPair>> allDensities = BottomUpPartition.makeClusteredPairs(placementNodes, allNetworks, macroNodes);
        System.out.println("Created cell clustering");
        int di = allDensities.size();
        double[] densities = new double[di];
        for (Double density : allDensities.keySet()) {
            densities[--di] = density;
        }
        int maxClusterSize = (int)Math.ceil(Math.sqrt(placementNodes.size()));
        HashMap<PlacementFrame.PlacementNode, FPCluster> nodeClusters = new HashMap<PlacementFrame.PlacementNode, FPCluster>();
        ArrayList<FPCluster> allClusters = new ArrayList<FPCluster>();
        for (int i2 = 0; i2 < densities.length; ++i2) {
            double curDensity = densities[i2];
            List<PNPair> pairs = allDensities.get(curDensity);
            for (PNPair pair : pairs) {
                PlacementFrame.PlacementNode pNode3 = pair.n1;
                PlacementFrame.PlacementNode oNode = pair.n2;
                FPCluster pCluster = (FPCluster)nodeClusters.get(pNode3);
                Object oCluster = (FPCluster)nodeClusters.get(oNode);
                if (pCluster == null && oCluster == null) {
                    pCluster = new FPCluster();
                    allClusters.add(pCluster);
                    pCluster.addNode(pNode3);
                    pCluster.addNode(oNode);
                    nodeClusters.put(pNode3, pCluster);
                    nodeClusters.put(oNode, pCluster);
                    continue;
                }
                if (pCluster == null && oCluster != null) {
                    ((FPCluster)oCluster).addNode(pNode3);
                    nodeClusters.put(pNode3, (FPCluster)oCluster);
                    continue;
                }
                if (pCluster != null && oCluster == null) {
                    pCluster.addNode(oNode);
                    nodeClusters.put(oNode, pCluster);
                    continue;
                }
                if (pCluster == oCluster || pCluster.getSize() + ((FPCluster)oCluster).getSize() >= maxClusterSize) continue;
                if (pCluster.getSize() < ((FPCluster)oCluster).getSize()) {
                    FPCluster swap = pCluster;
                    pCluster = oCluster;
                    oCluster = swap;
                }
                for (PlacementFrame.PlacementNode placementNode : ((FPCluster)oCluster).getMembers()) {
                    pCluster.addNode(placementNode);
                    nodeClusters.put(placementNode, pCluster);
                }
                allClusters.remove(oCluster);
            }
        }
        ArrayList<PlacementFrame.PlacementNode> unconnectedNodes = new ArrayList<PlacementFrame.PlacementNode>();
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            FPCluster cluster;
            if (macroNodes.contains(pn) || (cluster = (FPCluster)nodeClusters.get(pn)) != null) continue;
            unconnectedNodes.add(pn);
        }
        Library lib = null;
        for (int i3 = 1; i3 < 1000; ++i3) {
            String libName = "PlacementResult" + i3;
            if (Library.findLibrary(libName) != null) continue;
            lib = Library.newInst(libName, null);
            break;
        }
        HashMap<PlacementFrame.PlacementNetwork, Object> exportNames = new HashMap<PlacementFrame.PlacementNetwork, Object>();
        int exportNum = 1;
        ArrayList<Cell> clusterCells = new ArrayList<Cell>();
        System.out.println("Generating top-level cell and " + allClusters.size() + " intermediate cells");
        for (int i4 = 0; i4 <= allClusters.size(); ++i4) {
            ArrayList<PlacementFrame.PlacementNode> nodesToPlace;
            Object cellName;
            if (i4 == allClusters.size()) {
                cellName = "UNCLUSTERED{lay}";
                nodesToPlace = unconnectedNodes;
            } else {
                cellName = "CLUSTER" + (i4 + 1) + "{lay}";
                nodesToPlace = ((FPCluster)allClusters.get(i4)).getMembers();
            }
            if (nodesToPlace.size() == 0) continue;
            Cell newCell = Cell.makeInstance(this.ep, lib, (String)cellName);
            clusterCells.add(newCell);
            HashMap<PlacementFrame.PlacementNode, NodeInst> generatedNodes = new HashMap<PlacementFrame.PlacementNode, NodeInst>();
            this.placeList(nodesToPlace, newCell, generatedNodes);
            HashSet<Iterator<PlacementAdapter.PlacementExport>> usedNetworks = new HashSet<Iterator<PlacementAdapter.PlacementExport>>();
            for (PlacementFrame.PlacementNode placementNode : nodesToPlace) {
                for (PlacementFrame.PlacementPort port : placementNode.getPorts()) {
                    PlacementFrame.PlacementNetwork pNet = port.getPlacementNetwork();
                    if (pNet == null) continue;
                    usedNetworks.add((Iterator<PlacementAdapter.PlacementExport>)((Object)pNet));
                }
            }
            for (PlacementFrame.PlacementNetwork placementNetwork : usedNetworks) {
                Object exportName;
                PortInst lastPI2 = null;
                boolean exportNet = false;
                for (PlacementFrame.PlacementPort pPort : placementNetwork.getPortsOnNet()) {
                    PlacementFrame.PlacementNode pNode4 = pPort.getPlacementNode();
                    NodeInst ni2 = (NodeInst)generatedNodes.get(pNode4);
                    if (ni2 == null) {
                        exportNet = true;
                        continue;
                    }
                    PlacementAdapter.PlacementPort app2 = (PlacementAdapter.PlacementPort)pPort;
                    PortInst pi2 = ni2.findPortInstFromEquivalentProto(app2.getPortProto());
                    if (lastPI2 != null) {
                        ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, lastPI2, pi2);
                    }
                    lastPI2 = pi2;
                }
                if (!exportNet) continue;
                for (PlacementAdapter.PlacementExport pe : exportsToPlace) {
                    if (pe.getPort().getPlacementNetwork() != placementNetwork) continue;
                    exportsToPlace.remove(pe);
                    break;
                }
                if ((exportName = (String)exportNames.get(placementNetwork)) == null) {
                    exportName = "E" + exportNum;
                    ++exportNum;
                    exportNames.put(placementNetwork, exportName);
                }
                Export.newInst(newCell, lastPI2, (String)exportName, this.ep);
            }
            for (PlacementAdapter.PlacementExport placementExport : exportsToPlace) {
                PlacementAdapter.PlacementPort pp = placementExport.getPort();
                NodeInst ni3 = (NodeInst)generatedNodes.get(pp.getPlacementNode());
                if (ni3 == null) continue;
                PlacementAdapter.PlacementPort app3 = pp;
                PortInst pi3 = ni3.findPortInstFromEquivalentProto(app3.getPortProto());
                Export.newInst(newCell, pi3, placementExport.getName(), this.ep);
            }
        }
        Cell newCell = Cell.makeInstance(this.ep, lib, "ALLCLUSTERS{lay}");
        HashMap<PlacementFrame.PlacementNode, NodeInst> placedMacroCells = new HashMap<PlacementFrame.PlacementNode, NodeInst>();
        this.placeList(macroNodes, newCell, placedMacroCells);
        double gap = 5.0;
        HashMap<Cell, Object> clusterInstances = new HashMap<Cell, Object>();
        int cellsPerRow = (int)Math.sqrt(clusterCells.size());
        double d2 = 0.0;
        double yPos = 0.0;
        double maxHeight = 0.0;
        int cellNum = 0;
        for (Cell subCell : clusterCells) {
            ERectangle rect = subCell.getBounds();
            EPoint ctr = this.makeEPoint(d2 - rect.getCenterX() + subCell.getDefWidth() / 2.0, yPos - rect.getCenterY() + subCell.getDefHeight() / 2.0);
            NodeInst ni4 = NodeInst.makeInstance(subCell, this.ep, ctr, subCell.getDefWidth(), subCell.getDefHeight(), newCell);
            clusterInstances.put(subCell, ni4);
            d2 += rect.getWidth() + gap;
            if (rect.getHeight() > maxHeight) {
                maxHeight = rect.getHeight();
            }
            if (++cellNum < cellsPerRow) continue;
            cellNum = 0;
            d2 = 0.0;
            yPos += maxHeight + gap;
            maxHeight = 0.0;
        }
        for (PlacementFrame.PlacementNetwork pNet : exportNames.keySet()) {
            String exportName = (String)exportNames.get(pNet);
            lastPI = null;
            for (Cell subCell : clusterCells) {
                Export e2 = subCell.findExport(exportName);
                if (e2 == null) continue;
                ni = (NodeInst)clusterInstances.get(subCell);
                PortInst pi4 = ni.findPortInstFromEquivalentProto(e2);
                if (lastPI != null) {
                    ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, (PortInst)lastPI, pi4);
                }
                lastPI = pi4;
            }
            for (PlacementFrame.PlacementPort pPort : pNet.getPortsOnNet()) {
                pNode = pPort.getPlacementNode();
                if (!macroNodes.contains(pNode)) continue;
                ni = (NodeInst)placedMacroCells.get(pNode);
                app = (PlacementAdapter.PlacementPort)pPort;
                pi = ni.findPortInstFromEquivalentProto(app.getPortProto());
                if (lastPI != null) {
                    ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, (PortInst)lastPI, pi);
                }
                lastPI = pi;
            }
        }
        HashSet<PlacementFrame.PlacementNetwork> stillToWire = new HashSet<PlacementFrame.PlacementNetwork>();
        for (PlacementFrame.PlacementNode pNode5 : macroNodes) {
            for (PlacementFrame.PlacementPort pPort : pNode5.getPorts()) {
                PlacementFrame.PlacementNetwork pNet = pPort.getPlacementNetwork();
                if (pNet == null || exportNames.get(pNet) != null) continue;
                stillToWire.add(pNet);
            }
        }
        for (PlacementFrame.PlacementNetwork pNet : stillToWire) {
            lastPI = null;
            for (PlacementFrame.PlacementPort pPort : pNet.getPortsOnNet()) {
                pNode = pPort.getPlacementNode();
                if (!macroNodes.contains(pNode)) continue;
                ni = (NodeInst)placedMacroCells.get(pNode);
                app = (PlacementAdapter.PlacementPort)pPort;
                pi = ni.findPortInstFromEquivalentProto(app.getPortProto());
                if (lastPI != null) {
                    ArcInst.makeInstance(Generic.tech().unrouted_arc, this.ep, (PortInst)lastPI, pi);
                }
                lastPI = pi;
            }
        }
        return lib;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Double, List<PNPair>> makeClusteredPairs(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks, Set<PlacementFrame.PlacementNode> macroNodes) {
        HashMap<PlacementFrame.PlacementNode, Integer> ordering = new HashMap<PlacementFrame.PlacementNode, Integer>();
        for (int i2 = 0; i2 < placementNodes.size(); ++i2) {
            ordering.put(placementNodes.get(i2), i2);
        }
        double largestArea = 0.0;
        double smallestArea = Double.MAX_VALUE;
        for (PlacementFrame.PlacementNode pn : placementNodes) {
            double area = pn.getWidth() * pn.getHeight();
            if (area < smallestArea) {
                smallestArea = area;
            }
            if (!(area > largestArea)) continue;
            largestArea = area;
        }
        HashMap connectivityMap = new HashMap();
        HashMap<PlacementFrame.PlacementNetwork, List<SteinerTree.SteinerTreePortPair>> allConnections = new HashMap<PlacementFrame.PlacementNetwork, List<SteinerTree.SteinerTreePortPair>>();
        Job.getUserInterface().startProgressDialog("Computing steiner trees", null);
        Job.getUserInterface().setProgressValue(0);
        int totalNetworks = allNetworks.size();
        for (int i3 = 0; i3 < totalNetworks; ++i3) {
            PlacementFrame.PlacementNetwork pNet = allNetworks.get(i3);
            allConnections.put(pNet, PlacementAdapter.getOptimalConnections(pNet));
            if (i3 % 100 != 99) continue;
            Job.getUserInterface().setProgressValue(i3 * 100 / totalNetworks);
        }
        Job.getUserInterface().stopProgressDialog();
        for (PlacementFrame.PlacementNetwork pNet : allNetworks) {
            List cons = (List)allConnections.get(pNet);
            for (SteinerTree.SteinerTreePortPair con : cons) {
                void var28_29;
                MutableDouble mutableDouble;
                PlacementFrame.PlacementNode realONode;
                PlacementFrame.PlacementNode realPNode;
                PlacementFrame.PlacementPort oPort;
                PlacementFrame.PlacementNode oNode;
                PlacementFrame.PlacementPort pPort = (PlacementFrame.PlacementPort)con.getPort1();
                PlacementFrame.PlacementNode pNode = pPort.getPlacementNode();
                if (macroNodes.contains(pNode) || macroNodes.contains(oNode = (oPort = (PlacementFrame.PlacementPort)con.getPort2()).getPlacementNode()) || oNode == pNode) continue;
                Integer pNodeIndex = (Integer)ordering.get(pNode);
                Integer oNodeIndex = (Integer)ordering.get(oNode);
                if (pNodeIndex < oNodeIndex) {
                    realPNode = pNode;
                    realONode = oNode;
                } else {
                    realPNode = oNode;
                    realONode = pNode;
                }
                int totalMatches = 0;
                int partialMatches = 0;
                HashSet<PlacementFrame.PlacementNetwork> possibleNetworks = new HashSet<PlacementFrame.PlacementNetwork>();
                for (PlacementFrame.PlacementPort placementPort : realPNode.getPorts()) {
                    possibleNetworks.add(placementPort.getPlacementNetwork());
                }
                for (PlacementFrame.PlacementPort placementPort : realONode.getPorts()) {
                    possibleNetworks.add(placementPort.getPlacementNetwork());
                }
                for (PlacementFrame.PlacementNetwork placementNetwork : possibleNetworks) {
                    List cons2 = (List)allConnections.get(placementNetwork);
                    if (cons2 == null) continue;
                    for (SteinerTree.SteinerTreePortPair con2 : cons2) {
                        boolean match2;
                        PlacementFrame.PlacementPort pPort1 = (PlacementFrame.PlacementPort)con2.getPort1();
                        PlacementFrame.PlacementNode pNode1 = pPort1.getPlacementNode();
                        PlacementFrame.PlacementPort pPort2 = (PlacementFrame.PlacementPort)con2.getPort2();
                        PlacementFrame.PlacementNode pNode2 = pPort2.getPlacementNode();
                        if (pNode2 == pNode1) continue;
                        boolean match1 = pNode1 == pNode || pNode1 == oNode;
                        boolean bl = match2 = pNode2 == pNode || pNode2 == oNode;
                        if (match1 && match2) {
                            ++totalMatches;
                            continue;
                        }
                        if (!match1 && !match2) continue;
                        ++partialMatches;
                    }
                }
                HashMap<PlacementFrame.PlacementNode, MutableDouble> nodeMap = (HashMap<PlacementFrame.PlacementNode, MutableDouble>)connectivityMap.get(realPNode);
                if (nodeMap == null) {
                    nodeMap = new HashMap<PlacementFrame.PlacementNode, MutableDouble>();
                    connectivityMap.put(realPNode, nodeMap);
                }
                if ((mutableDouble = (MutableDouble)nodeMap.get(realONode)) == null) {
                    MutableDouble mutableDouble2 = new MutableDouble(0.0);
                    nodeMap.put(realONode, mutableDouble2);
                }
                double amt = 1.0 / (double)pNet.getPortsOnNet().size();
                if (partialMatches > 0) {
                    double matchWeight = (double)totalMatches / (double)partialMatches;
                    amt *= matchWeight;
                }
                var28_29.setValue(var28_29.doubleValue() + amt);
            }
        }
        TreeMap<Double, List<PNPair>> allDensities = new TreeMap<Double, List<PNPair>>();
        for (PlacementFrame.PlacementNode pNode : connectivityMap.keySet()) {
            Map nodeMap = (Map)connectivityMap.get(pNode);
            for (PlacementFrame.PlacementNode oNode : nodeMap.keySet()) {
                MutableDouble md = (MutableDouble)nodeMap.get(oNode);
                Double key = md.doubleValue();
                ArrayList<PNPair> pairs = (ArrayList<PNPair>)allDensities.get(key);
                if (pairs == null) {
                    pairs = new ArrayList<PNPair>();
                    allDensities.put(key, pairs);
                }
                pairs.add(new PNPair(pNode, oNode));
            }
        }
        for (Double d2 : allDensities.keySet()) {
            List pairs = (List)allDensities.get(d2);
            Collections.sort(pairs, new PNPairOrdering());
        }
        return allDensities;
    }

    private void placeList(Collection<PlacementFrame.PlacementNode> nodesToPlace, Cell cell, Map<PlacementFrame.PlacementNode, NodeInst> assignment) {
        double maxWid = 0.0;
        double maxHei = 0.0;
        for (PlacementFrame.PlacementNode pNode : nodesToPlace) {
            PlacementAdapter.PlacementNode apn = (PlacementAdapter.PlacementNode)pNode;
            NodeInst ni = apn.getOriginal();
            boolean flipped = false;
            if (ni.getOrient().isXMirrored() == ni.getOrient().isYMirrored()) {
                if (ni.getOrient().getAngle() == 90 || ni.getOrient().getAngle() == 2700) {
                    flipped = true;
                }
            } else if (ni.getOrient().getAngle() == 0 || ni.getOrient().getAngle() == 1800) {
                flipped = true;
            }
            if (flipped) {
                if (pNode.getWidth() > maxHei) {
                    maxHei = pNode.getWidth();
                }
                if (!(pNode.getHeight() > maxWid)) continue;
                maxWid = pNode.getHeight();
                continue;
            }
            if (pNode.getWidth() > maxWid) {
                maxWid = pNode.getWidth();
            }
            if (!(pNode.getHeight() > maxHei)) continue;
            maxHei = pNode.getHeight();
        }
        double spacing = Math.max(maxWid + 1.0, maxHei + 1.0);
        int cellsPerRow = (int)Math.sqrt(nodesToPlace.size());
        double xPos = 0.0;
        double yPos = 0.0;
        int cellNum = 0;
        for (PlacementFrame.PlacementNode pNode : nodesToPlace) {
            PlacementAdapter.PlacementNode apn = (PlacementAdapter.PlacementNode)pNode;
            NodeInst ni = apn.getOriginal();
            ERectangle rect = ni.isCellInstance() ? ((Cell)ni.getProto()).getBounds() : ni.getBounds();
            EPoint ctr = this.makeEPoint(xPos - rect.getCenterX(), yPos - rect.getCenterY());
            NodeInst newNi = NodeInst.makeInstance(ni.getProto(), this.ep, ctr, ni.getXSize(), ni.getYSize(), cell, ni.getOrient(), ni.getName());
            if (assignment != null) {
                assignment.put(pNode, newNi);
            }
            xPos += spacing;
            if (++cellNum < cellsPerRow) continue;
            cellNum = 0;
            xPos = 0.0;
            yPos += spacing;
        }
    }

    private EPoint makeEPoint(double x, double y) {
        double maxValue = Math.round(4294967.0f);
        if (x >= maxValue) {
            System.out.println("X VALUE CLIPPED FROM " + x + " TO " + maxValue);
            x = maxValue;
        }
        if (x <= -maxValue) {
            System.out.println("X VALUE CLIPPED FROM " + x + " TO " + -maxValue);
            x = -maxValue;
        }
        if (y >= maxValue) {
            System.out.println("Y VALUE CLIPPED FROM " + y + " TO " + maxValue);
            y = maxValue;
        }
        if (y <= -maxValue) {
            System.out.println("Y VALUE CLIPPED FROM " + y + " TO " + -maxValue);
            y = -maxValue;
        }
        try {
            return EPoint.fromLambda(x, y);
        }
        catch (IllegalArgumentException e2) {
            System.out.println("ERROR: bad instance location (" + x + "," + y + "): " + e2.getMessage());
            return EPoint.fromLambda(0.0, 0.0);
        }
    }

    public static class PNPair {
        PlacementFrame.PlacementNode n1;
        PlacementFrame.PlacementNode n2;

        PNPair(PlacementFrame.PlacementNode pn1, PlacementFrame.PlacementNode pn2) {
            PlacementAdapter.PlacementNode pan1 = (PlacementAdapter.PlacementNode)pn1;
            NodeInst ni1 = pan1.getOriginal();
            PlacementAdapter.PlacementNode pan2 = (PlacementAdapter.PlacementNode)pn2;
            NodeInst ni2 = pan2.getOriginal();
            if (ni1.getName().compareTo(ni2.getName()) < 0) {
                this.n1 = pn1;
                this.n2 = pn2;
            } else {
                this.n1 = pn2;
                this.n2 = pn1;
            }
        }
    }

    private static class FPCluster {
        private Set<PlacementFrame.PlacementNode> nodesInCluster = new HashSet<PlacementFrame.PlacementNode>();

        FPCluster() {
        }

        Set<PlacementFrame.PlacementNode> getMembers() {
            return this.nodesInCluster;
        }

        int getSize() {
            return this.nodesInCluster.size();
        }

        void addNode(PlacementFrame.PlacementNode pn) {
            this.nodesInCluster.add(pn);
        }
    }

    public static class PNPairOrdering
    implements Comparator<PNPair> {
        @Override
        public int compare(PNPair pnpA, PNPair pnpB) {
            PlacementAdapter.PlacementNode panA1 = (PlacementAdapter.PlacementNode)pnpA.n1;
            NodeInst niA1 = panA1.getOriginal();
            PlacementAdapter.PlacementNode panB1 = (PlacementAdapter.PlacementNode)pnpB.n1;
            NodeInst niB1 = panB1.getOriginal();
            int diff = niA1.getName().compareTo(niB1.getName());
            if (diff != 0) {
                return diff;
            }
            PlacementAdapter.PlacementNode panA2 = (PlacementAdapter.PlacementNode)pnpA.n2;
            NodeInst niA2 = panA2.getOriginal();
            PlacementAdapter.PlacementNode panB2 = (PlacementAdapter.PlacementNode)pnpB.n2;
            NodeInst niB2 = panB2.getOriginal();
            diff = niA2.getName().compareTo(niB2.getName());
            return diff;
        }
    }
}

