/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.utils.concurrent;

import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.IStructure;

public class CircularArray
extends IStructure<Runnable> {
    private int logCapacity;
    private Runnable[] currentItems;

    public CircularArray(int myLogCapacity) {
        this.logCapacity = myLogCapacity;
        this.currentItems = new Runnable[1 << this.logCapacity];
    }

    public void add(int i2, Runnable item) {
        this.currentItems[i2 % this.getCapacity()] = item;
    }

    @Override
    @Deprecated
    public void add(Runnable item) {
        this.add(0, item);
    }

    @Override
    public Runnable get() throws EmptyException {
        return this.get(0);
    }

    public Runnable get(int i2) throws EmptyException {
        return this.currentItems[i2 % this.getCapacity()];
    }

    public int getCapacity() {
        return 1 << this.logCapacity;
    }

    @Override
    @Deprecated
    public boolean isEmpty() {
        return false;
    }

    public CircularArray resize(int bottom, int top) {
        CircularArray newTasks = new CircularArray(this.logCapacity + 1);
        for (int i2 = top; i2 < bottom; ++i2) {
            try {
                newTasks.add(i2, this.get(i2));
                continue;
            }
            catch (EmptyException e2) {
                e2.printStackTrace();
            }
        }
        return newTasks;
    }
}

