/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingPattern;
import com.sun.electric.tool.placement.forceDirected2.metrics.AbstractMetric;
import java.math.BigDecimal;
import java.util.List;

public class OverallAreaMetric
extends AbstractMetric {
    private static final String metricName = "Overall Area Metric";
    private CheckboardingPattern checkPattern;

    public OverallAreaMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, CheckboardingPattern pattern) {
        super(nodesToPlace, allNetworks);
        this.checkPattern = pattern;
    }

    @Override
    public Double compute() {
        return this.computeAsBigDecimal().doubleValue();
    }

    public BigDecimal computeAsBigDecimal() {
        if (this.checkPattern == null) {
            return new BigDecimal(-1.0);
        }
        BigDecimal minX = null;
        BigDecimal maxX = null;
        BigDecimal minY = new BigDecimal(-1);
        BigDecimal maxY = new BigDecimal(-1);
        for (int i2 = 0; i2 < this.checkPattern.getAll().length; ++i2) {
            for (int j2 = 0; j2 < this.checkPattern.getAll()[i2].length; ++j2) {
                CheckboardingField field = this.checkPattern.getField(j2, i2);
                if (field.getNode() == null) continue;
                if (minX == null) {
                    minX = new BigDecimal(field.getLocation().getX() - field.getNode().getWidth() / 2.0);
                    maxX = new BigDecimal(field.getLocation().getX() - field.getNode().getWidth() / 2.0);
                }
                if (minY == null) {
                    minY = new BigDecimal(field.getLocation().getY() - field.getNode().getHeight() / 2.0);
                    maxY = new BigDecimal(field.getLocation().getY() - field.getNode().getHeight() / 2.0);
                }
                BigDecimal tmpX = new BigDecimal(field.getLocation().getX() + field.getNode().getWidth() / 2.0);
                maxX = maxX.max(tmpX);
                BigDecimal tmpY = new BigDecimal(field.getLocation().getY() + field.getNode().getHeight() / 2.0);
                maxY = maxY.max(tmpY);
            }
        }
        BigDecimal x = maxX.subtract(minX);
        BigDecimal y = maxY.subtract(minY);
        return x.multiply(y);
    }

    public CheckboardingPattern getCheckPattern() {
        return this.checkPattern;
    }

    @Override
    public String getMetricName() {
        return metricName;
    }

    public void setCheckPattern(CheckboardingPattern checkPattern) {
        this.checkPattern = checkPattern;
    }
}

