/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.forceDirected2.forceDirected.staged;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.forceDirected2.PlacementForceDirectedStaged;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.OverlapDirection;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.staged.PlacementDTO;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.CheckboardingField;
import com.sun.electric.tool.placement.forceDirected2.forceDirected.util.history.OverlapHistorySync;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.EmptyException;
import com.sun.electric.tool.placement.forceDirected2.utils.concurrent.StageWorker;

public class OverlapWorker
extends StageWorker {
    private double threshold;
    private int index;

    public OverlapWorker(double threshold, int index) {
        this.threshold = threshold;
        this.index = index;
    }

    private void exchangeAndPlace(CheckboardingField field1, CheckboardingField field2, CheckboardingField[][] fields) {
        OverlapHistorySync history = OverlapHistorySync.getInstance();
        PlacementFrame.PlacementNode node1 = field1.getNode();
        PlacementFrame.PlacementNode node2 = field2.getNode();
        if (field1 != field2 && history.isMovementInHistory(node1, node2)) {
            this.exchangeAndPlace(field1, field1, fields);
            this.exchangeAndPlace(field2, field2, fields);
        } else {
            field2.placeCentralized(node1);
            field1.placeCentralized(node2);
            history.saveHistory(node1, node2);
            PlacementForceDirectedStaged.incMovementCounter();
        }
    }

    private void handleOverlappingInX(CheckboardingField[][] fieldPart, int i2, int j2) {
        double ovX = fieldPart[i2][j2].getOverlappingFractionInX();
        double ovY = fieldPart[i2][j2].getOverlappingFractionInY();
        OverlapDirection dir2 = fieldPart[i2][j2].getOverlapDirection();
        if (ovX > this.threshold) {
            int newX;
            CheckboardingField newField = null;
            if (OverlapDirection.isEast(dir2)) {
                int newX2 = j2 + 1;
                if (newX2 < fieldPart[i2].length) {
                    newField = fieldPart[i2][newX2];
                }
            } else if (OverlapDirection.isWest(dir2) && (newX = j2 - 1) >= 0) {
                newField = fieldPart[i2][newX];
            }
            if (newField == null) {
                newField = fieldPart[i2][j2];
            }
            this.exchangeAndPlace(fieldPart[i2][j2], newField, fieldPart);
        } else if (ovY > this.threshold) {
            this.handleOverlappingInY(fieldPart, i2, j2);
        }
    }

    private void handleOverlappingInY(CheckboardingField[][] fieldPart, int i2, int j2) {
        double ovX = fieldPart[i2][j2].getOverlappingFractionInX();
        double ovY = fieldPart[i2][j2].getOverlappingFractionInY();
        OverlapDirection dir2 = fieldPart[i2][j2].getOverlapDirection();
        if (ovY > this.threshold) {
            int newY;
            CheckboardingField newField = null;
            if (OverlapDirection.isNorth(dir2)) {
                int newY2 = i2 + 1;
                if (newY2 < fieldPart.length) {
                    newField = fieldPart[newY2][j2];
                }
            } else if (OverlapDirection.isSouth(dir2) && (newY = j2 - 1) >= 0) {
                newField = fieldPart[newY][j2];
            }
            if (newField == null) {
                newField = fieldPart[i2][j2];
            }
            this.exchangeAndPlace(fieldPart[i2][j2], newField, fieldPart);
        } else if (ovX > this.threshold) {
            this.handleOverlappingInX(fieldPart, i2, j2);
        }
    }

    @Override
    public void run() {
        while (!this.abort.booleanValue()) {
            try {
                PlacementDTO data = this.stage.getInput(this).get();
                CheckboardingField[][] fieldPart = data.getFieldPart();
                for (int i2 = 0; i2 < fieldPart.length; ++i2) {
                    for (int j2 = 0; j2 < fieldPart[i2].length; ++j2) {
                        if (fieldPart[i2][j2] == null || !fieldPart[i2][j2].isOverlappingBiggerThreshold(this.threshold)) continue;
                        int proc = fieldPart[i2][j2].getCoordX() + fieldPart[i2][j2].getCoordY();
                        if (proc % 2 == 0) {
                            this.handleOverlappingInX(fieldPart, i2, j2);
                            continue;
                        }
                        this.handleOverlappingInY(fieldPart, i2, j2);
                    }
                }
                this.stage.sendToNextStage(data);
            }
            catch (EmptyException e2) {
                Thread.yield();
            }
        }
    }
}

