/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.TreeMap;

public class StratCount
extends Strategy {
    private static final int INDENT_WIDTH = 4;
    private static final int LABEL_WIDTH = 30;
    private static final int FIELD_WIDTH = 15;
    private int maxDepth;
    private NetObjStats numMismatchedNetObjs = new NetObjStats(0);
    private NetObjStats numMatchedNetObjs = new NetObjStats(0);
    private NetObjStats numActiveNetObjs = new NetObjStats(0);
    private NetObjStats numMismatchedLeafRecs = new NetObjStats(0);
    private NetObjStats numMatchedLeafRecs = new NetObjStats(0);
    private NetObjStats numActiveLeafRecs = new NetObjStats(0);
    private NetObject.Type netObjType;
    private SizeHistogram sizeHistogram = new SizeHistogram();

    private StratCount(NccGlobals globals) {
        super(globals);
    }

    private static String spaces(int num) {
        StringBuffer b2 = new StringBuffer();
        for (int i2 = 0; i2 < num; ++i2) {
            b2.append(" ");
        }
        return b2.toString();
    }

    private static String rightJustifyInField(String s, int fieldWidth) {
        return StratCount.spaces(fieldWidth - s.length()) + s;
    }

    private static String leftJustifyInField(String s, int fieldWidth) {
        return s + StratCount.spaces(fieldWidth - s.length());
    }

    private void printLine(String label, NetObjStats stats) {
        this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + stats.toString());
    }

    private void printLine(String label, int data) {
        this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField(label, 30) + StratCount.rightJustifyInField(String.valueOf(data), 15));
    }

    private void preamble(EquivRecord j2) {
        this.startTime("StratCount", "statistics for entire equivalence class tree");
    }

    private Counts summary() {
        this.globals.status2(StratCount.spaces(34) + StratCount.rightJustifyInField("Parts", 15) + StratCount.rightJustifyInField("Wires", 15) + StratCount.rightJustifyInField("Ports", 15));
        this.printLine("# mismatched equiv classes", this.numMismatchedLeafRecs);
        this.printLine("# matched equiv classes", this.numMatchedLeafRecs);
        this.printLine("# active equiv classes", this.numActiveLeafRecs);
        this.printLine("# mismatched net objects", this.numMismatchedNetObjs);
        this.printLine("# matched net objects", this.numMatchedNetObjs);
        this.printLine("# active net objects", this.numActiveNetObjs);
        this.globals.status2("");
        this.sizeHistogram.print();
        this.globals.status2("");
        this.printLine("max tree depth", this.maxDepth);
        this.elapsedTime();
        return new Counts(this.numMatchedLeafRecs.get(NetObject.Type.PART), this.numMatchedLeafRecs.get(NetObject.Type.WIRE), this.numMismatchedLeafRecs.get(NetObject.Type.PART), this.numMismatchedLeafRecs.get(NetObject.Type.WIRE), this.numActiveLeafRecs.get(NetObject.Type.PART), this.numActiveLeafRecs.get(NetObject.Type.WIRE));
    }

    @Override
    public LeafList doFor(EquivRecord j2) {
        if (j2.isLeaf()) {
            this.doEquivRec(j2);
        }
        return super.doFor(j2);
    }

    private void doEquivRec(EquivRecord er) {
        int erSize = er.maxSize();
        this.netObjType = er.getNetObjType();
        int numNetObjs = er.numNetObjs();
        if (er.isMismatched()) {
            this.numMismatchedLeafRecs.incr(this.netObjType, 1);
            this.numMismatchedNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        } else if (er.isMatched()) {
            this.numMatchedLeafRecs.incr(this.netObjType, 1);
            this.numMatchedNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        } else {
            this.numActiveLeafRecs.incr(this.netObjType, 1);
            this.numActiveNetObjs.incr(this.netObjType, numNetObjs);
            this.sizeHistogram.incr(this.netObjType, erSize);
        }
    }

    @Override
    public Integer doFor(NetObject n2) {
        this.error(n2.getNetObjType() != this.netObjType, "mixed type leaf record");
        this.maxDepth = Math.max(this.maxDepth, this.getDepth());
        if (n2 instanceof Wire) {
            this.doFor((Wire)n2);
        } else if (n2 instanceof Part) {
            this.doFor((Part)n2);
        } else {
            this.error(!(n2 instanceof Port), "expecting Port");
        }
        return CODE_NO_CHANGE;
    }

    private void doFor(Wire w) {
    }

    private void doFor(Part p) {
        p.numDistinctWires();
    }

    public static Counts doYourJob(NccGlobals globals) {
        EquivRecord root = globals.getRoot();
        StratCount jsc = new StratCount(globals);
        jsc.preamble(root);
        jsc.doFor(root);
        return jsc.summary();
    }

    private static class NetObjStats {
        private static final int NUM_TYPES = 3;
        private int[] data = new int[3];

        NetObjStats(int initialVal) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.data[i2] = initialVal;
            }
        }

        public void incr(NetObject.Type type, int delta) {
            int n2 = type.ordinal();
            this.data[n2] = this.data[n2] + delta;
        }

        public int get(NetObject.Type type) {
            return this.data[type.ordinal()];
        }

        public String toString() {
            Object out = "";
            for (int i2 = 0; i2 < 3; ++i2) {
                String v = String.valueOf(this.data[i2]);
                out = (String)out + StratCount.rightJustifyInField(v, 15);
            }
            return out;
        }
    }

    private class SizeHistogram {
        TreeMap<Integer, NetObjStats> sizeToStats = new TreeMap();

        private SizeHistogram() {
        }

        void incr(NetObject.Type type, int size) {
            Integer sz = size;
            NetObjStats stats = this.sizeToStats.get(sz);
            if (stats == null) {
                stats = new NetObjStats(0);
                this.sizeToStats.put(sz, stats);
            }
            stats.incr(type, 1);
        }

        void print() {
            StratCount.this.globals.status2(StratCount.spaces(4) + StratCount.leftJustifyInField("LeafRec size", 30) + StratCount.rightJustifyInField("#Part_Recs", 15) + StratCount.rightJustifyInField("#Wire_Recs", 15) + StratCount.rightJustifyInField("#Port_Recs", 15));
            for (Integer key : this.sizeToStats.keySet()) {
                NetObjStats stats = this.sizeToStats.get(key);
                StratCount.this.printLine(StratCount.rightJustifyInField(key.toString(), 7), stats);
            }
        }
    }

    public static class Counts {
        public final int numMatchedPartEquivRecs;
        public final int numMatchedWireEquivRecs;
        public final int numMismatchedPartEquivRecs;
        public final int numMismatchedWireEquivRecs;
        public final int numActivePartEquivRecs;
        public final int numActiveWireEquivRecs;

        public Counts(int matchPartER, int matchWireER, int mismatchPartER, int mismatchWireER, int activePartER, int activeWireER) {
            this.numMatchedPartEquivRecs = matchPartER;
            this.numMatchedWireEquivRecs = matchWireER;
            this.numMismatchedPartEquivRecs = mismatchPartER;
            this.numMismatchedWireEquivRecs = mismatchWireER;
            this.numActivePartEquivRecs = activePartER;
            this.numActiveWireEquivRecs = activeWireER;
        }

        public int numNotMatchedPartEquivRecs() {
            return this.numMismatchedPartEquivRecs + this.numActivePartEquivRecs;
        }

        public int numNotMatchedWireEquivRecs() {
            return this.numMismatchedWireEquivRecs + this.numActiveWireEquivRecs;
        }
    }
}

