/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Subcircuit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SubcircuitInfo {
    private final ReferenceInfo shared;
    private final Map<String, Integer> exportNameToPortIndex;

    private void processReferencePorts(String[] portNames, Map<String, Integer> exportNameToPortIndex, Port[] refPorts) {
        for (int i2 = 0; i2 < refPorts.length; ++i2) {
            Integer portIndex = i2;
            Port port = refPorts[i2];
            Iterator<String> it = port.getExportNames();
            while (it.hasNext()) {
                String exportName = it.next();
                if (portNames[i2] == null) {
                    portNames[i2] = exportName;
                }
                exportNameToPortIndex.put(exportName, portIndex);
            }
            Job.error(portNames[i2] == null, "Port with no name?");
        }
    }

    public SubcircuitInfo(String name, int ID2, Port[] refPorts) {
        String[] portNames = new String[refPorts.length];
        this.exportNameToPortIndex = new HashMap<String, Integer>();
        this.processReferencePorts(portNames, this.exportNameToPortIndex, refPorts);
        this.shared = new ReferenceInfo(name, ID2, portNames);
    }

    public SubcircuitInfo(SubcircuitInfo referenceInfo, Map<String, Integer> exportNameToPortIndex) {
        this.shared = referenceInfo.shared;
        this.exportNameToPortIndex = exportNameToPortIndex;
    }

    public int getID() {
        return this.shared.ID;
    }

    public String getName() {
        return this.shared.name;
    }

    public int numPorts() {
        return this.shared.portNames.length;
    }

    public String getPortName(int i2) {
        return this.shared.portNames[i2];
    }

    public int getPortIndex(String exportName) {
        Integer I = this.exportNameToPortIndex.get(exportName);
        return I == null ? -1 : I;
    }

    public int[] getPortCoeffs() {
        return this.shared.portCoeffs;
    }

    public PinType[] getPinTypes() {
        return this.shared.pinTypes;
    }

    private static class ReferenceInfo {
        final String name;
        final int ID;
        final String[] portNames;
        final int[] portCoeffs;
        final PinType[] pinTypes;

        private int[] initPortCoeffs() {
            int i2;
            int[] coeffs = new int[this.portNames.length];
            int nameHash = 0;
            for (i2 = 0; i2 < this.name.length(); ++i2) {
                nameHash = (nameHash << 1) + this.name.charAt(i2);
            }
            nameHash %= 257;
            nameHash = Math.abs(nameHash);
            for (i2 = 0; i2 < coeffs.length; ++i2) {
                coeffs[i2] = Primes.get(nameHash + i2);
            }
            return coeffs;
        }

        ReferenceInfo(String name, int ID2, String[] portNames) {
            Job.error(name == null, "No name?");
            this.name = name;
            this.ID = ID2;
            this.portNames = portNames;
            this.portCoeffs = this.initPortCoeffs();
            this.pinTypes = new PinType[portNames.length];
            for (int i2 = 0; i2 < this.pinTypes.length; ++i2) {
                String pinDesc = name + " " + portNames[i2];
                this.pinTypes[i2] = new Subcircuit.SubcircuitPinType(0, i2, pinDesc);
            }
        }
    }
}

