/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.result.EquivRecReport;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.List;

public class LocalPartitionResult {
    private NccGlobals globals;
    private List<EquivRecord> saveBadPartRecs = new ArrayList<EquivRecord>();
    private List<EquivRecord> saveBadWireRecs = new ArrayList<EquivRecord>();
    private List<EquivRecReport> badPartReps;
    private List<EquivRecReport> badWireReps;

    private void prln(String s) {
        System.out.println(s);
    }

    private void printCircuitContents(List<NetObjReport> notMatched, List<NetObjReport> matched, String cktName, String t) {
        int numNetObjs = notMatched.size() + matched.size();
        this.prln("      " + cktName + " has " + numNetObjs + " of these " + t + ":");
        int maxPrint = this.globals.getOptions().maxEquivRecMembersToPrint;
        if (numNetObjs > maxPrint) {
            this.prln("        Too many " + t + "! I'll only print the first " + maxPrint);
        }
        int numPrint = 0;
        for (NetObjReport o2 : notMatched) {
            if (numPrint > maxPrint) break;
            this.prln("      * " + o2.fullDescription());
            ++numPrint;
        }
        for (NetObjReport o2 : matched) {
            if (numPrint > maxPrint) break;
            this.prln("        " + o2.fullDescription());
            ++numPrint;
        }
    }

    private void printBadRecord(EquivRecReport r) {
        String t = r.hasParts() ? "Parts" : "Wires";
        this.prln("    The " + t + " in this equivalence class share the following characteristics:");
        List<String> reasons = r.getReasons();
        for (String s : reasons) {
            this.prln("      " + s);
        }
        List<List<NetObjReport>> matched = r.getMatchedNetObjs();
        List<List<NetObjReport>> notMatched = r.getNotMatchedNetObjs();
        for (int cktNdx = 0; cktNdx < matched.size(); ++cktNdx) {
            String cktName = this.globals.getRootCellNames()[cktNdx];
            this.printCircuitContents(notMatched.get(cktNdx), matched.get(cktNdx), cktName, t);
        }
    }

    private void printBadRecords(List<EquivRecReport> badRecs) {
        for (EquivRecReport r : badRecs) {
            this.printBadRecord(r);
        }
    }

    private void createReports() {
        if (this.badPartReps != null) {
            return;
        }
        this.badPartReps = new ArrayList<EquivRecReport>();
        for (EquivRecord er : this.saveBadPartRecs) {
            this.badPartReps.add(new EquivRecReport(er, false));
        }
        this.badWireReps = new ArrayList<EquivRecReport>();
        for (EquivRecord er : this.saveBadWireRecs) {
            this.badWireReps.add(new EquivRecReport(er, false));
        }
    }

    public LocalPartitionResult(List<EquivRecord> notMatchedParts, List<EquivRecord> notMatchedWires, NccGlobals globals) {
        this.globals = globals;
        for (EquivRecord er : notMatchedParts) {
            if (er.isBalanced()) continue;
            this.saveBadPartRecs.add(er);
        }
        for (EquivRecord er : notMatchedWires) {
            if (er.isBalanced()) continue;
            this.saveBadWireRecs.add(er);
        }
    }

    public boolean matches() {
        return this.saveBadPartRecs.size() == 0 && this.saveBadWireRecs.size() == 0;
    }

    public List<EquivRecReport> getPartRecReports() {
        this.createReports();
        return this.badPartReps;
    }

    public List<EquivRecReport> getWireRecReports() {
        this.createReports();
        return this.badWireReps;
    }

    public void printErrorReport() {
        if (!this.matches()) {
            this.prln("\n  Mismatches found during local partitioning:\n");
        }
        this.createReports();
        this.printBadRecords(this.badPartReps);
        this.printBadRecords(this.badWireReps);
    }
}

