/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.Map;

public class Inductor
extends Part {
    private static final InductorPinTypeCache TYPE_TO_PINTYPE = new InductorPinTypeCache();
    private static final int[] PIN_COEFFS = new int[]{Primes.get(1), Primes.get(1)};
    private final double length;

    public Inductor(PrimitiveNode.Function type, NccNameProxy.PartNameProxy name, VarContext cont, double length, Wire w1, Wire w2) {
        super(name, cont, type, new Wire[]{w1, w2});
        this.length = length;
    }

    @Override
    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    @Override
    public String valueDescription() {
        String sz = "IND=" + this.length;
        return sz;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        int hc = this.pins[0].hashCode() + this.pins[1].hashCode() + this.getClass().hashCode();
        return hc;
    }

    @Override
    public double getLength() {
        return this.length;
    }

    public void connect(Wire ss, Wire ee) {
        this.pins[0] = ss;
        this.pins[1] = ee;
        ss.add(this);
        ee.add(this);
    }

    @Override
    public boolean parallelMerge(Part p, NccOptions nccOpt) {
        return false;
    }

    @Override
    public int typeCode() {
        return this.type().ordinal();
    }

    @Override
    public PinType getPinTypeOfNthPin(int n2) {
        return TYPE_TO_PINTYPE.get(this.type());
    }

    @Override
    public String typeString() {
        return this.type().getShortName();
    }

    @Override
    public String connectionDescription(int n2) {
        String s = this.pins[0].getName();
        String e2 = this.pins[1].getName();
        return "S= " + s + " E= " + e2;
    }

    @Override
    public String connectionDescription(Wire w) {
        Object s = "";
        for (int i2 = 0; i2 < this.pins.length; ++i2) {
            if (this.pins[i2] != w) continue;
            if (((String)s).length() != 0) {
                s = (String)s + ",";
            }
            s = (String)s + (i2 == 0 ? "S" : "E");
        }
        return s;
    }

    private static class InductorPinTypeCache {
        private final Map<PrimitiveNode.Function, InductorPinType> typeToPinType = new HashMap<PrimitiveNode.Function, InductorPinType>();

        private InductorPinTypeCache() {
        }

        synchronized InductorPinType get(PrimitiveNode.Function f2) {
            InductorPinType t = this.typeToPinType.get((Object)f2);
            if (t == null) {
                t = new InductorPinType(f2);
                this.typeToPinType.put(f2, t);
            }
            return t;
        }
    }

    private static class InductorPinType
    implements PinType {
        private PrimitiveNode.Function type;

        public InductorPinType(PrimitiveNode.Function t) {
            this.type = t;
        }

        @Override
        public String description() {
            return this.type.getShortName();
        }
    }
}

